// Copyright 2015-2026 The Khronos Group Inc.
//
// SPDX-License-Identifier: Apache-2.0 OR MIT
//

// This header is generated from the Khronos Vulkan XML API Registry.

#ifndef VULKAN_HANDLES_HPP
#define VULKAN_HANDLES_HPP

// include-what-you-use: make sure, vulkan.hpp is used by code-completers
// IWYU pragma: private, include "vulkan/vulkan.hpp"

VULKAN_HPP_EXPORT namespace VULKAN_HPP_NAMESPACE
{
  //===================================
  //=== STRUCT forward declarations ===
  //===================================

  //=== VK_VERSION_1_0 ===
  struct Extent2D;
  struct Extent3D;
  struct Offset2D;
  struct Offset3D;
  struct Rect2D;
  struct BaseInStructure;
  struct BaseOutStructure;
  struct AllocationCallbacks;
  struct ApplicationInfo;
  struct FormatProperties;
  struct ImageFormatProperties;
  struct InstanceCreateInfo;
  struct MemoryHeap;
  struct MemoryType;
  struct PhysicalDeviceFeatures;
  struct PhysicalDeviceLimits;
  struct PhysicalDeviceMemoryProperties;
  struct PhysicalDeviceSparseProperties;
  struct PhysicalDeviceProperties;
  struct QueueFamilyProperties;
  struct DeviceQueueCreateInfo;
  struct DeviceCreateInfo;
  struct ExtensionProperties;
  struct LayerProperties;
  struct SubmitInfo;
  struct MappedMemoryRange;
  struct MemoryAllocateInfo;
  struct MemoryRequirements;
  struct ImageSubresource;
  struct SparseImageFormatProperties;
  struct SparseImageMemoryBind;
  struct SparseImageMemoryBindInfo;
  struct SparseImageMemoryRequirements;
  struct SparseMemoryBind;
  struct SparseBufferMemoryBindInfo;
  struct SparseImageOpaqueMemoryBindInfo;
  struct BindSparseInfo;
  struct FenceCreateInfo;
  struct SemaphoreCreateInfo;
  struct QueryPoolCreateInfo;
  struct BufferCreateInfo;
  struct ImageCreateInfo;
  struct SubresourceLayout;
  struct ComponentMapping;
  struct ImageSubresourceRange;
  struct ImageViewCreateInfo;
  struct CommandPoolCreateInfo;
  struct CommandBufferAllocateInfo;
  struct CommandBufferInheritanceInfo;
  struct CommandBufferBeginInfo;
  struct BufferCopy;
  struct ImageSubresourceLayers;
  struct BufferImageCopy;
  struct ImageCopy;
  struct BufferMemoryBarrier;
  struct ImageMemoryBarrier;
  struct MemoryBarrier;
  struct DispatchIndirectCommand;
  struct PipelineCacheHeaderVersionOne;
  struct EventCreateInfo;
  struct BufferViewCreateInfo;
  struct ShaderModuleCreateInfo;
  struct PipelineCacheCreateInfo;
  struct SpecializationMapEntry;
  struct SpecializationInfo;
  struct PipelineShaderStageCreateInfo;
  struct ComputePipelineCreateInfo;
  struct PushConstantRange;
  struct PipelineLayoutCreateInfo;
  struct SamplerCreateInfo;
  struct CopyDescriptorSet;
  struct DescriptorBufferInfo;
  struct DescriptorImageInfo;
  struct DescriptorPoolSize;
  struct DescriptorPoolCreateInfo;
  struct DescriptorSetAllocateInfo;
  struct DescriptorSetLayoutBinding;
  struct DescriptorSetLayoutCreateInfo;
  struct WriteDescriptorSet;
  union ClearColorValue;
  struct DrawIndexedIndirectCommand;
  struct DrawIndirectCommand;
  struct StencilOpState;
  struct VertexInputAttributeDescription;
  struct VertexInputBindingDescription;
  struct Viewport;
  struct PipelineColorBlendAttachmentState;
  struct PipelineColorBlendStateCreateInfo;
  struct PipelineDepthStencilStateCreateInfo;
  struct PipelineDynamicStateCreateInfo;
  struct PipelineInputAssemblyStateCreateInfo;
  struct PipelineMultisampleStateCreateInfo;
  struct PipelineRasterizationStateCreateInfo;
  struct PipelineTessellationStateCreateInfo;
  struct PipelineVertexInputStateCreateInfo;
  struct PipelineViewportStateCreateInfo;
  struct GraphicsPipelineCreateInfo;
  struct AttachmentDescription;
  struct AttachmentReference;
  struct FramebufferCreateInfo;
  struct SubpassDependency;
  struct SubpassDescription;
  struct RenderPassCreateInfo;
  struct ClearDepthStencilValue;
  struct ClearRect;
  union ClearValue;
  struct ClearAttachment;
  struct ImageBlit;
  struct ImageResolve;
  struct RenderPassBeginInfo;

  //=== VK_VERSION_1_1 ===
  struct BindBufferMemoryInfo;
  using BindBufferMemoryInfoKHR = BindBufferMemoryInfo;
  struct BindImageMemoryInfo;
  using BindImageMemoryInfoKHR = BindImageMemoryInfo;
  struct MemoryDedicatedRequirements;
  using MemoryDedicatedRequirementsKHR = MemoryDedicatedRequirements;
  struct MemoryDedicatedAllocateInfo;
  using MemoryDedicatedAllocateInfoKHR = MemoryDedicatedAllocateInfo;
  struct MemoryAllocateFlagsInfo;
  using MemoryAllocateFlagsInfoKHR = MemoryAllocateFlagsInfo;
  struct DeviceGroupCommandBufferBeginInfo;
  using DeviceGroupCommandBufferBeginInfoKHR = DeviceGroupCommandBufferBeginInfo;
  struct DeviceGroupSubmitInfo;
  using DeviceGroupSubmitInfoKHR = DeviceGroupSubmitInfo;
  struct DeviceGroupBindSparseInfo;
  using DeviceGroupBindSparseInfoKHR = DeviceGroupBindSparseInfo;
  struct BindBufferMemoryDeviceGroupInfo;
  using BindBufferMemoryDeviceGroupInfoKHR = BindBufferMemoryDeviceGroupInfo;
  struct BindImageMemoryDeviceGroupInfo;
  using BindImageMemoryDeviceGroupInfoKHR = BindImageMemoryDeviceGroupInfo;
  struct PhysicalDeviceGroupProperties;
  using PhysicalDeviceGroupPropertiesKHR = PhysicalDeviceGroupProperties;
  struct DeviceGroupDeviceCreateInfo;
  using DeviceGroupDeviceCreateInfoKHR = DeviceGroupDeviceCreateInfo;
  struct BufferMemoryRequirementsInfo2;
  using BufferMemoryRequirementsInfo2KHR = BufferMemoryRequirementsInfo2;
  struct ImageMemoryRequirementsInfo2;
  using ImageMemoryRequirementsInfo2KHR = ImageMemoryRequirementsInfo2;
  struct ImageSparseMemoryRequirementsInfo2;
  using ImageSparseMemoryRequirementsInfo2KHR = ImageSparseMemoryRequirementsInfo2;
  struct MemoryRequirements2;
  using MemoryRequirements2KHR = MemoryRequirements2;
  struct SparseImageMemoryRequirements2;
  using SparseImageMemoryRequirements2KHR = SparseImageMemoryRequirements2;
  struct PhysicalDeviceFeatures2;
  using PhysicalDeviceFeatures2KHR = PhysicalDeviceFeatures2;
  struct PhysicalDeviceProperties2;
  using PhysicalDeviceProperties2KHR = PhysicalDeviceProperties2;
  struct FormatProperties2;
  using FormatProperties2KHR = FormatProperties2;
  struct ImageFormatProperties2;
  using ImageFormatProperties2KHR = ImageFormatProperties2;
  struct PhysicalDeviceImageFormatInfo2;
  using PhysicalDeviceImageFormatInfo2KHR = PhysicalDeviceImageFormatInfo2;
  struct QueueFamilyProperties2;
  using QueueFamilyProperties2KHR = QueueFamilyProperties2;
  struct PhysicalDeviceMemoryProperties2;
  using PhysicalDeviceMemoryProperties2KHR = PhysicalDeviceMemoryProperties2;
  struct SparseImageFormatProperties2;
  using SparseImageFormatProperties2KHR = SparseImageFormatProperties2;
  struct PhysicalDeviceSparseImageFormatInfo2;
  using PhysicalDeviceSparseImageFormatInfo2KHR = PhysicalDeviceSparseImageFormatInfo2;
  struct ImageViewUsageCreateInfo;
  using ImageViewUsageCreateInfoKHR = ImageViewUsageCreateInfo;
  struct PhysicalDeviceProtectedMemoryFeatures;
  struct PhysicalDeviceProtectedMemoryProperties;
  struct DeviceQueueInfo2;
  struct ProtectedSubmitInfo;
  struct BindImagePlaneMemoryInfo;
  using BindImagePlaneMemoryInfoKHR = BindImagePlaneMemoryInfo;
  struct ImagePlaneMemoryRequirementsInfo;
  using ImagePlaneMemoryRequirementsInfoKHR = ImagePlaneMemoryRequirementsInfo;
  struct ExternalMemoryProperties;
  using ExternalMemoryPropertiesKHR = ExternalMemoryProperties;
  struct PhysicalDeviceExternalImageFormatInfo;
  using PhysicalDeviceExternalImageFormatInfoKHR = PhysicalDeviceExternalImageFormatInfo;
  struct ExternalImageFormatProperties;
  using ExternalImageFormatPropertiesKHR = ExternalImageFormatProperties;
  struct PhysicalDeviceExternalBufferInfo;
  using PhysicalDeviceExternalBufferInfoKHR = PhysicalDeviceExternalBufferInfo;
  struct ExternalBufferProperties;
  using ExternalBufferPropertiesKHR = ExternalBufferProperties;
  struct PhysicalDeviceIDProperties;
  using PhysicalDeviceIDPropertiesKHR = PhysicalDeviceIDProperties;
  struct ExternalMemoryImageCreateInfo;
  using ExternalMemoryImageCreateInfoKHR = ExternalMemoryImageCreateInfo;
  struct ExternalMemoryBufferCreateInfo;
  using ExternalMemoryBufferCreateInfoKHR = ExternalMemoryBufferCreateInfo;
  struct ExportMemoryAllocateInfo;
  using ExportMemoryAllocateInfoKHR = ExportMemoryAllocateInfo;
  struct PhysicalDeviceExternalFenceInfo;
  using PhysicalDeviceExternalFenceInfoKHR = PhysicalDeviceExternalFenceInfo;
  struct ExternalFenceProperties;
  using ExternalFencePropertiesKHR = ExternalFenceProperties;
  struct ExportFenceCreateInfo;
  using ExportFenceCreateInfoKHR = ExportFenceCreateInfo;
  struct ExportSemaphoreCreateInfo;
  using ExportSemaphoreCreateInfoKHR = ExportSemaphoreCreateInfo;
  struct PhysicalDeviceExternalSemaphoreInfo;
  using PhysicalDeviceExternalSemaphoreInfoKHR = PhysicalDeviceExternalSemaphoreInfo;
  struct ExternalSemaphoreProperties;
  using ExternalSemaphorePropertiesKHR = ExternalSemaphoreProperties;
  struct PhysicalDeviceSubgroupProperties;
  struct PhysicalDevice16BitStorageFeatures;
  using PhysicalDevice16BitStorageFeaturesKHR = PhysicalDevice16BitStorageFeatures;
  struct PhysicalDeviceVariablePointersFeatures;
  using PhysicalDeviceVariablePointerFeatures     = PhysicalDeviceVariablePointersFeatures;
  using PhysicalDeviceVariablePointerFeaturesKHR  = PhysicalDeviceVariablePointersFeatures;
  using PhysicalDeviceVariablePointersFeaturesKHR = PhysicalDeviceVariablePointersFeatures;
  struct DescriptorUpdateTemplateEntry;
  using DescriptorUpdateTemplateEntryKHR = DescriptorUpdateTemplateEntry;
  struct DescriptorUpdateTemplateCreateInfo;
  using DescriptorUpdateTemplateCreateInfoKHR = DescriptorUpdateTemplateCreateInfo;
  struct PhysicalDeviceMaintenance3Properties;
  using PhysicalDeviceMaintenance3PropertiesKHR = PhysicalDeviceMaintenance3Properties;
  struct DescriptorSetLayoutSupport;
  using DescriptorSetLayoutSupportKHR = DescriptorSetLayoutSupport;
  struct SamplerYcbcrConversionCreateInfo;
  using SamplerYcbcrConversionCreateInfoKHR = SamplerYcbcrConversionCreateInfo;
  struct SamplerYcbcrConversionInfo;
  using SamplerYcbcrConversionInfoKHR = SamplerYcbcrConversionInfo;
  struct PhysicalDeviceSamplerYcbcrConversionFeatures;
  using PhysicalDeviceSamplerYcbcrConversionFeaturesKHR = PhysicalDeviceSamplerYcbcrConversionFeatures;
  struct SamplerYcbcrConversionImageFormatProperties;
  using SamplerYcbcrConversionImageFormatPropertiesKHR = SamplerYcbcrConversionImageFormatProperties;
  struct DeviceGroupRenderPassBeginInfo;
  using DeviceGroupRenderPassBeginInfoKHR = DeviceGroupRenderPassBeginInfo;
  struct PhysicalDevicePointClippingProperties;
  using PhysicalDevicePointClippingPropertiesKHR = PhysicalDevicePointClippingProperties;
  struct InputAttachmentAspectReference;
  using InputAttachmentAspectReferenceKHR = InputAttachmentAspectReference;
  struct RenderPassInputAttachmentAspectCreateInfo;
  using RenderPassInputAttachmentAspectCreateInfoKHR = RenderPassInputAttachmentAspectCreateInfo;
  struct PipelineTessellationDomainOriginStateCreateInfo;
  using PipelineTessellationDomainOriginStateCreateInfoKHR = PipelineTessellationDomainOriginStateCreateInfo;
  struct RenderPassMultiviewCreateInfo;
  using RenderPassMultiviewCreateInfoKHR = RenderPassMultiviewCreateInfo;
  struct PhysicalDeviceMultiviewFeatures;
  using PhysicalDeviceMultiviewFeaturesKHR = PhysicalDeviceMultiviewFeatures;
  struct PhysicalDeviceMultiviewProperties;
  using PhysicalDeviceMultiviewPropertiesKHR = PhysicalDeviceMultiviewProperties;
  struct PhysicalDeviceShaderDrawParametersFeatures;
  using PhysicalDeviceShaderDrawParameterFeatures = PhysicalDeviceShaderDrawParametersFeatures;

  //=== VK_VERSION_1_2 ===
  struct ConformanceVersion;
  using ConformanceVersionKHR = ConformanceVersion;
  struct PhysicalDeviceDriverProperties;
  using PhysicalDeviceDriverPropertiesKHR = PhysicalDeviceDriverProperties;
  struct PhysicalDeviceVulkan11Features;
  struct PhysicalDeviceVulkan11Properties;
  struct PhysicalDeviceVulkan12Features;
  struct PhysicalDeviceVulkan12Properties;
  struct ImageFormatListCreateInfo;
  using ImageFormatListCreateInfoKHR = ImageFormatListCreateInfo;
  struct PhysicalDeviceVulkanMemoryModelFeatures;
  using PhysicalDeviceVulkanMemoryModelFeaturesKHR = PhysicalDeviceVulkanMemoryModelFeatures;
  struct PhysicalDeviceHostQueryResetFeatures;
  using PhysicalDeviceHostQueryResetFeaturesEXT = PhysicalDeviceHostQueryResetFeatures;
  struct PhysicalDeviceTimelineSemaphoreFeatures;
  using PhysicalDeviceTimelineSemaphoreFeaturesKHR = PhysicalDeviceTimelineSemaphoreFeatures;
  struct PhysicalDeviceTimelineSemaphoreProperties;
  using PhysicalDeviceTimelineSemaphorePropertiesKHR = PhysicalDeviceTimelineSemaphoreProperties;
  struct SemaphoreTypeCreateInfo;
  using SemaphoreTypeCreateInfoKHR = SemaphoreTypeCreateInfo;
  struct TimelineSemaphoreSubmitInfo;
  using TimelineSemaphoreSubmitInfoKHR = TimelineSemaphoreSubmitInfo;
  struct SemaphoreWaitInfo;
  using SemaphoreWaitInfoKHR = SemaphoreWaitInfo;
  struct SemaphoreSignalInfo;
  using SemaphoreSignalInfoKHR = SemaphoreSignalInfo;
  struct PhysicalDeviceBufferDeviceAddressFeatures;
  using PhysicalDeviceBufferDeviceAddressFeaturesKHR = PhysicalDeviceBufferDeviceAddressFeatures;
  struct BufferDeviceAddressInfo;
  using BufferDeviceAddressInfoEXT = BufferDeviceAddressInfo;
  using BufferDeviceAddressInfoKHR = BufferDeviceAddressInfo;
  struct BufferOpaqueCaptureAddressCreateInfo;
  using BufferOpaqueCaptureAddressCreateInfoKHR = BufferOpaqueCaptureAddressCreateInfo;
  struct MemoryOpaqueCaptureAddressAllocateInfo;
  using MemoryOpaqueCaptureAddressAllocateInfoKHR = MemoryOpaqueCaptureAddressAllocateInfo;
  struct DeviceMemoryOpaqueCaptureAddressInfo;
  using DeviceMemoryOpaqueCaptureAddressInfoKHR = DeviceMemoryOpaqueCaptureAddressInfo;
  struct PhysicalDevice8BitStorageFeatures;
  using PhysicalDevice8BitStorageFeaturesKHR = PhysicalDevice8BitStorageFeatures;
  struct PhysicalDeviceShaderAtomicInt64Features;
  using PhysicalDeviceShaderAtomicInt64FeaturesKHR = PhysicalDeviceShaderAtomicInt64Features;
  struct PhysicalDeviceShaderFloat16Int8Features;
  using PhysicalDeviceFloat16Int8FeaturesKHR       = PhysicalDeviceShaderFloat16Int8Features;
  using PhysicalDeviceShaderFloat16Int8FeaturesKHR = PhysicalDeviceShaderFloat16Int8Features;
  struct PhysicalDeviceFloatControlsProperties;
  using PhysicalDeviceFloatControlsPropertiesKHR = PhysicalDeviceFloatControlsProperties;
  struct DescriptorSetLayoutBindingFlagsCreateInfo;
  using DescriptorSetLayoutBindingFlagsCreateInfoEXT = DescriptorSetLayoutBindingFlagsCreateInfo;
  struct PhysicalDeviceDescriptorIndexingFeatures;
  using PhysicalDeviceDescriptorIndexingFeaturesEXT = PhysicalDeviceDescriptorIndexingFeatures;
  struct PhysicalDeviceDescriptorIndexingProperties;
  using PhysicalDeviceDescriptorIndexingPropertiesEXT = PhysicalDeviceDescriptorIndexingProperties;
  struct DescriptorSetVariableDescriptorCountAllocateInfo;
  using DescriptorSetVariableDescriptorCountAllocateInfoEXT = DescriptorSetVariableDescriptorCountAllocateInfo;
  struct DescriptorSetVariableDescriptorCountLayoutSupport;
  using DescriptorSetVariableDescriptorCountLayoutSupportEXT = DescriptorSetVariableDescriptorCountLayoutSupport;
  struct PhysicalDeviceScalarBlockLayoutFeatures;
  using PhysicalDeviceScalarBlockLayoutFeaturesEXT = PhysicalDeviceScalarBlockLayoutFeatures;
  struct SamplerReductionModeCreateInfo;
  using SamplerReductionModeCreateInfoEXT = SamplerReductionModeCreateInfo;
  struct PhysicalDeviceSamplerFilterMinmaxProperties;
  using PhysicalDeviceSamplerFilterMinmaxPropertiesEXT = PhysicalDeviceSamplerFilterMinmaxProperties;
  struct PhysicalDeviceUniformBufferStandardLayoutFeatures;
  using PhysicalDeviceUniformBufferStandardLayoutFeaturesKHR = PhysicalDeviceUniformBufferStandardLayoutFeatures;
  struct PhysicalDeviceShaderSubgroupExtendedTypesFeatures;
  using PhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR = PhysicalDeviceShaderSubgroupExtendedTypesFeatures;
  struct AttachmentDescription2;
  using AttachmentDescription2KHR = AttachmentDescription2;
  struct AttachmentReference2;
  using AttachmentReference2KHR = AttachmentReference2;
  struct SubpassDescription2;
  using SubpassDescription2KHR = SubpassDescription2;
  struct SubpassDependency2;
  using SubpassDependency2KHR = SubpassDependency2;
  struct SubpassBeginInfo;
  using SubpassBeginInfoKHR = SubpassBeginInfo;
  struct SubpassEndInfo;
  using SubpassEndInfoKHR = SubpassEndInfo;
  struct RenderPassCreateInfo2;
  using RenderPassCreateInfo2KHR = RenderPassCreateInfo2;
  struct SubpassDescriptionDepthStencilResolve;
  using SubpassDescriptionDepthStencilResolveKHR = SubpassDescriptionDepthStencilResolve;
  struct PhysicalDeviceDepthStencilResolveProperties;
  using PhysicalDeviceDepthStencilResolvePropertiesKHR = PhysicalDeviceDepthStencilResolveProperties;
  struct ImageStencilUsageCreateInfo;
  using ImageStencilUsageCreateInfoEXT = ImageStencilUsageCreateInfo;
  struct PhysicalDeviceImagelessFramebufferFeatures;
  using PhysicalDeviceImagelessFramebufferFeaturesKHR = PhysicalDeviceImagelessFramebufferFeatures;
  struct FramebufferAttachmentImageInfo;
  using FramebufferAttachmentImageInfoKHR = FramebufferAttachmentImageInfo;
  struct RenderPassAttachmentBeginInfo;
  using RenderPassAttachmentBeginInfoKHR = RenderPassAttachmentBeginInfo;
  struct FramebufferAttachmentsCreateInfo;
  using FramebufferAttachmentsCreateInfoKHR = FramebufferAttachmentsCreateInfo;
  struct PhysicalDeviceSeparateDepthStencilLayoutsFeatures;
  using PhysicalDeviceSeparateDepthStencilLayoutsFeaturesKHR = PhysicalDeviceSeparateDepthStencilLayoutsFeatures;
  struct AttachmentReferenceStencilLayout;
  using AttachmentReferenceStencilLayoutKHR = AttachmentReferenceStencilLayout;
  struct AttachmentDescriptionStencilLayout;
  using AttachmentDescriptionStencilLayoutKHR = AttachmentDescriptionStencilLayout;

  //=== VK_VERSION_1_3 ===
  struct PhysicalDeviceVulkan13Features;
  struct PhysicalDeviceVulkan13Properties;
  struct PhysicalDeviceToolProperties;
  using PhysicalDeviceToolPropertiesEXT = PhysicalDeviceToolProperties;
  struct PhysicalDevicePrivateDataFeatures;
  using PhysicalDevicePrivateDataFeaturesEXT = PhysicalDevicePrivateDataFeatures;
  struct DevicePrivateDataCreateInfo;
  using DevicePrivateDataCreateInfoEXT = DevicePrivateDataCreateInfo;
  struct PrivateDataSlotCreateInfo;
  using PrivateDataSlotCreateInfoEXT = PrivateDataSlotCreateInfo;
  struct MemoryBarrier2;
  using MemoryBarrier2KHR = MemoryBarrier2;
  struct BufferMemoryBarrier2;
  using BufferMemoryBarrier2KHR = BufferMemoryBarrier2;
  struct ImageMemoryBarrier2;
  using ImageMemoryBarrier2KHR = ImageMemoryBarrier2;
  struct DependencyInfo;
  using DependencyInfoKHR = DependencyInfo;
  struct SemaphoreSubmitInfo;
  using SemaphoreSubmitInfoKHR = SemaphoreSubmitInfo;
  struct CommandBufferSubmitInfo;
  using CommandBufferSubmitInfoKHR = CommandBufferSubmitInfo;
  struct SubmitInfo2;
  using SubmitInfo2KHR = SubmitInfo2;
  struct PhysicalDeviceSynchronization2Features;
  using PhysicalDeviceSynchronization2FeaturesKHR = PhysicalDeviceSynchronization2Features;
  struct BufferCopy2;
  using BufferCopy2KHR = BufferCopy2;
  struct CopyBufferInfo2;
  using CopyBufferInfo2KHR = CopyBufferInfo2;
  struct ImageCopy2;
  using ImageCopy2KHR = ImageCopy2;
  struct CopyImageInfo2;
  using CopyImageInfo2KHR = CopyImageInfo2;
  struct BufferImageCopy2;
  using BufferImageCopy2KHR = BufferImageCopy2;
  struct CopyBufferToImageInfo2;
  using CopyBufferToImageInfo2KHR = CopyBufferToImageInfo2;
  struct CopyImageToBufferInfo2;
  using CopyImageToBufferInfo2KHR = CopyImageToBufferInfo2;
  struct PhysicalDeviceTextureCompressionASTCHDRFeatures;
  using PhysicalDeviceTextureCompressionASTCHDRFeaturesEXT = PhysicalDeviceTextureCompressionASTCHDRFeatures;
  struct FormatProperties3;
  using FormatProperties3KHR = FormatProperties3;
  struct PhysicalDeviceMaintenance4Features;
  using PhysicalDeviceMaintenance4FeaturesKHR = PhysicalDeviceMaintenance4Features;
  struct PhysicalDeviceMaintenance4Properties;
  using PhysicalDeviceMaintenance4PropertiesKHR = PhysicalDeviceMaintenance4Properties;
  struct DeviceBufferMemoryRequirements;
  using DeviceBufferMemoryRequirementsKHR = DeviceBufferMemoryRequirements;
  struct DeviceImageMemoryRequirements;
  using DeviceImageMemoryRequirementsKHR = DeviceImageMemoryRequirements;
  struct PipelineCreationFeedback;
  using PipelineCreationFeedbackEXT = PipelineCreationFeedback;
  struct PipelineCreationFeedbackCreateInfo;
  using PipelineCreationFeedbackCreateInfoEXT = PipelineCreationFeedbackCreateInfo;
  struct PhysicalDeviceShaderTerminateInvocationFeatures;
  using PhysicalDeviceShaderTerminateInvocationFeaturesKHR = PhysicalDeviceShaderTerminateInvocationFeatures;
  struct PhysicalDeviceShaderDemoteToHelperInvocationFeatures;
  using PhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT = PhysicalDeviceShaderDemoteToHelperInvocationFeatures;
  struct PhysicalDevicePipelineCreationCacheControlFeatures;
  using PhysicalDevicePipelineCreationCacheControlFeaturesEXT = PhysicalDevicePipelineCreationCacheControlFeatures;
  struct PhysicalDeviceZeroInitializeWorkgroupMemoryFeatures;
  using PhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR = PhysicalDeviceZeroInitializeWorkgroupMemoryFeatures;
  struct PhysicalDeviceImageRobustnessFeatures;
  using PhysicalDeviceImageRobustnessFeaturesEXT = PhysicalDeviceImageRobustnessFeatures;
  struct PhysicalDeviceSubgroupSizeControlFeatures;
  using PhysicalDeviceSubgroupSizeControlFeaturesEXT = PhysicalDeviceSubgroupSizeControlFeatures;
  struct PhysicalDeviceSubgroupSizeControlProperties;
  using PhysicalDeviceSubgroupSizeControlPropertiesEXT = PhysicalDeviceSubgroupSizeControlProperties;
  struct PipelineShaderStageRequiredSubgroupSizeCreateInfo;
  using PipelineShaderStageRequiredSubgroupSizeCreateInfoEXT = PipelineShaderStageRequiredSubgroupSizeCreateInfo;
  using ShaderRequiredSubgroupSizeCreateInfoEXT              = PipelineShaderStageRequiredSubgroupSizeCreateInfo;
  struct PhysicalDeviceInlineUniformBlockFeatures;
  using PhysicalDeviceInlineUniformBlockFeaturesEXT = PhysicalDeviceInlineUniformBlockFeatures;
  struct PhysicalDeviceInlineUniformBlockProperties;
  using PhysicalDeviceInlineUniformBlockPropertiesEXT = PhysicalDeviceInlineUniformBlockProperties;
  struct WriteDescriptorSetInlineUniformBlock;
  using WriteDescriptorSetInlineUniformBlockEXT = WriteDescriptorSetInlineUniformBlock;
  struct DescriptorPoolInlineUniformBlockCreateInfo;
  using DescriptorPoolInlineUniformBlockCreateInfoEXT = DescriptorPoolInlineUniformBlockCreateInfo;
  struct PhysicalDeviceShaderIntegerDotProductFeatures;
  using PhysicalDeviceShaderIntegerDotProductFeaturesKHR = PhysicalDeviceShaderIntegerDotProductFeatures;
  struct PhysicalDeviceShaderIntegerDotProductProperties;
  using PhysicalDeviceShaderIntegerDotProductPropertiesKHR = PhysicalDeviceShaderIntegerDotProductProperties;
  struct PhysicalDeviceTexelBufferAlignmentProperties;
  using PhysicalDeviceTexelBufferAlignmentPropertiesEXT = PhysicalDeviceTexelBufferAlignmentProperties;
  struct ImageBlit2;
  using ImageBlit2KHR = ImageBlit2;
  struct BlitImageInfo2;
  using BlitImageInfo2KHR = BlitImageInfo2;
  struct ImageResolve2;
  using ImageResolve2KHR = ImageResolve2;
  struct ResolveImageInfo2;
  using ResolveImageInfo2KHR = ResolveImageInfo2;
  struct RenderingAttachmentInfo;
  using RenderingAttachmentInfoKHR = RenderingAttachmentInfo;
  struct RenderingInfo;
  using RenderingInfoKHR = RenderingInfo;
  struct PipelineRenderingCreateInfo;
  using PipelineRenderingCreateInfoKHR = PipelineRenderingCreateInfo;
  struct PhysicalDeviceDynamicRenderingFeatures;
  using PhysicalDeviceDynamicRenderingFeaturesKHR = PhysicalDeviceDynamicRenderingFeatures;
  struct CommandBufferInheritanceRenderingInfo;
  using CommandBufferInheritanceRenderingInfoKHR = CommandBufferInheritanceRenderingInfo;

  //=== VK_VERSION_1_4 ===
  struct PhysicalDeviceVulkan14Features;
  struct PhysicalDeviceVulkan14Properties;
  struct DeviceQueueGlobalPriorityCreateInfo;
  using DeviceQueueGlobalPriorityCreateInfoEXT = DeviceQueueGlobalPriorityCreateInfo;
  using DeviceQueueGlobalPriorityCreateInfoKHR = DeviceQueueGlobalPriorityCreateInfo;
  struct PhysicalDeviceGlobalPriorityQueryFeatures;
  using PhysicalDeviceGlobalPriorityQueryFeaturesEXT = PhysicalDeviceGlobalPriorityQueryFeatures;
  using PhysicalDeviceGlobalPriorityQueryFeaturesKHR = PhysicalDeviceGlobalPriorityQueryFeatures;
  struct QueueFamilyGlobalPriorityProperties;
  using QueueFamilyGlobalPriorityPropertiesEXT = QueueFamilyGlobalPriorityProperties;
  using QueueFamilyGlobalPriorityPropertiesKHR = QueueFamilyGlobalPriorityProperties;
  struct PhysicalDeviceIndexTypeUint8Features;
  using PhysicalDeviceIndexTypeUint8FeaturesEXT = PhysicalDeviceIndexTypeUint8Features;
  using PhysicalDeviceIndexTypeUint8FeaturesKHR = PhysicalDeviceIndexTypeUint8Features;
  struct MemoryMapInfo;
  using MemoryMapInfoKHR = MemoryMapInfo;
  struct MemoryUnmapInfo;
  using MemoryUnmapInfoKHR = MemoryUnmapInfo;
  struct PhysicalDeviceMaintenance5Features;
  using PhysicalDeviceMaintenance5FeaturesKHR = PhysicalDeviceMaintenance5Features;
  struct PhysicalDeviceMaintenance5Properties;
  using PhysicalDeviceMaintenance5PropertiesKHR = PhysicalDeviceMaintenance5Properties;
  struct SubresourceLayout2;
  using SubresourceLayout2EXT = SubresourceLayout2;
  using SubresourceLayout2KHR = SubresourceLayout2;
  struct ImageSubresource2;
  using ImageSubresource2EXT = ImageSubresource2;
  using ImageSubresource2KHR = ImageSubresource2;
  struct DeviceImageSubresourceInfo;
  using DeviceImageSubresourceInfoKHR = DeviceImageSubresourceInfo;
  struct BufferUsageFlags2CreateInfo;
  using BufferUsageFlags2CreateInfoKHR = BufferUsageFlags2CreateInfo;
  struct PhysicalDeviceMaintenance6Features;
  using PhysicalDeviceMaintenance6FeaturesKHR = PhysicalDeviceMaintenance6Features;
  struct PhysicalDeviceMaintenance6Properties;
  using PhysicalDeviceMaintenance6PropertiesKHR = PhysicalDeviceMaintenance6Properties;
  struct BindMemoryStatus;
  using BindMemoryStatusKHR = BindMemoryStatus;
  struct PhysicalDeviceHostImageCopyFeatures;
  using PhysicalDeviceHostImageCopyFeaturesEXT = PhysicalDeviceHostImageCopyFeatures;
  struct PhysicalDeviceHostImageCopyProperties;
  using PhysicalDeviceHostImageCopyPropertiesEXT = PhysicalDeviceHostImageCopyProperties;
  struct MemoryToImageCopy;
  using MemoryToImageCopyEXT = MemoryToImageCopy;
  struct ImageToMemoryCopy;
  using ImageToMemoryCopyEXT = ImageToMemoryCopy;
  struct CopyMemoryToImageInfo;
  using CopyMemoryToImageInfoEXT = CopyMemoryToImageInfo;
  struct CopyImageToMemoryInfo;
  using CopyImageToMemoryInfoEXT = CopyImageToMemoryInfo;
  struct CopyImageToImageInfo;
  using CopyImageToImageInfoEXT = CopyImageToImageInfo;
  struct HostImageLayoutTransitionInfo;
  using HostImageLayoutTransitionInfoEXT = HostImageLayoutTransitionInfo;
  struct SubresourceHostMemcpySize;
  using SubresourceHostMemcpySizeEXT = SubresourceHostMemcpySize;
  struct HostImageCopyDevicePerformanceQuery;
  using HostImageCopyDevicePerformanceQueryEXT = HostImageCopyDevicePerformanceQuery;
  struct PhysicalDeviceShaderSubgroupRotateFeatures;
  using PhysicalDeviceShaderSubgroupRotateFeaturesKHR = PhysicalDeviceShaderSubgroupRotateFeatures;
  struct PhysicalDeviceShaderFloatControls2Features;
  using PhysicalDeviceShaderFloatControls2FeaturesKHR = PhysicalDeviceShaderFloatControls2Features;
  struct PhysicalDeviceShaderExpectAssumeFeatures;
  using PhysicalDeviceShaderExpectAssumeFeaturesKHR = PhysicalDeviceShaderExpectAssumeFeatures;
  struct PipelineCreateFlags2CreateInfo;
  using PipelineCreateFlags2CreateInfoKHR = PipelineCreateFlags2CreateInfo;
  struct PhysicalDevicePushDescriptorProperties;
  using PhysicalDevicePushDescriptorPropertiesKHR = PhysicalDevicePushDescriptorProperties;
  struct BindDescriptorSetsInfo;
  using BindDescriptorSetsInfoKHR = BindDescriptorSetsInfo;
  struct PushConstantsInfo;
  using PushConstantsInfoKHR = PushConstantsInfo;
  struct PushDescriptorSetInfo;
  using PushDescriptorSetInfoKHR = PushDescriptorSetInfo;
  struct PushDescriptorSetWithTemplateInfo;
  using PushDescriptorSetWithTemplateInfoKHR = PushDescriptorSetWithTemplateInfo;
  struct PhysicalDevicePipelineProtectedAccessFeatures;
  using PhysicalDevicePipelineProtectedAccessFeaturesEXT = PhysicalDevicePipelineProtectedAccessFeatures;
  struct PhysicalDevicePipelineRobustnessFeatures;
  using PhysicalDevicePipelineRobustnessFeaturesEXT = PhysicalDevicePipelineRobustnessFeatures;
  struct PhysicalDevicePipelineRobustnessProperties;
  using PhysicalDevicePipelineRobustnessPropertiesEXT = PhysicalDevicePipelineRobustnessProperties;
  struct PipelineRobustnessCreateInfo;
  using PipelineRobustnessCreateInfoEXT = PipelineRobustnessCreateInfo;
  struct PhysicalDeviceLineRasterizationFeatures;
  using PhysicalDeviceLineRasterizationFeaturesEXT = PhysicalDeviceLineRasterizationFeatures;
  using PhysicalDeviceLineRasterizationFeaturesKHR = PhysicalDeviceLineRasterizationFeatures;
  struct PhysicalDeviceLineRasterizationProperties;
  using PhysicalDeviceLineRasterizationPropertiesEXT = PhysicalDeviceLineRasterizationProperties;
  using PhysicalDeviceLineRasterizationPropertiesKHR = PhysicalDeviceLineRasterizationProperties;
  struct PipelineRasterizationLineStateCreateInfo;
  using PipelineRasterizationLineStateCreateInfoEXT = PipelineRasterizationLineStateCreateInfo;
  using PipelineRasterizationLineStateCreateInfoKHR = PipelineRasterizationLineStateCreateInfo;
  struct PhysicalDeviceVertexAttributeDivisorProperties;
  using PhysicalDeviceVertexAttributeDivisorPropertiesKHR = PhysicalDeviceVertexAttributeDivisorProperties;
  struct VertexInputBindingDivisorDescription;
  using VertexInputBindingDivisorDescriptionEXT = VertexInputBindingDivisorDescription;
  using VertexInputBindingDivisorDescriptionKHR = VertexInputBindingDivisorDescription;
  struct PipelineVertexInputDivisorStateCreateInfo;
  using PipelineVertexInputDivisorStateCreateInfoEXT = PipelineVertexInputDivisorStateCreateInfo;
  using PipelineVertexInputDivisorStateCreateInfoKHR = PipelineVertexInputDivisorStateCreateInfo;
  struct PhysicalDeviceVertexAttributeDivisorFeatures;
  using PhysicalDeviceVertexAttributeDivisorFeaturesEXT = PhysicalDeviceVertexAttributeDivisorFeatures;
  using PhysicalDeviceVertexAttributeDivisorFeaturesKHR = PhysicalDeviceVertexAttributeDivisorFeatures;
  struct RenderingAreaInfo;
  using RenderingAreaInfoKHR = RenderingAreaInfo;
  struct PhysicalDeviceDynamicRenderingLocalReadFeatures;
  using PhysicalDeviceDynamicRenderingLocalReadFeaturesKHR = PhysicalDeviceDynamicRenderingLocalReadFeatures;
  struct RenderingAttachmentLocationInfo;
  using RenderingAttachmentLocationInfoKHR = RenderingAttachmentLocationInfo;
  struct RenderingInputAttachmentIndexInfo;
  using RenderingInputAttachmentIndexInfoKHR = RenderingInputAttachmentIndexInfo;

  //=== VK_KHR_surface ===
  struct SurfaceCapabilitiesKHR;
  struct SurfaceFormatKHR;

  //=== VK_KHR_swapchain ===
  struct SwapchainCreateInfoKHR;
  struct PresentInfoKHR;
  struct ImageSwapchainCreateInfoKHR;
  struct BindImageMemorySwapchainInfoKHR;
  struct AcquireNextImageInfoKHR;
  struct DeviceGroupPresentCapabilitiesKHR;
  struct DeviceGroupPresentInfoKHR;
  struct DeviceGroupSwapchainCreateInfoKHR;

  //=== VK_KHR_display ===
  struct DisplayModeCreateInfoKHR;
  struct DisplayModeParametersKHR;
  struct DisplayModePropertiesKHR;
  struct DisplayPlaneCapabilitiesKHR;
  struct DisplayPlanePropertiesKHR;
  struct DisplayPropertiesKHR;
  struct DisplaySurfaceCreateInfoKHR;

  //=== VK_KHR_display_swapchain ===
  struct DisplayPresentInfoKHR;

#if defined( VK_USE_PLATFORM_XLIB_KHR )
  //=== VK_KHR_xlib_surface ===
  struct XlibSurfaceCreateInfoKHR;
#endif /*VK_USE_PLATFORM_XLIB_KHR*/

#if defined( VK_USE_PLATFORM_XCB_KHR )
  //=== VK_KHR_xcb_surface ===
  struct XcbSurfaceCreateInfoKHR;
#endif /*VK_USE_PLATFORM_XCB_KHR*/

#if defined( VK_USE_PLATFORM_WAYLAND_KHR )
  //=== VK_KHR_wayland_surface ===
  struct WaylandSurfaceCreateInfoKHR;
#endif /*VK_USE_PLATFORM_WAYLAND_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  //=== VK_KHR_android_surface ===
  struct AndroidSurfaceCreateInfoKHR;
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_WIN32_KHR )
  //=== VK_KHR_win32_surface ===
  struct Win32SurfaceCreateInfoKHR;
#endif /*VK_USE_PLATFORM_WIN32_KHR*/

  //=== VK_EXT_debug_report ===
  struct DebugReportCallbackCreateInfoEXT;

  //=== VK_AMD_rasterization_order ===
  struct PipelineRasterizationStateRasterizationOrderAMD;

  //=== VK_EXT_debug_marker ===
  struct DebugMarkerObjectNameInfoEXT;
  struct DebugMarkerObjectTagInfoEXT;
  struct DebugMarkerMarkerInfoEXT;

  //=== VK_KHR_video_queue ===
  struct QueueFamilyQueryResultStatusPropertiesKHR;
  struct QueueFamilyVideoPropertiesKHR;
  struct VideoProfileInfoKHR;
  struct VideoProfileListInfoKHR;
  struct VideoCapabilitiesKHR;
  struct PhysicalDeviceVideoFormatInfoKHR;
  struct VideoFormatPropertiesKHR;
  struct VideoPictureResourceInfoKHR;
  struct VideoReferenceSlotInfoKHR;
  struct VideoSessionMemoryRequirementsKHR;
  struct BindVideoSessionMemoryInfoKHR;
  struct VideoSessionCreateInfoKHR;
  struct VideoSessionParametersCreateInfoKHR;
  struct VideoSessionParametersUpdateInfoKHR;
  struct VideoBeginCodingInfoKHR;
  struct VideoEndCodingInfoKHR;
  struct VideoCodingControlInfoKHR;

  //=== VK_KHR_video_decode_queue ===
  struct VideoDecodeCapabilitiesKHR;
  struct VideoDecodeUsageInfoKHR;
  struct VideoDecodeInfoKHR;

  //=== VK_NV_dedicated_allocation ===
  struct DedicatedAllocationImageCreateInfoNV;
  struct DedicatedAllocationBufferCreateInfoNV;
  struct DedicatedAllocationMemoryAllocateInfoNV;

  //=== VK_EXT_transform_feedback ===
  struct PhysicalDeviceTransformFeedbackFeaturesEXT;
  struct PhysicalDeviceTransformFeedbackPropertiesEXT;
  struct PipelineRasterizationStateStreamCreateInfoEXT;

  //=== VK_NVX_binary_import ===
  struct CuModuleCreateInfoNVX;
  struct CuModuleTexturingModeCreateInfoNVX;
  struct CuFunctionCreateInfoNVX;
  struct CuLaunchInfoNVX;

  //=== VK_NVX_image_view_handle ===
  struct ImageViewHandleInfoNVX;
  struct ImageViewAddressPropertiesNVX;

  //=== VK_KHR_video_encode_h264 ===
  struct VideoEncodeH264CapabilitiesKHR;
  struct VideoEncodeH264QualityLevelPropertiesKHR;
  struct VideoEncodeH264SessionCreateInfoKHR;
  struct VideoEncodeH264SessionParametersCreateInfoKHR;
  struct VideoEncodeH264SessionParametersAddInfoKHR;
  struct VideoEncodeH264SessionParametersGetInfoKHR;
  struct VideoEncodeH264SessionParametersFeedbackInfoKHR;
  struct VideoEncodeH264PictureInfoKHR;
  struct VideoEncodeH264DpbSlotInfoKHR;
  struct VideoEncodeH264NaluSliceInfoKHR;
  struct VideoEncodeH264ProfileInfoKHR;
  struct VideoEncodeH264RateControlInfoKHR;
  struct VideoEncodeH264RateControlLayerInfoKHR;
  struct VideoEncodeH264QpKHR;
  struct VideoEncodeH264FrameSizeKHR;
  struct VideoEncodeH264GopRemainingFrameInfoKHR;

  //=== VK_KHR_video_encode_h265 ===
  struct VideoEncodeH265CapabilitiesKHR;
  struct VideoEncodeH265SessionCreateInfoKHR;
  struct VideoEncodeH265QualityLevelPropertiesKHR;
  struct VideoEncodeH265SessionParametersCreateInfoKHR;
  struct VideoEncodeH265SessionParametersAddInfoKHR;
  struct VideoEncodeH265SessionParametersGetInfoKHR;
  struct VideoEncodeH265SessionParametersFeedbackInfoKHR;
  struct VideoEncodeH265PictureInfoKHR;
  struct VideoEncodeH265DpbSlotInfoKHR;
  struct VideoEncodeH265NaluSliceSegmentInfoKHR;
  struct VideoEncodeH265ProfileInfoKHR;
  struct VideoEncodeH265RateControlInfoKHR;
  struct VideoEncodeH265RateControlLayerInfoKHR;
  struct VideoEncodeH265QpKHR;
  struct VideoEncodeH265FrameSizeKHR;
  struct VideoEncodeH265GopRemainingFrameInfoKHR;

  //=== VK_KHR_video_decode_h264 ===
  struct VideoDecodeH264ProfileInfoKHR;
  struct VideoDecodeH264CapabilitiesKHR;
  struct VideoDecodeH264SessionParametersCreateInfoKHR;
  struct VideoDecodeH264SessionParametersAddInfoKHR;
  struct VideoDecodeH264PictureInfoKHR;
  struct VideoDecodeH264DpbSlotInfoKHR;

  //=== VK_AMD_texture_gather_bias_lod ===
  struct TextureLODGatherFormatPropertiesAMD;

  //=== VK_AMD_shader_info ===
  struct ShaderResourceUsageAMD;
  struct ShaderStatisticsInfoAMD;

#if defined( VK_USE_PLATFORM_GGP )
  //=== VK_GGP_stream_descriptor_surface ===
  struct StreamDescriptorSurfaceCreateInfoGGP;
#endif /*VK_USE_PLATFORM_GGP*/

  //=== VK_NV_corner_sampled_image ===
  struct PhysicalDeviceCornerSampledImageFeaturesNV;

  //=== VK_NV_external_memory_capabilities ===
  struct ExternalImageFormatPropertiesNV;

  //=== VK_NV_external_memory ===
  struct ExternalMemoryImageCreateInfoNV;
  struct ExportMemoryAllocateInfoNV;

#if defined( VK_USE_PLATFORM_WIN32_KHR )
  //=== VK_NV_external_memory_win32 ===
  struct ImportMemoryWin32HandleInfoNV;
  struct ExportMemoryWin32HandleInfoNV;
#endif /*VK_USE_PLATFORM_WIN32_KHR*/

#if defined( VK_USE_PLATFORM_WIN32_KHR )
  //=== VK_NV_win32_keyed_mutex ===
  struct Win32KeyedMutexAcquireReleaseInfoNV;
#endif /*VK_USE_PLATFORM_WIN32_KHR*/

  //=== VK_EXT_validation_flags ===
  struct ValidationFlagsEXT;

#if defined( VK_USE_PLATFORM_VI_NN )
  //=== VK_NN_vi_surface ===
  struct ViSurfaceCreateInfoNN;
#endif /*VK_USE_PLATFORM_VI_NN*/

  //=== VK_EXT_astc_decode_mode ===
  struct ImageViewASTCDecodeModeEXT;
  struct PhysicalDeviceASTCDecodeFeaturesEXT;

#if defined( VK_USE_PLATFORM_WIN32_KHR )
  //=== VK_KHR_external_memory_win32 ===
  struct ImportMemoryWin32HandleInfoKHR;
  struct ExportMemoryWin32HandleInfoKHR;
  struct MemoryWin32HandlePropertiesKHR;
  struct MemoryGetWin32HandleInfoKHR;
#endif /*VK_USE_PLATFORM_WIN32_KHR*/

  //=== VK_KHR_external_memory_fd ===
  struct ImportMemoryFdInfoKHR;
  struct MemoryFdPropertiesKHR;
  struct MemoryGetFdInfoKHR;

#if defined( VK_USE_PLATFORM_WIN32_KHR )
  //=== VK_KHR_win32_keyed_mutex ===
  struct Win32KeyedMutexAcquireReleaseInfoKHR;
#endif /*VK_USE_PLATFORM_WIN32_KHR*/

#if defined( VK_USE_PLATFORM_WIN32_KHR )
  //=== VK_KHR_external_semaphore_win32 ===
  struct ImportSemaphoreWin32HandleInfoKHR;
  struct ExportSemaphoreWin32HandleInfoKHR;
  struct D3D12FenceSubmitInfoKHR;
  struct SemaphoreGetWin32HandleInfoKHR;
#endif /*VK_USE_PLATFORM_WIN32_KHR*/

  //=== VK_KHR_external_semaphore_fd ===
  struct ImportSemaphoreFdInfoKHR;
  struct SemaphoreGetFdInfoKHR;

  //=== VK_EXT_conditional_rendering ===
  struct ConditionalRenderingBeginInfoEXT;
  struct PhysicalDeviceConditionalRenderingFeaturesEXT;
  struct CommandBufferInheritanceConditionalRenderingInfoEXT;

  //=== VK_KHR_incremental_present ===
  struct PresentRegionsKHR;
  struct PresentRegionKHR;
  struct RectLayerKHR;

  //=== VK_NV_clip_space_w_scaling ===
  struct ViewportWScalingNV;
  struct PipelineViewportWScalingStateCreateInfoNV;

  //=== VK_EXT_display_surface_counter ===
  struct SurfaceCapabilities2EXT;

  //=== VK_EXT_display_control ===
  struct DisplayPowerInfoEXT;
  struct DeviceEventInfoEXT;
  struct DisplayEventInfoEXT;
  struct SwapchainCounterCreateInfoEXT;

  //=== VK_GOOGLE_display_timing ===
  struct RefreshCycleDurationGOOGLE;
  struct PastPresentationTimingGOOGLE;
  struct PresentTimesInfoGOOGLE;
  struct PresentTimeGOOGLE;

  //=== VK_NVX_multiview_per_view_attributes ===
  struct PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX;
  struct MultiviewPerViewAttributesInfoNVX;

  //=== VK_NV_viewport_swizzle ===
  struct ViewportSwizzleNV;
  struct PipelineViewportSwizzleStateCreateInfoNV;

  //=== VK_EXT_discard_rectangles ===
  struct PhysicalDeviceDiscardRectanglePropertiesEXT;
  struct PipelineDiscardRectangleStateCreateInfoEXT;

  //=== VK_EXT_conservative_rasterization ===
  struct PhysicalDeviceConservativeRasterizationPropertiesEXT;
  struct PipelineRasterizationConservativeStateCreateInfoEXT;

  //=== VK_EXT_depth_clip_enable ===
  struct PhysicalDeviceDepthClipEnableFeaturesEXT;
  struct PipelineRasterizationDepthClipStateCreateInfoEXT;

  //=== VK_EXT_hdr_metadata ===
  struct HdrMetadataEXT;
  struct XYColorEXT;

  //=== VK_IMG_relaxed_line_rasterization ===
  struct PhysicalDeviceRelaxedLineRasterizationFeaturesIMG;

  //=== VK_KHR_shared_presentable_image ===
  struct SharedPresentSurfaceCapabilitiesKHR;

#if defined( VK_USE_PLATFORM_WIN32_KHR )
  //=== VK_KHR_external_fence_win32 ===
  struct ImportFenceWin32HandleInfoKHR;
  struct ExportFenceWin32HandleInfoKHR;
  struct FenceGetWin32HandleInfoKHR;
#endif /*VK_USE_PLATFORM_WIN32_KHR*/

  //=== VK_KHR_external_fence_fd ===
  struct ImportFenceFdInfoKHR;
  struct FenceGetFdInfoKHR;

  //=== VK_KHR_performance_query ===
  struct PhysicalDevicePerformanceQueryFeaturesKHR;
  struct PhysicalDevicePerformanceQueryPropertiesKHR;
  struct PerformanceCounterKHR;
  struct PerformanceCounterDescriptionKHR;
  struct QueryPoolPerformanceCreateInfoKHR;
  union PerformanceCounterResultKHR;
  struct AcquireProfilingLockInfoKHR;
  struct PerformanceQuerySubmitInfoKHR;

  //=== VK_KHR_get_surface_capabilities2 ===
  struct PhysicalDeviceSurfaceInfo2KHR;
  struct SurfaceCapabilities2KHR;
  struct SurfaceFormat2KHR;

  //=== VK_KHR_get_display_properties2 ===
  struct DisplayProperties2KHR;
  struct DisplayPlaneProperties2KHR;
  struct DisplayModeProperties2KHR;
  struct DisplayPlaneInfo2KHR;
  struct DisplayPlaneCapabilities2KHR;

#if defined( VK_USE_PLATFORM_IOS_MVK )
  //=== VK_MVK_ios_surface ===
  struct IOSSurfaceCreateInfoMVK;
#endif /*VK_USE_PLATFORM_IOS_MVK*/

#if defined( VK_USE_PLATFORM_MACOS_MVK )
  //=== VK_MVK_macos_surface ===
  struct MacOSSurfaceCreateInfoMVK;
#endif /*VK_USE_PLATFORM_MACOS_MVK*/

  //=== VK_EXT_debug_utils ===
  struct DebugUtilsLabelEXT;
  struct DebugUtilsMessengerCallbackDataEXT;
  struct DebugUtilsMessengerCreateInfoEXT;
  struct DebugUtilsObjectNameInfoEXT;
  struct DebugUtilsObjectTagInfoEXT;

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  //=== VK_ANDROID_external_memory_android_hardware_buffer ===
  struct AndroidHardwareBufferUsageANDROID;
  struct AndroidHardwareBufferPropertiesANDROID;
  struct AndroidHardwareBufferFormatPropertiesANDROID;
  struct ImportAndroidHardwareBufferInfoANDROID;
  struct MemoryGetAndroidHardwareBufferInfoANDROID;
  struct ExternalFormatANDROID;
  struct AndroidHardwareBufferFormatProperties2ANDROID;
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_ENABLE_BETA_EXTENSIONS )
  //=== VK_AMDX_shader_enqueue ===
  struct PhysicalDeviceShaderEnqueueFeaturesAMDX;
  struct PhysicalDeviceShaderEnqueuePropertiesAMDX;
  struct ExecutionGraphPipelineScratchSizeAMDX;
  struct ExecutionGraphPipelineCreateInfoAMDX;
  struct DispatchGraphInfoAMDX;
  struct DispatchGraphCountInfoAMDX;
  struct PipelineShaderStageNodeCreateInfoAMDX;
  union DeviceOrHostAddressConstAMDX;
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

  //=== VK_EXT_descriptor_heap ===
  struct HostAddressRangeEXT;
  struct HostAddressRangeConstEXT;
  struct DeviceAddressRangeEXT;
  struct TexelBufferDescriptorInfoEXT;
  struct ImageDescriptorInfoEXT;
  struct ResourceDescriptorInfoEXT;
  union ResourceDescriptorDataEXT;
  struct BindHeapInfoEXT;
  struct PushDataInfoEXT;
  struct DescriptorMappingSourceConstantOffsetEXT;
  struct DescriptorMappingSourcePushIndexEXT;
  struct DescriptorMappingSourceIndirectIndexEXT;
  struct DescriptorMappingSourceHeapDataEXT;
  struct DescriptorMappingSourceIndirectAddressEXT;
  struct DescriptorMappingSourceShaderRecordIndexEXT;
  union DescriptorMappingSourceDataEXT;
  struct DescriptorMappingSourceIndirectIndexArrayEXT;
  struct DescriptorSetAndBindingMappingEXT;
  struct ShaderDescriptorSetAndBindingMappingInfoEXT;
  struct OpaqueCaptureDataCreateInfoEXT;
  struct PhysicalDeviceDescriptorHeapFeaturesEXT;
  struct PhysicalDeviceDescriptorHeapPropertiesEXT;
  struct CommandBufferInheritanceDescriptorHeapInfoEXT;
  struct SamplerCustomBorderColorIndexCreateInfoEXT;
  struct IndirectCommandsLayoutPushDataTokenNV;
  struct SubsampledImageFormatPropertiesEXT;
  struct TensorViewCreateInfoARM;
  struct PhysicalDeviceDescriptorHeapTensorPropertiesARM;

  //=== VK_AMD_mixed_attachment_samples ===
  struct AttachmentSampleCountInfoAMD;
  using AttachmentSampleCountInfoNV = AttachmentSampleCountInfoAMD;

  //=== VK_KHR_shader_bfloat16 ===
  struct PhysicalDeviceShaderBfloat16FeaturesKHR;

  //=== VK_EXT_sample_locations ===
  struct SampleLocationEXT;
  struct SampleLocationsInfoEXT;
  struct AttachmentSampleLocationsEXT;
  struct SubpassSampleLocationsEXT;
  struct RenderPassSampleLocationsBeginInfoEXT;
  struct PipelineSampleLocationsStateCreateInfoEXT;
  struct PhysicalDeviceSampleLocationsPropertiesEXT;
  struct MultisamplePropertiesEXT;

  //=== VK_EXT_blend_operation_advanced ===
  struct PhysicalDeviceBlendOperationAdvancedFeaturesEXT;
  struct PhysicalDeviceBlendOperationAdvancedPropertiesEXT;
  struct PipelineColorBlendAdvancedStateCreateInfoEXT;

  //=== VK_NV_fragment_coverage_to_color ===
  struct PipelineCoverageToColorStateCreateInfoNV;

  //=== VK_KHR_acceleration_structure ===
  union DeviceOrHostAddressKHR;
  union DeviceOrHostAddressConstKHR;
  struct AccelerationStructureBuildRangeInfoKHR;
  struct AabbPositionsKHR;
  using AabbPositionsNV = AabbPositionsKHR;
  struct AccelerationStructureGeometryTrianglesDataKHR;
  struct TransformMatrixKHR;
  using TransformMatrixNV = TransformMatrixKHR;
  struct AccelerationStructureBuildGeometryInfoKHR;
  struct AccelerationStructureGeometryAabbsDataKHR;
  struct AccelerationStructureInstanceKHR;
  using AccelerationStructureInstanceNV = AccelerationStructureInstanceKHR;
  struct AccelerationStructureGeometryInstancesDataKHR;
  union AccelerationStructureGeometryDataKHR;
  struct AccelerationStructureGeometryKHR;
  struct AccelerationStructureCreateInfoKHR;
  struct WriteDescriptorSetAccelerationStructureKHR;
  struct PhysicalDeviceAccelerationStructureFeaturesKHR;
  struct PhysicalDeviceAccelerationStructurePropertiesKHR;
  struct AccelerationStructureDeviceAddressInfoKHR;
  struct AccelerationStructureVersionInfoKHR;
  struct CopyAccelerationStructureToMemoryInfoKHR;
  struct CopyMemoryToAccelerationStructureInfoKHR;
  struct CopyAccelerationStructureInfoKHR;
  struct AccelerationStructureBuildSizesInfoKHR;

  //=== VK_KHR_ray_tracing_pipeline ===
  struct RayTracingShaderGroupCreateInfoKHR;
  struct RayTracingPipelineCreateInfoKHR;
  struct PhysicalDeviceRayTracingPipelineFeaturesKHR;
  struct PhysicalDeviceRayTracingPipelinePropertiesKHR;
  struct StridedDeviceAddressRegionKHR;
  struct TraceRaysIndirectCommandKHR;
  struct RayTracingPipelineInterfaceCreateInfoKHR;

  //=== VK_KHR_ray_query ===
  struct PhysicalDeviceRayQueryFeaturesKHR;

  //=== VK_NV_framebuffer_mixed_samples ===
  struct PipelineCoverageModulationStateCreateInfoNV;

  //=== VK_NV_shader_sm_builtins ===
  struct PhysicalDeviceShaderSMBuiltinsPropertiesNV;
  struct PhysicalDeviceShaderSMBuiltinsFeaturesNV;

  //=== VK_EXT_image_drm_format_modifier ===
  struct DrmFormatModifierPropertiesListEXT;
  struct DrmFormatModifierPropertiesEXT;
  struct PhysicalDeviceImageDrmFormatModifierInfoEXT;
  struct ImageDrmFormatModifierListCreateInfoEXT;
  struct ImageDrmFormatModifierExplicitCreateInfoEXT;
  struct ImageDrmFormatModifierPropertiesEXT;
  struct DrmFormatModifierPropertiesList2EXT;
  struct DrmFormatModifierProperties2EXT;

  //=== VK_EXT_validation_cache ===
  struct ValidationCacheCreateInfoEXT;
  struct ShaderModuleValidationCacheCreateInfoEXT;

#if defined( VK_ENABLE_BETA_EXTENSIONS )
  //=== VK_KHR_portability_subset ===
  struct PhysicalDevicePortabilitySubsetFeaturesKHR;
  struct PhysicalDevicePortabilitySubsetPropertiesKHR;
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

  //=== VK_NV_shading_rate_image ===
  struct ShadingRatePaletteNV;
  struct PipelineViewportShadingRateImageStateCreateInfoNV;
  struct PhysicalDeviceShadingRateImageFeaturesNV;
  struct PhysicalDeviceShadingRateImagePropertiesNV;
  struct CoarseSampleLocationNV;
  struct CoarseSampleOrderCustomNV;
  struct PipelineViewportCoarseSampleOrderStateCreateInfoNV;

  //=== VK_NV_ray_tracing ===
  struct RayTracingShaderGroupCreateInfoNV;
  struct RayTracingPipelineCreateInfoNV;
  struct GeometryTrianglesNV;
  struct GeometryAABBNV;
  struct GeometryDataNV;
  struct GeometryNV;
  struct AccelerationStructureInfoNV;
  struct AccelerationStructureCreateInfoNV;
  struct BindAccelerationStructureMemoryInfoNV;
  struct WriteDescriptorSetAccelerationStructureNV;
  struct AccelerationStructureMemoryRequirementsInfoNV;
  struct PhysicalDeviceRayTracingPropertiesNV;

  //=== VK_NV_representative_fragment_test ===
  struct PhysicalDeviceRepresentativeFragmentTestFeaturesNV;
  struct PipelineRepresentativeFragmentTestStateCreateInfoNV;

  //=== VK_EXT_filter_cubic ===
  struct PhysicalDeviceImageViewImageFormatInfoEXT;
  struct FilterCubicImageViewImageFormatPropertiesEXT;

  //=== VK_QCOM_cooperative_matrix_conversion ===
  struct PhysicalDeviceCooperativeMatrixConversionFeaturesQCOM;

  //=== VK_EXT_external_memory_host ===
  struct ImportMemoryHostPointerInfoEXT;
  struct MemoryHostPointerPropertiesEXT;
  struct PhysicalDeviceExternalMemoryHostPropertiesEXT;

  //=== VK_KHR_shader_clock ===
  struct PhysicalDeviceShaderClockFeaturesKHR;

  //=== VK_AMD_pipeline_compiler_control ===
  struct PipelineCompilerControlCreateInfoAMD;

  //=== VK_AMD_shader_core_properties ===
  struct PhysicalDeviceShaderCorePropertiesAMD;

  //=== VK_KHR_video_decode_h265 ===
  struct VideoDecodeH265ProfileInfoKHR;
  struct VideoDecodeH265CapabilitiesKHR;
  struct VideoDecodeH265SessionParametersCreateInfoKHR;
  struct VideoDecodeH265SessionParametersAddInfoKHR;
  struct VideoDecodeH265PictureInfoKHR;
  struct VideoDecodeH265DpbSlotInfoKHR;

  //=== VK_AMD_memory_overallocation_behavior ===
  struct DeviceMemoryOverallocationCreateInfoAMD;

  //=== VK_EXT_vertex_attribute_divisor ===
  struct PhysicalDeviceVertexAttributeDivisorPropertiesEXT;

#if defined( VK_USE_PLATFORM_GGP )
  //=== VK_GGP_frame_token ===
  struct PresentFrameTokenGGP;
#endif /*VK_USE_PLATFORM_GGP*/

  //=== VK_NV_mesh_shader ===
  struct PhysicalDeviceMeshShaderFeaturesNV;
  struct PhysicalDeviceMeshShaderPropertiesNV;
  struct DrawMeshTasksIndirectCommandNV;

  //=== VK_NV_shader_image_footprint ===
  struct PhysicalDeviceShaderImageFootprintFeaturesNV;

  //=== VK_NV_scissor_exclusive ===
  struct PipelineViewportExclusiveScissorStateCreateInfoNV;
  struct PhysicalDeviceExclusiveScissorFeaturesNV;

  //=== VK_NV_device_diagnostic_checkpoints ===
  struct QueueFamilyCheckpointPropertiesNV;
  struct CheckpointDataNV;
  struct QueueFamilyCheckpointProperties2NV;
  struct CheckpointData2NV;

  //=== VK_EXT_present_timing ===
  struct PhysicalDevicePresentTimingFeaturesEXT;
  struct PresentTimingSurfaceCapabilitiesEXT;
  struct SwapchainCalibratedTimestampInfoEXT;
  struct SwapchainTimingPropertiesEXT;
  struct SwapchainTimeDomainPropertiesEXT;
  struct PastPresentationTimingInfoEXT;
  struct PastPresentationTimingPropertiesEXT;
  struct PastPresentationTimingEXT;
  struct PresentTimingsInfoEXT;
  struct PresentTimingInfoEXT;
  struct PresentStageTimeEXT;

  //=== VK_INTEL_shader_integer_functions2 ===
  struct PhysicalDeviceShaderIntegerFunctions2FeaturesINTEL;

  //=== VK_INTEL_performance_query ===
  union PerformanceValueDataINTEL;
  struct PerformanceValueINTEL;
  struct InitializePerformanceApiInfoINTEL;
  struct QueryPoolPerformanceQueryCreateInfoINTEL;
  using QueryPoolCreateInfoINTEL = QueryPoolPerformanceQueryCreateInfoINTEL;
  struct PerformanceMarkerInfoINTEL;
  struct PerformanceStreamMarkerInfoINTEL;
  struct PerformanceOverrideInfoINTEL;
  struct PerformanceConfigurationAcquireInfoINTEL;

  //=== VK_EXT_pci_bus_info ===
  struct PhysicalDevicePCIBusInfoPropertiesEXT;

  //=== VK_AMD_display_native_hdr ===
  struct DisplayNativeHdrSurfaceCapabilitiesAMD;
  struct SwapchainDisplayNativeHdrCreateInfoAMD;

#if defined( VK_USE_PLATFORM_FUCHSIA )
  //=== VK_FUCHSIA_imagepipe_surface ===
  struct ImagePipeSurfaceCreateInfoFUCHSIA;
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_METAL_EXT )
  //=== VK_EXT_metal_surface ===
  struct MetalSurfaceCreateInfoEXT;
#endif /*VK_USE_PLATFORM_METAL_EXT*/

  //=== VK_EXT_fragment_density_map ===
  struct PhysicalDeviceFragmentDensityMapFeaturesEXT;
  struct PhysicalDeviceFragmentDensityMapPropertiesEXT;
  struct RenderPassFragmentDensityMapCreateInfoEXT;
  struct RenderingFragmentDensityMapAttachmentInfoEXT;

  //=== VK_KHR_fragment_shading_rate ===
  struct FragmentShadingRateAttachmentInfoKHR;
  struct PipelineFragmentShadingRateStateCreateInfoKHR;
  struct PhysicalDeviceFragmentShadingRateFeaturesKHR;
  struct PhysicalDeviceFragmentShadingRatePropertiesKHR;
  struct PhysicalDeviceFragmentShadingRateKHR;
  struct RenderingFragmentShadingRateAttachmentInfoKHR;

  //=== VK_AMD_shader_core_properties2 ===
  struct PhysicalDeviceShaderCoreProperties2AMD;

  //=== VK_AMD_device_coherent_memory ===
  struct PhysicalDeviceCoherentMemoryFeaturesAMD;

  //=== VK_EXT_shader_image_atomic_int64 ===
  struct PhysicalDeviceShaderImageAtomicInt64FeaturesEXT;

  //=== VK_KHR_shader_quad_control ===
  struct PhysicalDeviceShaderQuadControlFeaturesKHR;

  //=== VK_EXT_memory_budget ===
  struct PhysicalDeviceMemoryBudgetPropertiesEXT;

  //=== VK_EXT_memory_priority ===
  struct PhysicalDeviceMemoryPriorityFeaturesEXT;
  struct MemoryPriorityAllocateInfoEXT;

  //=== VK_KHR_surface_protected_capabilities ===
  struct SurfaceProtectedCapabilitiesKHR;

  //=== VK_NV_dedicated_allocation_image_aliasing ===
  struct PhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV;

  //=== VK_EXT_buffer_device_address ===
  struct PhysicalDeviceBufferDeviceAddressFeaturesEXT;
  using PhysicalDeviceBufferAddressFeaturesEXT = PhysicalDeviceBufferDeviceAddressFeaturesEXT;
  struct BufferDeviceAddressCreateInfoEXT;

  //=== VK_EXT_validation_features ===
  struct ValidationFeaturesEXT;

  //=== VK_KHR_present_wait ===
  struct PhysicalDevicePresentWaitFeaturesKHR;

  //=== VK_NV_cooperative_matrix ===
  struct CooperativeMatrixPropertiesNV;
  struct PhysicalDeviceCooperativeMatrixFeaturesNV;
  struct PhysicalDeviceCooperativeMatrixPropertiesNV;

  //=== VK_NV_coverage_reduction_mode ===
  struct PhysicalDeviceCoverageReductionModeFeaturesNV;
  struct PipelineCoverageReductionStateCreateInfoNV;
  struct FramebufferMixedSamplesCombinationNV;

  //=== VK_EXT_fragment_shader_interlock ===
  struct PhysicalDeviceFragmentShaderInterlockFeaturesEXT;

  //=== VK_EXT_ycbcr_image_arrays ===
  struct PhysicalDeviceYcbcrImageArraysFeaturesEXT;

  //=== VK_EXT_provoking_vertex ===
  struct PhysicalDeviceProvokingVertexFeaturesEXT;
  struct PhysicalDeviceProvokingVertexPropertiesEXT;
  struct PipelineRasterizationProvokingVertexStateCreateInfoEXT;

#if defined( VK_USE_PLATFORM_WIN32_KHR )
  //=== VK_EXT_full_screen_exclusive ===
  struct SurfaceFullScreenExclusiveInfoEXT;
  struct SurfaceCapabilitiesFullScreenExclusiveEXT;
  struct SurfaceFullScreenExclusiveWin32InfoEXT;
#endif /*VK_USE_PLATFORM_WIN32_KHR*/

  //=== VK_EXT_headless_surface ===
  struct HeadlessSurfaceCreateInfoEXT;

  //=== VK_EXT_shader_atomic_float ===
  struct PhysicalDeviceShaderAtomicFloatFeaturesEXT;

  //=== VK_EXT_extended_dynamic_state ===
  struct PhysicalDeviceExtendedDynamicStateFeaturesEXT;

  //=== VK_KHR_pipeline_executable_properties ===
  struct PhysicalDevicePipelineExecutablePropertiesFeaturesKHR;
  struct PipelineInfoKHR;
  using PipelineInfoEXT = PipelineInfoKHR;
  struct PipelineExecutablePropertiesKHR;
  struct PipelineExecutableInfoKHR;
  union PipelineExecutableStatisticValueKHR;
  struct PipelineExecutableStatisticKHR;
  struct PipelineExecutableInternalRepresentationKHR;

  //=== VK_EXT_map_memory_placed ===
  struct PhysicalDeviceMapMemoryPlacedFeaturesEXT;
  struct PhysicalDeviceMapMemoryPlacedPropertiesEXT;
  struct MemoryMapPlacedInfoEXT;

  //=== VK_EXT_shader_atomic_float2 ===
  struct PhysicalDeviceShaderAtomicFloat2FeaturesEXT;

  //=== VK_NV_device_generated_commands ===
  struct PhysicalDeviceDeviceGeneratedCommandsPropertiesNV;
  struct PhysicalDeviceDeviceGeneratedCommandsFeaturesNV;
  struct GraphicsShaderGroupCreateInfoNV;
  struct GraphicsPipelineShaderGroupsCreateInfoNV;
  struct BindShaderGroupIndirectCommandNV;
  struct BindIndexBufferIndirectCommandNV;
  struct BindVertexBufferIndirectCommandNV;
  struct SetStateFlagsIndirectCommandNV;
  struct IndirectCommandsStreamNV;
  struct IndirectCommandsLayoutTokenNV;
  struct IndirectCommandsLayoutCreateInfoNV;
  struct GeneratedCommandsInfoNV;
  struct GeneratedCommandsMemoryRequirementsInfoNV;

  //=== VK_NV_inherited_viewport_scissor ===
  struct PhysicalDeviceInheritedViewportScissorFeaturesNV;
  struct CommandBufferInheritanceViewportScissorInfoNV;

  //=== VK_EXT_texel_buffer_alignment ===
  struct PhysicalDeviceTexelBufferAlignmentFeaturesEXT;

  //=== VK_QCOM_render_pass_transform ===
  struct RenderPassTransformBeginInfoQCOM;
  struct CommandBufferInheritanceRenderPassTransformInfoQCOM;

  //=== VK_EXT_depth_bias_control ===
  struct PhysicalDeviceDepthBiasControlFeaturesEXT;
  struct DepthBiasInfoEXT;
  struct DepthBiasRepresentationInfoEXT;

  //=== VK_EXT_device_memory_report ===
  struct PhysicalDeviceDeviceMemoryReportFeaturesEXT;
  struct DeviceDeviceMemoryReportCreateInfoEXT;
  struct DeviceMemoryReportCallbackDataEXT;

  //=== VK_EXT_custom_border_color ===
  struct SamplerCustomBorderColorCreateInfoEXT;
  struct PhysicalDeviceCustomBorderColorPropertiesEXT;
  struct PhysicalDeviceCustomBorderColorFeaturesEXT;

  //=== VK_EXT_texture_compression_astc_3d ===
  struct PhysicalDeviceTextureCompressionASTC3DFeaturesEXT;

  //=== VK_KHR_pipeline_library ===
  struct PipelineLibraryCreateInfoKHR;

  //=== VK_NV_present_barrier ===
  struct PhysicalDevicePresentBarrierFeaturesNV;
  struct SurfaceCapabilitiesPresentBarrierNV;
  struct SwapchainPresentBarrierCreateInfoNV;

  //=== VK_KHR_present_id ===
  struct PresentIdKHR;
  struct PhysicalDevicePresentIdFeaturesKHR;

  //=== VK_KHR_video_encode_queue ===
  struct VideoEncodeInfoKHR;
  struct VideoEncodeCapabilitiesKHR;
  struct QueryPoolVideoEncodeFeedbackCreateInfoKHR;
  struct VideoEncodeUsageInfoKHR;
  struct VideoEncodeRateControlInfoKHR;
  struct VideoEncodeRateControlLayerInfoKHR;
  struct PhysicalDeviceVideoEncodeQualityLevelInfoKHR;
  struct VideoEncodeQualityLevelPropertiesKHR;
  struct VideoEncodeQualityLevelInfoKHR;
  struct VideoEncodeSessionParametersGetInfoKHR;
  struct VideoEncodeSessionParametersFeedbackInfoKHR;

  //=== VK_NV_device_diagnostics_config ===
  struct PhysicalDeviceDiagnosticsConfigFeaturesNV;
  struct DeviceDiagnosticsConfigCreateInfoNV;

#if defined( VK_ENABLE_BETA_EXTENSIONS )
  //=== VK_NV_cuda_kernel_launch ===
  struct CudaModuleCreateInfoNV;
  struct CudaFunctionCreateInfoNV;
  struct CudaLaunchInfoNV;
  struct PhysicalDeviceCudaKernelLaunchFeaturesNV;
  struct PhysicalDeviceCudaKernelLaunchPropertiesNV;
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

  //=== VK_QCOM_tile_shading ===
  struct PhysicalDeviceTileShadingFeaturesQCOM;
  struct PhysicalDeviceTileShadingPropertiesQCOM;
  struct RenderPassTileShadingCreateInfoQCOM;
  struct PerTileBeginInfoQCOM;
  struct PerTileEndInfoQCOM;
  struct DispatchTileInfoQCOM;

  //=== VK_NV_low_latency ===
  struct QueryLowLatencySupportNV;

#if defined( VK_USE_PLATFORM_METAL_EXT )
  //=== VK_EXT_metal_objects ===
  struct ExportMetalObjectCreateInfoEXT;
  struct ExportMetalObjectsInfoEXT;
  struct ExportMetalDeviceInfoEXT;
  struct ExportMetalCommandQueueInfoEXT;
  struct ExportMetalBufferInfoEXT;
  struct ImportMetalBufferInfoEXT;
  struct ExportMetalTextureInfoEXT;
  struct ImportMetalTextureInfoEXT;
  struct ExportMetalIOSurfaceInfoEXT;
  struct ImportMetalIOSurfaceInfoEXT;
  struct ExportMetalSharedEventInfoEXT;
  struct ImportMetalSharedEventInfoEXT;
#endif /*VK_USE_PLATFORM_METAL_EXT*/

  //=== VK_EXT_descriptor_buffer ===
  struct PhysicalDeviceDescriptorBufferPropertiesEXT;
  struct PhysicalDeviceDescriptorBufferDensityMapPropertiesEXT;
  struct PhysicalDeviceDescriptorBufferFeaturesEXT;
  struct DescriptorAddressInfoEXT;
  struct DescriptorBufferBindingInfoEXT;
  struct DescriptorBufferBindingPushDescriptorBufferHandleEXT;
  union DescriptorDataEXT;
  struct DescriptorGetInfoEXT;
  struct BufferCaptureDescriptorDataInfoEXT;
  struct ImageCaptureDescriptorDataInfoEXT;
  struct ImageViewCaptureDescriptorDataInfoEXT;
  struct SamplerCaptureDescriptorDataInfoEXT;
  struct OpaqueCaptureDescriptorDataCreateInfoEXT;
  struct AccelerationStructureCaptureDescriptorDataInfoEXT;

  //=== VK_EXT_graphics_pipeline_library ===
  struct PhysicalDeviceGraphicsPipelineLibraryFeaturesEXT;
  struct PhysicalDeviceGraphicsPipelineLibraryPropertiesEXT;
  struct GraphicsPipelineLibraryCreateInfoEXT;

  //=== VK_AMD_shader_early_and_late_fragment_tests ===
  struct PhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD;

  //=== VK_KHR_fragment_shader_barycentric ===
  struct PhysicalDeviceFragmentShaderBarycentricFeaturesKHR;
  using PhysicalDeviceFragmentShaderBarycentricFeaturesNV = PhysicalDeviceFragmentShaderBarycentricFeaturesKHR;
  struct PhysicalDeviceFragmentShaderBarycentricPropertiesKHR;

  //=== VK_KHR_shader_subgroup_uniform_control_flow ===
  struct PhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR;

  //=== VK_NV_fragment_shading_rate_enums ===
  struct PhysicalDeviceFragmentShadingRateEnumsFeaturesNV;
  struct PhysicalDeviceFragmentShadingRateEnumsPropertiesNV;
  struct PipelineFragmentShadingRateEnumStateCreateInfoNV;

  //=== VK_NV_ray_tracing_motion_blur ===
  struct AccelerationStructureGeometryMotionTrianglesDataNV;
  struct AccelerationStructureMotionInfoNV;
  struct AccelerationStructureMotionInstanceNV;
  union AccelerationStructureMotionInstanceDataNV;
  struct AccelerationStructureMatrixMotionInstanceNV;
  struct AccelerationStructureSRTMotionInstanceNV;
  struct SRTDataNV;
  struct PhysicalDeviceRayTracingMotionBlurFeaturesNV;

  //=== VK_EXT_mesh_shader ===
  struct PhysicalDeviceMeshShaderFeaturesEXT;
  struct PhysicalDeviceMeshShaderPropertiesEXT;
  struct DrawMeshTasksIndirectCommandEXT;

  //=== VK_EXT_ycbcr_2plane_444_formats ===
  struct PhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT;

  //=== VK_EXT_fragment_density_map2 ===
  struct PhysicalDeviceFragmentDensityMap2FeaturesEXT;
  struct PhysicalDeviceFragmentDensityMap2PropertiesEXT;

  //=== VK_QCOM_rotated_copy_commands ===
  struct CopyCommandTransformInfoQCOM;

  //=== VK_KHR_workgroup_memory_explicit_layout ===
  struct PhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR;

  //=== VK_EXT_image_compression_control ===
  struct PhysicalDeviceImageCompressionControlFeaturesEXT;
  struct ImageCompressionControlEXT;
  struct ImageCompressionPropertiesEXT;

  //=== VK_EXT_attachment_feedback_loop_layout ===
  struct PhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT;

  //=== VK_EXT_4444_formats ===
  struct PhysicalDevice4444FormatsFeaturesEXT;

  //=== VK_EXT_device_fault ===
  struct PhysicalDeviceFaultFeaturesEXT;
  struct DeviceFaultCountsEXT;
  struct DeviceFaultInfoEXT;
  struct DeviceFaultAddressInfoEXT;
  struct DeviceFaultVendorInfoEXT;
  struct DeviceFaultVendorBinaryHeaderVersionOneEXT;

  //=== VK_EXT_rgba10x6_formats ===
  struct PhysicalDeviceRGBA10X6FormatsFeaturesEXT;

#if defined( VK_USE_PLATFORM_DIRECTFB_EXT )
  //=== VK_EXT_directfb_surface ===
  struct DirectFBSurfaceCreateInfoEXT;
#endif /*VK_USE_PLATFORM_DIRECTFB_EXT*/

  //=== VK_EXT_vertex_input_dynamic_state ===
  struct PhysicalDeviceVertexInputDynamicStateFeaturesEXT;
  struct VertexInputBindingDescription2EXT;
  struct VertexInputAttributeDescription2EXT;

  //=== VK_EXT_physical_device_drm ===
  struct PhysicalDeviceDrmPropertiesEXT;

  //=== VK_EXT_device_address_binding_report ===
  struct PhysicalDeviceAddressBindingReportFeaturesEXT;
  struct DeviceAddressBindingCallbackDataEXT;

  //=== VK_EXT_depth_clip_control ===
  struct PhysicalDeviceDepthClipControlFeaturesEXT;
  struct PipelineViewportDepthClipControlCreateInfoEXT;

  //=== VK_EXT_primitive_topology_list_restart ===
  struct PhysicalDevicePrimitiveTopologyListRestartFeaturesEXT;

#if defined( VK_USE_PLATFORM_FUCHSIA )
  //=== VK_FUCHSIA_external_memory ===
  struct ImportMemoryZirconHandleInfoFUCHSIA;
  struct MemoryZirconHandlePropertiesFUCHSIA;
  struct MemoryGetZirconHandleInfoFUCHSIA;
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  //=== VK_FUCHSIA_external_semaphore ===
  struct ImportSemaphoreZirconHandleInfoFUCHSIA;
  struct SemaphoreGetZirconHandleInfoFUCHSIA;
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  //=== VK_FUCHSIA_buffer_collection ===
  struct BufferCollectionCreateInfoFUCHSIA;
  struct ImportMemoryBufferCollectionFUCHSIA;
  struct BufferCollectionImageCreateInfoFUCHSIA;
  struct BufferConstraintsInfoFUCHSIA;
  struct BufferCollectionBufferCreateInfoFUCHSIA;
  struct BufferCollectionPropertiesFUCHSIA;
  struct SysmemColorSpaceFUCHSIA;
  struct ImageConstraintsInfoFUCHSIA;
  struct ImageFormatConstraintsInfoFUCHSIA;
  struct BufferCollectionConstraintsInfoFUCHSIA;
#endif /*VK_USE_PLATFORM_FUCHSIA*/

  //=== VK_HUAWEI_subpass_shading ===
  struct SubpassShadingPipelineCreateInfoHUAWEI;
  struct PhysicalDeviceSubpassShadingFeaturesHUAWEI;
  struct PhysicalDeviceSubpassShadingPropertiesHUAWEI;

  //=== VK_HUAWEI_invocation_mask ===
  struct PhysicalDeviceInvocationMaskFeaturesHUAWEI;

  //=== VK_NV_external_memory_rdma ===
  struct MemoryGetRemoteAddressInfoNV;
  struct PhysicalDeviceExternalMemoryRDMAFeaturesNV;

  //=== VK_EXT_pipeline_properties ===
  struct PipelinePropertiesIdentifierEXT;
  struct PhysicalDevicePipelinePropertiesFeaturesEXT;

  //=== VK_EXT_frame_boundary ===
  struct PhysicalDeviceFrameBoundaryFeaturesEXT;
  struct FrameBoundaryEXT;

  //=== VK_EXT_multisampled_render_to_single_sampled ===
  struct PhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT;
  struct SubpassResolvePerformanceQueryEXT;
  struct MultisampledRenderToSingleSampledInfoEXT;

  //=== VK_EXT_extended_dynamic_state2 ===
  struct PhysicalDeviceExtendedDynamicState2FeaturesEXT;

#if defined( VK_USE_PLATFORM_SCREEN_QNX )
  //=== VK_QNX_screen_surface ===
  struct ScreenSurfaceCreateInfoQNX;
#endif /*VK_USE_PLATFORM_SCREEN_QNX*/

  //=== VK_EXT_color_write_enable ===
  struct PhysicalDeviceColorWriteEnableFeaturesEXT;
  struct PipelineColorWriteCreateInfoEXT;

  //=== VK_EXT_primitives_generated_query ===
  struct PhysicalDevicePrimitivesGeneratedQueryFeaturesEXT;

  //=== VK_KHR_ray_tracing_maintenance1 ===
  struct PhysicalDeviceRayTracingMaintenance1FeaturesKHR;
  struct TraceRaysIndirectCommand2KHR;

  //=== VK_KHR_shader_untyped_pointers ===
  struct PhysicalDeviceShaderUntypedPointersFeaturesKHR;

  //=== VK_VALVE_video_encode_rgb_conversion ===
  struct PhysicalDeviceVideoEncodeRgbConversionFeaturesVALVE;
  struct VideoEncodeRgbConversionCapabilitiesVALVE;
  struct VideoEncodeProfileRgbConversionInfoVALVE;
  struct VideoEncodeSessionRgbConversionCreateInfoVALVE;

  //=== VK_EXT_image_view_min_lod ===
  struct PhysicalDeviceImageViewMinLodFeaturesEXT;
  struct ImageViewMinLodCreateInfoEXT;

  //=== VK_EXT_multi_draw ===
  struct PhysicalDeviceMultiDrawFeaturesEXT;
  struct PhysicalDeviceMultiDrawPropertiesEXT;
  struct MultiDrawInfoEXT;
  struct MultiDrawIndexedInfoEXT;

  //=== VK_EXT_image_2d_view_of_3d ===
  struct PhysicalDeviceImage2DViewOf3DFeaturesEXT;

  //=== VK_EXT_shader_tile_image ===
  struct PhysicalDeviceShaderTileImageFeaturesEXT;
  struct PhysicalDeviceShaderTileImagePropertiesEXT;

  //=== VK_EXT_opacity_micromap ===
  struct MicromapBuildInfoEXT;
  struct MicromapUsageEXT;
  struct MicromapCreateInfoEXT;
  struct PhysicalDeviceOpacityMicromapFeaturesEXT;
  struct PhysicalDeviceOpacityMicromapPropertiesEXT;
  struct MicromapVersionInfoEXT;
  struct CopyMicromapToMemoryInfoEXT;
  struct CopyMemoryToMicromapInfoEXT;
  struct CopyMicromapInfoEXT;
  struct MicromapBuildSizesInfoEXT;
  struct AccelerationStructureTrianglesOpacityMicromapEXT;
  struct MicromapTriangleEXT;

#if defined( VK_ENABLE_BETA_EXTENSIONS )
  //=== VK_NV_displacement_micromap ===
  struct PhysicalDeviceDisplacementMicromapFeaturesNV;
  struct PhysicalDeviceDisplacementMicromapPropertiesNV;
  struct AccelerationStructureTrianglesDisplacementMicromapNV;
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

  //=== VK_HUAWEI_cluster_culling_shader ===
  struct PhysicalDeviceClusterCullingShaderFeaturesHUAWEI;
  struct PhysicalDeviceClusterCullingShaderPropertiesHUAWEI;
  struct PhysicalDeviceClusterCullingShaderVrsFeaturesHUAWEI;

  //=== VK_EXT_border_color_swizzle ===
  struct PhysicalDeviceBorderColorSwizzleFeaturesEXT;
  struct SamplerBorderColorComponentMappingCreateInfoEXT;

  //=== VK_EXT_pageable_device_local_memory ===
  struct PhysicalDevicePageableDeviceLocalMemoryFeaturesEXT;

  //=== VK_ARM_shader_core_properties ===
  struct PhysicalDeviceShaderCorePropertiesARM;

  //=== VK_ARM_scheduling_controls ===
  struct DeviceQueueShaderCoreControlCreateInfoARM;
  struct PhysicalDeviceSchedulingControlsFeaturesARM;
  struct PhysicalDeviceSchedulingControlsPropertiesARM;

  //=== VK_EXT_image_sliced_view_of_3d ===
  struct PhysicalDeviceImageSlicedViewOf3DFeaturesEXT;
  struct ImageViewSlicedCreateInfoEXT;

  //=== VK_VALVE_descriptor_set_host_mapping ===
  struct PhysicalDeviceDescriptorSetHostMappingFeaturesVALVE;
  struct DescriptorSetBindingReferenceVALVE;
  struct DescriptorSetLayoutHostMappingInfoVALVE;

  //=== VK_EXT_non_seamless_cube_map ===
  struct PhysicalDeviceNonSeamlessCubeMapFeaturesEXT;

  //=== VK_ARM_render_pass_striped ===
  struct PhysicalDeviceRenderPassStripedFeaturesARM;
  struct PhysicalDeviceRenderPassStripedPropertiesARM;
  struct RenderPassStripeBeginInfoARM;
  struct RenderPassStripeInfoARM;
  struct RenderPassStripeSubmitInfoARM;

  //=== VK_NV_copy_memory_indirect ===
  struct PhysicalDeviceCopyMemoryIndirectFeaturesNV;

  //=== VK_NV_memory_decompression ===
  struct DecompressMemoryRegionNV;

  //=== VK_NV_device_generated_commands_compute ===
  struct PhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV;
  struct ComputePipelineIndirectBufferInfoNV;
  struct PipelineIndirectDeviceAddressInfoNV;
  struct BindPipelineIndirectCommandNV;

  //=== VK_NV_ray_tracing_linear_swept_spheres ===
  struct PhysicalDeviceRayTracingLinearSweptSpheresFeaturesNV;
  struct AccelerationStructureGeometryLinearSweptSpheresDataNV;
  struct AccelerationStructureGeometrySpheresDataNV;

  //=== VK_NV_linear_color_attachment ===
  struct PhysicalDeviceLinearColorAttachmentFeaturesNV;

  //=== VK_KHR_shader_maximal_reconvergence ===
  struct PhysicalDeviceShaderMaximalReconvergenceFeaturesKHR;

  //=== VK_EXT_image_compression_control_swapchain ===
  struct PhysicalDeviceImageCompressionControlSwapchainFeaturesEXT;

  //=== VK_QCOM_image_processing ===
  struct ImageViewSampleWeightCreateInfoQCOM;
  struct PhysicalDeviceImageProcessingFeaturesQCOM;
  struct PhysicalDeviceImageProcessingPropertiesQCOM;

  //=== VK_EXT_nested_command_buffer ===
  struct PhysicalDeviceNestedCommandBufferFeaturesEXT;
  struct PhysicalDeviceNestedCommandBufferPropertiesEXT;

#if defined( VK_USE_PLATFORM_OHOS )
  //=== VK_OHOS_external_memory ===
  struct NativeBufferUsageOHOS;
  struct NativeBufferPropertiesOHOS;
  struct NativeBufferFormatPropertiesOHOS;
  struct ImportNativeBufferInfoOHOS;
  struct MemoryGetNativeBufferInfoOHOS;
  struct ExternalFormatOHOS;
#endif /*VK_USE_PLATFORM_OHOS*/

  //=== VK_EXT_external_memory_acquire_unmodified ===
  struct ExternalMemoryAcquireUnmodifiedEXT;

  //=== VK_EXT_extended_dynamic_state3 ===
  struct PhysicalDeviceExtendedDynamicState3FeaturesEXT;
  struct PhysicalDeviceExtendedDynamicState3PropertiesEXT;
  struct ColorBlendEquationEXT;
  struct ColorBlendAdvancedEXT;

  //=== VK_EXT_subpass_merge_feedback ===
  struct PhysicalDeviceSubpassMergeFeedbackFeaturesEXT;
  struct RenderPassCreationControlEXT;
  struct RenderPassCreationFeedbackInfoEXT;
  struct RenderPassCreationFeedbackCreateInfoEXT;
  struct RenderPassSubpassFeedbackInfoEXT;
  struct RenderPassSubpassFeedbackCreateInfoEXT;

  //=== VK_LUNARG_direct_driver_loading ===
  struct DirectDriverLoadingInfoLUNARG;
  struct DirectDriverLoadingListLUNARG;

  //=== VK_ARM_tensors ===
  struct TensorDescriptionARM;
  struct TensorCreateInfoARM;
  struct TensorMemoryRequirementsInfoARM;
  struct BindTensorMemoryInfoARM;
  struct WriteDescriptorSetTensorARM;
  struct TensorFormatPropertiesARM;
  struct PhysicalDeviceTensorPropertiesARM;
  struct TensorMemoryBarrierARM;
  struct TensorDependencyInfoARM;
  struct PhysicalDeviceTensorFeaturesARM;
  struct DeviceTensorMemoryRequirementsARM;
  struct CopyTensorInfoARM;
  struct TensorCopyARM;
  struct MemoryDedicatedAllocateInfoTensorARM;
  struct PhysicalDeviceExternalTensorInfoARM;
  struct ExternalTensorPropertiesARM;
  struct ExternalMemoryTensorCreateInfoARM;
  struct PhysicalDeviceDescriptorBufferTensorFeaturesARM;
  struct PhysicalDeviceDescriptorBufferTensorPropertiesARM;
  struct DescriptorGetTensorInfoARM;
  struct TensorCaptureDescriptorDataInfoARM;
  struct TensorViewCaptureDescriptorDataInfoARM;
  struct FrameBoundaryTensorsARM;

  //=== VK_EXT_shader_module_identifier ===
  struct PhysicalDeviceShaderModuleIdentifierFeaturesEXT;
  struct PhysicalDeviceShaderModuleIdentifierPropertiesEXT;
  struct PipelineShaderStageModuleIdentifierCreateInfoEXT;
  struct ShaderModuleIdentifierEXT;

  //=== VK_EXT_rasterization_order_attachment_access ===
  struct PhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT;
  using PhysicalDeviceRasterizationOrderAttachmentAccessFeaturesARM = PhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT;

  //=== VK_NV_optical_flow ===
  struct PhysicalDeviceOpticalFlowFeaturesNV;
  struct PhysicalDeviceOpticalFlowPropertiesNV;
  struct OpticalFlowImageFormatInfoNV;
  struct OpticalFlowImageFormatPropertiesNV;
  struct OpticalFlowSessionCreateInfoNV;
  struct OpticalFlowSessionCreatePrivateDataInfoNV;
  struct OpticalFlowExecuteInfoNV;

  //=== VK_EXT_legacy_dithering ===
  struct PhysicalDeviceLegacyDitheringFeaturesEXT;

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  //=== VK_ANDROID_external_format_resolve ===
  struct PhysicalDeviceExternalFormatResolveFeaturesANDROID;
  struct PhysicalDeviceExternalFormatResolvePropertiesANDROID;
  struct AndroidHardwareBufferFormatResolvePropertiesANDROID;
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

  //=== VK_AMD_anti_lag ===
  struct PhysicalDeviceAntiLagFeaturesAMD;
  struct AntiLagDataAMD;
  struct AntiLagPresentationInfoAMD;

#if defined( VK_ENABLE_BETA_EXTENSIONS )
  //=== VK_AMDX_dense_geometry_format ===
  struct PhysicalDeviceDenseGeometryFormatFeaturesAMDX;
  struct AccelerationStructureDenseGeometryFormatTrianglesDataAMDX;
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

  //=== VK_KHR_present_id2 ===
  struct SurfaceCapabilitiesPresentId2KHR;
  struct PresentId2KHR;
  struct PhysicalDevicePresentId2FeaturesKHR;

  //=== VK_KHR_present_wait2 ===
  struct SurfaceCapabilitiesPresentWait2KHR;
  struct PhysicalDevicePresentWait2FeaturesKHR;
  struct PresentWait2InfoKHR;

  //=== VK_KHR_ray_tracing_position_fetch ===
  struct PhysicalDeviceRayTracingPositionFetchFeaturesKHR;

  //=== VK_EXT_shader_object ===
  struct PhysicalDeviceShaderObjectFeaturesEXT;
  struct PhysicalDeviceShaderObjectPropertiesEXT;
  struct ShaderCreateInfoEXT;

  //=== VK_KHR_pipeline_binary ===
  struct PhysicalDevicePipelineBinaryFeaturesKHR;
  struct PhysicalDevicePipelineBinaryPropertiesKHR;
  struct DevicePipelineBinaryInternalCacheControlKHR;
  struct PipelineBinaryKeyKHR;
  struct PipelineBinaryDataKHR;
  struct PipelineBinaryKeysAndDataKHR;
  struct PipelineBinaryCreateInfoKHR;
  struct PipelineBinaryInfoKHR;
  struct ReleaseCapturedPipelineDataInfoKHR;
  struct PipelineBinaryDataInfoKHR;
  struct PipelineCreateInfoKHR;
  struct PipelineBinaryHandlesInfoKHR;

  //=== VK_QCOM_tile_properties ===
  struct PhysicalDeviceTilePropertiesFeaturesQCOM;
  struct TilePropertiesQCOM;

  //=== VK_SEC_amigo_profiling ===
  struct PhysicalDeviceAmigoProfilingFeaturesSEC;
  struct AmigoProfilingSubmitInfoSEC;

  //=== VK_KHR_surface_maintenance1 ===
  struct SurfacePresentModeKHR;
  using SurfacePresentModeEXT = SurfacePresentModeKHR;
  struct SurfacePresentScalingCapabilitiesKHR;
  using SurfacePresentScalingCapabilitiesEXT = SurfacePresentScalingCapabilitiesKHR;
  struct SurfacePresentModeCompatibilityKHR;
  using SurfacePresentModeCompatibilityEXT = SurfacePresentModeCompatibilityKHR;

  //=== VK_KHR_swapchain_maintenance1 ===
  struct PhysicalDeviceSwapchainMaintenance1FeaturesKHR;
  using PhysicalDeviceSwapchainMaintenance1FeaturesEXT = PhysicalDeviceSwapchainMaintenance1FeaturesKHR;
  struct SwapchainPresentFenceInfoKHR;
  using SwapchainPresentFenceInfoEXT = SwapchainPresentFenceInfoKHR;
  struct SwapchainPresentModesCreateInfoKHR;
  using SwapchainPresentModesCreateInfoEXT = SwapchainPresentModesCreateInfoKHR;
  struct SwapchainPresentModeInfoKHR;
  using SwapchainPresentModeInfoEXT = SwapchainPresentModeInfoKHR;
  struct SwapchainPresentScalingCreateInfoKHR;
  using SwapchainPresentScalingCreateInfoEXT = SwapchainPresentScalingCreateInfoKHR;
  struct ReleaseSwapchainImagesInfoKHR;
  using ReleaseSwapchainImagesInfoEXT = ReleaseSwapchainImagesInfoKHR;

  //=== VK_QCOM_multiview_per_view_viewports ===
  struct PhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM;

  //=== VK_NV_ray_tracing_invocation_reorder ===
  struct PhysicalDeviceRayTracingInvocationReorderPropertiesNV;
  struct PhysicalDeviceRayTracingInvocationReorderFeaturesNV;

  //=== VK_NV_cooperative_vector ===
  struct PhysicalDeviceCooperativeVectorPropertiesNV;
  struct PhysicalDeviceCooperativeVectorFeaturesNV;
  struct CooperativeVectorPropertiesNV;
  struct ConvertCooperativeVectorMatrixInfoNV;

  //=== VK_NV_extended_sparse_address_space ===
  struct PhysicalDeviceExtendedSparseAddressSpaceFeaturesNV;
  struct PhysicalDeviceExtendedSparseAddressSpacePropertiesNV;

  //=== VK_EXT_mutable_descriptor_type ===
  struct PhysicalDeviceMutableDescriptorTypeFeaturesEXT;
  using PhysicalDeviceMutableDescriptorTypeFeaturesVALVE = PhysicalDeviceMutableDescriptorTypeFeaturesEXT;
  struct MutableDescriptorTypeListEXT;
  using MutableDescriptorTypeListVALVE = MutableDescriptorTypeListEXT;
  struct MutableDescriptorTypeCreateInfoEXT;
  using MutableDescriptorTypeCreateInfoVALVE = MutableDescriptorTypeCreateInfoEXT;

  //=== VK_EXT_legacy_vertex_attributes ===
  struct PhysicalDeviceLegacyVertexAttributesFeaturesEXT;
  struct PhysicalDeviceLegacyVertexAttributesPropertiesEXT;

  //=== VK_EXT_layer_settings ===
  struct LayerSettingsCreateInfoEXT;
  struct LayerSettingEXT;

  //=== VK_ARM_shader_core_builtins ===
  struct PhysicalDeviceShaderCoreBuiltinsFeaturesARM;
  struct PhysicalDeviceShaderCoreBuiltinsPropertiesARM;

  //=== VK_EXT_pipeline_library_group_handles ===
  struct PhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT;

  //=== VK_EXT_dynamic_rendering_unused_attachments ===
  struct PhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT;

  //=== VK_KHR_internally_synchronized_queues ===
  struct PhysicalDeviceInternallySynchronizedQueuesFeaturesKHR;

  //=== VK_NV_low_latency2 ===
  struct LatencySleepModeInfoNV;
  struct LatencySleepInfoNV;
  struct SetLatencyMarkerInfoNV;
  struct GetLatencyMarkerInfoNV;
  struct LatencyTimingsFrameReportNV;
  struct LatencySubmissionPresentIdNV;
  struct SwapchainLatencyCreateInfoNV;
  struct OutOfBandQueueTypeInfoNV;
  struct LatencySurfaceCapabilitiesNV;

  //=== VK_KHR_cooperative_matrix ===
  struct CooperativeMatrixPropertiesKHR;
  struct PhysicalDeviceCooperativeMatrixFeaturesKHR;
  struct PhysicalDeviceCooperativeMatrixPropertiesKHR;

  //=== VK_ARM_data_graph ===
  struct PhysicalDeviceDataGraphFeaturesARM;
  struct DataGraphPipelineConstantARM;
  struct DataGraphPipelineResourceInfoARM;
  struct DataGraphPipelineCompilerControlCreateInfoARM;
  struct DataGraphPipelineCreateInfoARM;
  struct DataGraphPipelineShaderModuleCreateInfoARM;
  struct DataGraphPipelineSessionCreateInfoARM;
  struct DataGraphPipelineSessionBindPointRequirementsInfoARM;
  struct DataGraphPipelineSessionBindPointRequirementARM;
  struct DataGraphPipelineSessionMemoryRequirementsInfoARM;
  struct BindDataGraphPipelineSessionMemoryInfoARM;
  struct DataGraphPipelineInfoARM;
  struct DataGraphPipelinePropertyQueryResultARM;
  struct DataGraphPipelineIdentifierCreateInfoARM;
  struct DataGraphPipelineDispatchInfoARM;
  struct PhysicalDeviceDataGraphProcessingEngineARM;
  struct QueueFamilyDataGraphPropertiesARM;
  struct DataGraphProcessingEngineCreateInfoARM;
  struct PhysicalDeviceQueueFamilyDataGraphProcessingEngineInfoARM;
  struct QueueFamilyDataGraphProcessingEnginePropertiesARM;
  struct PhysicalDeviceDataGraphOperationSupportARM;
  struct DataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM;

  //=== VK_QCOM_multiview_per_view_render_areas ===
  struct PhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM;
  struct MultiviewPerViewRenderAreasRenderPassBeginInfoQCOM;

  //=== VK_KHR_compute_shader_derivatives ===
  struct PhysicalDeviceComputeShaderDerivativesFeaturesKHR;
  using PhysicalDeviceComputeShaderDerivativesFeaturesNV = PhysicalDeviceComputeShaderDerivativesFeaturesKHR;
  struct PhysicalDeviceComputeShaderDerivativesPropertiesKHR;

  //=== VK_KHR_video_decode_av1 ===
  struct VideoDecodeAV1ProfileInfoKHR;
  struct VideoDecodeAV1CapabilitiesKHR;
  struct VideoDecodeAV1SessionParametersCreateInfoKHR;
  struct VideoDecodeAV1PictureInfoKHR;
  struct VideoDecodeAV1DpbSlotInfoKHR;

  //=== VK_KHR_video_encode_av1 ===
  struct PhysicalDeviceVideoEncodeAV1FeaturesKHR;
  struct VideoEncodeAV1CapabilitiesKHR;
  struct VideoEncodeAV1QualityLevelPropertiesKHR;
  struct VideoEncodeAV1SessionCreateInfoKHR;
  struct VideoEncodeAV1SessionParametersCreateInfoKHR;
  struct VideoEncodeAV1PictureInfoKHR;
  struct VideoEncodeAV1DpbSlotInfoKHR;
  struct VideoEncodeAV1ProfileInfoKHR;
  struct VideoEncodeAV1QIndexKHR;
  struct VideoEncodeAV1FrameSizeKHR;
  struct VideoEncodeAV1GopRemainingFrameInfoKHR;
  struct VideoEncodeAV1RateControlInfoKHR;
  struct VideoEncodeAV1RateControlLayerInfoKHR;

  //=== VK_KHR_video_decode_vp9 ===
  struct PhysicalDeviceVideoDecodeVP9FeaturesKHR;
  struct VideoDecodeVP9ProfileInfoKHR;
  struct VideoDecodeVP9CapabilitiesKHR;
  struct VideoDecodeVP9PictureInfoKHR;

  //=== VK_KHR_video_maintenance1 ===
  struct PhysicalDeviceVideoMaintenance1FeaturesKHR;
  struct VideoInlineQueryInfoKHR;

  //=== VK_NV_per_stage_descriptor_set ===
  struct PhysicalDevicePerStageDescriptorSetFeaturesNV;

  //=== VK_QCOM_image_processing2 ===
  struct PhysicalDeviceImageProcessing2FeaturesQCOM;
  struct PhysicalDeviceImageProcessing2PropertiesQCOM;
  struct SamplerBlockMatchWindowCreateInfoQCOM;

  //=== VK_QCOM_filter_cubic_weights ===
  struct PhysicalDeviceCubicWeightsFeaturesQCOM;
  struct SamplerCubicWeightsCreateInfoQCOM;
  struct BlitImageCubicWeightsInfoQCOM;

  //=== VK_QCOM_ycbcr_degamma ===
  struct PhysicalDeviceYcbcrDegammaFeaturesQCOM;
  struct SamplerYcbcrConversionYcbcrDegammaCreateInfoQCOM;

  //=== VK_QCOM_filter_cubic_clamp ===
  struct PhysicalDeviceCubicClampFeaturesQCOM;

  //=== VK_EXT_attachment_feedback_loop_dynamic_state ===
  struct PhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT;

  //=== VK_KHR_unified_image_layouts ===
  struct PhysicalDeviceUnifiedImageLayoutsFeaturesKHR;
  struct AttachmentFeedbackLoopInfoEXT;

#if defined( VK_USE_PLATFORM_SCREEN_QNX )
  //=== VK_QNX_external_memory_screen_buffer ===
  struct ScreenBufferPropertiesQNX;
  struct ScreenBufferFormatPropertiesQNX;
  struct ImportScreenBufferInfoQNX;
  struct ExternalFormatQNX;
  struct PhysicalDeviceExternalMemoryScreenBufferFeaturesQNX;
#endif /*VK_USE_PLATFORM_SCREEN_QNX*/

  //=== VK_MSFT_layered_driver ===
  struct PhysicalDeviceLayeredDriverPropertiesMSFT;

  //=== VK_KHR_calibrated_timestamps ===
  struct CalibratedTimestampInfoKHR;
  using CalibratedTimestampInfoEXT = CalibratedTimestampInfoKHR;

  //=== VK_KHR_maintenance6 ===
  struct SetDescriptorBufferOffsetsInfoEXT;
  struct BindDescriptorBufferEmbeddedSamplersInfoEXT;

  //=== VK_NV_descriptor_pool_overallocation ===
  struct PhysicalDeviceDescriptorPoolOverallocationFeaturesNV;

  //=== VK_QCOM_tile_memory_heap ===
  struct PhysicalDeviceTileMemoryHeapFeaturesQCOM;
  struct PhysicalDeviceTileMemoryHeapPropertiesQCOM;
  struct TileMemoryRequirementsQCOM;
  struct TileMemoryBindInfoQCOM;
  struct TileMemorySizeInfoQCOM;

  //=== VK_KHR_copy_memory_indirect ===
  struct StridedDeviceAddressRangeKHR;
  struct CopyMemoryIndirectCommandKHR;
  using CopyMemoryIndirectCommandNV = CopyMemoryIndirectCommandKHR;
  struct CopyMemoryIndirectInfoKHR;
  struct CopyMemoryToImageIndirectCommandKHR;
  using CopyMemoryToImageIndirectCommandNV = CopyMemoryToImageIndirectCommandKHR;
  struct CopyMemoryToImageIndirectInfoKHR;
  struct PhysicalDeviceCopyMemoryIndirectFeaturesKHR;
  struct PhysicalDeviceCopyMemoryIndirectPropertiesKHR;
  using PhysicalDeviceCopyMemoryIndirectPropertiesNV = PhysicalDeviceCopyMemoryIndirectPropertiesKHR;

  //=== VK_EXT_memory_decompression ===
  struct DecompressMemoryInfoEXT;
  struct DecompressMemoryRegionEXT;
  struct PhysicalDeviceMemoryDecompressionFeaturesEXT;
  using PhysicalDeviceMemoryDecompressionFeaturesNV = PhysicalDeviceMemoryDecompressionFeaturesEXT;
  struct PhysicalDeviceMemoryDecompressionPropertiesEXT;
  using PhysicalDeviceMemoryDecompressionPropertiesNV = PhysicalDeviceMemoryDecompressionPropertiesEXT;

  //=== VK_NV_display_stereo ===
  struct DisplaySurfaceStereoCreateInfoNV;
  struct DisplayModeStereoPropertiesNV;

  //=== VK_KHR_video_encode_intra_refresh ===
  struct VideoEncodeIntraRefreshCapabilitiesKHR;
  struct VideoEncodeSessionIntraRefreshCreateInfoKHR;
  struct VideoEncodeIntraRefreshInfoKHR;
  struct VideoReferenceIntraRefreshInfoKHR;
  struct PhysicalDeviceVideoEncodeIntraRefreshFeaturesKHR;

  //=== VK_KHR_video_encode_quantization_map ===
  struct VideoEncodeQuantizationMapCapabilitiesKHR;
  struct VideoFormatQuantizationMapPropertiesKHR;
  struct VideoEncodeQuantizationMapInfoKHR;
  struct VideoEncodeQuantizationMapSessionParametersCreateInfoKHR;
  struct PhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR;
  struct VideoEncodeH264QuantizationMapCapabilitiesKHR;
  struct VideoEncodeH265QuantizationMapCapabilitiesKHR;
  struct VideoFormatH265QuantizationMapPropertiesKHR;
  struct VideoEncodeAV1QuantizationMapCapabilitiesKHR;
  struct VideoFormatAV1QuantizationMapPropertiesKHR;

  //=== VK_NV_raw_access_chains ===
  struct PhysicalDeviceRawAccessChainsFeaturesNV;

  //=== VK_NV_external_compute_queue ===
  struct ExternalComputeQueueDeviceCreateInfoNV;
  struct ExternalComputeQueueCreateInfoNV;
  struct ExternalComputeQueueDataParamsNV;
  struct PhysicalDeviceExternalComputeQueuePropertiesNV;

  //=== VK_KHR_shader_relaxed_extended_instruction ===
  struct PhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR;

  //=== VK_NV_command_buffer_inheritance ===
  struct PhysicalDeviceCommandBufferInheritanceFeaturesNV;

  //=== VK_KHR_maintenance7 ===
  struct PhysicalDeviceMaintenance7FeaturesKHR;
  struct PhysicalDeviceMaintenance7PropertiesKHR;
  struct PhysicalDeviceLayeredApiPropertiesListKHR;
  struct PhysicalDeviceLayeredApiPropertiesKHR;
  struct PhysicalDeviceLayeredApiVulkanPropertiesKHR;

  //=== VK_NV_shader_atomic_float16_vector ===
  struct PhysicalDeviceShaderAtomicFloat16VectorFeaturesNV;

  //=== VK_EXT_shader_replicated_composites ===
  struct PhysicalDeviceShaderReplicatedCompositesFeaturesEXT;

  //=== VK_EXT_shader_float8 ===
  struct PhysicalDeviceShaderFloat8FeaturesEXT;

  //=== VK_NV_ray_tracing_validation ===
  struct PhysicalDeviceRayTracingValidationFeaturesNV;

  //=== VK_NV_cluster_acceleration_structure ===
  struct PhysicalDeviceClusterAccelerationStructureFeaturesNV;
  struct PhysicalDeviceClusterAccelerationStructurePropertiesNV;
  struct ClusterAccelerationStructureClustersBottomLevelInputNV;
  struct ClusterAccelerationStructureTriangleClusterInputNV;
  struct ClusterAccelerationStructureMoveObjectsInputNV;
  union ClusterAccelerationStructureOpInputNV;
  struct ClusterAccelerationStructureInputInfoNV;
  struct ClusterAccelerationStructureCommandsInfoNV;
  struct StridedDeviceAddressNV;
  struct ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV;
  struct ClusterAccelerationStructureMoveObjectsInfoNV;
  struct ClusterAccelerationStructureBuildClustersBottomLevelInfoNV;
  struct ClusterAccelerationStructureBuildTriangleClusterInfoNV;
  struct ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV;
  struct ClusterAccelerationStructureInstantiateClusterInfoNV;
  struct ClusterAccelerationStructureGetTemplateIndicesInfoNV;
  struct RayTracingPipelineClusterAccelerationStructureCreateInfoNV;

  //=== VK_NV_partitioned_acceleration_structure ===
  struct PhysicalDevicePartitionedAccelerationStructureFeaturesNV;
  struct PhysicalDevicePartitionedAccelerationStructurePropertiesNV;
  struct PartitionedAccelerationStructureFlagsNV;
  struct BuildPartitionedAccelerationStructureIndirectCommandNV;
  struct PartitionedAccelerationStructureWriteInstanceDataNV;
  struct PartitionedAccelerationStructureUpdateInstanceDataNV;
  struct PartitionedAccelerationStructureWritePartitionTranslationDataNV;
  struct WriteDescriptorSetPartitionedAccelerationStructureNV;
  struct PartitionedAccelerationStructureInstancesInputNV;
  struct BuildPartitionedAccelerationStructureInfoNV;

  //=== VK_EXT_device_generated_commands ===
  struct PhysicalDeviceDeviceGeneratedCommandsFeaturesEXT;
  struct PhysicalDeviceDeviceGeneratedCommandsPropertiesEXT;
  struct GeneratedCommandsMemoryRequirementsInfoEXT;
  struct IndirectExecutionSetCreateInfoEXT;
  union IndirectExecutionSetInfoEXT;
  struct IndirectExecutionSetPipelineInfoEXT;
  struct IndirectExecutionSetShaderInfoEXT;
  struct GeneratedCommandsInfoEXT;
  struct WriteIndirectExecutionSetPipelineEXT;
  struct IndirectCommandsLayoutCreateInfoEXT;
  struct IndirectCommandsLayoutTokenEXT;
  struct DrawIndirectCountIndirectCommandEXT;
  struct IndirectCommandsVertexBufferTokenEXT;
  struct BindVertexBufferIndirectCommandEXT;
  struct IndirectCommandsIndexBufferTokenEXT;
  struct BindIndexBufferIndirectCommandEXT;
  struct IndirectCommandsPushConstantTokenEXT;
  struct IndirectCommandsExecutionSetTokenEXT;
  union IndirectCommandsTokenDataEXT;
  struct IndirectExecutionSetShaderLayoutInfoEXT;
  struct GeneratedCommandsPipelineInfoEXT;
  struct GeneratedCommandsShaderInfoEXT;
  struct WriteIndirectExecutionSetShaderEXT;

  //=== VK_KHR_maintenance8 ===
  struct MemoryBarrierAccessFlags3KHR;
  struct PhysicalDeviceMaintenance8FeaturesKHR;

  //=== VK_MESA_image_alignment_control ===
  struct PhysicalDeviceImageAlignmentControlFeaturesMESA;
  struct PhysicalDeviceImageAlignmentControlPropertiesMESA;
  struct ImageAlignmentControlCreateInfoMESA;

  //=== VK_KHR_shader_fma ===
  struct PhysicalDeviceShaderFmaFeaturesKHR;

  //=== VK_NV_push_constant_bank ===
  struct PushConstantBankInfoNV;
  struct PhysicalDevicePushConstantBankFeaturesNV;
  struct PhysicalDevicePushConstantBankPropertiesNV;

  //=== VK_EXT_ray_tracing_invocation_reorder ===
  struct PhysicalDeviceRayTracingInvocationReorderPropertiesEXT;
  struct PhysicalDeviceRayTracingInvocationReorderFeaturesEXT;

  //=== VK_EXT_depth_clamp_control ===
  struct PhysicalDeviceDepthClampControlFeaturesEXT;
  struct PipelineViewportDepthClampControlCreateInfoEXT;
  struct DepthClampRangeEXT;

  //=== VK_KHR_maintenance9 ===
  struct PhysicalDeviceMaintenance9FeaturesKHR;
  struct PhysicalDeviceMaintenance9PropertiesKHR;
  struct QueueFamilyOwnershipTransferPropertiesKHR;

  //=== VK_KHR_video_maintenance2 ===
  struct PhysicalDeviceVideoMaintenance2FeaturesKHR;
  struct VideoDecodeH264InlineSessionParametersInfoKHR;
  struct VideoDecodeH265InlineSessionParametersInfoKHR;
  struct VideoDecodeAV1InlineSessionParametersInfoKHR;

#if defined( VK_USE_PLATFORM_OHOS )
  //=== VK_OHOS_surface ===
  struct SurfaceCreateInfoOHOS;
#endif /*VK_USE_PLATFORM_OHOS*/

  //=== VK_HUAWEI_hdr_vivid ===
  struct PhysicalDeviceHdrVividFeaturesHUAWEI;
  struct HdrVividDynamicMetadataHUAWEI;

  //=== VK_NV_cooperative_matrix2 ===
  struct CooperativeMatrixFlexibleDimensionsPropertiesNV;
  struct PhysicalDeviceCooperativeMatrix2FeaturesNV;
  struct PhysicalDeviceCooperativeMatrix2PropertiesNV;

  //=== VK_ARM_pipeline_opacity_micromap ===
  struct PhysicalDevicePipelineOpacityMicromapFeaturesARM;

#if defined( VK_USE_PLATFORM_METAL_EXT )
  //=== VK_EXT_external_memory_metal ===
  struct ImportMemoryMetalHandleInfoEXT;
  struct MemoryMetalHandlePropertiesEXT;
  struct MemoryGetMetalHandleInfoEXT;
#endif /*VK_USE_PLATFORM_METAL_EXT*/

  //=== VK_KHR_depth_clamp_zero_one ===
  struct PhysicalDeviceDepthClampZeroOneFeaturesKHR;
  using PhysicalDeviceDepthClampZeroOneFeaturesEXT = PhysicalDeviceDepthClampZeroOneFeaturesKHR;

  //=== VK_ARM_performance_counters_by_region ===
  struct PhysicalDevicePerformanceCountersByRegionFeaturesARM;
  struct PhysicalDevicePerformanceCountersByRegionPropertiesARM;
  struct PerformanceCounterARM;
  struct PerformanceCounterDescriptionARM;
  struct RenderPassPerformanceCountersByRegionBeginInfoARM;

  //=== VK_EXT_vertex_attribute_robustness ===
  struct PhysicalDeviceVertexAttributeRobustnessFeaturesEXT;

  //=== VK_ARM_format_pack ===
  struct PhysicalDeviceFormatPackFeaturesARM;

  //=== VK_VALVE_fragment_density_map_layered ===
  struct PhysicalDeviceFragmentDensityMapLayeredFeaturesVALVE;
  struct PhysicalDeviceFragmentDensityMapLayeredPropertiesVALVE;
  struct PipelineFragmentDensityMapLayeredCreateInfoVALVE;

  //=== VK_KHR_robustness2 ===
  struct PhysicalDeviceRobustness2FeaturesKHR;
  using PhysicalDeviceRobustness2FeaturesEXT = PhysicalDeviceRobustness2FeaturesKHR;
  struct PhysicalDeviceRobustness2PropertiesKHR;
  using PhysicalDeviceRobustness2PropertiesEXT = PhysicalDeviceRobustness2PropertiesKHR;

#if defined( VK_ENABLE_BETA_EXTENSIONS )
  //=== VK_NV_present_metering ===
  struct SetPresentConfigNV;
  struct PhysicalDevicePresentMeteringFeaturesNV;
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

  //=== VK_EXT_fragment_density_map_offset ===
  struct PhysicalDeviceFragmentDensityMapOffsetFeaturesEXT;
  using PhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM = PhysicalDeviceFragmentDensityMapOffsetFeaturesEXT;
  struct PhysicalDeviceFragmentDensityMapOffsetPropertiesEXT;
  using PhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM = PhysicalDeviceFragmentDensityMapOffsetPropertiesEXT;
  struct RenderPassFragmentDensityMapOffsetEndInfoEXT;
  using SubpassFragmentDensityMapOffsetEndInfoQCOM = RenderPassFragmentDensityMapOffsetEndInfoEXT;

  //=== VK_EXT_zero_initialize_device_memory ===
  struct PhysicalDeviceZeroInitializeDeviceMemoryFeaturesEXT;

  //=== VK_KHR_present_mode_fifo_latest_ready ===
  struct PhysicalDevicePresentModeFifoLatestReadyFeaturesKHR;
  using PhysicalDevicePresentModeFifoLatestReadyFeaturesEXT = PhysicalDevicePresentModeFifoLatestReadyFeaturesKHR;

  //=== VK_EXT_shader_64bit_indexing ===
  struct PhysicalDeviceShader64BitIndexingFeaturesEXT;

  //=== VK_EXT_custom_resolve ===
  struct PhysicalDeviceCustomResolveFeaturesEXT;
  struct BeginCustomResolveInfoEXT;
  struct CustomResolveCreateInfoEXT;

  //=== VK_QCOM_data_graph_model ===
  struct PipelineCacheHeaderVersionDataGraphQCOM;
  struct DataGraphPipelineBuiltinModelCreateInfoQCOM;
  struct PhysicalDeviceDataGraphModelFeaturesQCOM;

  //=== VK_KHR_maintenance10 ===
  struct PhysicalDeviceMaintenance10FeaturesKHR;
  struct PhysicalDeviceMaintenance10PropertiesKHR;
  struct RenderingEndInfoKHR;
  using RenderingEndInfoEXT = RenderingEndInfoKHR;
  struct RenderingAttachmentFlagsInfoKHR;
  struct ResolveImageModeInfoKHR;

  //=== VK_EXT_shader_long_vector ===
  struct PhysicalDeviceShaderLongVectorFeaturesEXT;
  struct PhysicalDeviceShaderLongVectorPropertiesEXT;

  //=== VK_SEC_pipeline_cache_incremental_mode ===
  struct PhysicalDevicePipelineCacheIncrementalModeFeaturesSEC;

  //=== VK_EXT_shader_uniform_buffer_unsized_array ===
  struct PhysicalDeviceShaderUniformBufferUnsizedArrayFeaturesEXT;

  //=== VK_NV_compute_occupancy_priority ===
  struct ComputeOccupancyPriorityParametersNV;
  struct PhysicalDeviceComputeOccupancyPriorityFeaturesNV;

  //=== VK_EXT_shader_subgroup_partitioned ===
  struct PhysicalDeviceShaderSubgroupPartitionedFeaturesEXT;

#if defined( VK_USE_PLATFORM_UBM_SEC )
  //=== VK_SEC_ubm_surface ===
  struct UbmSurfaceCreateInfoSEC;
#endif /*VK_USE_PLATFORM_UBM_SEC*/

  //=== VK_VALVE_shader_mixed_float_dot_product ===
  struct PhysicalDeviceShaderMixedFloatDotProductFeaturesVALVE;

  //===================================
  //=== HANDLE forward declarations ===
  //===================================

  //=== VK_VERSION_1_0 ===
  class Instance;
  class PhysicalDevice;
  class Device;
  class Queue;
  class DeviceMemory;
  class Fence;
  class Semaphore;
  class QueryPool;
  class Buffer;
  class Image;
  class ImageView;
  class CommandPool;
  class CommandBuffer;
  class Event;
  class BufferView;
  class ShaderModule;
  class PipelineCache;
  class Pipeline;
  class PipelineLayout;
  class Sampler;
  class DescriptorPool;
  class DescriptorSet;
  class DescriptorSetLayout;
  class Framebuffer;
  class RenderPass;

  //=== VK_VERSION_1_1 ===
  class DescriptorUpdateTemplate;
  class SamplerYcbcrConversion;

  //=== VK_VERSION_1_3 ===
  class PrivateDataSlot;

  //=== VK_KHR_surface ===
  class SurfaceKHR;

  //=== VK_KHR_swapchain ===
  class SwapchainKHR;

  //=== VK_KHR_display ===
  class DisplayKHR;
  class DisplayModeKHR;

  //=== VK_EXT_debug_report ===
  class DebugReportCallbackEXT;

  //=== VK_KHR_video_queue ===
  class VideoSessionKHR;
  class VideoSessionParametersKHR;

  //=== VK_NVX_binary_import ===
  class CuModuleNVX;
  class CuFunctionNVX;

  //=== VK_EXT_debug_utils ===
  class DebugUtilsMessengerEXT;

  //=== VK_EXT_descriptor_heap ===
  class TensorARM;

  //=== VK_KHR_acceleration_structure ===
  class AccelerationStructureKHR;

  //=== VK_EXT_validation_cache ===
  class ValidationCacheEXT;

  //=== VK_NV_ray_tracing ===
  class AccelerationStructureNV;

  //=== VK_INTEL_performance_query ===
  class PerformanceConfigurationINTEL;

  //=== VK_KHR_deferred_host_operations ===
  class DeferredOperationKHR;

  //=== VK_NV_device_generated_commands ===
  class IndirectCommandsLayoutNV;

#if defined( VK_ENABLE_BETA_EXTENSIONS )
  //=== VK_NV_cuda_kernel_launch ===
  class CudaModuleNV;
  class CudaFunctionNV;
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  //=== VK_FUCHSIA_buffer_collection ===
  class BufferCollectionFUCHSIA;
#endif /*VK_USE_PLATFORM_FUCHSIA*/

  //=== VK_EXT_opacity_micromap ===
  class MicromapEXT;

  //=== VK_ARM_tensors ===
  class TensorARM;
  class TensorViewARM;

  //=== VK_NV_optical_flow ===
  class OpticalFlowSessionNV;

  //=== VK_EXT_shader_object ===
  class ShaderEXT;

  //=== VK_KHR_pipeline_binary ===
  class PipelineBinaryKHR;

  //=== VK_ARM_data_graph ===
  class DataGraphPipelineSessionARM;

  //=== VK_NV_external_compute_queue ===
  class ExternalComputeQueueNV;

  //=== VK_EXT_device_generated_commands ===
  class IndirectCommandsLayoutEXT;
  class IndirectExecutionSetEXT;

  typedef void( VKAPI_PTR * PFN_VoidFunction )();

#ifndef VULKAN_HPP_NO_SMART_HANDLE
  //======================
  //=== UNIQUE HANDLEs ===
  //======================

  //=== VK_VERSION_1_0 ===
  template <typename Dispatch>
  class UniqueHandleTraits<Instance, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<detail::NoParent, Dispatch>;
  };

  using UniqueInstance = UniqueHandle<Instance, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<Device, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<detail::NoParent, Dispatch>;
  };

  using UniqueDevice = UniqueHandle<Device, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<DeviceMemory, Dispatch>
  {
  public:
    using deleter = detail::ObjectFree<Device, Dispatch>;
  };

  using UniqueDeviceMemory = UniqueHandle<DeviceMemory, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<Fence, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueFence = UniqueHandle<Fence, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<Semaphore, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueSemaphore = UniqueHandle<Semaphore, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<QueryPool, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueQueryPool = UniqueHandle<QueryPool, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<Buffer, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueBuffer = UniqueHandle<Buffer, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<Image, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueImage = UniqueHandle<Image, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<ImageView, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueImageView = UniqueHandle<ImageView, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<CommandPool, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueCommandPool = UniqueHandle<CommandPool, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<CommandBuffer, Dispatch>
  {
  public:
    using deleter = detail::PoolFree<Device, CommandPool, Dispatch>;
  };

  using UniqueCommandBuffer = UniqueHandle<CommandBuffer, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<Event, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueEvent = UniqueHandle<Event, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<BufferView, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueBufferView = UniqueHandle<BufferView, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<ShaderModule, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueShaderModule = UniqueHandle<ShaderModule, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<PipelineCache, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniquePipelineCache = UniqueHandle<PipelineCache, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<Pipeline, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniquePipeline = UniqueHandle<Pipeline, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<PipelineLayout, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniquePipelineLayout = UniqueHandle<PipelineLayout, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<Sampler, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueSampler = UniqueHandle<Sampler, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<DescriptorPool, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueDescriptorPool = UniqueHandle<DescriptorPool, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<DescriptorSet, Dispatch>
  {
  public:
    using deleter = detail::PoolFree<Device, DescriptorPool, Dispatch>;
  };

  using UniqueDescriptorSet = UniqueHandle<DescriptorSet, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<DescriptorSetLayout, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueDescriptorSetLayout = UniqueHandle<DescriptorSetLayout, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<Framebuffer, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueFramebuffer = UniqueHandle<Framebuffer, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<RenderPass, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueRenderPass = UniqueHandle<RenderPass, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_VERSION_1_1 ===
  template <typename Dispatch>
  class UniqueHandleTraits<DescriptorUpdateTemplate, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueDescriptorUpdateTemplate    = UniqueHandle<DescriptorUpdateTemplate, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;
  using UniqueDescriptorUpdateTemplateKHR = UniqueHandle<DescriptorUpdateTemplate, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<SamplerYcbcrConversion, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueSamplerYcbcrConversion    = UniqueHandle<SamplerYcbcrConversion, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;
  using UniqueSamplerYcbcrConversionKHR = UniqueHandle<SamplerYcbcrConversion, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_VERSION_1_3 ===
  template <typename Dispatch>
  class UniqueHandleTraits<PrivateDataSlot, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniquePrivateDataSlot    = UniqueHandle<PrivateDataSlot, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;
  using UniquePrivateDataSlotEXT = UniqueHandle<PrivateDataSlot, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_KHR_surface ===
  template <typename Dispatch>
  class UniqueHandleTraits<SurfaceKHR, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Instance, Dispatch>;
  };

  using UniqueSurfaceKHR = UniqueHandle<SurfaceKHR, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_KHR_swapchain ===
  template <typename Dispatch>
  class UniqueHandleTraits<SwapchainKHR, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueSwapchainKHR = UniqueHandle<SwapchainKHR, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_KHR_display ===
  template <typename Dispatch>
  class UniqueHandleTraits<DisplayKHR, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<PhysicalDevice, Dispatch>;
  };

  using UniqueDisplayKHR = UniqueHandle<DisplayKHR, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_EXT_debug_report ===
  template <typename Dispatch>
  class UniqueHandleTraits<DebugReportCallbackEXT, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Instance, Dispatch>;
  };

  using UniqueDebugReportCallbackEXT = UniqueHandle<DebugReportCallbackEXT, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_KHR_video_queue ===
  template <typename Dispatch>
  class UniqueHandleTraits<VideoSessionKHR, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueVideoSessionKHR = UniqueHandle<VideoSessionKHR, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<VideoSessionParametersKHR, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueVideoSessionParametersKHR = UniqueHandle<VideoSessionParametersKHR, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_NVX_binary_import ===
  template <typename Dispatch>
  class UniqueHandleTraits<CuModuleNVX, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueCuModuleNVX = UniqueHandle<CuModuleNVX, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<CuFunctionNVX, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueCuFunctionNVX = UniqueHandle<CuFunctionNVX, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_EXT_debug_utils ===
  template <typename Dispatch>
  class UniqueHandleTraits<DebugUtilsMessengerEXT, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Instance, Dispatch>;
  };

  using UniqueDebugUtilsMessengerEXT = UniqueHandle<DebugUtilsMessengerEXT, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_EXT_descriptor_heap ===
  template <typename Dispatch>
  class UniqueHandleTraits<TensorARM, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueTensorARM = UniqueHandle<TensorARM, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_KHR_acceleration_structure ===
  template <typename Dispatch>
  class UniqueHandleTraits<AccelerationStructureKHR, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueAccelerationStructureKHR = UniqueHandle<AccelerationStructureKHR, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_EXT_validation_cache ===
  template <typename Dispatch>
  class UniqueHandleTraits<ValidationCacheEXT, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueValidationCacheEXT = UniqueHandle<ValidationCacheEXT, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_NV_ray_tracing ===
  template <typename Dispatch>
  class UniqueHandleTraits<AccelerationStructureNV, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueAccelerationStructureNV = UniqueHandle<AccelerationStructureNV, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_INTEL_performance_query ===
  template <typename Dispatch>
  class UniqueHandleTraits<PerformanceConfigurationINTEL, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniquePerformanceConfigurationINTEL = UniqueHandle<PerformanceConfigurationINTEL, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_KHR_deferred_host_operations ===
  template <typename Dispatch>
  class UniqueHandleTraits<DeferredOperationKHR, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueDeferredOperationKHR = UniqueHandle<DeferredOperationKHR, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_NV_device_generated_commands ===
  template <typename Dispatch>
  class UniqueHandleTraits<IndirectCommandsLayoutNV, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueIndirectCommandsLayoutNV = UniqueHandle<IndirectCommandsLayoutNV, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

#  if defined( VK_ENABLE_BETA_EXTENSIONS )
  //=== VK_NV_cuda_kernel_launch ===
  template <typename Dispatch>
  class UniqueHandleTraits<CudaModuleNV, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueCudaModuleNV = UniqueHandle<CudaModuleNV, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<CudaFunctionNV, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueCudaFunctionNV = UniqueHandle<CudaFunctionNV, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;
#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

#  if defined( VK_USE_PLATFORM_FUCHSIA )
  //=== VK_FUCHSIA_buffer_collection ===
  template <typename Dispatch>
  class UniqueHandleTraits<BufferCollectionFUCHSIA, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueBufferCollectionFUCHSIA = UniqueHandle<BufferCollectionFUCHSIA, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

  //=== VK_EXT_opacity_micromap ===
  template <typename Dispatch>
  class UniqueHandleTraits<MicromapEXT, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueMicromapEXT = UniqueHandle<MicromapEXT, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_ARM_tensors ===
  template <typename Dispatch>
  class UniqueHandleTraits<TensorViewARM, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueTensorViewARM = UniqueHandle<TensorViewARM, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_NV_optical_flow ===
  template <typename Dispatch>
  class UniqueHandleTraits<OpticalFlowSessionNV, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueOpticalFlowSessionNV = UniqueHandle<OpticalFlowSessionNV, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_EXT_shader_object ===
  template <typename Dispatch>
  class UniqueHandleTraits<ShaderEXT, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueShaderEXT = UniqueHandle<ShaderEXT, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_KHR_pipeline_binary ===
  template <typename Dispatch>
  class UniqueHandleTraits<PipelineBinaryKHR, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniquePipelineBinaryKHR = UniqueHandle<PipelineBinaryKHR, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_ARM_data_graph ===
  template <typename Dispatch>
  class UniqueHandleTraits<DataGraphPipelineSessionARM, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueDataGraphPipelineSessionARM = UniqueHandle<DataGraphPipelineSessionARM, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_NV_external_compute_queue ===
  template <typename Dispatch>
  class UniqueHandleTraits<ExternalComputeQueueNV, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueExternalComputeQueueNV = UniqueHandle<ExternalComputeQueueNV, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  //=== VK_EXT_device_generated_commands ===
  template <typename Dispatch>
  class UniqueHandleTraits<IndirectCommandsLayoutEXT, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueIndirectCommandsLayoutEXT = UniqueHandle<IndirectCommandsLayoutEXT, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;

  template <typename Dispatch>
  class UniqueHandleTraits<IndirectExecutionSetEXT, Dispatch>
  {
  public:
    using deleter = detail::ObjectDestroy<Device, Dispatch>;
  };

  using UniqueIndirectExecutionSetEXT = UniqueHandle<IndirectExecutionSetEXT, VULKAN_HPP_DEFAULT_DISPATCHER_TYPE>;
#endif /*VULKAN_HPP_NO_SMART_HANDLE*/

  //===============
  //=== HANDLEs ===
  //===============

  template <typename Type>
  struct isVulkanHandleType
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = false;
  };

  // wrapper class for handle VkSurfaceKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSurfaceKHR.html
  class SurfaceKHR
  {
  public:
    using CType      = VkSurfaceKHR;
    using NativeType = VkSurfaceKHR;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eSurfaceKHR;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eSurfaceKHR;

  public:
    SurfaceKHR() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    SurfaceKHR( SurfaceKHR const & rhs )             = default;
    SurfaceKHR & operator=( SurfaceKHR const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    SurfaceKHR( SurfaceKHR && rhs )             = default;
    SurfaceKHR & operator=( SurfaceKHR && rhs ) = default;
#else
    SurfaceKHR( SurfaceKHR && rhs ) VULKAN_HPP_NOEXCEPT : m_surfaceKHR( exchange( rhs.m_surfaceKHR, {} ) ) {}

    SurfaceKHR & operator=( SurfaceKHR && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_surfaceKHR = exchange( rhs.m_surfaceKHR, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR SurfaceKHR( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT SurfaceKHR( VkSurfaceKHR surfaceKHR ) VULKAN_HPP_NOEXCEPT : m_surfaceKHR( surfaceKHR ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    SurfaceKHR & operator=( VkSurfaceKHR surfaceKHR ) VULKAN_HPP_NOEXCEPT
    {
      m_surfaceKHR = surfaceKHR;
      return *this;
    }
#endif

    SurfaceKHR & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_surfaceKHR = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkSurfaceKHR() const VULKAN_HPP_NOEXCEPT
    {
      return m_surfaceKHR;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_surfaceKHR != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_surfaceKHR == VK_NULL_HANDLE;
    }

  private:
    VkSurfaceKHR m_surfaceKHR = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eSurfaceKHR>
  {
    using Type = SurfaceKHR;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eSurfaceKHR>
  {
    using Type = SurfaceKHR;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkSurfaceKHR, VK_NULL_HANDLE>
  {
    using Type = SurfaceKHR;
  };
#endif

  template <>
  struct isVulkanHandleType<SurfaceKHR>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkDebugReportCallbackEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDebugReportCallbackEXT.html
  class DebugReportCallbackEXT
  {
  public:
    using CType      = VkDebugReportCallbackEXT;
    using NativeType = VkDebugReportCallbackEXT;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDebugReportCallbackEXT;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDebugReportCallbackEXT;

  public:
    DebugReportCallbackEXT() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    DebugReportCallbackEXT( DebugReportCallbackEXT const & rhs )             = default;
    DebugReportCallbackEXT & operator=( DebugReportCallbackEXT const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    DebugReportCallbackEXT( DebugReportCallbackEXT && rhs )             = default;
    DebugReportCallbackEXT & operator=( DebugReportCallbackEXT && rhs ) = default;
#else
    DebugReportCallbackEXT( DebugReportCallbackEXT && rhs ) VULKAN_HPP_NOEXCEPT : m_debugReportCallbackEXT( exchange( rhs.m_debugReportCallbackEXT, {} ) ) {}

    DebugReportCallbackEXT & operator=( DebugReportCallbackEXT && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_debugReportCallbackEXT = exchange( rhs.m_debugReportCallbackEXT, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR DebugReportCallbackEXT( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT DebugReportCallbackEXT( VkDebugReportCallbackEXT debugReportCallbackEXT ) VULKAN_HPP_NOEXCEPT
      : m_debugReportCallbackEXT( debugReportCallbackEXT )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    DebugReportCallbackEXT & operator=( VkDebugReportCallbackEXT debugReportCallbackEXT ) VULKAN_HPP_NOEXCEPT
    {
      m_debugReportCallbackEXT = debugReportCallbackEXT;
      return *this;
    }
#endif

    DebugReportCallbackEXT & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_debugReportCallbackEXT = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkDebugReportCallbackEXT() const VULKAN_HPP_NOEXCEPT
    {
      return m_debugReportCallbackEXT;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_debugReportCallbackEXT != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_debugReportCallbackEXT == VK_NULL_HANDLE;
    }

  private:
    VkDebugReportCallbackEXT m_debugReportCallbackEXT = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eDebugReportCallbackEXT>
  {
    using Type = DebugReportCallbackEXT;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eDebugReportCallbackEXT>
  {
    using Type = DebugReportCallbackEXT;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkDebugReportCallbackEXT, VK_NULL_HANDLE>
  {
    using Type = DebugReportCallbackEXT;
  };
#endif

  template <>
  struct isVulkanHandleType<DebugReportCallbackEXT>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkDebugUtilsMessengerEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDebugUtilsMessengerEXT.html
  class DebugUtilsMessengerEXT
  {
  public:
    using CType      = VkDebugUtilsMessengerEXT;
    using NativeType = VkDebugUtilsMessengerEXT;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDebugUtilsMessengerEXT;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    DebugUtilsMessengerEXT() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    DebugUtilsMessengerEXT( DebugUtilsMessengerEXT const & rhs )             = default;
    DebugUtilsMessengerEXT & operator=( DebugUtilsMessengerEXT const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    DebugUtilsMessengerEXT( DebugUtilsMessengerEXT && rhs )             = default;
    DebugUtilsMessengerEXT & operator=( DebugUtilsMessengerEXT && rhs ) = default;
#else
    DebugUtilsMessengerEXT( DebugUtilsMessengerEXT && rhs ) VULKAN_HPP_NOEXCEPT : m_debugUtilsMessengerEXT( exchange( rhs.m_debugUtilsMessengerEXT, {} ) ) {}

    DebugUtilsMessengerEXT & operator=( DebugUtilsMessengerEXT && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_debugUtilsMessengerEXT = exchange( rhs.m_debugUtilsMessengerEXT, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR DebugUtilsMessengerEXT( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT DebugUtilsMessengerEXT( VkDebugUtilsMessengerEXT debugUtilsMessengerEXT ) VULKAN_HPP_NOEXCEPT
      : m_debugUtilsMessengerEXT( debugUtilsMessengerEXT )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    DebugUtilsMessengerEXT & operator=( VkDebugUtilsMessengerEXT debugUtilsMessengerEXT ) VULKAN_HPP_NOEXCEPT
    {
      m_debugUtilsMessengerEXT = debugUtilsMessengerEXT;
      return *this;
    }
#endif

    DebugUtilsMessengerEXT & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_debugUtilsMessengerEXT = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkDebugUtilsMessengerEXT() const VULKAN_HPP_NOEXCEPT
    {
      return m_debugUtilsMessengerEXT;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_debugUtilsMessengerEXT != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_debugUtilsMessengerEXT == VK_NULL_HANDLE;
    }

  private:
    VkDebugUtilsMessengerEXT m_debugUtilsMessengerEXT = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eDebugUtilsMessengerEXT>
  {
    using Type = DebugUtilsMessengerEXT;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkDebugUtilsMessengerEXT, VK_NULL_HANDLE>
  {
    using Type = DebugUtilsMessengerEXT;
  };
#endif

  template <>
  struct isVulkanHandleType<DebugUtilsMessengerEXT>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkDisplayKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDisplayKHR.html
  class DisplayKHR
  {
  public:
    using CType      = VkDisplayKHR;
    using NativeType = VkDisplayKHR;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDisplayKHR;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDisplayKHR;

  public:
    DisplayKHR() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    DisplayKHR( DisplayKHR const & rhs )             = default;
    DisplayKHR & operator=( DisplayKHR const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    DisplayKHR( DisplayKHR && rhs )             = default;
    DisplayKHR & operator=( DisplayKHR && rhs ) = default;
#else
    DisplayKHR( DisplayKHR && rhs ) VULKAN_HPP_NOEXCEPT : m_displayKHR( exchange( rhs.m_displayKHR, {} ) ) {}

    DisplayKHR & operator=( DisplayKHR && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_displayKHR = exchange( rhs.m_displayKHR, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR DisplayKHR( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT DisplayKHR( VkDisplayKHR displayKHR ) VULKAN_HPP_NOEXCEPT : m_displayKHR( displayKHR ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    DisplayKHR & operator=( VkDisplayKHR displayKHR ) VULKAN_HPP_NOEXCEPT
    {
      m_displayKHR = displayKHR;
      return *this;
    }
#endif

    DisplayKHR & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_displayKHR = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkDisplayKHR() const VULKAN_HPP_NOEXCEPT
    {
      return m_displayKHR;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_displayKHR != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_displayKHR == VK_NULL_HANDLE;
    }

  private:
    VkDisplayKHR m_displayKHR = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eDisplayKHR>
  {
    using Type = DisplayKHR;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eDisplayKHR>
  {
    using Type = DisplayKHR;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkDisplayKHR, VK_NULL_HANDLE>
  {
    using Type = DisplayKHR;
  };
#endif

  template <>
  struct isVulkanHandleType<DisplayKHR>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkSwapchainKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSwapchainKHR.html
  class SwapchainKHR
  {
  public:
    using CType      = VkSwapchainKHR;
    using NativeType = VkSwapchainKHR;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eSwapchainKHR;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eSwapchainKHR;

  public:
    SwapchainKHR() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    SwapchainKHR( SwapchainKHR const & rhs )             = default;
    SwapchainKHR & operator=( SwapchainKHR const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    SwapchainKHR( SwapchainKHR && rhs )             = default;
    SwapchainKHR & operator=( SwapchainKHR && rhs ) = default;
#else
    SwapchainKHR( SwapchainKHR && rhs ) VULKAN_HPP_NOEXCEPT : m_swapchainKHR( exchange( rhs.m_swapchainKHR, {} ) ) {}

    SwapchainKHR & operator=( SwapchainKHR && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_swapchainKHR = exchange( rhs.m_swapchainKHR, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR SwapchainKHR( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT SwapchainKHR( VkSwapchainKHR swapchainKHR ) VULKAN_HPP_NOEXCEPT : m_swapchainKHR( swapchainKHR ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    SwapchainKHR & operator=( VkSwapchainKHR swapchainKHR ) VULKAN_HPP_NOEXCEPT
    {
      m_swapchainKHR = swapchainKHR;
      return *this;
    }
#endif

    SwapchainKHR & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_swapchainKHR = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkSwapchainKHR() const VULKAN_HPP_NOEXCEPT
    {
      return m_swapchainKHR;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_swapchainKHR != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_swapchainKHR == VK_NULL_HANDLE;
    }

  private:
    VkSwapchainKHR m_swapchainKHR = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eSwapchainKHR>
  {
    using Type = SwapchainKHR;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eSwapchainKHR>
  {
    using Type = SwapchainKHR;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkSwapchainKHR, VK_NULL_HANDLE>
  {
    using Type = SwapchainKHR;
  };
#endif

  template <>
  struct isVulkanHandleType<SwapchainKHR>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkSemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSemaphore.html
  class Semaphore
  {
  public:
    using CType      = VkSemaphore;
    using NativeType = VkSemaphore;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eSemaphore;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eSemaphore;

  public:
    Semaphore() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    Semaphore( Semaphore const & rhs )             = default;
    Semaphore & operator=( Semaphore const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    Semaphore( Semaphore && rhs )             = default;
    Semaphore & operator=( Semaphore && rhs ) = default;
#else
    Semaphore( Semaphore && rhs ) VULKAN_HPP_NOEXCEPT : m_semaphore( exchange( rhs.m_semaphore, {} ) ) {}

    Semaphore & operator=( Semaphore && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_semaphore = exchange( rhs.m_semaphore, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR Semaphore( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT Semaphore( VkSemaphore semaphore ) VULKAN_HPP_NOEXCEPT : m_semaphore( semaphore ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    Semaphore & operator=( VkSemaphore semaphore ) VULKAN_HPP_NOEXCEPT
    {
      m_semaphore = semaphore;
      return *this;
    }
#endif

    Semaphore & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_semaphore = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkSemaphore() const VULKAN_HPP_NOEXCEPT
    {
      return m_semaphore;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_semaphore != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_semaphore == VK_NULL_HANDLE;
    }

  private:
    VkSemaphore m_semaphore = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eSemaphore>
  {
    using Type = Semaphore;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eSemaphore>
  {
    using Type = Semaphore;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkSemaphore, VK_NULL_HANDLE>
  {
    using Type = Semaphore;
  };
#endif

  template <>
  struct isVulkanHandleType<Semaphore>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkFence, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkFence.html
  class Fence
  {
  public:
    using CType      = VkFence;
    using NativeType = VkFence;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eFence;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eFence;

  public:
    Fence() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    Fence( Fence const & rhs )             = default;
    Fence & operator=( Fence const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    Fence( Fence && rhs )             = default;
    Fence & operator=( Fence && rhs ) = default;
#else
    Fence( Fence && rhs ) VULKAN_HPP_NOEXCEPT : m_fence( exchange( rhs.m_fence, {} ) ) {}

    Fence & operator=( Fence && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_fence = exchange( rhs.m_fence, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR Fence( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT Fence( VkFence fence ) VULKAN_HPP_NOEXCEPT : m_fence( fence ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    Fence & operator=( VkFence fence ) VULKAN_HPP_NOEXCEPT
    {
      m_fence = fence;
      return *this;
    }
#endif

    Fence & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_fence = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkFence() const VULKAN_HPP_NOEXCEPT
    {
      return m_fence;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_fence != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_fence == VK_NULL_HANDLE;
    }

  private:
    VkFence m_fence = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eFence>
  {
    using Type = Fence;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eFence>
  {
    using Type = Fence;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkFence, VK_NULL_HANDLE>
  {
    using Type = Fence;
  };
#endif

  template <>
  struct isVulkanHandleType<Fence>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkPerformanceConfigurationINTEL, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkPerformanceConfigurationINTEL.html
  class PerformanceConfigurationINTEL
  {
  public:
    using CType      = VkPerformanceConfigurationINTEL;
    using NativeType = VkPerformanceConfigurationINTEL;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePerformanceConfigurationINTEL;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    PerformanceConfigurationINTEL() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    PerformanceConfigurationINTEL( PerformanceConfigurationINTEL const & rhs )             = default;
    PerformanceConfigurationINTEL & operator=( PerformanceConfigurationINTEL const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    PerformanceConfigurationINTEL( PerformanceConfigurationINTEL && rhs )             = default;
    PerformanceConfigurationINTEL & operator=( PerformanceConfigurationINTEL && rhs ) = default;
#else
    PerformanceConfigurationINTEL( PerformanceConfigurationINTEL && rhs ) VULKAN_HPP_NOEXCEPT
      : m_performanceConfigurationINTEL( exchange( rhs.m_performanceConfigurationINTEL, {} ) )
    {
    }

    PerformanceConfigurationINTEL & operator=( PerformanceConfigurationINTEL && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_performanceConfigurationINTEL = exchange( rhs.m_performanceConfigurationINTEL, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR PerformanceConfigurationINTEL( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT PerformanceConfigurationINTEL( VkPerformanceConfigurationINTEL performanceConfigurationINTEL ) VULKAN_HPP_NOEXCEPT
      : m_performanceConfigurationINTEL( performanceConfigurationINTEL )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    PerformanceConfigurationINTEL & operator=( VkPerformanceConfigurationINTEL performanceConfigurationINTEL ) VULKAN_HPP_NOEXCEPT
    {
      m_performanceConfigurationINTEL = performanceConfigurationINTEL;
      return *this;
    }
#endif

    PerformanceConfigurationINTEL & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_performanceConfigurationINTEL = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkPerformanceConfigurationINTEL() const VULKAN_HPP_NOEXCEPT
    {
      return m_performanceConfigurationINTEL;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_performanceConfigurationINTEL != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_performanceConfigurationINTEL == VK_NULL_HANDLE;
    }

  private:
    VkPerformanceConfigurationINTEL m_performanceConfigurationINTEL = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::ePerformanceConfigurationINTEL>
  {
    using Type = PerformanceConfigurationINTEL;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkPerformanceConfigurationINTEL, VK_NULL_HANDLE>
  {
    using Type = PerformanceConfigurationINTEL;
  };
#endif

  template <>
  struct isVulkanHandleType<PerformanceConfigurationINTEL>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkQueryPool.html
  class QueryPool
  {
  public:
    using CType      = VkQueryPool;
    using NativeType = VkQueryPool;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eQueryPool;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eQueryPool;

  public:
    QueryPool() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    QueryPool( QueryPool const & rhs )             = default;
    QueryPool & operator=( QueryPool const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    QueryPool( QueryPool && rhs )             = default;
    QueryPool & operator=( QueryPool && rhs ) = default;
#else
    QueryPool( QueryPool && rhs ) VULKAN_HPP_NOEXCEPT : m_queryPool( exchange( rhs.m_queryPool, {} ) ) {}

    QueryPool & operator=( QueryPool && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_queryPool = exchange( rhs.m_queryPool, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR QueryPool( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT QueryPool( VkQueryPool queryPool ) VULKAN_HPP_NOEXCEPT : m_queryPool( queryPool ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    QueryPool & operator=( VkQueryPool queryPool ) VULKAN_HPP_NOEXCEPT
    {
      m_queryPool = queryPool;
      return *this;
    }
#endif

    QueryPool & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_queryPool = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkQueryPool() const VULKAN_HPP_NOEXCEPT
    {
      return m_queryPool;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_queryPool != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_queryPool == VK_NULL_HANDLE;
    }

  private:
    VkQueryPool m_queryPool = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eQueryPool>
  {
    using Type = QueryPool;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eQueryPool>
  {
    using Type = QueryPool;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkQueryPool, VK_NULL_HANDLE>
  {
    using Type = QueryPool;
  };
#endif

  template <>
  struct isVulkanHandleType<QueryPool>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBuffer.html
  class Buffer
  {
  public:
    using CType      = VkBuffer;
    using NativeType = VkBuffer;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eBuffer;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eBuffer;

  public:
    Buffer() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    Buffer( Buffer const & rhs )             = default;
    Buffer & operator=( Buffer const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    Buffer( Buffer && rhs )             = default;
    Buffer & operator=( Buffer && rhs ) = default;
#else
    Buffer( Buffer && rhs ) VULKAN_HPP_NOEXCEPT : m_buffer( exchange( rhs.m_buffer, {} ) ) {}

    Buffer & operator=( Buffer && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_buffer = exchange( rhs.m_buffer, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR Buffer( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT Buffer( VkBuffer buffer ) VULKAN_HPP_NOEXCEPT : m_buffer( buffer ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    Buffer & operator=( VkBuffer buffer ) VULKAN_HPP_NOEXCEPT
    {
      m_buffer = buffer;
      return *this;
    }
#endif

    Buffer & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_buffer = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkBuffer() const VULKAN_HPP_NOEXCEPT
    {
      return m_buffer;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_buffer != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_buffer == VK_NULL_HANDLE;
    }

  private:
    VkBuffer m_buffer = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eBuffer>
  {
    using Type = Buffer;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eBuffer>
  {
    using Type = Buffer;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkBuffer, VK_NULL_HANDLE>
  {
    using Type = Buffer;
  };
#endif

  template <>
  struct isVulkanHandleType<Buffer>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkPipelineLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkPipelineLayout.html
  class PipelineLayout
  {
  public:
    using CType      = VkPipelineLayout;
    using NativeType = VkPipelineLayout;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePipelineLayout;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::ePipelineLayout;

  public:
    PipelineLayout() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    PipelineLayout( PipelineLayout const & rhs )             = default;
    PipelineLayout & operator=( PipelineLayout const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    PipelineLayout( PipelineLayout && rhs )             = default;
    PipelineLayout & operator=( PipelineLayout && rhs ) = default;
#else
    PipelineLayout( PipelineLayout && rhs ) VULKAN_HPP_NOEXCEPT : m_pipelineLayout( exchange( rhs.m_pipelineLayout, {} ) ) {}

    PipelineLayout & operator=( PipelineLayout && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_pipelineLayout = exchange( rhs.m_pipelineLayout, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR PipelineLayout( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT PipelineLayout( VkPipelineLayout pipelineLayout ) VULKAN_HPP_NOEXCEPT : m_pipelineLayout( pipelineLayout ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    PipelineLayout & operator=( VkPipelineLayout pipelineLayout ) VULKAN_HPP_NOEXCEPT
    {
      m_pipelineLayout = pipelineLayout;
      return *this;
    }
#endif

    PipelineLayout & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_pipelineLayout = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkPipelineLayout() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipelineLayout;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipelineLayout != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipelineLayout == VK_NULL_HANDLE;
    }

  private:
    VkPipelineLayout m_pipelineLayout = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::ePipelineLayout>
  {
    using Type = PipelineLayout;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::ePipelineLayout>
  {
    using Type = PipelineLayout;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkPipelineLayout, VK_NULL_HANDLE>
  {
    using Type = PipelineLayout;
  };
#endif

  template <>
  struct isVulkanHandleType<PipelineLayout>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkDescriptorSet, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDescriptorSet.html
  class DescriptorSet
  {
  public:
    using CType      = VkDescriptorSet;
    using NativeType = VkDescriptorSet;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDescriptorSet;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDescriptorSet;

  public:
    DescriptorSet() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    DescriptorSet( DescriptorSet const & rhs )             = default;
    DescriptorSet & operator=( DescriptorSet const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    DescriptorSet( DescriptorSet && rhs )             = default;
    DescriptorSet & operator=( DescriptorSet && rhs ) = default;
#else
    DescriptorSet( DescriptorSet && rhs ) VULKAN_HPP_NOEXCEPT : m_descriptorSet( exchange( rhs.m_descriptorSet, {} ) ) {}

    DescriptorSet & operator=( DescriptorSet && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorSet = exchange( rhs.m_descriptorSet, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR DescriptorSet( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT DescriptorSet( VkDescriptorSet descriptorSet ) VULKAN_HPP_NOEXCEPT : m_descriptorSet( descriptorSet ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    DescriptorSet & operator=( VkDescriptorSet descriptorSet ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorSet = descriptorSet;
      return *this;
    }
#endif

    DescriptorSet & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorSet = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkDescriptorSet() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorSet;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorSet != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorSet == VK_NULL_HANDLE;
    }

  private:
    VkDescriptorSet m_descriptorSet = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eDescriptorSet>
  {
    using Type = DescriptorSet;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eDescriptorSet>
  {
    using Type = DescriptorSet;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkDescriptorSet, VK_NULL_HANDLE>
  {
    using Type = DescriptorSet;
  };
#endif

  template <>
  struct isVulkanHandleType<DescriptorSet>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkImageView, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkImageView.html
  class ImageView
  {
  public:
    using CType      = VkImageView;
    using NativeType = VkImageView;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eImageView;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eImageView;

  public:
    ImageView() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    ImageView( ImageView const & rhs )             = default;
    ImageView & operator=( ImageView const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    ImageView( ImageView && rhs )             = default;
    ImageView & operator=( ImageView && rhs ) = default;
#else
    ImageView( ImageView && rhs ) VULKAN_HPP_NOEXCEPT : m_imageView( exchange( rhs.m_imageView, {} ) ) {}

    ImageView & operator=( ImageView && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_imageView = exchange( rhs.m_imageView, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR ImageView( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT ImageView( VkImageView imageView ) VULKAN_HPP_NOEXCEPT : m_imageView( imageView ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    ImageView & operator=( VkImageView imageView ) VULKAN_HPP_NOEXCEPT
    {
      m_imageView = imageView;
      return *this;
    }
#endif

    ImageView & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_imageView = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkImageView() const VULKAN_HPP_NOEXCEPT
    {
      return m_imageView;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_imageView != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_imageView == VK_NULL_HANDLE;
    }

  private:
    VkImageView m_imageView = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eImageView>
  {
    using Type = ImageView;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eImageView>
  {
    using Type = ImageView;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkImageView, VK_NULL_HANDLE>
  {
    using Type = ImageView;
  };
#endif

  template <>
  struct isVulkanHandleType<ImageView>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkPipeline, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkPipeline.html
  class Pipeline
  {
  public:
    using CType      = VkPipeline;
    using NativeType = VkPipeline;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePipeline;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::ePipeline;

  public:
    Pipeline() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    Pipeline( Pipeline const & rhs )             = default;
    Pipeline & operator=( Pipeline const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    Pipeline( Pipeline && rhs )             = default;
    Pipeline & operator=( Pipeline && rhs ) = default;
#else
    Pipeline( Pipeline && rhs ) VULKAN_HPP_NOEXCEPT : m_pipeline( exchange( rhs.m_pipeline, {} ) ) {}

    Pipeline & operator=( Pipeline && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_pipeline = exchange( rhs.m_pipeline, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR Pipeline( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT Pipeline( VkPipeline pipeline ) VULKAN_HPP_NOEXCEPT : m_pipeline( pipeline ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    Pipeline & operator=( VkPipeline pipeline ) VULKAN_HPP_NOEXCEPT
    {
      m_pipeline = pipeline;
      return *this;
    }
#endif

    Pipeline & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_pipeline = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkPipeline() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipeline;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipeline != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipeline == VK_NULL_HANDLE;
    }

  private:
    VkPipeline m_pipeline = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::ePipeline>
  {
    using Type = Pipeline;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::ePipeline>
  {
    using Type = Pipeline;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkPipeline, VK_NULL_HANDLE>
  {
    using Type = Pipeline;
  };
#endif

  template <>
  struct isVulkanHandleType<Pipeline>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkShaderEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkShaderEXT.html
  class ShaderEXT
  {
  public:
    using CType      = VkShaderEXT;
    using NativeType = VkShaderEXT;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eShaderEXT;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    ShaderEXT() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    ShaderEXT( ShaderEXT const & rhs )             = default;
    ShaderEXT & operator=( ShaderEXT const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    ShaderEXT( ShaderEXT && rhs )             = default;
    ShaderEXT & operator=( ShaderEXT && rhs ) = default;
#else
    ShaderEXT( ShaderEXT && rhs ) VULKAN_HPP_NOEXCEPT : m_shaderEXT( exchange( rhs.m_shaderEXT, {} ) ) {}

    ShaderEXT & operator=( ShaderEXT && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_shaderEXT = exchange( rhs.m_shaderEXT, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR ShaderEXT( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT ShaderEXT( VkShaderEXT shaderEXT ) VULKAN_HPP_NOEXCEPT : m_shaderEXT( shaderEXT ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    ShaderEXT & operator=( VkShaderEXT shaderEXT ) VULKAN_HPP_NOEXCEPT
    {
      m_shaderEXT = shaderEXT;
      return *this;
    }
#endif

    ShaderEXT & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_shaderEXT = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkShaderEXT() const VULKAN_HPP_NOEXCEPT
    {
      return m_shaderEXT;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_shaderEXT != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_shaderEXT == VK_NULL_HANDLE;
    }

  private:
    VkShaderEXT m_shaderEXT = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eShaderEXT>
  {
    using Type = ShaderEXT;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkShaderEXT, VK_NULL_HANDLE>
  {
    using Type = ShaderEXT;
  };
#endif

  template <>
  struct isVulkanHandleType<ShaderEXT>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkImage.html
  class Image
  {
  public:
    using CType      = VkImage;
    using NativeType = VkImage;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eImage;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eImage;

  public:
    Image() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    Image( Image const & rhs )             = default;
    Image & operator=( Image const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    Image( Image && rhs )             = default;
    Image & operator=( Image && rhs ) = default;
#else
    Image( Image && rhs ) VULKAN_HPP_NOEXCEPT : m_image( exchange( rhs.m_image, {} ) ) {}

    Image & operator=( Image && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_image = exchange( rhs.m_image, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR Image( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT Image( VkImage image ) VULKAN_HPP_NOEXCEPT : m_image( image ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    Image & operator=( VkImage image ) VULKAN_HPP_NOEXCEPT
    {
      m_image = image;
      return *this;
    }
#endif

    Image & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_image = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkImage() const VULKAN_HPP_NOEXCEPT
    {
      return m_image;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_image != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_image == VK_NULL_HANDLE;
    }

  private:
    VkImage m_image = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eImage>
  {
    using Type = Image;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eImage>
  {
    using Type = Image;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkImage, VK_NULL_HANDLE>
  {
    using Type = Image;
  };
#endif

  template <>
  struct isVulkanHandleType<Image>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkAccelerationStructureNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureNV.html
  class AccelerationStructureNV
  {
  public:
    using CType      = VkAccelerationStructureNV;
    using NativeType = VkAccelerationStructureNV;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eAccelerationStructureNV;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eAccelerationStructureNV;

  public:
    AccelerationStructureNV() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    AccelerationStructureNV( AccelerationStructureNV const & rhs )             = default;
    AccelerationStructureNV & operator=( AccelerationStructureNV const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    AccelerationStructureNV( AccelerationStructureNV && rhs )             = default;
    AccelerationStructureNV & operator=( AccelerationStructureNV && rhs ) = default;
#else
    AccelerationStructureNV( AccelerationStructureNV && rhs ) VULKAN_HPP_NOEXCEPT : m_accelerationStructureNV( exchange( rhs.m_accelerationStructureNV, {} ) )
    {
    }

    AccelerationStructureNV & operator=( AccelerationStructureNV && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_accelerationStructureNV = exchange( rhs.m_accelerationStructureNV, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR AccelerationStructureNV( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT AccelerationStructureNV( VkAccelerationStructureNV accelerationStructureNV ) VULKAN_HPP_NOEXCEPT
      : m_accelerationStructureNV( accelerationStructureNV )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    AccelerationStructureNV & operator=( VkAccelerationStructureNV accelerationStructureNV ) VULKAN_HPP_NOEXCEPT
    {
      m_accelerationStructureNV = accelerationStructureNV;
      return *this;
    }
#endif

    AccelerationStructureNV & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_accelerationStructureNV = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkAccelerationStructureNV() const VULKAN_HPP_NOEXCEPT
    {
      return m_accelerationStructureNV;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_accelerationStructureNV != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_accelerationStructureNV == VK_NULL_HANDLE;
    }

  private:
    VkAccelerationStructureNV m_accelerationStructureNV = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eAccelerationStructureNV>
  {
    using Type = AccelerationStructureNV;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eAccelerationStructureNV>
  {
    using Type = AccelerationStructureNV;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkAccelerationStructureNV, VK_NULL_HANDLE>
  {
    using Type = AccelerationStructureNV;
  };
#endif

  template <>
  struct isVulkanHandleType<AccelerationStructureNV>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkDataGraphPipelineSessionARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDataGraphPipelineSessionARM.html
  class DataGraphPipelineSessionARM
  {
  public:
    using CType      = VkDataGraphPipelineSessionARM;
    using NativeType = VkDataGraphPipelineSessionARM;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDataGraphPipelineSessionARM;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    DataGraphPipelineSessionARM() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    DataGraphPipelineSessionARM( DataGraphPipelineSessionARM const & rhs )             = default;
    DataGraphPipelineSessionARM & operator=( DataGraphPipelineSessionARM const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    DataGraphPipelineSessionARM( DataGraphPipelineSessionARM && rhs )             = default;
    DataGraphPipelineSessionARM & operator=( DataGraphPipelineSessionARM && rhs ) = default;
#else
    DataGraphPipelineSessionARM( DataGraphPipelineSessionARM && rhs ) VULKAN_HPP_NOEXCEPT
      : m_dataGraphPipelineSessionARM( exchange( rhs.m_dataGraphPipelineSessionARM, {} ) )
    {
    }

    DataGraphPipelineSessionARM & operator=( DataGraphPipelineSessionARM && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_dataGraphPipelineSessionARM = exchange( rhs.m_dataGraphPipelineSessionARM, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR DataGraphPipelineSessionARM( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT DataGraphPipelineSessionARM( VkDataGraphPipelineSessionARM dataGraphPipelineSessionARM ) VULKAN_HPP_NOEXCEPT
      : m_dataGraphPipelineSessionARM( dataGraphPipelineSessionARM )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    DataGraphPipelineSessionARM & operator=( VkDataGraphPipelineSessionARM dataGraphPipelineSessionARM ) VULKAN_HPP_NOEXCEPT
    {
      m_dataGraphPipelineSessionARM = dataGraphPipelineSessionARM;
      return *this;
    }
#endif

    DataGraphPipelineSessionARM & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_dataGraphPipelineSessionARM = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkDataGraphPipelineSessionARM() const VULKAN_HPP_NOEXCEPT
    {
      return m_dataGraphPipelineSessionARM;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_dataGraphPipelineSessionARM != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_dataGraphPipelineSessionARM == VK_NULL_HANDLE;
    }

  private:
    VkDataGraphPipelineSessionARM m_dataGraphPipelineSessionARM = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eDataGraphPipelineSessionARM>
  {
    using Type = DataGraphPipelineSessionARM;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkDataGraphPipelineSessionARM, VK_NULL_HANDLE>
  {
    using Type = DataGraphPipelineSessionARM;
  };
#endif

  template <>
  struct isVulkanHandleType<DataGraphPipelineSessionARM>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkOpticalFlowSessionNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkOpticalFlowSessionNV.html
  class OpticalFlowSessionNV
  {
  public:
    using CType      = VkOpticalFlowSessionNV;
    using NativeType = VkOpticalFlowSessionNV;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eOpticalFlowSessionNV;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    OpticalFlowSessionNV() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    OpticalFlowSessionNV( OpticalFlowSessionNV const & rhs )             = default;
    OpticalFlowSessionNV & operator=( OpticalFlowSessionNV const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    OpticalFlowSessionNV( OpticalFlowSessionNV && rhs )             = default;
    OpticalFlowSessionNV & operator=( OpticalFlowSessionNV && rhs ) = default;
#else
    OpticalFlowSessionNV( OpticalFlowSessionNV && rhs ) VULKAN_HPP_NOEXCEPT : m_opticalFlowSessionNV( exchange( rhs.m_opticalFlowSessionNV, {} ) ) {}

    OpticalFlowSessionNV & operator=( OpticalFlowSessionNV && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_opticalFlowSessionNV = exchange( rhs.m_opticalFlowSessionNV, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR OpticalFlowSessionNV( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT OpticalFlowSessionNV( VkOpticalFlowSessionNV opticalFlowSessionNV ) VULKAN_HPP_NOEXCEPT
      : m_opticalFlowSessionNV( opticalFlowSessionNV )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    OpticalFlowSessionNV & operator=( VkOpticalFlowSessionNV opticalFlowSessionNV ) VULKAN_HPP_NOEXCEPT
    {
      m_opticalFlowSessionNV = opticalFlowSessionNV;
      return *this;
    }
#endif

    OpticalFlowSessionNV & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_opticalFlowSessionNV = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkOpticalFlowSessionNV() const VULKAN_HPP_NOEXCEPT
    {
      return m_opticalFlowSessionNV;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_opticalFlowSessionNV != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_opticalFlowSessionNV == VK_NULL_HANDLE;
    }

  private:
    VkOpticalFlowSessionNV m_opticalFlowSessionNV = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eOpticalFlowSessionNV>
  {
    using Type = OpticalFlowSessionNV;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkOpticalFlowSessionNV, VK_NULL_HANDLE>
  {
    using Type = OpticalFlowSessionNV;
  };
#endif

  template <>
  struct isVulkanHandleType<OpticalFlowSessionNV>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkDescriptorUpdateTemplate, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDescriptorUpdateTemplate.html
  class DescriptorUpdateTemplate
  {
  public:
    using CType      = VkDescriptorUpdateTemplate;
    using NativeType = VkDescriptorUpdateTemplate;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDescriptorUpdateTemplate;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDescriptorUpdateTemplate;

  public:
    DescriptorUpdateTemplate() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    DescriptorUpdateTemplate( DescriptorUpdateTemplate const & rhs )             = default;
    DescriptorUpdateTemplate & operator=( DescriptorUpdateTemplate const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    DescriptorUpdateTemplate( DescriptorUpdateTemplate && rhs )             = default;
    DescriptorUpdateTemplate & operator=( DescriptorUpdateTemplate && rhs ) = default;
#else
    DescriptorUpdateTemplate( DescriptorUpdateTemplate && rhs ) VULKAN_HPP_NOEXCEPT
      : m_descriptorUpdateTemplate( exchange( rhs.m_descriptorUpdateTemplate, {} ) )
    {
    }

    DescriptorUpdateTemplate & operator=( DescriptorUpdateTemplate && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorUpdateTemplate = exchange( rhs.m_descriptorUpdateTemplate, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR DescriptorUpdateTemplate( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT DescriptorUpdateTemplate( VkDescriptorUpdateTemplate descriptorUpdateTemplate ) VULKAN_HPP_NOEXCEPT
      : m_descriptorUpdateTemplate( descriptorUpdateTemplate )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    DescriptorUpdateTemplate & operator=( VkDescriptorUpdateTemplate descriptorUpdateTemplate ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorUpdateTemplate = descriptorUpdateTemplate;
      return *this;
    }
#endif

    DescriptorUpdateTemplate & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorUpdateTemplate = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkDescriptorUpdateTemplate() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorUpdateTemplate;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorUpdateTemplate != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorUpdateTemplate == VK_NULL_HANDLE;
    }

  private:
    VkDescriptorUpdateTemplate m_descriptorUpdateTemplate = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eDescriptorUpdateTemplate>
  {
    using Type = DescriptorUpdateTemplate;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eDescriptorUpdateTemplate>
  {
    using Type = DescriptorUpdateTemplate;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkDescriptorUpdateTemplate, VK_NULL_HANDLE>
  {
    using Type = DescriptorUpdateTemplate;
  };
#endif

  template <>
  struct isVulkanHandleType<DescriptorUpdateTemplate>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  using DescriptorUpdateTemplateKHR = DescriptorUpdateTemplate;

  // wrapper class for handle VkEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkEvent.html
  class Event
  {
  public:
    using CType      = VkEvent;
    using NativeType = VkEvent;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eEvent;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eEvent;

  public:
    Event() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    Event( Event const & rhs )             = default;
    Event & operator=( Event const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    Event( Event && rhs )             = default;
    Event & operator=( Event && rhs ) = default;
#else
    Event( Event && rhs ) VULKAN_HPP_NOEXCEPT : m_event( exchange( rhs.m_event, {} ) ) {}

    Event & operator=( Event && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_event = exchange( rhs.m_event, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR Event( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT Event( VkEvent event ) VULKAN_HPP_NOEXCEPT : m_event( event ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    Event & operator=( VkEvent event ) VULKAN_HPP_NOEXCEPT
    {
      m_event = event;
      return *this;
    }
#endif

    Event & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_event = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkEvent() const VULKAN_HPP_NOEXCEPT
    {
      return m_event;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_event != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_event == VK_NULL_HANDLE;
    }

  private:
    VkEvent m_event = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eEvent>
  {
    using Type = Event;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eEvent>
  {
    using Type = Event;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkEvent, VK_NULL_HANDLE>
  {
    using Type = Event;
  };
#endif

  template <>
  struct isVulkanHandleType<Event>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkAccelerationStructureKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureKHR.html
  class AccelerationStructureKHR
  {
  public:
    using CType      = VkAccelerationStructureKHR;
    using NativeType = VkAccelerationStructureKHR;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eAccelerationStructureKHR;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eAccelerationStructureKHR;

  public:
    AccelerationStructureKHR() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    AccelerationStructureKHR( AccelerationStructureKHR const & rhs )             = default;
    AccelerationStructureKHR & operator=( AccelerationStructureKHR const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    AccelerationStructureKHR( AccelerationStructureKHR && rhs )             = default;
    AccelerationStructureKHR & operator=( AccelerationStructureKHR && rhs ) = default;
#else
    AccelerationStructureKHR( AccelerationStructureKHR && rhs ) VULKAN_HPP_NOEXCEPT
      : m_accelerationStructureKHR( exchange( rhs.m_accelerationStructureKHR, {} ) )
    {
    }

    AccelerationStructureKHR & operator=( AccelerationStructureKHR && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_accelerationStructureKHR = exchange( rhs.m_accelerationStructureKHR, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR AccelerationStructureKHR( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT AccelerationStructureKHR( VkAccelerationStructureKHR accelerationStructureKHR ) VULKAN_HPP_NOEXCEPT
      : m_accelerationStructureKHR( accelerationStructureKHR )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    AccelerationStructureKHR & operator=( VkAccelerationStructureKHR accelerationStructureKHR ) VULKAN_HPP_NOEXCEPT
    {
      m_accelerationStructureKHR = accelerationStructureKHR;
      return *this;
    }
#endif

    AccelerationStructureKHR & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_accelerationStructureKHR = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkAccelerationStructureKHR() const VULKAN_HPP_NOEXCEPT
    {
      return m_accelerationStructureKHR;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_accelerationStructureKHR != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_accelerationStructureKHR == VK_NULL_HANDLE;
    }

  private:
    VkAccelerationStructureKHR m_accelerationStructureKHR = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eAccelerationStructureKHR>
  {
    using Type = AccelerationStructureKHR;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eAccelerationStructureKHR>
  {
    using Type = AccelerationStructureKHR;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkAccelerationStructureKHR, VK_NULL_HANDLE>
  {
    using Type = AccelerationStructureKHR;
  };
#endif

  template <>
  struct isVulkanHandleType<AccelerationStructureKHR>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkMicromapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkMicromapEXT.html
  class MicromapEXT
  {
  public:
    using CType      = VkMicromapEXT;
    using NativeType = VkMicromapEXT;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eMicromapEXT;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    MicromapEXT() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    MicromapEXT( MicromapEXT const & rhs )             = default;
    MicromapEXT & operator=( MicromapEXT const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    MicromapEXT( MicromapEXT && rhs )             = default;
    MicromapEXT & operator=( MicromapEXT && rhs ) = default;
#else
    MicromapEXT( MicromapEXT && rhs ) VULKAN_HPP_NOEXCEPT : m_micromapEXT( exchange( rhs.m_micromapEXT, {} ) ) {}

    MicromapEXT & operator=( MicromapEXT && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_micromapEXT = exchange( rhs.m_micromapEXT, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR MicromapEXT( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT MicromapEXT( VkMicromapEXT micromapEXT ) VULKAN_HPP_NOEXCEPT : m_micromapEXT( micromapEXT ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    MicromapEXT & operator=( VkMicromapEXT micromapEXT ) VULKAN_HPP_NOEXCEPT
    {
      m_micromapEXT = micromapEXT;
      return *this;
    }
#endif

    MicromapEXT & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_micromapEXT = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkMicromapEXT() const VULKAN_HPP_NOEXCEPT
    {
      return m_micromapEXT;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_micromapEXT != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_micromapEXT == VK_NULL_HANDLE;
    }

  private:
    VkMicromapEXT m_micromapEXT = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eMicromapEXT>
  {
    using Type = MicromapEXT;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkMicromapEXT, VK_NULL_HANDLE>
  {
    using Type = MicromapEXT;
  };
#endif

  template <>
  struct isVulkanHandleType<MicromapEXT>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandBuffer.html
  class CommandBuffer
  {
  public:
    using CType      = VkCommandBuffer;
    using NativeType = VkCommandBuffer;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCommandBuffer;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCommandBuffer;

  public:
    CommandBuffer() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    CommandBuffer( CommandBuffer const & rhs )             = default;
    CommandBuffer & operator=( CommandBuffer const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    CommandBuffer( CommandBuffer && rhs )             = default;
    CommandBuffer & operator=( CommandBuffer && rhs ) = default;
#else
    CommandBuffer( CommandBuffer && rhs ) VULKAN_HPP_NOEXCEPT : m_commandBuffer( exchange( rhs.m_commandBuffer, {} ) ) {}

    CommandBuffer & operator=( CommandBuffer && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_commandBuffer = exchange( rhs.m_commandBuffer, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR CommandBuffer( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    CommandBuffer( VkCommandBuffer commandBuffer ) VULKAN_HPP_NOEXCEPT : m_commandBuffer( commandBuffer ) {}

    CommandBuffer & operator=( VkCommandBuffer commandBuffer ) VULKAN_HPP_NOEXCEPT
    {
      m_commandBuffer = commandBuffer;
      return *this;
    }

    CommandBuffer & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_commandBuffer = {};
      return *this;
    }

    //=== VK_VERSION_1_0 ===

    // wrapper function for command vkBeginCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBeginCommandBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBeginCommandBuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result begin( CommandBufferBeginInfo const * pBeginInfo,
                                       Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkBeginCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBeginCommandBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBeginCommandBuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type begin( CommandBufferBeginInfo const & beginInfo,
                                                                                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkEndCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkEndCommandBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkEndCommandBuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result end( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkEndCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkEndCommandBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkEndCommandBuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type end( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkResetCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetCommandBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkResetCommandBuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result reset( CommandBufferResetFlags flags, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkResetCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetCommandBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkResetCommandBuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type reset( CommandBufferResetFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                                                                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    // wrapper function for command vkCmdCopyBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBuffer ), bool>::type = true>
    void copyBuffer( Buffer             srcBuffer,
                     Buffer             dstBuffer,
                     uint32_t           regionCount,
                     BufferCopy const * pRegions,
                     Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBuffer ), bool>::type = true>
    void copyBuffer( Buffer                               srcBuffer,
                     Buffer                               dstBuffer,
                     ArrayProxy<BufferCopy const> const & regions,
                     Dispatch const & d                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImage ), bool>::type = true>
    void copyImage( Image              srcImage,
                    ImageLayout        srcImageLayout,
                    Image              dstImage,
                    ImageLayout        dstImageLayout,
                    uint32_t           regionCount,
                    ImageCopy const *  pRegions,
                    Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImage ), bool>::type = true>
    void copyImage( Image                               srcImage,
                    ImageLayout                         srcImageLayout,
                    Image                               dstImage,
                    ImageLayout                         dstImageLayout,
                    ArrayProxy<ImageCopy const> const & regions,
                    Dispatch const & d                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyBufferToImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBufferToImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBufferToImage ), bool>::type = true>
    void copyBufferToImage( Buffer                  srcBuffer,
                            Image                   dstImage,
                            ImageLayout             dstImageLayout,
                            uint32_t                regionCount,
                            BufferImageCopy const * pRegions,
                            Dispatch const & d      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyBufferToImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBufferToImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBufferToImage ), bool>::type = true>
    void copyBufferToImage( Buffer                                    srcBuffer,
                            Image                                     dstImage,
                            ImageLayout                               dstImageLayout,
                            ArrayProxy<BufferImageCopy const> const & regions,
                            Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyImageToBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImageToBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImageToBuffer ), bool>::type = true>
    void copyImageToBuffer( Image                   srcImage,
                            ImageLayout             srcImageLayout,
                            Buffer                  dstBuffer,
                            uint32_t                regionCount,
                            BufferImageCopy const * pRegions,
                            Dispatch const & d      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyImageToBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImageToBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImageToBuffer ), bool>::type = true>
    void copyImageToBuffer( Image                                     srcImage,
                            ImageLayout                               srcImageLayout,
                            Buffer                                    dstBuffer,
                            ArrayProxy<BufferImageCopy const> const & regions,
                            Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdUpdateBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdUpdateBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdUpdateBuffer ), bool>::type = true>
    void updateBuffer( Buffer             dstBuffer,
                       DeviceSize         dstOffset,
                       DeviceSize         dataSize,
                       void const *       pData,
                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdUpdateBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdUpdateBuffer.html
    template <typename DataType,
              typename Dispatch                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdUpdateBuffer ), bool>::type = true>
    void updateBuffer( Buffer                             dstBuffer,
                       DeviceSize                         dstOffset,
                       ArrayProxy<DataType const> const & data,
                       Dispatch const & d                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdFillBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdFillBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdFillBuffer ), bool>::type = true>
    void fillBuffer( Buffer dstBuffer, DeviceSize dstOffset, DeviceSize size, uint32_t data, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const
      VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdPipelineBarrier, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPipelineBarrier.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPipelineBarrier ), bool>::type = true>
    void pipelineBarrier( PipelineStageFlags          srcStageMask,
                          PipelineStageFlags          dstStageMask,
                          DependencyFlags             dependencyFlags,
                          uint32_t                    memoryBarrierCount,
                          MemoryBarrier const *       pMemoryBarriers,
                          uint32_t                    bufferMemoryBarrierCount,
                          BufferMemoryBarrier const * pBufferMemoryBarriers,
                          uint32_t                    imageMemoryBarrierCount,
                          ImageMemoryBarrier const *  pImageMemoryBarriers,
                          Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPipelineBarrier, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPipelineBarrier.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPipelineBarrier ), bool>::type = true>
    void pipelineBarrier( PipelineStageFlags                            srcStageMask,
                          PipelineStageFlags                            dstStageMask,
                          DependencyFlags                               dependencyFlags,
                          ArrayProxy<MemoryBarrier const> const &       memoryBarriers,
                          ArrayProxy<BufferMemoryBarrier const> const & bufferMemoryBarriers,
                          ArrayProxy<ImageMemoryBarrier const> const &  imageMemoryBarriers,
                          Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBeginQuery, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginQuery.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginQuery ), bool>::type = true>
    void beginQuery( QueryPool          queryPool,
                     uint32_t           query,
                     QueryControlFlags  flags,
                     Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdEndQuery, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndQuery.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndQuery ), bool>::type = true>
    void endQuery( QueryPool queryPool, uint32_t query, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdResetQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResetQueryPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdResetQueryPool ), bool>::type = true>
    void resetQueryPool( QueryPool          queryPool,
                         uint32_t           firstQuery,
                         uint32_t           queryCount,
                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdWriteTimestamp, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteTimestamp.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdWriteTimestamp ), bool>::type = true>
    void writeTimestamp( PipelineStageFlagBits pipelineStage,
                         QueryPool             queryPool,
                         uint32_t              query,
                         Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdCopyQueryPoolResults, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyQueryPoolResults.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyQueryPoolResults ), bool>::type = true>
    void copyQueryPoolResults( QueryPool          queryPool,
                               uint32_t           firstQuery,
                               uint32_t           queryCount,
                               Buffer             dstBuffer,
                               DeviceSize         dstOffset,
                               DeviceSize         stride,
                               QueryResultFlags   flags,
                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdExecuteCommands, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdExecuteCommands.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdExecuteCommands ), bool>::type = true>
    void executeCommands( uint32_t              commandBufferCount,
                          CommandBuffer const * pCommandBuffers,
                          Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdExecuteCommands, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdExecuteCommands.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdExecuteCommands ), bool>::type = true>
    void executeCommands( ArrayProxy<CommandBuffer const> const & commandBuffers,
                          Dispatch const & d                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBindPipeline, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindPipeline.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindPipeline ), bool>::type = true>
    void bindPipeline( PipelineBindPoint  pipelineBindPoint,
                       Pipeline           pipeline,
                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdBindDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorSets.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindDescriptorSets ), bool>::type = true>
    void bindDescriptorSets( PipelineBindPoint     pipelineBindPoint,
                             PipelineLayout        layout,
                             uint32_t              firstSet,
                             uint32_t              descriptorSetCount,
                             DescriptorSet const * pDescriptorSets,
                             uint32_t              dynamicOffsetCount,
                             uint32_t const *      pDynamicOffsets,
                             Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorSets.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindDescriptorSets ), bool>::type = true>
    void bindDescriptorSets( PipelineBindPoint                       pipelineBindPoint,
                             PipelineLayout                          layout,
                             uint32_t                                firstSet,
                             ArrayProxy<DescriptorSet const> const & descriptorSets,
                             ArrayProxy<uint32_t const> const &      dynamicOffsets,
                             Dispatch const & d                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdClearColorImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearColorImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdClearColorImage ), bool>::type = true>
    void clearColorImage( Image                         image,
                          ImageLayout                   imageLayout,
                          ClearColorValue const *       pColor,
                          uint32_t                      rangeCount,
                          ImageSubresourceRange const * pRanges,
                          Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdClearColorImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearColorImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdClearColorImage ), bool>::type = true>
    void clearColorImage( Image                                           image,
                          ImageLayout                                     imageLayout,
                          ClearColorValue const &                         color,
                          ArrayProxy<ImageSubresourceRange const> const & ranges,
                          Dispatch const & d                              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdDispatch, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatch.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDispatch ), bool>::type = true>
    void dispatch( uint32_t           groupCountX,
                   uint32_t           groupCountY,
                   uint32_t           groupCountZ,
                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDispatchIndirect, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchIndirect.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDispatchIndirect ), bool>::type = true>
    void dispatchIndirect( Buffer buffer, DeviceSize offset, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetEvent ), bool>::type = true>
    void setEvent( Event event, PipelineStageFlags stageMask, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdResetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResetEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdResetEvent ), bool>::type = true>
    void resetEvent( Event event, PipelineStageFlags stageMask, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdWaitEvents, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWaitEvents.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdWaitEvents ), bool>::type = true>
    void waitEvents( uint32_t                    eventCount,
                     Event const *               pEvents,
                     PipelineStageFlags          srcStageMask,
                     PipelineStageFlags          dstStageMask,
                     uint32_t                    memoryBarrierCount,
                     MemoryBarrier const *       pMemoryBarriers,
                     uint32_t                    bufferMemoryBarrierCount,
                     BufferMemoryBarrier const * pBufferMemoryBarriers,
                     uint32_t                    imageMemoryBarrierCount,
                     ImageMemoryBarrier const *  pImageMemoryBarriers,
                     Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdWaitEvents, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWaitEvents.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdWaitEvents ), bool>::type = true>
    void waitEvents( ArrayProxy<Event const> const &               events,
                     PipelineStageFlags                            srcStageMask,
                     PipelineStageFlags                            dstStageMask,
                     ArrayProxy<MemoryBarrier const> const &       memoryBarriers,
                     ArrayProxy<BufferMemoryBarrier const> const & bufferMemoryBarriers,
                     ArrayProxy<ImageMemoryBarrier const> const &  imageMemoryBarriers,
                     Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdPushConstants, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushConstants.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushConstants ), bool>::type = true>
    void pushConstants( PipelineLayout     layout,
                        ShaderStageFlags   stageFlags,
                        uint32_t           offset,
                        uint32_t           size,
                        void const *       pValues,
                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushConstants, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushConstants.html
    template <typename ValuesType,
              typename Dispatch                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPushConstants ), bool>::type = true>
    void pushConstants( PipelineLayout                       layout,
                        ShaderStageFlags                     stageFlags,
                        uint32_t                             offset,
                        ArrayProxy<ValuesType const> const & values,
                        Dispatch const & d                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetViewport, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewport.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetViewport ), bool>::type = true>
    void setViewport( uint32_t           firstViewport,
                      uint32_t           viewportCount,
                      Viewport const *   pViewports,
                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetViewport, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewport.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetViewport ), bool>::type = true>
    void setViewport( uint32_t                           firstViewport,
                      ArrayProxy<Viewport const> const & viewports,
                      Dispatch const & d                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetScissor, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetScissor.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetScissor ), bool>::type = true>
    void setScissor( uint32_t           firstScissor,
                     uint32_t           scissorCount,
                     Rect2D const *     pScissors,
                     Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetScissor, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetScissor.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetScissor ), bool>::type = true>
    void setScissor( uint32_t                         firstScissor,
                     ArrayProxy<Rect2D const> const & scissors,
                     Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetLineWidth, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineWidth.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetLineWidth ), bool>::type = true>
    void setLineWidth( float lineWidth, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthBias, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBias.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthBias ), bool>::type = true>
    void setDepthBias( float              depthBiasConstantFactor,
                       float              depthBiasClamp,
                       float              depthBiasSlopeFactor,
                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetBlendConstants, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetBlendConstants.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetBlendConstants ), bool>::type = true>
    void setBlendConstants( float const blendConstants[4], Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthBounds, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBounds.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthBounds ), bool>::type = true>
    void setDepthBounds( float minDepthBounds, float maxDepthBounds, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetStencilCompareMask, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilCompareMask.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetStencilCompareMask ), bool>::type = true>
    void setStencilCompareMask( StencilFaceFlags   faceMask,
                                uint32_t           compareMask,
                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetStencilWriteMask, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilWriteMask.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetStencilWriteMask ), bool>::type = true>
    void setStencilWriteMask( StencilFaceFlags   faceMask,
                              uint32_t           writeMask,
                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetStencilReference, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilReference.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetStencilReference ), bool>::type = true>
    void setStencilReference( StencilFaceFlags   faceMask,
                              uint32_t           reference,
                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdBindIndexBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindIndexBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindIndexBuffer ), bool>::type = true>
    void bindIndexBuffer( Buffer             buffer,
                          DeviceSize         offset,
                          IndexType          indexType,
                          Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdBindVertexBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindVertexBuffers.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindVertexBuffers ), bool>::type = true>
    void bindVertexBuffers( uint32_t           firstBinding,
                            uint32_t           bindingCount,
                            Buffer const *     pBuffers,
                            DeviceSize const * pOffsets,
                            Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindVertexBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindVertexBuffers.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindVertexBuffers ), bool>::type = true>
    void bindVertexBuffers( uint32_t                             firstBinding,
                            ArrayProxy<Buffer const> const &     buffers,
                            ArrayProxy<DeviceSize const> const & offsets,
                            Dispatch const & d                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdDraw, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDraw.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDraw ), bool>::type = true>
    void draw( uint32_t           vertexCount,
               uint32_t           instanceCount,
               uint32_t           firstVertex,
               uint32_t           firstInstance,
               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawIndexed, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexed.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawIndexed ), bool>::type = true>
    void drawIndexed( uint32_t           indexCount,
                      uint32_t           instanceCount,
                      uint32_t           firstIndex,
                      int32_t            vertexOffset,
                      uint32_t           firstInstance,
                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawIndirect, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirect.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawIndirect ), bool>::type = true>
    void drawIndirect( Buffer buffer, DeviceSize offset, uint32_t drawCount, uint32_t stride, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT )
      const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawIndexedIndirect, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexedIndirect.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawIndexedIndirect ), bool>::type = true>
    void drawIndexedIndirect( Buffer             buffer,
                              DeviceSize         offset,
                              uint32_t           drawCount,
                              uint32_t           stride,
                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdBlitImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBlitImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBlitImage ), bool>::type = true>
    void blitImage( Image              srcImage,
                    ImageLayout        srcImageLayout,
                    Image              dstImage,
                    ImageLayout        dstImageLayout,
                    uint32_t           regionCount,
                    ImageBlit const *  pRegions,
                    Filter             filter,
                    Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBlitImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBlitImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBlitImage ), bool>::type = true>
    void blitImage( Image                               srcImage,
                    ImageLayout                         srcImageLayout,
                    Image                               dstImage,
                    ImageLayout                         dstImageLayout,
                    ArrayProxy<ImageBlit const> const & regions,
                    Filter                              filter,
                    Dispatch const & d                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdClearDepthStencilImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearDepthStencilImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdClearDepthStencilImage ), bool>::type = true>
    void clearDepthStencilImage( Image                          image,
                                 ImageLayout                    imageLayout,
                                 ClearDepthStencilValue const * pDepthStencil,
                                 uint32_t                       rangeCount,
                                 ImageSubresourceRange const *  pRanges,
                                 Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdClearDepthStencilImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearDepthStencilImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdClearDepthStencilImage ), bool>::type = true>
    void clearDepthStencilImage( Image                                           image,
                                 ImageLayout                                     imageLayout,
                                 ClearDepthStencilValue const &                  depthStencil,
                                 ArrayProxy<ImageSubresourceRange const> const & ranges,
                                 Dispatch const & d                              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdClearAttachments, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearAttachments.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdClearAttachments ), bool>::type = true>
    void clearAttachments( uint32_t                attachmentCount,
                           ClearAttachment const * pAttachments,
                           uint32_t                rectCount,
                           ClearRect const *       pRects,
                           Dispatch const & d      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdClearAttachments, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearAttachments.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdClearAttachments ), bool>::type = true>
    void clearAttachments( ArrayProxy<ClearAttachment const> const & attachments,
                           ArrayProxy<ClearRect const> const &       rects,
                           Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdResolveImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResolveImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdResolveImage ), bool>::type = true>
    void resolveImage( Image                srcImage,
                       ImageLayout          srcImageLayout,
                       Image                dstImage,
                       ImageLayout          dstImageLayout,
                       uint32_t             regionCount,
                       ImageResolve const * pRegions,
                       Dispatch const & d   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdResolveImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResolveImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdResolveImage ), bool>::type = true>
    void resolveImage( Image                                  srcImage,
                       ImageLayout                            srcImageLayout,
                       Image                                  dstImage,
                       ImageLayout                            dstImageLayout,
                       ArrayProxy<ImageResolve const> const & regions,
                       Dispatch const & d                     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBeginRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderPass.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginRenderPass ), bool>::type = true>
    void beginRenderPass( RenderPassBeginInfo const * pRenderPassBegin,
                          SubpassContents             contents,
                          Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBeginRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderPass.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginRenderPass ), bool>::type = true>
    void beginRenderPass( RenderPassBeginInfo const & renderPassBegin,
                          SubpassContents             contents,
                          Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdNextSubpass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdNextSubpass.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdNextSubpass ), bool>::type = true>
    void nextSubpass( SubpassContents contents, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdEndRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderPass.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndRenderPass ), bool>::type = true>
    void endRenderPass( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_VERSION_1_1 ===

    // wrapper function for command vkCmdSetDeviceMask, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDeviceMask.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDeviceMask ), bool>::type = true>
    void setDeviceMask( uint32_t deviceMask, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDispatchBase, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchBase.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDispatchBase ), bool>::type = true>
    void dispatchBase( uint32_t           baseGroupX,
                       uint32_t           baseGroupY,
                       uint32_t           baseGroupZ,
                       uint32_t           groupCountX,
                       uint32_t           groupCountY,
                       uint32_t           groupCountZ,
                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_VERSION_1_2 ===

    // wrapper function for command vkCmdDrawIndirectCount, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirectCount.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawIndirectCount ), bool>::type = true>
    void drawIndirectCount( Buffer             buffer,
                            DeviceSize         offset,
                            Buffer             countBuffer,
                            DeviceSize         countBufferOffset,
                            uint32_t           maxDrawCount,
                            uint32_t           stride,
                            Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawIndexedIndirectCount, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexedIndirectCount.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDrawIndexedIndirectCount ), bool>::type = true>
    void drawIndexedIndirectCount( Buffer             buffer,
                                   DeviceSize         offset,
                                   Buffer             countBuffer,
                                   DeviceSize         countBufferOffset,
                                   uint32_t           maxDrawCount,
                                   uint32_t           stride,
                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdBeginRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderPass2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginRenderPass2 ), bool>::type = true>
    void beginRenderPass2( RenderPassBeginInfo const * pRenderPassBegin,
                           SubpassBeginInfo const *    pSubpassBeginInfo,
                           Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBeginRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderPass2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginRenderPass2 ), bool>::type = true>
    void beginRenderPass2( RenderPassBeginInfo const & renderPassBegin,
                           SubpassBeginInfo const &    subpassBeginInfo,
                           Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdNextSubpass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdNextSubpass2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdNextSubpass2 ), bool>::type = true>
    void nextSubpass2( SubpassBeginInfo const * pSubpassBeginInfo,
                       SubpassEndInfo const *   pSubpassEndInfo,
                       Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdNextSubpass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdNextSubpass2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdNextSubpass2 ), bool>::type = true>
    void nextSubpass2( SubpassBeginInfo const & subpassBeginInfo,
                       SubpassEndInfo const &   subpassEndInfo,
                       Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdEndRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderPass2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndRenderPass2 ), bool>::type = true>
    void endRenderPass2( SubpassEndInfo const * pSubpassEndInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdEndRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderPass2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndRenderPass2 ), bool>::type = true>
    void endRenderPass2( SubpassEndInfo const & subpassEndInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_VERSION_1_3 ===

    // wrapper function for command vkCmdPipelineBarrier2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPipelineBarrier2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPipelineBarrier2 ), bool>::type = true>
    void pipelineBarrier2( DependencyInfo const * pDependencyInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPipelineBarrier2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPipelineBarrier2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPipelineBarrier2 ), bool>::type = true>
    void pipelineBarrier2( DependencyInfo const & dependencyInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdWriteTimestamp2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteTimestamp2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdWriteTimestamp2 ), bool>::type = true>
    void writeTimestamp2( PipelineStageFlags2 stage,
                          QueryPool           queryPool,
                          uint32_t            query,
                          Dispatch const & d  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdCopyBuffer2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBuffer2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBuffer2 ), bool>::type = true>
    void copyBuffer2( CopyBufferInfo2 const * pCopyBufferInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyBuffer2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBuffer2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBuffer2 ), bool>::type = true>
    void copyBuffer2( CopyBufferInfo2 const & copyBufferInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImage2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImage2 ), bool>::type = true>
    void copyImage2( CopyImageInfo2 const * pCopyImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImage2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImage2 ), bool>::type = true>
    void copyImage2( CopyImageInfo2 const & copyImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyBufferToImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBufferToImage2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBufferToImage2 ), bool>::type = true>
    void copyBufferToImage2( CopyBufferToImageInfo2 const * pCopyBufferToImageInfo,
                             Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyBufferToImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBufferToImage2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBufferToImage2 ), bool>::type = true>
    void copyBufferToImage2( CopyBufferToImageInfo2 const & copyBufferToImageInfo,
                             Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyImageToBuffer2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImageToBuffer2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImageToBuffer2 ), bool>::type = true>
    void copyImageToBuffer2( CopyImageToBufferInfo2 const * pCopyImageToBufferInfo,
                             Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyImageToBuffer2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImageToBuffer2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImageToBuffer2 ), bool>::type = true>
    void copyImageToBuffer2( CopyImageToBufferInfo2 const & copyImageToBufferInfo,
                             Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetEvent2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetEvent2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetEvent2 ), bool>::type = true>
    void
      setEvent2( Event event, DependencyInfo const * pDependencyInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetEvent2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetEvent2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetEvent2 ), bool>::type = true>
    void setEvent2( Event event, DependencyInfo const & dependencyInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdResetEvent2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResetEvent2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdResetEvent2 ), bool>::type = true>
    void resetEvent2( Event event, PipelineStageFlags2 stageMask, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdWaitEvents2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWaitEvents2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdWaitEvents2 ), bool>::type = true>
    void waitEvents2( uint32_t               eventCount,
                      Event const *          pEvents,
                      DependencyInfo const * pDependencyInfos,
                      Dispatch const & d     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdWaitEvents2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWaitEvents2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdWaitEvents2 ), bool>::type = true>
    void waitEvents2( ArrayProxy<Event const> const &          events,
                      ArrayProxy<DependencyInfo const> const & dependencyInfos,
                      Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBlitImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBlitImage2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBlitImage2 ), bool>::type = true>
    void blitImage2( BlitImageInfo2 const * pBlitImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBlitImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBlitImage2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBlitImage2 ), bool>::type = true>
    void blitImage2( BlitImageInfo2 const & blitImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdResolveImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResolveImage2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdResolveImage2 ), bool>::type = true>
    void resolveImage2( ResolveImageInfo2 const * pResolveImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdResolveImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResolveImage2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdResolveImage2 ), bool>::type = true>
    void resolveImage2( ResolveImageInfo2 const & resolveImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBeginRendering, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRendering.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginRendering ), bool>::type = true>
    void beginRendering( RenderingInfo const * pRenderingInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBeginRendering, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRendering.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginRendering ), bool>::type = true>
    void beginRendering( RenderingInfo const & renderingInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdEndRendering, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRendering.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndRendering ), bool>::type = true>
    void endRendering( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetCullMode, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCullMode.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetCullMode ), bool>::type = true>
    void setCullMode( CullModeFlags cullMode, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetFrontFace, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetFrontFace.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetFrontFace ), bool>::type = true>
    void setFrontFace( FrontFace frontFace, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetPrimitiveTopology, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPrimitiveTopology.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetPrimitiveTopology ), bool>::type = true>
    void setPrimitiveTopology( PrimitiveTopology primitiveTopology, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetViewportWithCount, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportWithCount.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetViewportWithCount ), bool>::type = true>
    void setViewportWithCount( uint32_t           viewportCount,
                               Viewport const *   pViewports,
                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetViewportWithCount, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportWithCount.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetViewportWithCount ), bool>::type = true>
    void setViewportWithCount( ArrayProxy<Viewport const> const & viewports,
                               Dispatch const & d                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetScissorWithCount, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetScissorWithCount.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetScissorWithCount ), bool>::type = true>
    void setScissorWithCount( uint32_t           scissorCount,
                              Rect2D const *     pScissors,
                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetScissorWithCount, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetScissorWithCount.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetScissorWithCount ), bool>::type = true>
    void setScissorWithCount( ArrayProxy<Rect2D const> const & scissors,
                              Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBindVertexBuffers2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindVertexBuffers2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindVertexBuffers2 ), bool>::type = true>
    void bindVertexBuffers2( uint32_t           firstBinding,
                             uint32_t           bindingCount,
                             Buffer const *     pBuffers,
                             DeviceSize const * pOffsets,
                             DeviceSize const * pSizes,
                             DeviceSize const * pStrides,
                             Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindVertexBuffers2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindVertexBuffers2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindVertexBuffers2 ), bool>::type = true>
    void bindVertexBuffers2( uint32_t                                     firstBinding,
                             ArrayProxy<Buffer const> const &             buffers,
                             ArrayProxy<DeviceSize const> const &         offsets,
                             ArrayProxy<DeviceSize const> const & sizes   VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                             ArrayProxy<DeviceSize const> const & strides VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                             Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetDepthTestEnable, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthTestEnable.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthTestEnable ), bool>::type = true>
    void setDepthTestEnable( Bool32 depthTestEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthWriteEnable, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthWriteEnable.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthWriteEnable ), bool>::type = true>
    void setDepthWriteEnable( Bool32 depthWriteEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthCompareOp, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthCompareOp.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthCompareOp ), bool>::type = true>
    void setDepthCompareOp( CompareOp depthCompareOp, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthBoundsTestEnable, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBoundsTestEnable.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthBoundsTestEnable ), bool>::type = true>
    void setDepthBoundsTestEnable( Bool32 depthBoundsTestEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetStencilTestEnable, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilTestEnable.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetStencilTestEnable ), bool>::type = true>
    void setStencilTestEnable( Bool32 stencilTestEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetStencilOp, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilOp.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetStencilOp ), bool>::type = true>
    void setStencilOp( StencilFaceFlags   faceMask,
                       StencilOp          failOp,
                       StencilOp          passOp,
                       StencilOp          depthFailOp,
                       CompareOp          compareOp,
                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetRasterizerDiscardEnable, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRasterizerDiscardEnable.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRasterizerDiscardEnable ), bool>::type = true>
    void setRasterizerDiscardEnable( Bool32 rasterizerDiscardEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthBiasEnable, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBiasEnable.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthBiasEnable ), bool>::type = true>
    void setDepthBiasEnable( Bool32 depthBiasEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetPrimitiveRestartEnable, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPrimitiveRestartEnable.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetPrimitiveRestartEnable ), bool>::type = true>
    void setPrimitiveRestartEnable( Bool32 primitiveRestartEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_VERSION_1_4 ===

    // wrapper function for command vkCmdPushDescriptorSet, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSet.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSet ), bool>::type = true>
    void pushDescriptorSet( PipelineBindPoint          pipelineBindPoint,
                            PipelineLayout             layout,
                            uint32_t                   set,
                            uint32_t                   descriptorWriteCount,
                            WriteDescriptorSet const * pDescriptorWrites,
                            Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushDescriptorSet, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSet.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSet ), bool>::type = true>
    void pushDescriptorSet( PipelineBindPoint                            pipelineBindPoint,
                            PipelineLayout                               layout,
                            uint32_t                                     set,
                            ArrayProxy<WriteDescriptorSet const> const & descriptorWrites,
                            Dispatch const & d                           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdPushDescriptorSetWithTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplate.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSetWithTemplate ), bool>::type = true>
    void pushDescriptorSetWithTemplate( DescriptorUpdateTemplate descriptorUpdateTemplate,
                                        PipelineLayout           layout,
                                        uint32_t                 set,
                                        void const *             pData,
                                        Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushDescriptorSetWithTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplate.html
    template <typename DataType,
              typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSetWithTemplate ), bool>::type = true>
    void pushDescriptorSetWithTemplate( DescriptorUpdateTemplate descriptorUpdateTemplate,
                                        PipelineLayout           layout,
                                        uint32_t                 set,
                                        DataType const &         data,
                                        Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBindDescriptorSets2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorSets2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindDescriptorSets2 ), bool>::type = true>
    void bindDescriptorSets2( BindDescriptorSetsInfo const * pBindDescriptorSetsInfo,
                              Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindDescriptorSets2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorSets2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindDescriptorSets2 ), bool>::type = true>
    void bindDescriptorSets2( BindDescriptorSetsInfo const & bindDescriptorSetsInfo,
                              Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdPushConstants2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushConstants2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushConstants2 ), bool>::type = true>
    void pushConstants2( PushConstantsInfo const * pPushConstantsInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushConstants2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushConstants2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushConstants2 ), bool>::type = true>
    void pushConstants2( PushConstantsInfo const & pushConstantsInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdPushDescriptorSet2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSet2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSet2 ), bool>::type = true>
    void pushDescriptorSet2( PushDescriptorSetInfo const * pPushDescriptorSetInfo,
                             Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushDescriptorSet2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSet2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSet2 ), bool>::type = true>
    void pushDescriptorSet2( PushDescriptorSetInfo const & pushDescriptorSetInfo,
                             Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdPushDescriptorSetWithTemplate2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplate2.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSetWithTemplate2 ), bool>::type = true>
    void pushDescriptorSetWithTemplate2( PushDescriptorSetWithTemplateInfo const * pPushDescriptorSetWithTemplateInfo,
                                         Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushDescriptorSetWithTemplate2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplate2.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSetWithTemplate2 ), bool>::type = true>
    void pushDescriptorSetWithTemplate2( PushDescriptorSetWithTemplateInfo const & pushDescriptorSetWithTemplateInfo,
                                         Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetLineStipple, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineStipple.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetLineStipple ), bool>::type = true>
    void setLineStipple( uint32_t           lineStippleFactor,
                         uint16_t           lineStipplePattern,
                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdBindIndexBuffer2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindIndexBuffer2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindIndexBuffer2 ), bool>::type = true>
    void bindIndexBuffer2( Buffer buffer, DeviceSize offset, DeviceSize size, IndexType indexType, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT )
      const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetRenderingAttachmentLocations, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingAttachmentLocations.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRenderingAttachmentLocations ), bool>::type = true>
    void setRenderingAttachmentLocations( RenderingAttachmentLocationInfo const * pLocationInfo,
                                          Dispatch const & d                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetRenderingAttachmentLocations, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingAttachmentLocations.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRenderingAttachmentLocations ), bool>::type = true>
    void setRenderingAttachmentLocations( RenderingAttachmentLocationInfo const & locationInfo,
                                          Dispatch const & d                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetRenderingInputAttachmentIndices, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingInputAttachmentIndices.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRenderingInputAttachmentIndices ), bool>::type = true>
    void setRenderingInputAttachmentIndices( RenderingInputAttachmentIndexInfo const * pInputAttachmentIndexInfo,
                                             Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetRenderingInputAttachmentIndices, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingInputAttachmentIndices.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRenderingInputAttachmentIndices ), bool>::type = true>
    void setRenderingInputAttachmentIndices( RenderingInputAttachmentIndexInfo const & inputAttachmentIndexInfo,
                                             Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_debug_marker ===

    // wrapper function for command vkCmdDebugMarkerBeginEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDebugMarkerBeginEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDebugMarkerBeginEXT ), bool>::type = true>
    void debugMarkerBeginEXT( DebugMarkerMarkerInfoEXT const * pMarkerInfo,
                              Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdDebugMarkerBeginEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDebugMarkerBeginEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDebugMarkerBeginEXT ), bool>::type = true>
    void debugMarkerBeginEXT( DebugMarkerMarkerInfoEXT const & markerInfo,
                              Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdDebugMarkerEndEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDebugMarkerEndEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDebugMarkerEndEXT ), bool>::type = true>
    void debugMarkerEndEXT( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDebugMarkerInsertEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDebugMarkerInsertEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDebugMarkerInsertEXT ), bool>::type = true>
    void debugMarkerInsertEXT( DebugMarkerMarkerInfoEXT const * pMarkerInfo,
                               Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdDebugMarkerInsertEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDebugMarkerInsertEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDebugMarkerInsertEXT ), bool>::type = true>
    void debugMarkerInsertEXT( DebugMarkerMarkerInfoEXT const & markerInfo,
                               Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_video_queue ===

    // wrapper function for command vkCmdBeginVideoCodingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginVideoCodingKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginVideoCodingKHR ), bool>::type = true>
    void beginVideoCodingKHR( VideoBeginCodingInfoKHR const * pBeginInfo,
                              Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBeginVideoCodingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginVideoCodingKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginVideoCodingKHR ), bool>::type = true>
    void beginVideoCodingKHR( VideoBeginCodingInfoKHR const & beginInfo,
                              Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdEndVideoCodingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndVideoCodingKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndVideoCodingKHR ), bool>::type = true>
    void endVideoCodingKHR( VideoEndCodingInfoKHR const * pEndCodingInfo,
                            Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdEndVideoCodingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndVideoCodingKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndVideoCodingKHR ), bool>::type = true>
    void endVideoCodingKHR( VideoEndCodingInfoKHR const & endCodingInfo,
                            Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdControlVideoCodingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdControlVideoCodingKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdControlVideoCodingKHR ), bool>::type = true>
    void controlVideoCodingKHR( VideoCodingControlInfoKHR const * pCodingControlInfo,
                                Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdControlVideoCodingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdControlVideoCodingKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdControlVideoCodingKHR ), bool>::type = true>
    void controlVideoCodingKHR( VideoCodingControlInfoKHR const & codingControlInfo,
                                Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_video_decode_queue ===

    // wrapper function for command vkCmdDecodeVideoKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecodeVideoKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDecodeVideoKHR ), bool>::type = true>
    void decodeVideoKHR( VideoDecodeInfoKHR const * pDecodeInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdDecodeVideoKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecodeVideoKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDecodeVideoKHR ), bool>::type = true>
    void decodeVideoKHR( VideoDecodeInfoKHR const & decodeInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_transform_feedback ===

    // wrapper function for command vkCmdBindTransformFeedbackBuffersEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindTransformFeedbackBuffersEXT.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBindTransformFeedbackBuffersEXT ), bool>::type = true>
    void bindTransformFeedbackBuffersEXT( uint32_t           firstBinding,
                                          uint32_t           bindingCount,
                                          Buffer const *     pBuffers,
                                          DeviceSize const * pOffsets,
                                          DeviceSize const * pSizes,
                                          Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindTransformFeedbackBuffersEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindTransformFeedbackBuffersEXT.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBindTransformFeedbackBuffersEXT ), bool>::type = true>
    void bindTransformFeedbackBuffersEXT( uint32_t                                   firstBinding,
                                          ArrayProxy<Buffer const> const &           buffers,
                                          ArrayProxy<DeviceSize const> const &       offsets,
                                          ArrayProxy<DeviceSize const> const & sizes VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                          Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBeginTransformFeedbackEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginTransformFeedbackEXT.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBeginTransformFeedbackEXT ), bool>::type = true>
    void beginTransformFeedbackEXT( uint32_t           firstCounterBuffer,
                                    uint32_t           counterBufferCount,
                                    Buffer const *     pCounterBuffers,
                                    DeviceSize const * pCounterBufferOffsets,
                                    Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBeginTransformFeedbackEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginTransformFeedbackEXT.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBeginTransformFeedbackEXT ), bool>::type = true>
    void beginTransformFeedbackEXT( uint32_t                                                  firstCounterBuffer,
                                    ArrayProxy<Buffer const> const &                          counterBuffers,
                                    ArrayProxy<DeviceSize const> const & counterBufferOffsets VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                    Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdEndTransformFeedbackEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndTransformFeedbackEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndTransformFeedbackEXT ), bool>::type = true>
    void endTransformFeedbackEXT( uint32_t           firstCounterBuffer,
                                  uint32_t           counterBufferCount,
                                  Buffer const *     pCounterBuffers,
                                  DeviceSize const * pCounterBufferOffsets,
                                  Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdEndTransformFeedbackEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndTransformFeedbackEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndTransformFeedbackEXT ), bool>::type = true>
    void endTransformFeedbackEXT( uint32_t                                                  firstCounterBuffer,
                                  ArrayProxy<Buffer const> const &                          counterBuffers,
                                  ArrayProxy<DeviceSize const> const & counterBufferOffsets VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                  Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBeginQueryIndexedEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginQueryIndexedEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginQueryIndexedEXT ), bool>::type = true>
    void beginQueryIndexedEXT( QueryPool          queryPool,
                               uint32_t           query,
                               QueryControlFlags  flags,
                               uint32_t           index,
                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdEndQueryIndexedEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndQueryIndexedEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndQueryIndexedEXT ), bool>::type = true>
    void endQueryIndexedEXT( QueryPool          queryPool,
                             uint32_t           query,
                             uint32_t           index,
                             Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawIndirectByteCountEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirectByteCountEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDrawIndirectByteCountEXT ), bool>::type = true>
    void drawIndirectByteCountEXT( uint32_t           instanceCount,
                                   uint32_t           firstInstance,
                                   Buffer             counterBuffer,
                                   DeviceSize         counterBufferOffset,
                                   uint32_t           counterOffset,
                                   uint32_t           vertexStride,
                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_NVX_binary_import ===

    // wrapper function for command vkCmdCuLaunchKernelNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCuLaunchKernelNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCuLaunchKernelNVX ), bool>::type = true>
    void cuLaunchKernelNVX( CuLaunchInfoNVX const * pLaunchInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCuLaunchKernelNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCuLaunchKernelNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCuLaunchKernelNVX ), bool>::type = true>
    void cuLaunchKernelNVX( CuLaunchInfoNVX const & launchInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_AMD_draw_indirect_count ===

    // wrapper function for command vkCmdDrawIndirectCountAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirectCountAMD.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawIndirectCountAMD ), bool>::type = true>
    void drawIndirectCountAMD( Buffer             buffer,
                               DeviceSize         offset,
                               Buffer             countBuffer,
                               DeviceSize         countBufferOffset,
                               uint32_t           maxDrawCount,
                               uint32_t           stride,
                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawIndexedIndirectCountAMD, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexedIndirectCountAMD.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDrawIndexedIndirectCountAMD ), bool>::type = true>
    void drawIndexedIndirectCountAMD( Buffer             buffer,
                                      DeviceSize         offset,
                                      Buffer             countBuffer,
                                      DeviceSize         countBufferOffset,
                                      uint32_t           maxDrawCount,
                                      uint32_t           stride,
                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_KHR_dynamic_rendering ===

    // wrapper function for command vkCmdBeginRenderingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderingKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginRenderingKHR ), bool>::type = true>
    void beginRenderingKHR( RenderingInfo const * pRenderingInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBeginRenderingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderingKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginRenderingKHR ), bool>::type = true>
    void beginRenderingKHR( RenderingInfo const & renderingInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdEndRenderingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderingKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndRenderingKHR ), bool>::type = true>
    void endRenderingKHR( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_KHR_device_group ===

    // wrapper function for command vkCmdSetDeviceMaskKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDeviceMaskKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDeviceMaskKHR ), bool>::type = true>
    void setDeviceMaskKHR( uint32_t deviceMask, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDispatchBaseKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchBaseKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDispatchBaseKHR ), bool>::type = true>
    void dispatchBaseKHR( uint32_t           baseGroupX,
                          uint32_t           baseGroupY,
                          uint32_t           baseGroupZ,
                          uint32_t           groupCountX,
                          uint32_t           groupCountY,
                          uint32_t           groupCountZ,
                          Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_KHR_push_descriptor ===

    // wrapper function for command vkCmdPushDescriptorSetKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSetKHR ), bool>::type = true>
    void pushDescriptorSetKHR( PipelineBindPoint          pipelineBindPoint,
                               PipelineLayout             layout,
                               uint32_t                   set,
                               uint32_t                   descriptorWriteCount,
                               WriteDescriptorSet const * pDescriptorWrites,
                               Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushDescriptorSetKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSetKHR ), bool>::type = true>
    void pushDescriptorSetKHR( PipelineBindPoint                            pipelineBindPoint,
                               PipelineLayout                               layout,
                               uint32_t                                     set,
                               ArrayProxy<WriteDescriptorSet const> const & descriptorWrites,
                               Dispatch const & d                           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdPushDescriptorSetWithTemplateKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplateKHR.html
    template <typename Dispatch                                                                           = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSetWithTemplateKHR ), bool>::type = true>
    void pushDescriptorSetWithTemplateKHR( DescriptorUpdateTemplate descriptorUpdateTemplate,
                                           PipelineLayout           layout,
                                           uint32_t                 set,
                                           void const *             pData,
                                           Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushDescriptorSetWithTemplateKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplateKHR.html
    template <typename DataType,
              typename Dispatch                                                                           = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSetWithTemplateKHR ), bool>::type = true>
    void pushDescriptorSetWithTemplateKHR( DescriptorUpdateTemplate descriptorUpdateTemplate,
                                           PipelineLayout           layout,
                                           uint32_t                 set,
                                           DataType const &         data,
                                           Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_conditional_rendering ===

    // wrapper function for command vkCmdBeginConditionalRenderingEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginConditionalRenderingEXT.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBeginConditionalRenderingEXT ), bool>::type = true>
    void beginConditionalRenderingEXT( ConditionalRenderingBeginInfoEXT const * pConditionalRenderingBegin,
                                       Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBeginConditionalRenderingEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginConditionalRenderingEXT.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBeginConditionalRenderingEXT ), bool>::type = true>
    void beginConditionalRenderingEXT( ConditionalRenderingBeginInfoEXT const & conditionalRenderingBegin,
                                       Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdEndConditionalRenderingEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndConditionalRenderingEXT.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdEndConditionalRenderingEXT ), bool>::type = true>
    void endConditionalRenderingEXT( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_NV_clip_space_w_scaling ===

    // wrapper function for command vkCmdSetViewportWScalingNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportWScalingNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetViewportWScalingNV ), bool>::type = true>
    void setViewportWScalingNV( uint32_t                   firstViewport,
                                uint32_t                   viewportCount,
                                ViewportWScalingNV const * pViewportWScalings,
                                Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetViewportWScalingNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportWScalingNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetViewportWScalingNV ), bool>::type = true>
    void setViewportWScalingNV( uint32_t                                     firstViewport,
                                ArrayProxy<ViewportWScalingNV const> const & viewportWScalings,
                                Dispatch const & d                           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_discard_rectangles ===

    // wrapper function for command vkCmdSetDiscardRectangleEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDiscardRectangleEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDiscardRectangleEXT ), bool>::type = true>
    void setDiscardRectangleEXT( uint32_t           firstDiscardRectangle,
                                 uint32_t           discardRectangleCount,
                                 Rect2D const *     pDiscardRectangles,
                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetDiscardRectangleEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDiscardRectangleEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDiscardRectangleEXT ), bool>::type = true>
    void setDiscardRectangleEXT( uint32_t                         firstDiscardRectangle,
                                 ArrayProxy<Rect2D const> const & discardRectangles,
                                 Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetDiscardRectangleEnableEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDiscardRectangleEnableEXT.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetDiscardRectangleEnableEXT ), bool>::type = true>
    void setDiscardRectangleEnableEXT( Bool32 discardRectangleEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDiscardRectangleModeEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDiscardRectangleModeEXT.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetDiscardRectangleModeEXT ), bool>::type = true>
    void setDiscardRectangleModeEXT( DiscardRectangleModeEXT discardRectangleMode,
                                     Dispatch const & d      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_KHR_create_renderpass2 ===

    // wrapper function for command vkCmdBeginRenderPass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderPass2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginRenderPass2KHR ), bool>::type = true>
    void beginRenderPass2KHR( RenderPassBeginInfo const * pRenderPassBegin,
                              SubpassBeginInfo const *    pSubpassBeginInfo,
                              Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBeginRenderPass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderPass2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginRenderPass2KHR ), bool>::type = true>
    void beginRenderPass2KHR( RenderPassBeginInfo const & renderPassBegin,
                              SubpassBeginInfo const &    subpassBeginInfo,
                              Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdNextSubpass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdNextSubpass2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdNextSubpass2KHR ), bool>::type = true>
    void nextSubpass2KHR( SubpassBeginInfo const * pSubpassBeginInfo,
                          SubpassEndInfo const *   pSubpassEndInfo,
                          Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdNextSubpass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdNextSubpass2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdNextSubpass2KHR ), bool>::type = true>
    void nextSubpass2KHR( SubpassBeginInfo const & subpassBeginInfo,
                          SubpassEndInfo const &   subpassEndInfo,
                          Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdEndRenderPass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderPass2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndRenderPass2KHR ), bool>::type = true>
    void endRenderPass2KHR( SubpassEndInfo const * pSubpassEndInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdEndRenderPass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderPass2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndRenderPass2KHR ), bool>::type = true>
    void endRenderPass2KHR( SubpassEndInfo const & subpassEndInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_debug_utils ===

    // wrapper function for command vkCmdBeginDebugUtilsLabelEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginDebugUtilsLabelEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginDebugUtilsLabelEXT ), bool>::type = true>
    void beginDebugUtilsLabelEXT( DebugUtilsLabelEXT const * pLabelInfo,
                                  Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBeginDebugUtilsLabelEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginDebugUtilsLabelEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginDebugUtilsLabelEXT ), bool>::type = true>
    void beginDebugUtilsLabelEXT( DebugUtilsLabelEXT const & labelInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdEndDebugUtilsLabelEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndDebugUtilsLabelEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndDebugUtilsLabelEXT ), bool>::type = true>
    void endDebugUtilsLabelEXT( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdInsertDebugUtilsLabelEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdInsertDebugUtilsLabelEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdInsertDebugUtilsLabelEXT ), bool>::type = true>
    void insertDebugUtilsLabelEXT( DebugUtilsLabelEXT const * pLabelInfo,
                                   Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdInsertDebugUtilsLabelEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdInsertDebugUtilsLabelEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdInsertDebugUtilsLabelEXT ), bool>::type = true>
    void insertDebugUtilsLabelEXT( DebugUtilsLabelEXT const & labelInfo,
                                   Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#if defined( VK_ENABLE_BETA_EXTENSIONS )
    //=== VK_AMDX_shader_enqueue ===

    // wrapper function for command vkCmdInitializeGraphScratchMemoryAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdInitializeGraphScratchMemoryAMDX.html
    template <typename Dispatch                                                                           = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdInitializeGraphScratchMemoryAMDX ), bool>::type = true>
    void initializeGraphScratchMemoryAMDX( Pipeline           executionGraph,
                                           DeviceAddress      scratch,
                                           DeviceSize         scratchSize,
                                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDispatchGraphAMDX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchGraphAMDX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDispatchGraphAMDX ), bool>::type = true>
    void dispatchGraphAMDX( DeviceAddress                      scratch,
                            DeviceSize                         scratchSize,
                            DispatchGraphCountInfoAMDX const * pCountInfo,
                            Dispatch const & d                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdDispatchGraphAMDX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchGraphAMDX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDispatchGraphAMDX ), bool>::type = true>
    void dispatchGraphAMDX( DeviceAddress                      scratch,
                            DeviceSize                         scratchSize,
                            DispatchGraphCountInfoAMDX const & countInfo,
                            Dispatch const & d                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdDispatchGraphIndirectAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchGraphIndirectAMDX.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDispatchGraphIndirectAMDX ), bool>::type = true>
    void dispatchGraphIndirectAMDX( DeviceAddress                      scratch,
                                    DeviceSize                         scratchSize,
                                    DispatchGraphCountInfoAMDX const * pCountInfo,
                                    Dispatch const & d                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdDispatchGraphIndirectAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchGraphIndirectAMDX.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDispatchGraphIndirectAMDX ), bool>::type = true>
    void dispatchGraphIndirectAMDX( DeviceAddress                      scratch,
                                    DeviceSize                         scratchSize,
                                    DispatchGraphCountInfoAMDX const & countInfo,
                                    Dispatch const & d                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdDispatchGraphIndirectCountAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchGraphIndirectCountAMDX.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDispatchGraphIndirectCountAMDX ), bool>::type = true>
    void dispatchGraphIndirectCountAMDX( DeviceAddress      scratch,
                                         DeviceSize         scratchSize,
                                         DeviceAddress      countInfo,
                                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

    //=== VK_EXT_descriptor_heap ===

    // wrapper function for command vkCmdBindSamplerHeapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindSamplerHeapEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindSamplerHeapEXT ), bool>::type = true>
    void bindSamplerHeapEXT( BindHeapInfoEXT const * pBindInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindSamplerHeapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindSamplerHeapEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindSamplerHeapEXT ), bool>::type = true>
    void bindSamplerHeapEXT( BindHeapInfoEXT const & bindInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBindResourceHeapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindResourceHeapEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindResourceHeapEXT ), bool>::type = true>
    void bindResourceHeapEXT( BindHeapInfoEXT const * pBindInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindResourceHeapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindResourceHeapEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindResourceHeapEXT ), bool>::type = true>
    void bindResourceHeapEXT( BindHeapInfoEXT const & bindInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdPushDataEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDataEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushDataEXT ), bool>::type = true>
    void pushDataEXT( PushDataInfoEXT const * pPushDataInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushDataEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDataEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushDataEXT ), bool>::type = true>
    void pushDataEXT( PushDataInfoEXT const & pushDataInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_sample_locations ===

    // wrapper function for command vkCmdSetSampleLocationsEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetSampleLocationsEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetSampleLocationsEXT ), bool>::type = true>
    void setSampleLocationsEXT( SampleLocationsInfoEXT const * pSampleLocationsInfo,
                                Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetSampleLocationsEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetSampleLocationsEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetSampleLocationsEXT ), bool>::type = true>
    void setSampleLocationsEXT( SampleLocationsInfoEXT const & sampleLocationsInfo,
                                Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_acceleration_structure ===

    // wrapper function for command vkCmdBuildAccelerationStructuresKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildAccelerationStructuresKHR.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBuildAccelerationStructuresKHR ), bool>::type = true>
    void buildAccelerationStructuresKHR( uint32_t                                               infoCount,
                                         AccelerationStructureBuildGeometryInfoKHR const *      pInfos,
                                         AccelerationStructureBuildRangeInfoKHR const * const * ppBuildRangeInfos,
                                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBuildAccelerationStructuresKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildAccelerationStructuresKHR.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBuildAccelerationStructuresKHR ), bool>::type = true>
    void buildAccelerationStructuresKHR( ArrayProxy<AccelerationStructureBuildGeometryInfoKHR const> const &      infos,
                                         ArrayProxy<AccelerationStructureBuildRangeInfoKHR const * const> const & pBuildRangeInfos,
                                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBuildAccelerationStructuresIndirectKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildAccelerationStructuresIndirectKHR.html
    template <typename Dispatch                                                                                 = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBuildAccelerationStructuresIndirectKHR ), bool>::type = true>
    void buildAccelerationStructuresIndirectKHR( uint32_t                                          infoCount,
                                                 AccelerationStructureBuildGeometryInfoKHR const * pInfos,
                                                 DeviceAddress const *                             pIndirectDeviceAddresses,
                                                 uint32_t const *                                  pIndirectStrides,
                                                 uint32_t const * const *                          ppMaxPrimitiveCounts,
                                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBuildAccelerationStructuresIndirectKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildAccelerationStructuresIndirectKHR.html
    template <typename Dispatch                                                                                 = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBuildAccelerationStructuresIndirectKHR ), bool>::type = true>
    void buildAccelerationStructuresIndirectKHR( ArrayProxy<AccelerationStructureBuildGeometryInfoKHR const> const & infos,
                                                 ArrayProxy<DeviceAddress const> const &                             indirectDeviceAddresses,
                                                 ArrayProxy<uint32_t const> const &                                  indirectStrides,
                                                 ArrayProxy<uint32_t const * const> const &                          pMaxPrimitiveCounts,
                                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyAccelerationStructureKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdCopyAccelerationStructureKHR ), bool>::type = true>
    void copyAccelerationStructureKHR( CopyAccelerationStructureInfoKHR const * pInfo,
                                       Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyAccelerationStructureKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdCopyAccelerationStructureKHR ), bool>::type = true>
    void copyAccelerationStructureKHR( CopyAccelerationStructureInfoKHR const & info,
                                       Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyAccelerationStructureToMemoryKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyAccelerationStructureToMemoryKHR.html
    template <typename Dispatch                                                                               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdCopyAccelerationStructureToMemoryKHR ), bool>::type = true>
    void copyAccelerationStructureToMemoryKHR( CopyAccelerationStructureToMemoryInfoKHR const * pInfo,
                                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyAccelerationStructureToMemoryKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyAccelerationStructureToMemoryKHR.html
    template <typename Dispatch                                                                               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdCopyAccelerationStructureToMemoryKHR ), bool>::type = true>
    void copyAccelerationStructureToMemoryKHR( CopyAccelerationStructureToMemoryInfoKHR const & info,
                                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyMemoryToAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToAccelerationStructureKHR.html
    template <typename Dispatch                                                                               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdCopyMemoryToAccelerationStructureKHR ), bool>::type = true>
    void copyMemoryToAccelerationStructureKHR( CopyMemoryToAccelerationStructureInfoKHR const * pInfo,
                                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyMemoryToAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToAccelerationStructureKHR.html
    template <typename Dispatch                                                                               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdCopyMemoryToAccelerationStructureKHR ), bool>::type = true>
    void copyMemoryToAccelerationStructureKHR( CopyMemoryToAccelerationStructureInfoKHR const & info,
                                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdWriteAccelerationStructuresPropertiesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteAccelerationStructuresPropertiesKHR.html
    template <typename Dispatch                                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdWriteAccelerationStructuresPropertiesKHR ), bool>::type = true>
    void writeAccelerationStructuresPropertiesKHR( uint32_t                         accelerationStructureCount,
                                                   AccelerationStructureKHR const * pAccelerationStructures,
                                                   QueryType                        queryType,
                                                   QueryPool                        queryPool,
                                                   uint32_t                         firstQuery,
                                                   Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdWriteAccelerationStructuresPropertiesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteAccelerationStructuresPropertiesKHR.html
    template <typename Dispatch                                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdWriteAccelerationStructuresPropertiesKHR ), bool>::type = true>
    void writeAccelerationStructuresPropertiesKHR( ArrayProxy<AccelerationStructureKHR const> const & accelerationStructures,
                                                   QueryType                                          queryType,
                                                   QueryPool                                          queryPool,
                                                   uint32_t                                           firstQuery,
                                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_ray_tracing_pipeline ===

    // wrapper function for command vkCmdTraceRaysKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdTraceRaysKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdTraceRaysKHR ), bool>::type = true>
    void traceRaysKHR( StridedDeviceAddressRegionKHR const * pRaygenShaderBindingTable,
                       StridedDeviceAddressRegionKHR const * pMissShaderBindingTable,
                       StridedDeviceAddressRegionKHR const * pHitShaderBindingTable,
                       StridedDeviceAddressRegionKHR const * pCallableShaderBindingTable,
                       uint32_t                              width,
                       uint32_t                              height,
                       uint32_t                              depth,
                       Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdTraceRaysKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdTraceRaysKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdTraceRaysKHR ), bool>::type = true>
    void traceRaysKHR( StridedDeviceAddressRegionKHR const & raygenShaderBindingTable,
                       StridedDeviceAddressRegionKHR const & missShaderBindingTable,
                       StridedDeviceAddressRegionKHR const & hitShaderBindingTable,
                       StridedDeviceAddressRegionKHR const & callableShaderBindingTable,
                       uint32_t                              width,
                       uint32_t                              height,
                       uint32_t                              depth,
                       Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdTraceRaysIndirectKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdTraceRaysIndirectKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdTraceRaysIndirectKHR ), bool>::type = true>
    void traceRaysIndirectKHR( StridedDeviceAddressRegionKHR const * pRaygenShaderBindingTable,
                               StridedDeviceAddressRegionKHR const * pMissShaderBindingTable,
                               StridedDeviceAddressRegionKHR const * pHitShaderBindingTable,
                               StridedDeviceAddressRegionKHR const * pCallableShaderBindingTable,
                               DeviceAddress                         indirectDeviceAddress,
                               Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdTraceRaysIndirectKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdTraceRaysIndirectKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdTraceRaysIndirectKHR ), bool>::type = true>
    void traceRaysIndirectKHR( StridedDeviceAddressRegionKHR const & raygenShaderBindingTable,
                               StridedDeviceAddressRegionKHR const & missShaderBindingTable,
                               StridedDeviceAddressRegionKHR const & hitShaderBindingTable,
                               StridedDeviceAddressRegionKHR const & callableShaderBindingTable,
                               DeviceAddress                         indirectDeviceAddress,
                               Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetRayTracingPipelineStackSizeKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRayTracingPipelineStackSizeKHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRayTracingPipelineStackSizeKHR ), bool>::type = true>
    void setRayTracingPipelineStackSizeKHR( uint32_t pipelineStackSize, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_NV_shading_rate_image ===

    // wrapper function for command vkCmdBindShadingRateImageNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindShadingRateImageNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindShadingRateImageNV ), bool>::type = true>
    void bindShadingRateImageNV( ImageView          imageView,
                                 ImageLayout        imageLayout,
                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetViewportShadingRatePaletteNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportShadingRatePaletteNV.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetViewportShadingRatePaletteNV ), bool>::type = true>
    void setViewportShadingRatePaletteNV( uint32_t                     firstViewport,
                                          uint32_t                     viewportCount,
                                          ShadingRatePaletteNV const * pShadingRatePalettes,
                                          Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetViewportShadingRatePaletteNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportShadingRatePaletteNV.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetViewportShadingRatePaletteNV ), bool>::type = true>
    void setViewportShadingRatePaletteNV( uint32_t                                       firstViewport,
                                          ArrayProxy<ShadingRatePaletteNV const> const & shadingRatePalettes,
                                          Dispatch const & d                             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetCoarseSampleOrderNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoarseSampleOrderNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetCoarseSampleOrderNV ), bool>::type = true>
    void setCoarseSampleOrderNV( CoarseSampleOrderTypeNV           sampleOrderType,
                                 uint32_t                          customSampleOrderCount,
                                 CoarseSampleOrderCustomNV const * pCustomSampleOrders,
                                 Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetCoarseSampleOrderNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoarseSampleOrderNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetCoarseSampleOrderNV ), bool>::type = true>
    void setCoarseSampleOrderNV( CoarseSampleOrderTypeNV                             sampleOrderType,
                                 ArrayProxy<CoarseSampleOrderCustomNV const> const & customSampleOrders,
                                 Dispatch const & d                                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_NV_ray_tracing ===

    // wrapper function for command vkCmdBuildAccelerationStructureNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildAccelerationStructureNV.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBuildAccelerationStructureNV ), bool>::type = true>
    void buildAccelerationStructureNV( AccelerationStructureInfoNV const * pInfo,
                                       Buffer                              instanceData,
                                       DeviceSize                          instanceOffset,
                                       Bool32                              update,
                                       AccelerationStructureNV             dst,
                                       AccelerationStructureNV             src,
                                       Buffer                              scratch,
                                       DeviceSize                          scratchOffset,
                                       Dispatch const & d                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBuildAccelerationStructureNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildAccelerationStructureNV.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBuildAccelerationStructureNV ), bool>::type = true>
    void buildAccelerationStructureNV( AccelerationStructureInfoNV const & info,
                                       Buffer                              instanceData,
                                       DeviceSize                          instanceOffset,
                                       Bool32                              update,
                                       AccelerationStructureNV             dst,
                                       AccelerationStructureNV             src,
                                       Buffer                              scratch,
                                       DeviceSize                          scratchOffset,
                                       Dispatch const & d                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyAccelerationStructureNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyAccelerationStructureNV.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdCopyAccelerationStructureNV ), bool>::type = true>
    void copyAccelerationStructureNV( AccelerationStructureNV          dst,
                                      AccelerationStructureNV          src,
                                      CopyAccelerationStructureModeKHR mode,
                                      Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdTraceRaysNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdTraceRaysNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdTraceRaysNV ), bool>::type = true>
    void traceRaysNV( Buffer             raygenShaderBindingTableBuffer,
                      DeviceSize         raygenShaderBindingOffset,
                      Buffer             missShaderBindingTableBuffer,
                      DeviceSize         missShaderBindingOffset,
                      DeviceSize         missShaderBindingStride,
                      Buffer             hitShaderBindingTableBuffer,
                      DeviceSize         hitShaderBindingOffset,
                      DeviceSize         hitShaderBindingStride,
                      Buffer             callableShaderBindingTableBuffer,
                      DeviceSize         callableShaderBindingOffset,
                      DeviceSize         callableShaderBindingStride,
                      uint32_t           width,
                      uint32_t           height,
                      uint32_t           depth,
                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdWriteAccelerationStructuresPropertiesNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteAccelerationStructuresPropertiesNV.html
    template <typename Dispatch                                                                                  = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdWriteAccelerationStructuresPropertiesNV ), bool>::type = true>
    void writeAccelerationStructuresPropertiesNV( uint32_t                        accelerationStructureCount,
                                                  AccelerationStructureNV const * pAccelerationStructures,
                                                  QueryType                       queryType,
                                                  QueryPool                       queryPool,
                                                  uint32_t                        firstQuery,
                                                  Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdWriteAccelerationStructuresPropertiesNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteAccelerationStructuresPropertiesNV.html
    template <typename Dispatch                                                                                  = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdWriteAccelerationStructuresPropertiesNV ), bool>::type = true>
    void writeAccelerationStructuresPropertiesNV( ArrayProxy<AccelerationStructureNV const> const & accelerationStructures,
                                                  QueryType                                         queryType,
                                                  QueryPool                                         queryPool,
                                                  uint32_t                                          firstQuery,
                                                  Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_draw_indirect_count ===

    // wrapper function for command vkCmdDrawIndirectCountKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirectCountKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawIndirectCountKHR ), bool>::type = true>
    void drawIndirectCountKHR( Buffer             buffer,
                               DeviceSize         offset,
                               Buffer             countBuffer,
                               DeviceSize         countBufferOffset,
                               uint32_t           maxDrawCount,
                               uint32_t           stride,
                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawIndexedIndirectCountKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexedIndirectCountKHR.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDrawIndexedIndirectCountKHR ), bool>::type = true>
    void drawIndexedIndirectCountKHR( Buffer             buffer,
                                      DeviceSize         offset,
                                      Buffer             countBuffer,
                                      DeviceSize         countBufferOffset,
                                      uint32_t           maxDrawCount,
                                      uint32_t           stride,
                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_AMD_buffer_marker ===

    // wrapper function for command vkCmdWriteBufferMarkerAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteBufferMarkerAMD.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdWriteBufferMarkerAMD ), bool>::type = true>
    void writeBufferMarkerAMD( PipelineStageFlagBits pipelineStage,
                               Buffer                dstBuffer,
                               DeviceSize            dstOffset,
                               uint32_t              marker,
                               Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdWriteBufferMarker2AMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteBufferMarker2AMD.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdWriteBufferMarker2AMD ), bool>::type = true>
    void writeBufferMarker2AMD( PipelineStageFlags2 stage,
                                Buffer              dstBuffer,
                                DeviceSize          dstOffset,
                                uint32_t            marker,
                                Dispatch const & d  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_NV_mesh_shader ===

    // wrapper function for command vkCmdDrawMeshTasksNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawMeshTasksNV ), bool>::type = true>
    void drawMeshTasksNV( uint32_t taskCount, uint32_t firstTask, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawMeshTasksIndirectNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksIndirectNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawMeshTasksIndirectNV ), bool>::type = true>
    void drawMeshTasksIndirectNV( Buffer             buffer,
                                  DeviceSize         offset,
                                  uint32_t           drawCount,
                                  uint32_t           stride,
                                  Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawMeshTasksIndirectCountNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksIndirectCountNV.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDrawMeshTasksIndirectCountNV ), bool>::type = true>
    void drawMeshTasksIndirectCountNV( Buffer             buffer,
                                       DeviceSize         offset,
                                       Buffer             countBuffer,
                                       DeviceSize         countBufferOffset,
                                       uint32_t           maxDrawCount,
                                       uint32_t           stride,
                                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_NV_scissor_exclusive ===

    // wrapper function for command vkCmdSetExclusiveScissorEnableNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetExclusiveScissorEnableNV.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetExclusiveScissorEnableNV ), bool>::type = true>
    void setExclusiveScissorEnableNV( uint32_t           firstExclusiveScissor,
                                      uint32_t           exclusiveScissorCount,
                                      Bool32 const *     pExclusiveScissorEnables,
                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetExclusiveScissorEnableNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetExclusiveScissorEnableNV.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetExclusiveScissorEnableNV ), bool>::type = true>
    void setExclusiveScissorEnableNV( uint32_t                         firstExclusiveScissor,
                                      ArrayProxy<Bool32 const> const & exclusiveScissorEnables,
                                      Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetExclusiveScissorNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetExclusiveScissorNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetExclusiveScissorNV ), bool>::type = true>
    void setExclusiveScissorNV( uint32_t           firstExclusiveScissor,
                                uint32_t           exclusiveScissorCount,
                                Rect2D const *     pExclusiveScissors,
                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetExclusiveScissorNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetExclusiveScissorNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetExclusiveScissorNV ), bool>::type = true>
    void setExclusiveScissorNV( uint32_t                         firstExclusiveScissor,
                                ArrayProxy<Rect2D const> const & exclusiveScissors,
                                Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_NV_device_diagnostic_checkpoints ===

    // wrapper function for command vkCmdSetCheckpointNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCheckpointNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetCheckpointNV ), bool>::type = true>
    void setCheckpointNV( void const * pCheckpointMarker, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetCheckpointNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCheckpointNV.html
    template <typename CheckpointMarkerType,
              typename Dispatch                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetCheckpointNV ), bool>::type = true>
    void setCheckpointNV( CheckpointMarkerType const & checkpointMarker,
                          Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_INTEL_performance_query ===

    // wrapper function for command vkCmdSetPerformanceMarkerINTEL, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPerformanceMarkerINTEL.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetPerformanceMarkerINTEL ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result setPerformanceMarkerINTEL( PerformanceMarkerInfoINTEL const * pMarkerInfo,
                                                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetPerformanceMarkerINTEL, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPerformanceMarkerINTEL.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetPerformanceMarkerINTEL ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      setPerformanceMarkerINTEL( PerformanceMarkerInfoINTEL const & markerInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetPerformanceStreamMarkerINTEL, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPerformanceStreamMarkerINTEL.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetPerformanceStreamMarkerINTEL ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result setPerformanceStreamMarkerINTEL( PerformanceStreamMarkerInfoINTEL const * pMarkerInfo,
                                                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetPerformanceStreamMarkerINTEL, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPerformanceStreamMarkerINTEL.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetPerformanceStreamMarkerINTEL ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      setPerformanceStreamMarkerINTEL( PerformanceStreamMarkerInfoINTEL const & markerInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetPerformanceOverrideINTEL, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPerformanceOverrideINTEL.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetPerformanceOverrideINTEL ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result setPerformanceOverrideINTEL( PerformanceOverrideInfoINTEL const * pOverrideInfo,
                                                             Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetPerformanceOverrideINTEL, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPerformanceOverrideINTEL.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetPerformanceOverrideINTEL ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      setPerformanceOverrideINTEL( PerformanceOverrideInfoINTEL const & overrideInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_fragment_shading_rate ===

    // wrapper function for command vkCmdSetFragmentShadingRateKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetFragmentShadingRateKHR.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetFragmentShadingRateKHR ), bool>::type = true>
    void setFragmentShadingRateKHR( Extent2D const *                       pFragmentSize,
                                    FragmentShadingRateCombinerOpKHR const combinerOps[2],
                                    Dispatch const & d                     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetFragmentShadingRateKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetFragmentShadingRateKHR.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetFragmentShadingRateKHR ), bool>::type = true>
    void setFragmentShadingRateKHR( Extent2D const &                       fragmentSize,
                                    FragmentShadingRateCombinerOpKHR const combinerOps[2],
                                    Dispatch const & d                     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_dynamic_rendering_local_read ===

    // wrapper function for command vkCmdSetRenderingAttachmentLocationsKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingAttachmentLocationsKHR.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRenderingAttachmentLocationsKHR ), bool>::type = true>
    void setRenderingAttachmentLocationsKHR( RenderingAttachmentLocationInfo const * pLocationInfo,
                                             Dispatch const & d                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetRenderingAttachmentLocationsKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingAttachmentLocationsKHR.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRenderingAttachmentLocationsKHR ), bool>::type = true>
    void setRenderingAttachmentLocationsKHR( RenderingAttachmentLocationInfo const & locationInfo,
                                             Dispatch const & d                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetRenderingInputAttachmentIndicesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingInputAttachmentIndicesKHR.html
    template <typename Dispatch                                                                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRenderingInputAttachmentIndicesKHR ), bool>::type = true>
    void setRenderingInputAttachmentIndicesKHR( RenderingInputAttachmentIndexInfo const * pInputAttachmentIndexInfo,
                                                Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetRenderingInputAttachmentIndicesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingInputAttachmentIndicesKHR.html
    template <typename Dispatch                                                                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRenderingInputAttachmentIndicesKHR ), bool>::type = true>
    void setRenderingInputAttachmentIndicesKHR( RenderingInputAttachmentIndexInfo const & inputAttachmentIndexInfo,
                                                Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_line_rasterization ===

    // wrapper function for command vkCmdSetLineStippleEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineStippleEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetLineStippleEXT ), bool>::type = true>
    void setLineStippleEXT( uint32_t           lineStippleFactor,
                            uint16_t           lineStipplePattern,
                            Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_EXT_extended_dynamic_state ===

    // wrapper function for command vkCmdSetCullModeEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCullModeEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetCullModeEXT ), bool>::type = true>
    void setCullModeEXT( CullModeFlags cullMode, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetFrontFaceEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetFrontFaceEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetFrontFaceEXT ), bool>::type = true>
    void setFrontFaceEXT( FrontFace frontFace, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetPrimitiveTopologyEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPrimitiveTopologyEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetPrimitiveTopologyEXT ), bool>::type = true>
    void setPrimitiveTopologyEXT( PrimitiveTopology primitiveTopology, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetViewportWithCountEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportWithCountEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetViewportWithCountEXT ), bool>::type = true>
    void setViewportWithCountEXT( uint32_t           viewportCount,
                                  Viewport const *   pViewports,
                                  Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetViewportWithCountEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportWithCountEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetViewportWithCountEXT ), bool>::type = true>
    void setViewportWithCountEXT( ArrayProxy<Viewport const> const & viewports,
                                  Dispatch const & d                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetScissorWithCountEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetScissorWithCountEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetScissorWithCountEXT ), bool>::type = true>
    void setScissorWithCountEXT( uint32_t           scissorCount,
                                 Rect2D const *     pScissors,
                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetScissorWithCountEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetScissorWithCountEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetScissorWithCountEXT ), bool>::type = true>
    void setScissorWithCountEXT( ArrayProxy<Rect2D const> const & scissors,
                                 Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBindVertexBuffers2EXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindVertexBuffers2EXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindVertexBuffers2EXT ), bool>::type = true>
    void bindVertexBuffers2EXT( uint32_t           firstBinding,
                                uint32_t           bindingCount,
                                Buffer const *     pBuffers,
                                DeviceSize const * pOffsets,
                                DeviceSize const * pSizes,
                                DeviceSize const * pStrides,
                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindVertexBuffers2EXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindVertexBuffers2EXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindVertexBuffers2EXT ), bool>::type = true>
    void bindVertexBuffers2EXT( uint32_t                                     firstBinding,
                                ArrayProxy<Buffer const> const &             buffers,
                                ArrayProxy<DeviceSize const> const &         offsets,
                                ArrayProxy<DeviceSize const> const & sizes   VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                ArrayProxy<DeviceSize const> const & strides VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetDepthTestEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthTestEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthTestEnableEXT ), bool>::type = true>
    void setDepthTestEnableEXT( Bool32 depthTestEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthWriteEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthWriteEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthWriteEnableEXT ), bool>::type = true>
    void setDepthWriteEnableEXT( Bool32 depthWriteEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthCompareOpEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthCompareOpEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthCompareOpEXT ), bool>::type = true>
    void setDepthCompareOpEXT( CompareOp depthCompareOp, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthBoundsTestEnableEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBoundsTestEnableEXT.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthBoundsTestEnableEXT ), bool>::type = true>
    void setDepthBoundsTestEnableEXT( Bool32 depthBoundsTestEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetStencilTestEnableEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilTestEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetStencilTestEnableEXT ), bool>::type = true>
    void setStencilTestEnableEXT( Bool32 stencilTestEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetStencilOpEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilOpEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetStencilOpEXT ), bool>::type = true>
    void setStencilOpEXT( StencilFaceFlags   faceMask,
                          StencilOp          failOp,
                          StencilOp          passOp,
                          StencilOp          depthFailOp,
                          CompareOp          compareOp,
                          Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_NV_device_generated_commands ===

    // wrapper function for command vkCmdPreprocessGeneratedCommandsNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPreprocessGeneratedCommandsNV.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPreprocessGeneratedCommandsNV ), bool>::type = true>
    void preprocessGeneratedCommandsNV( GeneratedCommandsInfoNV const * pGeneratedCommandsInfo,
                                        Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPreprocessGeneratedCommandsNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPreprocessGeneratedCommandsNV.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPreprocessGeneratedCommandsNV ), bool>::type = true>
    void preprocessGeneratedCommandsNV( GeneratedCommandsInfoNV const & generatedCommandsInfo,
                                        Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdExecuteGeneratedCommandsNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdExecuteGeneratedCommandsNV.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdExecuteGeneratedCommandsNV ), bool>::type = true>
    void executeGeneratedCommandsNV( Bool32                          isPreprocessed,
                                     GeneratedCommandsInfoNV const * pGeneratedCommandsInfo,
                                     Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdExecuteGeneratedCommandsNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdExecuteGeneratedCommandsNV.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdExecuteGeneratedCommandsNV ), bool>::type = true>
    void executeGeneratedCommandsNV( Bool32                          isPreprocessed,
                                     GeneratedCommandsInfoNV const & generatedCommandsInfo,
                                     Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBindPipelineShaderGroupNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindPipelineShaderGroupNV.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBindPipelineShaderGroupNV ), bool>::type = true>
    void bindPipelineShaderGroupNV( PipelineBindPoint  pipelineBindPoint,
                                    Pipeline           pipeline,
                                    uint32_t           groupIndex,
                                    Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_EXT_depth_bias_control ===

    // wrapper function for command vkCmdSetDepthBias2EXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBias2EXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthBias2EXT ), bool>::type = true>
    void setDepthBias2EXT( DepthBiasInfoEXT const * pDepthBiasInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetDepthBias2EXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBias2EXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthBias2EXT ), bool>::type = true>
    void setDepthBias2EXT( DepthBiasInfoEXT const & depthBiasInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_video_encode_queue ===

    // wrapper function for command vkCmdEncodeVideoKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEncodeVideoKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEncodeVideoKHR ), bool>::type = true>
    void encodeVideoKHR( VideoEncodeInfoKHR const * pEncodeInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdEncodeVideoKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEncodeVideoKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEncodeVideoKHR ), bool>::type = true>
    void encodeVideoKHR( VideoEncodeInfoKHR const & encodeInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#if defined( VK_ENABLE_BETA_EXTENSIONS )
    //=== VK_NV_cuda_kernel_launch ===

    // wrapper function for command vkCmdCudaLaunchKernelNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCudaLaunchKernelNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCudaLaunchKernelNV ), bool>::type = true>
    void cudaLaunchKernelNV( CudaLaunchInfoNV const * pLaunchInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCudaLaunchKernelNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCudaLaunchKernelNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCudaLaunchKernelNV ), bool>::type = true>
    void cudaLaunchKernelNV( CudaLaunchInfoNV const & launchInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */
#endif   /*VK_ENABLE_BETA_EXTENSIONS*/

    //=== VK_QCOM_tile_shading ===

    // wrapper function for command vkCmdDispatchTileQCOM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchTileQCOM.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDispatchTileQCOM ), bool>::type = true>
    void dispatchTileQCOM( DispatchTileInfoQCOM const * pDispatchTileInfo,
                           Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdDispatchTileQCOM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchTileQCOM.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDispatchTileQCOM ), bool>::type = true>
    void dispatchTileQCOM( DispatchTileInfoQCOM const & dispatchTileInfo,
                           Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBeginPerTileExecutionQCOM, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginPerTileExecutionQCOM.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBeginPerTileExecutionQCOM ), bool>::type = true>
    void beginPerTileExecutionQCOM( PerTileBeginInfoQCOM const * pPerTileBeginInfo,
                                    Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBeginPerTileExecutionQCOM, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginPerTileExecutionQCOM.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBeginPerTileExecutionQCOM ), bool>::type = true>
    void beginPerTileExecutionQCOM( PerTileBeginInfoQCOM const & perTileBeginInfo,
                                    Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdEndPerTileExecutionQCOM, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndPerTileExecutionQCOM.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndPerTileExecutionQCOM ), bool>::type = true>
    void endPerTileExecutionQCOM( PerTileEndInfoQCOM const * pPerTileEndInfo,
                                  Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdEndPerTileExecutionQCOM, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndPerTileExecutionQCOM.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndPerTileExecutionQCOM ), bool>::type = true>
    void endPerTileExecutionQCOM( PerTileEndInfoQCOM const & perTileEndInfo,
                                  Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_synchronization2 ===

    // wrapper function for command vkCmdSetEvent2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetEvent2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetEvent2KHR ), bool>::type = true>
    void setEvent2KHR( Event                  event,
                       DependencyInfo const * pDependencyInfo,
                       Dispatch const & d     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetEvent2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetEvent2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetEvent2KHR ), bool>::type = true>
    void
      setEvent2KHR( Event event, DependencyInfo const & dependencyInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdResetEvent2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResetEvent2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdResetEvent2KHR ), bool>::type = true>
    void resetEvent2KHR( Event event, PipelineStageFlags2 stageMask, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdWaitEvents2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWaitEvents2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdWaitEvents2KHR ), bool>::type = true>
    void waitEvents2KHR( uint32_t               eventCount,
                         Event const *          pEvents,
                         DependencyInfo const * pDependencyInfos,
                         Dispatch const & d     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdWaitEvents2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWaitEvents2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdWaitEvents2KHR ), bool>::type = true>
    void waitEvents2KHR( ArrayProxy<Event const> const &          events,
                         ArrayProxy<DependencyInfo const> const & dependencyInfos,
                         Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdPipelineBarrier2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPipelineBarrier2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPipelineBarrier2KHR ), bool>::type = true>
    void pipelineBarrier2KHR( DependencyInfo const * pDependencyInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPipelineBarrier2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPipelineBarrier2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPipelineBarrier2KHR ), bool>::type = true>
    void pipelineBarrier2KHR( DependencyInfo const & dependencyInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdWriteTimestamp2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteTimestamp2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdWriteTimestamp2KHR ), bool>::type = true>
    void writeTimestamp2KHR( PipelineStageFlags2 stage,
                             QueryPool           queryPool,
                             uint32_t            query,
                             Dispatch const & d  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_EXT_descriptor_buffer ===

    // wrapper function for command vkCmdBindDescriptorBuffersEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorBuffersEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBindDescriptorBuffersEXT ), bool>::type = true>
    void bindDescriptorBuffersEXT( uint32_t                               bufferCount,
                                   DescriptorBufferBindingInfoEXT const * pBindingInfos,
                                   Dispatch const & d                     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindDescriptorBuffersEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorBuffersEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBindDescriptorBuffersEXT ), bool>::type = true>
    void bindDescriptorBuffersEXT( ArrayProxy<DescriptorBufferBindingInfoEXT const> const & bindingInfos,
                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetDescriptorBufferOffsetsEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDescriptorBufferOffsetsEXT.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetDescriptorBufferOffsetsEXT ), bool>::type = true>
    void setDescriptorBufferOffsetsEXT( PipelineBindPoint  pipelineBindPoint,
                                        PipelineLayout     layout,
                                        uint32_t           firstSet,
                                        uint32_t           setCount,
                                        uint32_t const *   pBufferIndices,
                                        DeviceSize const * pOffsets,
                                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetDescriptorBufferOffsetsEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDescriptorBufferOffsetsEXT.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetDescriptorBufferOffsetsEXT ), bool>::type = true>
    void setDescriptorBufferOffsetsEXT( PipelineBindPoint                    pipelineBindPoint,
                                        PipelineLayout                       layout,
                                        uint32_t                             firstSet,
                                        ArrayProxy<uint32_t const> const &   bufferIndices,
                                        ArrayProxy<DeviceSize const> const & offsets,
                                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBindDescriptorBufferEmbeddedSamplersEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorBufferEmbeddedSamplersEXT.html
    template <typename Dispatch                                                                                  = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBindDescriptorBufferEmbeddedSamplersEXT ), bool>::type = true>
    void bindDescriptorBufferEmbeddedSamplersEXT( PipelineBindPoint  pipelineBindPoint,
                                                  PipelineLayout     layout,
                                                  uint32_t           set,
                                                  Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_NV_fragment_shading_rate_enums ===

    // wrapper function for command vkCmdSetFragmentShadingRateEnumNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetFragmentShadingRateEnumNV.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetFragmentShadingRateEnumNV ), bool>::type = true>
    void setFragmentShadingRateEnumNV( FragmentShadingRateNV                  shadingRate,
                                       FragmentShadingRateCombinerOpKHR const combinerOps[2],
                                       Dispatch const & d                     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_EXT_mesh_shader ===

    // wrapper function for command vkCmdDrawMeshTasksEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawMeshTasksEXT ), bool>::type = true>
    void drawMeshTasksEXT( uint32_t           groupCountX,
                           uint32_t           groupCountY,
                           uint32_t           groupCountZ,
                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawMeshTasksIndirectEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksIndirectEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDrawMeshTasksIndirectEXT ), bool>::type = true>
    void drawMeshTasksIndirectEXT( Buffer             buffer,
                                   DeviceSize         offset,
                                   uint32_t           drawCount,
                                   uint32_t           stride,
                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawMeshTasksIndirectCountEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksIndirectCountEXT.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDrawMeshTasksIndirectCountEXT ), bool>::type = true>
    void drawMeshTasksIndirectCountEXT( Buffer             buffer,
                                        DeviceSize         offset,
                                        Buffer             countBuffer,
                                        DeviceSize         countBufferOffset,
                                        uint32_t           maxDrawCount,
                                        uint32_t           stride,
                                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_KHR_copy_commands2 ===

    // wrapper function for command vkCmdCopyBuffer2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBuffer2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBuffer2KHR ), bool>::type = true>
    void copyBuffer2KHR( CopyBufferInfo2 const * pCopyBufferInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyBuffer2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBuffer2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBuffer2KHR ), bool>::type = true>
    void copyBuffer2KHR( CopyBufferInfo2 const & copyBufferInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImage2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImage2KHR ), bool>::type = true>
    void copyImage2KHR( CopyImageInfo2 const * pCopyImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImage2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImage2KHR ), bool>::type = true>
    void copyImage2KHR( CopyImageInfo2 const & copyImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyBufferToImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBufferToImage2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBufferToImage2KHR ), bool>::type = true>
    void copyBufferToImage2KHR( CopyBufferToImageInfo2 const * pCopyBufferToImageInfo,
                                Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyBufferToImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBufferToImage2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyBufferToImage2KHR ), bool>::type = true>
    void copyBufferToImage2KHR( CopyBufferToImageInfo2 const & copyBufferToImageInfo,
                                Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyImageToBuffer2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImageToBuffer2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImageToBuffer2KHR ), bool>::type = true>
    void copyImageToBuffer2KHR( CopyImageToBufferInfo2 const * pCopyImageToBufferInfo,
                                Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyImageToBuffer2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImageToBuffer2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyImageToBuffer2KHR ), bool>::type = true>
    void copyImageToBuffer2KHR( CopyImageToBufferInfo2 const & copyImageToBufferInfo,
                                Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBlitImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBlitImage2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBlitImage2KHR ), bool>::type = true>
    void blitImage2KHR( BlitImageInfo2 const * pBlitImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBlitImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBlitImage2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBlitImage2KHR ), bool>::type = true>
    void blitImage2KHR( BlitImageInfo2 const & blitImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdResolveImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResolveImage2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdResolveImage2KHR ), bool>::type = true>
    void resolveImage2KHR( ResolveImageInfo2 const * pResolveImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdResolveImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResolveImage2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdResolveImage2KHR ), bool>::type = true>
    void resolveImage2KHR( ResolveImageInfo2 const & resolveImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_vertex_input_dynamic_state ===

    // wrapper function for command vkCmdSetVertexInputEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetVertexInputEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetVertexInputEXT ), bool>::type = true>
    void setVertexInputEXT( uint32_t                                    vertexBindingDescriptionCount,
                            VertexInputBindingDescription2EXT const *   pVertexBindingDescriptions,
                            uint32_t                                    vertexAttributeDescriptionCount,
                            VertexInputAttributeDescription2EXT const * pVertexAttributeDescriptions,
                            Dispatch const & d                          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetVertexInputEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetVertexInputEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetVertexInputEXT ), bool>::type = true>
    void setVertexInputEXT( ArrayProxy<VertexInputBindingDescription2EXT const> const &   vertexBindingDescriptions,
                            ArrayProxy<VertexInputAttributeDescription2EXT const> const & vertexAttributeDescriptions,
                            Dispatch const & d                                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_HUAWEI_subpass_shading ===

    // wrapper function for command vkCmdSubpassShadingHUAWEI, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSubpassShadingHUAWEI.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSubpassShadingHUAWEI ), bool>::type = true>
    void subpassShadingHUAWEI( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_HUAWEI_invocation_mask ===

    // wrapper function for command vkCmdBindInvocationMaskHUAWEI, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindInvocationMaskHUAWEI.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBindInvocationMaskHUAWEI ), bool>::type = true>
    void bindInvocationMaskHUAWEI( ImageView          imageView,
                                   ImageLayout        imageLayout,
                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_EXT_extended_dynamic_state2 ===

    // wrapper function for command vkCmdSetPatchControlPointsEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPatchControlPointsEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetPatchControlPointsEXT ), bool>::type = true>
    void setPatchControlPointsEXT( uint32_t patchControlPoints, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetRasterizerDiscardEnableEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRasterizerDiscardEnableEXT.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRasterizerDiscardEnableEXT ), bool>::type = true>
    void setRasterizerDiscardEnableEXT( Bool32 rasterizerDiscardEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthBiasEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBiasEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthBiasEnableEXT ), bool>::type = true>
    void setDepthBiasEnableEXT( Bool32 depthBiasEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetLogicOpEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLogicOpEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetLogicOpEXT ), bool>::type = true>
    void setLogicOpEXT( LogicOp logicOp, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetPrimitiveRestartEnableEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPrimitiveRestartEnableEXT.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetPrimitiveRestartEnableEXT ), bool>::type = true>
    void setPrimitiveRestartEnableEXT( Bool32 primitiveRestartEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_EXT_color_write_enable ===

    // wrapper function for command vkCmdSetColorWriteEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorWriteEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetColorWriteEnableEXT ), bool>::type = true>
    void setColorWriteEnableEXT( uint32_t           attachmentCount,
                                 Bool32 const *     pColorWriteEnables,
                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetColorWriteEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorWriteEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetColorWriteEnableEXT ), bool>::type = true>
    void setColorWriteEnableEXT( ArrayProxy<Bool32 const> const & colorWriteEnables,
                                 Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_ray_tracing_maintenance1 ===

    // wrapper function for command vkCmdTraceRaysIndirect2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdTraceRaysIndirect2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdTraceRaysIndirect2KHR ), bool>::type = true>
    void traceRaysIndirect2KHR( DeviceAddress indirectDeviceAddress, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_EXT_multi_draw ===

    // wrapper function for command vkCmdDrawMultiEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMultiEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawMultiEXT ), bool>::type = true>
    void drawMultiEXT( uint32_t                 drawCount,
                       MultiDrawInfoEXT const * pVertexInfo,
                       uint32_t                 instanceCount,
                       uint32_t                 firstInstance,
                       uint32_t                 stride,
                       Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdDrawMultiEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMultiEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawMultiEXT ), bool>::type = true>
    void drawMultiEXT( StridedArrayProxy<MultiDrawInfoEXT const> const & vertexInfo,
                       uint32_t                                          instanceCount,
                       uint32_t                                          firstInstance,
                       Dispatch const & d                                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdDrawMultiIndexedEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMultiIndexedEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawMultiIndexedEXT ), bool>::type = true>
    void drawMultiIndexedEXT( uint32_t                        drawCount,
                              MultiDrawIndexedInfoEXT const * pIndexInfo,
                              uint32_t                        instanceCount,
                              uint32_t                        firstInstance,
                              uint32_t                        stride,
                              int32_t const *                 pVertexOffset,
                              Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdDrawMultiIndexedEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMultiIndexedEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawMultiIndexedEXT ), bool>::type = true>
    void drawMultiIndexedEXT( StridedArrayProxy<MultiDrawIndexedInfoEXT const> const & indexInfo,
                              uint32_t                                                 instanceCount,
                              uint32_t                                                 firstInstance,
                              Optional<int32_t const> vertexOffset                     VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                              Dispatch const & d                                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_opacity_micromap ===

    // wrapper function for command vkCmdBuildMicromapsEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildMicromapsEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBuildMicromapsEXT ), bool>::type = true>
    void buildMicromapsEXT( uint32_t                     infoCount,
                            MicromapBuildInfoEXT const * pInfos,
                            Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBuildMicromapsEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildMicromapsEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBuildMicromapsEXT ), bool>::type = true>
    void buildMicromapsEXT( ArrayProxy<MicromapBuildInfoEXT const> const & infos,
                            Dispatch const & d                             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyMicromapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMicromapEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyMicromapEXT ), bool>::type = true>
    void copyMicromapEXT( CopyMicromapInfoEXT const * pInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyMicromapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMicromapEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyMicromapEXT ), bool>::type = true>
    void copyMicromapEXT( CopyMicromapInfoEXT const & info, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyMicromapToMemoryEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMicromapToMemoryEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyMicromapToMemoryEXT ), bool>::type = true>
    void copyMicromapToMemoryEXT( CopyMicromapToMemoryInfoEXT const * pInfo,
                                  Dispatch const & d                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyMicromapToMemoryEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMicromapToMemoryEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyMicromapToMemoryEXT ), bool>::type = true>
    void copyMicromapToMemoryEXT( CopyMicromapToMemoryInfoEXT const & info,
                                  Dispatch const & d                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyMemoryToMicromapEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToMicromapEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyMemoryToMicromapEXT ), bool>::type = true>
    void copyMemoryToMicromapEXT( CopyMemoryToMicromapInfoEXT const * pInfo,
                                  Dispatch const & d                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyMemoryToMicromapEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToMicromapEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyMemoryToMicromapEXT ), bool>::type = true>
    void copyMemoryToMicromapEXT( CopyMemoryToMicromapInfoEXT const & info,
                                  Dispatch const & d                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdWriteMicromapsPropertiesEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteMicromapsPropertiesEXT.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdWriteMicromapsPropertiesEXT ), bool>::type = true>
    void writeMicromapsPropertiesEXT( uint32_t            micromapCount,
                                      MicromapEXT const * pMicromaps,
                                      QueryType           queryType,
                                      QueryPool           queryPool,
                                      uint32_t            firstQuery,
                                      Dispatch const & d  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdWriteMicromapsPropertiesEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteMicromapsPropertiesEXT.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdWriteMicromapsPropertiesEXT ), bool>::type = true>
    void writeMicromapsPropertiesEXT( ArrayProxy<MicromapEXT const> const & micromaps,
                                      QueryType                             queryType,
                                      QueryPool                             queryPool,
                                      uint32_t                              firstQuery,
                                      Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_HUAWEI_cluster_culling_shader ===

    // wrapper function for command vkCmdDrawClusterHUAWEI, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawClusterHUAWEI.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDrawClusterHUAWEI ), bool>::type = true>
    void drawClusterHUAWEI( uint32_t           groupCountX,
                            uint32_t           groupCountY,
                            uint32_t           groupCountZ,
                            Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdDrawClusterIndirectHUAWEI, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawClusterIndirectHUAWEI.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDrawClusterIndirectHUAWEI ), bool>::type = true>
    void drawClusterIndirectHUAWEI( Buffer buffer, DeviceSize offset, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_NV_copy_memory_indirect ===

    // wrapper function for command vkCmdCopyMemoryIndirectNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryIndirectNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyMemoryIndirectNV ), bool>::type = true>
    void copyMemoryIndirectNV( DeviceAddress      copyBufferAddress,
                               uint32_t           copyCount,
                               uint32_t           stride,
                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdCopyMemoryToImageIndirectNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToImageIndirectNV.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdCopyMemoryToImageIndirectNV ), bool>::type = true>
    void copyMemoryToImageIndirectNV( DeviceAddress                  copyBufferAddress,
                                      uint32_t                       copyCount,
                                      uint32_t                       stride,
                                      Image                          dstImage,
                                      ImageLayout                    dstImageLayout,
                                      ImageSubresourceLayers const * pImageSubresources,
                                      Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyMemoryToImageIndirectNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToImageIndirectNV.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdCopyMemoryToImageIndirectNV ), bool>::type = true>
    void copyMemoryToImageIndirectNV( DeviceAddress                                    copyBufferAddress,
                                      uint32_t                                         stride,
                                      Image                                            dstImage,
                                      ImageLayout                                      dstImageLayout,
                                      ArrayProxy<ImageSubresourceLayers const> const & imageSubresources,
                                      Dispatch const & d                               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_NV_memory_decompression ===

    // wrapper function for command vkCmdDecompressMemoryNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecompressMemoryNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDecompressMemoryNV ), bool>::type = true>
    void decompressMemoryNV( uint32_t                         decompressRegionCount,
                             DecompressMemoryRegionNV const * pDecompressMemoryRegions,
                             Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdDecompressMemoryNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecompressMemoryNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDecompressMemoryNV ), bool>::type = true>
    void decompressMemoryNV( ArrayProxy<DecompressMemoryRegionNV const> const & decompressMemoryRegions,
                             Dispatch const & d                                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdDecompressMemoryIndirectCountNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecompressMemoryIndirectCountNV.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDecompressMemoryIndirectCountNV ), bool>::type = true>
    void decompressMemoryIndirectCountNV( DeviceAddress      indirectCommandsAddress,
                                          DeviceAddress      indirectCommandsCountAddress,
                                          uint32_t           stride,
                                          Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_NV_device_generated_commands_compute ===

    // wrapper function for command vkCmdUpdatePipelineIndirectBufferNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdUpdatePipelineIndirectBufferNV.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdUpdatePipelineIndirectBufferNV ), bool>::type = true>
    void updatePipelineIndirectBufferNV( PipelineBindPoint  pipelineBindPoint,
                                         Pipeline           pipeline,
                                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_EXT_extended_dynamic_state3 ===

    // wrapper function for command vkCmdSetDepthClampEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthClampEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthClampEnableEXT ), bool>::type = true>
    void setDepthClampEnableEXT( Bool32 depthClampEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetPolygonModeEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPolygonModeEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetPolygonModeEXT ), bool>::type = true>
    void setPolygonModeEXT( PolygonMode polygonMode, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetRasterizationSamplesEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRasterizationSamplesEXT.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRasterizationSamplesEXT ), bool>::type = true>
    void setRasterizationSamplesEXT( SampleCountFlagBits rasterizationSamples,
                                     Dispatch const & d  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetSampleMaskEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetSampleMaskEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetSampleMaskEXT ), bool>::type = true>
    void setSampleMaskEXT( SampleCountFlagBits samples,
                           SampleMask const *  pSampleMask,
                           Dispatch const & d  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetSampleMaskEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetSampleMaskEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetSampleMaskEXT ), bool>::type = true>
    void setSampleMaskEXT( SampleCountFlagBits                             samples,
                           ArrayProxy<SampleMask const> const & sampleMask VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetAlphaToCoverageEnableEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetAlphaToCoverageEnableEXT.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetAlphaToCoverageEnableEXT ), bool>::type = true>
    void setAlphaToCoverageEnableEXT( Bool32 alphaToCoverageEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetAlphaToOneEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetAlphaToOneEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetAlphaToOneEnableEXT ), bool>::type = true>
    void setAlphaToOneEnableEXT( Bool32 alphaToOneEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetLogicOpEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLogicOpEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetLogicOpEnableEXT ), bool>::type = true>
    void setLogicOpEnableEXT( Bool32 logicOpEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetColorBlendEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorBlendEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetColorBlendEnableEXT ), bool>::type = true>
    void setColorBlendEnableEXT( uint32_t           firstAttachment,
                                 uint32_t           attachmentCount,
                                 Bool32 const *     pColorBlendEnables,
                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetColorBlendEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorBlendEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetColorBlendEnableEXT ), bool>::type = true>
    void setColorBlendEnableEXT( uint32_t                         firstAttachment,
                                 ArrayProxy<Bool32 const> const & colorBlendEnables,
                                 Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetColorBlendEquationEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorBlendEquationEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetColorBlendEquationEXT ), bool>::type = true>
    void setColorBlendEquationEXT( uint32_t                      firstAttachment,
                                   uint32_t                      attachmentCount,
                                   ColorBlendEquationEXT const * pColorBlendEquations,
                                   Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetColorBlendEquationEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorBlendEquationEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetColorBlendEquationEXT ), bool>::type = true>
    void setColorBlendEquationEXT( uint32_t                                        firstAttachment,
                                   ArrayProxy<ColorBlendEquationEXT const> const & colorBlendEquations,
                                   Dispatch const & d                              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetColorWriteMaskEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorWriteMaskEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetColorWriteMaskEXT ), bool>::type = true>
    void setColorWriteMaskEXT( uint32_t                    firstAttachment,
                               uint32_t                    attachmentCount,
                               ColorComponentFlags const * pColorWriteMasks,
                               Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetColorWriteMaskEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorWriteMaskEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetColorWriteMaskEXT ), bool>::type = true>
    void setColorWriteMaskEXT( uint32_t                                      firstAttachment,
                               ArrayProxy<ColorComponentFlags const> const & colorWriteMasks,
                               Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetTessellationDomainOriginEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetTessellationDomainOriginEXT.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetTessellationDomainOriginEXT ), bool>::type = true>
    void setTessellationDomainOriginEXT( TessellationDomainOrigin domainOrigin,
                                         Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetRasterizationStreamEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRasterizationStreamEXT.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRasterizationStreamEXT ), bool>::type = true>
    void setRasterizationStreamEXT( uint32_t rasterizationStream, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetConservativeRasterizationModeEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetConservativeRasterizationModeEXT.html
    template <typename Dispatch                                                                              = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetConservativeRasterizationModeEXT ), bool>::type = true>
    void setConservativeRasterizationModeEXT( ConservativeRasterizationModeEXT conservativeRasterizationMode,
                                              Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetExtraPrimitiveOverestimationSizeEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetExtraPrimitiveOverestimationSizeEXT.html
    template <typename Dispatch                                                                                 = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetExtraPrimitiveOverestimationSizeEXT ), bool>::type = true>
    void setExtraPrimitiveOverestimationSizeEXT( float              extraPrimitiveOverestimationSize,
                                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthClipEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthClipEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthClipEnableEXT ), bool>::type = true>
    void setDepthClipEnableEXT( Bool32 depthClipEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetSampleLocationsEnableEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetSampleLocationsEnableEXT.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetSampleLocationsEnableEXT ), bool>::type = true>
    void setSampleLocationsEnableEXT( Bool32 sampleLocationsEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetColorBlendAdvancedEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorBlendAdvancedEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetColorBlendAdvancedEXT ), bool>::type = true>
    void setColorBlendAdvancedEXT( uint32_t                      firstAttachment,
                                   uint32_t                      attachmentCount,
                                   ColorBlendAdvancedEXT const * pColorBlendAdvanced,
                                   Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetColorBlendAdvancedEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorBlendAdvancedEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetColorBlendAdvancedEXT ), bool>::type = true>
    void setColorBlendAdvancedEXT( uint32_t                                        firstAttachment,
                                   ArrayProxy<ColorBlendAdvancedEXT const> const & colorBlendAdvanced,
                                   Dispatch const & d                              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetProvokingVertexModeEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetProvokingVertexModeEXT.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetProvokingVertexModeEXT ), bool>::type = true>
    void setProvokingVertexModeEXT( ProvokingVertexModeEXT provokingVertexMode,
                                    Dispatch const & d     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetLineRasterizationModeEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineRasterizationModeEXT.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetLineRasterizationModeEXT ), bool>::type = true>
    void setLineRasterizationModeEXT( LineRasterizationModeEXT lineRasterizationMode,
                                      Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetLineStippleEnableEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineStippleEnableEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetLineStippleEnableEXT ), bool>::type = true>
    void setLineStippleEnableEXT( Bool32 stippledLineEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetDepthClipNegativeOneToOneEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthClipNegativeOneToOneEXT.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthClipNegativeOneToOneEXT ), bool>::type = true>
    void setDepthClipNegativeOneToOneEXT( Bool32 negativeOneToOne, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetViewportWScalingEnableNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportWScalingEnableNV.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetViewportWScalingEnableNV ), bool>::type = true>
    void setViewportWScalingEnableNV( Bool32 viewportWScalingEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetViewportSwizzleNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportSwizzleNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetViewportSwizzleNV ), bool>::type = true>
    void setViewportSwizzleNV( uint32_t                  firstViewport,
                               uint32_t                  viewportCount,
                               ViewportSwizzleNV const * pViewportSwizzles,
                               Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetViewportSwizzleNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportSwizzleNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetViewportSwizzleNV ), bool>::type = true>
    void setViewportSwizzleNV( uint32_t                                    firstViewport,
                               ArrayProxy<ViewportSwizzleNV const> const & viewportSwizzles,
                               Dispatch const & d                          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetCoverageToColorEnableNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageToColorEnableNV.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetCoverageToColorEnableNV ), bool>::type = true>
    void setCoverageToColorEnableNV( Bool32 coverageToColorEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetCoverageToColorLocationNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageToColorLocationNV.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetCoverageToColorLocationNV ), bool>::type = true>
    void setCoverageToColorLocationNV( uint32_t           coverageToColorLocation,
                                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetCoverageModulationModeNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageModulationModeNV.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetCoverageModulationModeNV ), bool>::type = true>
    void setCoverageModulationModeNV( CoverageModulationModeNV coverageModulationMode,
                                      Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetCoverageModulationTableEnableNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageModulationTableEnableNV.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetCoverageModulationTableEnableNV ), bool>::type = true>
    void setCoverageModulationTableEnableNV( Bool32             coverageModulationTableEnable,
                                             Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetCoverageModulationTableNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageModulationTableNV.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetCoverageModulationTableNV ), bool>::type = true>
    void setCoverageModulationTableNV( uint32_t           coverageModulationTableCount,
                                       float const *      pCoverageModulationTable,
                                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetCoverageModulationTableNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageModulationTableNV.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetCoverageModulationTableNV ), bool>::type = true>
    void setCoverageModulationTableNV( ArrayProxy<float const> const & coverageModulationTable,
                                       Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetShadingRateImageEnableNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetShadingRateImageEnableNV.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetShadingRateImageEnableNV ), bool>::type = true>
    void setShadingRateImageEnableNV( Bool32 shadingRateImageEnable, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetRepresentativeFragmentTestEnableNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRepresentativeFragmentTestEnableNV.html
    template <typename Dispatch                                                                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetRepresentativeFragmentTestEnableNV ), bool>::type = true>
    void setRepresentativeFragmentTestEnableNV( Bool32             representativeFragmentTestEnable,
                                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkCmdSetCoverageReductionModeNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageReductionModeNV.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetCoverageReductionModeNV ), bool>::type = true>
    void setCoverageReductionModeNV( CoverageReductionModeNV coverageReductionMode,
                                     Dispatch const & d      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_ARM_tensors ===

    // wrapper function for command vkCmdCopyTensorARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyTensorARM.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyTensorARM ), bool>::type = true>
    void copyTensorARM( CopyTensorInfoARM const * pCopyTensorInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyTensorARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyTensorARM.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyTensorARM ), bool>::type = true>
    void copyTensorARM( CopyTensorInfoARM const & copyTensorInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_NV_optical_flow ===

    // wrapper function for command vkCmdOpticalFlowExecuteNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdOpticalFlowExecuteNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdOpticalFlowExecuteNV ), bool>::type = true>
    void opticalFlowExecuteNV( OpticalFlowSessionNV             session,
                               OpticalFlowExecuteInfoNV const * pExecuteInfo,
                               Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdOpticalFlowExecuteNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdOpticalFlowExecuteNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdOpticalFlowExecuteNV ), bool>::type = true>
    void opticalFlowExecuteNV( OpticalFlowSessionNV             session,
                               OpticalFlowExecuteInfoNV const & executeInfo,
                               Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_maintenance5 ===

    // wrapper function for command vkCmdBindIndexBuffer2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindIndexBuffer2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindIndexBuffer2KHR ), bool>::type = true>
    void bindIndexBuffer2KHR( Buffer             buffer,
                              DeviceSize         offset,
                              DeviceSize         size,
                              IndexType          indexType,
                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_EXT_shader_object ===

    // wrapper function for command vkCmdBindShadersEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindShadersEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindShadersEXT ), bool>::type = true>
    void bindShadersEXT( uint32_t                    stageCount,
                         ShaderStageFlagBits const * pStages,
                         ShaderEXT const *           pShaders,
                         Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindShadersEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindShadersEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindShadersEXT ), bool>::type = true>
    void bindShadersEXT( ArrayProxy<ShaderStageFlagBits const> const & stages,
                         ArrayProxy<ShaderEXT const> const &           shaders,
                         Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetDepthClampRangeEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthClampRangeEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthClampRangeEXT ), bool>::type = true>
    void setDepthClampRangeEXT( DepthClampModeEXT          depthClampMode,
                                DepthClampRangeEXT const * pDepthClampRange,
                                Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetDepthClampRangeEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthClampRangeEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetDepthClampRangeEXT ), bool>::type = true>
    void setDepthClampRangeEXT( DepthClampModeEXT                                  depthClampMode,
                                Optional<DepthClampRangeEXT const> depthClampRange VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                Dispatch const & d                                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_NV_cooperative_vector ===

    // wrapper function for command vkCmdConvertCooperativeVectorMatrixNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdConvertCooperativeVectorMatrixNV.html
    template <typename Dispatch                                                                           = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdConvertCooperativeVectorMatrixNV ), bool>::type = true>
    void convertCooperativeVectorMatrixNV( uint32_t                                     infoCount,
                                           ConvertCooperativeVectorMatrixInfoNV const * pInfos,
                                           Dispatch const & d                           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdConvertCooperativeVectorMatrixNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdConvertCooperativeVectorMatrixNV.html
    template <typename Dispatch                                                                           = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdConvertCooperativeVectorMatrixNV ), bool>::type = true>
    void convertCooperativeVectorMatrixNV( ArrayProxy<ConvertCooperativeVectorMatrixInfoNV const> const & infos,
                                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_ARM_data_graph ===

    // wrapper function for command vkCmdDispatchDataGraphARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchDataGraphARM.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDispatchDataGraphARM ), bool>::type = true>
    void dispatchDataGraphARM( DataGraphPipelineSessionARM              session,
                               DataGraphPipelineDispatchInfoARM const * pInfo,
                               Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdDispatchDataGraphARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchDataGraphARM.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDispatchDataGraphARM ), bool>::type = true>
    void dispatchDataGraphARM( DataGraphPipelineSessionARM                           session,
                               Optional<DataGraphPipelineDispatchInfoARM const> info VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                               Dispatch const & d                                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_attachment_feedback_loop_dynamic_state ===

    // wrapper function for command vkCmdSetAttachmentFeedbackLoopEnableEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetAttachmentFeedbackLoopEnableEXT.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetAttachmentFeedbackLoopEnableEXT ), bool>::type = true>
    void setAttachmentFeedbackLoopEnableEXT( ImageAspectFlags   aspectMask,
                                             Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_KHR_line_rasterization ===

    // wrapper function for command vkCmdSetLineStippleKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineStippleKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdSetLineStippleKHR ), bool>::type = true>
    void setLineStippleKHR( uint32_t           lineStippleFactor,
                            uint16_t           lineStipplePattern,
                            Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_KHR_maintenance6 ===

    // wrapper function for command vkCmdBindDescriptorSets2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorSets2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindDescriptorSets2KHR ), bool>::type = true>
    void bindDescriptorSets2KHR( BindDescriptorSetsInfo const * pBindDescriptorSetsInfo,
                                 Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindDescriptorSets2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorSets2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindDescriptorSets2KHR ), bool>::type = true>
    void bindDescriptorSets2KHR( BindDescriptorSetsInfo const & bindDescriptorSetsInfo,
                                 Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdPushConstants2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushConstants2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushConstants2KHR ), bool>::type = true>
    void pushConstants2KHR( PushConstantsInfo const * pPushConstantsInfo,
                            Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushConstants2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushConstants2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushConstants2KHR ), bool>::type = true>
    void pushConstants2KHR( PushConstantsInfo const & pushConstantsInfo,
                            Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdPushDescriptorSet2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSet2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSet2KHR ), bool>::type = true>
    void pushDescriptorSet2KHR( PushDescriptorSetInfo const * pPushDescriptorSetInfo,
                                Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushDescriptorSet2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSet2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSet2KHR ), bool>::type = true>
    void pushDescriptorSet2KHR( PushDescriptorSetInfo const & pushDescriptorSetInfo,
                                Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdPushDescriptorSetWithTemplate2KHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplate2KHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSetWithTemplate2KHR ), bool>::type = true>
    void pushDescriptorSetWithTemplate2KHR( PushDescriptorSetWithTemplateInfo const * pPushDescriptorSetWithTemplateInfo,
                                            Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPushDescriptorSetWithTemplate2KHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplate2KHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPushDescriptorSetWithTemplate2KHR ), bool>::type = true>
    void pushDescriptorSetWithTemplate2KHR( PushDescriptorSetWithTemplateInfo const & pushDescriptorSetWithTemplateInfo,
                                            Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdSetDescriptorBufferOffsets2EXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDescriptorBufferOffsets2EXT.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetDescriptorBufferOffsets2EXT ), bool>::type = true>
    void setDescriptorBufferOffsets2EXT( SetDescriptorBufferOffsetsInfoEXT const * pSetDescriptorBufferOffsetsInfo,
                                         Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetDescriptorBufferOffsets2EXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDescriptorBufferOffsets2EXT.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetDescriptorBufferOffsets2EXT ), bool>::type = true>
    void setDescriptorBufferOffsets2EXT( SetDescriptorBufferOffsetsInfoEXT const & setDescriptorBufferOffsetsInfo,
                                         Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdBindDescriptorBufferEmbeddedSamplers2EXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorBufferEmbeddedSamplers2EXT.html
    template <typename Dispatch                                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBindDescriptorBufferEmbeddedSamplers2EXT ), bool>::type = true>
    void bindDescriptorBufferEmbeddedSamplers2EXT( BindDescriptorBufferEmbeddedSamplersInfoEXT const * pBindDescriptorBufferEmbeddedSamplersInfo,
                                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindDescriptorBufferEmbeddedSamplers2EXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorBufferEmbeddedSamplers2EXT.html
    template <typename Dispatch                                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBindDescriptorBufferEmbeddedSamplers2EXT ), bool>::type = true>
    void bindDescriptorBufferEmbeddedSamplers2EXT( BindDescriptorBufferEmbeddedSamplersInfoEXT const & bindDescriptorBufferEmbeddedSamplersInfo,
                                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_QCOM_tile_memory_heap ===

    // wrapper function for command vkCmdBindTileMemoryQCOM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindTileMemoryQCOM.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindTileMemoryQCOM ), bool>::type = true>
    void bindTileMemoryQCOM( TileMemoryBindInfoQCOM const * pTileMemoryBindInfo,
                             Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBindTileMemoryQCOM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindTileMemoryQCOM.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBindTileMemoryQCOM ), bool>::type = true>
    void bindTileMemoryQCOM( Optional<TileMemoryBindInfoQCOM const> tileMemoryBindInfo VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                             Dispatch const & d                                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_copy_memory_indirect ===

    // wrapper function for command vkCmdCopyMemoryIndirectKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryIndirectKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyMemoryIndirectKHR ), bool>::type = true>
    void copyMemoryIndirectKHR( CopyMemoryIndirectInfoKHR const * pCopyMemoryIndirectInfo,
                                Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyMemoryIndirectKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryIndirectKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdCopyMemoryIndirectKHR ), bool>::type = true>
    void copyMemoryIndirectKHR( CopyMemoryIndirectInfoKHR const & copyMemoryIndirectInfo,
                                Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdCopyMemoryToImageIndirectKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToImageIndirectKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdCopyMemoryToImageIndirectKHR ), bool>::type = true>
    void copyMemoryToImageIndirectKHR( CopyMemoryToImageIndirectInfoKHR const * pCopyMemoryToImageIndirectInfo,
                                       Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdCopyMemoryToImageIndirectKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToImageIndirectKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdCopyMemoryToImageIndirectKHR ), bool>::type = true>
    void copyMemoryToImageIndirectKHR( CopyMemoryToImageIndirectInfoKHR const & copyMemoryToImageIndirectInfo,
                                       Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_memory_decompression ===

    // wrapper function for command vkCmdDecompressMemoryEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecompressMemoryEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDecompressMemoryEXT ), bool>::type = true>
    void decompressMemoryEXT( DecompressMemoryInfoEXT const * pDecompressMemoryInfoEXT,
                              Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdDecompressMemoryEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecompressMemoryEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdDecompressMemoryEXT ), bool>::type = true>
    void decompressMemoryEXT( DecompressMemoryInfoEXT const & decompressMemoryInfoEXT,
                              Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdDecompressMemoryIndirectCountEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecompressMemoryIndirectCountEXT.html
    template <typename Dispatch                                                                           = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdDecompressMemoryIndirectCountEXT ), bool>::type = true>
    void decompressMemoryIndirectCountEXT( MemoryDecompressionMethodFlagsEXT decompressionMethod,
                                           DeviceAddress                     indirectCommandsAddress,
                                           DeviceAddress                     indirectCommandsCountAddress,
                                           uint32_t                          maxDecompressionCount,
                                           uint32_t                          stride,
                                           Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_NV_cluster_acceleration_structure ===

    // wrapper function for command vkCmdBuildClusterAccelerationStructureIndirectNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildClusterAccelerationStructureIndirectNV.html
    template <typename Dispatch                                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBuildClusterAccelerationStructureIndirectNV ), bool>::type = true>
    void buildClusterAccelerationStructureIndirectNV( ClusterAccelerationStructureCommandsInfoNV const * pCommandInfos,
                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBuildClusterAccelerationStructureIndirectNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildClusterAccelerationStructureIndirectNV.html
    template <typename Dispatch                                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBuildClusterAccelerationStructureIndirectNV ), bool>::type = true>
    void buildClusterAccelerationStructureIndirectNV( ClusterAccelerationStructureCommandsInfoNV const & commandInfos,
                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_NV_partitioned_acceleration_structure ===

    // wrapper function for command vkCmdBuildPartitionedAccelerationStructuresNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildPartitionedAccelerationStructuresNV.html
    template <typename Dispatch                                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBuildPartitionedAccelerationStructuresNV ), bool>::type = true>
    void buildPartitionedAccelerationStructuresNV( BuildPartitionedAccelerationStructureInfoNV const * pBuildInfo,
                                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBuildPartitionedAccelerationStructuresNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildPartitionedAccelerationStructuresNV.html
    template <typename Dispatch                                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdBuildPartitionedAccelerationStructuresNV ), bool>::type = true>
    void buildPartitionedAccelerationStructuresNV( BuildPartitionedAccelerationStructureInfoNV const & buildInfo,
                                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_device_generated_commands ===

    // wrapper function for command vkCmdPreprocessGeneratedCommandsEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPreprocessGeneratedCommandsEXT.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPreprocessGeneratedCommandsEXT ), bool>::type = true>
    void preprocessGeneratedCommandsEXT( GeneratedCommandsInfoEXT const * pGeneratedCommandsInfo,
                                         CommandBuffer                    stateCommandBuffer,
                                         Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdPreprocessGeneratedCommandsEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPreprocessGeneratedCommandsEXT.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdPreprocessGeneratedCommandsEXT ), bool>::type = true>
    void preprocessGeneratedCommandsEXT( GeneratedCommandsInfoEXT const & generatedCommandsInfo,
                                         CommandBuffer                    stateCommandBuffer,
                                         Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCmdExecuteGeneratedCommandsEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdExecuteGeneratedCommandsEXT.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdExecuteGeneratedCommandsEXT ), bool>::type = true>
    void executeGeneratedCommandsEXT( Bool32                           isPreprocessed,
                                      GeneratedCommandsInfoEXT const * pGeneratedCommandsInfo,
                                      Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdExecuteGeneratedCommandsEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdExecuteGeneratedCommandsEXT.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdExecuteGeneratedCommandsEXT ), bool>::type = true>
    void executeGeneratedCommandsEXT( Bool32                           isPreprocessed,
                                      GeneratedCommandsInfoEXT const & generatedCommandsInfo,
                                      Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_fragment_density_map_offset ===

    // wrapper function for command vkCmdEndRendering2EXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRendering2EXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndRendering2EXT ), bool>::type = true>
    void endRendering2EXT( RenderingEndInfoKHR const * pRenderingEndInfo,
                           Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdEndRendering2EXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRendering2EXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndRendering2EXT ), bool>::type = true>
    void endRendering2EXT( Optional<RenderingEndInfoKHR const> renderingEndInfo VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                           Dispatch const & d                                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_custom_resolve ===

    // wrapper function for command vkCmdBeginCustomResolveEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginCustomResolveEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginCustomResolveEXT ), bool>::type = true>
    void beginCustomResolveEXT( BeginCustomResolveInfoEXT const * pBeginCustomResolveInfo,
                                Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdBeginCustomResolveEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginCustomResolveEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdBeginCustomResolveEXT ), bool>::type = true>
    void beginCustomResolveEXT( Optional<BeginCustomResolveInfoEXT const> beginCustomResolveInfo VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_maintenance10 ===

    // wrapper function for command vkCmdEndRendering2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRendering2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndRendering2KHR ), bool>::type = true>
    void endRendering2KHR( RenderingEndInfoKHR const * pRenderingEndInfo,
                           Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdEndRendering2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRendering2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCmdEndRendering2KHR ), bool>::type = true>
    void endRendering2KHR( Optional<RenderingEndInfoKHR const> renderingEndInfo VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                           Dispatch const & d                                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_NV_compute_occupancy_priority ===

    // wrapper function for command vkCmdSetComputeOccupancyPriorityNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetComputeOccupancyPriorityNV.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetComputeOccupancyPriorityNV ), bool>::type = true>
    void setComputeOccupancyPriorityNV( ComputeOccupancyPriorityParametersNV const * pParameters,
                                        Dispatch const & d                           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCmdSetComputeOccupancyPriorityNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetComputeOccupancyPriorityNV.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCmdSetComputeOccupancyPriorityNV ), bool>::type = true>
    void setComputeOccupancyPriorityNV( ComputeOccupancyPriorityParametersNV const & parameters,
                                        Dispatch const & d                           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    operator VkCommandBuffer() const VULKAN_HPP_NOEXCEPT
    {
      return m_commandBuffer;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_commandBuffer != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_commandBuffer == VK_NULL_HANDLE;
    }

  private:
    VkCommandBuffer m_commandBuffer = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eCommandBuffer>
  {
    using Type = CommandBuffer;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eCommandBuffer>
  {
    using Type = CommandBuffer;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkCommandBuffer, VK_NULL_HANDLE>
  {
    using Type = CommandBuffer;
  };
#endif

  template <>
  struct isVulkanHandleType<CommandBuffer>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkDeviceMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDeviceMemory.html
  class DeviceMemory
  {
  public:
    using CType      = VkDeviceMemory;
    using NativeType = VkDeviceMemory;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDeviceMemory;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDeviceMemory;

  public:
    DeviceMemory() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    DeviceMemory( DeviceMemory const & rhs )             = default;
    DeviceMemory & operator=( DeviceMemory const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    DeviceMemory( DeviceMemory && rhs )             = default;
    DeviceMemory & operator=( DeviceMemory && rhs ) = default;
#else
    DeviceMemory( DeviceMemory && rhs ) VULKAN_HPP_NOEXCEPT : m_deviceMemory( exchange( rhs.m_deviceMemory, {} ) ) {}

    DeviceMemory & operator=( DeviceMemory && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_deviceMemory = exchange( rhs.m_deviceMemory, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR DeviceMemory( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT DeviceMemory( VkDeviceMemory deviceMemory ) VULKAN_HPP_NOEXCEPT : m_deviceMemory( deviceMemory ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    DeviceMemory & operator=( VkDeviceMemory deviceMemory ) VULKAN_HPP_NOEXCEPT
    {
      m_deviceMemory = deviceMemory;
      return *this;
    }
#endif

    DeviceMemory & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_deviceMemory = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkDeviceMemory() const VULKAN_HPP_NOEXCEPT
    {
      return m_deviceMemory;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_deviceMemory != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_deviceMemory == VK_NULL_HANDLE;
    }

  private:
    VkDeviceMemory m_deviceMemory = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eDeviceMemory>
  {
    using Type = DeviceMemory;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eDeviceMemory>
  {
    using Type = DeviceMemory;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkDeviceMemory, VK_NULL_HANDLE>
  {
    using Type = DeviceMemory;
  };
#endif

  template <>
  struct isVulkanHandleType<DeviceMemory>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkVideoSessionKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkVideoSessionKHR.html
  class VideoSessionKHR
  {
  public:
    using CType      = VkVideoSessionKHR;
    using NativeType = VkVideoSessionKHR;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eVideoSessionKHR;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    VideoSessionKHR() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    VideoSessionKHR( VideoSessionKHR const & rhs )             = default;
    VideoSessionKHR & operator=( VideoSessionKHR const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    VideoSessionKHR( VideoSessionKHR && rhs )             = default;
    VideoSessionKHR & operator=( VideoSessionKHR && rhs ) = default;
#else
    VideoSessionKHR( VideoSessionKHR && rhs ) VULKAN_HPP_NOEXCEPT : m_videoSessionKHR( exchange( rhs.m_videoSessionKHR, {} ) ) {}

    VideoSessionKHR & operator=( VideoSessionKHR && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_videoSessionKHR = exchange( rhs.m_videoSessionKHR, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR VideoSessionKHR( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT VideoSessionKHR( VkVideoSessionKHR videoSessionKHR ) VULKAN_HPP_NOEXCEPT : m_videoSessionKHR( videoSessionKHR ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    VideoSessionKHR & operator=( VkVideoSessionKHR videoSessionKHR ) VULKAN_HPP_NOEXCEPT
    {
      m_videoSessionKHR = videoSessionKHR;
      return *this;
    }
#endif

    VideoSessionKHR & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_videoSessionKHR = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkVideoSessionKHR() const VULKAN_HPP_NOEXCEPT
    {
      return m_videoSessionKHR;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_videoSessionKHR != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_videoSessionKHR == VK_NULL_HANDLE;
    }

  private:
    VkVideoSessionKHR m_videoSessionKHR = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eVideoSessionKHR>
  {
    using Type = VideoSessionKHR;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkVideoSessionKHR, VK_NULL_HANDLE>
  {
    using Type = VideoSessionKHR;
  };
#endif

  template <>
  struct isVulkanHandleType<VideoSessionKHR>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkDeferredOperationKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDeferredOperationKHR.html
  class DeferredOperationKHR
  {
  public:
    using CType      = VkDeferredOperationKHR;
    using NativeType = VkDeferredOperationKHR;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDeferredOperationKHR;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    DeferredOperationKHR() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    DeferredOperationKHR( DeferredOperationKHR const & rhs )             = default;
    DeferredOperationKHR & operator=( DeferredOperationKHR const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    DeferredOperationKHR( DeferredOperationKHR && rhs )             = default;
    DeferredOperationKHR & operator=( DeferredOperationKHR && rhs ) = default;
#else
    DeferredOperationKHR( DeferredOperationKHR && rhs ) VULKAN_HPP_NOEXCEPT : m_deferredOperationKHR( exchange( rhs.m_deferredOperationKHR, {} ) ) {}

    DeferredOperationKHR & operator=( DeferredOperationKHR && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_deferredOperationKHR = exchange( rhs.m_deferredOperationKHR, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR DeferredOperationKHR( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT DeferredOperationKHR( VkDeferredOperationKHR deferredOperationKHR ) VULKAN_HPP_NOEXCEPT
      : m_deferredOperationKHR( deferredOperationKHR )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    DeferredOperationKHR & operator=( VkDeferredOperationKHR deferredOperationKHR ) VULKAN_HPP_NOEXCEPT
    {
      m_deferredOperationKHR = deferredOperationKHR;
      return *this;
    }
#endif

    DeferredOperationKHR & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_deferredOperationKHR = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkDeferredOperationKHR() const VULKAN_HPP_NOEXCEPT
    {
      return m_deferredOperationKHR;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_deferredOperationKHR != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_deferredOperationKHR == VK_NULL_HANDLE;
    }

  private:
    VkDeferredOperationKHR m_deferredOperationKHR = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eDeferredOperationKHR>
  {
    using Type = DeferredOperationKHR;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkDeferredOperationKHR, VK_NULL_HANDLE>
  {
    using Type = DeferredOperationKHR;
  };
#endif

  template <>
  struct isVulkanHandleType<DeferredOperationKHR>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkBufferCollectionFUCHSIA, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferCollectionFUCHSIA.html
#if defined( VK_USE_PLATFORM_FUCHSIA )
  class BufferCollectionFUCHSIA
  {
  public:
    using CType      = VkBufferCollectionFUCHSIA;
    using NativeType = VkBufferCollectionFUCHSIA;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eBufferCollectionFUCHSIA;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eBufferCollectionFUCHSIA;

  public:
    BufferCollectionFUCHSIA() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    BufferCollectionFUCHSIA( BufferCollectionFUCHSIA const & rhs )             = default;
    BufferCollectionFUCHSIA & operator=( BufferCollectionFUCHSIA const & rhs ) = default;

#  if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    BufferCollectionFUCHSIA( BufferCollectionFUCHSIA && rhs )             = default;
    BufferCollectionFUCHSIA & operator=( BufferCollectionFUCHSIA && rhs ) = default;
#  else
    BufferCollectionFUCHSIA( BufferCollectionFUCHSIA && rhs ) VULKAN_HPP_NOEXCEPT : m_bufferCollectionFUCHSIA( exchange( rhs.m_bufferCollectionFUCHSIA, {} ) )
    {
    }

    BufferCollectionFUCHSIA & operator=( BufferCollectionFUCHSIA && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_bufferCollectionFUCHSIA = exchange( rhs.m_bufferCollectionFUCHSIA, {} );
      return *this;
    }
#  endif

    VULKAN_HPP_CONSTEXPR BufferCollectionFUCHSIA( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT BufferCollectionFUCHSIA( VkBufferCollectionFUCHSIA bufferCollectionFUCHSIA ) VULKAN_HPP_NOEXCEPT
      : m_bufferCollectionFUCHSIA( bufferCollectionFUCHSIA )
    {
    }

#  if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    BufferCollectionFUCHSIA & operator=( VkBufferCollectionFUCHSIA bufferCollectionFUCHSIA ) VULKAN_HPP_NOEXCEPT
    {
      m_bufferCollectionFUCHSIA = bufferCollectionFUCHSIA;
      return *this;
    }
#  endif

    BufferCollectionFUCHSIA & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_bufferCollectionFUCHSIA = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkBufferCollectionFUCHSIA() const VULKAN_HPP_NOEXCEPT
    {
      return m_bufferCollectionFUCHSIA;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_bufferCollectionFUCHSIA != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_bufferCollectionFUCHSIA == VK_NULL_HANDLE;
    }

  private:
    VkBufferCollectionFUCHSIA m_bufferCollectionFUCHSIA = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eBufferCollectionFUCHSIA>
  {
    using Type = BufferCollectionFUCHSIA;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eBufferCollectionFUCHSIA>
  {
    using Type = BufferCollectionFUCHSIA;
  };

#  if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkBufferCollectionFUCHSIA, VK_NULL_HANDLE>
  {
    using Type = BufferCollectionFUCHSIA;
  };
#  endif

  template <>
  struct isVulkanHandleType<BufferCollectionFUCHSIA>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

  // wrapper class for handle VkBufferView, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferView.html
  class BufferView
  {
  public:
    using CType      = VkBufferView;
    using NativeType = VkBufferView;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eBufferView;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eBufferView;

  public:
    BufferView() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    BufferView( BufferView const & rhs )             = default;
    BufferView & operator=( BufferView const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    BufferView( BufferView && rhs )             = default;
    BufferView & operator=( BufferView && rhs ) = default;
#else
    BufferView( BufferView && rhs ) VULKAN_HPP_NOEXCEPT : m_bufferView( exchange( rhs.m_bufferView, {} ) ) {}

    BufferView & operator=( BufferView && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_bufferView = exchange( rhs.m_bufferView, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR BufferView( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT BufferView( VkBufferView bufferView ) VULKAN_HPP_NOEXCEPT : m_bufferView( bufferView ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    BufferView & operator=( VkBufferView bufferView ) VULKAN_HPP_NOEXCEPT
    {
      m_bufferView = bufferView;
      return *this;
    }
#endif

    BufferView & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_bufferView = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkBufferView() const VULKAN_HPP_NOEXCEPT
    {
      return m_bufferView;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_bufferView != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_bufferView == VK_NULL_HANDLE;
    }

  private:
    VkBufferView m_bufferView = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eBufferView>
  {
    using Type = BufferView;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eBufferView>
  {
    using Type = BufferView;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkBufferView, VK_NULL_HANDLE>
  {
    using Type = BufferView;
  };
#endif

  template <>
  struct isVulkanHandleType<BufferView>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandPool.html
  class CommandPool
  {
  public:
    using CType      = VkCommandPool;
    using NativeType = VkCommandPool;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCommandPool;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCommandPool;

  public:
    CommandPool() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    CommandPool( CommandPool const & rhs )             = default;
    CommandPool & operator=( CommandPool const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    CommandPool( CommandPool && rhs )             = default;
    CommandPool & operator=( CommandPool && rhs ) = default;
#else
    CommandPool( CommandPool && rhs ) VULKAN_HPP_NOEXCEPT : m_commandPool( exchange( rhs.m_commandPool, {} ) ) {}

    CommandPool & operator=( CommandPool && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_commandPool = exchange( rhs.m_commandPool, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR CommandPool( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT CommandPool( VkCommandPool commandPool ) VULKAN_HPP_NOEXCEPT : m_commandPool( commandPool ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    CommandPool & operator=( VkCommandPool commandPool ) VULKAN_HPP_NOEXCEPT
    {
      m_commandPool = commandPool;
      return *this;
    }
#endif

    CommandPool & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_commandPool = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkCommandPool() const VULKAN_HPP_NOEXCEPT
    {
      return m_commandPool;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_commandPool != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_commandPool == VK_NULL_HANDLE;
    }

  private:
    VkCommandPool m_commandPool = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eCommandPool>
  {
    using Type = CommandPool;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eCommandPool>
  {
    using Type = CommandPool;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkCommandPool, VK_NULL_HANDLE>
  {
    using Type = CommandPool;
  };
#endif

  template <>
  struct isVulkanHandleType<CommandPool>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkPipelineCache, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkPipelineCache.html
  class PipelineCache
  {
  public:
    using CType      = VkPipelineCache;
    using NativeType = VkPipelineCache;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePipelineCache;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::ePipelineCache;

  public:
    PipelineCache() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    PipelineCache( PipelineCache const & rhs )             = default;
    PipelineCache & operator=( PipelineCache const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    PipelineCache( PipelineCache && rhs )             = default;
    PipelineCache & operator=( PipelineCache && rhs ) = default;
#else
    PipelineCache( PipelineCache && rhs ) VULKAN_HPP_NOEXCEPT : m_pipelineCache( exchange( rhs.m_pipelineCache, {} ) ) {}

    PipelineCache & operator=( PipelineCache && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_pipelineCache = exchange( rhs.m_pipelineCache, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR PipelineCache( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT PipelineCache( VkPipelineCache pipelineCache ) VULKAN_HPP_NOEXCEPT : m_pipelineCache( pipelineCache ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    PipelineCache & operator=( VkPipelineCache pipelineCache ) VULKAN_HPP_NOEXCEPT
    {
      m_pipelineCache = pipelineCache;
      return *this;
    }
#endif

    PipelineCache & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_pipelineCache = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkPipelineCache() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipelineCache;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipelineCache != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipelineCache == VK_NULL_HANDLE;
    }

  private:
    VkPipelineCache m_pipelineCache = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::ePipelineCache>
  {
    using Type = PipelineCache;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::ePipelineCache>
  {
    using Type = PipelineCache;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkPipelineCache, VK_NULL_HANDLE>
  {
    using Type = PipelineCache;
  };
#endif

  template <>
  struct isVulkanHandleType<PipelineCache>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkCuFunctionNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCuFunctionNVX.html
  class CuFunctionNVX
  {
  public:
    using CType      = VkCuFunctionNVX;
    using NativeType = VkCuFunctionNVX;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCuFunctionNVX;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCuFunctionNVX;

  public:
    CuFunctionNVX() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    CuFunctionNVX( CuFunctionNVX const & rhs )             = default;
    CuFunctionNVX & operator=( CuFunctionNVX const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    CuFunctionNVX( CuFunctionNVX && rhs )             = default;
    CuFunctionNVX & operator=( CuFunctionNVX && rhs ) = default;
#else
    CuFunctionNVX( CuFunctionNVX && rhs ) VULKAN_HPP_NOEXCEPT : m_cuFunctionNVX( exchange( rhs.m_cuFunctionNVX, {} ) ) {}

    CuFunctionNVX & operator=( CuFunctionNVX && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_cuFunctionNVX = exchange( rhs.m_cuFunctionNVX, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR CuFunctionNVX( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT CuFunctionNVX( VkCuFunctionNVX cuFunctionNVX ) VULKAN_HPP_NOEXCEPT : m_cuFunctionNVX( cuFunctionNVX ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    CuFunctionNVX & operator=( VkCuFunctionNVX cuFunctionNVX ) VULKAN_HPP_NOEXCEPT
    {
      m_cuFunctionNVX = cuFunctionNVX;
      return *this;
    }
#endif

    CuFunctionNVX & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_cuFunctionNVX = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkCuFunctionNVX() const VULKAN_HPP_NOEXCEPT
    {
      return m_cuFunctionNVX;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_cuFunctionNVX != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_cuFunctionNVX == VK_NULL_HANDLE;
    }

  private:
    VkCuFunctionNVX m_cuFunctionNVX = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eCuFunctionNVX>
  {
    using Type = CuFunctionNVX;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eCuFunctionNVX>
  {
    using Type = CuFunctionNVX;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkCuFunctionNVX, VK_NULL_HANDLE>
  {
    using Type = CuFunctionNVX;
  };
#endif

  template <>
  struct isVulkanHandleType<CuFunctionNVX>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkCuModuleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCuModuleNVX.html
  class CuModuleNVX
  {
  public:
    using CType      = VkCuModuleNVX;
    using NativeType = VkCuModuleNVX;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCuModuleNVX;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCuModuleNVX;

  public:
    CuModuleNVX() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    CuModuleNVX( CuModuleNVX const & rhs )             = default;
    CuModuleNVX & operator=( CuModuleNVX const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    CuModuleNVX( CuModuleNVX && rhs )             = default;
    CuModuleNVX & operator=( CuModuleNVX && rhs ) = default;
#else
    CuModuleNVX( CuModuleNVX && rhs ) VULKAN_HPP_NOEXCEPT : m_cuModuleNVX( exchange( rhs.m_cuModuleNVX, {} ) ) {}

    CuModuleNVX & operator=( CuModuleNVX && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_cuModuleNVX = exchange( rhs.m_cuModuleNVX, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR CuModuleNVX( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT CuModuleNVX( VkCuModuleNVX cuModuleNVX ) VULKAN_HPP_NOEXCEPT : m_cuModuleNVX( cuModuleNVX ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    CuModuleNVX & operator=( VkCuModuleNVX cuModuleNVX ) VULKAN_HPP_NOEXCEPT
    {
      m_cuModuleNVX = cuModuleNVX;
      return *this;
    }
#endif

    CuModuleNVX & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_cuModuleNVX = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkCuModuleNVX() const VULKAN_HPP_NOEXCEPT
    {
      return m_cuModuleNVX;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_cuModuleNVX != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_cuModuleNVX == VK_NULL_HANDLE;
    }

  private:
    VkCuModuleNVX m_cuModuleNVX = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eCuModuleNVX>
  {
    using Type = CuModuleNVX;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eCuModuleNVX>
  {
    using Type = CuModuleNVX;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkCuModuleNVX, VK_NULL_HANDLE>
  {
    using Type = CuModuleNVX;
  };
#endif

  template <>
  struct isVulkanHandleType<CuModuleNVX>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkCudaFunctionNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCudaFunctionNV.html
#if defined( VK_ENABLE_BETA_EXTENSIONS )
  class CudaFunctionNV
  {
  public:
    using CType      = VkCudaFunctionNV;
    using NativeType = VkCudaFunctionNV;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCudaFunctionNV;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCudaFunctionNV;

  public:
    CudaFunctionNV() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    CudaFunctionNV( CudaFunctionNV const & rhs )             = default;
    CudaFunctionNV & operator=( CudaFunctionNV const & rhs ) = default;

#  if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    CudaFunctionNV( CudaFunctionNV && rhs )             = default;
    CudaFunctionNV & operator=( CudaFunctionNV && rhs ) = default;
#  else
    CudaFunctionNV( CudaFunctionNV && rhs ) VULKAN_HPP_NOEXCEPT : m_cudaFunctionNV( exchange( rhs.m_cudaFunctionNV, {} ) ) {}

    CudaFunctionNV & operator=( CudaFunctionNV && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_cudaFunctionNV = exchange( rhs.m_cudaFunctionNV, {} );
      return *this;
    }
#  endif

    VULKAN_HPP_CONSTEXPR CudaFunctionNV( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT CudaFunctionNV( VkCudaFunctionNV cudaFunctionNV ) VULKAN_HPP_NOEXCEPT : m_cudaFunctionNV( cudaFunctionNV ) {}

#  if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    CudaFunctionNV & operator=( VkCudaFunctionNV cudaFunctionNV ) VULKAN_HPP_NOEXCEPT
    {
      m_cudaFunctionNV = cudaFunctionNV;
      return *this;
    }
#  endif

    CudaFunctionNV & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_cudaFunctionNV = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkCudaFunctionNV() const VULKAN_HPP_NOEXCEPT
    {
      return m_cudaFunctionNV;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_cudaFunctionNV != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_cudaFunctionNV == VK_NULL_HANDLE;
    }

  private:
    VkCudaFunctionNV m_cudaFunctionNV = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eCudaFunctionNV>
  {
    using Type = CudaFunctionNV;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eCudaFunctionNV>
  {
    using Type = CudaFunctionNV;
  };

#  if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkCudaFunctionNV, VK_NULL_HANDLE>
  {
    using Type = CudaFunctionNV;
  };
#  endif

  template <>
  struct isVulkanHandleType<CudaFunctionNV>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

  // wrapper class for handle VkCudaModuleNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCudaModuleNV.html
#if defined( VK_ENABLE_BETA_EXTENSIONS )
  class CudaModuleNV
  {
  public:
    using CType      = VkCudaModuleNV;
    using NativeType = VkCudaModuleNV;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCudaModuleNV;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCudaModuleNV;

  public:
    CudaModuleNV() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    CudaModuleNV( CudaModuleNV const & rhs )             = default;
    CudaModuleNV & operator=( CudaModuleNV const & rhs ) = default;

#  if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    CudaModuleNV( CudaModuleNV && rhs )             = default;
    CudaModuleNV & operator=( CudaModuleNV && rhs ) = default;
#  else
    CudaModuleNV( CudaModuleNV && rhs ) VULKAN_HPP_NOEXCEPT : m_cudaModuleNV( exchange( rhs.m_cudaModuleNV, {} ) ) {}

    CudaModuleNV & operator=( CudaModuleNV && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_cudaModuleNV = exchange( rhs.m_cudaModuleNV, {} );
      return *this;
    }
#  endif

    VULKAN_HPP_CONSTEXPR CudaModuleNV( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT CudaModuleNV( VkCudaModuleNV cudaModuleNV ) VULKAN_HPP_NOEXCEPT : m_cudaModuleNV( cudaModuleNV ) {}

#  if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    CudaModuleNV & operator=( VkCudaModuleNV cudaModuleNV ) VULKAN_HPP_NOEXCEPT
    {
      m_cudaModuleNV = cudaModuleNV;
      return *this;
    }
#  endif

    CudaModuleNV & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_cudaModuleNV = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkCudaModuleNV() const VULKAN_HPP_NOEXCEPT
    {
      return m_cudaModuleNV;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_cudaModuleNV != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_cudaModuleNV == VK_NULL_HANDLE;
    }

  private:
    VkCudaModuleNV m_cudaModuleNV = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eCudaModuleNV>
  {
    using Type = CudaModuleNV;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eCudaModuleNV>
  {
    using Type = CudaModuleNV;
  };

#  if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkCudaModuleNV, VK_NULL_HANDLE>
  {
    using Type = CudaModuleNV;
  };
#  endif

  template <>
  struct isVulkanHandleType<CudaModuleNV>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

  // wrapper class for handle VkDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDescriptorPool.html
  class DescriptorPool
  {
  public:
    using CType      = VkDescriptorPool;
    using NativeType = VkDescriptorPool;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDescriptorPool;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDescriptorPool;

  public:
    DescriptorPool() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    DescriptorPool( DescriptorPool const & rhs )             = default;
    DescriptorPool & operator=( DescriptorPool const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    DescriptorPool( DescriptorPool && rhs )             = default;
    DescriptorPool & operator=( DescriptorPool && rhs ) = default;
#else
    DescriptorPool( DescriptorPool && rhs ) VULKAN_HPP_NOEXCEPT : m_descriptorPool( exchange( rhs.m_descriptorPool, {} ) ) {}

    DescriptorPool & operator=( DescriptorPool && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorPool = exchange( rhs.m_descriptorPool, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR DescriptorPool( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT DescriptorPool( VkDescriptorPool descriptorPool ) VULKAN_HPP_NOEXCEPT : m_descriptorPool( descriptorPool ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    DescriptorPool & operator=( VkDescriptorPool descriptorPool ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorPool = descriptorPool;
      return *this;
    }
#endif

    DescriptorPool & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorPool = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkDescriptorPool() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorPool;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorPool != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorPool == VK_NULL_HANDLE;
    }

  private:
    VkDescriptorPool m_descriptorPool = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eDescriptorPool>
  {
    using Type = DescriptorPool;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eDescriptorPool>
  {
    using Type = DescriptorPool;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkDescriptorPool, VK_NULL_HANDLE>
  {
    using Type = DescriptorPool;
  };
#endif

  template <>
  struct isVulkanHandleType<DescriptorPool>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkDescriptorSetLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDescriptorSetLayout.html
  class DescriptorSetLayout
  {
  public:
    using CType      = VkDescriptorSetLayout;
    using NativeType = VkDescriptorSetLayout;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDescriptorSetLayout;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDescriptorSetLayout;

  public:
    DescriptorSetLayout() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    DescriptorSetLayout( DescriptorSetLayout const & rhs )             = default;
    DescriptorSetLayout & operator=( DescriptorSetLayout const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    DescriptorSetLayout( DescriptorSetLayout && rhs )             = default;
    DescriptorSetLayout & operator=( DescriptorSetLayout && rhs ) = default;
#else
    DescriptorSetLayout( DescriptorSetLayout && rhs ) VULKAN_HPP_NOEXCEPT : m_descriptorSetLayout( exchange( rhs.m_descriptorSetLayout, {} ) ) {}

    DescriptorSetLayout & operator=( DescriptorSetLayout && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorSetLayout = exchange( rhs.m_descriptorSetLayout, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR DescriptorSetLayout( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT DescriptorSetLayout( VkDescriptorSetLayout descriptorSetLayout ) VULKAN_HPP_NOEXCEPT
      : m_descriptorSetLayout( descriptorSetLayout )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    DescriptorSetLayout & operator=( VkDescriptorSetLayout descriptorSetLayout ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorSetLayout = descriptorSetLayout;
      return *this;
    }
#endif

    DescriptorSetLayout & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_descriptorSetLayout = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkDescriptorSetLayout() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorSetLayout;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorSetLayout != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_descriptorSetLayout == VK_NULL_HANDLE;
    }

  private:
    VkDescriptorSetLayout m_descriptorSetLayout = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eDescriptorSetLayout>
  {
    using Type = DescriptorSetLayout;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eDescriptorSetLayout>
  {
    using Type = DescriptorSetLayout;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkDescriptorSetLayout, VK_NULL_HANDLE>
  {
    using Type = DescriptorSetLayout;
  };
#endif

  template <>
  struct isVulkanHandleType<DescriptorSetLayout>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkExternalComputeQueueNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkExternalComputeQueueNV.html
  class ExternalComputeQueueNV
  {
  public:
    using CType      = VkExternalComputeQueueNV;
    using NativeType = VkExternalComputeQueueNV;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eExternalComputeQueueNV;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    ExternalComputeQueueNV() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    ExternalComputeQueueNV( ExternalComputeQueueNV const & rhs )             = default;
    ExternalComputeQueueNV & operator=( ExternalComputeQueueNV const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    ExternalComputeQueueNV( ExternalComputeQueueNV && rhs )             = default;
    ExternalComputeQueueNV & operator=( ExternalComputeQueueNV && rhs ) = default;
#else
    ExternalComputeQueueNV( ExternalComputeQueueNV && rhs ) VULKAN_HPP_NOEXCEPT : m_externalComputeQueueNV( exchange( rhs.m_externalComputeQueueNV, {} ) ) {}

    ExternalComputeQueueNV & operator=( ExternalComputeQueueNV && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_externalComputeQueueNV = exchange( rhs.m_externalComputeQueueNV, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR ExternalComputeQueueNV( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    ExternalComputeQueueNV( VkExternalComputeQueueNV externalComputeQueueNV ) VULKAN_HPP_NOEXCEPT : m_externalComputeQueueNV( externalComputeQueueNV ) {}

    ExternalComputeQueueNV & operator=( VkExternalComputeQueueNV externalComputeQueueNV ) VULKAN_HPP_NOEXCEPT
    {
      m_externalComputeQueueNV = externalComputeQueueNV;
      return *this;
    }

    ExternalComputeQueueNV & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_externalComputeQueueNV = {};
      return *this;
    }

    //=== VK_NV_external_compute_queue ===

    // wrapper function for command vkGetExternalComputeQueueDataNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetExternalComputeQueueDataNV.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetExternalComputeQueueDataNV ), bool>::type = true>
    void
      getData( ExternalComputeQueueDataParamsNV * params, void * pData, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetExternalComputeQueueDataNV, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetExternalComputeQueueDataNV.html
    template <typename DataType,
              typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetExternalComputeQueueDataNV ), bool>::type = true>
    VULKAN_HPP_NODISCARD std::pair<ExternalComputeQueueDataParamsNV, DataType>
                         getData( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    operator VkExternalComputeQueueNV() const VULKAN_HPP_NOEXCEPT
    {
      return m_externalComputeQueueNV;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_externalComputeQueueNV != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_externalComputeQueueNV == VK_NULL_HANDLE;
    }

  private:
    VkExternalComputeQueueNV m_externalComputeQueueNV = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eExternalComputeQueueNV>
  {
    using Type = ExternalComputeQueueNV;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkExternalComputeQueueNV, VK_NULL_HANDLE>
  {
    using Type = ExternalComputeQueueNV;
  };
#endif

  template <>
  struct isVulkanHandleType<ExternalComputeQueueNV>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkFramebuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkFramebuffer.html
  class Framebuffer
  {
  public:
    using CType      = VkFramebuffer;
    using NativeType = VkFramebuffer;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eFramebuffer;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eFramebuffer;

  public:
    Framebuffer() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    Framebuffer( Framebuffer const & rhs )             = default;
    Framebuffer & operator=( Framebuffer const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    Framebuffer( Framebuffer && rhs )             = default;
    Framebuffer & operator=( Framebuffer && rhs ) = default;
#else
    Framebuffer( Framebuffer && rhs ) VULKAN_HPP_NOEXCEPT : m_framebuffer( exchange( rhs.m_framebuffer, {} ) ) {}

    Framebuffer & operator=( Framebuffer && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_framebuffer = exchange( rhs.m_framebuffer, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR Framebuffer( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT Framebuffer( VkFramebuffer framebuffer ) VULKAN_HPP_NOEXCEPT : m_framebuffer( framebuffer ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    Framebuffer & operator=( VkFramebuffer framebuffer ) VULKAN_HPP_NOEXCEPT
    {
      m_framebuffer = framebuffer;
      return *this;
    }
#endif

    Framebuffer & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_framebuffer = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkFramebuffer() const VULKAN_HPP_NOEXCEPT
    {
      return m_framebuffer;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_framebuffer != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_framebuffer == VK_NULL_HANDLE;
    }

  private:
    VkFramebuffer m_framebuffer = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eFramebuffer>
  {
    using Type = Framebuffer;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eFramebuffer>
  {
    using Type = Framebuffer;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkFramebuffer, VK_NULL_HANDLE>
  {
    using Type = Framebuffer;
  };
#endif

  template <>
  struct isVulkanHandleType<Framebuffer>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkIndirectCommandsLayoutEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkIndirectCommandsLayoutEXT.html
  class IndirectCommandsLayoutEXT
  {
  public:
    using CType      = VkIndirectCommandsLayoutEXT;
    using NativeType = VkIndirectCommandsLayoutEXT;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eIndirectCommandsLayoutEXT;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    IndirectCommandsLayoutEXT() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    IndirectCommandsLayoutEXT( IndirectCommandsLayoutEXT const & rhs )             = default;
    IndirectCommandsLayoutEXT & operator=( IndirectCommandsLayoutEXT const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    IndirectCommandsLayoutEXT( IndirectCommandsLayoutEXT && rhs )             = default;
    IndirectCommandsLayoutEXT & operator=( IndirectCommandsLayoutEXT && rhs ) = default;
#else
    IndirectCommandsLayoutEXT( IndirectCommandsLayoutEXT && rhs ) VULKAN_HPP_NOEXCEPT
      : m_indirectCommandsLayoutEXT( exchange( rhs.m_indirectCommandsLayoutEXT, {} ) )
    {
    }

    IndirectCommandsLayoutEXT & operator=( IndirectCommandsLayoutEXT && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_indirectCommandsLayoutEXT = exchange( rhs.m_indirectCommandsLayoutEXT, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR IndirectCommandsLayoutEXT( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT IndirectCommandsLayoutEXT( VkIndirectCommandsLayoutEXT indirectCommandsLayoutEXT ) VULKAN_HPP_NOEXCEPT
      : m_indirectCommandsLayoutEXT( indirectCommandsLayoutEXT )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    IndirectCommandsLayoutEXT & operator=( VkIndirectCommandsLayoutEXT indirectCommandsLayoutEXT ) VULKAN_HPP_NOEXCEPT
    {
      m_indirectCommandsLayoutEXT = indirectCommandsLayoutEXT;
      return *this;
    }
#endif

    IndirectCommandsLayoutEXT & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_indirectCommandsLayoutEXT = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkIndirectCommandsLayoutEXT() const VULKAN_HPP_NOEXCEPT
    {
      return m_indirectCommandsLayoutEXT;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_indirectCommandsLayoutEXT != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_indirectCommandsLayoutEXT == VK_NULL_HANDLE;
    }

  private:
    VkIndirectCommandsLayoutEXT m_indirectCommandsLayoutEXT = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eIndirectCommandsLayoutEXT>
  {
    using Type = IndirectCommandsLayoutEXT;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkIndirectCommandsLayoutEXT, VK_NULL_HANDLE>
  {
    using Type = IndirectCommandsLayoutEXT;
  };
#endif

  template <>
  struct isVulkanHandleType<IndirectCommandsLayoutEXT>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkIndirectCommandsLayoutNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkIndirectCommandsLayoutNV.html
  class IndirectCommandsLayoutNV
  {
  public:
    using CType      = VkIndirectCommandsLayoutNV;
    using NativeType = VkIndirectCommandsLayoutNV;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eIndirectCommandsLayoutNV;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    IndirectCommandsLayoutNV() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    IndirectCommandsLayoutNV( IndirectCommandsLayoutNV const & rhs )             = default;
    IndirectCommandsLayoutNV & operator=( IndirectCommandsLayoutNV const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    IndirectCommandsLayoutNV( IndirectCommandsLayoutNV && rhs )             = default;
    IndirectCommandsLayoutNV & operator=( IndirectCommandsLayoutNV && rhs ) = default;
#else
    IndirectCommandsLayoutNV( IndirectCommandsLayoutNV && rhs ) VULKAN_HPP_NOEXCEPT
      : m_indirectCommandsLayoutNV( exchange( rhs.m_indirectCommandsLayoutNV, {} ) )
    {
    }

    IndirectCommandsLayoutNV & operator=( IndirectCommandsLayoutNV && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_indirectCommandsLayoutNV = exchange( rhs.m_indirectCommandsLayoutNV, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR IndirectCommandsLayoutNV( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT IndirectCommandsLayoutNV( VkIndirectCommandsLayoutNV indirectCommandsLayoutNV ) VULKAN_HPP_NOEXCEPT
      : m_indirectCommandsLayoutNV( indirectCommandsLayoutNV )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    IndirectCommandsLayoutNV & operator=( VkIndirectCommandsLayoutNV indirectCommandsLayoutNV ) VULKAN_HPP_NOEXCEPT
    {
      m_indirectCommandsLayoutNV = indirectCommandsLayoutNV;
      return *this;
    }
#endif

    IndirectCommandsLayoutNV & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_indirectCommandsLayoutNV = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkIndirectCommandsLayoutNV() const VULKAN_HPP_NOEXCEPT
    {
      return m_indirectCommandsLayoutNV;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_indirectCommandsLayoutNV != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_indirectCommandsLayoutNV == VK_NULL_HANDLE;
    }

  private:
    VkIndirectCommandsLayoutNV m_indirectCommandsLayoutNV = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eIndirectCommandsLayoutNV>
  {
    using Type = IndirectCommandsLayoutNV;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkIndirectCommandsLayoutNV, VK_NULL_HANDLE>
  {
    using Type = IndirectCommandsLayoutNV;
  };
#endif

  template <>
  struct isVulkanHandleType<IndirectCommandsLayoutNV>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkIndirectExecutionSetEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkIndirectExecutionSetEXT.html
  class IndirectExecutionSetEXT
  {
  public:
    using CType      = VkIndirectExecutionSetEXT;
    using NativeType = VkIndirectExecutionSetEXT;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eIndirectExecutionSetEXT;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    IndirectExecutionSetEXT() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    IndirectExecutionSetEXT( IndirectExecutionSetEXT const & rhs )             = default;
    IndirectExecutionSetEXT & operator=( IndirectExecutionSetEXT const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    IndirectExecutionSetEXT( IndirectExecutionSetEXT && rhs )             = default;
    IndirectExecutionSetEXT & operator=( IndirectExecutionSetEXT && rhs ) = default;
#else
    IndirectExecutionSetEXT( IndirectExecutionSetEXT && rhs ) VULKAN_HPP_NOEXCEPT : m_indirectExecutionSetEXT( exchange( rhs.m_indirectExecutionSetEXT, {} ) )
    {
    }

    IndirectExecutionSetEXT & operator=( IndirectExecutionSetEXT && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_indirectExecutionSetEXT = exchange( rhs.m_indirectExecutionSetEXT, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR IndirectExecutionSetEXT( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT IndirectExecutionSetEXT( VkIndirectExecutionSetEXT indirectExecutionSetEXT ) VULKAN_HPP_NOEXCEPT
      : m_indirectExecutionSetEXT( indirectExecutionSetEXT )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    IndirectExecutionSetEXT & operator=( VkIndirectExecutionSetEXT indirectExecutionSetEXT ) VULKAN_HPP_NOEXCEPT
    {
      m_indirectExecutionSetEXT = indirectExecutionSetEXT;
      return *this;
    }
#endif

    IndirectExecutionSetEXT & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_indirectExecutionSetEXT = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkIndirectExecutionSetEXT() const VULKAN_HPP_NOEXCEPT
    {
      return m_indirectExecutionSetEXT;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_indirectExecutionSetEXT != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_indirectExecutionSetEXT == VK_NULL_HANDLE;
    }

  private:
    VkIndirectExecutionSetEXT m_indirectExecutionSetEXT = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eIndirectExecutionSetEXT>
  {
    using Type = IndirectExecutionSetEXT;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkIndirectExecutionSetEXT, VK_NULL_HANDLE>
  {
    using Type = IndirectExecutionSetEXT;
  };
#endif

  template <>
  struct isVulkanHandleType<IndirectExecutionSetEXT>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkPrivateDataSlot, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkPrivateDataSlot.html
  class PrivateDataSlot
  {
  public:
    using CType      = VkPrivateDataSlot;
    using NativeType = VkPrivateDataSlot;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePrivateDataSlot;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    PrivateDataSlot() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    PrivateDataSlot( PrivateDataSlot const & rhs )             = default;
    PrivateDataSlot & operator=( PrivateDataSlot const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    PrivateDataSlot( PrivateDataSlot && rhs )             = default;
    PrivateDataSlot & operator=( PrivateDataSlot && rhs ) = default;
#else
    PrivateDataSlot( PrivateDataSlot && rhs ) VULKAN_HPP_NOEXCEPT : m_privateDataSlot( exchange( rhs.m_privateDataSlot, {} ) ) {}

    PrivateDataSlot & operator=( PrivateDataSlot && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_privateDataSlot = exchange( rhs.m_privateDataSlot, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR PrivateDataSlot( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT PrivateDataSlot( VkPrivateDataSlot privateDataSlot ) VULKAN_HPP_NOEXCEPT : m_privateDataSlot( privateDataSlot ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    PrivateDataSlot & operator=( VkPrivateDataSlot privateDataSlot ) VULKAN_HPP_NOEXCEPT
    {
      m_privateDataSlot = privateDataSlot;
      return *this;
    }
#endif

    PrivateDataSlot & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_privateDataSlot = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkPrivateDataSlot() const VULKAN_HPP_NOEXCEPT
    {
      return m_privateDataSlot;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_privateDataSlot != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_privateDataSlot == VK_NULL_HANDLE;
    }

  private:
    VkPrivateDataSlot m_privateDataSlot = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::ePrivateDataSlot>
  {
    using Type = PrivateDataSlot;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkPrivateDataSlot, VK_NULL_HANDLE>
  {
    using Type = PrivateDataSlot;
  };
#endif

  template <>
  struct isVulkanHandleType<PrivateDataSlot>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  using PrivateDataSlotEXT = PrivateDataSlot;

  // wrapper class for handle VkRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkRenderPass.html
  class RenderPass
  {
  public:
    using CType      = VkRenderPass;
    using NativeType = VkRenderPass;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eRenderPass;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eRenderPass;

  public:
    RenderPass() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    RenderPass( RenderPass const & rhs )             = default;
    RenderPass & operator=( RenderPass const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    RenderPass( RenderPass && rhs )             = default;
    RenderPass & operator=( RenderPass && rhs ) = default;
#else
    RenderPass( RenderPass && rhs ) VULKAN_HPP_NOEXCEPT : m_renderPass( exchange( rhs.m_renderPass, {} ) ) {}

    RenderPass & operator=( RenderPass && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_renderPass = exchange( rhs.m_renderPass, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR RenderPass( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT RenderPass( VkRenderPass renderPass ) VULKAN_HPP_NOEXCEPT : m_renderPass( renderPass ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    RenderPass & operator=( VkRenderPass renderPass ) VULKAN_HPP_NOEXCEPT
    {
      m_renderPass = renderPass;
      return *this;
    }
#endif

    RenderPass & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_renderPass = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkRenderPass() const VULKAN_HPP_NOEXCEPT
    {
      return m_renderPass;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_renderPass != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_renderPass == VK_NULL_HANDLE;
    }

  private:
    VkRenderPass m_renderPass = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eRenderPass>
  {
    using Type = RenderPass;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eRenderPass>
  {
    using Type = RenderPass;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkRenderPass, VK_NULL_HANDLE>
  {
    using Type = RenderPass;
  };
#endif

  template <>
  struct isVulkanHandleType<RenderPass>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkSampler, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSampler.html
  class Sampler
  {
  public:
    using CType      = VkSampler;
    using NativeType = VkSampler;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eSampler;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eSampler;

  public:
    Sampler() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    Sampler( Sampler const & rhs )             = default;
    Sampler & operator=( Sampler const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    Sampler( Sampler && rhs )             = default;
    Sampler & operator=( Sampler && rhs ) = default;
#else
    Sampler( Sampler && rhs ) VULKAN_HPP_NOEXCEPT : m_sampler( exchange( rhs.m_sampler, {} ) ) {}

    Sampler & operator=( Sampler && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_sampler = exchange( rhs.m_sampler, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR Sampler( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT Sampler( VkSampler sampler ) VULKAN_HPP_NOEXCEPT : m_sampler( sampler ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    Sampler & operator=( VkSampler sampler ) VULKAN_HPP_NOEXCEPT
    {
      m_sampler = sampler;
      return *this;
    }
#endif

    Sampler & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_sampler = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkSampler() const VULKAN_HPP_NOEXCEPT
    {
      return m_sampler;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_sampler != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_sampler == VK_NULL_HANDLE;
    }

  private:
    VkSampler m_sampler = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eSampler>
  {
    using Type = Sampler;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eSampler>
  {
    using Type = Sampler;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkSampler, VK_NULL_HANDLE>
  {
    using Type = Sampler;
  };
#endif

  template <>
  struct isVulkanHandleType<Sampler>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkSamplerYcbcrConversion, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSamplerYcbcrConversion.html
  class SamplerYcbcrConversion
  {
  public:
    using CType      = VkSamplerYcbcrConversion;
    using NativeType = VkSamplerYcbcrConversion;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eSamplerYcbcrConversion;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eSamplerYcbcrConversion;

  public:
    SamplerYcbcrConversion() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    SamplerYcbcrConversion( SamplerYcbcrConversion const & rhs )             = default;
    SamplerYcbcrConversion & operator=( SamplerYcbcrConversion const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    SamplerYcbcrConversion( SamplerYcbcrConversion && rhs )             = default;
    SamplerYcbcrConversion & operator=( SamplerYcbcrConversion && rhs ) = default;
#else
    SamplerYcbcrConversion( SamplerYcbcrConversion && rhs ) VULKAN_HPP_NOEXCEPT : m_samplerYcbcrConversion( exchange( rhs.m_samplerYcbcrConversion, {} ) ) {}

    SamplerYcbcrConversion & operator=( SamplerYcbcrConversion && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_samplerYcbcrConversion = exchange( rhs.m_samplerYcbcrConversion, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR SamplerYcbcrConversion( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT SamplerYcbcrConversion( VkSamplerYcbcrConversion samplerYcbcrConversion ) VULKAN_HPP_NOEXCEPT
      : m_samplerYcbcrConversion( samplerYcbcrConversion )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    SamplerYcbcrConversion & operator=( VkSamplerYcbcrConversion samplerYcbcrConversion ) VULKAN_HPP_NOEXCEPT
    {
      m_samplerYcbcrConversion = samplerYcbcrConversion;
      return *this;
    }
#endif

    SamplerYcbcrConversion & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_samplerYcbcrConversion = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkSamplerYcbcrConversion() const VULKAN_HPP_NOEXCEPT
    {
      return m_samplerYcbcrConversion;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_samplerYcbcrConversion != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_samplerYcbcrConversion == VK_NULL_HANDLE;
    }

  private:
    VkSamplerYcbcrConversion m_samplerYcbcrConversion = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eSamplerYcbcrConversion>
  {
    using Type = SamplerYcbcrConversion;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eSamplerYcbcrConversion>
  {
    using Type = SamplerYcbcrConversion;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkSamplerYcbcrConversion, VK_NULL_HANDLE>
  {
    using Type = SamplerYcbcrConversion;
  };
#endif

  template <>
  struct isVulkanHandleType<SamplerYcbcrConversion>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  using SamplerYcbcrConversionKHR = SamplerYcbcrConversion;

  // wrapper class for handle VkShaderModule, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkShaderModule.html
  class ShaderModule
  {
  public:
    using CType      = VkShaderModule;
    using NativeType = VkShaderModule;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eShaderModule;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eShaderModule;

  public:
    ShaderModule() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    ShaderModule( ShaderModule const & rhs )             = default;
    ShaderModule & operator=( ShaderModule const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    ShaderModule( ShaderModule && rhs )             = default;
    ShaderModule & operator=( ShaderModule && rhs ) = default;
#else
    ShaderModule( ShaderModule && rhs ) VULKAN_HPP_NOEXCEPT : m_shaderModule( exchange( rhs.m_shaderModule, {} ) ) {}

    ShaderModule & operator=( ShaderModule && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_shaderModule = exchange( rhs.m_shaderModule, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR ShaderModule( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT ShaderModule( VkShaderModule shaderModule ) VULKAN_HPP_NOEXCEPT : m_shaderModule( shaderModule ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    ShaderModule & operator=( VkShaderModule shaderModule ) VULKAN_HPP_NOEXCEPT
    {
      m_shaderModule = shaderModule;
      return *this;
    }
#endif

    ShaderModule & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_shaderModule = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkShaderModule() const VULKAN_HPP_NOEXCEPT
    {
      return m_shaderModule;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_shaderModule != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_shaderModule == VK_NULL_HANDLE;
    }

  private:
    VkShaderModule m_shaderModule = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eShaderModule>
  {
    using Type = ShaderModule;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eShaderModule>
  {
    using Type = ShaderModule;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkShaderModule, VK_NULL_HANDLE>
  {
    using Type = ShaderModule;
  };
#endif

  template <>
  struct isVulkanHandleType<ShaderModule>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkTensorARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkTensorARM.html
  class TensorARM
  {
  public:
    using CType      = VkTensorARM;
    using NativeType = VkTensorARM;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eTensorARM;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    TensorARM() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    TensorARM( TensorARM const & rhs )             = default;
    TensorARM & operator=( TensorARM const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    TensorARM( TensorARM && rhs )             = default;
    TensorARM & operator=( TensorARM && rhs ) = default;
#else
    TensorARM( TensorARM && rhs ) VULKAN_HPP_NOEXCEPT : m_tensorARM( exchange( rhs.m_tensorARM, {} ) ) {}

    TensorARM & operator=( TensorARM && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_tensorARM = exchange( rhs.m_tensorARM, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR TensorARM( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT TensorARM( VkTensorARM tensorARM ) VULKAN_HPP_NOEXCEPT : m_tensorARM( tensorARM ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    TensorARM & operator=( VkTensorARM tensorARM ) VULKAN_HPP_NOEXCEPT
    {
      m_tensorARM = tensorARM;
      return *this;
    }
#endif

    TensorARM & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_tensorARM = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkTensorARM() const VULKAN_HPP_NOEXCEPT
    {
      return m_tensorARM;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_tensorARM != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_tensorARM == VK_NULL_HANDLE;
    }

  private:
    VkTensorARM m_tensorARM = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eTensorARM>
  {
    using Type = TensorARM;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkTensorARM, VK_NULL_HANDLE>
  {
    using Type = TensorARM;
  };
#endif

  template <>
  struct isVulkanHandleType<TensorARM>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkTensorViewARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkTensorViewARM.html
  class TensorViewARM
  {
  public:
    using CType      = VkTensorViewARM;
    using NativeType = VkTensorViewARM;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eTensorViewARM;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    TensorViewARM() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    TensorViewARM( TensorViewARM const & rhs )             = default;
    TensorViewARM & operator=( TensorViewARM const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    TensorViewARM( TensorViewARM && rhs )             = default;
    TensorViewARM & operator=( TensorViewARM && rhs ) = default;
#else
    TensorViewARM( TensorViewARM && rhs ) VULKAN_HPP_NOEXCEPT : m_tensorViewARM( exchange( rhs.m_tensorViewARM, {} ) ) {}

    TensorViewARM & operator=( TensorViewARM && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_tensorViewARM = exchange( rhs.m_tensorViewARM, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR TensorViewARM( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT TensorViewARM( VkTensorViewARM tensorViewARM ) VULKAN_HPP_NOEXCEPT : m_tensorViewARM( tensorViewARM ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    TensorViewARM & operator=( VkTensorViewARM tensorViewARM ) VULKAN_HPP_NOEXCEPT
    {
      m_tensorViewARM = tensorViewARM;
      return *this;
    }
#endif

    TensorViewARM & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_tensorViewARM = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkTensorViewARM() const VULKAN_HPP_NOEXCEPT
    {
      return m_tensorViewARM;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_tensorViewARM != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_tensorViewARM == VK_NULL_HANDLE;
    }

  private:
    VkTensorViewARM m_tensorViewARM = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eTensorViewARM>
  {
    using Type = TensorViewARM;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkTensorViewARM, VK_NULL_HANDLE>
  {
    using Type = TensorViewARM;
  };
#endif

  template <>
  struct isVulkanHandleType<TensorViewARM>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkValidationCacheEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkValidationCacheEXT.html
  class ValidationCacheEXT
  {
  public:
    using CType      = VkValidationCacheEXT;
    using NativeType = VkValidationCacheEXT;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eValidationCacheEXT;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eValidationCacheEXT;

  public:
    ValidationCacheEXT() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    ValidationCacheEXT( ValidationCacheEXT const & rhs )             = default;
    ValidationCacheEXT & operator=( ValidationCacheEXT const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    ValidationCacheEXT( ValidationCacheEXT && rhs )             = default;
    ValidationCacheEXT & operator=( ValidationCacheEXT && rhs ) = default;
#else
    ValidationCacheEXT( ValidationCacheEXT && rhs ) VULKAN_HPP_NOEXCEPT : m_validationCacheEXT( exchange( rhs.m_validationCacheEXT, {} ) ) {}

    ValidationCacheEXT & operator=( ValidationCacheEXT && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_validationCacheEXT = exchange( rhs.m_validationCacheEXT, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR ValidationCacheEXT( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT ValidationCacheEXT( VkValidationCacheEXT validationCacheEXT ) VULKAN_HPP_NOEXCEPT : m_validationCacheEXT( validationCacheEXT )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    ValidationCacheEXT & operator=( VkValidationCacheEXT validationCacheEXT ) VULKAN_HPP_NOEXCEPT
    {
      m_validationCacheEXT = validationCacheEXT;
      return *this;
    }
#endif

    ValidationCacheEXT & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_validationCacheEXT = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkValidationCacheEXT() const VULKAN_HPP_NOEXCEPT
    {
      return m_validationCacheEXT;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_validationCacheEXT != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_validationCacheEXT == VK_NULL_HANDLE;
    }

  private:
    VkValidationCacheEXT m_validationCacheEXT = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eValidationCacheEXT>
  {
    using Type = ValidationCacheEXT;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eValidationCacheEXT>
  {
    using Type = ValidationCacheEXT;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkValidationCacheEXT, VK_NULL_HANDLE>
  {
    using Type = ValidationCacheEXT;
  };
#endif

  template <>
  struct isVulkanHandleType<ValidationCacheEXT>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkVideoSessionParametersKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkVideoSessionParametersKHR.html
  class VideoSessionParametersKHR
  {
  public:
    using CType      = VkVideoSessionParametersKHR;
    using NativeType = VkVideoSessionParametersKHR;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eVideoSessionParametersKHR;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    VideoSessionParametersKHR() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    VideoSessionParametersKHR( VideoSessionParametersKHR const & rhs )             = default;
    VideoSessionParametersKHR & operator=( VideoSessionParametersKHR const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    VideoSessionParametersKHR( VideoSessionParametersKHR && rhs )             = default;
    VideoSessionParametersKHR & operator=( VideoSessionParametersKHR && rhs ) = default;
#else
    VideoSessionParametersKHR( VideoSessionParametersKHR && rhs ) VULKAN_HPP_NOEXCEPT
      : m_videoSessionParametersKHR( exchange( rhs.m_videoSessionParametersKHR, {} ) )
    {
    }

    VideoSessionParametersKHR & operator=( VideoSessionParametersKHR && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_videoSessionParametersKHR = exchange( rhs.m_videoSessionParametersKHR, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR VideoSessionParametersKHR( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT VideoSessionParametersKHR( VkVideoSessionParametersKHR videoSessionParametersKHR ) VULKAN_HPP_NOEXCEPT
      : m_videoSessionParametersKHR( videoSessionParametersKHR )
    {
    }

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    VideoSessionParametersKHR & operator=( VkVideoSessionParametersKHR videoSessionParametersKHR ) VULKAN_HPP_NOEXCEPT
    {
      m_videoSessionParametersKHR = videoSessionParametersKHR;
      return *this;
    }
#endif

    VideoSessionParametersKHR & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_videoSessionParametersKHR = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkVideoSessionParametersKHR() const VULKAN_HPP_NOEXCEPT
    {
      return m_videoSessionParametersKHR;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_videoSessionParametersKHR != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_videoSessionParametersKHR == VK_NULL_HANDLE;
    }

  private:
    VkVideoSessionParametersKHR m_videoSessionParametersKHR = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eVideoSessionParametersKHR>
  {
    using Type = VideoSessionParametersKHR;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkVideoSessionParametersKHR, VK_NULL_HANDLE>
  {
    using Type = VideoSessionParametersKHR;
  };
#endif

  template <>
  struct isVulkanHandleType<VideoSessionParametersKHR>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkPipelineBinaryKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkPipelineBinaryKHR.html
  class PipelineBinaryKHR
  {
  public:
    using CType      = VkPipelineBinaryKHR;
    using NativeType = VkPipelineBinaryKHR;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePipelineBinaryKHR;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

  public:
    PipelineBinaryKHR() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    PipelineBinaryKHR( PipelineBinaryKHR const & rhs )             = default;
    PipelineBinaryKHR & operator=( PipelineBinaryKHR const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    PipelineBinaryKHR( PipelineBinaryKHR && rhs )             = default;
    PipelineBinaryKHR & operator=( PipelineBinaryKHR && rhs ) = default;
#else
    PipelineBinaryKHR( PipelineBinaryKHR && rhs ) VULKAN_HPP_NOEXCEPT : m_pipelineBinaryKHR( exchange( rhs.m_pipelineBinaryKHR, {} ) ) {}

    PipelineBinaryKHR & operator=( PipelineBinaryKHR && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_pipelineBinaryKHR = exchange( rhs.m_pipelineBinaryKHR, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR PipelineBinaryKHR( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    VULKAN_HPP_TYPESAFE_EXPLICIT PipelineBinaryKHR( VkPipelineBinaryKHR pipelineBinaryKHR ) VULKAN_HPP_NOEXCEPT : m_pipelineBinaryKHR( pipelineBinaryKHR ) {}

#if ( VULKAN_HPP_TYPESAFE_CONVERSION == 1 )
    PipelineBinaryKHR & operator=( VkPipelineBinaryKHR pipelineBinaryKHR ) VULKAN_HPP_NOEXCEPT
    {
      m_pipelineBinaryKHR = pipelineBinaryKHR;
      return *this;
    }
#endif

    PipelineBinaryKHR & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_pipelineBinaryKHR = {};
      return *this;
    }

    VULKAN_HPP_TYPESAFE_EXPLICIT operator VkPipelineBinaryKHR() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipelineBinaryKHR;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipelineBinaryKHR != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_pipelineBinaryKHR == VK_NULL_HANDLE;
    }

  private:
    VkPipelineBinaryKHR m_pipelineBinaryKHR = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::ePipelineBinaryKHR>
  {
    using Type = PipelineBinaryKHR;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkPipelineBinaryKHR, VK_NULL_HANDLE>
  {
    using Type = PipelineBinaryKHR;
  };
#endif

  template <>
  struct isVulkanHandleType<PipelineBinaryKHR>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkQueue, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkQueue.html
  class Queue
  {
  public:
    using CType      = VkQueue;
    using NativeType = VkQueue;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eQueue;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eQueue;

  public:
    Queue() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    Queue( Queue const & rhs )             = default;
    Queue & operator=( Queue const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    Queue( Queue && rhs )             = default;
    Queue & operator=( Queue && rhs ) = default;
#else
    Queue( Queue && rhs ) VULKAN_HPP_NOEXCEPT : m_queue( exchange( rhs.m_queue, {} ) ) {}

    Queue & operator=( Queue && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_queue = exchange( rhs.m_queue, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR Queue( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    Queue( VkQueue queue ) VULKAN_HPP_NOEXCEPT : m_queue( queue ) {}

    Queue & operator=( VkQueue queue ) VULKAN_HPP_NOEXCEPT
    {
      m_queue = queue;
      return *this;
    }

    Queue & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_queue = {};
      return *this;
    }

    //=== VK_VERSION_1_0 ===

    // wrapper function for command vkQueueSubmit, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSubmit.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueSubmit ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result submit( uint32_t           submitCount,
                                        SubmitInfo const * pSubmits,
                                        Fence              fence,
                                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkQueueSubmit, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSubmit.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueSubmit ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type submit( ArrayProxy<SubmitInfo const> const & submits,
                                                                                         Fence fence        VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                                                                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkQueueWaitIdle, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueWaitIdle.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueWaitIdle ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result waitIdle( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkQueueWaitIdle, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueWaitIdle.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueWaitIdle ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type waitIdle( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    // wrapper function for command vkQueueBindSparse, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueBindSparse.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueBindSparse ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result bindSparse( uint32_t               bindInfoCount,
                                            BindSparseInfo const * pBindInfo,
                                            Fence                  fence,
                                            Dispatch const & d     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkQueueBindSparse, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueBindSparse.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueBindSparse ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      bindSparse( ArrayProxy<BindSparseInfo const> const & bindInfo,
                  Fence fence                              VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                  Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_VERSION_1_3 ===

    // wrapper function for command vkQueueSubmit2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSubmit2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueSubmit2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result submit2( uint32_t            submitCount,
                                         SubmitInfo2 const * pSubmits,
                                         Fence               fence,
                                         Dispatch const & d  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkQueueSubmit2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSubmit2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueSubmit2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type submit2( ArrayProxy<SubmitInfo2 const> const & submits,
                                                                                          Fence fence        VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                                                                          Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_swapchain ===

    // wrapper function for command vkQueuePresentKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueuePresentKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueuePresentKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result presentKHR( PresentInfoKHR const * pPresentInfo,
                                            Dispatch const & d     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkQueuePresentKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueuePresentKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueuePresentKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result presentKHR( PresentInfoKHR const & presentInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_debug_utils ===

    // wrapper function for command vkQueueBeginDebugUtilsLabelEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueBeginDebugUtilsLabelEXT.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkQueueBeginDebugUtilsLabelEXT ), bool>::type = true>
    void beginDebugUtilsLabelEXT( DebugUtilsLabelEXT const * pLabelInfo,
                                  Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkQueueBeginDebugUtilsLabelEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueBeginDebugUtilsLabelEXT.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkQueueBeginDebugUtilsLabelEXT ), bool>::type = true>
    void beginDebugUtilsLabelEXT( DebugUtilsLabelEXT const & labelInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkQueueEndDebugUtilsLabelEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueEndDebugUtilsLabelEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueEndDebugUtilsLabelEXT ), bool>::type = true>
    void endDebugUtilsLabelEXT( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkQueueInsertDebugUtilsLabelEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueInsertDebugUtilsLabelEXT.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkQueueInsertDebugUtilsLabelEXT ), bool>::type = true>
    void insertDebugUtilsLabelEXT( DebugUtilsLabelEXT const * pLabelInfo,
                                   Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkQueueInsertDebugUtilsLabelEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueInsertDebugUtilsLabelEXT.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkQueueInsertDebugUtilsLabelEXT ), bool>::type = true>
    void insertDebugUtilsLabelEXT( DebugUtilsLabelEXT const & labelInfo,
                                   Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_NV_device_diagnostic_checkpoints ===

    // wrapper function for command vkGetQueueCheckpointDataNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueueCheckpointDataNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetQueueCheckpointDataNV ), bool>::type = true>
    void getCheckpointDataNV( uint32_t *         pCheckpointDataCount,
                              CheckpointDataNV * pCheckpointData,
                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetQueueCheckpointDataNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueueCheckpointDataNV.html
    template <typename CheckpointDataNVAllocator = std::allocator<CheckpointDataNV>,
              typename Dispatch                  = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename CheckpointDataNVAllocator::value_type, CheckpointDataNV>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetQueueCheckpointDataNV ), bool>::type                                          = true>
    VULKAN_HPP_NODISCARD std::vector<CheckpointDataNV, CheckpointDataNVAllocator>
                         getCheckpointDataNV( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetQueueCheckpointDataNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueueCheckpointDataNV.html
    template <typename CheckpointDataNVAllocator = std::allocator<CheckpointDataNV>,
              typename Dispatch                  = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename CheckpointDataNVAllocator::value_type, CheckpointDataNV>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetQueueCheckpointDataNV ), bool>::type                                          = true>
    VULKAN_HPP_NODISCARD std::vector<CheckpointDataNV, CheckpointDataNVAllocator>
      getCheckpointDataNV( CheckpointDataNVAllocator const & checkpointDataNVAllocator, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetQueueCheckpointData2NV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueueCheckpointData2NV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetQueueCheckpointData2NV ), bool>::type = true>
    void getCheckpointData2NV( uint32_t *          pCheckpointDataCount,
                               CheckpointData2NV * pCheckpointData,
                               Dispatch const & d  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetQueueCheckpointData2NV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueueCheckpointData2NV.html
    template <typename CheckpointData2NVAllocator = std::allocator<CheckpointData2NV>,
              typename Dispatch                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename CheckpointData2NVAllocator::value_type, CheckpointData2NV>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetQueueCheckpointData2NV ), bool>::type                                           = true>
    VULKAN_HPP_NODISCARD std::vector<CheckpointData2NV, CheckpointData2NVAllocator>
                         getCheckpointData2NV( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetQueueCheckpointData2NV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueueCheckpointData2NV.html
    template <typename CheckpointData2NVAllocator = std::allocator<CheckpointData2NV>,
              typename Dispatch                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename CheckpointData2NVAllocator::value_type, CheckpointData2NV>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetQueueCheckpointData2NV ), bool>::type                                           = true>
    VULKAN_HPP_NODISCARD std::vector<CheckpointData2NV, CheckpointData2NVAllocator>
      getCheckpointData2NV( CheckpointData2NVAllocator const & checkpointData2NVAllocator, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_INTEL_performance_query ===

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkQueueSetPerformanceConfigurationINTEL, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSetPerformanceConfigurationINTEL.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkQueueSetPerformanceConfigurationINTEL ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result setPerformanceConfigurationINTEL( PerformanceConfigurationINTEL configuration,
                                                                  Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkQueueSetPerformanceConfigurationINTEL, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSetPerformanceConfigurationINTEL.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkQueueSetPerformanceConfigurationINTEL ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      setPerformanceConfigurationINTEL( PerformanceConfigurationINTEL configuration, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    //=== VK_KHR_synchronization2 ===

    // wrapper function for command vkQueueSubmit2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSubmit2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueSubmit2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result submit2KHR( uint32_t            submitCount,
                                            SubmitInfo2 const * pSubmits,
                                            Fence               fence,
                                            Dispatch const & d  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkQueueSubmit2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSubmit2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueSubmit2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      submit2KHR( ArrayProxy<SubmitInfo2 const> const & submits,
                  Fence fence                           VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                  Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_NV_low_latency2 ===

    // wrapper function for command vkQueueNotifyOutOfBandNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueNotifyOutOfBandNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueNotifyOutOfBandNV ), bool>::type = true>
    void notifyOutOfBandNV( OutOfBandQueueTypeInfoNV const * pQueueTypeInfo,
                            Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkQueueNotifyOutOfBandNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueNotifyOutOfBandNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkQueueNotifyOutOfBandNV ), bool>::type = true>
    void notifyOutOfBandNV( OutOfBandQueueTypeInfoNV const & queueTypeInfo,
                            Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    operator VkQueue() const VULKAN_HPP_NOEXCEPT
    {
      return m_queue;
    }

    explicit operator bool() const VULKAN_HPP_NOEXCEPT
    {
      return m_queue != VK_NULL_HANDLE;
    }

    bool operator!() const VULKAN_HPP_NOEXCEPT
    {
      return m_queue == VK_NULL_HANDLE;
    }

  private:
    VkQueue m_queue = {};
  };

  template <>
  struct CppType<ObjectType, ObjectType::eQueue>
  {
    using Type = Queue;
  };

  template <>
  struct CppType<DebugReportObjectTypeEXT, DebugReportObjectTypeEXT::eQueue>
  {
    using Type = Queue;
  };

#if ( VK_USE_64_BIT_PTR_DEFINES == 1 )
  template <>
  struct CppType<VkQueue, VK_NULL_HANDLE>
  {
    using Type = Queue;
  };
#endif

  template <>
  struct isVulkanHandleType<Queue>
  {
    static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
  };

  // wrapper class for handle VkDevice, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDevice.html
  class Device
  {
  public:
    using CType      = VkDevice;
    using NativeType = VkDevice;

    static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDevice;
    static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDevice;

  public:
    Device() VULKAN_HPP_NOEXCEPT {}  // = default; - try to workaround a compiler issue

    Device( Device const & rhs )             = default;
    Device & operator=( Device const & rhs ) = default;

#if !defined( VULKAN_HPP_HANDLES_MOVE_EXCHANGE )
    Device( Device && rhs )             = default;
    Device & operator=( Device && rhs ) = default;
#else
    Device( Device && rhs ) VULKAN_HPP_NOEXCEPT : m_device( exchange( rhs.m_device, {} ) ) {}

    Device & operator=( Device && rhs ) VULKAN_HPP_NOEXCEPT
    {
      m_device = exchange( rhs.m_device, {} );
      return *this;
    }
#endif

    VULKAN_HPP_CONSTEXPR Device( std::nullptr_t ) VULKAN_HPP_NOEXCEPT {}

    Device( VkDevice device ) VULKAN_HPP_NOEXCEPT : m_device( device ) {}

    Device & operator=( VkDevice device ) VULKAN_HPP_NOEXCEPT
    {
      m_device = device;
      return *this;
    }

    Device & operator=( std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      m_device = {};
      return *this;
    }

    //=== VK_VERSION_1_0 ===

    // wrapper function for command vkGetDeviceProcAddr, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceProcAddr.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetDeviceProcAddr ), bool>::type = true>
    PFN_vkVoidFunction getProcAddr( char const * pName, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceProcAddr, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceProcAddr.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetDeviceProcAddr ), bool>::type = true>
    PFN_VoidFunction getProcAddr( std::string const & name, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyDevice, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDevice.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyDevice ), bool>::type = true>
    void destroy( AllocationCallbacks const * pAllocator, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyDevice, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDevice.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyDevice ), bool>::type = true>
    void destroy( Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceQueue, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceQueue.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetDeviceQueue ), bool>::type = true>
    void getQueue( uint32_t           queueFamilyIndex,
                   uint32_t           queueIndex,
                   Queue *            pQueue,
                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceQueue, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceQueue.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetDeviceQueue ), bool>::type = true>
    VULKAN_HPP_NODISCARD Queue getQueue( uint32_t           queueFamilyIndex,
                                         uint32_t           queueIndex,
                                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDeviceWaitIdle, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDeviceWaitIdle.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDeviceWaitIdle ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result waitIdle( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkDeviceWaitIdle, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDeviceWaitIdle.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDeviceWaitIdle ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type waitIdle( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    // wrapper function for command vkAllocateMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkAllocateMemory ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result allocateMemory( MemoryAllocateInfo const *  pAllocateInfo,
                                                AllocationCallbacks const * pAllocator,
                                                DeviceMemory *              pMemory,
                                                Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkAllocateMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkAllocateMemory ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<DeviceMemory>::type
      allocateMemory( MemoryAllocateInfo const &                    allocateInfo,
                      Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                      Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkAllocateMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkAllocateMemory ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<DeviceMemory, Dispatch>>::type
      allocateMemoryUnique( MemoryAllocateInfo const &                    allocateInfo,
                            Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                            Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkFreeMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeMemory ), bool>::type = true>
    void freeMemory( DeviceMemory                memory,
                     AllocationCallbacks const * pAllocator,
                     Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkFreeMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeMemory ), bool>::type = true>
    void freeMemory( DeviceMemory memory                           VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                     Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                     Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkFreeMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeMemory ), bool>::type = true>
    void( free )( DeviceMemory                memory,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkFreeMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeMemory ), bool>::type = true>
    void( free )( DeviceMemory                                  memory,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkMapMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMapMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkMapMemory ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result mapMemory( DeviceMemory       memory,
                                           DeviceSize         offset,
                                           DeviceSize         size,
                                           MemoryMapFlags     flags,
                                           void **            ppData,
                                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkMapMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMapMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkMapMemory ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<void *>::type mapMemory( DeviceMemory         memory,
                                                                           DeviceSize           offset,
                                                                           DeviceSize           size,
                                                                           MemoryMapFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                                                           Dispatch const & d   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkUnmapMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkUnmapMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkUnmapMemory ), bool>::type = true>
    void unmapMemory( DeviceMemory memory, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkFlushMappedMemoryRanges, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFlushMappedMemoryRanges.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFlushMappedMemoryRanges ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result flushMappedMemoryRanges( uint32_t                  memoryRangeCount,
                                                         MappedMemoryRange const * pMemoryRanges,
                                                         Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkFlushMappedMemoryRanges, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFlushMappedMemoryRanges.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFlushMappedMemoryRanges ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      flushMappedMemoryRanges( ArrayProxy<MappedMemoryRange const> const & memoryRanges, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkInvalidateMappedMemoryRanges, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkInvalidateMappedMemoryRanges.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkInvalidateMappedMemoryRanges ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result invalidateMappedMemoryRanges( uint32_t                  memoryRangeCount,
                                                              MappedMemoryRange const * pMemoryRanges,
                                                              Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkInvalidateMappedMemoryRanges, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkInvalidateMappedMemoryRanges.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkInvalidateMappedMemoryRanges ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      invalidateMappedMemoryRanges( ArrayProxy<MappedMemoryRange const> const & memoryRanges,
                                    Dispatch const & d                          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceMemoryCommitment, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceMemoryCommitment.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetDeviceMemoryCommitment ), bool>::type = true>
    void getMemoryCommitment( DeviceMemory       memory,
                              DeviceSize *       pCommittedMemoryInBytes,
                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceMemoryCommitment, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceMemoryCommitment.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetDeviceMemoryCommitment ), bool>::type = true>
    VULKAN_HPP_NODISCARD DeviceSize getMemoryCommitment( DeviceMemory       memory,
                                                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkBindBufferMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindBufferMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBindBufferMemory ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result bindBufferMemory( Buffer             buffer,
                                                  DeviceMemory       memory,
                                                  DeviceSize         memoryOffset,
                                                  Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkBindBufferMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindBufferMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBindBufferMemory ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      bindBufferMemory( Buffer buffer, DeviceMemory memory, DeviceSize memoryOffset, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkBindImageMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindImageMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBindImageMemory ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result bindImageMemory( Image              image,
                                                 DeviceMemory       memory,
                                                 DeviceSize         memoryOffset,
                                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkBindImageMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindImageMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBindImageMemory ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      bindImageMemory( Image image, DeviceMemory memory, DeviceSize memoryOffset, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    // wrapper function for command vkGetBufferMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetBufferMemoryRequirements ), bool>::type = true>
    void getBufferMemoryRequirements( Buffer               buffer,
                                      MemoryRequirements * pMemoryRequirements,
                                      Dispatch const & d   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetBufferMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetBufferMemoryRequirements ), bool>::type = true>
    VULKAN_HPP_NODISCARD MemoryRequirements
      getBufferMemoryRequirements( Buffer buffer, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetImageMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageMemoryRequirements ), bool>::type = true>
    void getImageMemoryRequirements( Image                image,
                                     MemoryRequirements * pMemoryRequirements,
                                     Dispatch const & d   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetImageMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageMemoryRequirements ), bool>::type = true>
    VULKAN_HPP_NODISCARD MemoryRequirements getImageMemoryRequirements( Image              image,
                                                                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetImageSparseMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetImageSparseMemoryRequirements ), bool>::type = true>
    void getImageSparseMemoryRequirements( Image                           image,
                                           uint32_t *                      pSparseMemoryRequirementCount,
                                           SparseImageMemoryRequirements * pSparseMemoryRequirements,
                                           Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetImageSparseMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements.html
    template <
      typename SparseImageMemoryRequirementsAllocator = std::allocator<SparseImageMemoryRequirements>,
      typename Dispatch                               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
      typename std::enable_if<std::is_same<typename SparseImageMemoryRequirementsAllocator::value_type, SparseImageMemoryRequirements>::value, int>::type = 0,
      typename std::enable_if<IS_DISPATCHED( vkGetImageSparseMemoryRequirements ), bool>::type = true>
    VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements, SparseImageMemoryRequirementsAllocator>
                         getImageSparseMemoryRequirements( Image image, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetImageSparseMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements.html
    template <
      typename SparseImageMemoryRequirementsAllocator = std::allocator<SparseImageMemoryRequirements>,
      typename Dispatch                               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
      typename std::enable_if<std::is_same<typename SparseImageMemoryRequirementsAllocator::value_type, SparseImageMemoryRequirements>::value, int>::type = 0,
      typename std::enable_if<IS_DISPATCHED( vkGetImageSparseMemoryRequirements ), bool>::type = true>
    VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements, SparseImageMemoryRequirementsAllocator>
                         getImageSparseMemoryRequirements( Image                                          image,
                                                           SparseImageMemoryRequirementsAllocator const & sparseImageMemoryRequirementsAllocator,
                                                           Dispatch const & d                             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateFence, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateFence.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateFence ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createFence( FenceCreateInfo const *     pCreateInfo,
                                             AllocationCallbacks const * pAllocator,
                                             Fence *                     pFence,
                                             Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateFence, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateFence.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateFence ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<Fence>::type
      createFence( FenceCreateInfo const &                       createInfo,
                   Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                   Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateFence, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateFence.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateFence ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<Fence, Dispatch>>::type
      createFenceUnique( FenceCreateInfo const &                       createInfo,
                         Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                         Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyFence, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyFence.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyFence ), bool>::type = true>
    void destroyFence( Fence                       fence,
                       AllocationCallbacks const * pAllocator,
                       Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyFence, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyFence.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyFence ), bool>::type = true>
    void destroyFence( Fence fence                                   VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                       Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                       Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyFence, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyFence.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyFence ), bool>::type = true>
    void destroy( Fence fence, AllocationCallbacks const * pAllocator, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyFence, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyFence.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyFence ), bool>::type = true>
    void destroy( Fence                                         fence,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkResetFences, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetFences.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkResetFences ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result resetFences( uint32_t           fenceCount,
                                             Fence const *      pFences,
                                             Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkResetFences, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetFences.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkResetFences ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      resetFences( ArrayProxy<Fence const> const & fences, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetFenceStatus, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetFenceStatus.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetFenceStatus ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getFenceStatus( Fence fence, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkGetFenceStatus, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetFenceStatus.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetFenceStatus ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getFenceStatus( Fence fence, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    // wrapper function for command vkWaitForFences, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkWaitForFences.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkWaitForFences ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result waitForFences( uint32_t           fenceCount,
                                               Fence const *      pFences,
                                               Bool32             waitAll,
                                               uint64_t           timeout,
                                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkWaitForFences, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkWaitForFences.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkWaitForFences ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result waitForFences( ArrayProxy<Fence const> const & fences,
                                               Bool32                          waitAll,
                                               uint64_t                        timeout,
                                               Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateSemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSemaphore.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSemaphore ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createSemaphore( SemaphoreCreateInfo const * pCreateInfo,
                                                 AllocationCallbacks const * pAllocator,
                                                 Semaphore *                 pSemaphore,
                                                 Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateSemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSemaphore.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSemaphore ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<Semaphore>::type
      createSemaphore( SemaphoreCreateInfo const &                   createInfo,
                       Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                       Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateSemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSemaphore.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSemaphore ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<Semaphore, Dispatch>>::type
      createSemaphoreUnique( SemaphoreCreateInfo const &                   createInfo,
                             Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                             Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroySemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySemaphore.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySemaphore ), bool>::type = true>
    void destroySemaphore( Semaphore                   semaphore,
                           AllocationCallbacks const * pAllocator,
                           Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroySemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySemaphore.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySemaphore ), bool>::type = true>
    void destroySemaphore( Semaphore semaphore                           VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                           Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                           Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroySemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySemaphore.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySemaphore ), bool>::type = true>
    void destroy( Semaphore                   semaphore,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroySemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySemaphore.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySemaphore ), bool>::type = true>
    void destroy( Semaphore                                     semaphore,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateQueryPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateQueryPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createQueryPool( QueryPoolCreateInfo const * pCreateInfo,
                                                 AllocationCallbacks const * pAllocator,
                                                 QueryPool *                 pQueryPool,
                                                 Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateQueryPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateQueryPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<QueryPool>::type
      createQueryPool( QueryPoolCreateInfo const &                   createInfo,
                       Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                       Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateQueryPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateQueryPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<QueryPool, Dispatch>>::type
      createQueryPoolUnique( QueryPoolCreateInfo const &                   createInfo,
                             Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                             Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyQueryPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyQueryPool ), bool>::type = true>
    void destroyQueryPool( QueryPool                   queryPool,
                           AllocationCallbacks const * pAllocator,
                           Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyQueryPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyQueryPool ), bool>::type = true>
    void destroyQueryPool( QueryPool queryPool                           VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                           Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                           Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyQueryPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyQueryPool ), bool>::type = true>
    void destroy( QueryPool                   queryPool,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyQueryPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyQueryPool ), bool>::type = true>
    void destroy( QueryPool                                     queryPool,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetQueryPoolResults, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueryPoolResults.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetQueryPoolResults ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getQueryPoolResults( QueryPool          queryPool,
                                                     uint32_t           firstQuery,
                                                     uint32_t           queryCount,
                                                     size_t             dataSize,
                                                     void *             pData,
                                                     DeviceSize         stride,
                                                     QueryResultFlags   flags,
                                                     Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetQueryPoolResults, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueryPoolResults.html
    template <typename DataType,
              typename DataTypeAllocator                                                                                = std::allocator<DataType>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename DataTypeAllocator::value_type, DataType>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetQueryPoolResults ), bool>::type                               = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<DataType, DataTypeAllocator>>
                         getQueryPoolResults( QueryPool              queryPool,
                                              uint32_t               firstQuery,
                                              uint32_t               queryCount,
                                              size_t                 dataSize,
                                              DeviceSize             stride,
                                              QueryResultFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                              Dispatch const & d     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetQueryPoolResults, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueryPoolResults.html
    template <typename DataType,
              typename Dispatch                                                           = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetQueryPoolResults ), bool>::type = true>
    VULKAN_HPP_NODISCARD ResultValue<DataType> getQueryPoolResult( QueryPool              queryPool,
                                                                   uint32_t               firstQuery,
                                                                   uint32_t               queryCount,
                                                                   DeviceSize             stride,
                                                                   QueryResultFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                                                   Dispatch const & d     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateBuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createBuffer( BufferCreateInfo const *    pCreateInfo,
                                              AllocationCallbacks const * pAllocator,
                                              Buffer *                    pBuffer,
                                              Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateBuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<Buffer>::type
      createBuffer( BufferCreateInfo const &                      createInfo,
                    Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                    Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateBuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<Buffer, Dispatch>>::type
      createBufferUnique( BufferCreateInfo const &                      createInfo,
                          Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                          Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyBuffer ), bool>::type = true>
    void destroyBuffer( Buffer                      buffer,
                        AllocationCallbacks const * pAllocator,
                        Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyBuffer ), bool>::type = true>
    void destroyBuffer( Buffer buffer                                 VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                        Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                        Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyBuffer ), bool>::type = true>
    void
      destroy( Buffer buffer, AllocationCallbacks const * pAllocator, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyBuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyBuffer ), bool>::type = true>
    void destroy( Buffer                                        buffer,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateImage ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createImage( ImageCreateInfo const *     pCreateInfo,
                                             AllocationCallbacks const * pAllocator,
                                             Image *                     pImage,
                                             Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateImage ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<Image>::type
      createImage( ImageCreateInfo const &                       createInfo,
                   Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                   Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateImage ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<Image, Dispatch>>::type
      createImageUnique( ImageCreateInfo const &                       createInfo,
                         Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                         Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyImage ), bool>::type = true>
    void destroyImage( Image                       image,
                       AllocationCallbacks const * pAllocator,
                       Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyImage ), bool>::type = true>
    void destroyImage( Image image                                   VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                       Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                       Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyImage ), bool>::type = true>
    void destroy( Image image, AllocationCallbacks const * pAllocator, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyImage ), bool>::type = true>
    void destroy( Image                                         image,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetImageSubresourceLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageSubresourceLayout ), bool>::type = true>
    void getImageSubresourceLayout( Image                    image,
                                    ImageSubresource const * pSubresource,
                                    SubresourceLayout *      pLayout,
                                    Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetImageSubresourceLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageSubresourceLayout ), bool>::type = true>
    VULKAN_HPP_NODISCARD SubresourceLayout getImageSubresourceLayout( Image                    image,
                                                                      ImageSubresource const & subresource,
                                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateImageView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateImageView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateImageView ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createImageView( ImageViewCreateInfo const * pCreateInfo,
                                                 AllocationCallbacks const * pAllocator,
                                                 ImageView *                 pView,
                                                 Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateImageView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateImageView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateImageView ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<ImageView>::type
      createImageView( ImageViewCreateInfo const &                   createInfo,
                       Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                       Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateImageView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateImageView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateImageView ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<ImageView, Dispatch>>::type
      createImageViewUnique( ImageViewCreateInfo const &                   createInfo,
                             Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                             Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyImageView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyImageView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyImageView ), bool>::type = true>
    void destroyImageView( ImageView                   imageView,
                           AllocationCallbacks const * pAllocator,
                           Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyImageView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyImageView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyImageView ), bool>::type = true>
    void destroyImageView( ImageView imageView                           VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                           Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                           Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyImageView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyImageView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyImageView ), bool>::type = true>
    void destroy( ImageView                   imageView,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyImageView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyImageView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyImageView ), bool>::type = true>
    void destroy( ImageView                                     imageView,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCommandPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateCommandPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createCommandPool( CommandPoolCreateInfo const * pCreateInfo,
                                                   AllocationCallbacks const *   pAllocator,
                                                   CommandPool *                 pCommandPool,
                                                   Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCommandPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateCommandPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<CommandPool>::type
      createCommandPool( CommandPoolCreateInfo const &                 createInfo,
                         Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                         Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCommandPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateCommandPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<CommandPool, Dispatch>>::type
      createCommandPoolUnique( CommandPoolCreateInfo const &                 createInfo,
                               Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                               Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCommandPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCommandPool ), bool>::type = true>
    void destroyCommandPool( CommandPool                 commandPool,
                             AllocationCallbacks const * pAllocator,
                             Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCommandPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCommandPool ), bool>::type = true>
    void destroyCommandPool( CommandPool commandPool                       VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                             Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                             Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCommandPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCommandPool ), bool>::type = true>
    void destroy( CommandPool                 commandPool,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCommandPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCommandPool ), bool>::type = true>
    void destroy( CommandPool                                   commandPool,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkResetCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetCommandPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkResetCommandPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result resetCommandPool( CommandPool           commandPool,
                                                  CommandPoolResetFlags flags,
                                                  Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkResetCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetCommandPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkResetCommandPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      resetCommandPool( CommandPool                 commandPool,
                        CommandPoolResetFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                        Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    // wrapper function for command vkAllocateCommandBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateCommandBuffers.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkAllocateCommandBuffers ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result allocateCommandBuffers( CommandBufferAllocateInfo const * pAllocateInfo,
                                                        CommandBuffer *                   pCommandBuffers,
                                                        Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkAllocateCommandBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateCommandBuffers.html
    template <typename CommandBufferAllocator = std::allocator<CommandBuffer>,
              typename Dispatch               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename CommandBufferAllocator::value_type, CommandBuffer>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkAllocateCommandBuffers ), bool>::type                                      = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<CommandBuffer, CommandBufferAllocator>>::type
      allocateCommandBuffers( CommandBufferAllocateInfo const & allocateInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkAllocateCommandBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateCommandBuffers.html
    template <typename CommandBufferAllocator = std::allocator<CommandBuffer>,
              typename Dispatch               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename CommandBufferAllocator::value_type, CommandBuffer>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkAllocateCommandBuffers ), bool>::type                                      = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<CommandBuffer, CommandBufferAllocator>>::type
      allocateCommandBuffers( CommandBufferAllocateInfo const & allocateInfo,
                              CommandBufferAllocator const &    commandBufferAllocator,
                              Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkAllocateCommandBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateCommandBuffers.html
    template <typename Dispatch               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename CommandBufferAllocator = std::allocator<UniqueHandle<CommandBuffer, Dispatch>>,
              typename std::enable_if<std::is_same<typename CommandBufferAllocator::value_type, UniqueHandle<CommandBuffer, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkAllocateCommandBuffers ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<UniqueHandle<CommandBuffer, Dispatch>, CommandBufferAllocator>>::type
      allocateCommandBuffersUnique( CommandBufferAllocateInfo const & allocateInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkAllocateCommandBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateCommandBuffers.html
    template <typename Dispatch               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename CommandBufferAllocator = std::allocator<UniqueHandle<CommandBuffer, Dispatch>>,
              typename std::enable_if<std::is_same<typename CommandBufferAllocator::value_type, UniqueHandle<CommandBuffer, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkAllocateCommandBuffers ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<UniqueHandle<CommandBuffer, Dispatch>, CommandBufferAllocator>>::type
      allocateCommandBuffersUnique( CommandBufferAllocateInfo const & allocateInfo,
                                    CommandBufferAllocator const &    commandBufferAllocator,
                                    Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkFreeCommandBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeCommandBuffers.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeCommandBuffers ), bool>::type = true>
    void freeCommandBuffers( CommandPool           commandPool,
                             uint32_t              commandBufferCount,
                             CommandBuffer const * pCommandBuffers,
                             Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkFreeCommandBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeCommandBuffers.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeCommandBuffers ), bool>::type = true>
    void freeCommandBuffers( CommandPool                             commandPool,
                             ArrayProxy<CommandBuffer const> const & commandBuffers,
                             Dispatch const & d                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkFreeCommandBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeCommandBuffers.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeCommandBuffers ), bool>::type = true>
    void( free )( CommandPool           commandPool,
                  uint32_t              commandBufferCount,
                  CommandBuffer const * pCommandBuffers,
                  Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkFreeCommandBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeCommandBuffers.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeCommandBuffers ), bool>::type = true>
    void( free )( CommandPool                             commandPool,
                  ArrayProxy<CommandBuffer const> const & commandBuffers,
                  Dispatch const & d                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateEvent ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createEvent( EventCreateInfo const *     pCreateInfo,
                                             AllocationCallbacks const * pAllocator,
                                             Event *                     pEvent,
                                             Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateEvent ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<Event>::type
      createEvent( EventCreateInfo const &                       createInfo,
                   Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                   Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateEvent ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<Event, Dispatch>>::type
      createEventUnique( EventCreateInfo const &                       createInfo,
                         Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                         Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyEvent ), bool>::type = true>
    void destroyEvent( Event                       event,
                       AllocationCallbacks const * pAllocator,
                       Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyEvent ), bool>::type = true>
    void destroyEvent( Event event                                   VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                       Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                       Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyEvent ), bool>::type = true>
    void destroy( Event event, AllocationCallbacks const * pAllocator, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyEvent ), bool>::type = true>
    void destroy( Event                                         event,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetEventStatus, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetEventStatus.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetEventStatus ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getEventStatus( Event event, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkGetEventStatus, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetEventStatus.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetEventStatus ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getEventStatus( Event event, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkSetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSetEvent ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result setEvent( Event event, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkSetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSetEvent ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type setEvent( Event              event,
                                                                                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkResetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkResetEvent ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result resetEvent( Event event, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkResetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetEvent.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkResetEvent ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      resetEvent( Event event, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    // wrapper function for command vkCreateBufferView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateBufferView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateBufferView ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createBufferView( BufferViewCreateInfo const * pCreateInfo,
                                                  AllocationCallbacks const *  pAllocator,
                                                  BufferView *                 pView,
                                                  Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateBufferView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateBufferView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateBufferView ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<BufferView>::type
      createBufferView( BufferViewCreateInfo const &                  createInfo,
                        Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                        Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateBufferView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateBufferView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateBufferView ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<BufferView, Dispatch>>::type
      createBufferViewUnique( BufferViewCreateInfo const &                  createInfo,
                              Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                              Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyBufferView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyBufferView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyBufferView ), bool>::type = true>
    void destroyBufferView( BufferView                  bufferView,
                            AllocationCallbacks const * pAllocator,
                            Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyBufferView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyBufferView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyBufferView ), bool>::type = true>
    void destroyBufferView( BufferView bufferView                         VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                            Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                            Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyBufferView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyBufferView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyBufferView ), bool>::type = true>
    void destroy( BufferView                  bufferView,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyBufferView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyBufferView.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyBufferView ), bool>::type = true>
    void destroy( BufferView                                    bufferView,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateShaderModule, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateShaderModule.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateShaderModule ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createShaderModule( ShaderModuleCreateInfo const * pCreateInfo,
                                                    AllocationCallbacks const *    pAllocator,
                                                    ShaderModule *                 pShaderModule,
                                                    Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateShaderModule, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateShaderModule.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateShaderModule ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<ShaderModule>::type
      createShaderModule( ShaderModuleCreateInfo const &                createInfo,
                          Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                          Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateShaderModule, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateShaderModule.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateShaderModule ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<ShaderModule, Dispatch>>::type
      createShaderModuleUnique( ShaderModuleCreateInfo const &                createInfo,
                                Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyShaderModule, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyShaderModule.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyShaderModule ), bool>::type = true>
    void destroyShaderModule( ShaderModule                shaderModule,
                              AllocationCallbacks const * pAllocator,
                              Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyShaderModule, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyShaderModule.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyShaderModule ), bool>::type = true>
    void destroyShaderModule( ShaderModule shaderModule                     VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                              Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                              Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyShaderModule, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyShaderModule.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyShaderModule ), bool>::type = true>
    void destroy( ShaderModule                shaderModule,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyShaderModule, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyShaderModule.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyShaderModule ), bool>::type = true>
    void destroy( ShaderModule                                  shaderModule,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreatePipelineCache, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePipelineCache.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreatePipelineCache ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createPipelineCache( PipelineCacheCreateInfo const * pCreateInfo,
                                                     AllocationCallbacks const *     pAllocator,
                                                     PipelineCache *                 pPipelineCache,
                                                     Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreatePipelineCache, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePipelineCache.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreatePipelineCache ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<PipelineCache>::type
      createPipelineCache( PipelineCacheCreateInfo const &               createInfo,
                           Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                           Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreatePipelineCache, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePipelineCache.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreatePipelineCache ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<PipelineCache, Dispatch>>::type
      createPipelineCacheUnique( PipelineCacheCreateInfo const &               createInfo,
                                 Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                 Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyPipelineCache, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipelineCache.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipelineCache ), bool>::type = true>
    void destroyPipelineCache( PipelineCache               pipelineCache,
                               AllocationCallbacks const * pAllocator,
                               Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyPipelineCache, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipelineCache.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipelineCache ), bool>::type = true>
    void destroyPipelineCache( PipelineCache pipelineCache                   VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                               Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                               Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyPipelineCache, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipelineCache.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipelineCache ), bool>::type = true>
    void destroy( PipelineCache               pipelineCache,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyPipelineCache, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipelineCache.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipelineCache ), bool>::type = true>
    void destroy( PipelineCache                                 pipelineCache,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetPipelineCacheData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineCacheData.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetPipelineCacheData ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getPipelineCacheData( PipelineCache      pipelineCache,
                                                      size_t *           pDataSize,
                                                      void *             pData,
                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetPipelineCacheData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineCacheData.html
    template <typename Uint8_tAllocator                                                                               = std::allocator<uint8_t>,
              typename Dispatch                                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename Uint8_tAllocator::value_type, uint8_t>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetPipelineCacheData ), bool>::type                            = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<uint8_t, Uint8_tAllocator>>::type
      getPipelineCacheData( PipelineCache pipelineCache, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetPipelineCacheData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineCacheData.html
    template <typename Uint8_tAllocator                                                                               = std::allocator<uint8_t>,
              typename Dispatch                                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename Uint8_tAllocator::value_type, uint8_t>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetPipelineCacheData ), bool>::type                            = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<uint8_t, Uint8_tAllocator>>::type getPipelineCacheData(
      PipelineCache pipelineCache, Uint8_tAllocator const & uint8_tAllocator, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkMergePipelineCaches, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMergePipelineCaches.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkMergePipelineCaches ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result mergePipelineCaches( PipelineCache         dstCache,
                                                     uint32_t              srcCacheCount,
                                                     PipelineCache const * pSrcCaches,
                                                     Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkMergePipelineCaches, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMergePipelineCaches.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkMergePipelineCaches ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type mergePipelineCaches(
      PipelineCache dstCache, ArrayProxy<PipelineCache const> const & srcCaches, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateComputePipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateComputePipelines.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateComputePipelines ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createComputePipelines( PipelineCache                     pipelineCache,
                                                        uint32_t                          createInfoCount,
                                                        ComputePipelineCreateInfo const * pCreateInfos,
                                                        AllocationCallbacks const *       pAllocator,
                                                        Pipeline *                        pPipelines,
                                                        Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateComputePipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateComputePipelines.html
    template <typename PipelineAllocator                                                                                = std::allocator<Pipeline>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, Pipeline>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateComputePipelines ), bool>::type                            = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<Pipeline, PipelineAllocator>>
                         createComputePipelines( PipelineCache                                       pipelineCache,
                                                 ArrayProxy<ComputePipelineCreateInfo const> const & createInfos,
                                                 Optional<AllocationCallbacks const> allocator       VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                 Dispatch const & d                                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateComputePipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateComputePipelines.html
    template <typename PipelineAllocator                                                                                = std::allocator<Pipeline>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, Pipeline>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateComputePipelines ), bool>::type                            = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<Pipeline, PipelineAllocator>>
                         createComputePipelines( PipelineCache                                       pipelineCache,
                                                 ArrayProxy<ComputePipelineCreateInfo const> const & createInfos,
                                                 Optional<AllocationCallbacks const>                 allocator,
                                                 PipelineAllocator const &                           pipelineAllocator,
                                                 Dispatch const & d                                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateComputePipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateComputePipelines.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateComputePipelines ), bool>::type = true>
    VULKAN_HPP_NODISCARD ResultValue<Pipeline> createComputePipeline( PipelineCache                                 pipelineCache,
                                                                      ComputePipelineCreateInfo const &             createInfo,
                                                                      Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateComputePipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateComputePipelines.html
    template <typename Dispatch          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename PipelineAllocator = std::allocator<UniqueHandle<Pipeline, Dispatch>>,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, UniqueHandle<Pipeline, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateComputePipelines ), bool>::type                                                    = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<UniqueHandle<Pipeline, Dispatch>, PipelineAllocator>>
                         createComputePipelinesUnique( PipelineCache                                       pipelineCache,
                                                       ArrayProxy<ComputePipelineCreateInfo const> const & createInfos,
                                                       Optional<AllocationCallbacks const> allocator       VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                       Dispatch const & d                                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateComputePipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateComputePipelines.html
    template <typename Dispatch          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename PipelineAllocator = std::allocator<UniqueHandle<Pipeline, Dispatch>>,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, UniqueHandle<Pipeline, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateComputePipelines ), bool>::type                                                    = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<UniqueHandle<Pipeline, Dispatch>, PipelineAllocator>>
                         createComputePipelinesUnique( PipelineCache                                       pipelineCache,
                                                       ArrayProxy<ComputePipelineCreateInfo const> const & createInfos,
                                                       Optional<AllocationCallbacks const>                 allocator,
                                                       PipelineAllocator const &                           pipelineAllocator,
                                                       Dispatch const & d                                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateComputePipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateComputePipelines.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateComputePipelines ), bool>::type = true>
    VULKAN_HPP_NODISCARD ResultValue<UniqueHandle<Pipeline, Dispatch>>
                         createComputePipelineUnique( PipelineCache                                 pipelineCache,
                                                      ComputePipelineCreateInfo const &             createInfo,
                                                      Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                      Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyPipeline, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipeline.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipeline ), bool>::type = true>
    void destroyPipeline( Pipeline                    pipeline,
                          AllocationCallbacks const * pAllocator,
                          Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyPipeline, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipeline.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipeline ), bool>::type = true>
    void destroyPipeline( Pipeline pipeline                             VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                          Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                          Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyPipeline, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipeline.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipeline ), bool>::type = true>
    void destroy( Pipeline                    pipeline,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyPipeline, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipeline.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipeline ), bool>::type = true>
    void destroy( Pipeline                                      pipeline,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreatePipelineLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePipelineLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreatePipelineLayout ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createPipelineLayout( PipelineLayoutCreateInfo const * pCreateInfo,
                                                      AllocationCallbacks const *      pAllocator,
                                                      PipelineLayout *                 pPipelineLayout,
                                                      Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreatePipelineLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePipelineLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreatePipelineLayout ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<PipelineLayout>::type
      createPipelineLayout( PipelineLayoutCreateInfo const &              createInfo,
                            Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                            Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreatePipelineLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePipelineLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreatePipelineLayout ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<PipelineLayout, Dispatch>>::type
      createPipelineLayoutUnique( PipelineLayoutCreateInfo const &              createInfo,
                                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyPipelineLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipelineLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipelineLayout ), bool>::type = true>
    void destroyPipelineLayout( PipelineLayout              pipelineLayout,
                                AllocationCallbacks const * pAllocator,
                                Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyPipelineLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipelineLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipelineLayout ), bool>::type = true>
    void destroyPipelineLayout( PipelineLayout pipelineLayout                 VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyPipelineLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipelineLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipelineLayout ), bool>::type = true>
    void destroy( PipelineLayout              pipelineLayout,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyPipelineLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPipelineLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPipelineLayout ), bool>::type = true>
    void destroy( PipelineLayout                                pipelineLayout,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateSampler, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSampler.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSampler ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createSampler( SamplerCreateInfo const *   pCreateInfo,
                                               AllocationCallbacks const * pAllocator,
                                               Sampler *                   pSampler,
                                               Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateSampler, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSampler.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSampler ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<Sampler>::type
      createSampler( SamplerCreateInfo const &                     createInfo,
                     Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                     Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateSampler, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSampler.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSampler ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<Sampler, Dispatch>>::type
      createSamplerUnique( SamplerCreateInfo const &                     createInfo,
                           Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                           Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroySampler, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySampler.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySampler ), bool>::type = true>
    void destroySampler( Sampler                     sampler,
                         AllocationCallbacks const * pAllocator,
                         Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroySampler, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySampler.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySampler ), bool>::type = true>
    void destroySampler( Sampler sampler                               VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                         Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                         Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroySampler, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySampler.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySampler ), bool>::type = true>
    void
      destroy( Sampler sampler, AllocationCallbacks const * pAllocator, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroySampler, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySampler.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySampler ), bool>::type = true>
    void destroy( Sampler                                       sampler,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateDescriptorSetLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorSetLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorSetLayout ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createDescriptorSetLayout( DescriptorSetLayoutCreateInfo const * pCreateInfo,
                                                           AllocationCallbacks const *           pAllocator,
                                                           DescriptorSetLayout *                 pSetLayout,
                                                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateDescriptorSetLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorSetLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorSetLayout ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<DescriptorSetLayout>::type
      createDescriptorSetLayout( DescriptorSetLayoutCreateInfo const &         createInfo,
                                 Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                 Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateDescriptorSetLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorSetLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorSetLayout ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<DescriptorSetLayout, Dispatch>>::type
      createDescriptorSetLayoutUnique( DescriptorSetLayoutCreateInfo const &         createInfo,
                                       Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                       Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyDescriptorSetLayout, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorSetLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorSetLayout ), bool>::type = true>
    void destroyDescriptorSetLayout( DescriptorSetLayout         descriptorSetLayout,
                                     AllocationCallbacks const * pAllocator,
                                     Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyDescriptorSetLayout, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorSetLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorSetLayout ), bool>::type = true>
    void destroyDescriptorSetLayout( DescriptorSetLayout descriptorSetLayout       VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                     Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                     Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyDescriptorSetLayout, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorSetLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorSetLayout ), bool>::type = true>
    void destroy( DescriptorSetLayout         descriptorSetLayout,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyDescriptorSetLayout, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorSetLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorSetLayout ), bool>::type = true>
    void destroy( DescriptorSetLayout                           descriptorSetLayout,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createDescriptorPool( DescriptorPoolCreateInfo const * pCreateInfo,
                                                      AllocationCallbacks const *      pAllocator,
                                                      DescriptorPool *                 pDescriptorPool,
                                                      Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<DescriptorPool>::type
      createDescriptorPool( DescriptorPoolCreateInfo const &              createInfo,
                            Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                            Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<DescriptorPool, Dispatch>>::type
      createDescriptorPoolUnique( DescriptorPoolCreateInfo const &              createInfo,
                                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorPool ), bool>::type = true>
    void destroyDescriptorPool( DescriptorPool              descriptorPool,
                                AllocationCallbacks const * pAllocator,
                                Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorPool ), bool>::type = true>
    void destroyDescriptorPool( DescriptorPool descriptorPool                 VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorPool ), bool>::type = true>
    void destroy( DescriptorPool              descriptorPool,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorPool ), bool>::type = true>
    void destroy( DescriptorPool                                descriptorPool,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkResetDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetDescriptorPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkResetDescriptorPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result resetDescriptorPool( DescriptorPool           descriptorPool,
                                                     DescriptorPoolResetFlags flags,
                                                     Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkResetDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetDescriptorPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkResetDescriptorPool ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      resetDescriptorPool( DescriptorPool                 descriptorPool,
                           DescriptorPoolResetFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                           Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    // wrapper function for command vkAllocateDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateDescriptorSets.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkAllocateDescriptorSets ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result allocateDescriptorSets( DescriptorSetAllocateInfo const * pAllocateInfo,
                                                        DescriptorSet *                   pDescriptorSets,
                                                        Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkAllocateDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateDescriptorSets.html
    template <typename DescriptorSetAllocator = std::allocator<DescriptorSet>,
              typename Dispatch               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename DescriptorSetAllocator::value_type, DescriptorSet>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkAllocateDescriptorSets ), bool>::type                                      = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DescriptorSet, DescriptorSetAllocator>>::type
      allocateDescriptorSets( DescriptorSetAllocateInfo const & allocateInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkAllocateDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateDescriptorSets.html
    template <typename DescriptorSetAllocator = std::allocator<DescriptorSet>,
              typename Dispatch               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename DescriptorSetAllocator::value_type, DescriptorSet>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkAllocateDescriptorSets ), bool>::type                                      = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DescriptorSet, DescriptorSetAllocator>>::type
      allocateDescriptorSets( DescriptorSetAllocateInfo const & allocateInfo,
                              DescriptorSetAllocator const &    descriptorSetAllocator,
                              Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkAllocateDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateDescriptorSets.html
    template <typename Dispatch               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename DescriptorSetAllocator = std::allocator<UniqueHandle<DescriptorSet, Dispatch>>,
              typename std::enable_if<std::is_same<typename DescriptorSetAllocator::value_type, UniqueHandle<DescriptorSet, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkAllocateDescriptorSets ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<UniqueHandle<DescriptorSet, Dispatch>, DescriptorSetAllocator>>::type
      allocateDescriptorSetsUnique( DescriptorSetAllocateInfo const & allocateInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkAllocateDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateDescriptorSets.html
    template <typename Dispatch               = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename DescriptorSetAllocator = std::allocator<UniqueHandle<DescriptorSet, Dispatch>>,
              typename std::enable_if<std::is_same<typename DescriptorSetAllocator::value_type, UniqueHandle<DescriptorSet, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkAllocateDescriptorSets ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<UniqueHandle<DescriptorSet, Dispatch>, DescriptorSetAllocator>>::type
      allocateDescriptorSetsUnique( DescriptorSetAllocateInfo const & allocateInfo,
                                    DescriptorSetAllocator const &    descriptorSetAllocator,
                                    Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkFreeDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeDescriptorSets.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeDescriptorSets ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result freeDescriptorSets( DescriptorPool        descriptorPool,
                                                    uint32_t              descriptorSetCount,
                                                    DescriptorSet const * pDescriptorSets,
                                                    Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkFreeDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeDescriptorSets.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeDescriptorSets ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      freeDescriptorSets( DescriptorPool                          descriptorPool,
                          ArrayProxy<DescriptorSet const> const & descriptorSets,
                          Dispatch const & d                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkFreeDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeDescriptorSets.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeDescriptorSets ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result( free )( DescriptorPool        descriptorPool,
                                         uint32_t              descriptorSetCount,
                                         DescriptorSet const * pDescriptorSets,
                                         Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkFreeDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFreeDescriptorSets.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkFreeDescriptorSets ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type( free )( DescriptorPool                          descriptorPool,
                                                                                          ArrayProxy<DescriptorSet const> const & descriptorSets,
                                                                                          Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkUpdateDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateDescriptorSets.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkUpdateDescriptorSets ), bool>::type = true>
    void updateDescriptorSets( uint32_t                   descriptorWriteCount,
                               WriteDescriptorSet const * pDescriptorWrites,
                               uint32_t                   descriptorCopyCount,
                               CopyDescriptorSet const *  pDescriptorCopies,
                               Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkUpdateDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateDescriptorSets.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkUpdateDescriptorSets ), bool>::type = true>
    void updateDescriptorSets( ArrayProxy<WriteDescriptorSet const> const & descriptorWrites,
                               ArrayProxy<CopyDescriptorSet const> const &  descriptorCopies,
                               Dispatch const & d                           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateGraphicsPipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateGraphicsPipelines.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateGraphicsPipelines ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createGraphicsPipelines( PipelineCache                      pipelineCache,
                                                         uint32_t                           createInfoCount,
                                                         GraphicsPipelineCreateInfo const * pCreateInfos,
                                                         AllocationCallbacks const *        pAllocator,
                                                         Pipeline *                         pPipelines,
                                                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateGraphicsPipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateGraphicsPipelines.html
    template <typename PipelineAllocator                                                                                = std::allocator<Pipeline>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, Pipeline>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateGraphicsPipelines ), bool>::type                           = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<Pipeline, PipelineAllocator>>
                         createGraphicsPipelines( PipelineCache                                        pipelineCache,
                                                  ArrayProxy<GraphicsPipelineCreateInfo const> const & createInfos,
                                                  Optional<AllocationCallbacks const> allocator        VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                  Dispatch const & d                                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateGraphicsPipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateGraphicsPipelines.html
    template <typename PipelineAllocator                                                                                = std::allocator<Pipeline>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, Pipeline>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateGraphicsPipelines ), bool>::type                           = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<Pipeline, PipelineAllocator>>
                         createGraphicsPipelines( PipelineCache                                        pipelineCache,
                                                  ArrayProxy<GraphicsPipelineCreateInfo const> const & createInfos,
                                                  Optional<AllocationCallbacks const>                  allocator,
                                                  PipelineAllocator const &                            pipelineAllocator,
                                                  Dispatch const & d                                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateGraphicsPipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateGraphicsPipelines.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateGraphicsPipelines ), bool>::type = true>
    VULKAN_HPP_NODISCARD ResultValue<Pipeline> createGraphicsPipeline( PipelineCache                                 pipelineCache,
                                                                       GraphicsPipelineCreateInfo const &            createInfo,
                                                                       Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateGraphicsPipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateGraphicsPipelines.html
    template <typename Dispatch          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename PipelineAllocator = std::allocator<UniqueHandle<Pipeline, Dispatch>>,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, UniqueHandle<Pipeline, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateGraphicsPipelines ), bool>::type                                                   = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<UniqueHandle<Pipeline, Dispatch>, PipelineAllocator>>
                         createGraphicsPipelinesUnique( PipelineCache                                        pipelineCache,
                                                        ArrayProxy<GraphicsPipelineCreateInfo const> const & createInfos,
                                                        Optional<AllocationCallbacks const> allocator        VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                        Dispatch const & d                                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateGraphicsPipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateGraphicsPipelines.html
    template <typename Dispatch          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename PipelineAllocator = std::allocator<UniqueHandle<Pipeline, Dispatch>>,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, UniqueHandle<Pipeline, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateGraphicsPipelines ), bool>::type                                                   = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<UniqueHandle<Pipeline, Dispatch>, PipelineAllocator>>
                         createGraphicsPipelinesUnique( PipelineCache                                        pipelineCache,
                                                        ArrayProxy<GraphicsPipelineCreateInfo const> const & createInfos,
                                                        Optional<AllocationCallbacks const>                  allocator,
                                                        PipelineAllocator const &                            pipelineAllocator,
                                                        Dispatch const & d                                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateGraphicsPipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateGraphicsPipelines.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateGraphicsPipelines ), bool>::type = true>
    VULKAN_HPP_NODISCARD ResultValue<UniqueHandle<Pipeline, Dispatch>>
                         createGraphicsPipelineUnique( PipelineCache                                 pipelineCache,
                                                       GraphicsPipelineCreateInfo const &            createInfo,
                                                       Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                       Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateFramebuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateFramebuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateFramebuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createFramebuffer( FramebufferCreateInfo const * pCreateInfo,
                                                   AllocationCallbacks const *   pAllocator,
                                                   Framebuffer *                 pFramebuffer,
                                                   Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateFramebuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateFramebuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateFramebuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<Framebuffer>::type
      createFramebuffer( FramebufferCreateInfo const &                 createInfo,
                         Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                         Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateFramebuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateFramebuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateFramebuffer ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<Framebuffer, Dispatch>>::type
      createFramebufferUnique( FramebufferCreateInfo const &                 createInfo,
                               Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                               Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyFramebuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyFramebuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyFramebuffer ), bool>::type = true>
    void destroyFramebuffer( Framebuffer                 framebuffer,
                             AllocationCallbacks const * pAllocator,
                             Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyFramebuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyFramebuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyFramebuffer ), bool>::type = true>
    void destroyFramebuffer( Framebuffer framebuffer                       VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                             Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                             Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyFramebuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyFramebuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyFramebuffer ), bool>::type = true>
    void destroy( Framebuffer                 framebuffer,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyFramebuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyFramebuffer.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyFramebuffer ), bool>::type = true>
    void destroy( Framebuffer                                   framebuffer,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateRenderPass ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createRenderPass( RenderPassCreateInfo const * pCreateInfo,
                                                  AllocationCallbacks const *  pAllocator,
                                                  RenderPass *                 pRenderPass,
                                                  Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateRenderPass ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<RenderPass>::type
      createRenderPass( RenderPassCreateInfo const &                  createInfo,
                        Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                        Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateRenderPass ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<RenderPass, Dispatch>>::type
      createRenderPassUnique( RenderPassCreateInfo const &                  createInfo,
                              Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                              Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyRenderPass.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyRenderPass ), bool>::type = true>
    void destroyRenderPass( RenderPass                  renderPass,
                            AllocationCallbacks const * pAllocator,
                            Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyRenderPass.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyRenderPass ), bool>::type = true>
    void destroyRenderPass( RenderPass renderPass                         VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                            Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                            Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyRenderPass.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyRenderPass ), bool>::type = true>
    void destroy( RenderPass                  renderPass,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyRenderPass.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyRenderPass ), bool>::type = true>
    void destroy( RenderPass                                    renderPass,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetRenderAreaGranularity, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRenderAreaGranularity.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetRenderAreaGranularity ), bool>::type = true>
    void getRenderAreaGranularity( RenderPass         renderPass,
                                   Extent2D *         pGranularity,
                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetRenderAreaGranularity, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRenderAreaGranularity.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetRenderAreaGranularity ), bool>::type = true>
    VULKAN_HPP_NODISCARD Extent2D getRenderAreaGranularity( RenderPass         renderPass,
                                                            Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_VERSION_1_1 ===

    // wrapper function for command vkBindBufferMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindBufferMemory2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBindBufferMemory2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result bindBufferMemory2( uint32_t                     bindInfoCount,
                                                   BindBufferMemoryInfo const * pBindInfos,
                                                   Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkBindBufferMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindBufferMemory2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBindBufferMemory2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      bindBufferMemory2( ArrayProxy<BindBufferMemoryInfo const> const & bindInfos, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkBindImageMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindImageMemory2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBindImageMemory2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result bindImageMemory2( uint32_t                    bindInfoCount,
                                                  BindImageMemoryInfo const * pBindInfos,
                                                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkBindImageMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindImageMemory2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBindImageMemory2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      bindImageMemory2( ArrayProxy<BindImageMemoryInfo const> const & bindInfos, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceGroupPeerMemoryFeatures, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupPeerMemoryFeatures.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceGroupPeerMemoryFeatures ), bool>::type = true>
    void getGroupPeerMemoryFeatures( uint32_t                 heapIndex,
                                     uint32_t                 localDeviceIndex,
                                     uint32_t                 remoteDeviceIndex,
                                     PeerMemoryFeatureFlags * pPeerMemoryFeatures,
                                     Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceGroupPeerMemoryFeatures, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupPeerMemoryFeatures.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceGroupPeerMemoryFeatures ), bool>::type = true>
    VULKAN_HPP_NODISCARD PeerMemoryFeatureFlags
      getGroupPeerMemoryFeatures( uint32_t           heapIndex,
                                  uint32_t           localDeviceIndex,
                                  uint32_t           remoteDeviceIndex,
                                  Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetImageMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetImageMemoryRequirements2 ), bool>::type = true>
    void getImageMemoryRequirements2( ImageMemoryRequirementsInfo2 const * pInfo,
                                      MemoryRequirements2 *                pMemoryRequirements,
                                      Dispatch const & d                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetImageMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetImageMemoryRequirements2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD MemoryRequirements2 getImageMemoryRequirements2(
      ImageMemoryRequirementsInfo2 const & info, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
    // wrapper function for command vkGetImageMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2.html
    template <typename X,
              typename Y,
              typename... Z,
              typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetImageMemoryRequirements2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                         getImageMemoryRequirements2( ImageMemoryRequirementsInfo2 const & info,
                                                      Dispatch const & d                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetBufferMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetBufferMemoryRequirements2 ), bool>::type = true>
    void getBufferMemoryRequirements2( BufferMemoryRequirementsInfo2 const * pInfo,
                                       MemoryRequirements2 *                 pMemoryRequirements,
                                       Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetBufferMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetBufferMemoryRequirements2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD MemoryRequirements2 getBufferMemoryRequirements2(
      BufferMemoryRequirementsInfo2 const & info, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
    // wrapper function for command vkGetBufferMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2.html
    template <typename X,
              typename Y,
              typename... Z,
              typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetBufferMemoryRequirements2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                         getBufferMemoryRequirements2( BufferMemoryRequirementsInfo2 const & info,
                                                       Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetImageSparseMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements2.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetImageSparseMemoryRequirements2 ), bool>::type = true>
    void getImageSparseMemoryRequirements2( ImageSparseMemoryRequirementsInfo2 const * pInfo,
                                            uint32_t *                                 pSparseMemoryRequirementCount,
                                            SparseImageMemoryRequirements2 *           pSparseMemoryRequirements,
                                            Dispatch const & d                         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetImageSparseMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements2.html
    template <
      typename SparseImageMemoryRequirements2Allocator = std::allocator<SparseImageMemoryRequirements2>,
      typename Dispatch                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
      typename std::enable_if<std::is_same<typename SparseImageMemoryRequirements2Allocator::value_type, SparseImageMemoryRequirements2>::value, int>::type = 0,
      typename std::enable_if<IS_DISPATCHED( vkGetImageSparseMemoryRequirements2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements2, SparseImageMemoryRequirements2Allocator>
      getImageSparseMemoryRequirements2( ImageSparseMemoryRequirementsInfo2 const & info, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetImageSparseMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements2.html
    template <
      typename SparseImageMemoryRequirements2Allocator = std::allocator<SparseImageMemoryRequirements2>,
      typename Dispatch                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
      typename std::enable_if<std::is_same<typename SparseImageMemoryRequirements2Allocator::value_type, SparseImageMemoryRequirements2>::value, int>::type = 0,
      typename std::enable_if<IS_DISPATCHED( vkGetImageSparseMemoryRequirements2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements2, SparseImageMemoryRequirements2Allocator>
                         getImageSparseMemoryRequirements2( ImageSparseMemoryRequirementsInfo2 const &      info,
                                                            SparseImageMemoryRequirements2Allocator const & sparseImageMemoryRequirements2Allocator,
                                                            Dispatch const & d                              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkTrimCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkTrimCommandPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkTrimCommandPool ), bool>::type = true>
    void trimCommandPool( CommandPool          commandPool,
                          CommandPoolTrimFlags flags,
                          Dispatch const & d   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkGetDeviceQueue2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceQueue2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetDeviceQueue2 ), bool>::type = true>
    void
      getQueue2( DeviceQueueInfo2 const * pQueueInfo, Queue * pQueue, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceQueue2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceQueue2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetDeviceQueue2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD Queue getQueue2( DeviceQueueInfo2 const & queueInfo,
                                          Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateDescriptorUpdateTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorUpdateTemplate.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorUpdateTemplate ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createDescriptorUpdateTemplate( DescriptorUpdateTemplateCreateInfo const * pCreateInfo,
                                                                AllocationCallbacks const *                pAllocator,
                                                                DescriptorUpdateTemplate *                 pDescriptorUpdateTemplate,
                                                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateDescriptorUpdateTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorUpdateTemplate.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorUpdateTemplate ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<DescriptorUpdateTemplate>::type
      createDescriptorUpdateTemplate( DescriptorUpdateTemplateCreateInfo const &    createInfo,
                                      Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                      Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateDescriptorUpdateTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorUpdateTemplate.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorUpdateTemplate ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<DescriptorUpdateTemplate, Dispatch>>::type
      createDescriptorUpdateTemplateUnique( DescriptorUpdateTemplateCreateInfo const &    createInfo,
                                            Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                            Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyDescriptorUpdateTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorUpdateTemplate.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorUpdateTemplate ), bool>::type = true>
    void destroyDescriptorUpdateTemplate( DescriptorUpdateTemplate    descriptorUpdateTemplate,
                                          AllocationCallbacks const * pAllocator,
                                          Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyDescriptorUpdateTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorUpdateTemplate.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorUpdateTemplate ), bool>::type = true>
    void destroyDescriptorUpdateTemplate( DescriptorUpdateTemplate descriptorUpdateTemplate VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                          Optional<AllocationCallbacks const> allocator     VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                          Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyDescriptorUpdateTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorUpdateTemplate.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorUpdateTemplate ), bool>::type = true>
    void destroy( DescriptorUpdateTemplate    descriptorUpdateTemplate,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyDescriptorUpdateTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorUpdateTemplate.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorUpdateTemplate ), bool>::type = true>
    void destroy( DescriptorUpdateTemplate                      descriptorUpdateTemplate,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkUpdateDescriptorSetWithTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateDescriptorSetWithTemplate.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkUpdateDescriptorSetWithTemplate ), bool>::type = true>
    void updateDescriptorSetWithTemplate( DescriptorSet            descriptorSet,
                                          DescriptorUpdateTemplate descriptorUpdateTemplate,
                                          void const *             pData,
                                          Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkUpdateDescriptorSetWithTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateDescriptorSetWithTemplate.html
    template <typename DataType,
              typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkUpdateDescriptorSetWithTemplate ), bool>::type = true>
    void updateDescriptorSetWithTemplate( DescriptorSet            descriptorSet,
                                          DescriptorUpdateTemplate descriptorUpdateTemplate,
                                          DataType const &         data,
                                          Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDescriptorSetLayoutSupport, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutSupport.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDescriptorSetLayoutSupport ), bool>::type = true>
    void getDescriptorSetLayoutSupport( DescriptorSetLayoutCreateInfo const * pCreateInfo,
                                        DescriptorSetLayoutSupport *          pSupport,
                                        Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDescriptorSetLayoutSupport, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutSupport.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDescriptorSetLayoutSupport ), bool>::type = true>
    VULKAN_HPP_NODISCARD DescriptorSetLayoutSupport getDescriptorSetLayoutSupport(
      DescriptorSetLayoutCreateInfo const & createInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
    // wrapper function for command vkGetDescriptorSetLayoutSupport, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutSupport.html
    template <typename X,
              typename Y,
              typename... Z,
              typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDescriptorSetLayoutSupport ), bool>::type = true>
    VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                         getDescriptorSetLayoutSupport( DescriptorSetLayoutCreateInfo const & createInfo,
                                                        Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateSamplerYcbcrConversion, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSamplerYcbcrConversion.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateSamplerYcbcrConversion ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createSamplerYcbcrConversion( SamplerYcbcrConversionCreateInfo const * pCreateInfo,
                                                              AllocationCallbacks const *              pAllocator,
                                                              SamplerYcbcrConversion *                 pYcbcrConversion,
                                                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateSamplerYcbcrConversion, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSamplerYcbcrConversion.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateSamplerYcbcrConversion ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<SamplerYcbcrConversion>::type
      createSamplerYcbcrConversion( SamplerYcbcrConversionCreateInfo const &      createInfo,
                                    Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                    Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateSamplerYcbcrConversion, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSamplerYcbcrConversion.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateSamplerYcbcrConversion ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<SamplerYcbcrConversion, Dispatch>>::type
      createSamplerYcbcrConversionUnique( SamplerYcbcrConversionCreateInfo const &      createInfo,
                                          Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                          Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroySamplerYcbcrConversion, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySamplerYcbcrConversion.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroySamplerYcbcrConversion ), bool>::type = true>
    void destroySamplerYcbcrConversion( SamplerYcbcrConversion      ycbcrConversion,
                                        AllocationCallbacks const * pAllocator,
                                        Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroySamplerYcbcrConversion, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySamplerYcbcrConversion.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroySamplerYcbcrConversion ), bool>::type = true>
    void destroySamplerYcbcrConversion( SamplerYcbcrConversion ycbcrConversion        VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                        Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                        Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroySamplerYcbcrConversion, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySamplerYcbcrConversion.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroySamplerYcbcrConversion ), bool>::type = true>
    void destroy( SamplerYcbcrConversion      ycbcrConversion,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroySamplerYcbcrConversion, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySamplerYcbcrConversion.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroySamplerYcbcrConversion ), bool>::type = true>
    void destroy( SamplerYcbcrConversion                        ycbcrConversion,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_VERSION_1_2 ===

    // wrapper function for command vkResetQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetQueryPool.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkResetQueryPool ), bool>::type = true>
    void resetQueryPool( QueryPool          queryPool,
                         uint32_t           firstQuery,
                         uint32_t           queryCount,
                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkGetSemaphoreCounterValue, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreCounterValue.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetSemaphoreCounterValue ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getSemaphoreCounterValue( Semaphore          semaphore,
                                                          uint64_t *         pValue,
                                                          Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetSemaphoreCounterValue, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreCounterValue.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetSemaphoreCounterValue ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<uint64_t>::type getSemaphoreCounterValue( Semaphore          semaphore,
                                                                                            Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkWaitSemaphores, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkWaitSemaphores.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkWaitSemaphores ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result waitSemaphores( SemaphoreWaitInfo const * pWaitInfo,
                                                uint64_t                  timeout,
                                                Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkWaitSemaphores, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkWaitSemaphores.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkWaitSemaphores ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result waitSemaphores( SemaphoreWaitInfo const & waitInfo,
                                                uint64_t                  timeout,
                                                Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkSignalSemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSignalSemaphore.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSignalSemaphore ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result signalSemaphore( SemaphoreSignalInfo const * pSignalInfo,
                                                 Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkSignalSemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSignalSemaphore.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSignalSemaphore ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      signalSemaphore( SemaphoreSignalInfo const & signalInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetBufferDeviceAddress, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferDeviceAddress.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetBufferDeviceAddress ), bool>::type = true>
    DeviceAddress getBufferAddress( BufferDeviceAddressInfo const * pInfo,
                                    Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetBufferDeviceAddress, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferDeviceAddress.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetBufferDeviceAddress ), bool>::type = true>
    DeviceAddress getBufferAddress( BufferDeviceAddressInfo const & info,
                                    Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetBufferOpaqueCaptureAddress, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferOpaqueCaptureAddress.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetBufferOpaqueCaptureAddress ), bool>::type = true>
    uint64_t getBufferOpaqueCaptureAddress( BufferDeviceAddressInfo const * pInfo,
                                            Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetBufferOpaqueCaptureAddress, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferOpaqueCaptureAddress.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetBufferOpaqueCaptureAddress ), bool>::type = true>
    uint64_t getBufferOpaqueCaptureAddress( BufferDeviceAddressInfo const & info,
                                            Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceMemoryOpaqueCaptureAddress, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceMemoryOpaqueCaptureAddress.html
    template <typename Dispatch                                                                           = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceMemoryOpaqueCaptureAddress ), bool>::type = true>
    uint64_t getMemoryOpaqueCaptureAddress( DeviceMemoryOpaqueCaptureAddressInfo const * pInfo,
                                            Dispatch const & d                           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceMemoryOpaqueCaptureAddress, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceMemoryOpaqueCaptureAddress.html
    template <typename Dispatch                                                                           = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceMemoryOpaqueCaptureAddress ), bool>::type = true>
    uint64_t getMemoryOpaqueCaptureAddress( DeviceMemoryOpaqueCaptureAddressInfo const & info,
                                            Dispatch const & d                           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateRenderPass2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createRenderPass2( RenderPassCreateInfo2 const * pCreateInfo,
                                                   AllocationCallbacks const *   pAllocator,
                                                   RenderPass *                  pRenderPass,
                                                   Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateRenderPass2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<RenderPass>::type
      createRenderPass2( RenderPassCreateInfo2 const &                 createInfo,
                         Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                         Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateRenderPass2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<RenderPass, Dispatch>>::type
      createRenderPass2Unique( RenderPassCreateInfo2 const &                 createInfo,
                               Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                               Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_VERSION_1_3 ===

    // wrapper function for command vkCreatePrivateDataSlot, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePrivateDataSlot.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreatePrivateDataSlot ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createPrivateDataSlot( PrivateDataSlotCreateInfo const * pCreateInfo,
                                                       AllocationCallbacks const *       pAllocator,
                                                       PrivateDataSlot *                 pPrivateDataSlot,
                                                       Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreatePrivateDataSlot, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePrivateDataSlot.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreatePrivateDataSlot ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<PrivateDataSlot>::type
      createPrivateDataSlot( PrivateDataSlotCreateInfo const &             createInfo,
                             Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                             Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreatePrivateDataSlot, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePrivateDataSlot.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreatePrivateDataSlot ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<PrivateDataSlot, Dispatch>>::type
      createPrivateDataSlotUnique( PrivateDataSlotCreateInfo const &             createInfo,
                                   Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                   Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyPrivateDataSlot, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPrivateDataSlot.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPrivateDataSlot ), bool>::type = true>
    void destroyPrivateDataSlot( PrivateDataSlot             privateDataSlot,
                                 AllocationCallbacks const * pAllocator,
                                 Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyPrivateDataSlot, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPrivateDataSlot.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPrivateDataSlot ), bool>::type = true>
    void destroyPrivateDataSlot( PrivateDataSlot privateDataSlot               VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                 Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                 Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyPrivateDataSlot, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPrivateDataSlot.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPrivateDataSlot ), bool>::type = true>
    void destroy( PrivateDataSlot             privateDataSlot,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyPrivateDataSlot, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPrivateDataSlot.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyPrivateDataSlot ), bool>::type = true>
    void destroy( PrivateDataSlot                               privateDataSlot,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkSetPrivateData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetPrivateData.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSetPrivateData ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result setPrivateData( ObjectType         objectType,
                                                uint64_t           objectHandle,
                                                PrivateDataSlot    privateDataSlot,
                                                uint64_t           data,
                                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkSetPrivateData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetPrivateData.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSetPrivateData ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      setPrivateData( ObjectType         objectType,
                      uint64_t           objectHandle,
                      PrivateDataSlot    privateDataSlot,
                      uint64_t           data,
                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    // wrapper function for command vkGetPrivateData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPrivateData.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetPrivateData ), bool>::type = true>
    void getPrivateData( ObjectType         objectType,
                         uint64_t           objectHandle,
                         PrivateDataSlot    privateDataSlot,
                         uint64_t *         pData,
                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetPrivateData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPrivateData.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetPrivateData ), bool>::type = true>
    VULKAN_HPP_NODISCARD uint64_t getPrivateData( ObjectType         objectType,
                                                  uint64_t           objectHandle,
                                                  PrivateDataSlot    privateDataSlot,
                                                  Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceBufferMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceBufferMemoryRequirements.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceBufferMemoryRequirements ), bool>::type = true>
    void getBufferMemoryRequirements( DeviceBufferMemoryRequirements const * pInfo,
                                      MemoryRequirements2 *                  pMemoryRequirements,
                                      Dispatch const & d                     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceBufferMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceBufferMemoryRequirements.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceBufferMemoryRequirements ), bool>::type = true>
    VULKAN_HPP_NODISCARD MemoryRequirements2 getBufferMemoryRequirements(
      DeviceBufferMemoryRequirements const & info, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
    // wrapper function for command vkGetDeviceBufferMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceBufferMemoryRequirements.html
    template <typename X,
              typename Y,
              typename... Z,
              typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceBufferMemoryRequirements ), bool>::type = true>
    VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                         getBufferMemoryRequirements( DeviceBufferMemoryRequirements const & info,
                                                      Dispatch const & d                     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceImageMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageMemoryRequirements.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceImageMemoryRequirements ), bool>::type = true>
    void getImageMemoryRequirements( DeviceImageMemoryRequirements const * pInfo,
                                     MemoryRequirements2 *                 pMemoryRequirements,
                                     Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceImageMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageMemoryRequirements.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceImageMemoryRequirements ), bool>::type = true>
    VULKAN_HPP_NODISCARD MemoryRequirements2 getImageMemoryRequirements(
      DeviceImageMemoryRequirements const & info, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
    // wrapper function for command vkGetDeviceImageMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageMemoryRequirements.html
    template <typename X,
              typename Y,
              typename... Z,
              typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceImageMemoryRequirements ), bool>::type = true>
    VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                         getImageMemoryRequirements( DeviceImageMemoryRequirements const & info,
                                                     Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceImageSparseMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSparseMemoryRequirements.html
    template <typename Dispatch                                                                              = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceImageSparseMemoryRequirements ), bool>::type = true>
    void getImageSparseMemoryRequirements( DeviceImageMemoryRequirements const * pInfo,
                                           uint32_t *                            pSparseMemoryRequirementCount,
                                           SparseImageMemoryRequirements2 *      pSparseMemoryRequirements,
                                           Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceImageSparseMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSparseMemoryRequirements.html
    template <
      typename SparseImageMemoryRequirements2Allocator = std::allocator<SparseImageMemoryRequirements2>,
      typename Dispatch                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
      typename std::enable_if<std::is_same<typename SparseImageMemoryRequirements2Allocator::value_type, SparseImageMemoryRequirements2>::value, int>::type = 0,
      typename std::enable_if<IS_DISPATCHED( vkGetDeviceImageSparseMemoryRequirements ), bool>::type = true>
    VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements2, SparseImageMemoryRequirements2Allocator>
      getImageSparseMemoryRequirements( DeviceImageMemoryRequirements const & info, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetDeviceImageSparseMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSparseMemoryRequirements.html
    template <
      typename SparseImageMemoryRequirements2Allocator = std::allocator<SparseImageMemoryRequirements2>,
      typename Dispatch                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
      typename std::enable_if<std::is_same<typename SparseImageMemoryRequirements2Allocator::value_type, SparseImageMemoryRequirements2>::value, int>::type = 0,
      typename std::enable_if<IS_DISPATCHED( vkGetDeviceImageSparseMemoryRequirements ), bool>::type = true>
    VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements2, SparseImageMemoryRequirements2Allocator>
                         getImageSparseMemoryRequirements( DeviceImageMemoryRequirements const &           info,
                                                           SparseImageMemoryRequirements2Allocator const & sparseImageMemoryRequirements2Allocator,
                                                           Dispatch const & d                              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_VERSION_1_4 ===

    // wrapper function for command vkMapMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMapMemory2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkMapMemory2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result mapMemory2( MemoryMapInfo const * pMemoryMapInfo,
                                            void **               ppData,
                                            Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkMapMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMapMemory2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkMapMemory2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<void *>::type mapMemory2( MemoryMapInfo const & memoryMapInfo,
                                                                            Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkUnmapMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkUnmapMemory2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkUnmapMemory2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result unmapMemory2( MemoryUnmapInfo const * pMemoryUnmapInfo,
                                              Dispatch const & d      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkUnmapMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkUnmapMemory2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkUnmapMemory2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      unmapMemory2( MemoryUnmapInfo const & memoryUnmapInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceImageSubresourceLayout, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSubresourceLayout.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceImageSubresourceLayout ), bool>::type = true>
    void getImageSubresourceLayout( DeviceImageSubresourceInfo const * pInfo,
                                    SubresourceLayout2 *               pLayout,
                                    Dispatch const & d                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceImageSubresourceLayout, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSubresourceLayout.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceImageSubresourceLayout ), bool>::type = true>
    VULKAN_HPP_NODISCARD SubresourceLayout2 getImageSubresourceLayout( DeviceImageSubresourceInfo const & info,
                                                                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
    // wrapper function for command vkGetDeviceImageSubresourceLayout, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSubresourceLayout.html
    template <typename X,
              typename Y,
              typename... Z,
              typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceImageSubresourceLayout ), bool>::type = true>
    VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                         getImageSubresourceLayout( DeviceImageSubresourceInfo const & info,
                                                    Dispatch const & d                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetImageSubresourceLayout2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageSubresourceLayout2 ), bool>::type = true>
    void getImageSubresourceLayout2( Image                     image,
                                     ImageSubresource2 const * pSubresource,
                                     SubresourceLayout2 *      pLayout,
                                     Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetImageSubresourceLayout2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout2.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageSubresourceLayout2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD SubresourceLayout2 getImageSubresourceLayout2( Image                     image,
                                                                        ImageSubresource2 const & subresource,
                                                                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
    // wrapper function for command vkGetImageSubresourceLayout2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout2.html
    template <typename X,
              typename Y,
              typename... Z,
              typename Dispatch                                                                  = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetImageSubresourceLayout2 ), bool>::type = true>
    VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getImageSubresourceLayout2(
      Image image, ImageSubresource2 const & subresource, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCopyMemoryToImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyMemoryToImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCopyMemoryToImage ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result copyMemoryToImage( CopyMemoryToImageInfo const * pCopyMemoryToImageInfo,
                                                   Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCopyMemoryToImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyMemoryToImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCopyMemoryToImage ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      copyMemoryToImage( CopyMemoryToImageInfo const & copyMemoryToImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCopyImageToMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyImageToMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCopyImageToMemory ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result copyImageToMemory( CopyImageToMemoryInfo const * pCopyImageToMemoryInfo,
                                                   Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCopyImageToMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyImageToMemory.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCopyImageToMemory ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      copyImageToMemory( CopyImageToMemoryInfo const & copyImageToMemoryInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCopyImageToImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyImageToImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCopyImageToImage ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result copyImageToImage( CopyImageToImageInfo const * pCopyImageToImageInfo,
                                                  Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCopyImageToImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyImageToImage.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCopyImageToImage ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      copyImageToImage( CopyImageToImageInfo const & copyImageToImageInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkTransitionImageLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkTransitionImageLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkTransitionImageLayout ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result transitionImageLayout( uint32_t                              transitionCount,
                                                       HostImageLayoutTransitionInfo const * pTransitions,
                                                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkTransitionImageLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkTransitionImageLayout.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkTransitionImageLayout ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      transitionImageLayout( ArrayProxy<HostImageLayoutTransitionInfo const> const & transitions,
                             Dispatch const & d                                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetRenderingAreaGranularity, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRenderingAreaGranularity.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetRenderingAreaGranularity ), bool>::type = true>
    void getRenderingAreaGranularity( RenderingAreaInfo const * pRenderingAreaInfo,
                                      Extent2D *                pGranularity,
                                      Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetRenderingAreaGranularity, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRenderingAreaGranularity.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetRenderingAreaGranularity ), bool>::type = true>
    VULKAN_HPP_NODISCARD Extent2D getRenderingAreaGranularity( RenderingAreaInfo const & renderingAreaInfo,
                                                               Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_swapchain ===

    // wrapper function for command vkCreateSwapchainKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSwapchainKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSwapchainKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createSwapchainKHR( SwapchainCreateInfoKHR const * pCreateInfo,
                                                    AllocationCallbacks const *    pAllocator,
                                                    SwapchainKHR *                 pSwapchain,
                                                    Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateSwapchainKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSwapchainKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSwapchainKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<SwapchainKHR>::type
      createSwapchainKHR( SwapchainCreateInfoKHR const &                createInfo,
                          Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                          Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateSwapchainKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSwapchainKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSwapchainKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<SwapchainKHR, Dispatch>>::type
      createSwapchainKHRUnique( SwapchainCreateInfoKHR const &                createInfo,
                                Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroySwapchainKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySwapchainKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySwapchainKHR ), bool>::type = true>
    void destroySwapchainKHR( SwapchainKHR                swapchain,
                              AllocationCallbacks const * pAllocator,
                              Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroySwapchainKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySwapchainKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySwapchainKHR ), bool>::type = true>
    void destroySwapchainKHR( SwapchainKHR swapchain                        VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                              Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                              Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroySwapchainKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySwapchainKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySwapchainKHR ), bool>::type = true>
    void destroy( SwapchainKHR                swapchain,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroySwapchainKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySwapchainKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroySwapchainKHR ), bool>::type = true>
    void destroy( SwapchainKHR                                  swapchain,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetSwapchainImagesKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSwapchainImagesKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetSwapchainImagesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getSwapchainImagesKHR( SwapchainKHR       swapchain,
                                                       uint32_t *         pSwapchainImageCount,
                                                       Image *            pSwapchainImages,
                                                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetSwapchainImagesKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSwapchainImagesKHR.html
    template <typename ImageAllocator                                                                             = std::allocator<Image>,
              typename Dispatch                                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename ImageAllocator::value_type, Image>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetSwapchainImagesKHR ), bool>::type                       = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<Image, ImageAllocator>>::type
      getSwapchainImagesKHR( SwapchainKHR swapchain, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetSwapchainImagesKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSwapchainImagesKHR.html
    template <typename ImageAllocator                                                                             = std::allocator<Image>,
              typename Dispatch                                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename ImageAllocator::value_type, Image>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetSwapchainImagesKHR ), bool>::type                       = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<Image, ImageAllocator>>::type
      getSwapchainImagesKHR( SwapchainKHR swapchain, ImageAllocator const & imageAllocator, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkAcquireNextImageKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireNextImageKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkAcquireNextImageKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result acquireNextImageKHR( SwapchainKHR       swapchain,
                                                     uint64_t           timeout,
                                                     Semaphore          semaphore,
                                                     Fence              fence,
                                                     uint32_t *         pImageIndex,
                                                     Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkAcquireNextImageKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireNextImageKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkAcquireNextImageKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD ResultValue<uint32_t> acquireNextImageKHR( SwapchainKHR        swapchain,
                                                                    uint64_t            timeout,
                                                                    Semaphore semaphore VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                                                    Fence fence         VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                                                    Dispatch const & d  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceGroupPresentCapabilitiesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupPresentCapabilitiesKHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceGroupPresentCapabilitiesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getGroupPresentCapabilitiesKHR( DeviceGroupPresentCapabilitiesKHR * pDeviceGroupPresentCapabilities,
                                                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceGroupPresentCapabilitiesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupPresentCapabilitiesKHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceGroupPresentCapabilitiesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<DeviceGroupPresentCapabilitiesKHR>::type
      getGroupPresentCapabilitiesKHR( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceGroupSurfacePresentModesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupSurfacePresentModesKHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceGroupSurfacePresentModesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getGroupSurfacePresentModesKHR( SurfaceKHR                       surface,
                                                                DeviceGroupPresentModeFlagsKHR * pModes,
                                                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceGroupSurfacePresentModesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupSurfacePresentModesKHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceGroupSurfacePresentModesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<DeviceGroupPresentModeFlagsKHR>::type
      getGroupSurfacePresentModesKHR( SurfaceKHR surface, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkAcquireNextImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireNextImage2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkAcquireNextImage2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result acquireNextImage2KHR( AcquireNextImageInfoKHR const * pAcquireInfo,
                                                      uint32_t *                      pImageIndex,
                                                      Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkAcquireNextImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireNextImage2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkAcquireNextImage2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD ResultValue<uint32_t> acquireNextImage2KHR( AcquireNextImageInfoKHR const & acquireInfo,
                                                                     Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_display_swapchain ===

    // wrapper function for command vkCreateSharedSwapchainsKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSharedSwapchainsKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSharedSwapchainsKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createSharedSwapchainsKHR( uint32_t                       swapchainCount,
                                                           SwapchainCreateInfoKHR const * pCreateInfos,
                                                           AllocationCallbacks const *    pAllocator,
                                                           SwapchainKHR *                 pSwapchains,
                                                           Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateSharedSwapchainsKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSharedSwapchainsKHR.html
    template <typename SwapchainKHRAllocator = std::allocator<SwapchainKHR>,
              typename Dispatch              = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename SwapchainKHRAllocator::value_type, SwapchainKHR>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateSharedSwapchainsKHR ), bool>::type                                 = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<SwapchainKHR, SwapchainKHRAllocator>>::type
      createSharedSwapchainsKHR( ArrayProxy<SwapchainCreateInfoKHR const> const & createInfos,
                                 Optional<AllocationCallbacks const> allocator    VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                 Dispatch const & d                               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateSharedSwapchainsKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSharedSwapchainsKHR.html
    template <typename SwapchainKHRAllocator = std::allocator<SwapchainKHR>,
              typename Dispatch              = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename SwapchainKHRAllocator::value_type, SwapchainKHR>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateSharedSwapchainsKHR ), bool>::type                                 = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<SwapchainKHR, SwapchainKHRAllocator>>::type
      createSharedSwapchainsKHR( ArrayProxy<SwapchainCreateInfoKHR const> const & createInfos,
                                 Optional<AllocationCallbacks const>              allocator,
                                 SwapchainKHRAllocator const &                    swapchainKHRAllocator,
                                 Dispatch const & d                               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateSharedSwapchainsKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSharedSwapchainsKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSharedSwapchainsKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<SwapchainKHR>::type
      createSharedSwapchainKHR( SwapchainCreateInfoKHR const &                createInfo,
                                Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateSharedSwapchainsKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSharedSwapchainsKHR.html
    template <typename Dispatch              = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename SwapchainKHRAllocator = std::allocator<UniqueHandle<SwapchainKHR, Dispatch>>,
              typename std::enable_if<std::is_same<typename SwapchainKHRAllocator::value_type, UniqueHandle<SwapchainKHR, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateSharedSwapchainsKHR ), bool>::type                                                         = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<UniqueHandle<SwapchainKHR, Dispatch>, SwapchainKHRAllocator>>::type
      createSharedSwapchainsKHRUnique( ArrayProxy<SwapchainCreateInfoKHR const> const & createInfos,
                                       Optional<AllocationCallbacks const> allocator    VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                       Dispatch const & d                               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateSharedSwapchainsKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSharedSwapchainsKHR.html
    template <typename Dispatch              = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename SwapchainKHRAllocator = std::allocator<UniqueHandle<SwapchainKHR, Dispatch>>,
              typename std::enable_if<std::is_same<typename SwapchainKHRAllocator::value_type, UniqueHandle<SwapchainKHR, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateSharedSwapchainsKHR ), bool>::type                                                         = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<UniqueHandle<SwapchainKHR, Dispatch>, SwapchainKHRAllocator>>::type
      createSharedSwapchainsKHRUnique( ArrayProxy<SwapchainCreateInfoKHR const> const & createInfos,
                                       Optional<AllocationCallbacks const>              allocator,
                                       SwapchainKHRAllocator const &                    swapchainKHRAllocator,
                                       Dispatch const & d                               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateSharedSwapchainsKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSharedSwapchainsKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateSharedSwapchainsKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<SwapchainKHR, Dispatch>>::type
      createSharedSwapchainKHRUnique( SwapchainCreateInfoKHR const &                createInfo,
                                      Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                      Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_debug_marker ===

    // wrapper function for command vkDebugMarkerSetObjectTagEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDebugMarkerSetObjectTagEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDebugMarkerSetObjectTagEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result debugMarkerSetObjectTagEXT( DebugMarkerObjectTagInfoEXT const * pTagInfo,
                                                            Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDebugMarkerSetObjectTagEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDebugMarkerSetObjectTagEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDebugMarkerSetObjectTagEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      debugMarkerSetObjectTagEXT( DebugMarkerObjectTagInfoEXT const & tagInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDebugMarkerSetObjectNameEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDebugMarkerSetObjectNameEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDebugMarkerSetObjectNameEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result debugMarkerSetObjectNameEXT( DebugMarkerObjectNameInfoEXT const * pNameInfo,
                                                             Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDebugMarkerSetObjectNameEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDebugMarkerSetObjectNameEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDebugMarkerSetObjectNameEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      debugMarkerSetObjectNameEXT( DebugMarkerObjectNameInfoEXT const & nameInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_video_queue ===

    // wrapper function for command vkCreateVideoSessionKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateVideoSessionKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateVideoSessionKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createVideoSessionKHR( VideoSessionCreateInfoKHR const * pCreateInfo,
                                                       AllocationCallbacks const *       pAllocator,
                                                       VideoSessionKHR *                 pVideoSession,
                                                       Dispatch const & d                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateVideoSessionKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateVideoSessionKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateVideoSessionKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<VideoSessionKHR>::type
      createVideoSessionKHR( VideoSessionCreateInfoKHR const &             createInfo,
                             Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                             Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateVideoSessionKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateVideoSessionKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateVideoSessionKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<VideoSessionKHR, Dispatch>>::type
      createVideoSessionKHRUnique( VideoSessionCreateInfoKHR const &             createInfo,
                                   Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                   Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyVideoSessionKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyVideoSessionKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyVideoSessionKHR ), bool>::type = true>
    void destroyVideoSessionKHR( VideoSessionKHR             videoSession,
                                 AllocationCallbacks const * pAllocator,
                                 Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyVideoSessionKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyVideoSessionKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyVideoSessionKHR ), bool>::type = true>
    void destroyVideoSessionKHR( VideoSessionKHR videoSession                  VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                 Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                 Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyVideoSessionKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyVideoSessionKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyVideoSessionKHR ), bool>::type = true>
    void destroy( VideoSessionKHR             videoSession,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyVideoSessionKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyVideoSessionKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyVideoSessionKHR ), bool>::type = true>
    void destroy( VideoSessionKHR                               videoSession,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetVideoSessionMemoryRequirementsKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetVideoSessionMemoryRequirementsKHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetVideoSessionMemoryRequirementsKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getVideoSessionMemoryRequirementsKHR( VideoSessionKHR                     videoSession,
                                                                      uint32_t *                          pMemoryRequirementsCount,
                                                                      VideoSessionMemoryRequirementsKHR * pMemoryRequirements,
                                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetVideoSessionMemoryRequirementsKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetVideoSessionMemoryRequirementsKHR.html
    template <typename VideoSessionMemoryRequirementsKHRAllocator                                          = std::allocator<VideoSessionMemoryRequirementsKHR>,
              typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename VideoSessionMemoryRequirementsKHRAllocator::value_type, VideoSessionMemoryRequirementsKHR>::value,
                                      int>::type                                                           = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetVideoSessionMemoryRequirementsKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<VideoSessionMemoryRequirementsKHR, VideoSessionMemoryRequirementsKHRAllocator>>::type
      getVideoSessionMemoryRequirementsKHR( VideoSessionKHR videoSession, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetVideoSessionMemoryRequirementsKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetVideoSessionMemoryRequirementsKHR.html
    template <typename VideoSessionMemoryRequirementsKHRAllocator                                          = std::allocator<VideoSessionMemoryRequirementsKHR>,
              typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename VideoSessionMemoryRequirementsKHRAllocator::value_type, VideoSessionMemoryRequirementsKHR>::value,
                                      int>::type                                                           = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetVideoSessionMemoryRequirementsKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<VideoSessionMemoryRequirementsKHR, VideoSessionMemoryRequirementsKHRAllocator>>::type
      getVideoSessionMemoryRequirementsKHR( VideoSessionKHR                                    videoSession,
                                            VideoSessionMemoryRequirementsKHRAllocator const & videoSessionMemoryRequirementsKHRAllocator,
                                            Dispatch const & d                                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkBindVideoSessionMemoryKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindVideoSessionMemoryKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBindVideoSessionMemoryKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result bindVideoSessionMemoryKHR( VideoSessionKHR                       videoSession,
                                                           uint32_t                              bindSessionMemoryInfoCount,
                                                           BindVideoSessionMemoryInfoKHR const * pBindSessionMemoryInfos,
                                                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkBindVideoSessionMemoryKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindVideoSessionMemoryKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkBindVideoSessionMemoryKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      bindVideoSessionMemoryKHR( VideoSessionKHR                                         videoSession,
                                 ArrayProxy<BindVideoSessionMemoryInfoKHR const> const & bindSessionMemoryInfos,
                                 Dispatch const & d                                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateVideoSessionParametersKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateVideoSessionParametersKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateVideoSessionParametersKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createVideoSessionParametersKHR( VideoSessionParametersCreateInfoKHR const * pCreateInfo,
                                                                 AllocationCallbacks const *                 pAllocator,
                                                                 VideoSessionParametersKHR *                 pVideoSessionParameters,
                                                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateVideoSessionParametersKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateVideoSessionParametersKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateVideoSessionParametersKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<VideoSessionParametersKHR>::type
      createVideoSessionParametersKHR( VideoSessionParametersCreateInfoKHR const &   createInfo,
                                       Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                       Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateVideoSessionParametersKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateVideoSessionParametersKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateVideoSessionParametersKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<VideoSessionParametersKHR, Dispatch>>::type
      createVideoSessionParametersKHRUnique( VideoSessionParametersCreateInfoKHR const &   createInfo,
                                             Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                             Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkUpdateVideoSessionParametersKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateVideoSessionParametersKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkUpdateVideoSessionParametersKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result updateVideoSessionParametersKHR( VideoSessionParametersKHR                   videoSessionParameters,
                                                                 VideoSessionParametersUpdateInfoKHR const * pUpdateInfo,
                                                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkUpdateVideoSessionParametersKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateVideoSessionParametersKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkUpdateVideoSessionParametersKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      updateVideoSessionParametersKHR( VideoSessionParametersKHR                   videoSessionParameters,
                                       VideoSessionParametersUpdateInfoKHR const & updateInfo,
                                       Dispatch const & d                          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyVideoSessionParametersKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyVideoSessionParametersKHR.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyVideoSessionParametersKHR ), bool>::type = true>
    void destroyVideoSessionParametersKHR( VideoSessionParametersKHR   videoSessionParameters,
                                           AllocationCallbacks const * pAllocator,
                                           Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyVideoSessionParametersKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyVideoSessionParametersKHR.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyVideoSessionParametersKHR ), bool>::type = true>
    void destroyVideoSessionParametersKHR( VideoSessionParametersKHR videoSessionParameters VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                           Optional<AllocationCallbacks const> allocator    VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyVideoSessionParametersKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyVideoSessionParametersKHR.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyVideoSessionParametersKHR ), bool>::type = true>
    void destroy( VideoSessionParametersKHR   videoSessionParameters,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyVideoSessionParametersKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyVideoSessionParametersKHR.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyVideoSessionParametersKHR ), bool>::type = true>
    void destroy( VideoSessionParametersKHR                     videoSessionParameters,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_NVX_binary_import ===

    // wrapper function for command vkCreateCuModuleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCuModuleNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateCuModuleNVX ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createCuModuleNVX( CuModuleCreateInfoNVX const * pCreateInfo,
                                                   AllocationCallbacks const *   pAllocator,
                                                   CuModuleNVX *                 pModule,
                                                   Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateCuModuleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCuModuleNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateCuModuleNVX ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<CuModuleNVX>::type
      createCuModuleNVX( CuModuleCreateInfoNVX const &                 createInfo,
                         Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                         Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateCuModuleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCuModuleNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateCuModuleNVX ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<CuModuleNVX, Dispatch>>::type
      createCuModuleNVXUnique( CuModuleCreateInfoNVX const &                 createInfo,
                               Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                               Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCreateCuFunctionNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCuFunctionNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateCuFunctionNVX ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createCuFunctionNVX( CuFunctionCreateInfoNVX const * pCreateInfo,
                                                     AllocationCallbacks const *     pAllocator,
                                                     CuFunctionNVX *                 pFunction,
                                                     Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateCuFunctionNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCuFunctionNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateCuFunctionNVX ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<CuFunctionNVX>::type
      createCuFunctionNVX( CuFunctionCreateInfoNVX const &               createInfo,
                           Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                           Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateCuFunctionNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCuFunctionNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateCuFunctionNVX ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<CuFunctionNVX, Dispatch>>::type
      createCuFunctionNVXUnique( CuFunctionCreateInfoNVX const &               createInfo,
                                 Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                 Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyCuModuleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCuModuleNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCuModuleNVX ), bool>::type = true>
    void destroyCuModuleNVX( CuModuleNVX                 module,
                             AllocationCallbacks const * pAllocator,
                             Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyCuModuleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCuModuleNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCuModuleNVX ), bool>::type = true>
    void destroyCuModuleNVX( CuModuleNVX                                   module,
                             Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                             Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyCuModuleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCuModuleNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCuModuleNVX ), bool>::type = true>
    void destroy( CuModuleNVX                 module,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyCuModuleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCuModuleNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCuModuleNVX ), bool>::type = true>
    void destroy( CuModuleNVX                                   module,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyCuFunctionNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCuFunctionNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCuFunctionNVX ), bool>::type = true>
    void destroyCuFunctionNVX( CuFunctionNVX               function,
                               AllocationCallbacks const * pAllocator,
                               Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyCuFunctionNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCuFunctionNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCuFunctionNVX ), bool>::type = true>
    void destroyCuFunctionNVX( CuFunctionNVX                                 function,
                               Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                               Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyCuFunctionNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCuFunctionNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCuFunctionNVX ), bool>::type = true>
    void destroy( CuFunctionNVX               function,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyCuFunctionNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyCuFunctionNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDestroyCuFunctionNVX ), bool>::type = true>
    void destroy( CuFunctionNVX                                 function,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_NVX_image_view_handle ===

    // wrapper function for command vkGetImageViewHandleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageViewHandleNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageViewHandleNVX ), bool>::type = true>
    uint32_t getImageViewHandleNVX( ImageViewHandleInfoNVX const * pInfo,
                                    Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetImageViewHandleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageViewHandleNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageViewHandleNVX ), bool>::type = true>
    uint32_t getImageViewHandleNVX( ImageViewHandleInfoNVX const & info,
                                    Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetImageViewHandle64NVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageViewHandle64NVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageViewHandle64NVX ), bool>::type = true>
    uint64_t getImageViewHandle64NVX( ImageViewHandleInfoNVX const * pInfo,
                                      Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetImageViewHandle64NVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageViewHandle64NVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageViewHandle64NVX ), bool>::type = true>
    uint64_t getImageViewHandle64NVX( ImageViewHandleInfoNVX const & info,
                                      Dispatch const & d             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetImageViewAddressNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageViewAddressNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageViewAddressNVX ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getImageViewAddressNVX( ImageView                       imageView,
                                                        ImageViewAddressPropertiesNVX * pProperties,
                                                        Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetImageViewAddressNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageViewAddressNVX.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetImageViewAddressNVX ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<ImageViewAddressPropertiesNVX>::type
      getImageViewAddressNVX( ImageView imageView, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceCombinedImageSamplerIndexNVX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceCombinedImageSamplerIndexNVX.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceCombinedImageSamplerIndexNVX ), bool>::type = true>
    uint64_t getCombinedImageSamplerIndexNVX( uint64_t           imageViewIndex,
                                              uint64_t           samplerIndex,
                                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_AMD_shader_info ===

    // wrapper function for command vkGetShaderInfoAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetShaderInfoAMD.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetShaderInfoAMD ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getShaderInfoAMD( Pipeline            pipeline,
                                                  ShaderStageFlagBits shaderStage,
                                                  ShaderInfoTypeAMD   infoType,
                                                  size_t *            pInfoSize,
                                                  void *              pInfo,
                                                  Dispatch const & d  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetShaderInfoAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetShaderInfoAMD.html
    template <typename Uint8_tAllocator                                                                               = std::allocator<uint8_t>,
              typename Dispatch                                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename Uint8_tAllocator::value_type, uint8_t>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetShaderInfoAMD ), bool>::type                                = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<uint8_t, Uint8_tAllocator>>::type getShaderInfoAMD(
      Pipeline pipeline, ShaderStageFlagBits shaderStage, ShaderInfoTypeAMD infoType, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetShaderInfoAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetShaderInfoAMD.html
    template <typename Uint8_tAllocator                                                                               = std::allocator<uint8_t>,
              typename Dispatch                                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename Uint8_tAllocator::value_type, uint8_t>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetShaderInfoAMD ), bool>::type                                = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<uint8_t, Uint8_tAllocator>>::type
      getShaderInfoAMD( Pipeline                 pipeline,
                        ShaderStageFlagBits      shaderStage,
                        ShaderInfoTypeAMD        infoType,
                        Uint8_tAllocator const & uint8_tAllocator,
                        Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#if defined( VK_USE_PLATFORM_WIN32_KHR )
    //=== VK_NV_external_memory_win32 ===

    // wrapper function for command vkGetMemoryWin32HandleNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryWin32HandleNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetMemoryWin32HandleNV ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getMemoryWin32HandleNV( DeviceMemory                    memory,
                                                        ExternalMemoryHandleTypeFlagsNV handleType,
                                                        HANDLE *                        pHandle,
                                                        Dispatch const & d              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetMemoryWin32HandleNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryWin32HandleNV.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetMemoryWin32HandleNV ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<HANDLE>::type getMemoryWin32HandleNV( DeviceMemory                    memory,
                                                                                        ExternalMemoryHandleTypeFlagsNV handleType,
                                                                                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */
#endif   /*VK_USE_PLATFORM_WIN32_KHR*/

    //=== VK_KHR_device_group ===

    // wrapper function for command vkGetDeviceGroupPeerMemoryFeaturesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupPeerMemoryFeaturesKHR.html
    template <typename Dispatch                                                                           = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceGroupPeerMemoryFeaturesKHR ), bool>::type = true>
    void getGroupPeerMemoryFeaturesKHR( uint32_t                 heapIndex,
                                        uint32_t                 localDeviceIndex,
                                        uint32_t                 remoteDeviceIndex,
                                        PeerMemoryFeatureFlags * pPeerMemoryFeatures,
                                        Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceGroupPeerMemoryFeaturesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupPeerMemoryFeaturesKHR.html
    template <typename Dispatch                                                                           = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceGroupPeerMemoryFeaturesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD PeerMemoryFeatureFlags
      getGroupPeerMemoryFeaturesKHR( uint32_t           heapIndex,
                                     uint32_t           localDeviceIndex,
                                     uint32_t           remoteDeviceIndex,
                                     Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_maintenance1 ===

    // wrapper function for command vkTrimCommandPoolKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkTrimCommandPoolKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkTrimCommandPoolKHR ), bool>::type = true>
    void trimCommandPoolKHR( CommandPool          commandPool,
                             CommandPoolTrimFlags flags,
                             Dispatch const & d   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

#if defined( VK_USE_PLATFORM_WIN32_KHR )
    //=== VK_KHR_external_memory_win32 ===

    // wrapper function for command vkGetMemoryWin32HandleKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryWin32HandleKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetMemoryWin32HandleKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getMemoryWin32HandleKHR( MemoryGetWin32HandleInfoKHR const * pGetWin32HandleInfo,
                                                         HANDLE *                            pHandle,
                                                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetMemoryWin32HandleKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryWin32HandleKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetMemoryWin32HandleKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<HANDLE>::type getMemoryWin32HandleKHR( MemoryGetWin32HandleInfoKHR const & getWin32HandleInfo,
                                                                                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetMemoryWin32HandlePropertiesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryWin32HandlePropertiesKHR.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetMemoryWin32HandlePropertiesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getMemoryWin32HandlePropertiesKHR( ExternalMemoryHandleTypeFlagBits handleType,
                                                                   HANDLE                           handle,
                                                                   MemoryWin32HandlePropertiesKHR * pMemoryWin32HandleProperties,
                                                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetMemoryWin32HandlePropertiesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryWin32HandlePropertiesKHR.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetMemoryWin32HandlePropertiesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<MemoryWin32HandlePropertiesKHR>::type getMemoryWin32HandlePropertiesKHR(
      ExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */
#endif   /*VK_USE_PLATFORM_WIN32_KHR*/

    //=== VK_KHR_external_memory_fd ===

    // wrapper function for command vkGetMemoryFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryFdKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetMemoryFdKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getMemoryFdKHR( MemoryGetFdInfoKHR const * pGetFdInfo,
                                                int *                      pFd,
                                                Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetMemoryFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryFdKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetMemoryFdKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<int>::type getMemoryFdKHR( MemoryGetFdInfoKHR const & getFdInfo,
                                                                             Dispatch const & d         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetMemoryFdPropertiesKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryFdPropertiesKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetMemoryFdPropertiesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getMemoryFdPropertiesKHR( ExternalMemoryHandleTypeFlagBits handleType,
                                                          int                              fd,
                                                          MemoryFdPropertiesKHR *          pMemoryFdProperties,
                                                          Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetMemoryFdPropertiesKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryFdPropertiesKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetMemoryFdPropertiesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<MemoryFdPropertiesKHR>::type
      getMemoryFdPropertiesKHR( ExternalMemoryHandleTypeFlagBits handleType, int fd, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#if defined( VK_USE_PLATFORM_WIN32_KHR )
    //=== VK_KHR_external_semaphore_win32 ===

    // wrapper function for command vkImportSemaphoreWin32HandleKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportSemaphoreWin32HandleKHR.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkImportSemaphoreWin32HandleKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result importSemaphoreWin32HandleKHR( ImportSemaphoreWin32HandleInfoKHR const * pImportSemaphoreWin32HandleInfo,
                                                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkImportSemaphoreWin32HandleKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportSemaphoreWin32HandleKHR.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkImportSemaphoreWin32HandleKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      importSemaphoreWin32HandleKHR( ImportSemaphoreWin32HandleInfoKHR const & importSemaphoreWin32HandleInfo,
                                     Dispatch const & d                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetSemaphoreWin32HandleKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreWin32HandleKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetSemaphoreWin32HandleKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getSemaphoreWin32HandleKHR( SemaphoreGetWin32HandleInfoKHR const * pGetWin32HandleInfo,
                                                            HANDLE *                               pHandle,
                                                            Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetSemaphoreWin32HandleKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreWin32HandleKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetSemaphoreWin32HandleKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<HANDLE>::type getSemaphoreWin32HandleKHR( SemaphoreGetWin32HandleInfoKHR const & getWin32HandleInfo,
                                                                                            Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */
#endif   /*VK_USE_PLATFORM_WIN32_KHR*/

    //=== VK_KHR_external_semaphore_fd ===

    // wrapper function for command vkImportSemaphoreFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportSemaphoreFdKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkImportSemaphoreFdKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result importSemaphoreFdKHR( ImportSemaphoreFdInfoKHR const * pImportSemaphoreFdInfo,
                                                      Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkImportSemaphoreFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportSemaphoreFdKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkImportSemaphoreFdKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      importSemaphoreFdKHR( ImportSemaphoreFdInfoKHR const & importSemaphoreFdInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetSemaphoreFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreFdKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetSemaphoreFdKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getSemaphoreFdKHR( SemaphoreGetFdInfoKHR const * pGetFdInfo,
                                                   int *                         pFd,
                                                   Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetSemaphoreFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreFdKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetSemaphoreFdKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<int>::type getSemaphoreFdKHR( SemaphoreGetFdInfoKHR const & getFdInfo,
                                                                                Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_descriptor_update_template ===

    // wrapper function for command vkCreateDescriptorUpdateTemplateKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorUpdateTemplateKHR.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorUpdateTemplateKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createDescriptorUpdateTemplateKHR( DescriptorUpdateTemplateCreateInfo const * pCreateInfo,
                                                                   AllocationCallbacks const *                pAllocator,
                                                                   DescriptorUpdateTemplate *                 pDescriptorUpdateTemplate,
                                                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateDescriptorUpdateTemplateKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorUpdateTemplateKHR.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorUpdateTemplateKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<DescriptorUpdateTemplate>::type
      createDescriptorUpdateTemplateKHR( DescriptorUpdateTemplateCreateInfo const &    createInfo,
                                         Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                         Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateDescriptorUpdateTemplateKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorUpdateTemplateKHR.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateDescriptorUpdateTemplateKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<DescriptorUpdateTemplate, Dispatch>>::type
      createDescriptorUpdateTemplateKHRUnique( DescriptorUpdateTemplateCreateInfo const &    createInfo,
                                               Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                               Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyDescriptorUpdateTemplateKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorUpdateTemplateKHR.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorUpdateTemplateKHR ), bool>::type = true>
    void destroyDescriptorUpdateTemplateKHR( DescriptorUpdateTemplate    descriptorUpdateTemplate,
                                             AllocationCallbacks const * pAllocator,
                                             Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyDescriptorUpdateTemplateKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorUpdateTemplateKHR.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyDescriptorUpdateTemplateKHR ), bool>::type = true>
    void destroyDescriptorUpdateTemplateKHR( DescriptorUpdateTemplate descriptorUpdateTemplate VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                             Optional<AllocationCallbacks const> allocator     VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                             Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkUpdateDescriptorSetWithTemplateKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateDescriptorSetWithTemplateKHR.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkUpdateDescriptorSetWithTemplateKHR ), bool>::type = true>
    void updateDescriptorSetWithTemplateKHR( DescriptorSet            descriptorSet,
                                             DescriptorUpdateTemplate descriptorUpdateTemplate,
                                             void const *             pData,
                                             Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkUpdateDescriptorSetWithTemplateKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateDescriptorSetWithTemplateKHR.html
    template <typename DataType,
              typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkUpdateDescriptorSetWithTemplateKHR ), bool>::type = true>
    void updateDescriptorSetWithTemplateKHR( DescriptorSet            descriptorSet,
                                             DescriptorUpdateTemplate descriptorUpdateTemplate,
                                             DataType const &         data,
                                             Dispatch const & d       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_display_control ===

    // wrapper function for command vkDisplayPowerControlEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDisplayPowerControlEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDisplayPowerControlEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result displayPowerControlEXT( DisplayKHR                  display,
                                                        DisplayPowerInfoEXT const * pDisplayPowerInfo,
                                                        Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDisplayPowerControlEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDisplayPowerControlEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkDisplayPowerControlEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type displayPowerControlEXT(
      DisplayKHR display, DisplayPowerInfoEXT const & displayPowerInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkRegisterDeviceEventEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkRegisterDeviceEventEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkRegisterDeviceEventEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result registerEventEXT( DeviceEventInfoEXT const *  pDeviceEventInfo,
                                                  AllocationCallbacks const * pAllocator,
                                                  Fence *                     pFence,
                                                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkRegisterDeviceEventEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkRegisterDeviceEventEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkRegisterDeviceEventEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<Fence>::type
      registerEventEXT( DeviceEventInfoEXT const &                    deviceEventInfo,
                        Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                        Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkRegisterDeviceEventEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkRegisterDeviceEventEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkRegisterDeviceEventEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<Fence, Dispatch>>::type
      registerEventEXTUnique( DeviceEventInfoEXT const &                    deviceEventInfo,
                              Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                              Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkRegisterDisplayEventEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkRegisterDisplayEventEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkRegisterDisplayEventEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result registerDisplayEventEXT( DisplayKHR                  display,
                                                         DisplayEventInfoEXT const * pDisplayEventInfo,
                                                         AllocationCallbacks const * pAllocator,
                                                         Fence *                     pFence,
                                                         Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkRegisterDisplayEventEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkRegisterDisplayEventEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkRegisterDisplayEventEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<Fence>::type
      registerDisplayEventEXT( DisplayKHR                                    display,
                               DisplayEventInfoEXT const &                   displayEventInfo,
                               Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                               Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkRegisterDisplayEventEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkRegisterDisplayEventEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkRegisterDisplayEventEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<Fence, Dispatch>>::type
      registerDisplayEventEXTUnique( DisplayKHR                                    display,
                                     DisplayEventInfoEXT const &                   displayEventInfo,
                                     Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                     Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetSwapchainCounterEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSwapchainCounterEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetSwapchainCounterEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getSwapchainCounterEXT( SwapchainKHR              swapchain,
                                                        SurfaceCounterFlagBitsEXT counter,
                                                        uint64_t *                pCounterValue,
                                                        Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetSwapchainCounterEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSwapchainCounterEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetSwapchainCounterEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD
#  if defined( VULKAN_HPP_HANDLE_ERROR_OUT_OF_DATE_AS_SUCCESS )
      ResultValue<uint64_t>
#  else
      typename ResultValueType<uint64_t>::type
#  endif
      getSwapchainCounterEXT( SwapchainKHR swapchain, SurfaceCounterFlagBitsEXT counter, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_GOOGLE_display_timing ===

    // wrapper function for command vkGetRefreshCycleDurationGOOGLE, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRefreshCycleDurationGOOGLE.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetRefreshCycleDurationGOOGLE ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getRefreshCycleDurationGOOGLE( SwapchainKHR                 swapchain,
                                                               RefreshCycleDurationGOOGLE * pDisplayTimingProperties,
                                                               Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetRefreshCycleDurationGOOGLE, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRefreshCycleDurationGOOGLE.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetRefreshCycleDurationGOOGLE ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<RefreshCycleDurationGOOGLE>::type
      getRefreshCycleDurationGOOGLE( SwapchainKHR swapchain, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetPastPresentationTimingGOOGLE, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPastPresentationTimingGOOGLE.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetPastPresentationTimingGOOGLE ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getPastPresentationTimingGOOGLE( SwapchainKHR                   swapchain,
                                                                 uint32_t *                     pPresentationTimingCount,
                                                                 PastPresentationTimingGOOGLE * pPresentationTimings,
                                                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetPastPresentationTimingGOOGLE, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPastPresentationTimingGOOGLE.html
    template <
      typename PastPresentationTimingGOOGLEAllocator = std::allocator<PastPresentationTimingGOOGLE>,
      typename Dispatch                              = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
      typename std::enable_if<std::is_same<typename PastPresentationTimingGOOGLEAllocator::value_type, PastPresentationTimingGOOGLE>::value, int>::type = 0,
      typename std::enable_if<IS_DISPATCHED( vkGetPastPresentationTimingGOOGLE ), bool>::type                                                           = true>
    VULKAN_HPP_NODISCARD
#  if defined( VULKAN_HPP_HANDLE_ERROR_OUT_OF_DATE_AS_SUCCESS )
      ResultValue<std::vector<PastPresentationTimingGOOGLE, PastPresentationTimingGOOGLEAllocator>>
#  else
      typename ResultValueType<std::vector<PastPresentationTimingGOOGLE, PastPresentationTimingGOOGLEAllocator>>::type
#  endif
      getPastPresentationTimingGOOGLE( SwapchainKHR swapchain, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetPastPresentationTimingGOOGLE, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPastPresentationTimingGOOGLE.html
    template <
      typename PastPresentationTimingGOOGLEAllocator = std::allocator<PastPresentationTimingGOOGLE>,
      typename Dispatch                              = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
      typename std::enable_if<std::is_same<typename PastPresentationTimingGOOGLEAllocator::value_type, PastPresentationTimingGOOGLE>::value, int>::type = 0,
      typename std::enable_if<IS_DISPATCHED( vkGetPastPresentationTimingGOOGLE ), bool>::type                                                           = true>
    VULKAN_HPP_NODISCARD
#  if defined( VULKAN_HPP_HANDLE_ERROR_OUT_OF_DATE_AS_SUCCESS )
      ResultValue<std::vector<PastPresentationTimingGOOGLE, PastPresentationTimingGOOGLEAllocator>>
#  else
      typename ResultValueType<std::vector<PastPresentationTimingGOOGLE, PastPresentationTimingGOOGLEAllocator>>::type
#  endif
      getPastPresentationTimingGOOGLE( SwapchainKHR                                  swapchain,
                                       PastPresentationTimingGOOGLEAllocator const & pastPresentationTimingGOOGLEAllocator,
                                       Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_EXT_hdr_metadata ===

    // wrapper function for command vkSetHdrMetadataEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetHdrMetadataEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSetHdrMetadataEXT ), bool>::type = true>
    void setHdrMetadataEXT( uint32_t               swapchainCount,
                            SwapchainKHR const *   pSwapchains,
                            HdrMetadataEXT const * pMetadata,
                            Dispatch const & d     VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkSetHdrMetadataEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetHdrMetadataEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSetHdrMetadataEXT ), bool>::type = true>
    void setHdrMetadataEXT( ArrayProxy<SwapchainKHR const> const &   swapchains,
                            ArrayProxy<HdrMetadataEXT const> const & metadata,
                            Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_create_renderpass2 ===

    // wrapper function for command vkCreateRenderPass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateRenderPass2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createRenderPass2KHR( RenderPassCreateInfo2 const * pCreateInfo,
                                                      AllocationCallbacks const *   pAllocator,
                                                      RenderPass *                  pRenderPass,
                                                      Dispatch const & d            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateRenderPass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateRenderPass2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<RenderPass>::type
      createRenderPass2KHR( RenderPassCreateInfo2 const &                 createInfo,
                            Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                            Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateRenderPass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass2KHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkCreateRenderPass2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<RenderPass, Dispatch>>::type
      createRenderPass2KHRUnique( RenderPassCreateInfo2 const &                 createInfo,
                                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_shared_presentable_image ===

#ifdef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetSwapchainStatusKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSwapchainStatusKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetSwapchainStatusKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getSwapchainStatusKHR( SwapchainKHR       swapchain,
                                                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#else
    // wrapper function for command vkGetSwapchainStatusKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSwapchainStatusKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetSwapchainStatusKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getSwapchainStatusKHR( SwapchainKHR swapchain, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

#if defined( VK_USE_PLATFORM_WIN32_KHR )
    //=== VK_KHR_external_fence_win32 ===

    // wrapper function for command vkImportFenceWin32HandleKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportFenceWin32HandleKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkImportFenceWin32HandleKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result importFenceWin32HandleKHR( ImportFenceWin32HandleInfoKHR const * pImportFenceWin32HandleInfo,
                                                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkImportFenceWin32HandleKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportFenceWin32HandleKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkImportFenceWin32HandleKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      importFenceWin32HandleKHR( ImportFenceWin32HandleInfoKHR const & importFenceWin32HandleInfo,
                                 Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetFenceWin32HandleKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetFenceWin32HandleKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetFenceWin32HandleKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getFenceWin32HandleKHR( FenceGetWin32HandleInfoKHR const * pGetWin32HandleInfo,
                                                        HANDLE *                           pHandle,
                                                        Dispatch const & d                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetFenceWin32HandleKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetFenceWin32HandleKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetFenceWin32HandleKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<HANDLE>::type getFenceWin32HandleKHR( FenceGetWin32HandleInfoKHR const & getWin32HandleInfo,
                                                                                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */
#endif   /*VK_USE_PLATFORM_WIN32_KHR*/

    //=== VK_KHR_external_fence_fd ===

    // wrapper function for command vkImportFenceFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportFenceFdKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkImportFenceFdKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result importFenceFdKHR( ImportFenceFdInfoKHR const * pImportFenceFdInfo,
                                                  Dispatch const & d           VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkImportFenceFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportFenceFdKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkImportFenceFdKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      importFenceFdKHR( ImportFenceFdInfoKHR const & importFenceFdInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetFenceFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetFenceFdKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetFenceFdKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getFenceFdKHR( FenceGetFdInfoKHR const * pGetFdInfo,
                                               int *                     pFd,
                                               Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetFenceFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetFenceFdKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkGetFenceFdKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<int>::type getFenceFdKHR( FenceGetFdInfoKHR const & getFdInfo,
                                                                            Dispatch const & d        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_performance_query ===

    // wrapper function for command vkAcquireProfilingLockKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireProfilingLockKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkAcquireProfilingLockKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result acquireProfilingLockKHR( AcquireProfilingLockInfoKHR const * pInfo,
                                                         Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkAcquireProfilingLockKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireProfilingLockKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkAcquireProfilingLockKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      acquireProfilingLockKHR( AcquireProfilingLockInfoKHR const & info, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkReleaseProfilingLockKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkReleaseProfilingLockKHR.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkReleaseProfilingLockKHR ), bool>::type = true>
    void releaseProfilingLockKHR( Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_EXT_debug_utils ===

    // wrapper function for command vkSetDebugUtilsObjectNameEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetDebugUtilsObjectNameEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSetDebugUtilsObjectNameEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result setDebugUtilsObjectNameEXT( DebugUtilsObjectNameInfoEXT const * pNameInfo,
                                                            Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkSetDebugUtilsObjectNameEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetDebugUtilsObjectNameEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSetDebugUtilsObjectNameEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      setDebugUtilsObjectNameEXT( DebugUtilsObjectNameInfoEXT const & nameInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkSetDebugUtilsObjectNameEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetDebugUtilsObjectNameEXT.html
    template <typename HandleType,
              typename Dispatch                                                                  = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkSetDebugUtilsObjectNameEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      setDebugUtilsObjectNameEXT( HandleType const & handle, std::string const & name, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkSetDebugUtilsObjectTagEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetDebugUtilsObjectTagEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSetDebugUtilsObjectTagEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result setDebugUtilsObjectTagEXT( DebugUtilsObjectTagInfoEXT const * pTagInfo,
                                                           Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkSetDebugUtilsObjectTagEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetDebugUtilsObjectTagEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkSetDebugUtilsObjectTagEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      setDebugUtilsObjectTagEXT( DebugUtilsObjectTagInfoEXT const & tagInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkSetDebugUtilsObjectTagEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetDebugUtilsObjectTagEXT.html
    template <typename HandleType,
              typename TagType,
              typename Dispatch                                                                  = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkSetDebugUtilsObjectNameEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type setDebugUtilsObjectTagEXT(
      HandleType const & handle, uint64_t name, TagType const & tag, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
    //=== VK_ANDROID_external_memory_android_hardware_buffer ===

    // wrapper function for command vkGetAndroidHardwareBufferPropertiesANDROID, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAndroidHardwareBufferPropertiesANDROID.html
    template <typename Dispatch                                                                                 = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetAndroidHardwareBufferPropertiesANDROID ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result
      getAndroidHardwareBufferPropertiesANDROID( const struct AHardwareBuffer *           buffer,
                                                 AndroidHardwareBufferPropertiesANDROID * pProperties,
                                                 Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetAndroidHardwareBufferPropertiesANDROID, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAndroidHardwareBufferPropertiesANDROID.html
    template <typename Dispatch                                                                                 = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetAndroidHardwareBufferPropertiesANDROID ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<AndroidHardwareBufferPropertiesANDROID>::type
      getAndroidHardwareBufferPropertiesANDROID( const struct AHardwareBuffer & buffer, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetAndroidHardwareBufferPropertiesANDROID, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAndroidHardwareBufferPropertiesANDROID.html
    template <typename X,
              typename Y,
              typename... Z,
              typename Dispatch                                                                                 = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetAndroidHardwareBufferPropertiesANDROID ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<StructureChain<X, Y, Z...>>::type
      getAndroidHardwareBufferPropertiesANDROID( const struct AHardwareBuffer & buffer, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetMemoryAndroidHardwareBufferANDROID, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryAndroidHardwareBufferANDROID.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetMemoryAndroidHardwareBufferANDROID ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getMemoryAndroidHardwareBufferANDROID( MemoryGetAndroidHardwareBufferInfoANDROID const * pInfo,
                                                                       struct AHardwareBuffer **                         pBuffer,
                                                                       Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetMemoryAndroidHardwareBufferANDROID, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryAndroidHardwareBufferANDROID.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetMemoryAndroidHardwareBufferANDROID ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<struct AHardwareBuffer *>::type
      getMemoryAndroidHardwareBufferANDROID( MemoryGetAndroidHardwareBufferInfoANDROID const & info,
                                             Dispatch const & d                                VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */
#endif   /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_ENABLE_BETA_EXTENSIONS )
    //=== VK_AMDX_shader_enqueue ===

    // wrapper function for command vkCreateExecutionGraphPipelinesAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateExecutionGraphPipelinesAMDX.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateExecutionGraphPipelinesAMDX ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createExecutionGraphPipelinesAMDX( PipelineCache                                pipelineCache,
                                                                   uint32_t                                     createInfoCount,
                                                                   ExecutionGraphPipelineCreateInfoAMDX const * pCreateInfos,
                                                                   AllocationCallbacks const *                  pAllocator,
                                                                   Pipeline *                                   pPipelines,
                                                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateExecutionGraphPipelinesAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateExecutionGraphPipelinesAMDX.html
    template <typename PipelineAllocator                                                                                = std::allocator<Pipeline>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, Pipeline>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateExecutionGraphPipelinesAMDX ), bool>::type                 = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<Pipeline, PipelineAllocator>>
                         createExecutionGraphPipelinesAMDX( PipelineCache                                                  pipelineCache,
                                                            ArrayProxy<ExecutionGraphPipelineCreateInfoAMDX const> const & createInfos,
                                                            Optional<AllocationCallbacks const> allocator                  VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                            Dispatch const & d                                             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateExecutionGraphPipelinesAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateExecutionGraphPipelinesAMDX.html
    template <typename PipelineAllocator                                                                                = std::allocator<Pipeline>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, Pipeline>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateExecutionGraphPipelinesAMDX ), bool>::type                 = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<Pipeline, PipelineAllocator>>
                         createExecutionGraphPipelinesAMDX( PipelineCache                                                  pipelineCache,
                                                            ArrayProxy<ExecutionGraphPipelineCreateInfoAMDX const> const & createInfos,
                                                            Optional<AllocationCallbacks const>                            allocator,
                                                            PipelineAllocator const &                                      pipelineAllocator,
                                                            Dispatch const & d                                             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateExecutionGraphPipelinesAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateExecutionGraphPipelinesAMDX.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateExecutionGraphPipelinesAMDX ), bool>::type = true>
    VULKAN_HPP_NODISCARD ResultValue<Pipeline>
                         createExecutionGraphPipelineAMDX( PipelineCache                                 pipelineCache,
                                                           ExecutionGraphPipelineCreateInfoAMDX const &  createInfo,
                                                           Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                           Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#    ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateExecutionGraphPipelinesAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateExecutionGraphPipelinesAMDX.html
    template <typename Dispatch          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename PipelineAllocator = std::allocator<UniqueHandle<Pipeline, Dispatch>>,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, UniqueHandle<Pipeline, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateExecutionGraphPipelinesAMDX ), bool>::type                                         = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<UniqueHandle<Pipeline, Dispatch>, PipelineAllocator>>
                         createExecutionGraphPipelinesAMDXUnique( PipelineCache                                                  pipelineCache,
                                                                  ArrayProxy<ExecutionGraphPipelineCreateInfoAMDX const> const & createInfos,
                                                                  Optional<AllocationCallbacks const> allocator                  VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                                  Dispatch const & d                                             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateExecutionGraphPipelinesAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateExecutionGraphPipelinesAMDX.html
    template <typename Dispatch          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename PipelineAllocator = std::allocator<UniqueHandle<Pipeline, Dispatch>>,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, UniqueHandle<Pipeline, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateExecutionGraphPipelinesAMDX ), bool>::type                                         = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<UniqueHandle<Pipeline, Dispatch>, PipelineAllocator>>
                         createExecutionGraphPipelinesAMDXUnique( PipelineCache                                                  pipelineCache,
                                                                  ArrayProxy<ExecutionGraphPipelineCreateInfoAMDX const> const & createInfos,
                                                                  Optional<AllocationCallbacks const>                            allocator,
                                                                  PipelineAllocator const &                                      pipelineAllocator,
                                                                  Dispatch const & d                                             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateExecutionGraphPipelinesAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateExecutionGraphPipelinesAMDX.html
    template <typename Dispatch                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateExecutionGraphPipelinesAMDX ), bool>::type = true>
    VULKAN_HPP_NODISCARD ResultValue<UniqueHandle<Pipeline, Dispatch>>
                         createExecutionGraphPipelineAMDXUnique( PipelineCache                                 pipelineCache,
                                                                 ExecutionGraphPipelineCreateInfoAMDX const &  createInfo,
                                                                 Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                                 Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#    endif /* VULKAN_HPP_NO_SMART_HANDLE */
#  endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetExecutionGraphPipelineScratchSizeAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetExecutionGraphPipelineScratchSizeAMDX.html
    template <typename Dispatch                                                                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetExecutionGraphPipelineScratchSizeAMDX ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result
      getExecutionGraphPipelineScratchSizeAMDX( Pipeline                                executionGraph,
                                                ExecutionGraphPipelineScratchSizeAMDX * pSizeInfo,
                                                Dispatch const & d                      VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetExecutionGraphPipelineScratchSizeAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetExecutionGraphPipelineScratchSizeAMDX.html
    template <typename Dispatch                                                                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetExecutionGraphPipelineScratchSizeAMDX ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<ExecutionGraphPipelineScratchSizeAMDX>::type
      getExecutionGraphPipelineScratchSizeAMDX( Pipeline executionGraph, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetExecutionGraphPipelineNodeIndexAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetExecutionGraphPipelineNodeIndexAMDX.html
    template <typename Dispatch                                                                              = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetExecutionGraphPipelineNodeIndexAMDX ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getExecutionGraphPipelineNodeIndexAMDX( Pipeline                                      executionGraph,
                                                                        PipelineShaderStageNodeCreateInfoAMDX const * pNodeInfo,
                                                                        uint32_t *                                    pNodeIndex,
                                                                        Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#  ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetExecutionGraphPipelineNodeIndexAMDX, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetExecutionGraphPipelineNodeIndexAMDX.html
    template <typename Dispatch                                                                              = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetExecutionGraphPipelineNodeIndexAMDX ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<uint32_t>::type getExecutionGraphPipelineNodeIndexAMDX(
      Pipeline executionGraph, PipelineShaderStageNodeCreateInfoAMDX const & nodeInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */
#endif   /*VK_ENABLE_BETA_EXTENSIONS*/

    //=== VK_EXT_descriptor_heap ===

    // wrapper function for command vkWriteSamplerDescriptorsEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkWriteSamplerDescriptorsEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkWriteSamplerDescriptorsEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result writeSamplerDescriptorsEXT( uint32_t                    samplerCount,
                                                            SamplerCreateInfo const *   pSamplers,
                                                            HostAddressRangeEXT const * pDescriptors,
                                                            Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkWriteSamplerDescriptorsEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkWriteSamplerDescriptorsEXT.html
    template <typename Dispatch = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE, typename std::enable_if<IS_DISPATCHED( vkWriteSamplerDescriptorsEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      writeSamplerDescriptorsEXT( ArrayProxy<SamplerCreateInfo const> const &   samplers,
                                  ArrayProxy<HostAddressRangeEXT const> const & descriptors,
                                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkWriteResourceDescriptorsEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkWriteResourceDescriptorsEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkWriteResourceDescriptorsEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result writeResourceDescriptorsEXT( uint32_t                          resourceCount,
                                                             ResourceDescriptorInfoEXT const * pResources,
                                                             HostAddressRangeEXT const *       pDescriptors,
                                                             Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkWriteResourceDescriptorsEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkWriteResourceDescriptorsEXT.html
    template <typename Dispatch                                                                   = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkWriteResourceDescriptorsEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD_WHEN_NO_EXCEPTIONS typename ResultValueType<void>::type
      writeResourceDescriptorsEXT( ArrayProxy<ResourceDescriptorInfoEXT const> const & resources,
                                   ArrayProxy<HostAddressRangeEXT const> const &       descriptors,
                                   Dispatch const & d                                  VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetImageOpaqueCaptureDataEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageOpaqueCaptureDataEXT.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetImageOpaqueCaptureDataEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getImageOpaqueCaptureDataEXT( uint32_t              imageCount,
                                                              Image const *         pImages,
                                                              HostAddressRangeEXT * pDatas,
                                                              Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkRegisterCustomBorderColorEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkRegisterCustomBorderColorEXT.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkRegisterCustomBorderColorEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result registerCustomBorderColorEXT( SamplerCustomBorderColorCreateInfoEXT const * pBorderColor,
                                                              Bool32                                        requestIndex,
                                                              uint32_t *                                    pIndex,
                                                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkRegisterCustomBorderColorEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkRegisterCustomBorderColorEXT.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkRegisterCustomBorderColorEXT ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<uint32_t>::type registerCustomBorderColorEXT(
      SamplerCustomBorderColorCreateInfoEXT const & borderColor, Bool32 requestIndex, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkUnregisterCustomBorderColorEXT, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUnregisterCustomBorderColorEXT.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkUnregisterCustomBorderColorEXT ), bool>::type = true>
    void unregisterCustomBorderColorEXT( uint32_t index, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    // wrapper function for command vkGetTensorOpaqueCaptureDataARM, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetTensorOpaqueCaptureDataARM.html
    template <typename Dispatch                                                                     = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetTensorOpaqueCaptureDataARM ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getTensorOpaqueCaptureDataARM( uint32_t              tensorCount,
                                                               TensorARM const *     pTensors,
                                                               HostAddressRangeEXT * pDatas,
                                                               Dispatch const & d    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_KHR_get_memory_requirements2 ===

    // wrapper function for command vkGetImageMemoryRequirements2KHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2KHR.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetImageMemoryRequirements2KHR ), bool>::type = true>
    void getImageMemoryRequirements2KHR( ImageMemoryRequirementsInfo2 const * pInfo,
                                         MemoryRequirements2 *                pMemoryRequirements,
                                         Dispatch const & d                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetImageMemoryRequirements2KHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2KHR.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetImageMemoryRequirements2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD MemoryRequirements2 getImageMemoryRequirements2KHR(
      ImageMemoryRequirementsInfo2 const & info, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
    // wrapper function for command vkGetImageMemoryRequirements2KHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2KHR.html
    template <typename X,
              typename Y,
              typename... Z,
              typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetImageMemoryRequirements2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                         getImageMemoryRequirements2KHR( ImageMemoryRequirementsInfo2 const & info,
                                                         Dispatch const & d                   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetBufferMemoryRequirements2KHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2KHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetBufferMemoryRequirements2KHR ), bool>::type = true>
    void getBufferMemoryRequirements2KHR( BufferMemoryRequirementsInfo2 const * pInfo,
                                          MemoryRequirements2 *                 pMemoryRequirements,
                                          Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetBufferMemoryRequirements2KHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2KHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetBufferMemoryRequirements2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD MemoryRequirements2 getBufferMemoryRequirements2KHR(
      BufferMemoryRequirementsInfo2 const & info, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
    // wrapper function for command vkGetBufferMemoryRequirements2KHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2KHR.html
    template <typename X,
              typename Y,
              typename... Z,
              typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetBufferMemoryRequirements2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                         getBufferMemoryRequirements2KHR( BufferMemoryRequirementsInfo2 const & info,
                                                          Dispatch const & d                    VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetImageSparseMemoryRequirements2KHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements2KHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetImageSparseMemoryRequirements2KHR ), bool>::type = true>
    void getImageSparseMemoryRequirements2KHR( ImageSparseMemoryRequirementsInfo2 const * pInfo,
                                               uint32_t *                                 pSparseMemoryRequirementCount,
                                               SparseImageMemoryRequirements2 *           pSparseMemoryRequirements,
                                               Dispatch const & d                         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetImageSparseMemoryRequirements2KHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements2KHR.html
    template <
      typename SparseImageMemoryRequirements2Allocator = std::allocator<SparseImageMemoryRequirements2>,
      typename Dispatch                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
      typename std::enable_if<std::is_same<typename SparseImageMemoryRequirements2Allocator::value_type, SparseImageMemoryRequirements2>::value, int>::type = 0,
      typename std::enable_if<IS_DISPATCHED( vkGetImageSparseMemoryRequirements2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements2, SparseImageMemoryRequirements2Allocator>
                         getImageSparseMemoryRequirements2KHR( ImageSparseMemoryRequirementsInfo2 const & info,
                                                               Dispatch const & d                         VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetImageSparseMemoryRequirements2KHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements2KHR.html
    template <
      typename SparseImageMemoryRequirements2Allocator = std::allocator<SparseImageMemoryRequirements2>,
      typename Dispatch                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
      typename std::enable_if<std::is_same<typename SparseImageMemoryRequirements2Allocator::value_type, SparseImageMemoryRequirements2>::value, int>::type = 0,
      typename std::enable_if<IS_DISPATCHED( vkGetImageSparseMemoryRequirements2KHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements2, SparseImageMemoryRequirements2Allocator>
                         getImageSparseMemoryRequirements2KHR( ImageSparseMemoryRequirementsInfo2 const &      info,
                                                               SparseImageMemoryRequirements2Allocator const & sparseImageMemoryRequirements2Allocator,
                                                               Dispatch const & d                              VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_acceleration_structure ===

    // wrapper function for command vkCreateAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateAccelerationStructureKHR.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateAccelerationStructureKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createAccelerationStructureKHR( AccelerationStructureCreateInfoKHR const * pCreateInfo,
                                                                AllocationCallbacks const *                pAllocator,
                                                                AccelerationStructureKHR *                 pAccelerationStructure,
                                                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateAccelerationStructureKHR.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateAccelerationStructureKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<AccelerationStructureKHR>::type
      createAccelerationStructureKHR( AccelerationStructureCreateInfoKHR const &    createInfo,
                                      Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                      Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateAccelerationStructureKHR.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateAccelerationStructureKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<AccelerationStructureKHR, Dispatch>>::type
      createAccelerationStructureKHRUnique( AccelerationStructureCreateInfoKHR const &    createInfo,
                                            Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                            Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyAccelerationStructureKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyAccelerationStructureKHR ), bool>::type = true>
    void destroyAccelerationStructureKHR( AccelerationStructureKHR    accelerationStructure,
                                          AllocationCallbacks const * pAllocator,
                                          Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyAccelerationStructureKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyAccelerationStructureKHR ), bool>::type = true>
    void destroyAccelerationStructureKHR( AccelerationStructureKHR accelerationStructure VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                          Optional<AllocationCallbacks const> allocator  VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                          Dispatch const & d                             VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroyAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyAccelerationStructureKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyAccelerationStructureKHR ), bool>::type = true>
    void destroy( AccelerationStructureKHR    accelerationStructure,
                  AllocationCallbacks const * pAllocator,
                  Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroyAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyAccelerationStructureKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroyAccelerationStructureKHR ), bool>::type = true>
    void destroy( AccelerationStructureKHR                      accelerationStructure,
                  Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                  Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkBuildAccelerationStructuresKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkBuildAccelerationStructuresKHR.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkBuildAccelerationStructuresKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result buildAccelerationStructuresKHR( DeferredOperationKHR                                   deferredOperation,
                                                                uint32_t                                               infoCount,
                                                                AccelerationStructureBuildGeometryInfoKHR const *      pInfos,
                                                                AccelerationStructureBuildRangeInfoKHR const * const * ppBuildRangeInfos,
                                                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkBuildAccelerationStructuresKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkBuildAccelerationStructuresKHR.html
    template <typename Dispatch                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkBuildAccelerationStructuresKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result buildAccelerationStructuresKHR( DeferredOperationKHR                                                     deferredOperation,
                                                                ArrayProxy<AccelerationStructureBuildGeometryInfoKHR const> const &      infos,
                                                                ArrayProxy<AccelerationStructureBuildRangeInfoKHR const * const> const & pBuildRangeInfos,
                                                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCopyAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyAccelerationStructureKHR.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCopyAccelerationStructureKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result copyAccelerationStructureKHR( DeferredOperationKHR                     deferredOperation,
                                                              CopyAccelerationStructureInfoKHR const * pInfo,
                                                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCopyAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyAccelerationStructureKHR.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCopyAccelerationStructureKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result copyAccelerationStructureKHR( DeferredOperationKHR                     deferredOperation,
                                                              CopyAccelerationStructureInfoKHR const & info,
                                                              Dispatch const & d                       VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCopyAccelerationStructureToMemoryKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyAccelerationStructureToMemoryKHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCopyAccelerationStructureToMemoryKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result copyAccelerationStructureToMemoryKHR( DeferredOperationKHR                             deferredOperation,
                                                                      CopyAccelerationStructureToMemoryInfoKHR const * pInfo,
                                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCopyAccelerationStructureToMemoryKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyAccelerationStructureToMemoryKHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCopyAccelerationStructureToMemoryKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result copyAccelerationStructureToMemoryKHR( DeferredOperationKHR                             deferredOperation,
                                                                      CopyAccelerationStructureToMemoryInfoKHR const & info,
                                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkCopyMemoryToAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyMemoryToAccelerationStructureKHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCopyMemoryToAccelerationStructureKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result copyMemoryToAccelerationStructureKHR( DeferredOperationKHR                             deferredOperation,
                                                                      CopyMemoryToAccelerationStructureInfoKHR const * pInfo,
                                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCopyMemoryToAccelerationStructureKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyMemoryToAccelerationStructureKHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCopyMemoryToAccelerationStructureKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result copyMemoryToAccelerationStructureKHR( DeferredOperationKHR                             deferredOperation,
                                                                      CopyMemoryToAccelerationStructureInfoKHR const & info,
                                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkWriteAccelerationStructuresPropertiesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkWriteAccelerationStructuresPropertiesKHR.html
    template <typename Dispatch                                                                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkWriteAccelerationStructuresPropertiesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result
      writeAccelerationStructuresPropertiesKHR( uint32_t                         accelerationStructureCount,
                                                AccelerationStructureKHR const * pAccelerationStructures,
                                                QueryType                        queryType,
                                                size_t                           dataSize,
                                                void *                           pData,
                                                size_t                           stride,
                                                Dispatch const & d               VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkWriteAccelerationStructuresPropertiesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkWriteAccelerationStructuresPropertiesKHR.html
    template <typename DataType,
              typename DataTypeAllocator                                                                                = std::allocator<DataType>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename DataTypeAllocator::value_type, DataType>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkWriteAccelerationStructuresPropertiesKHR ), bool>::type          = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DataType, DataTypeAllocator>>::type
      writeAccelerationStructuresPropertiesKHR( ArrayProxy<AccelerationStructureKHR const> const & accelerationStructures,
                                                QueryType                                          queryType,
                                                size_t                                             dataSize,
                                                size_t                                             stride,
                                                Dispatch const & d                                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkWriteAccelerationStructuresPropertiesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkWriteAccelerationStructuresPropertiesKHR.html
    template <typename DataType,
              typename Dispatch                                                                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkWriteAccelerationStructuresPropertiesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type
      writeAccelerationStructuresPropertyKHR( ArrayProxy<AccelerationStructureKHR const> const & accelerationStructures,
                                              QueryType                                          queryType,
                                              size_t                                             stride,
                                              Dispatch const & d                                 VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetAccelerationStructureDeviceAddressKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAccelerationStructureDeviceAddressKHR.html
    template <typename Dispatch                                                                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetAccelerationStructureDeviceAddressKHR ), bool>::type = true>
    DeviceAddress getAccelerationStructureAddressKHR( AccelerationStructureDeviceAddressInfoKHR const * pInfo,
                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetAccelerationStructureDeviceAddressKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAccelerationStructureDeviceAddressKHR.html
    template <typename Dispatch                                                                                = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetAccelerationStructureDeviceAddressKHR ), bool>::type = true>
    DeviceAddress getAccelerationStructureAddressKHR( AccelerationStructureDeviceAddressInfoKHR const & info,
                                                      Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetDeviceAccelerationStructureCompatibilityKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceAccelerationStructureCompatibilityKHR.html
    template <typename Dispatch                                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceAccelerationStructureCompatibilityKHR ), bool>::type = true>
    void getAccelerationStructureCompatibilityKHR( AccelerationStructureVersionInfoKHR const * pVersionInfo,
                                                   AccelerationStructureCompatibilityKHR *     pCompatibility,
                                                   Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetDeviceAccelerationStructureCompatibilityKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceAccelerationStructureCompatibilityKHR.html
    template <typename Dispatch                                                                                      = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetDeviceAccelerationStructureCompatibilityKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD AccelerationStructureCompatibilityKHR getAccelerationStructureCompatibilityKHR(
      AccelerationStructureVersionInfoKHR const & versionInfo, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetAccelerationStructureBuildSizesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAccelerationStructureBuildSizesKHR.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetAccelerationStructureBuildSizesKHR ), bool>::type = true>
    void getAccelerationStructureBuildSizesKHR( AccelerationStructureBuildTypeKHR                 buildType,
                                                AccelerationStructureBuildGeometryInfoKHR const * pBuildInfo,
                                                uint32_t const *                                  pMaxPrimitiveCounts,
                                                AccelerationStructureBuildSizesInfoKHR *          pSizeInfo,
                                                Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetAccelerationStructureBuildSizesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAccelerationStructureBuildSizesKHR.html
    template <typename Dispatch                                                                             = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetAccelerationStructureBuildSizesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD AccelerationStructureBuildSizesInfoKHR
      getAccelerationStructureBuildSizesKHR( AccelerationStructureBuildTypeKHR                     buildType,
                                             AccelerationStructureBuildGeometryInfoKHR const &     buildInfo,
                                             ArrayProxy<uint32_t const> const & maxPrimitiveCounts VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                             Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    //=== VK_KHR_ray_tracing_pipeline ===

    // wrapper function for command vkCreateRayTracingPipelinesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRayTracingPipelinesKHR.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateRayTracingPipelinesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createRayTracingPipelinesKHR( DeferredOperationKHR                    deferredOperation,
                                                              PipelineCache                           pipelineCache,
                                                              uint32_t                                createInfoCount,
                                                              RayTracingPipelineCreateInfoKHR const * pCreateInfos,
                                                              AllocationCallbacks const *             pAllocator,
                                                              Pipeline *                              pPipelines,
                                                              Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateRayTracingPipelinesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRayTracingPipelinesKHR.html
    template <typename PipelineAllocator                                                                                = std::allocator<Pipeline>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, Pipeline>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateRayTracingPipelinesKHR ), bool>::type                      = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<Pipeline, PipelineAllocator>>
                         createRayTracingPipelinesKHR( DeferredOperationKHR                                      deferredOperation,
                                                       PipelineCache                                             pipelineCache,
                                                       ArrayProxy<RayTracingPipelineCreateInfoKHR const> const & createInfos,
                                                       Optional<AllocationCallbacks const> allocator             VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                       Dispatch const & d                                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateRayTracingPipelinesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRayTracingPipelinesKHR.html
    template <typename PipelineAllocator                                                                                = std::allocator<Pipeline>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, Pipeline>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateRayTracingPipelinesKHR ), bool>::type                      = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<Pipeline, PipelineAllocator>>
                         createRayTracingPipelinesKHR( DeferredOperationKHR                                      deferredOperation,
                                                       PipelineCache                                             pipelineCache,
                                                       ArrayProxy<RayTracingPipelineCreateInfoKHR const> const & createInfos,
                                                       Optional<AllocationCallbacks const>                       allocator,
                                                       PipelineAllocator const &                                 pipelineAllocator,
                                                       Dispatch const & d                                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateRayTracingPipelinesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRayTracingPipelinesKHR.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateRayTracingPipelinesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD ResultValue<Pipeline>
                         createRayTracingPipelineKHR( DeferredOperationKHR                          deferredOperation,
                                                      PipelineCache                                 pipelineCache,
                                                      RayTracingPipelineCreateInfoKHR const &       createInfo,
                                                      Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                      Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateRayTracingPipelinesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRayTracingPipelinesKHR.html
    template <typename Dispatch          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename PipelineAllocator = std::allocator<UniqueHandle<Pipeline, Dispatch>>,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, UniqueHandle<Pipeline, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateRayTracingPipelinesKHR ), bool>::type                                              = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<UniqueHandle<Pipeline, Dispatch>, PipelineAllocator>>
                         createRayTracingPipelinesKHRUnique( DeferredOperationKHR                                      deferredOperation,
                                                             PipelineCache                                             pipelineCache,
                                                             ArrayProxy<RayTracingPipelineCreateInfoKHR const> const & createInfos,
                                                             Optional<AllocationCallbacks const> allocator             VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                             Dispatch const & d                                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateRayTracingPipelinesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRayTracingPipelinesKHR.html
    template <typename Dispatch          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename PipelineAllocator = std::allocator<UniqueHandle<Pipeline, Dispatch>>,
              typename std::enable_if<std::is_same<typename PipelineAllocator::value_type, UniqueHandle<Pipeline, Dispatch>>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkCreateRayTracingPipelinesKHR ), bool>::type                                              = true>
    VULKAN_HPP_NODISCARD ResultValue<std::vector<UniqueHandle<Pipeline, Dispatch>, PipelineAllocator>>
                         createRayTracingPipelinesKHRUnique( DeferredOperationKHR                                      deferredOperation,
                                                             PipelineCache                                             pipelineCache,
                                                             ArrayProxy<RayTracingPipelineCreateInfoKHR const> const & createInfos,
                                                             Optional<AllocationCallbacks const>                       allocator,
                                                             PipelineAllocator const &                                 pipelineAllocator,
                                                             Dispatch const & d                                        VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkCreateRayTracingPipelinesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRayTracingPipelinesKHR.html
    template <typename Dispatch                                                                    = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateRayTracingPipelinesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD ResultValue<UniqueHandle<Pipeline, Dispatch>>
                         createRayTracingPipelineKHRUnique( DeferredOperationKHR                          deferredOperation,
                                                            PipelineCache                                 pipelineCache,
                                                            RayTracingPipelineCreateInfoKHR const &       createInfo,
                                                            Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                                            Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetRayTracingShaderGroupHandlesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingShaderGroupHandlesKHR.html
    template <typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetRayTracingShaderGroupHandlesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getRayTracingShaderGroupHandlesKHR( Pipeline           pipeline,
                                                                    uint32_t           firstGroup,
                                                                    uint32_t           groupCount,
                                                                    size_t             dataSize,
                                                                    void *             pData,
                                                                    Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetRayTracingShaderGroupHandlesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingShaderGroupHandlesKHR.html
    template <typename DataType,
              typename DataTypeAllocator                                                                                = std::allocator<DataType>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename DataTypeAllocator::value_type, DataType>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetRayTracingShaderGroupHandlesKHR ), bool>::type                = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DataType, DataTypeAllocator>>::type getRayTracingShaderGroupHandlesKHR(
      Pipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetRayTracingShaderGroupHandlesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingShaderGroupHandlesKHR.html
    template <typename DataType,
              typename Dispatch                                                                          = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetRayTracingShaderGroupHandlesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type getRayTracingShaderGroupHandleKHR(
      Pipeline pipeline, uint32_t firstGroup, uint32_t groupCount, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetRayTracingCaptureReplayShaderGroupHandlesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingCaptureReplayShaderGroupHandlesKHR.html
    template <typename Dispatch                                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetRayTracingCaptureReplayShaderGroupHandlesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result getRayTracingCaptureReplayShaderGroupHandlesKHR(
      Pipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void * pData, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT )
      const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkGetRayTracingCaptureReplayShaderGroupHandlesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingCaptureReplayShaderGroupHandlesKHR.html
    template <typename DataType,
              typename DataTypeAllocator                                                                                = std::allocator<DataType>,
              typename Dispatch                                                                                         = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<std::is_same<typename DataTypeAllocator::value_type, DataType>::value, int>::type = 0,
              typename std::enable_if<IS_DISPATCHED( vkGetRayTracingCaptureReplayShaderGroupHandlesKHR ), bool>::type   = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DataType, DataTypeAllocator>>::type getRayTracingCaptureReplayShaderGroupHandlesKHR(
      Pipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
    // wrapper function for command vkGetRayTracingCaptureReplayShaderGroupHandlesKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingCaptureReplayShaderGroupHandlesKHR.html
    template <typename DataType,
              typename Dispatch                                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetRayTracingCaptureReplayShaderGroupHandlesKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type getRayTracingCaptureReplayShaderGroupHandleKHR(
      Pipeline pipeline, uint32_t firstGroup, uint32_t groupCount, Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#endif /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkGetRayTracingShaderGroupStackSizeKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingShaderGroupStackSizeKHR.html
    template <typename Dispatch                                                                            = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkGetRayTracingShaderGroupStackSizeKHR ), bool>::type = true>
    DeviceSize getRayTracingShaderGroupStackSizeKHR( Pipeline             pipeline,
                                                     uint32_t             group,
                                                     ShaderGroupShaderKHR groupShader,
                                                     Dispatch const & d   VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;

    //=== VK_KHR_sampler_ycbcr_conversion ===

    // wrapper function for command vkCreateSamplerYcbcrConversionKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSamplerYcbcrConversionKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateSamplerYcbcrConversionKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD Result createSamplerYcbcrConversionKHR( SamplerYcbcrConversionCreateInfo const * pCreateInfo,
                                                                 AllocationCallbacks const *              pAllocator,
                                                                 SamplerYcbcrConversion *                 pYcbcrConversion,
                                                                 Dispatch const & d VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkCreateSamplerYcbcrConversionKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSamplerYcbcrConversionKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateSamplerYcbcrConversionKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<SamplerYcbcrConversion>::type
      createSamplerYcbcrConversionKHR( SamplerYcbcrConversionCreateInfo const &      createInfo,
                                       Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                       Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  ifndef VULKAN_HPP_NO_SMART_HANDLE
    // wrapper function for command vkCreateSamplerYcbcrConversionKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSamplerYcbcrConversionKHR.html
    template <typename Dispatch                                                                       = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkCreateSamplerYcbcrConversionKHR ), bool>::type = true>
    VULKAN_HPP_NODISCARD typename ResultValueType<UniqueHandle<SamplerYcbcrConversion, Dispatch>>::type
      createSamplerYcbcrConversionKHRUnique( SamplerYcbcrConversionCreateInfo const &      createInfo,
                                             Optional<AllocationCallbacks const> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                             Dispatch const & d                            VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const;
#  endif /* VULKAN_HPP_NO_SMART_HANDLE */
#endif   /* VULKAN_HPP_DISABLE_ENHANCED_MODE */

    // wrapper function for command vkDestroySamplerYcbcrConversionKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySamplerYcbcrConversionKHR.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroySamplerYcbcrConversionKHR ), bool>::type = true>
    void destroySamplerYcbcrConversionKHR( SamplerYcbcrConversion      ycbcrConversion,
                                           AllocationCallbacks const * pAllocator,
                                           Dispatch const & d          VULKAN_HPP_DEFAULT_DISPATCHER_ASSIGNMENT ) const VULKAN_HPP_NOEXCEPT;
#ifndef VULKAN_HPP_DISABLE_ENHANCED_MODE
    // wrapper function for command vkDestroySamplerYcbcrConversionKHR, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySamplerYcbcrConversionKHR.html
    template <typename Dispatch                                                                        = VULKAN_HPP_DEFAULT_DISPATCHER_TYPE,
              typename std::enable_if<IS_DISPATCHED( vkDestroySamplerYcbcrConversionKHR ), bool>::type = true>
    void destroySamplerYcbcrConversionKHR( SamplerY