// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStridedTypeUInt16Array
 * @brief   strided implicit array of vtkTypeUInt16.
 *
 * vtkStridedTypeUInt16Array is an strided implicit array of values of type vtkTypeUInt16.
 * see vtkStridedArray, vtkStridedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStridedTypeUInt16Array_h
#define vtkStridedTypeUInt16Array_h

#include "vtkStridedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStridedArray<vtkTypeUInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStridedTypeUInt16Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStridedTypeUInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStridedTypeUInt16Array* New();
  static vtkStridedTypeUInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt16);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStridedTypeUInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStridedTypeUInt16Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set the parameters for the strided backend.
   */
  void ConstructBackend(const vtkTypeUInt16* buffer, vtkIdType stride, int components, vtkIdType offset);
  void ConstructBackend(const vtkTypeUInt16* buffer, vtkIdType stride, int components);
  void ConstructBackend(const vtkTypeUInt16* buffer, vtkIdType stride);
  ///@}

protected:
  vtkStridedTypeUInt16Array();
  ~vtkStridedTypeUInt16Array() override;

private:
  typedef vtkStridedArray<vtkTypeUInt16> RealSuperclass;

  vtkStridedTypeUInt16Array(const vtkStridedTypeUInt16Array&) = delete;
  void operator=(const vtkStridedTypeUInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStridedTypeUInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
