// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeTypeInt16Array
 * @brief   composite implicit array of vtkTypeInt16.
 *
 * vtkCompositeTypeInt16Array is a composite implicit array of values of type vtkTypeInt16.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkCompositeTypeInt16Array_h
#define vtkCompositeTypeInt16Array_h

#include "vtkCompositeArray.h"   // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<vtkTypeInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT  vtkCompositeTypeInt16Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeTypeInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeTypeInt16Array* New();
  static vtkCompositeTypeInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt16);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeTypeInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeTypeInt16Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeTypeInt16Array();
  ~vtkCompositeTypeInt16Array() override;

private:
  typedef vtkCompositeArray<vtkTypeInt16> RealSuperclass;

  vtkCompositeTypeInt16Array(const vtkCompositeTypeInt16Array&) = delete;
  void operator=(const vtkCompositeTypeInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeTypeInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
