// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkAffineUnsignedShortArray
 * @brief   affine implicit array of unsigned short.
 *
 * vtkAffineUnsignedShortArray is an affine implicit array of values of type unsigned short.
 * see vtkAffineArray, vtkAffineImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkAffineUnsignedShortArray_h
#define vtkAffineUnsignedShortArray_h

#include "vtkAffineArray.h"      // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkAffineArray<unsigned short>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkAffineType*Array instead") vtkAffineUnsignedShortArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkAffineUnsignedShortArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkAffineUnsignedShortArray* New();
  static vtkAffineUnsignedShortArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned short);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkAffineUnsignedShortArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkAffineUnsignedShortArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the parameters for the affine backend.
   * slope is the unit variation and intercept is the value at 0.
   * Value at index is:
   *   value = slope * index + intercept
   */
  void ConstructBackend(unsigned short slope, unsigned short intercept);

protected:
  vtkAffineUnsignedShortArray();
  ~vtkAffineUnsignedShortArray() override;

private:
  typedef vtkAffineArray<unsigned short> RealSuperclass;

  vtkAffineUnsignedShortArray(const vtkAffineUnsignedShortArray&) = delete;
  void operator=(const vtkAffineUnsignedShortArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkAffineUnsignedShortArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
