// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkAffineTypeInt8Array
 * @brief   affine implicit array of vtkTypeInt8.
 *
 * vtkAffineTypeInt8Array is an affine implicit array of values of type vtkTypeInt8.
 * see vtkAffineArray, vtkAffineImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkAffineTypeInt8Array_h
#define vtkAffineTypeInt8Array_h

#include "vtkAffineArray.h"      // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkAffineArray<vtkTypeInt8>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkAffineTypeInt8Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkAffineTypeInt8Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkAffineTypeInt8Array* New();
  static vtkAffineTypeInt8Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt8);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkAffineTypeInt8Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkAffineTypeInt8Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the parameters for the affine backend.
   * slope is the unit variation and intercept is the value at 0.
   * Value at index is:
   *   value = slope * index + intercept
   */
  void ConstructBackend(vtkTypeInt8 slope, vtkTypeInt8 intercept);

protected:
  vtkAffineTypeInt8Array();
  ~vtkAffineTypeInt8Array() override;

private:
  typedef vtkAffineArray<vtkTypeInt8> RealSuperclass;

  vtkAffineTypeInt8Array(const vtkAffineTypeInt8Array&) = delete;
  void operator=(const vtkAffineTypeInt8Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkAffineTypeInt8Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
