/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.AbstractIterator;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Searching;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StepperShape$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.convert.impl.AnyNumericRangeStepper;
import scala.collection.convert.impl.IndexedStepperBase;
import scala.collection.convert.impl.IntNumericRangeStepper;
import scala.collection.convert.impl.LongNumericRangeStepper;
import scala.collection.generic.CommonErrors$;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.IndexedSeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange$;
import scala.collection.mutable.Builder;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Numeric$BigDecimalAsIfIntegral$;
import scala.math.Numeric$BigIntIsIntegral$;
import scala.math.Numeric$ByteIsIntegral$;
import scala.math.Numeric$CharIsIntegral$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Numeric$ShortIsIntegral$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.util.Either;

public class NumericRange<T>
extends AbstractSeq<T>
implements scala.collection.immutable.IndexedSeq<T>,
scala.collection.immutable.StrictOptimizedSeqOps<T, scala.collection.immutable.IndexedSeq, scala.collection.immutable.IndexedSeq<T>>,
Serializable {
    private static final long serialVersionUID = 3L;
    private static final VarHandle hashCode$lzy1$lzyHandle = MethodHandles.lookup().findVarHandle(NumericRange.class, "hashCode$lzy1", Object.class);
    private static final VarHandle isEmpty$lzy1$lzyHandle = MethodHandles.lookup().findVarHandle(NumericRange.class, "isEmpty$lzy1", Object.class);
    private static final VarHandle length$lzy1$lzyHandle = MethodHandles.lookup().findVarHandle(NumericRange.class, "length$lzy1", Object.class);
    private final T start;
    private final T end;
    private final T step;
    private final boolean isInclusive;
    private final Integral<T> num;
    private volatile Object length$lzy1;
    private volatile Object isEmpty$lzy1;
    private volatile Object hashCode$lzy1;

    public static Map<Numeric<?>, Ordering<?>> defaultOrdering() {
        return NumericRange$.MODULE$.defaultOrdering();
    }

    public static <T> Inclusive<T> inclusive(T t, T t2, T t3, Integral<T> integral) {
        return NumericRange$.MODULE$.inclusive(t, t2, t3, integral);
    }

    public NumericRange(T start, T end, T step, boolean isInclusive, Integral<T> num) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.isInclusive = isInclusive;
        this.num = num;
        scala.collection.IndexedSeqOps.$init$(this);
        IndexedSeq.$init$(this);
        IndexedSeqOps.$init$(this);
        scala.collection.immutable.IndexedSeq.$init$(this);
        StrictOptimizedIterableOps.$init$(this);
        StrictOptimizedSeqOps.$init$(this);
        scala.collection.immutable.StrictOptimizedSeqOps.$init$(this);
    }

    @Override
    public Iterator<T> reverseIterator() {
        return scala.collection.IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public <B> B foldRight(B z, Function2<T, B, B> op) {
        return (B)scala.collection.IndexedSeqOps.foldRight$(this, z, op);
    }

    @Override
    public IndexedSeqView<T> view() {
        return scala.collection.IndexedSeqOps.view$(this);
    }

    @Override
    public IndexedSeqView<T> view(int from, int until) {
        return scala.collection.IndexedSeqOps.view$(this, from, until);
    }

    @Override
    public Iterable<T> reversed() {
        return scala.collection.IndexedSeqOps.reversed$(this);
    }

    @Override
    public Iterator<scala.collection.immutable.IndexedSeq<T>> sliding(int size, int step) {
        return scala.collection.IndexedSeqOps.sliding$(this, size, step);
    }

    @Override
    public Option<T> headOption() {
        return scala.collection.IndexedSeqOps.headOption$(this);
    }

    @Override
    public final int lengthCompare(int len) {
        return scala.collection.IndexedSeqOps.lengthCompare$((scala.collection.IndexedSeqOps)this, len);
    }

    @Override
    public int knownSize() {
        return scala.collection.IndexedSeqOps.knownSize$(this);
    }

    @Override
    public final int lengthCompare(Iterable<?> that) {
        return scala.collection.IndexedSeqOps.lengthCompare$((scala.collection.IndexedSeqOps)this, that);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
        return scala.collection.IndexedSeqOps.search$(this, elem, ord);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
        return scala.collection.IndexedSeqOps.search$(this, elem, from, to, ord);
    }

    @Override
    public String stringPrefix() {
        return IndexedSeq.stringPrefix$(this);
    }

    @Override
    public Object slice(int from, int until) {
        return IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public final scala.collection.immutable.IndexedSeq<T> toIndexedSeq() {
        return scala.collection.immutable.IndexedSeq.toIndexedSeq$(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return scala.collection.immutable.IndexedSeq.canEqual$(this, that);
    }

    @Override
    public <B> boolean sameElements(IterableOnce<B> o) {
        return scala.collection.immutable.IndexedSeq.sameElements$(this, o);
    }

    @Override
    public SeqFactory<scala.collection.immutable.IndexedSeq> iterableFactory() {
        return scala.collection.immutable.IndexedSeq.iterableFactory$(this);
    }

    @Override
    public Tuple2<scala.collection.immutable.IndexedSeq<T>, scala.collection.immutable.IndexedSeq<T>> partition(Function1<T, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<scala.collection.immutable.IndexedSeq<T>, scala.collection.immutable.IndexedSeq<T>> span(Function1<T, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>> unzip(Function1<T, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>, scala.collection.immutable.IndexedSeq<A3>> unzip3(Function1<T, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<T, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<T, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<T, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<T, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<T, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>> partitionMap(Function1<T, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public Object prepended(Object elem) {
        return StrictOptimizedSeqOps.prepended$(this, elem);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object appendedAll(IterableOnce suffix) {
        return StrictOptimizedSeqOps.appendedAll$(this, suffix);
    }

    @Override
    public Object prependedAll(IterableOnce prefix) {
        return StrictOptimizedSeqOps.prependedAll$(this, prefix);
    }

    @Override
    public Object padTo(int len, Object elem) {
        return StrictOptimizedSeqOps.padTo$(this, len, elem);
    }

    @Override
    public Object diff(Seq that) {
        return StrictOptimizedSeqOps.diff$(this, that);
    }

    @Override
    public Object intersect(Seq that) {
        return StrictOptimizedSeqOps.intersect$(this, that);
    }

    @Override
    public Object distinctBy(Function1 f) {
        return scala.collection.immutable.StrictOptimizedSeqOps.distinctBy$(this, f);
    }

    @Override
    public Object updated(int index, Object elem) {
        return scala.collection.immutable.StrictOptimizedSeqOps.updated$(this, index, elem);
    }

    @Override
    public Object patch(int from, IterableOnce other, int replaced) {
        return scala.collection.immutable.StrictOptimizedSeqOps.patch$(this, from, other, replaced);
    }

    @Override
    public Object sorted(Ordering ord) {
        return scala.collection.immutable.StrictOptimizedSeqOps.sorted$(this, ord);
    }

    @Override
    public /* synthetic */ scala.collection.immutable.IndexedSeq scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
        return (scala.collection.immutable.IndexedSeq)scala.collection.IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
        return Seq.canEqual$(this, that);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce that) {
        return SeqOps.sameElements$(this, that);
    }

    @Override
    public /* synthetic */ scala.collection.immutable.IndexedSeq scala$collection$immutable$StrictOptimizedSeqOps$$super$sorted(Ordering ord) {
        return (scala.collection.immutable.IndexedSeq)SeqOps.sorted$(this, ord);
    }

    public T start() {
        return this.start;
    }

    public T end() {
        return this.end;
    }

    public T step() {
        return this.step;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    @Override
    public Iterator<T> iterator() {
        return new NumericRangeIterator<T>(this, this.num);
    }

    @Override
    public <S extends Stepper<?>> S stepper(StepperShape<T, S> shape) {
        int n = shape.shape();
        IndexedStepperBase s = StepperShape$.MODULE$.IntShape() == n ? new IntNumericRangeStepper(this, 0, this.length()) : (StepperShape$.MODULE$.LongShape() == n ? new LongNumericRangeStepper(this, 0, this.length()) : shape.parUnbox(new AnyNumericRangeStepper(this, 0, this.length())));
        return (S)s;
    }

    @Override
    public int length() {
        Object object = this.length$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt(object);
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt(this.length$lzyINIT1());
    }

    private Object length$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.length$lzy1) == null) {
                    if (!length$lzy1$lzyHandle.compareAndSet(this, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger(NumericRange$.MODULE$.count(this.start(), this.end(), this.step(), this.isInclusive(), this.num));
                        serializable = n == null ? LazyVals$NullValue$.MODULE$ : n;
                    }
                    catch (Throwable throwable) {
                        if (!length$lzy1$lzyHandle.compareAndSet(this, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.length$lzy1;
                            length$lzy1$lzyHandle.compareAndSet(this, waiting, serializable);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!length$lzy1$lzyHandle.compareAndSet(this, LazyVals$Evaluating$.MODULE$, serializable)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.length$lzy1;
                        length$lzy1$lzyHandle.compareAndSet(this, waiting, serializable);
                        waiting.countDown();
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    length$lzy1$lzyHandle.compareAndSet(this, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean isEmpty() {
        Object object = this.isEmpty$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean(object);
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean(this.isEmpty$lzyINIT1());
    }

    private Object isEmpty$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.isEmpty$lzy1) == null) {
                    if (!isEmpty$lzy1$lzyHandle.compareAndSet(this, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean(this.num.gt(this.start(), this.end()) && this.num.gt(this.step(), this.num.zero()) || this.num.lt(this.start(), this.end()) && this.num.lt(this.step(), this.num.zero()) || this.num.equiv(this.start(), this.end()) && !this.isInclusive());
                        serializable = bl == null ? LazyVals$NullValue$.MODULE$ : bl;
                    }
                    catch (Throwable throwable) {
                        if (!isEmpty$lzy1$lzyHandle.compareAndSet(this, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isEmpty$lzy1;
                            isEmpty$lzy1$lzyHandle.compareAndSet(this, waiting, serializable);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!isEmpty$lzy1$lzyHandle.compareAndSet(this, LazyVals$Evaluating$.MODULE$, serializable)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.isEmpty$lzy1;
                        isEmpty$lzy1$lzyHandle.compareAndSet(this, waiting, serializable);
                        waiting.countDown();
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    isEmpty$lzy1$lzyHandle.compareAndSet(this, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public T last() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.locationAfterN(this.length() - 1);
    }

    @Override
    public NumericRange<T> init() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.init();
        }
        return new NumericRange<T>(this.start(), this.num.mkNumericOps(this.end()).$minus(this.step()), this.step(), this.isInclusive(), this.num);
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.start();
    }

    @Override
    public NumericRange<T> tail() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.tail();
        }
        if (this.isInclusive()) {
            return new Inclusive(this.num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.num);
        }
        return new Exclusive(this.num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.num);
    }

    public NumericRange<T> by(T newStep) {
        return this.copy(this.start(), this.end(), newStep);
    }

    public NumericRange<T> copy(T start, T end, T step) {
        return new NumericRange<T>(start, end, step, this.isInclusive(), this.num);
    }

    @Override
    public T apply(int idx) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.length()) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(idx, this.length() - 1);
        }
        return this.locationAfterN(idx);
    }

    @Override
    public <U> void foreach(Function1<T, U> f) {
        T current = this.start();
        for (int count = 0; count < this.length(); ++count) {
            f.apply(current);
            current = this.num.mkNumericOps(current).$plus(this.step());
        }
    }

    public void foreach$mVc$sp(Function1<T, BoxedUnit> f) {
        this.foreach((Function1)f);
    }

    private int indexOfTyped(T elem, int from) {
        int n = this.posOf(elem);
        int pos = n;
        if (pos >= from) {
            return pos;
        }
        return -1;
    }

    @Override
    public final <B> int indexOf(B elem, int from) {
        int n;
        try {
            n = this.indexOfTyped(elem, from);
        }
        catch (ClassCastException classCastException) {
            n = SeqOps.indexOf$(this, elem, from);
        }
        return n;
    }

    private int lastIndexOfTyped(T elem, int end) {
        int n = this.posOf(elem);
        int pos = n;
        if (pos <= end) {
            return pos;
        }
        return -1;
    }

    @Override
    public final <B> int lastIndexOf(B elem, int end) {
        int n;
        try {
            n = this.lastIndexOfTyped(elem, end);
        }
        catch (ClassCastException classCastException) {
            n = SeqOps.lastIndexOf$(this, elem, end);
        }
        return n;
    }

    @Override
    public int lastIndexOf$default$2() {
        return this.length() - 1;
    }

    private int posOf(T i) {
        if (this.contains(i)) {
            return NumericRange$.MODULE$.count(this.start(), i, this.step(), false, this.num);
        }
        return -1;
    }

    private boolean isWithinBoundaries(T elem) {
        return !this.isEmpty() && (this.num.mkOrderingOps(this.step()).$greater(this.num.zero()) && this.num.mkOrderingOps(this.start()).$less$eq(elem) && this.num.mkOrderingOps(elem).$less$eq(this.last()) || this.num.mkOrderingOps(this.step()).$less(this.num.zero()) && this.num.mkOrderingOps(this.last()).$less$eq(elem) && this.num.mkOrderingOps(elem).$less$eq(this.start()));
    }

    private T locationAfterN(int n) {
        return this.num.mkNumericOps(this.start()).$plus(this.num.mkNumericOps(this.step()).$times(this.num.fromInt(n)));
    }

    private boolean crossesTheEndAfterN(int n) {
        int n2;
        NumericRange<T> r;
        NumericRange l;
        int n3;
        block14: {
            Tuple3<Exclusive<T>, NumericRange<T>, Integer> tuple3;
            block13: {
                NumericRange<T> numericRange;
                NumericRange numericRange2;
                Tuple3<NumericRange, NumericRange<T>, Integer> tuple32;
                T closestToZero;
                boolean stepIsInTheSameDirectionAsStartToEndVector;
                boolean bl = stepIsInTheSameDirectionAsStartToEndVector = this.num.gt(this.end(), this.start()) && this.num.gt(this.step(), this.num.zero()) || this.num.lt(this.end(), this.start()) && BoxesRunTime.equals(this.num.sign(this.step()), this.num.mkNumericOps(this.num.one()).unary_$minus());
                if (this.num.equiv(this.start(), this.end()) || n <= 0 || !stepIsInTheSameDirectionAsStartToEndVector) {
                    return n >= 1;
                }
                boolean sameSign = this.num.equiv(this.num.sign(this.start()), this.num.sign(this.end()));
                if (sameSign) {
                    Object len = this.unsafeRangeLength$1(this);
                    if (this.fitsInInteger$1(len)) {
                        return n >= this.num.toInt(len);
                    }
                    return this.num.gteq(this.num.fromInt(n), len);
                }
                T stepsRemainderToZero = this.num.rem(this.start(), this.step());
                boolean walksOnZero = this.num.equiv(stepsRemainderToZero, this.num.zero());
                T t = closestToZero = walksOnZero ? this.num.mkNumericOps(this.step()).unary_$minus() : stepsRemainderToZero;
                if (this.num.lt(this.start(), this.num.zero())) {
                    if (walksOnZero) {
                        T twoStepsAfterLargestNegativeNumber = this.num.plus(closestToZero, this.num.times(this.step(), this.num.fromInt(2)));
                        tuple32 = Tuple3$.MODULE$.apply(NumericRange$.MODULE$.apply(this.start(), closestToZero, this.step(), this.num), this.copy(twoStepsAfterLargestNegativeNumber, this.end(), this.step()), BoxesRunTime.boxToInteger(2));
                    } else {
                        tuple32 = Tuple3$.MODULE$.apply(NumericRange$.MODULE$.apply(this.start(), closestToZero, this.step(), this.num), this.copy(this.num.plus(closestToZero, this.step()), this.end(), this.step()), BoxesRunTime.boxToInteger(1));
                    }
                } else if (walksOnZero) {
                    T twoStepsAfterZero = this.num.times(this.step(), this.num.fromInt(2));
                    tuple32 = Tuple3$.MODULE$.apply(this.copy(twoStepsAfterZero, this.end(), this.step()), NumericRange$.MODULE$.inclusive(this.start(), this.num.mkNumericOps(this.step()).unary_$minus(), this.step(), this.num), BoxesRunTime.boxToInteger(2));
                } else {
                    T twoStepsAfterSmallestPositiveNumber = this.num.plus(closestToZero, this.num.times(this.step(), this.num.fromInt(2)));
                    tuple32 = Tuple3$.MODULE$.apply(this.copy(twoStepsAfterSmallestPositiveNumber, this.end(), this.step()), NumericRange$.MODULE$.inclusive(this.start(), closestToZero, this.step(), this.num), BoxesRunTime.boxToInteger(2));
                }
                tuple3 = tuple32;
                NumericRange numericRange3 = tuple3._1();
                NumericRange<T> numericRange4 = tuple3._2();
                n3 = BoxesRunTime.unboxToInt(tuple3._3());
                if (!(numericRange3 instanceof NumericRange)) break block13;
                l = numericRange2 = numericRange3;
                if (!(numericRange4 instanceof NumericRange)) break block13;
                r = numericRange = numericRange4;
                if (true) break block14;
            }
            throw new MatchError(tuple3);
        }
        int carry = n2 = n3;
        Tuple3<NumericRange, NumericRange<T>, Integer> tuple3 = Tuple3$.MODULE$.apply(l, r, BoxesRunTime.boxToInteger(carry));
        NumericRange l2 = tuple3._1();
        NumericRange<T> r2 = tuple3._2();
        int carry2 = BoxesRunTime.unboxToInt(tuple3._3());
        Object leftLength = this.unsafeRangeLength$1(l2);
        Object rightLength = this.unsafeRangeLength$1(r2);
        if (this.fitsInInteger$1(leftLength) && this.fitsInInteger$1(rightLength)) {
            return n - this.num.toInt(leftLength) - carry2 >= this.num.toInt(rightLength);
        }
        return this.num.gteq(this.num.minus(this.num.minus(this.num.fromInt(n), leftLength), this.num.fromInt(carry2)), rightLength);
    }

    private Exclusive<T> newEmptyRange(T value) {
        return NumericRange$.MODULE$.apply(value, value, this.step(), this.num);
    }

    @Override
    public NumericRange<T> take(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this.newEmptyRange(this.start());
        }
        if (this.crossesTheEndAfterN(n)) {
            return this;
        }
        return new Inclusive<T>(this.start(), this.locationAfterN(n - 1), this.step(), this.num);
    }

    @Override
    public NumericRange<T> drop(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this;
        }
        if (this.crossesTheEndAfterN(n)) {
            return this.newEmptyRange(this.end());
        }
        return this.copy(this.locationAfterN(n), this.end(), this.step());
    }

    @Override
    public Tuple2<NumericRange<T>, NumericRange<T>> splitAt(int n) {
        return Tuple2$.MODULE$.apply(this.take(n), this.drop(n));
    }

    @Override
    public NumericRange<T> reverse() {
        if (this.isEmpty()) {
            return this;
        }
        Object newStep = this.num.mkNumericOps(this.step()).unary_$minus();
        if (BoxesRunTime.equals(this.num.sign(newStep), this.num.sign(this.step()))) {
            throw new ArithmeticException("number type is unsigned, and .reverse requires a negative step");
        }
        return new Inclusive<T>(this.last(), this.start(), newStep, this.num);
    }

    @Override
    public <T1> T min(Ordering<T1> ord) {
        if (ord == this.num || NumericRange$.MODULE$.defaultOrdering().get(this.num).exists((Function1<Ordering, Boolean> & Serializable)_$1 -> ord == _$1)) {
            if (this.num.mkOrderingOps(this.num.sign(this.step())).$greater(this.num.zero())) {
                return this.head();
            }
            return this.last();
        }
        return (T)IterableOnceOps.min$(this, ord);
    }

    @Override
    public <T1> T max(Ordering<T1> ord) {
        if (ord == this.num || NumericRange$.MODULE$.defaultOrdering().get(this.num).exists((Function1<Ordering, Boolean> & Serializable)_$2 -> ord == _$2)) {
            if (this.num.mkOrderingOps(this.num.sign(this.step())).$greater(this.num.zero())) {
                return this.last();
            }
            return this.head();
        }
        return (T)IterableOnceOps.max$(this, ord);
    }

    public boolean containsTyped(T x) {
        return this.isWithinBoundaries(x) && BoxesRunTime.equals(this.num.mkNumericOps(this.num.mkNumericOps(x).$minus(this.start())).$percent(this.step()), this.num.zero());
    }

    @Override
    public <A1> boolean contains(A1 x) {
        boolean bl;
        try {
            bl = this.containsTyped(x);
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public <B> B sum(Numeric<B> num) {
        if (this.isEmpty()) {
            return num.zero();
        }
        if (this.size() == 1) {
            return (B)this.head();
        }
        if (num == Numeric$IntIsIntegral$.MODULE$ || num == Numeric$ShortIsIntegral$.MODULE$ || num == Numeric$ByteIsIntegral$.MODULE$ || num == Numeric$CharIsIntegral$.MODULE$) {
            long exact = (long)this.size() * (num.toLong(this.head()) + (long)num.toInt(this.last())) / 2L;
            return num.fromInt((int)exact);
        }
        if (num == Numeric$LongIsIntegral$.MODULE$) {
            long l;
            long a = this.num.mkNumericOps(this.head()).toLong();
            long b = this.num.mkNumericOps(this.last()).toLong();
            if ((this.size() & 1) == 0) {
                l = (long)(this.size() / 2) * (a + b);
            } else {
                long ha = a / 2L;
                long hb = b / 2L;
                l = (long)this.size() * (ha + hb + (a - 2L * ha + (b - 2L * hb)) / 2L);
            }
            long ans = l;
            return (B)BoxesRunTime.boxToLong(ans);
        }
        if (num == Numeric$BigIntIsIntegral$.MODULE$ || num == Numeric$BigDecimalAsIfIntegral$.MODULE$) {
            Integral numAsIntegral = (Integral)num;
            return (B)numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(num.fromInt(this.size())).$times(numAsIntegral.mkNumericOps(this.head()).$plus(this.last()))).$div(num.fromInt(2));
        }
        if (this.isEmpty()) {
            return num.zero();
        }
        B acc = num.zero();
        T i = this.head();
        for (int idx = 0; idx < this.length(); ++idx) {
            acc = num.plus(acc, i);
            i = this.num.mkNumericOps(i).$plus(this.step());
        }
        return acc;
    }

    @Override
    public int hashCode() {
        Object object = this.hashCode$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt(object);
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt(this.hashCode$lzyINIT1());
    }

    private Object hashCode$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hashCode$lzy1) == null) {
                    if (!hashCode$lzy1$lzyHandle.compareAndSet(this, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger(Seq.hashCode$(this));
                        serializable = n == null ? LazyVals$NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!hashCode$lzy1$lzyHandle.compareAndSet(this, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hashCode$lzy1;
                            hashCode$lzy1$lzyHandle.compareAndSet(this, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    hashCode$lzy1$lzyHandle.compareAndSet(this, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public final int applyPreferredMaxLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof NumericRange) {
            NumericRange numericRange = (NumericRange)object;
            NumericRange x = numericRange;
            return x.canEqual(this) && this.length() == x.length() && (this.isEmpty() || BoxesRunTime.equals(this.start(), x.start()) && BoxesRunTime.equals(this.last(), x.last()));
        }
        return Seq.equals$(this, other);
    }

    @Override
    public String toString() {
        String empty = this.isEmpty() ? "empty " : "";
        String preposition = this.isInclusive() ? "to" : "until";
        String stepped = BoxesRunTime.equals(this.step(), BoxesRunTime.boxToInteger(1)) ? "" : " by " + this.step();
        return empty + "NumericRange " + this.start() + " " + preposition + " " + this.end() + stepped;
    }

    @Override
    public String className() {
        return "NumericRange";
    }

    private final Object unsafeRangeLength$1(NumericRange r) {
        T diff = this.num.minus(r.end(), r.start());
        T quotient = this.num.quot(diff, r.step());
        T remainder = this.num.rem(diff, r.step());
        if (!r.isInclusive() && this.num.equiv(remainder, this.num.zero())) {
            return this.num.max(quotient, this.num.zero());
        }
        return this.num.max(this.num.plus(quotient, this.num.one()), this.num.zero());
    }

    private final boolean fitsInInteger$1(Object value) {
        return this.num.equiv(this.num.fromInt(this.num.toInt(value)), value);
    }

    public static class Exclusive<T>
    extends NumericRange<T> {
        private static final long serialVersionUID = 3L;
        private final T start;
        private final T end;
        private final T step;
        private final Integral<T> num;

        public Exclusive(T start, T end, T step, Integral<T> num) {
            this.start = start;
            this.end = end;
            this.step = step;
            this.num = num;
            super(start, end, step, false, num);
        }

        @Override
        public Exclusive<T> copy(T start, T end, T step) {
            return NumericRange$.MODULE$.apply(start, end, step, this.num);
        }

        public Inclusive<T> inclusive() {
            return NumericRange$.MODULE$.inclusive(this.start, this.end, this.step, this.num);
        }
    }

    public static class Inclusive<T>
    extends NumericRange<T> {
        private static final long serialVersionUID = 3L;
        private final T start;
        private final T end;
        private final T step;
        private final Integral<T> num;

        public Inclusive(T start, T end, T step, Integral<T> num) {
            this.start = start;
            this.end = end;
            this.step = step;
            this.num = num;
            super(start, end, step, true, num);
        }

        @Override
        public Inclusive<T> copy(T start, T end, T step) {
            return NumericRange$.MODULE$.inclusive(start, end, step, this.num);
        }

        public Exclusive<T> exclusive() {
            return NumericRange$.MODULE$.apply(this.start, this.end, this.step, this.num);
        }
    }

    public static final class NumericRangeIterator<T>
    extends AbstractIterator<T>
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private final NumericRange<T> self;
        private final Integral<T> num;
        private boolean _hasNext;
        private T _next;
        private final T lastElement;

        public NumericRangeIterator(NumericRange<T> self, Integral<T> num) {
            this.self = self;
            this.num = num;
            this._hasNext = !self.isEmpty();
            this._next = self.start();
            this.lastElement = this._hasNext ? self.last() : self.start();
        }

        @Override
        public int knownSize() {
            if (this._hasNext) {
                return this.num.toInt(this.num.mkNumericOps(this.num.mkNumericOps(this.lastElement).$minus(this._next)).$div(this.self.step())) + 1;
            }
            return 0;
        }

        @Override
        public boolean hasNext() {
            return this._hasNext;
        }

        @Override
        public T next() {
            T value;
            if (!this._hasNext) {
                Iterator$.MODULE$.empty().next();
            }
            this._hasNext = !BoxesRunTime.equals(value = this._next, this.lastElement);
            this._next = this.num.plus(value, this.self.step());
            return value;
        }
    }
}

