from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

SCOTTISH_GAELIC_LANG_MODEL = {
    26: {  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.POSITIVE,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.POSITIVE,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.LIKELY,  # 'N'
        39: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.LIKELY,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    28: {  # 'B'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        28: SequenceLikelihood.POSITIVE,  # 'B'
        25: SequenceLikelihood.POSITIVE,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.LIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.POSITIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.LIKELY,  # 'à'
        22: SequenceLikelihood.UNLIKELY,  # 'è'
        20: SequenceLikelihood.UNLIKELY,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.LIKELY,  # 'ù'
    },
    25: {  # 'C'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.LIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.LIKELY,  # 'N'
        39: SequenceLikelihood.POSITIVE,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.UNLIKELY,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.LIKELY,  # 'è'
        20: SequenceLikelihood.LIKELY,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    31: {  # 'D'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.LIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.LIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.UNLIKELY,  # 'È'
        56: SequenceLikelihood.UNLIKELY,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.UNLIKELY,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    38: {  # 'E'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.LIKELY,  # 'N'
        39: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.UNLIKELY,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    32: {  # 'F'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.UNLIKELY,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.LIKELY,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.LIKELY,  # 'ì'
        19: SequenceLikelihood.LIKELY,  # 'ò'
        24: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    27: {  # 'G'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.LIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.LIKELY,  # 'è'
        20: SequenceLikelihood.UNLIKELY,  # 'ì'
        19: SequenceLikelihood.LIKELY,  # 'ò'
        24: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    41: {  # 'H'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.POSITIVE,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.UNLIKELY,  # 'È'
        56: SequenceLikelihood.UNLIKELY,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.UNLIKELY,  # 'Ù'
        17: SequenceLikelihood.UNLIKELY,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.UNLIKELY,  # 'ò'
        24: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    34: {  # 'I'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.POSITIVE,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.LIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.LIKELY,  # 'N'
        39: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.LIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.NEGATIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.UNLIKELY,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.UNLIKELY,  # 'ò'
        24: SequenceLikelihood.LIKELY,  # 'ù'
    },
    52: {  # 'J'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    54: {  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    37: {  # 'L'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.UNLIKELY,  # 'È'
        56: SequenceLikelihood.UNLIKELY,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.UNLIKELY,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.LIKELY,  # 'è'
        20: SequenceLikelihood.LIKELY,  # 'ì'
        19: SequenceLikelihood.LIKELY,  # 'ò'
        24: SequenceLikelihood.LIKELY,  # 'ù'
    },
    30: {  # 'M'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.LIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.UNLIKELY,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.UNLIKELY,  # 'è'
        20: SequenceLikelihood.LIKELY,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    35: {  # 'N'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.LIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.LIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.LIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.UNLIKELY,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.LIKELY,  # 'è'
        20: SequenceLikelihood.LIKELY,  # 'ì'
        19: SequenceLikelihood.UNLIKELY,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    39: {  # 'O'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.LIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.LIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    33: {  # 'P'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.LIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.LIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.LIKELY,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    61: {  # 'Q'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    36: {  # 'R'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.UNLIKELY,  # 'È'
        56: SequenceLikelihood.UNLIKELY,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.UNLIKELY,  # 'Ù'
        17: SequenceLikelihood.LIKELY,  # 'à'
        22: SequenceLikelihood.LIKELY,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.LIKELY,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    29: {  # 'S'
        26: SequenceLikelihood.POSITIVE,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.POSITIVE,  # 'E'
        32: SequenceLikelihood.LIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.LIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.LIKELY,  # 'N'
        39: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.LIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.LIKELY,  # 'à'
        22: SequenceLikelihood.UNLIKELY,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.LIKELY,  # 'ò'
        24: SequenceLikelihood.LIKELY,  # 'ù'
    },
    23: {  # 'T'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.LIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.LIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.LIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.LIKELY,  # 'à'
        22: SequenceLikelihood.LIKELY,  # 'è'
        20: SequenceLikelihood.LIKELY,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.LIKELY,  # 'ù'
    },
    42: {  # 'U'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.LIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.LIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.LIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.NEGATIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.UNLIKELY,  # 'à'
        22: SequenceLikelihood.LIKELY,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    50: {  # 'V'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    47: {  # 'W'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    60: {  # 'X'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        12: SequenceLikelihood.NEGATIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    57: {  # 'Y'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    58: {  # 'Z'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    1: {  # 'a'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.POSITIVE,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        40: SequenceLikelihood.POSITIVE,  # 'y'
        55: SequenceLikelihood.LIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.UNLIKELY,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.UNLIKELY,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    16: {  # 'b'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.UNLIKELY,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    8: {  # 'c'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.LIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.POSITIVE,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.LIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.UNLIKELY,  # 'È'
        56: SequenceLikelihood.LIKELY,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.LIKELY,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    5: {  # 'd'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        5: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.UNLIKELY,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    6: {  # 'e'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.POSITIVE,  # 'x'
        40: SequenceLikelihood.POSITIVE,  # 'y'
        55: SequenceLikelihood.LIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.UNLIKELY,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.UNLIKELY,  # 'è'
        20: SequenceLikelihood.UNLIKELY,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    18: {  # 'f'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    13: {  # 'g'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.LIKELY,  # 'ò'
        24: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    2: {  # 'h'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.POSITIVE,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.LIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    3: {  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.LIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        62: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.POSITIVE,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.LIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.UNLIKELY,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.UNLIKELY,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    59: {  # 'j'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.UNLIKELY,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    44: {  # 'k'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    11: {  # 'l'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.LIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.POSITIVE,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.UNLIKELY,  # 'È'
        56: SequenceLikelihood.UNLIKELY,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    15: {  # 'm'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.LIKELY,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.LIKELY,  # 'ù'
    },
    4: {  # 'n'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.LIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.LIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.LIKELY,  # 'z'
        45: SequenceLikelihood.UNLIKELY,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.UNLIKELY,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.LIKELY,  # 'ò'
        24: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    12: {  # 'o'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.POSITIVE,  # 'v'
        43: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.LIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.UNLIKELY,  # 'à'
        22: SequenceLikelihood.UNLIKELY,  # 'è'
        20: SequenceLikelihood.UNLIKELY,  # 'ì'
        19: SequenceLikelihood.UNLIKELY,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    21: {  # 'p'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.LIKELY,  # 'ù'
    },
    62: {  # 'q'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    7: {  # 'r'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.LIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.POSITIVE,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.UNLIKELY,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    9: {  # 's'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.UNLIKELY,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.POSITIVE,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.LIKELY,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    10: {  # 't'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.UNLIKELY,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.POSITIVE,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.POSITIVE,  # 'y'
        55: SequenceLikelihood.LIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.POSITIVE,  # 'à'
        22: SequenceLikelihood.POSITIVE,  # 'è'
        20: SequenceLikelihood.POSITIVE,  # 'ì'
        19: SequenceLikelihood.POSITIVE,  # 'ò'
        24: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    14: {  # 'u'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.LIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.UNLIKELY,  # 'à'
        22: SequenceLikelihood.LIKELY,  # 'è'
        20: SequenceLikelihood.UNLIKELY,  # 'ì'
        19: SequenceLikelihood.UNLIKELY,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    46: {  # 'v'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    43: {  # 'w'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    51: {  # 'x'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        40: SequenceLikelihood.LIKELY,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    40: {  # 'y'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.UNLIKELY,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        5: SequenceLikelihood.LIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        14: SequenceLikelihood.LIKELY,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    55: {  # 'z'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.UNLIKELY,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.UNLIKELY,  # 'v'
        43: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.UNLIKELY,  # 'y'
        55: SequenceLikelihood.LIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    45: {  # 'À'
        26: SequenceLikelihood.LIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.UNLIKELY,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.LIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        16: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.UNLIKELY,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.NEGATIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    48: {  # 'È'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        14: SequenceLikelihood.NEGATIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.UNLIKELY,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    56: {  # 'Ì'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.NEGATIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.NEGATIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        14: SequenceLikelihood.NEGATIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.UNLIKELY,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    53: {  # 'Ò'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        12: SequenceLikelihood.NEGATIVE,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        14: SequenceLikelihood.NEGATIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    49: {  # 'Ù'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.UNLIKELY,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.LIKELY,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        12: SequenceLikelihood.NEGATIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.NEGATIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    17: {  # 'à'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.NEGATIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.UNLIKELY,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    22: {  # 'è'
        26: SequenceLikelihood.UNLIKELY,  # 'A'
        28: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        16: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        5: SequenceLikelihood.NEGATIVE,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.UNLIKELY,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        12: SequenceLikelihood.LIKELY,  # 'o'
        21: SequenceLikelihood.NEGATIVE,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.UNLIKELY,  # 'ì'
        19: SequenceLikelihood.UNLIKELY,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    20: {  # 'ì'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.UNLIKELY,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.UNLIKELY,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.POSITIVE,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.UNLIKELY,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    19: {  # 'ò'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.UNLIKELY,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        23: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.UNLIKELY,  # 'o'
        21: SequenceLikelihood.UNLIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.NEGATIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.UNLIKELY,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.NEGATIVE,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    24: {  # 'ù'
        26: SequenceLikelihood.NEGATIVE,  # 'A'
        28: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        31: SequenceLikelihood.NEGATIVE,  # 'D'
        38: SequenceLikelihood.NEGATIVE,  # 'E'
        32: SequenceLikelihood.NEGATIVE,  # 'F'
        27: SequenceLikelihood.NEGATIVE,  # 'G'
        41: SequenceLikelihood.NEGATIVE,  # 'H'
        34: SequenceLikelihood.NEGATIVE,  # 'I'
        52: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        30: SequenceLikelihood.NEGATIVE,  # 'M'
        35: SequenceLikelihood.NEGATIVE,  # 'N'
        39: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        36: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        23: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        50: SequenceLikelihood.NEGATIVE,  # 'V'
        47: SequenceLikelihood.NEGATIVE,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        57: SequenceLikelihood.NEGATIVE,  # 'Y'
        58: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        16: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        5: SequenceLikelihood.POSITIVE,  # 'd'
        6: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        13: SequenceLikelihood.POSITIVE,  # 'g'
        2: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        59: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        12: SequenceLikelihood.NEGATIVE,  # 'o'
        21: SequenceLikelihood.LIKELY,  # 'p'
        62: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        14: SequenceLikelihood.NEGATIVE,  # 'u'
        46: SequenceLikelihood.NEGATIVE,  # 'v'
        43: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        40: SequenceLikelihood.NEGATIVE,  # 'y'
        55: SequenceLikelihood.NEGATIVE,  # 'z'
        45: SequenceLikelihood.NEGATIVE,  # 'À'
        48: SequenceLikelihood.NEGATIVE,  # 'È'
        56: SequenceLikelihood.NEGATIVE,  # 'Ì'
        53: SequenceLikelihood.NEGATIVE,  # 'Ò'
        49: SequenceLikelihood.NEGATIVE,  # 'Ù'
        17: SequenceLikelihood.NEGATIVE,  # 'à'
        22: SequenceLikelihood.NEGATIVE,  # 'è'
        20: SequenceLikelihood.UNLIKELY,  # 'ì'
        19: SequenceLikelihood.NEGATIVE,  # 'ò'
        24: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
}

# Character Mapping Table(s):
CP037_SCOTTISH_GAELIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 17,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 0,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 22,  # 'è'
    85: 0,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 20,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 45,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 0,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 48,  # 'È'
    117: 0,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 56,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 16,  # 'b'
    131: 8,  # 'c'
    132: 5,  # 'd'
    133: 6,  # 'e'
    134: 18,  # 'f'
    135: 13,  # 'g'
    136: 2,  # 'h'
    137: 3,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 59,  # 'j'
    146: 44,  # 'k'
    147: 11,  # 'l'
    148: 15,  # 'm'
    149: 4,  # 'n'
    150: 12,  # 'o'
    151: 21,  # 'p'
    152: 62,  # 'q'
    153: 7,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 9,  # 's'
    163: 10,  # 't'
    164: 14,  # 'u'
    165: 46,  # 'v'
    166: 43,  # 'w'
    167: 51,  # 'x'
    168: 40,  # 'y'
    169: 55,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 26,  # 'A'
    194: 28,  # 'B'
    195: 25,  # 'C'
    196: 31,  # 'D'
    197: 38,  # 'E'
    198: 32,  # 'F'
    199: 27,  # 'G'
    200: 41,  # 'H'
    201: 34,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 19,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 52,  # 'J'
    210: 54,  # 'K'
    211: 37,  # 'L'
    212: 30,  # 'M'
    213: 35,  # 'N'
    214: 39,  # 'O'
    215: 33,  # 'P'
    216: 61,  # 'Q'
    217: 36,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 24,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 29,  # 'S'
    227: 23,  # 'T'
    228: 42,  # 'U'
    229: 50,  # 'V'
    230: 47,  # 'W'
    231: 60,  # 'X'
    232: 57,  # 'Y'
    233: 58,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 53,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 49,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_SCOTTISH_GAELIC_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="Scottish Gaelic",
    char_to_order_map=CP037_SCOTTISH_GAELIC_CHAR_TO_ORDER,
    language_model=SCOTTISH_GAELIC_LANG_MODEL,
    typical_positive_ratio=0.9919494770482096,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÌÒÙàèìòù",
)

CP437_SCOTTISH_GAELIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 28,  # 'B'
    67: 25,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 32,  # 'F'
    71: 27,  # 'G'
    72: 41,  # 'H'
    73: 34,  # 'I'
    74: 52,  # 'J'
    75: 54,  # 'K'
    76: 37,  # 'L'
    77: 30,  # 'M'
    78: 35,  # 'N'
    79: 39,  # 'O'
    80: 33,  # 'P'
    81: 61,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 23,  # 'T'
    85: 42,  # 'U'
    86: 50,  # 'V'
    87: 47,  # 'W'
    88: 60,  # 'X'
    89: 57,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 8,  # 'c'
    100: 5,  # 'd'
    101: 6,  # 'e'
    102: 18,  # 'f'
    103: 13,  # 'g'
    104: 2,  # 'h'
    105: 3,  # 'i'
    106: 59,  # 'j'
    107: 44,  # 'k'
    108: 11,  # 'l'
    109: 15,  # 'm'
    110: 4,  # 'n'
    111: 12,  # 'o'
    112: 21,  # 'p'
    113: 62,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 14,  # 'u'
    118: 46,  # 'v'
    119: 43,  # 'w'
    120: 51,  # 'x'
    121: 40,  # 'y'
    122: 55,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 17,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 22,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 20,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 19,  # 'ò'
    150: 0,  # 'û'
    151: 24,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_SCOTTISH_GAELIC_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="Scottish Gaelic",
    char_to_order_map=CP437_SCOTTISH_GAELIC_CHAR_TO_ORDER,
    language_model=SCOTTISH_GAELIC_LANG_MODEL,
    typical_positive_ratio=0.9922720227964176,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÌÒÙàèìòù",
)

CP500_SCOTTISH_GAELIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 17,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 0,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 22,  # 'è'
    85: 0,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 20,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 45,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 0,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 48,  # 'È'
    117: 0,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 56,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 1,  # 'a'
    130: 16,  # 'b'
    131: 8,  # 'c'
    132: 5,  # 'd'
    133: 6,  # 'e'
    134: 18,  # 'f'
    135: 13,  # 'g'
    136: 2,  # 'h'
    137: 3,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 59,  # 'j'
    146: 44,  # 'k'
    147: 11,  # 'l'
    148: 15,  # 'm'
    149: 4,  # 'n'
    150: 12,  # 'o'
    151: 21,  # 'p'
    152: 62,  # 'q'
    153: 7,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 9,  # 's'
    163: 10,  # 't'
    164: 14,  # 'u'
    165: 46,  # 'v'
    166: 43,  # 'w'
    167: 51,  # 'x'
    168: 40,  # 'y'
    169: 55,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 26,  # 'A'
    194: 28,  # 'B'
    195: 25,  # 'C'
    196: 31,  # 'D'
    197: 38,  # 'E'
    198: 32,  # 'F'
    199: 27,  # 'G'
    200: 41,  # 'H'
    201: 34,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 19,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 52,  # 'J'
    210: 54,  # 'K'
    211: 37,  # 'L'
    212: 30,  # 'M'
    213: 35,  # 'N'
    214: 39,  # 'O'
    215: 33,  # 'P'
    216: 61,  # 'Q'
    217: 36,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 24,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 29,  # 'S'
    227: 23,  # 'T'
    228: 42,  # 'U'
    229: 50,  # 'V'
    230: 47,  # 'W'
    231: 60,  # 'X'
    232: 57,  # 'Y'
    233: 58,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 53,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 49,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_SCOTTISH_GAELIC_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="Scottish Gaelic",
    char_to_order_map=CP500_SCOTTISH_GAELIC_CHAR_TO_ORDER,
    language_model=SCOTTISH_GAELIC_LANG_MODEL,
    typical_positive_ratio=0.9919494770482096,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÌÒÙàèìòù",
)

CP850_SCOTTISH_GAELIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 28,  # 'B'
    67: 25,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 32,  # 'F'
    71: 27,  # 'G'
    72: 41,  # 'H'
    73: 34,  # 'I'
    74: 52,  # 'J'
    75: 54,  # 'K'
    76: 37,  # 'L'
    77: 30,  # 'M'
    78: 35,  # 'N'
    79: 39,  # 'O'
    80: 33,  # 'P'
    81: 61,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 23,  # 'T'
    85: 42,  # 'U'
    86: 50,  # 'V'
    87: 47,  # 'W'
    88: 60,  # 'X'
    89: 57,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 8,  # 'c'
    100: 5,  # 'd'
    101: 6,  # 'e'
    102: 18,  # 'f'
    103: 13,  # 'g'
    104: 2,  # 'h'
    105: 3,  # 'i'
    106: 59,  # 'j'
    107: 44,  # 'k'
    108: 11,  # 'l'
    109: 15,  # 'm'
    110: 4,  # 'n'
    111: 12,  # 'o'
    112: 21,  # 'p'
    113: 62,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 14,  # 'u'
    118: 46,  # 'v'
    119: 43,  # 'w'
    120: 51,  # 'x'
    121: 40,  # 'y'
    122: 55,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 17,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 22,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 20,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 19,  # 'ò'
    150: 0,  # 'û'
    151: 24,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 0,  # 'Â'
    183: 45,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 48,  # 'È'
    213: 0,  # 'ı'
    214: 0,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 56,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 53,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 0,  # 'Û'
    235: 49,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_SCOTTISH_GAELIC_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="Scottish Gaelic",
    char_to_order_map=CP850_SCOTTISH_GAELIC_CHAR_TO_ORDER,
    language_model=SCOTTISH_GAELIC_LANG_MODEL,
    typical_positive_ratio=0.9919494770482096,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÌÒÙàèìòù",
)

CP858_SCOTTISH_GAELIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 28,  # 'B'
    67: 25,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 32,  # 'F'
    71: 27,  # 'G'
    72: 41,  # 'H'
    73: 34,  # 'I'
    74: 52,  # 'J'
    75: 54,  # 'K'
    76: 37,  # 'L'
    77: 30,  # 'M'
    78: 35,  # 'N'
    79: 39,  # 'O'
    80: 33,  # 'P'
    81: 61,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 23,  # 'T'
    85: 42,  # 'U'
    86: 50,  # 'V'
    87: 47,  # 'W'
    88: 60,  # 'X'
    89: 57,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 8,  # 'c'
    100: 5,  # 'd'
    101: 6,  # 'e'
    102: 18,  # 'f'
    103: 13,  # 'g'
    104: 2,  # 'h'
    105: 3,  # 'i'
    106: 59,  # 'j'
    107: 44,  # 'k'
    108: 11,  # 'l'
    109: 15,  # 'm'
    110: 4,  # 'n'
    111: 12,  # 'o'
    112: 21,  # 'p'
    113: 62,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 14,  # 'u'
    118: 46,  # 'v'
    119: 43,  # 'w'
    120: 51,  # 'x'
    121: 40,  # 'y'
    122: 55,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 17,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 22,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 20,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 19,  # 'ò'
    150: 0,  # 'û'
    151: 24,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 0,  # 'Â'
    183: 45,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 48,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 0,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 56,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 53,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 0,  # 'Û'
    235: 49,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_SCOTTISH_GAELIC_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="Scottish Gaelic",
    char_to_order_map=CP858_SCOTTISH_GAELIC_CHAR_TO_ORDER,
    language_model=SCOTTISH_GAELIC_LANG_MODEL,
    typical_positive_ratio=0.9919494770482096,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÌÒÙàèìòù",
)

ISO_8859_1_SCOTTISH_GAELIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 28,  # 'B'
    67: 25,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 32,  # 'F'
    71: 27,  # 'G'
    72: 41,  # 'H'
    73: 34,  # 'I'
    74: 52,  # 'J'
    75: 54,  # 'K'
    76: 37,  # 'L'
    77: 30,  # 'M'
    78: 35,  # 'N'
    79: 39,  # 'O'
    80: 33,  # 'P'
    81: 61,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 23,  # 'T'
    85: 42,  # 'U'
    86: 50,  # 'V'
    87: 47,  # 'W'
    88: 60,  # 'X'
    89: 57,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 8,  # 'c'
    100: 5,  # 'd'
    101: 6,  # 'e'
    102: 18,  # 'f'
    103: 13,  # 'g'
    104: 2,  # 'h'
    105: 3,  # 'i'
    106: 59,  # 'j'
    107: 44,  # 'k'
    108: 11,  # 'l'
    109: 15,  # 'm'
    110: 4,  # 'n'
    111: 12,  # 'o'
    112: 21,  # 'p'
    113: 62,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 14,  # 'u'
    118: 46,  # 'v'
    119: 43,  # 'w'
    120: 51,  # 'x'
    121: 40,  # 'y'
    122: 55,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 45,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 48,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 56,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 53,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 49,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 17,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 22,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 20,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 19,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 24,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_1_SCOTTISH_GAELIC_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="Scottish Gaelic",
    char_to_order_map=ISO_8859_1_SCOTTISH_GAELIC_CHAR_TO_ORDER,
    language_model=SCOTTISH_GAELIC_LANG_MODEL,
    typical_positive_ratio=0.9919494770482096,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÌÒÙàèìòù",
)

ISO_8859_14_SCOTTISH_GAELIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 28,  # 'B'
    67: 25,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 32,  # 'F'
    71: 27,  # 'G'
    72: 41,  # 'H'
    73: 34,  # 'I'
    74: 52,  # 'J'
    75: 54,  # 'K'
    76: 37,  # 'L'
    77: 30,  # 'M'
    78: 35,  # 'N'
    79: 39,  # 'O'
    80: 33,  # 'P'
    81: 61,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 23,  # 'T'
    85: 42,  # 'U'
    86: 50,  # 'V'
    87: 47,  # 'W'
    88: 60,  # 'X'
    89: 57,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 8,  # 'c'
    100: 5,  # 'd'
    101: 6,  # 'e'
    102: 18,  # 'f'
    103: 13,  # 'g'
    104: 2,  # 'h'
    105: 3,  # 'i'
    106: 59,  # 'j'
    107: 44,  # 'k'
    108: 11,  # 'l'
    109: 15,  # 'm'
    110: 4,  # 'n'
    111: 12,  # 'o'
    112: 21,  # 'p'
    113: 62,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 14,  # 'u'
    118: 46,  # 'v'
    119: 43,  # 'w'
    120: 51,  # 'x'
    121: 40,  # 'y'
    122: 55,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ḃ'
    162: 0,  # 'ḃ'
    163: CharacterCategory.SYMBOL,  # '£'
    164: 0,  # 'Ċ'
    165: 0,  # 'ċ'
    166: 0,  # 'Ḋ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ẁ'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ẃ'
    171: 0,  # 'ḋ'
    172: 0,  # 'Ỳ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ÿ'
    176: 0,  # 'Ḟ'
    177: 0,  # 'ḟ'
    178: 0,  # 'Ġ'
    179: 0,  # 'ġ'
    180: 0,  # 'Ṁ'
    181: 0,  # 'ṁ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: 0,  # 'Ṗ'
    184: 0,  # 'ẁ'
    185: 0,  # 'ṗ'
    186: 0,  # 'ẃ'
    187: 0,  # 'Ṡ'
    188: 0,  # 'ỳ'
    189: 0,  # 'Ẅ'
    190: 0,  # 'ẅ'
    191: 0,  # 'ṡ'
    192: 45,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 48,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 56,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ŵ'
    209: 0,  # 'Ñ'
    210: 53,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: 0,  # 'Ṫ'
    216: 0,  # 'Ø'
    217: 49,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Ŷ'
    223: 0,  # 'ß'
    224: 17,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 22,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 20,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ŵ'
    241: 0,  # 'ñ'
    242: 19,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: 0,  # 'ṫ'
    248: 0,  # 'ø'
    249: 24,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'ŷ'
    255: 0,  # 'ÿ'
}

ISO_8859_14_SCOTTISH_GAELIC_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-14",
    language="Scottish Gaelic",
    char_to_order_map=ISO_8859_14_SCOTTISH_GAELIC_CHAR_TO_ORDER,
    language_model=SCOTTISH_GAELIC_LANG_MODEL,
    typical_positive_ratio=0.9919494770482096,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÌÒÙàèìòù",
)

ISO_8859_15_SCOTTISH_GAELIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 28,  # 'B'
    67: 25,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 32,  # 'F'
    71: 27,  # 'G'
    72: 41,  # 'H'
    73: 34,  # 'I'
    74: 52,  # 'J'
    75: 54,  # 'K'
    76: 37,  # 'L'
    77: 30,  # 'M'
    78: 35,  # 'N'
    79: 39,  # 'O'
    80: 33,  # 'P'
    81: 61,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 23,  # 'T'
    85: 42,  # 'U'
    86: 50,  # 'V'
    87: 47,  # 'W'
    88: 60,  # 'X'
    89: 57,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 8,  # 'c'
    100: 5,  # 'd'
    101: 6,  # 'e'
    102: 18,  # 'f'
    103: 13,  # 'g'
    104: 2,  # 'h'
    105: 3,  # 'i'
    106: 59,  # 'j'
    107: 44,  # 'k'
    108: 11,  # 'l'
    109: 15,  # 'm'
    110: 4,  # 'n'
    111: 12,  # 'o'
    112: 21,  # 'p'
    113: 62,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 14,  # 'u'
    118: 46,  # 'v'
    119: 43,  # 'w'
    120: 51,  # 'x'
    121: 40,  # 'y'
    122: 55,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 45,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 48,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 56,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 53,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 49,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 17,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 22,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 20,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 19,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 24,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_15_SCOTTISH_GAELIC_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="Scottish Gaelic",
    char_to_order_map=ISO_8859_15_SCOTTISH_GAELIC_CHAR_TO_ORDER,
    language_model=SCOTTISH_GAELIC_LANG_MODEL,
    typical_positive_ratio=0.9919494770482096,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÌÒÙàèìòù",
)

MACROMAN_SCOTTISH_GAELIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 28,  # 'B'
    67: 25,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 32,  # 'F'
    71: 27,  # 'G'
    72: 41,  # 'H'
    73: 34,  # 'I'
    74: 52,  # 'J'
    75: 54,  # 'K'
    76: 37,  # 'L'
    77: 30,  # 'M'
    78: 35,  # 'N'
    79: 39,  # 'O'
    80: 33,  # 'P'
    81: 61,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 23,  # 'T'
    85: 42,  # 'U'
    86: 50,  # 'V'
    87: 47,  # 'W'
    88: 60,  # 'X'
    89: 57,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 8,  # 'c'
    100: 5,  # 'd'
    101: 6,  # 'e'
    102: 18,  # 'f'
    103: 13,  # 'g'
    104: 2,  # 'h'
    105: 3,  # 'i'
    106: 59,  # 'j'
    107: 44,  # 'k'
    108: 11,  # 'l'
    109: 15,  # 'm'
    110: 4,  # 'n'
    111: 12,  # 'o'
    112: 21,  # 'p'
    113: 62,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 14,  # 'u'
    118: 46,  # 'v'
    119: 43,  # 'w'
    120: 51,  # 'x'
    121: 40,  # 'y'
    122: 55,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 0,  # 'Ç'
    131: 0,  # 'É'
    132: 0,  # 'Ñ'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 0,  # 'á'
    136: 17,  # 'à'
    137: 0,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 0,  # 'ç'
    142: 0,  # 'é'
    143: 22,  # 'è'
    144: 0,  # 'ê'
    145: 0,  # 'ë'
    146: 0,  # 'í'
    147: 20,  # 'ì'
    148: 0,  # 'î'
    149: 0,  # 'ï'
    150: 0,  # 'ñ'
    151: 0,  # 'ó'
    152: 19,  # 'ò'
    153: 0,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 0,  # 'ú'
    157: 24,  # 'ù'
    158: 0,  # 'û'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 0,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 45,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 0,  # 'Â'
    230: 0,  # 'Ê'
    231: 0,  # 'Á'
    232: 0,  # 'Ë'
    233: 48,  # 'È'
    234: 0,  # 'Í'
    235: 0,  # 'Î'
    236: 0,  # 'Ï'
    237: 56,  # 'Ì'
    238: 0,  # 'Ó'
    239: 0,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 53,  # 'Ò'
    242: 0,  # 'Ú'
    243: 0,  # 'Û'
    244: 49,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_SCOTTISH_GAELIC_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="Scottish Gaelic",
    char_to_order_map=MACROMAN_SCOTTISH_GAELIC_CHAR_TO_ORDER,
    language_model=SCOTTISH_GAELIC_LANG_MODEL,
    typical_positive_ratio=0.9919494770482096,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÌÒÙàèìòù",
)

WINDOWS_1252_SCOTTISH_GAELIC_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 26,  # 'A'
    66: 28,  # 'B'
    67: 25,  # 'C'
    68: 31,  # 'D'
    69: 38,  # 'E'
    70: 32,  # 'F'
    71: 27,  # 'G'
    72: 41,  # 'H'
    73: 34,  # 'I'
    74: 52,  # 'J'
    75: 54,  # 'K'
    76: 37,  # 'L'
    77: 30,  # 'M'
    78: 35,  # 'N'
    79: 39,  # 'O'
    80: 33,  # 'P'
    81: 61,  # 'Q'
    82: 36,  # 'R'
    83: 29,  # 'S'
    84: 23,  # 'T'
    85: 42,  # 'U'
    86: 50,  # 'V'
    87: 47,  # 'W'
    88: 60,  # 'X'
    89: 57,  # 'Y'
    90: 58,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 16,  # 'b'
    99: 8,  # 'c'
    100: 5,  # 'd'
    101: 6,  # 'e'
    102: 18,  # 'f'
    103: 13,  # 'g'
    104: 2,  # 'h'
    105: 3,  # 'i'
    106: 59,  # 'j'
    107: 44,  # 'k'
    108: 11,  # 'l'
    109: 15,  # 'm'
    110: 4,  # 'n'
    111: 12,  # 'o'
    112: 21,  # 'p'
    113: 62,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 14,  # 'u'
    118: 46,  # 'v'
    119: 43,  # 'w'
    120: 51,  # 'x'
    121: 40,  # 'y'
    122: 55,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 45,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 48,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 56,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 53,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 49,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 17,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 22,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 20,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 19,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 24,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

WINDOWS_1252_SCOTTISH_GAELIC_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="Scottish Gaelic",
    char_to_order_map=WINDOWS_1252_SCOTTISH_GAELIC_CHAR_TO_ORDER,
    language_model=SCOTTISH_GAELIC_LANG_MODEL,
    typical_positive_ratio=0.9919494770482096,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÌÒÙàèìòù",
)
