% title: Hyphenation patterns for Polish
% copyright: Copyright (C) 1987-1995 Hanna Koodziejska, Bogusaw Jackowski, Marek Ryko
% notice: This file is part of the hyph-utf8 package.
%     See http://www.hyphenation.org/tex for more information.
% language:
%     name: Polish
%     tag: pl
% version: 3.0a, Wednesday, May 17th, 1995
% authors:
%   -
%     name: Hanna Koodziejska
%   -
%     name: Bogusaw Jackowski
%     contact: b_jackowski (at) gust.org.pl
%   -
%     name: Marek Ryko
%     contact: marek (at) do.com.pl
% licence:
%     - This file is made available under any of the following licences:
%     -
%         name: MIT
%         url: https://opensource.org/licenses/MIT
%         text: >
%             Permission is hereby granted, free of charge, to any person
%             obtaining a copy of this software and associated documentation
%             files (the ``Software''), to deal in the Software without
%             restriction, including without limitation the rights to use,
%             copy, modify, merge, publish, distribute, sublicense, and/or sell
%             copies of the Software, and to permit persons to whom the
%             Software is furnished to do so, subject to the following
%             conditions:
%
%             The above copyright notice and this permission notice shall be
%             included in all copies or substantial portions of the Software.
%
%             THE SOFTWARE IS PROVIDED ``AS IS'', WITHOUT WARRANTY OF ANY KIND,
%             EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
%             OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
%             NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
%             HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
%             WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
%             FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
%             OTHER DEALINGS IN THE SOFTWARE.
%     - text: >
%         This macro file belongs to the public domain
%         under the conditions specified by the author of TeX:
%
%           ``Macro files like PLAIN.TEX should not be changed in any way,
%             except with respect to preloaded fonts,
%             unless the changes are authorized by the authors of the macros.''
%
%                                                   Donald E. Knuth
% hyphenmins:
%     typesetting:
%         left: 2
%         right: 2
% changes:
%     - The first version of the patterns was developed
%           by Hanna Koodziejska (1987).
%     - The adaptation to the LeX format (see below) and extensive modification
%           were done by Bogusaw Jackowski & Marek Ryko (1987--1989).
%     - The hyphenation rules were further improved and adapted to the
%           TeX 3.x requirements by Hanna Koodziejska (1991).
%     - Lone-standing version (3.0a) of patterns was prepared (under pressure
%           from LaTeX users) by Bogusaw Jackowski and Marek Ryko, following
%           Mariusz Olko's suggestions, 1995.
%     - The LeX format mentioned above was the first version of the adaptation
%           of TeX to the Polish language. The next version is called MeX.
% texlive:
%     encoding: qx
%     babelname: polish
%     legacy_patterns: plhyph.tex
%     message: Polish hyphenation patterns
%     description: |-
%         Hyphenation patterns for Polish in QX and UTF-8 encodings.
%         These patterns are also used by Polish TeX formats MeX and LaMeX.
%
\patterns{
.8
.8
.8
.8
.8
.8
.8
.b8
.c8
.d8
.f8
.g8
.h8
.j8
.k8
.l8
.m8
.n8
.p8
.r8
.s8
.t8
.v8
.w8
.wier23
.x8
.z8
.8
.8
.8
.8
.8
.8
.8
.b8
.c8
.d8
.f8
.g8
.h8
.j8
.k8
.l8
.m8
.n8
.p8
.r8
.s8
.t8
.v8
.w8
.x8
.z8
.8
.8
.8
.8
.8
.8
.8
.b8
.c8
.d8
.f8
.g8
.h8
.j8
.k8
.l8
.m8
.n8
.p8
.r8
.s8
.t8
.v8
.w8
.x8
.z8
.8
.8
.8
.8
.8
.8
.8
.b8
.c8
.d8
.f8
.g8
.h8
.j8
.k8
.l8
.m8
.n8
.p8
.r2d5
.rdr2
.r8
.s8
.t8
.v8
.w8
.wiato3w2
.x8
.z8
.8
.8
.8
.8
.8
.8
.8
.b8
.c8
.d8
.d8
.f8
.g8
.h8
.j8
.k8
.l8
.m8
.n8
.p8
.r8
.s8
.t8
.v8
.w8
.x8
.z8
.8
.8
.8
.8
.8
.8
.8
.b8
.c8
.d8
.f8
.g8
.h8
.j8
.k8
.l8
.m8
.n8
.p8
.r8
.s8
.t8
.v8
.w8
.x8
.z8
.a2b2s3t
.a2d3
.ad4a
.ad4e
.ad4i
.ad4o
.ad4u
.ad4y
.ad5apt
.ad5iu
.ad5op
.ad5or
.ae3ro
.aeroa2
.aeroe2
.aeroi2
.aeroo2
.aerou2
.antya2
.antye2
.antyi2
.antyo2
.antyu2
.arcy32
.arcy3b2
.arcy3bz2
.arcy3k2
.arcy3m2
.arcya2
.arcye2
.arcyi2
.arcyo2
.arcyu2
.au3g2
.au3k2
.au3t2
.auto3ch2
.autoa2
.autoe2
.autoi2
.autoo2
.autotran2s3
.autou2
.b8
.b8
.b8
.b8
.b8
.b8
.b8
.bb8
.bc8
.bd8
.be2z3
.be3z4an
.be3z4ec
.be3z4ik
.bezch2
.bezm2
.bezo2
.bezo2b1j
.bezw2
.bezzw2
.bf8
.bg8
.bh8
.bj8
.bk8
.bl8
.bm8
.bn8
.bp8
.br8
.brz8
.bs8
.bt8
.bv8
.bw8
.bx8
.bz8
.c8
.c8
.c8
.c8
.c8
.c8
.c8
.cao32
.cao3k2
.cb8
.cc8
.cd8
.cf8
.cg8
.ch8
.chrz8
.cienko3w2
.ciepo3kr2
.cj8
.ck8
.cl8
.cm8
.cn8
.cp8
.cr8
.cs8
.ct8
.cv8
.cw8
.cx8
.cz8
.czarno3k2
.czk8
.cztere2ch3
.czterechse2t3
.cztero32
.czw2r3
.czw3r4
.czw3r4
.czw3r4a
.czw3r4e
.czw3r4o
.d8
.d8
.dugo3tr2
.dugo3w2
.d8
.d8
.d8
.d8
.d8
.daleko3w2
.db8
.dc8
.dd8
.de2z3
.de3z4a3bil
.de3z4a3wu
.de3z4el
.de3z4er
.de3z4y
.deza2
.dezo2
.df8
.dg8
.dh8
.dj8
.dk8
.dl8
.dm8
.dn8
.do32
.do32
.do32
.do32
.do32
.do3b2
.do3c2
.do3d2
.do3f2
.do3g2
.do3h2
.do3k2
.do3l2
.do3m2
.do3p2
.do3r2
.do3s2
.do3t2
.do3w2
.do3z2
.do43k
.do4k3t
.do4l3n
.do4m3k
.do4r3s
.do4w3c
.do5m4k2n
.dobr2
.dobrz2
.doch2
.docz2
.dod2
.dod2
.dodz2
.dogrz2
.dopch2
.doprz2
.dor2
.dorz2
.dosch2
.dosm2
.dosz2
.dotk2
.dotr2
.dp8
.dr8
.drogo3w2
.drz8
.ds8
.dt8
.dv8
.dw2j3
.dw3j4
.dw3j4
.dw3j4a
.dw3j4e
.dw3j4o
.dw8
.dx8
.dy2s3
.dy2z3
.dy3s4e
.dy3s4o
.dy3s4ta
.dy3s4y
.dy3sz
.dy3z4e
.dyzu2
.dz8
.dziesicio32
.dziewise2t3
.dziewi23
.dziewicio32
.e2k2s3
.e2m3e2s5ze2t
.e2s1e2s1ma
.e2s1ha
.e2s1t
.egoa2
.egoe2
.egoi2
.egoo2
.egou2
.eks4y
.elektroa2
.elektroe2
.elektroi2
.elektroo2
.elektrou2
.f8
.f8
.f8
.f8
.f8
.f8
.f8
.fb8
.fc8
.fd8
.ff8
.fg8
.fh8
.fj8
.fk8
.fl8
.fm8
.fn8
.fp8
.fr8
.fs8
.ft8
.fv8
.fw8
.fx8
.fz8
.g8
.g8
.g8
.g8
.g8
.g8
.g8
.gb8
.gc8
.gd8
.ge2o3
.gf8
.gg8
.gh8
.gj8
.gk8
.gl8
.gm8
.gn8
.go2u3
.gp8
.gr8
.grubo3w2
.grz8
.gs8
.gt8
.gv8
.gw8
.gx8
.gz8
.h8
.h8
.h8
.h8
.h8
.h8
.h8
.hb8
.hc8
.hd8
.hf8
.hg8
.hh8
.hipe2r3
.hipe3r4o
.hipera2
.hipere2
.hj8
.hk8
.hl8
.hm8
.hn8
.hp8
.hr8
.hs8
.ht8
.hv8
.hw8
.hx8
.hz8
.i2n3
.i2s3l
.i3n4ic
.i3n4o
.i3n4u
.i4n5o2k
.in4f3lan
.ino3w2
.izoa2
.izoe2
.izoi2
.izoo2
.izou2
.j8
.j8
.j8
.j8
.j8
.j8
.j8
.jado3w2
.jb8
.jc8
.jd8
.jf8
.jg8
.jh8
.jj8
.jk8
.jl8
.jm8
.jn8
.jp8
.jr8
.js8
.jt8
.jv8
.jw8
.jx8
.jz8
.k8
.k8
.k8
.k8
.k8
.k8
.k8
.kb8
.kc8
.kd8
.kf8
.kg8
.kh8
.kilkuse2t3
.kilkuseto2
.kj8
.kk8
.kl8
.km8
.kn8
.koo3w2
.kon2t2r3
.kon3tr4a
.kon3tr4e
.kon3tr4o3l
.kon3tr4o3w
.kon3tr4y
.kon4tr5a2gi
.kon4tr5a2se
.kon4tr5a2sy
.kon4tr5a2ta
.kon4tr5adm
.kon4tr5akc
.kon4tr5alt
.kon4tr5arg
.kontro2
.kontru2
.kp8
.krtko3tr2
.krtko3w2
.kr8
.kro23
.krz8
.ks8
.kt8
.kv8
.kw8
.kx8
.kz8
.l8
.l8
.l8
.l8
.l8
.l8
.l8
.lb8
.lc8
.ld8
.lf8
.lg8
.lh8
.lj8
.lk8
.ll8
.lm8
.ln8
.lp8
.lr8
.ls8
.lt8
.ludo3w2
.lv8
.lw8
.lx8
.lz8
.m8
.m8
.m8
.m8
.m8
.m8
.m8
.mb8
.mc8
.md8
.mf8
.mg8
.mh8
.mili3amp
.mj8
.mk8
.ml8
.mm8
.mn8
.mono3w2
.mp8
.mr8
.ms8
.mt8
.mv8
.mw8
.mx8
.mz8
.n8
.n8
.n8
.n8
.n8
.n8
.n8
.na2d2
.na2j
.na32
.na32
.na32
.na32
.na32
.na3b2
.na3c2
.na3d
.na3d
.na3d2
.na3d4ub
.na3d4ir
.na3d4much
.na3d4rcz
.na3d4r2w
.na3d4repcz
.na3d4rept
.na3d4ruk
.na3d4rz
.na3d4worn
.na3daj
.na3de
.na3do
.na3dy
.na3dzi
.na3f2
.na3g2
.na3h2
.na3j
.na3j
.na3jazd
.na3je
.na3k2
.na3l2
.na3m2
.na3p2
.na3r2
.na3s2
.na3t2
.na3u2
.na3w2
.na3z2
.na4d3o2b2
.na4d3o2bojcz
.na4d3o2bowi
.na4d3o2brot
.na4d3o2drz
.na4d3o2kien
.na4d3olbrz
.na4d5rz
.na4d5rz
.na4d5rzecz
.na4d5rzy
.na4d5ziem
.na4f3c
.na4f3t
.na4j3e2f
.na4j3e2g
.na4j3e2k2s
.na4j3e2ko
.na4j3e2n
.na4j3e2r
.na4j3e2s
.na4j3e2w
.na4j3emf
.na4j3eu
.na4r3c
.na4r3d
.na4r3k
.na4r3r
.na4r3t
.nabrz2
.nach2
.nacz2
.nadrod5ziem
.nad32
.nad32
.nad32
.nad3b2
.nad3c2
.nad3d2
.nad3e2tat
.nad3f2
.nad3g2
.nad3h2
.nad3i2
.nad3j2
.nad3k2
.nad3l2
.nad3m2
.nad3n2
.nad3p2
.nad3r2
.nad3s2
.nad3t2
.nad3u2
.nad3w2
.nad52
.nad5z
.nad5z2mys
.nad5zo
.nad5zwycz
.nadch2
.nadcz2
.nadd2
.nade32
.nade32
.nade32
.nade32
.nade32
.nade3b2
.nade3c2
.nade3d2
.nade3f2
.nade3g2
.nade3h2
.nade3k2
.nade3l2
.nade3m2
.nade3p2
.nade3r2
.nade3s2
.nade3t2
.nade3w2
.nade3z2
.nade4p3c
.nade4p3n
.nade4p3t
.nadech2
.nadecz2
.naded2
.naded2
.nadedz2
.nader2
.naderz2
.nadesz2
.nadsz2
.nadtr2
.nadz2
.nagrz2
.naj32
.naj32
.naj32
.naj32
.naj32
.naj3akt
.naj3au
.naj3b2
.naj3c2
.naj3d2
.naj3f2
.naj3g2
.naj3h2
.naj3i2
.naj3k2
.naj3l2
.naj3m2
.naj3o2
.naj3o22
.naj3o22
.naj3o22
.naj3o22
.naj3o22
.naj3o2b2
.naj3o2c2
.naj3o2d2
.naj3o2f2
.naj3o2g2
.naj3o2h2
.naj3o2k2
.naj3o2l2
.naj3o2m2
.naj3o2p2
.naj3o2r2
.naj3o2s2
.naj3o2t2
.naj3o2w2
.naj3o2z2
.naj3p2
.naj3r2
.naj3ro2z3
.naj3s2
.naj3t2
.naj3u2
.naj3w2
.naj3z2
.najbe2z3
.najbezw2
.najch2
.najcz2
.najd2
.najd2
.najdo32
.najdo32
.najdo32
.najdo32
.najdo32
.najdo3b2
.najdo3c2
.najdo3d2
.najdo3f2
.najdo3g2
.najdo3h2
.najdo3k2
.najdo3l2
.najdo3m2
.najdo3p2
.najdo3r2
.najdo3s2
.najdo3t2
.najdo3w2
.najdo3z2
.najdoch2
.najdocz2
.najdod2
.najdod2
.najdodz2
.najdorz2
.najdosz2
.najdotk2
.najdz2
.najkr2
.najob32
.najob32
.najob32
.najob32
.najob32
.najob3c2
.najob3d2
.najob3f2
.najob3g2
.najob3h2
.najob3j2
.najob3k2
.najob3l2
.najob3m2
.najob3n2
.najob3p2
.najob3s2
.najob3t2
.najob3w2
.najobch2
.najobcz2
.najobd2
.najobd2
.najobdz2
.najobrz2
.najobsz2
.najoch2
.najocz2
.najod2
.najod32
.najod32
.najod3c2
.najod3d2
.najod3f2
.najod3g2
.najod3h2
.najod3j2
.najod3k2
.najod3l2
.najod3m2
.najod3n2
.najod3p2
.najod3s2
.najod3t2
.najod3w2
.najod52
.najodch2
.najodcz2
.najodd2
.najodd2
.najoddz2
.najodsz2
.najodz2
.najorz2
.najosz2
.najro3z4u
.najrz2
.najsm2
.najsz2
.najtk2
.najtr2
.najucz2
.najzw2
.nakr2
.napo2d2
.napo32
.napo32
.napo32
.napo32
.napo32
.napo3b2
.napo3c2
.napo3f2
.napo3g2
.napo3h2
.napo3k2
.napo3l2
.napo3m2
.napo3p2
.napo3r2
.napo3s2
.napo3t2
.napo3w2
.napo3z2
.napo4m3p
.napoch2
.napocz2
.napod2
.napod2
.napod3d
.napomk2
.naporz2
.naposz2
.naprz2
.nar2
.naro2z3
.narz2
.nasm2
.nasz2
.natch2
.natk2
.naz3m2
.nazw2
.nb8
.nc8
.nd8
.ne2o3
.nf8
.ng8
.nh8
.nie32
.nie32
.nie32
.nie32
.nie32
.nie3b2
.nie3c2
.nie3d2
.nie3f2
.nie3g2
.nie3h2
.nie3k2
.nie3l2
.nie3m2
.nie3p2
.nie3r2
.nie3s2
.nie3t2
.nie3u2
.nie3w2
.nie3z2
.nie4c3c
.nie4c3k
.nie4d3
.nie4m3c
.nie4m3k
.niech2
.niecz2
.nied2
.niedo32
.niedo32
.niedo32
.niedo32
.niedo32
.niedo3b2
.niedo3c2
.niedo3d2
.niedo3f2
.niedo3g2
.niedo3h2
.niedo3k2
.niedo3l2
.niedo3m2
.niedo3p2
.niedo3r2
.niedo3s2
.niedo3t2
.niedo3w2
.niedo3z2
.niedobrz2
.niedoch2
.niedocz2
.niedod2
.niedod2
.niedodz2
.niedokr2
.niedomk2
.niedopch2
.niedorz2
.niedosz2
.niedotk2
.niedz2
.nieo2
.nieo2
.nieo2
.nieo2
.nieo2
.nieo2
.nieob2
.nieob32
.nieob32
.nieob32
.nieob32
.nieob3c2
.nieob3d2
.nieob3f2
.nieob3g2
.nieob3h2
.nieob3j2
.nieob3k2
.nieob3m2
.nieob3p2
.nieob3s2
.nieob3w2
.nieobch2
.nieobcz2
.nieobd2
.nieobd2
.nieobdz2
.nieobsz2
.nieoc2
.nieoch2
.nieocz2
.nieod2
.nieod2
.nieod32
.nieod32
.nieod32
.nieod3c2
.nieod3d2
.nieod3f2
.nieod3g2
.nieod3h2
.nieod3j2
.nieod3k2
.nieod3l2
.nieod3n2
.nieod3p2
.nieod3s2
.nieod3t2
.nieod3wr
.nieod52
.nieodch2
.nieodcz2
.nieodd2
.nieodd2
.nieoddz2
.nieodsz2
.nieodw2
.nieodz2
.nieof2
.nieog2
.nieoh2
.nieok2
.nieol2
.nieom2
.nieop2
.nieor2
.nieorz2
.nieos2
.nieosz2
.nieot2
.nieow2
.nieoz2
.niepo2d2
.niepo32
.niepo32
.niepo32
.niepo32
.niepo32
.niepo3b2
.niepo3c2
.niepo3d2
.niepo3d4u
.niepo3d4much
.niepo3d4rcz
.niepo3d4ra
.niepo3d4rap
.niepo3d4repcz
.niepo3d4rept
.niepo3d4waj
.niepo3d4woj
.niepo3do
.niepo3du
.niepo3dz2
.niepo3f2
.niepo3g2
.niepo3h2
.niepo3k2
.niepo3l2
.niepo3m2
.niepo3p2
.niepo3r2
.niepo3s2
.niepo3t2
.niepo3w2
.niepo3z2
.niepo4d3o2choc
.niepo4d3o2strz
.niepoch2
.niepocz2
.niepod32
.niepod32
.niepod32
.niepod3b2
.niepod3c2
.niepod3d2
.niepod3f2
.niepod3g2
.niepod3h2
.niepod3j2
.niepod3k2
.niepod3l2
.niepod3m2
.niepod3n2
.niepod3p2
.niepod3r2
.niepod3s2
.niepod3t2
.niepod3w2
.niepod5
.niepodch2
.niepodcz2
.niepodd2
.niepodd2
.niepodsm2
.niepodsz2
.nieporz2
.nieposm2
.nieposz2
.nieprzek2
.nieprze2d2
.nieprze32
.nieprze32
.nieprze32
.nieprze32
.nieprze32
.nieprze3b2
.nieprze3brz2
.nieprze3c2
.nieprze3d2
.nieprze3d4u
.nieprze3d4much
.nieprze3d4ramat
.nieprze3d4ruk
.nieprze3d4ryl
.nieprze3d4rz2
.nieprze3d4um
.nieprze3dy
.nieprze3dz2
.nieprze3e2k2s3
.nieprze3f2
.nieprze3g2
.nieprze3h2
.nieprze3k2
.nieprze3l2
.nieprze3m2
.nieprze3n2
.nieprze3p2
.nieprze3r2
.nieprze3s2
.nieprze3t2
.nieprze3w2
.nieprze3z2
.nieprze4d5uyc
.nieprze4d52
.nieprze4d5z2a
.nieprze4d5zg2
.nieprze4d5zim
.nieprze4d5zj
.nieprze4d5zl
.nieprze4d5zw2r
.nieprze4d5zwoj
.nieprzech2
.nieprzecz2
.nieprzed32
.nieprzed32
.nieprzed32
.nieprzed3c2
.nieprzed3d2
.nieprzed3f2
.nieprzed3g2
.nieprzed3h2
.nieprzed3i2
.nieprzed3j2
.nieprzed3k2
.nieprzed3l2
.nieprzed3m2
.nieprzed3n2
.nieprzed3p2
.nieprzed3r2
.nieprzed3s2
.nieprzed3sz2
.nieprzed3t2
.nieprzed3u2
.nieprzed3w2
.nieprzedch2
.nieprzedcz2
.nieprzedd2
.nieprzedd2
.nieprzeddz2
.nieprzegrz2
.nieprzekl2
.nieprzekr2
.nieprzepch2
.nieprzer2
.nieprzerz2
.nieprzesch2
.nieprzesm2
.nieprzesz2
.nieprzetk2
.nieprzetr2
.niero2z3
.niero3z4e
.niero3z4u
.nieroz2
.nierozbrz2
.nieroze3r2
.nierozm2
.nieroztr2
.nierz2
.niesu2b3
.niesu3b4ie
.niesz2
.nietk2
.nietr2
.nieucz2
.nieuw2
.niewy32
.niewy32
.niewy32
.niewy32
.niewy32
.niewy3b2
.niewy3c2
.niewy3d2
.niewy3f2
.niewy3g2
.niewy3h2
.niewy3k2
.niewy3l2
.niewy3m2
.niewy3p2
.niewy3r2
.niewy3s2
.niewy3t2
.niewy3w2
.niewy3z2
.niewybrz2
.niewych2
.niewycz2
.niewyd2
.niewyd2
.niewydz2
.niewyrz2
.niewysz2
.niewytk2
.niewytr2
.niezw2
.nj8
.nk8
.nl8
.nm8
.nn8
.np8
.nr8
.ns8
.nt8
.nv8
.nw8
.nx8
.nz8
.o2
.o2
.omio32
.o2
.o2
.o2b2
.o2d2
.o2t3ch
.o3b4
.o3b4
.o3b4oc
.o3b4luzg
.o3b4ra
.o3b4raso
.o3b4ro
.o3b4ron
.o3b4ry
.o3b4ryz
.o3b4rz2
.o3be
.o3bi
.o3d4iu
.o3d4rt
.o3d4rap
.o3d4robin
.o3d4rut
.o3d4rwi
.o3d4rze
.o3d4rzw
.o3d6zia
.o3d6zie
.o3de
.o3l2n
.o4b5ocz
.o4b5rz
.o4b5rzd
.o4b5rzez
.o4b5rzuc
.o4b5rzut
.o4b5rzyn
.o4d7ziar
.o4d7ziem
.oa3z
.ob32
.ob32
.ob32
.ob32
.ob32
.ob3c2
.ob3d2
.ob3f2
.ob3g2
.ob3h2
.ob3j2
.ob3k2
.ob3l2
.ob3m2
.ob3n2
.ob3o2strz
.ob3p2
.ob3r
.ob3s2
.ob3t2
.ob3u2m2
.ob3w2
.obch2
.obcz2
.obd2
.obd2
.obdz2
.obe32
.obe32
.obe32
.obe32
.obe32
.obe3b2
.obe3c2
.obe3d2
.obe3f2
.obe3g2
.obe3h2
.obe3k2
.obe3l2
.obe3m2
.obe3p2
.obe3r2
.obe3r3t
.obe3s2
.obe3t2
.obe3w2
.obe3z2
.obe4c3n
.obe4z3w
.obech2
.obecz2
.obed2
.obed2
.obedz2
.ober2
.ober3m
.oberz2
.obesch2
.obesz2
.obetk2
.obi3b2
.obsz2
.oc2
.och2
.ochrz2
.ocz2
.od2
.od32
.od32
.od3au
.od3b2
.od3c2
.od3d2
.od3f2
.od3g2
.od3h2
.od3i2
.od3i2zo
.od3j2
.od3k2
.od3l2
.od3m2
.od3n2
.od3o2s
.od3p2
.od3r2
.od3s2
.od3t2
.od3u2cz
.od3u2m2
.od3w2
.od52
.od5z2
.odbe2z3
.odch2
.odcz2
.odd2
.odd2
.oddz2
.ode32
.ode32
.ode32
.ode32
.ode32
.ode3b2
.ode3c2
.ode3d2
.ode3f2
.ode3g2
.ode3h2
.ode3k2
.ode3l2
.ode3m2
.ode3mk2
.ode3p2
.ode3r2
.ode3s2
.ode3t2
.ode3w2
.ode3z2
.odech2
.odecz2
.oded2
.oded2
.odedz2
.odepch2
.oder2
.oderz2
.odesz2
.odetch2
.odetk2
.odkrz2
.odrz2
.odsz2
.of2
.oglno3k2
.og2
.ognio3tr2
.oh2
.ok2
.oka3m2
.okr2
.ole2o3
.om2
.op2
.opch2
.or22
.or2t
.or2z2
.os2
.osie2m3
.osiemse2t3
.osz2
.ot2
.ow2
.oz2
.p8
.p8
.pasko3w2
.p8
.pk2
.pkr2
.pm2
.po2
.pob3r
.pom2d
.pprzy3m2k
.p23
.p34
.p34
.p34ecz
.p34y
.p8
.p8
.p8
.p8
.pb8
.pc8
.pch8
.pd8
.peno3kr2
.pe2r3
.pe3c2k
.pe3r4e
.pe3r4i
.pe3r4o
.pe3r4u
.pe3r4y
.pe4r5i2n
.pee2se2l
.pepee2r
.pepee2s
.peze2t1pee2r
.pf8
.pg8
.ph8
.pise2t3
.pi23
.picio32
.pierwo3w2
.piono3w2
.pj8
.pk8
.pl8
.pm8
.pn8
.pok2
.po2d2
.po32
.po32
.po32
.po32
.po32
.po3b2
.po3c2
.po3d
.po3d
.po3d2
.po3d4u
.po3d4much
.po3d4naw
.po3d4rcz
.po3d4rtw
.po3d4r
.po3d4r2wi
.po3d4ra
.po3d4rap
.po3d4repcz
.po3d4rept
.po3d4ro
.po3d4rob
.po3d4roba
.po3d4robo
.po3d4roby
.po3d4rocz
.po3d4ruzg
.po3d4ryg
.po3d4rze
.po3d4wjn
.po3d4wr
.po3d4waj
.po3d4woi
.po3d4woj
.po3d4worz
.po3da
.po3de
.po3dej
.po3diu
.po3do
.po3du
.po3dy
.po3dz2
.po3e2k2s3
.po3f2
.po3g2
.po3h2
.po3k2
.po3l2
.po3m2
.po3p2
.po3r
.po3r2
.po3s2
.po3t2
.po3w2
.po3z2
.po43c
.po4cz3d
.po4cz3t
.po4d3w
.po4d3e4k2s3
.po4d3o2bz
.po4d3o2biad
.po4d3o2bojcz
.po4d3o2braz
.po4d3o2choc
.po4d3o2dm
.po4d3o2f
.po4d3o2g
.po4d3o2kien
.po4d3o2kn
.po4d3o2krg
.po4d3o2kres
.po4d3o2piecz
.po4d3o2ryw
.po4d3o2siniak
.po4d3o2strz
.po4d3obsz
.po4d3odd
.po4d3olbrz
.po4d3u2cz
.po4d3u2dz
.po4d3u2pa
.po4d3u2ral
.po4d3u2sta
.po4d3u2szcz
.po4d5rczn
.po4d5zakr
.po4d5zam
.po4d5zast
.po4d5zbi
.po4d5ze
.po4d5zieleni
.po4d5zieleni
.po4d5zieleni
.po4d5zieleni
.po4d5zielenic
.po4d5zielenien
.po4d5zielenil
.po4d5zielenim
.po4d5zielenio
.po4d5zielenis
.po4d5ziem
.po4d5ziom
.po4d5zw2r
.po4l3s
.po4m3p
.po4r3c
.po4r3f
.po4r3n
.po4r3t
.po4st3d
.po4st3f
.po4st3g
.po4st3h
.po4st3i2
.po4st3k
.po4st3l
.po4st3m
.po4st3p
.po4st3rom
.po4st3s
.po5d4uszczyn
.po5r4t
.pobr2
.pobrz2
.poch2
.pochrz2
.pocz2
.pod32
.pod32
.pod32
.pod3r2d5
.pod3alp
.pod3b2
.pod3c2
.pod3d2
.pod3f2
.pod3g2
.pod3h2
.pod3i2n
.pod3j2
.pod3k2
.pod3l2
.pod3m2
.pod3n2
.pod3p2
.pod3r2
.pod3s2
.pod3t2
.pod3w2
.pod52
.podch2
.podcz2
.podd2
.podd2
.pode32
.pode32
.pode32
.pode32
.pode32
.pode3b2
.pode3c2
.pode3d2
.pode3f2
.pode3g2
.pode3h2
.pode3k2
.pode3l2
.pode3m2
.pode3p2
.pode3r2
.pode3s2
.pode3t2
.pode3tk2
.pode3w2
.pode3z2
.podech2
.podecz2
.poded2
.poded2
.podedz2
.podepch2
.poder2
.poderz2
.podesch2
.podesz2
.podro2z3
.podsm2
.podsz2
.pogrz2
.pokl2
.pokr2
.pom4pk
.pomk2
.pona2d2
.pona32
.pona32
.pona32
.pona32
.pona32
.pona3b2
.pona3c2
.pona3cz2
.pona3d2
.pona3do
.pona3f2
.pona3g2
.pona3h2
.pona3k2
.pona3l2
.pona3m2
.pona3p2
.pona3r2
.pona3s2
.pona3t2
.pona3w2
.pona3z2
.pona4f3t
.ponabrz2
.ponach2
.ponad32
.ponad32
.ponad3c2
.ponad3ch2
.ponad3cz2
.ponad3d2
.ponad3f2
.ponad3g2
.ponad3h2
.ponad3j2
.ponad3k2
.ponad3l2
.ponad3p2
.ponad3s2
.ponad3t2
.ponadz2
.ponarz2
.ponasm2
.ponasz2
.ponaz3m2
.ponazw2
.ponie3k2
.ponie3w2
.popch2
.popo3w2
.poprz2
.por4t1w
.por4tf
.por4tm
.poro2z3
.poro3z4u
.porz2
.posch2
.posm2
.posz2
.potk2
.potr2
.poz4m2
.poza3u2
.pozw2
.pp8
.pr8
.pra3s2
.pra3w2nu
.pra3w2z
.prapra3w2nu
.predy2s3po
.prz8
.przek2
.prze2d2
.prze32
.prze32
.prze32
.prze32
.prze32
.prze3b2
.prze3c2
.prze3d
.prze3d
.prze3d2
.prze3d4u
.prze3d4much
.prze3d4o3br
.prze3d4o3st
.prze3d4o3zo
.prze3d4ramat
.prze3d4ruk
.prze3d4ryl
.prze3d4rz2
.prze3d4um
.prze3dy
.prze3dz2
.prze3e2k2s3
.prze3f2
.prze3g2
.prze3h2
.prze3k2
.prze3l2
.prze3m2
.prze3n2
.prze3p2
.prze3r2
.prze3s2
.prze3t2
.prze3u2
.prze3w2
.prze3z2
.prze4d5uyc
.prze4d52
.prze4d5o4stat
.prze4d5za
.prze4d5zg2
.prze4d5zim
.prze4d5zj
.prze4d5zl
.prze4d5zw2r
.prze4d5zwoj
.przebr2
.przebrz2
.przech2
.przechrz2
.przeci2w3
.przeci3w4ie
.przeciwa2
.przeciww2
.przecz2
.przed32
.przed32
.przed32
.przed3a2gon
.przed3a2kc
.przed3alp
.przed3b2
.przed3c2
.przed3d2
.przed3e2gz
.przed3e2mer
.przed3f2
.przed3g2
.przed3h2
.przed3i2
.przed3j2
.przed3k2
.przed3l2
.przed3m2
.przed3n2
.przed3o2
.przed3p2
.przed3r2
.przed3s2
.przed3si3w2
.przed3sz2
.przed3t2
.przed3u2
.przed3w2
.przedch2
.przedcz2
.przedd2
.przedd2
.przeddz2
.przedgrz2
.przedy2s3ku
.przegrz2
.przekl2
.przekr2
.przemk2
.przepch2
.przer2
.przerz2
.przesch2
.przesm2
.przesz2
.przetk2
.przetr2
.przetran2s3
.przy32
.przy32
.przy32
.przy32
.przy32
.przy3b2
.przy3c2
.przy3d2
.przy3f2
.przy3g2
.przy3h2
.przy3k2
.przy3l2
.przy3m2
.przy3p2
.przy3r2
.przy3s2
.przy3t2
.przy3w2
.przy3z2
.przybr2
.przych2
.przycz2
.przyd2
.przyd2
.przydz2
.przygrz2
.przymk2
.przyoz2
.przypch2
.przyr2
.przyrz2
.przysch2
.przysz2
.przytk2
.ps8
.pt8
.pv8
.pw8
.px8
.pz8
.r8
.r8
.r8
.r8
.r8
.r8
.r8
.rb8
.rc8
.rd8
.retran2s3
.rf8
.rg8
.rh8
.rj8
.rk8
.rl8
.rm8
.rn8
.ro2z3
.ro3z4a
.ro3z4e
.ro3z4e32
.ro3z4e32
.ro3z4e32
.ro3z4e32
.ro3z4e32
.ro3z4e3b2
.ro3z4e3c2
.ro3z4e3d2
.ro3z4e3f2
.ro3z4e3g2
.ro3z4e3h2
.ro3z4e3k2
.ro3z4e3l2
.ro3z4e3m2
.ro3z4e3p2
.ro3z4e3r2
.ro3z4e3s2
.ro3z4e3t2
.ro3z4e3w2
.ro3z4e3z2
.ro3z4ej
.ro3z4u
.ro4z5a2gi
.ro4z5a2nie
.ro4z5e2mo
.ro4z5e4g3z
.ro4z5e4n3t
.roz2
.rozbrz2
.rozd2
.rozech2
.rozecz2
.rozed2
.rozed2
.rozedz2
.rozepch2
.rozer2
.rozerz2
.rozesch2
.rozesz2
.rozi2
.rozm2
.rozo2
.rozpo3w2
.rozt2
.roztr2
.rozw2
.rp8
.rr8
.rs8
.rt8
.rv8
.rw8
.rx8
.rz8
.s8
.s8
.s8
.s8
.s8
.s8
.s8
.samo3ch2
.samo3k2
.samo3p2
.samo3w2
.samoro2z3
.sb8
.sc8
.sch8
.sd8
.sf8
.sg8
.sh8
.siede2m3
.siedemse2t3
.siedmio32
.sj8
.sk2d5e
.sk8
.skl8
.skr8
.sl8
.sm8
.sn8
.sobo3w2
.sp23
.sp8
.spo2d2
.spo32
.spo32
.spo32
.spo32
.spo32
.spo3b2
.spo3c2
.spo3dz2
.spo3f2
.spo3g2
.spo3h2
.spo3k2
.spo3l2
.spo3m2
.spo3p2
.spo3r2
.spo3s2
.spo3t2
.spo3w2
.spo3z2
.spo4r3n
.spo4r3t
.spoch2
.spocz2
.spod2
.spod2
.spod3d
.sporz2
.sposz2
.sr8
.ss8
.st8
.stere2o3
.stereoa2
.stereoe2
.stereoi2
.stereoo2
.stereou2
.su2b3
.su3b4ie
.su3b4otn
.supe2r3
.supe3r4at
.supe3r4io
.supe4r5a2tr
.super5z2b
.supere2
.supero2d1rzut
.sv8
.sw8
.sx8
.sz8
.szese2t3
.szecio32
.sze223
.sze2s3
.t8
.t8
.t8
.t8
.t8
.t8
.t8
.ta2o3
.ta2r7zan
.tb8
.tc8
.tch8
.td8
.te2o3
.tf8
.tg8
.th8
.tj8
.tk8
.tl8
.tm8
.tn8
.toa3
.tp8
.tr2j3
.tr3j4
.tr3j4
.tr3j4ecz
.tr8
.tran2s3
.tran3s4e
.tran3s4ie
.tran3s4y
.tran3sz
.tran4s5eu
.transa2
.transo2
.trz8
.trze2ch3
.trzechse2t3
.ts8
.tt8
.tv8
.tw8
.tx8
.tysi2c3
.tysi3c4a
.tysi3c4e
.tysi3cz
.tysi4c5z
.tz8
.u2
.u2
.u32
.u32
.u32
.u3b2
.u3c2
.u3d2
.u3f2
.u3g2
.u3h2
.u3k2
.u3l2
.u3m2
.u3n2
.u3p2
.u3r2
.u3s2
.u3t2
.u3w2
.u3z2
.u4d3k
.u4f3n
.u4k3lej
.u4l3s
.u4l3t
.u4m3br
.u4n3c
.u4n3d
.u4p3p2s
.u4r3s
.u4st3n
.u4stc
.u4stk
.u4z3be
.ube2z3
.ubezw2
.ubr2
.uch2
.ucz2
.ud2
.ud2
.udz2
.ukr2
.umk2
.upch2
.upo2d2
.upo32
.upo32
.upo32
.upo32
.upo32
.upo3b2
.upo3c2
.upo3da
.upo3f2
.upo3g2
.upo3h2
.upo3k2
.upo3l2
.upo3m2
.upo3p2
.upo3r2
.upo3s2
.upo3t2
.upo3w2
.upo3z2
.upoch2
.upocz2
.upod2
.upod2
.upod3d
.uporz2
.uposz2
.ur2
.uro2z3
.urz2
.usch2
.usz2
.utk2
.utr2
.uze3w2
.v8
.v8
.v8
.v8
.v8
.v8
.v8
.vb8
.vc8
.vd8
.vf8
.vg8
.vh8
.vj8
.vk8
.vl8
.vm8
.vn8
.vp8
.vr8
.vs8
.vt8
.vv8
.vw8
.vx8
.vz8
.w8
.w8
.w8
.w8
.w8
.w8
.w8
.wb8
.wc8
.wd8
.we32
.we32
.we32
.we32
.we3b2
.we3c2
.we3d2
.we3f2
.we3g2
.we3h2
.we3k2
.we3l2
.we3m2
.we3n2
.we3p2
.we3r2
.we3s2
.we3t2
.we3w2
.we3z2
.we43n
.we4k3t
.we4l3w
.we4n3d
.we4n3t
.we4r3b
.we4r3d
.we4r3n
.we4r3s
.we4r3t
.we4s3prz
.we4s3tch2
.we4z3br
.we4z3g
.wech2
.wecz2
.wed2
.wed2
.wedz2
.wemk2
.wepch2
.werz2
.wesz2
.wetk2
.wewn2trz3
.wf8
.wg8
.wh8
.wielo32
.wielo3d2
.wielo3k2
.wieluse2t3
.wilczo3m2
.wj8
.wk8
.wl8
.wm8
.wn8
.wniebo3w2
.wodo3w2
.wp8
.wr8
.ws8
.wspi2
.wspo2b3w
.wspu2
.wspw2
.wsp23
.wsze2ch3
.wszecho2
.wszechw2
.wt8
.wv8
.ww8
.wx8
.wy32
.wy32
.wy32
.wy32
.wy32
.wy3b2
.wy3c2
.wy3d2
.wy3f2
.wy3g2
.wy3h2
.wy3k2
.wy3l2
.wy3m2
.wy3o2d3r
.wy3p2
.wy3r2
.wy3s2
.wy3t2
.wy3w2
.wy3z2
.wy43sz
.wy4cz3ha
.wybr2
.wybrz2
.wych2
.wycz2
.wyd2
.wyd2
.wydr2
.wydz2
.wye2k2s3
.wygrz2
.wyi2zo
.wykl2
.wykr2
.wykrz2
.wymk2
.wypch2
.wyprz2
.wyr2
.wyrz2
.wysch2
.wysm2
.wysz2
.wytch2
.wytk2
.wytr2
.wz8
.x8
.x8
.x8
.x8
.x8
.x8
.x8
.xb8
.xc8
.xd8
.xf8
.xg8
.xh8
.xj8
.xk8
.xl8
.xm8
.xn8
.xp8
.xr8
.xs8
.xt8
.xv8
.xw8
.xx8
.xz8
.z8
.z8
.zo3w2
.z8
.z8
.z8
.z8
.z8
.za32
.za32
.za32
.za32
.za32
.za3b2
.za3c2
.za3d2
.za3f2
.za3g2
.za3h2
.za3k2
.za3l2
.za3m2
.za3o2b3r
.za3o2b3s
.za3p2
.za3r2
.za3s2
.za3t2
.za3u2
.za3w2
.za3z2
.za4k3t
.za4l3g
.za4l3k
.za4l3t
.za4m3k
.za4r3ch
.za4uto
.za5m4k2n
.zabr2
.zabrz2
.zach2
.zacz2
.zad2
.zad2
.zadou4
.zado23
.zadr2
.zady2s3po
.zadz2
.zagrz2
.zai2n3
.zai2zo
.zain4ic
.zakl2
.zakr2
.zakrz2
.zanie3d2
.zar2
.zarz2
.zasch2
.zasm2
.zasz2
.zatk2
.zatr2
.zb8
.zc8
.zd8
.zde2z3
.zde3z4awu
.zde3z4el
.zde3z4er
.zde3z4y
.zdy2s3kont
.zdy2s3kred
.zdy2s3kwal
.ze32
.ze32
.ze32
.ze32
.ze32
.ze3b2
.ze3c2
.ze3d2
.ze3f2
.ze3g2
.ze3h2
.ze3k2
.ze3l2
.ze3m2
.ze3p2
.ze3r2
.ze3s2
.ze3t2
.ze3tk2
.ze3w2
.ze3z2
.ze4r3k
.ze4t3e2m1e2s
.ze4t3e2s1e2l
.ze4t3emp
.ze4t3hap
.zech2
.zecz2
.zed2
.zed2
.zedz2
.zekl2
.zepch2
.zer2
.zerz2
.zesch2
.zesm4
.zesz2
.zf8
.zg8
.zh8
.zimno3kr2
.zj8
.zk8
.zl8
.zm8
.zmartwy2ch3
.zmartwychw2
.zn8
.znie32
.znie32
.znie32
.znie32
.znie32
.znie32
.znie3b2
.znie3c2
.znie3d2
.znie3f2
.znie3g2
.znie3h2
.znie3k2
.znie3l2
.znie3m2
.znie3n2
.znie3p2
.znie3r2
.znie3s2
.znie3t2
.znie3w2
.znie3z2
.znie4d3
.znie4m3c
.zniech2
.zniecz2
.znied2
.zniedz2
.znierz2
.zniesz2
.zo2o3
.zp8
.zr8
.zro2z3
.zro3z4u
.zs8
.zt8
.zv8
.zw8
.zx8
.zz8
1
1
1
4w3cz
1c
2d
12ci
21
21
21
21
21b
21c
21d
21f
21g
21k
21m
21n
21p
21s
21t
21z
21
21
21
21
21
21b
21c
21d
21f
21g
21h
21j
21k
21l
21m
21n
21p
21r
21s
21t
21w
21z
21
21
21
21
21
21
21b
21c
21d
21f
21g
21h
21j
21k
21l
21m
21n
21p
21r
21s
21t
21w
21z
2c
21
21
21
21b
21d
21f
21g
21k
21p
21s
21t
21z
2lm
2ln
21
21
21
21b
21c
21d
21f
21g
21k
21l
21m
21n
21p
21s
21t
21w
21z
21
21
21
21
21
21b
21c
21d
21f
21g
21j
21k
21l
21m
21n
21p
21r
21s
21t
21w
21z
2bk
2b1
2b1
2b1
2b1
2b1
2b1c
2b1d
2b1f
2b1g
2b1k
2b1m
2b1n
2b1p
2b1s
2b1t
2b1z
2brn
2c1
2c1
2c1
2c1
2c1
2c1b
2c1d
2c1f
2c1g
2c1k
2c1l
2c1m
2c1n
2c1p
2c1s
2c1t
2ch1
2ch1
2ch1
2ch1
2ch1
2ch1b
2ch1c
2ch1d
2ch1f
2ch1g
2ch1k
2ch1m
2ch1n
2ch1p
2ch1s
2ch1t
2ch1z
2cz1
2cz1
2cz1
2cz1
2cz1
2cz1b
2cz1c
2cz1d
2cz1f
2cz1g
2cz1k
2cz1l
2cz1m
2cz1n
2cz1p
2cz1s
2cz1t
2cz1z
2db
2dsz
2d1
2d1
2d1
2d1
2d1
2d1b
2d1c
2d1d
2d1f
2d1g
2d1k
2d1m
2d1n
2d1p
2d1s
2d1t
2d1z
2d1
2d1
2d1
2d1
2d1
2d1b
2d1c
2d1d
2d1f
2d1g
2d1k
2d1m
2d1n
2d1p
2d1s
2d1t
2d1z
2d1
2d1
2d1
2d1b
2d1c
2d1f
2d1g
2d1k
2d1m
2d1n
2d1p
2d1s
2d1t
2drn
2dz1
2dz1
2dz1
2dz1
2dz1
2dz1b
2dz1c
2dz1d
2dz1f
2dz1g
2dz1k
2dz1l
2dz1m
2dz1n
2dz1p
2dz1s
2dz1t
2dz1z
2f1c
2f1k
2f1m
2f1n
2gb
2g1
2g1
2g1
2g1
2g1
2g1b
2g1c
2g1d
2g1f
2g1k
2g1m
2g1p
2g1s
2g1t
2g1z
2h1
2h1
2h1
2h1
2h1
2h1
2h1b
2h1c
2h1d
2h1f
2h1g
2h1j
2h1k
2h1l
2h1m
2h1n
2h1p
2h1r
2h1s
2h1t
2h1w
2h1z
2j1
2j1
2j1
2j1
2j1
2j1
2j1b
2j1c
2j1d
2j1f
2j1g
2j1h
2j1k
2j1l
2j1m
2j1n
2j1p
2j1r
2j1s
2j1t
2j1w
2j1z
2kb
2k1
2k1
2k1
2k1
2k1
2k1b
2k1c
2k1d
2k1f
2k1g
2k1m
2k1n
2k1p
2k1s
2k1sz
2k1t
2k1z
2l1
2l1
2l1
2l1
2l1
2l1
2l1b
2l1c
2l1d
2l1f
2l1g
2l1h
2l1j
2l1k
2l1m
2l1n
2l1p
2l1r
2l1s
2l1t
2l1w
2l1z
2m1
2m1
2m1
2m1
2m1
2m1
2m1b
2m1c
2m1d
2m1f
2m1g
2m1h
2m1j
2m1k
2m1l
2m1n
2m1p
2m1r
2m1s
2m1t
2m1w
2m1z
2n1
2n1
2n1
2n1
2n1
2n1
2n1b
2n1c
2n1d
2n1f
2n1g
2n1h
2n1j
2n1k
2n1l
2n1m
2n1p
2n1r
2n1s
2n1t
2n1w
2n1z
2ntn
2p1
2p1
2p1
2p1
2p1
2p1b
2p1c
2p1d
2p1f
2p1g
2p1k
2p1m
2p1n
2p1s
2p1sz
2p1t
2p1z
2pln
2r1
2r1
2r1
2r1
2r1
2r1
2r1b
2r1c
2r1d
2r1f
2r1g
2r1h
2r1j
2r1k
2r1l
2r1m
2r1n
2r1p
2r1s
2r1t
2r1w
2rz1
2rz1
2rz1
2rz1
2rz1
2rz1
2rz1b
2rz1c
2rz1d
2rz1f
2rz1g
2rz1h
2rz1j
2rz1k
2rz1l
2rz1m
2rz1n
2rz1p
2rz1r
2rz1s
2rz1t
2rz1w
2sb
2s1
2s1
2s1b
2s1d
2s1f
2s1g
2s1s
2snk
2stk
2stn
2stsz
2sz1
2sz1
2sz1c
2sz1f
2sz1k
2sz1l
2sz1m
2sz1n
2sz1p
2sz1s
2sz1t
2sz1w
2sz1z
2szln
2t1
2t1
2t1
2t1
2t1
2t1b
2t1c
2t1d
2t1f
2t1g
2t1k
2t1m
2t1n
2t1p
2t1s
2t1z
2tln
2trk
2trzn
2w1
2w1
2w1
2w1
2w1
2w1
2w1b
2w1c
2w1d
2w1f
2w1g
2w1j
2w1k
2w1l
2w1m
2w1n
2w1p
2w1r
2w1s
2w1t
2w1z
2z1
2z1
2z1c
2z1d
2z1f
2z1k
2z1p
2z1s
2z1t
2zdk
2zdn
3d2niow
3k2sz2t
3m2k2n
3m2nest
3m2nezj
3m2sk2n
3p2neu
3w2ad
3w2os
3w2czas
43
43
43
43
4b3b
4c3c
4d3d
4f3f
4g3g
4h3h
4j3j
4k3k
4l3l
4m3m
4n3n
4p3p
4r3r
4t3t
4w3w
4z3z
8.
8.
8.
8.
8.
8.
8.
8b.
8c.
8d.
8f.
8g.
8h.
8j.
8k.
8l.
8m.
8n.
8p.
8r.
8s.
8t.
8v.
8w.
8x.
8z.
8.
8.
8.
8.
8.
8.
8.
8b.
8c.
8d.
8f.
8g.
8h.
8j.
8k.
8l.
8m.
8n.
8p.
8r.
8s.
8t.
8v.
8w.
8x.
8z.
8.
8.
8.
8.
8.
8.
8.
8b.
8c.
8d.
8f.
8g.
8h.
8j.
8k.
8l.
8m.
8n.
8p.
8r.
8s.
8t.
8v.
8w.
8x.
8z.
8.
8.
8.
8.
8.
8.
8.
8b.
8c.
8d.
8f.
8g.
8h.
8j.
8k.
8l.
8m.
8n.
8p.
8r.
8s.
8t.
8v.
8w.
8x.
8z.
8.
8.
8.
8.
8.
8.
8.
8b.
8c.
8d.
8f.
8g.
8h.
8j.
8k.
8l.
8m.
8n.
8p.
8r.
8s.
8t.
8v.
8w.
8x.
8z.
8.
8.
8.
8.
8.
8.
8.
8b.
8c.
8d.
8f.
8g.
8h.
8j.
8k.
8l.
8m.
8n.
8p.
8r.
8s.
8t.
8v.
8w.
8x.
8z.
8b.
8b.
8b.
8b.
8b.
8b.
8b.
8bb.
8bc.
8bd.
8bf.
8bg.
8bh.
8bj.
8bk.
8bl.
8bm.
8bn.
8bp.
8br.
8brz.
8bs.
8bt.
8bv.
8bw.
8bx.
8bz.
8c.
8c.
8c.
8c.
8c.
8c.
8c.
8cb.
8cc.
8cd.
8cf.
8cg.
8ch.
8ch.
8chrz.
8chw.
8cj.
8ck.
8cl.
8cm.
8cn.
8cp.
8cr.
8cs.
8ct.
8cv.
8cw.
8cx.
8cz.
8czt.
8d.
8d.
8d.
8d.
8d.
8d.
8d.
8db.
8dc.
8dd.
8df.
8dg.
8dh.
8dj.
8dk.
8dl.
8dm.
8dn.
8dp.
8dr.
8drz.
8ds.
8dt.
8dv.
8dw.
8dx.
8dz.
8f.
8f.
8f.
8f.
8f.
8f.
8f.
8fb.
8fc.
8fd.
8ff.
8fg.
8fh.
8fj.
8fk.
8fl.
8fm.
8fn.
8fp.
8fr.
8fs.
8ft.
8fv.
8fw.
8fx.
8fz.
8g.
8g.
8g.
8g.
8g.
8g.
8g.
8gb.
8gc.
8gd.
8gf.
8gg.
8gh.
8gj.
8gk.
8gl.
8gm.
8gn.
8gp.
8gr.
8gs.
8gt.
8gv.
8gw.
8gx.
8gz.
8h.
8h.
8h.
8h.
8h.
8h.
8h.
8hb.
8hc.
8hd.
8hf.
8hg.
8hh.
8hj.
8hk.
8hl.
8hm.
8hn.
8hp.
8hr.
8hs.
8ht.
8hv.
8hw.
8hx.
8hz.
8j.
8j.
8j.
8j.
8j.
8j.
8j.
8jb.
8jc.
8jd.
8jf.
8jg.
8jh.
8jj.
8jk.
8jl.
8jm.
8jn.
8jp.
8jr.
8js.
8jt.
8jv.
8jw.
8jx.
8jz.
8k.
8k.
8k.
8k.
8k.
8k.
8k.
8kb.
8kc.
8kd.
8kf.
8kg.
8kh.
8kj.
8kk.
8kl.
8km.
8kn.
8kp.
8kr.
8ks.
8kst.
8kt.
8kv.
8kw.
8kx.
8kz.
8l.
8l.
8l.
8l.
8l.
8l.
8l.
8lb.
8lc.
8ld.
8lf.
8lg.
8lh.
8lj.
8lk.
8ll.
8lm.
8ln.
8lp.
8lr.
8ls.
8lt.
8lv.
8lw.
8lx.
8lz.
8m.
8m.
8m.
8m.
8m.
8m.
8m.
8mb.
8mc.
8md.
8mf.
8mg.
8mh.
8mj.
8mk.
8ml.
8mm.
8mn.
8mp.
8mr.
8ms.
8mst.
8mt.
8mv.
8mw.
8mx.
8mz.
8n.
8n.
8n.
8n.
8n.
8n.
8n.
8nb.
8nc.
8nd.
8nf.
8ng.
8nh.
8nj.
8nk.
8nl.
8nm.
8nn.
8np.
8nr.
8ns.
8nt.
8nv.
8nw.
8nx.
8nz.
8p.
8p.
8p.
8p.
8p.
8p.
8p.
8pb.
8pc.
8pd.
8pf.
8pg.
8ph.
8pj.
8pk.
8pl.
8pm.
8pn.
8pp.
8pr.
8prz.
8ps.
8pt.
8pv.
8pw.
8px.
8pz.
8r.
8r.
8r.
8r.
8r.
8r.
8r.
8rb.
8rc.
8rd.
8rf.
8rg.
8rh.
8rj.
8rk.
8rl.
8rm.
8rn.
8rp.
8rr.
8rs.
8rsz.
8rt.
8rv.
8rw.
8rx.
8rz.
8rz.
8s.
8s.
8s.
8s.
8s.
8s.
8s.
8sb.
8sc.
8sch.
8sd.
8sf.
8sg.
8sh.
8sj.
8sk.
8skrz.
8sl.
8sm.
8sn.
8sp.
8sr.
8ss.
8st.
8str.
8strz.
8stw.
8sv.
8sw.
8sx.
8sz.
8szcz.
8szczb.
8szk.
8szn.
8szt.
8sztr.
8t.
8t.
8t.
8t.
8t.
8t.
8t.
8tb.
8tc.
8td.
8tf.
8tg.
8th.
8tj.
8tk.
8tl.
8tm.
8tn.
8tp.
8tr.
8trz.
8ts.
8tt.
8tv.
8tw.
8tx.
8tz.
8v.
8v.
8v.
8v.
8v.
8v.
8v.
8vb.
8vc.
8vd.
8vf.
8vg.
8vh.
8vj.
8vk.
8vl.
8vm.
8vn.
8vp.
8vr.
8vs.
8vt.
8vv.
8vw.
8vx.
8vz.
8w.
8w.
8w.
8w.
8w.
8w.
8w.
8wb.
8wc.
8wd.
8wf.
8wg.
8wh.
8wj.
8wk.
8wl.
8wm.
8wn.
8wp.
8wr.
8ws.
8wt.
8wv.
8ww.
8wx.
8wz.
8x.
8x.
8x.
8x.
8x.
8x.
8x.
8xb.
8xc.
8xd.
8xf.
8xg.
8xh.
8xj.
8xk.
8xl.
8xm.
8xn.
8xp.
8xr.
8xs.
8xt.
8xv.
8xw.
8xx.
8xz.
8z.
8z.
8z.
8z.
8z.
8z.
8z.
8zb.
8zc.
8zd.
8zdr.
8zdrz.
8zf.
8zg.
8zh.
8zj.
8zk.
8zl.
8zm.
8zn.
8zp.
8zr.
8zs.
8zt.
8zv.
8zw.
8zx.
8zz.
a1
a2u
a2y
aa2
ae2
ai2
ao2
be2eth
be2f3sz2
be2k1hend
bi2n3o2ku
bi2sz3kop
bi2z3ne2s3m
bi2z3nes
birmin2g1ham
blo2k1hauz
bo2s3ma
br2d
bro2a2d3way
bu2sz3me
buk2sz3pan
busine2ss3m
busines2s
c4h
c4z
cal2d1well
ch2
ch2j
ch2l
ch2r
ch2w
chus1t
cu2r7zon
d2
d2j
d2l
d2r
d2w
de4z3b
de4z3m
d4
d4
d4z
deut4sch3land
drz2w
du2sz3past
e1
e2r5zac
e2u
e2y
e3u2sz
ea2
ee2
ei2
eo2
fi2s3harm
fi2sz3bin
fo2k2s3t
fo2r5zac
fol2k1lor
fos2f1a2zot
ga3d2get
gado3p2ta
gol2f3s
golfsz2
gran2d1ilo
gro4t3r
hi2sz3p
hu2cz1w
hu2x3ley
i1
i2
i2
i2
i2a
i2e
i2i
i2o
i2u
i2y
in4nsbruck
in4sbruc
j2t1
j2t1r
ja4z4z3b
ja4z4z3m
karl2s1kron
karl2s1ruhe
kir2chhoff
kongre2s3m
led1w
lu2ft3waffe
lu2ks1fer
ly2o
ma2r5z
ma2r5zl
ma2r5zn
mi2sz1masz
mie2r5z
mie2r5zi
mon2t3real
moza2i3k
mu2r7zasich3l
na43kows
na4r3v
o1
o2y
oa2
och3mistrz
oe2
of2f3set
oi2
oo2
ou2
pa2n3a2mer
pa2s3cal
pa2s3ch
pou3d2ni
po3d4nieprz
po3m2n
po3m2n
po3m2ni
po4rt2s3mo2uth
po4rt3land
poli3e2t
poli3u2re
powsze3d2ni
pr2chal
pre2sz3pa
r4z
ro2e3nt2gen
ro2k3rocz
ro2s3to3c2k
s4z
se2t3le
sko2r5zoner
sm2r
sowi3z2
sy2n3opt
sy2s1tem
sza2sz1y
sze2z1long
sze4
szto2k1holm
szyn2k1was
to3y2o3t
turboo2d3rzut
tygo3d2ni
u1
u2y
ua2
ue2
ui2
uo2
uu2
vo2lk2s3
we2e2k1end
we4st3f
we4st3m
y1
ya2
ye2
yi2
yo2
yu2
ze4p3p
}
\hyphenation{
be-zach
be-zami
by-naj-mniej
gdzie-nie-gdzie
ina-czej
na-dal
ni-gdy
ni-gdzie
niech-e
niech-by
ow-szem
p-ach
p-ami
p-ek
pod-w-czas
przy-naj-mniej
skd-ind
tr-jach
tr-jami
tr-jek
}

% Local Variables:
% mode: tex
% coding: latin-2
% fill-column: 72
% End:
% vim: set fileencoding=iso-8859-2 filetype=tex textwidth=72:
