// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStridedTypeInt8Array
 * @brief   strided implicit array of vtkTypeInt8.
 *
 * vtkStridedTypeInt8Array is an strided implicit array of values of type vtkTypeInt8.
 * see vtkStridedArray, vtkStridedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStridedTypeInt8Array_h
#define vtkStridedTypeInt8Array_h

#include "vtkStridedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStridedArray<vtkTypeInt8>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStridedTypeInt8Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStridedTypeInt8Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStridedTypeInt8Array* New();
  static vtkStridedTypeInt8Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt8);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStridedTypeInt8Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStridedTypeInt8Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set the parameters for the strided backend.
   */
  void ConstructBackend(const vtkTypeInt8* buffer, vtkIdType stride, int components, vtkIdType offset);
  void ConstructBackend(const vtkTypeInt8* buffer, vtkIdType stride, int components);
  void ConstructBackend(const vtkTypeInt8* buffer, vtkIdType stride);
  ///@}

protected:
  vtkStridedTypeInt8Array();
  ~vtkStridedTypeInt8Array() override;

private:
  typedef vtkStridedArray<vtkTypeInt8> RealSuperclass;

  vtkStridedTypeInt8Array(const vtkStridedTypeInt8Array&) = delete;
  void operator=(const vtkStridedTypeInt8Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStridedTypeInt8Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
