// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStridedTypeInt64Array
 * @brief   strided implicit array of vtkTypeInt64.
 *
 * vtkStridedTypeInt64Array is an strided implicit array of values of type vtkTypeInt64.
 * see vtkStridedArray, vtkStridedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStridedTypeInt64Array_h
#define vtkStridedTypeInt64Array_h

#include "vtkStridedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStridedArray<vtkTypeInt64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStridedTypeInt64Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStridedTypeInt64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStridedTypeInt64Array* New();
  static vtkStridedTypeInt64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStridedTypeInt64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStridedTypeInt64Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set the parameters for the strided backend.
   */
  void ConstructBackend(const vtkTypeInt64* buffer, vtkIdType stride, int components, vtkIdType offset);
  void ConstructBackend(const vtkTypeInt64* buffer, vtkIdType stride, int components);
  void ConstructBackend(const vtkTypeInt64* buffer, vtkIdType stride);
  ///@}

protected:
  vtkStridedTypeInt64Array();
  ~vtkStridedTypeInt64Array() override;

private:
  typedef vtkStridedArray<vtkTypeInt64> RealSuperclass;

  vtkStridedTypeInt64Array(const vtkStridedTypeInt64Array&) = delete;
  void operator=(const vtkStridedTypeInt64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStridedTypeInt64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
