// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStridedTypeInt16Array
 * @brief   strided implicit array of vtkTypeInt16.
 *
 * vtkStridedTypeInt16Array is an strided implicit array of values of type vtkTypeInt16.
 * see vtkStridedArray, vtkStridedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStridedTypeInt16Array_h
#define vtkStridedTypeInt16Array_h

#include "vtkStridedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStridedArray<vtkTypeInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStridedTypeInt16Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStridedTypeInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStridedTypeInt16Array* New();
  static vtkStridedTypeInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt16);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStridedTypeInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStridedTypeInt16Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set the parameters for the strided backend.
   */
  void ConstructBackend(const vtkTypeInt16* buffer, vtkIdType stride, int components, vtkIdType offset);
  void ConstructBackend(const vtkTypeInt16* buffer, vtkIdType stride, int components);
  void ConstructBackend(const vtkTypeInt16* buffer, vtkIdType stride);
  ///@}

protected:
  vtkStridedTypeInt16Array();
  ~vtkStridedTypeInt16Array() override;

private:
  typedef vtkStridedArray<vtkTypeInt16> RealSuperclass;

  vtkStridedTypeInt16Array(const vtkStridedTypeInt16Array&) = delete;
  void operator=(const vtkStridedTypeInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStridedTypeInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
