// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStridedTypeFloat32Array
 * @brief   strided implicit array of vtkTypeFloat32.
 *
 * vtkStridedTypeFloat32Array is an strided implicit array of values of type vtkTypeFloat32.
 * see vtkStridedArray, vtkStridedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStridedTypeFloat32Array_h
#define vtkStridedTypeFloat32Array_h

#include "vtkStridedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStridedArray<vtkTypeFloat32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStridedTypeFloat32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStridedTypeFloat32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStridedTypeFloat32Array* New();
  static vtkStridedTypeFloat32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeFloat32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStridedTypeFloat32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStridedTypeFloat32Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set the parameters for the strided backend.
   */
  void ConstructBackend(const vtkTypeFloat32* buffer, vtkIdType stride, int components, vtkIdType offset);
  void ConstructBackend(const vtkTypeFloat32* buffer, vtkIdType stride, int components);
  void ConstructBackend(const vtkTypeFloat32* buffer, vtkIdType stride);
  ///@}

protected:
  vtkStridedTypeFloat32Array();
  ~vtkStridedTypeFloat32Array() override;

private:
  typedef vtkStridedArray<vtkTypeFloat32> RealSuperclass;

  vtkStridedTypeFloat32Array(const vtkStridedTypeFloat32Array&) = delete;
  void operator=(const vtkStridedTypeFloat32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStridedTypeFloat32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
