// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStdFunctionTypeInt32Array
 * @brief   std function implicit array of vtkTypeInt32.
 *
 * vtkStdFunctionTypeInt32Array is an affine implicit array of values of type vtkTypeInt32.
 * see vtkStdFunctionArray, std::function<vtkTypeInt32(int)>
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStdFunctionTypeInt32Array_h
#define vtkStdFunctionTypeInt32Array_h

#include "vtkStdFunctionArray.h" // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStdFunctionArray<vtkTypeInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStdFunctionTypeInt32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStdFunctionTypeInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStdFunctionTypeInt32Array* New();
  static vtkStdFunctionTypeInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStdFunctionTypeInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStdFunctionTypeInt32Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the std::function to be used as backend.
   */
  void ConstructBackend(std::function<vtkTypeInt32(int)> func);

protected:
  vtkStdFunctionTypeInt32Array();
  ~vtkStdFunctionTypeInt32Array() override;

private:
  typedef vtkStdFunctionArray<vtkTypeInt32> RealSuperclass;

  vtkStdFunctionTypeInt32Array(const vtkStdFunctionTypeInt32Array&) = delete;
  void operator=(const vtkStdFunctionTypeInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStdFunctionTypeInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
