// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStdFunctionTypeFloat32Array
 * @brief   std function implicit array of vtkTypeFloat32.
 *
 * vtkStdFunctionTypeFloat32Array is an affine implicit array of values of type vtkTypeFloat32.
 * see vtkStdFunctionArray, std::function<vtkTypeFloat32(int)>
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStdFunctionTypeFloat32Array_h
#define vtkStdFunctionTypeFloat32Array_h

#include "vtkStdFunctionArray.h" // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStdFunctionArray<vtkTypeFloat32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStdFunctionTypeFloat32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStdFunctionTypeFloat32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStdFunctionTypeFloat32Array* New();
  static vtkStdFunctionTypeFloat32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeFloat32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStdFunctionTypeFloat32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStdFunctionTypeFloat32Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the std::function to be used as backend.
   */
  void ConstructBackend(std::function<vtkTypeFloat32(int)> func);

protected:
  vtkStdFunctionTypeFloat32Array();
  ~vtkStdFunctionTypeFloat32Array() override;

private:
  typedef vtkStdFunctionArray<vtkTypeFloat32> RealSuperclass;

  vtkStdFunctionTypeFloat32Array(const vtkStdFunctionTypeFloat32Array&) = delete;
  void operator=(const vtkStdFunctionTypeFloat32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStdFunctionTypeFloat32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
