// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkScaledSOATypeUInt32Array
 * @brief   scaled soa array of vtkTypeUInt32.
 *
 * vtkScaledSOATypeUInt32Array is a scaled soa array of values of type vtkTypeUInt32.
 * see vtkScaledSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkScaledSOATypeUInt32Array_h
#define vtkScaledSOATypeUInt32Array_h

#include "vtkCommonCoreModule.h"           // For export macro
#include "vtkScaledSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkScaledSOADataArrayTemplate<vtkTypeUInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkScaledSOATypeUInt32Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkScaledSOATypeUInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkScaledSOATypeUInt32Array* New();
  static vtkScaledSOATypeUInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkScaledSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateScaledSOAWrappedArrayInterface(vtkTypeUInt32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkScaledSOATypeUInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkScaledSOATypeUInt32Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkScaledSOATypeUInt32Array();
  ~vtkScaledSOATypeUInt32Array() override;

private:
  typedef vtkScaledSOADataArrayTemplate<vtkTypeUInt32> RealSuperclass;

  vtkScaledSOATypeUInt32Array(const vtkScaledSOATypeUInt32Array&) = delete;
  void operator=(const vtkScaledSOATypeUInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkScaledSOATypeUInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
