// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkScaledSOATypeInt8Array
 * @brief   scaled soa array of vtkTypeInt8.
 *
 * vtkScaledSOATypeInt8Array is a scaled soa array of values of type vtkTypeInt8.
 * see vtkScaledSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkScaledSOATypeInt8Array_h
#define vtkScaledSOATypeInt8Array_h

#include "vtkCommonCoreModule.h"           // For export macro
#include "vtkScaledSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkScaledSOADataArrayTemplate<vtkTypeInt8>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkScaledSOATypeInt8Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkScaledSOATypeInt8Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkScaledSOATypeInt8Array* New();
  static vtkScaledSOATypeInt8Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkScaledSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateScaledSOAWrappedArrayInterface(vtkTypeInt8);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkScaledSOATypeInt8Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkScaledSOATypeInt8Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkScaledSOATypeInt8Array();
  ~vtkScaledSOATypeInt8Array() override;

private:
  typedef vtkScaledSOADataArrayTemplate<vtkTypeInt8> RealSuperclass;

  vtkScaledSOATypeInt8Array(const vtkScaledSOATypeInt8Array&) = delete;
  void operator=(const vtkScaledSOATypeInt8Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkScaledSOATypeInt8Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
