// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSOATypeUInt32Array
 * @brief   soa array of vtkTypeUInt32.
 *
 * vtkSOATypeUInt32Array is a soa array of values of type vtkTypeUInt32.
 * see vtkSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkSOATypeUInt32Array_h
#define vtkSOATypeUInt32Array_h

#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkSOADataArrayTemplate<vtkTypeUInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkSOATypeUInt32Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkSOATypeUInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkSOATypeUInt32Array* New();
  static vtkSOATypeUInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateSOAWrappedArrayInterface(vtkTypeUInt32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkSOATypeUInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkSOATypeUInt32Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkSOATypeUInt32Array();
  ~vtkSOATypeUInt32Array() override;

private:
  typedef vtkSOADataArrayTemplate<vtkTypeUInt32> RealSuperclass;

  vtkSOATypeUInt32Array(const vtkSOATypeUInt32Array&) = delete;
  void operator=(const vtkSOATypeUInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkSOATypeUInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
