// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantTypeInt8Array
 * @brief   constant implicit array of vtkTypeInt8.
 *
 * vtkConstantTypeInt8Array is a constant implicit array of values of type vtkTypeInt8.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantTypeInt8Array_h
#define vtkConstantTypeInt8Array_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<vtkTypeInt8>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkConstantTypeInt8Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantTypeInt8Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt8);
#endif

  static vtkConstantTypeInt8Array* New();
  static vtkConstantTypeInt8Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantTypeInt8Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantTypeInt8Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(vtkTypeInt8 value);

protected:
  vtkConstantTypeInt8Array();
  ~vtkConstantTypeInt8Array() override;

private:
  typedef vtkConstantArray<vtkTypeInt8> RealSuperclass;

  vtkConstantTypeInt8Array(const vtkConstantTypeInt8Array&) = delete;
  void operator=(const vtkConstantTypeInt8Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantTypeInt8Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
