// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantDoubleArray
 * @brief   constant implicit array of double.
 *
 * vtkConstantDoubleArray is a constant implicit array of values of type double.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantDoubleArray_h
#define vtkConstantDoubleArray_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<double>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkConstantType*Array instead") vtkConstantDoubleArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantDoubleArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(double);
#endif

  static vtkConstantDoubleArray* New();
  static vtkConstantDoubleArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantDoubleArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantDoubleArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(double value);

protected:
  vtkConstantDoubleArray();
  ~vtkConstantDoubleArray() override;

private:
  typedef vtkConstantArray<double> RealSuperclass;

  vtkConstantDoubleArray(const vtkConstantDoubleArray&) = delete;
  void operator=(const vtkConstantDoubleArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantDoubleArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
