/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import vtk.vtkActor;
import vtk.vtkDataSetMapper;
import vtk.vtkNativeLibrary;
import vtk.vtkObject;
import vtk.vtkPanel;
import vtk.vtkReferenceInformation;
import vtk.vtkRenderer;
import vtk.vtkShrinkFilter;
import vtk.vtkSphereSource;

public class Demo
extends JPanel {
    private static final long serialVersionUID = 1L;
    private vtkPanel panel3d = new vtkPanel();
    private JCheckBox runGC;
    private JCheckBox debugMode;
    private JLabel gcStatus = new JLabel("");
    private int NUMBER_OF_PIPLINE_TO_BUILD = 120;
    private int nbSeconds;
    private final CompletionService<vtkActor> exec;

    public Demo() {
        super(new BorderLayout());
        this.runGC = new JCheckBox("Enable GC", false);
        this.debugMode = new JCheckBox("Debug mode", false);
        this.exec = new ExecutorCompletionService<vtkActor>(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.runGC);
        jPanel.add(this.debugMode);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.gcStatus);
        this.add((Component)this.panel3d, "Center");
        this.add((Component)jPanel, "South");
        this.setupWorkers();
        this.nbSeconds = 0;
        new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                vtkRenderer vtkRenderer2;
                if (Demo.this.nbSeconds++ < 10) {
                    Demo.this.panel3d.resetCamera();
                }
                if ((vtkRenderer2 = Demo.this.panel3d.GetRenderer()).GetNumberOfPropsRendered() > 1) {
                    vtkRenderer2.RemoveActor(vtkRenderer2.GetActors().GetLastProp());
                }
                if (Demo.this.runGC.isSelected()) {
                    vtkReferenceInformation vtkReferenceInformation2 = vtkObject.JAVA_OBJECT_MANAGER.gc(Demo.this.debugMode.isSelected());
                    if (Demo.this.debugMode.isSelected()) {
                        System.out.println(vtkReferenceInformation2.listKeptReferenceToString());
                        System.out.println(vtkReferenceInformation2.listRemovedReferenceToString());
                    }
                    Demo.this.gcStatus.setText(vtkReferenceInformation2.toString());
                } else {
                    Demo.this.gcStatus.setText("");
                }
                Demo.this.panel3d.Render();
            }
        }).start();
    }

    private void setupGC() {
        vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().SetScheduleTime(1L, TimeUnit.SECONDS);
        this.runGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().SetAutoGarbageCollection(Demo.this.runGC.isSelected());
            }
        });
        this.debugMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().SetDebug(Demo.this.debugMode.isSelected());
            }
        });
    }

    private void setupWorkers() {
        final AddActorRunnable addActorRunnable = new AddActorRunnable();
        addActorRunnable.setRenderer(this.panel3d);
        new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < Demo.this.NUMBER_OF_PIPLINE_TO_BUILD; ++i) {
                    try {
                        addActorRunnable.setActor((vtkActor)Demo.this.exec.take().get());
                        SwingUtilities.invokeAndWait(addActorRunnable);
                        Demo.this.panel3d.repaint();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    catch (ExecutionException executionException) {
                        executionException.printStackTrace();
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
            }
        }.start();
    }

    public void startWorking() {
        for (int i = 0; i < this.NUMBER_OF_PIPLINE_TO_BUILD; ++i) {
            this.exec.submit(new PipelineBuilder());
        }
    }

    public static void main(String[] stringArray) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Demo demo = new Demo();
                JFrame jFrame = new JFrame("Concurrency test");
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.getContentPane().add((Component)demo, "Center");
                jFrame.setDefaultCloseOperation(3);
                jFrame.setSize(400, 400);
                jFrame.setVisible(true);
                jFrame.validate();
                demo.startWorking();
            }
        });
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
                if (vtkNativeLibrary2.IsLoaded()) continue;
                System.out.println(vtkNativeLibrary2.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }

    public static class AddActorRunnable
    implements Runnable {
        private vtkActor actorToAdd;
        private vtkRenderer renderer;
        private vtkPanel panel;

        void setRenderer(vtkPanel vtkPanel2) {
            this.renderer = vtkPanel2.GetRenderer();
            this.panel = vtkPanel2;
        }

        void setActor(vtkActor vtkActor2) {
            this.actorToAdd = vtkActor2;
        }

        @Override
        public void run() {
            this.renderer.AddActor(this.actorToAdd);
            this.panel.Render();
        }
    }

    public static class PipelineBuilder
    implements Callable<vtkActor> {
        private vtkActor actor;
        private vtkDataSetMapper mapper;
        private vtkShrinkFilter shrink;
        private vtkSphereSource sphere;

        @Override
        public vtkActor call() throws Exception {
            this.actor = new vtkActor();
            this.mapper = new vtkDataSetMapper();
            this.shrink = new vtkShrinkFilter();
            this.sphere = new vtkSphereSource();
            this.sphere.SetPhiResolution(60);
            this.sphere.SetThetaResolution(60);
            double[] dArray = new double[3];
            this.sphere.SetCenter(this.GetRandomCenter(dArray));
            this.actor.GetProperty().SetColor(Math.random(), Math.random(), Math.random());
            this.actor.SetMapper(this.mapper);
            this.mapper.SetInputConnection(this.shrink.GetOutputPort());
            this.shrink.SetInputConnection(this.sphere.GetOutputPort());
            this.mapper.Update();
            Thread.sleep((long)(Math.random() * 500.0));
            return this.actor;
        }

        public double[] GetRandomCenter(double[] dArray) {
            for (int i = 0; i < 3; ++i) {
                dArray[i] = Math.random() * 10.0;
            }
            return dArray;
        }
    }
}

