/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.view;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.scilab.modules.xcos.palette.model.Category;
import org.scilab.modules.xcos.palette.model.PaletteNode;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.utils.XcosMessages;

public class PaletteConfiguratorListView
extends JTable {
    private static final String[] COLUMN_TITLE = new String[]{XcosMessages.ENABLE, XcosMessages.PAL_NAME};

    public PaletteConfiguratorListView(PaletteListModel paletteListModel) {
        super(paletteListModel);
        this.setBackground(Color.WHITE);
        this.setAutoResizeMode(3);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (this.getColumnModel().getColumnCount() != n2 + 1) {
            int n3 = component.getPreferredSize().width;
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            int n4 = Math.max(n3 + this.getIntercellSpacing().width, tableColumn.getPreferredWidth());
            tableColumn.setMaxWidth(n4);
        }
        return component;
    }

    public static class PaletteListModel
    extends AbstractTableModel {
        private final Category category;

        public PaletteListModel(Category category) {
            this.category = category;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public String getColumnName(int n) {
            return COLUMN_TITLE[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return COLUMN_TITLE.length;
        }

        @Override
        public int getRowCount() {
            return this.category.getNode().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PaletteNode paletteNode = this.category.getNode().get(n);
            Object object = n2 == 0 ? Boolean.valueOf(paletteNode.isEnable()) : paletteNode.toString();
            return object;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            PaletteNode paletteNode = this.category.getNode().get(n);
            if (n2 == 0) {
                paletteNode.setEnable((Boolean)object);
            } else {
                paletteNode.setName((String)object);
            }
            PaletteManagerView.updateTree();
        }
    }
}

