/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.listener;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.scilab.modules.xcos.palette.model.Category;
import org.scilab.modules.xcos.palette.model.PaletteNode;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;

public class PaletteTreeTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getLogger(PaletteTreeTransferHandler.class.getName());

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        PaletteTransferable paletteTransferable = (PaletteTransferable)transferable;
        if (n == 2 && paletteTransferable.isMoved()) {
            this.updateTree((JTree)jComponent, transferable);
        }
    }

    private void updateTree(JTree jTree, Transferable transferable) {
        PaletteNode paletteNode;
        TreePath treePath = jTree.getSelectionPath();
        try {
            paletteNode = (PaletteNode)transferable.getTransferData(PaletteTransferable.PALETTE_FLAVOR);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            LOG.severe(unsupportedFlavorException.toString());
            return;
        }
        catch (IOException iOException) {
            LOG.severe(iOException.toString());
            return;
        }
        PaletteNode.refreshView((PaletteNode)treePath.getParentPath().getLastPathComponent(), null);
        PaletteNode.refreshView(paletteNode.getParent(), paletteNode);
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        if (jComponent == null) {
            return null;
        }
        JTree jTree = (JTree)jComponent;
        PaletteNode paletteNode = (PaletteNode)jTree.getSelectionPath().getLastPathComponent();
        return new PaletteTransferable(paletteNode);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        JTree jTree = (JTree)transferSupport.getComponent();
        Point point = transferSupport.getDropLocation().getDropPoint();
        TreePath treePath = jTree.getPathForLocation(point.x, point.y);
        if (treePath != null) {
            return Arrays.asList(transferSupport.getDataFlavors()).contains(PaletteTransferable.PALETTE_FLAVOR);
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (PaletteManagerView.get() == null) {
            PaletteManagerView.restore();
        }
        JTree jTree = PaletteManagerView.get().getTree();
        JTree.DropLocation dropLocation = jTree.getDropLocation();
        Category category = (Category)dropLocation.getPath().getLastPathComponent();
        int n = dropLocation.getChildIndex();
        Transferable transferable = transferSupport.getTransferable();
        try {
            PaletteNode paletteNode = (PaletteNode)transferable.getTransferData(PaletteTransferable.PALETTE_FLAVOR);
            Category category2 = paletteNode.getParent();
            category2.getNode().remove(paletteNode);
            paletteNode.setParent(category);
            if (n == -1) {
                category.getNode().add(paletteNode);
            } else {
                category.getNode().add(n, paletteNode);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            LOG.severe(unsupportedFlavorException.toString());
            return false;
        }
        catch (IOException iOException) {
            LOG.severe(iOException.toString());
            return false;
        }
        return true;
    }

    private static class PaletteTransferable
    implements Transferable {
        public static final DataFlavor PALETTE_FLAVOR = new DataFlavor(PaletteNode.class, null);
        private static final DataFlavor STRING_FLAVOR = DataFlavor.stringFlavor;
        private final PaletteNode node;
        private boolean moved;

        public PaletteTransferable(PaletteNode paletteNode) {
            this.node = paletteNode;
            this.moved = false;
        }

        public final PaletteNode getNode() {
            return this.node;
        }

        public final boolean isMoved() {
            return this.moved;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            Object object = null;
            if (dataFlavor.equals(STRING_FLAVOR) && this.getNode() instanceof Category) {
                try {
                    JAXBContext jAXBContext = JAXBContext.newInstance((String)"org.scilab.modules.xcos.palette.model");
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)true);
                    StringWriter stringWriter = new StringWriter();
                    marshaller.marshal((Object)this.node, (Writer)stringWriter);
                    object = stringWriter.toString();
                }
                catch (JAXBException jAXBException) {
                    throw new IOException(jAXBException);
                }
            } else if (dataFlavor.equals(PALETTE_FLAVOR)) {
                object = this.node;
                this.moved = true;
            }
            if (object == null) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return object;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            Category category = this.getNode().getParent();
            if (category.getParent() == null && category.getChildAt(0) == this.getNode()) {
                return new DataFlavor[]{STRING_FLAVOR};
            }
            if (this.getNode() instanceof Category) {
                return new DataFlavor[]{PALETTE_FLAVOR, STRING_FLAVOR};
            }
            return new DataFlavor[]{PALETTE_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return Arrays.asList(this.getTransferDataFlavors()).contains(dataFlavor);
        }
    }
}

