/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.scilab.modules.graph.utils.ScilabExported;
import org.scilab.modules.javasci.JavasciException;
import org.scilab.modules.javasci.Scilab;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabTList;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;
import org.scilab.modules.xcos.palette.PaletteManager;
import org.scilab.modules.xcos.palette.PreLoadedElement;
import org.scilab.modules.xcos.palette.StyleElement;
import org.scilab.modules.xcos.palette.model.Category;
import org.scilab.modules.xcos.palette.model.PaletteBlock;
import org.scilab.modules.xcos.palette.model.PaletteNode;
import org.scilab.modules.xcos.palette.model.PreLoaded;
import org.scilab.modules.xcos.utils.BlockPositioning;

public final class Palette {
    public static final String NAME = "name";
    public static final String WRONG_INPUT_ARGUMENT_S_INVALID_TREE_PATH = Messages.gettext((String)"Wrong input argument \"%s\": invalid tree path.\n");
    public static final String WRONG_INPUT_ARGUMENT_S_INVALID_NODE = Messages.gettext((String)"Wrong input argument \"%s\": invalid node, use 'xcosPalDisable' instead.\n");
    public static final String UNABLE_TO_IMPORT = Messages.gettext((String)"Unable to import %s .\n");
    private static final Logger LOG = Logger.getLogger(Palette.class.getName());
    private static final String XCOS = "xcos";
    private static final String PALETTE_GIWS_XML = "Palette.giws.xml";

    private Palette() {
    }

    private static PaletteNode getPathNode(String[] stringArray, boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Unable to manipulate palette outside the EDT thread.");
        }
        Object object = PaletteManager.getInstance().getRoot();
        if (stringArray == null || stringArray.length == 0 || stringArray.length == 1 && stringArray[0].isEmpty()) {
            return object;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            for (PaletteNode paletteNode : ((Category)object).getNode()) {
                if (paletteNode.getName().equals(stringArray[i]) && paletteNode instanceof Category) {
                    object = (Category)paletteNode;
                    break;
                }
                if (!paletteNode.getName().equals(stringArray[i]) || i != stringArray.length - 1) continue;
                return paletteNode;
            }
            if (((PaletteNode)object).toString().equals(stringArray[i])) continue;
            if (bl) {
                Category category = new Category();
                category.setName(stringArray[i]);
                category.setEnable(bl);
                category.setParent((Category)object);
                ((Category)object).getNode().add(category);
                object = category;
                continue;
            }
            return null;
        }
        return object;
    }

    @ScilabExported(module="xcos", filename="Palette.giws.xml")
    public static void loadPal(String string, final String[] stringArray) throws JavasciException {
        final ScilabTList scilabTList = (ScilabTList)Scilab.getInCurrentScilabSession((String)string);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object object;
                        Object object22;
                        mxStylesheet mxStylesheet2 = Xcos.getInstance().getStyleSheet();
                        try {
                            new StyleElement().decode((ScilabType)scilabTList, mxStylesheet2);
                        }
                        catch (ScicosFormatException scicosFormatException) {
                            throw new RuntimeException(scicosFormatException);
                        }
                        for (Object object22 : Xcos.getInstance().openedDiagrams()) {
                            mxGraphComponent mxGraphComponent2;
                            if (object22 == null) continue;
                            object = object22.getView();
                            if (object != null) {
                                object.reload();
                            }
                            if ((mxGraphComponent2 = object22.getAsComponent()) == null) continue;
                            mxGraphComponent2.refresh();
                        }
                        PaletteNode paletteNode = Palette.getPathNode(stringArray, true);
                        if (!(paletteNode instanceof Category)) {
                            throw new RuntimeException(String.format(WRONG_INPUT_ARGUMENT_S_INVALID_TREE_PATH, "category"));
                        }
                        object22 = (Category)paletteNode;
                        try {
                            object = new PreLoadedElement().decode((ScilabType)scilabTList, new PreLoaded.Dynamic());
                        }
                        catch (ScicosFormatException scicosFormatException) {
                            throw new RuntimeException(scicosFormatException);
                        }
                        ((Category)object22).getNode().add((PaletteNode)object);
                        ((PaletteNode)object).setParent((Category)object22);
                        PaletteNode.refreshView((TreeNode)object22, (TreeNode)object);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            LOG.severe(interruptedException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            String string2 = null;
            for (Throwable throwable = invocationTargetException; throwable != null; throwable = ((Throwable)throwable).getCause()) {
                string2 = throwable.getLocalizedMessage();
            }
            throw new RuntimeException(string2, invocationTargetException);
        }
    }

    @ScilabExported(module="xcos", filename="Palette.giws.xml")
    public static void loadPal(String string) throws JavasciException {
        Palette.loadPal(string, null);
    }

    @ScilabExported(module="xcos", filename="Palette.giws.xml")
    public static void get(final String[] stringArray) throws JavasciException, InvocationTargetException, InterruptedException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ScilabDouble scilabDouble;
                PreLoaded preLoaded;
                PaletteNode paletteNode = Palette.getPathNode(stringArray, false);
                if (paletteNode instanceof PreLoaded) {
                    preLoaded = (PreLoaded)paletteNode;
                } else if (paletteNode instanceof Category) {
                    scilabDouble = new LinkedList();
                    scilabDouble.add((Category)paletteNode);
                    preLoaded = new PreLoaded();
                    preLoaded.setName(paletteNode.getName());
                    preLoaded.getBlock().addAll(Palette.list((Deque<Category>)scilabDouble, preLoaded));
                } else {
                    preLoaded = null;
                }
                if (preLoaded != null) {
                    PreLoadedElement preLoadedElement = new PreLoadedElement();
                    scilabDouble = preLoadedElement.encode(preLoaded, (ScilabType)null);
                } else {
                    scilabDouble = new ScilabDouble();
                }
                try {
                    Scilab.putInCurrentScilabSession((String)"pal", (ScilabType)scilabDouble);
                }
                catch (JavasciException javasciException) {
                    throw new RuntimeException(javasciException);
                }
            }
        });
    }

    private static List<PaletteBlock> list(Deque<Category> deque, PreLoaded preLoaded) {
        ArrayList<PaletteBlock> arrayList = new ArrayList<PaletteBlock>();
        while (!deque.isEmpty()) {
            Category category = deque.pop();
            for (PaletteNode paletteNode : category.getNode()) {
                if (paletteNode instanceof Category) {
                    deque.add((Category)paletteNode);
                    continue;
                }
                if (!(paletteNode instanceof PreLoaded)) continue;
                PreLoaded preLoaded2 = (PreLoaded)paletteNode;
                arrayList.addAll(preLoaded2.getBlock());
            }
        }
        return arrayList;
    }

    @ScilabExported(module="xcos", filename="Palette.giws.xml")
    public static void addCategory(final String[] stringArray, final boolean bl) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PaletteNode paletteNode = Palette.getPathNode(stringArray, true);
                    if (!(paletteNode instanceof Category)) {
                        throw new RuntimeException(String.format(WRONG_INPUT_ARGUMENT_S_INVALID_TREE_PATH, Palette.NAME));
                    }
                    paletteNode.setEnable(bl);
                    PaletteNode.refreshView(paletteNode.getParent(), paletteNode);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(Palette.class.getName()).severe(interruptedException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = null;
            for (Throwable throwable = invocationTargetException; throwable != null; throwable = ((Throwable)throwable).getCause()) {
                string = throwable.getLocalizedMessage();
            }
            throw new RuntimeException(string, invocationTargetException);
        }
    }

    @ScilabExported(module="xcos", filename="Palette.giws.xml")
    public static void remove(final String[] stringArray) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PaletteNode paletteNode = Palette.getPathNode(stringArray, false);
                    PaletteNode.remove(paletteNode);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            LOG.severe(interruptedException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = null;
            for (Throwable throwable = invocationTargetException; throwable != null; throwable = ((Throwable)throwable).getCause()) {
                string = throwable.getLocalizedMessage();
            }
            throw new RuntimeException(string, invocationTargetException);
        }
    }

    @ScilabExported(module="xcos", filename="Palette.giws.xml")
    public static void enable(final String[] stringArray, final boolean bl) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PaletteNode paletteNode = Palette.getPathNode(stringArray, false);
                    if (paletteNode == null) {
                        throw new RuntimeException(String.format(WRONG_INPUT_ARGUMENT_S_INVALID_TREE_PATH, Palette.NAME));
                    }
                    paletteNode.setEnable(bl);
                    PaletteNode.refreshView(paletteNode.getParent(), paletteNode);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            LOG.severe(interruptedException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = null;
            for (Throwable throwable = invocationTargetException; throwable != null; throwable = ((Throwable)throwable).getCause()) {
                string = throwable.getLocalizedMessage();
            }
            throw new RuntimeException(string, invocationTargetException);
        }
    }

    @ScilabExported(module="xcos", filename="Palette.giws.xml")
    public static void move(final String[] stringArray, final String[] stringArray2) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PaletteNode paletteNode = Palette.getPathNode(stringArray, false);
                    if (paletteNode == null) {
                        throw new RuntimeException(String.format(WRONG_INPUT_ARGUMENT_S_INVALID_TREE_PATH, "source"));
                    }
                    PaletteNode paletteNode2 = Palette.getPathNode(stringArray2, true);
                    if (paletteNode2 == null || !(paletteNode2 instanceof Category)) {
                        throw new RuntimeException(String.format(WRONG_INPUT_ARGUMENT_S_INVALID_TREE_PATH, "target"));
                    }
                    Category category = (Category)paletteNode2;
                    Category[] categoryArray = new Category[]{paletteNode.getParent(), category};
                    if (categoryArray[0] != null) {
                        categoryArray[0].getNode().remove(paletteNode);
                    }
                    category.getNode().add(paletteNode);
                    paletteNode.setParent(category);
                    PaletteNode.refreshView(categoryArray[0], null);
                    PaletteNode.refreshView(categoryArray[1], paletteNode);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            LOG.severe(interruptedException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = null;
            for (Throwable throwable = invocationTargetException; throwable != null; throwable = ((Throwable)throwable).getCause()) {
                string = throwable.getLocalizedMessage();
            }
            throw new RuntimeException(string, invocationTargetException);
        }
    }

    @ScilabExported(module="xcos", filename="Palette.giws.xml")
    public static void generatePaletteIcon(long l, String string) throws Exception {
        if (GraphicsEnvironment.isHeadless()) {
            LOG.warning("Headless environment detected, do not generate icons");
            return;
        }
        JavaController javaController = new JavaController();
        Kind kind = javaController.getKind(l);
        BasicBlock basicBlock = XcosCellFactory.createBlock(javaController, l, kind);
        Palette.generateIcon(basicBlock, string);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(string + " updated.");
        }
    }

    private static void generateIcon(BasicBlock basicBlock, String string) throws IOException {
        if (basicBlock == null || basicBlock.getGeometry() == null) {
            return;
        }
        mxGeometry mxGeometry2 = basicBlock.getGeometry();
        mxGeometry2.setX(8.0);
        mxGeometry2.setY(8.0);
        JavaController javaController = new JavaController();
        XcosDiagram xcosDiagram = new XcosDiagram(javaController, javaController.createObject(Kind.DIAGRAM), Kind.DIAGRAM, "");
        xcosDiagram.installListeners();
        xcosDiagram.addCell(basicBlock);
        xcosDiagram.selectAll();
        BlockPositioning.updateBlockView(xcosDiagram, basicBlock);
        mxGraphComponent mxGraphComponent2 = xcosDiagram.getAsComponent();
        mxGraphComponent2.refresh();
        mxRectangle mxRectangle2 = xcosDiagram.getPaintBounds(new Object[]{basicBlock});
        BufferedImage bufferedImage = mxCellRenderer.createBufferedImage((mxGraph)xcosDiagram, null, (double)3.0, (Color)mxGraphComponent2.getBackground(), (boolean)true, null, (mxGraphics2DCanvas)mxGraphComponent2.getCanvas());
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
    }
}

