/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.modelica;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.scilab.modules.xcos.modelica.TerminalAccessor;
import org.scilab.modules.xcos.modelica.model.Terminal;

public final class TerminalTableModel
extends AbstractTableModel {
    private List<Terminal> terminals;

    public TerminalTableModel() {
        this.setTerminals(null);
        for (int i = 0; i < TerminalAccessor.values().length; ++i) {
            TerminalAccessor terminalAccessor = TerminalAccessor.values()[i];
            terminalAccessor.addChangeListener(new ModelChangeListener(this));
        }
    }

    public List<Terminal> getTerminals() {
        return this.terminals;
    }

    public void setTerminals(List<Terminal> list) {
        this.terminals = list == null ? Collections.emptyList() : list;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.terminals.size();
    }

    @Override
    public int getColumnCount() {
        return TerminalAccessor.values().length - 1;
    }

    @Override
    public String getColumnName(int n) {
        return TerminalAccessor.values()[n].getName();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return TerminalAccessor.values()[n].getKlass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return TerminalAccessor.values()[n2].isEditable();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return TerminalAccessor.getData(TerminalAccessor.values()[n2], this.terminals.get(n));
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.fireTableChanged(new TerminalTableModelEvent(this, n, n2, true));
        TerminalAccessor.values()[n2].setData(object, this.terminals.get(n));
        this.fireTableChanged(new TerminalTableModelEvent(this, n, n2, false));
    }

    private static class ModelChangeListener
    implements TerminalAccessor.ChangeListener {
        private final TerminalTableModel model;

        public ModelChangeListener(TerminalTableModel terminalTableModel) {
            this.model = terminalTableModel;
        }

        @Override
        public void change(TerminalAccessor.ChangeEvent changeEvent) {
            TerminalAccessor terminalAccessor = (TerminalAccessor)((Object)changeEvent.getSource());
            Terminal terminal = changeEvent.getTerminal();
            int n = Arrays.asList(TerminalAccessor.values()).indexOf((Object)terminalAccessor);
            int n2 = this.model.getTerminals().indexOf(terminal);
            if (n2 < this.model.getRowCount() && n < this.model.getColumnCount()) {
                this.model.fireTableChanged(new TableModelEvent(this.model, n2, n2, n));
            }
        }
    }

    public static final class TerminalTableModelEvent
    extends TableModelEvent {
        private final boolean beforeCommit;

        public TerminalTableModelEvent(TerminalTableModel terminalTableModel, int n, int n2, int n3, int n4, boolean bl) {
            super(terminalTableModel, n, n2, n3, n4);
            this.beforeCommit = bl;
        }

        public TerminalTableModelEvent(TerminalTableModel terminalTableModel, int n, int n2, boolean bl) {
            this(terminalTableModel, n, n, n2, 0, bl);
        }

        public boolean isBeforeCommit() {
            return this.beforeCommit;
        }

        public boolean isAfterCommit() {
            return !this.beforeCommit;
        }
    }
}

