/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.modelica;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public final class ModelStatistics {
    private long equations;
    private long fixedParameters;
    private long relaxedParameters;
    private long fixedVariables;
    private long relaxedVariables;
    private long expectedRelaxedVariables;
    private long discreteStates;
    private long inputs;
    private long outputs;
    private long derivativeStates;
    private final EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent;

    public long getDerivativeStates() {
        return this.derivativeStates;
    }

    public long getDiscreteStates() {
        return this.discreteStates;
    }

    public long getEquations() {
        return this.equations;
    }

    public long getFixedParameters() {
        return this.fixedParameters;
    }

    public long getFixedVariables() {
        return this.fixedVariables;
    }

    public long getInputs() {
        return this.inputs;
    }

    public long getOutputs() {
        return this.outputs;
    }

    public long getRelaxedParameters() {
        return this.relaxedParameters;
    }

    public long getRelaxedVariables() {
        return this.relaxedVariables;
    }

    public long getUnknowns() {
        return this.getRelaxedParameters() + this.getRelaxedVariables();
    }

    public void incDerivativeStates() {
        this.incDerivativeStates(1L);
    }

    public void incDerivativeStates(long l) {
        this.derivativeStates += l;
    }

    public void incDiscreteStates() {
        this.incDiscreteStates(1L);
    }

    public void incDiscreteStates(long l) {
        this.discreteStates += l;
    }

    public void incEquations() {
        this.incEquations(1L);
    }

    public void incEquations(long l) {
        this.equations += l;
    }

    public void incFixedParameters() {
        this.incFixedParameters(1L);
    }

    public void incFixedParameters(long l) {
        this.fixedParameters += l;
    }

    public void incFixedVariables() {
        this.incFixedVariables(1L);
    }

    public void incFixedVariables(long l) {
        this.fixedVariables += l;
    }

    public void incInputs() {
        this.incInputs(1L);
    }

    public void incInputs(long l) {
        this.inputs += l;
    }

    public void incOutputs() {
        this.incOutputs(1L);
    }

    public void incOutputs(long l) {
        this.outputs += l;
    }

    public void incRelaxedParameters() {
        this.incRelaxedParameters(1L);
    }

    public void incRelaxedParameters(long l) {
        this.relaxedParameters += l;
    }

    public void incRelaxedVariables() {
        this.incRelaxedVariables(1L);
    }

    public void incRelaxedVariables(long l) {
        this.relaxedVariables += l;
    }

    public void setEquations(long l) {
        this.equations = l;
    }

    public void setRelaxedVariables(long l) {
        this.expectedRelaxedVariables = l;
    }

    public boolean isEmpty() {
        return this.equations == 0L && this.fixedParameters == 0L && this.relaxedParameters == 0L && this.fixedVariables == 0L && this.relaxedVariables == 0L && this.discreteStates == 0L && this.inputs == 0L && this.outputs == 0L && this.derivativeStates == 0L;
    }

    public void clear() {
        this.equations = 0L;
        this.fixedParameters = 0L;
        this.relaxedParameters = 0L;
        this.fixedVariables = 0L;
        this.relaxedVariables = 0L;
        this.discreteStates = 0L;
        this.inputs = 0L;
        this.outputs = 0L;
        this.derivativeStates = 0L;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public void fireChange() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

