/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.spec;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.scilab.modules.commons.xml.ScilabXMLOutputFactory;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.io.sax.XcosSAXHandler;
import org.scilab.modules.xcos.io.spec.Entry;
import org.scilab.modules.xcos.io.spec.XcosPackage;
import org.scilab.modules.xcos.io.writer.XcosWriter;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ContentEntry
implements Entry {
    private static final Logger LOG = Logger.getLogger(ContentEntry.class.getName());
    private XcosDiagram content;
    private XcosPackage pack;

    @Override
    public String getMediaType() {
        return "text/xml";
    }

    @Override
    public String getFullPath() {
        return "content.xml";
    }

    @Override
    public void setup(XcosPackage xcosPackage) {
        this.pack = xcosPackage;
        this.content = xcosPackage.getContent();
    }

    @Override
    public void load(ZipEntry zipEntry, InputStream inputStream, String string) throws CharConversionException, IOException {
        if (string == null) {
            string = "UTF-8";
        }
        try {
            XcosSAXHandler xcosSAXHandler = new XcosSAXHandler(this.content, this.pack.getDictionary());
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(xcosSAXHandler);
            xMLReader.setErrorHandler(xcosSAXHandler);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setEncoding(string);
            LOG.entering("XMLReader", "parse");
            xMLReader.parse(inputSource);
            LOG.exiting("XMLReader", "parse");
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new RuntimeException(sAXException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(ZipOutputStream zipOutputStream) throws IOException {
        try {
            XMLOutputFactory xMLOutputFactory = ScilabXMLOutputFactory.newInstance();
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(zipOutputStream, "UTF-8");
            LOG.entering("XMLStreamWriter", "write");
            new XcosWriter(this.pack.getDictionary(), xMLStreamWriter).write(this.content.getUID(), this.content.getKind());
            xMLStreamWriter.close();
            LOG.exiting("XMLStreamWriter", "write");
            Element element = this.pack.getManifest().createElement("manifest:file-entry");
            element.setAttribute("manifest:media-type", this.getMediaType());
            element.setAttribute("manifest:full-path", this.getFullPath());
            this.pack.getManifest().getFirstChild().appendChild(element);
        }
        catch (XMLStreamException xMLStreamException) {
            Logger.getLogger(ContentEntry.class.getName()).severe(xMLStreamException.getMessage());
        }
        finally {
            zipOutputStream.closeEntry();
        }
    }
}

