/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import java.util.Arrays;
import java.util.List;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.block.TextBlock;
import org.scilab.modules.xcos.graph.model.BlockInterFunction;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.io.scicos.AbstractElement;
import org.scilab.modules.xcos.io.scicos.BlockGraphicElement;
import org.scilab.modules.xcos.io.scicos.BlockModelElement;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;

public final class LabelElement
extends AbstractElement<TextBlock> {
    protected static final List<String> DATA_FIELD_NAMES = Arrays.asList("Text", "graphics", "model", "void", "gui");
    private static final int INTERFUNCTION_INDEX = DATA_FIELD_NAMES.indexOf("gui");
    private ScilabMList data;
    private final BlockModelElement modelElement;
    private final BlockGraphicElement graphicElement;

    public LabelElement(JavaController javaController) {
        super(javaController);
        this.modelElement = new BlockModelElement(this.controller, null);
        this.graphicElement = new BlockGraphicElement(this.controller, null, 1.0);
    }

    @Override
    public TextBlock decode(ScilabType scilabType, TextBlock textBlock) throws ScicosFormatException {
        TextBlock textBlock2 = textBlock;
        this.data = (ScilabMList)scilabType;
        this.validate();
        String string = ((ScilabString)this.data.get(INTERFUNCTION_INDEX)).getData()[0][0];
        if (textBlock == null) {
            BlockInterFunction blockInterFunction = XcosCellFactory.lookForInterfunction(string);
            textBlock2 = (TextBlock)XcosCellFactory.createBlock(this.controller, blockInterFunction, string, this.controller.createObject(Kind.ANNOTATION), Kind.ANNOTATION);
        }
        textBlock2 = this.beforeDecode(scilabType, textBlock2);
        int n = 1;
        this.graphicElement.decode((ScilabType)this.data.get(n), textBlock2);
        this.modelElement.decode((ScilabType)this.data.get(++n), textBlock2);
        ++n;
        ++n;
        textBlock2 = this.afterDecode(scilabType, textBlock2);
        return textBlock2;
    }

    private void validate() throws ScicosFormatException {
        if (!this.canDecode((ScilabType)this.data)) {
            throw new ScicosFormatException.WrongElementException();
        }
        int n = 0;
        if (this.data.size() != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        String[] stringArray = ((ScilabString)this.data.get(n)).getData()[0];
        if (stringArray.length != DATA_FIELD_NAMES.size()) {
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(DATA_FIELD_NAMES.get(i))) continue;
            throw new ScicosFormatException.WrongStructureException(DATA_FIELD_NAMES);
        }
        if (!(this.data.get(++n) instanceof ScilabMList)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabMList)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString)) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
        if (!(this.data.get(++n) instanceof ScilabString) && LabelElement.isEmptyField((ScilabType)this.data.get(n))) {
            throw new ScicosFormatException.WrongTypeException(DATA_FIELD_NAMES, n);
        }
    }

    @Override
    public boolean canDecode(ScilabType scilabType) {
        this.data = (ScilabMList)scilabType;
        String string = ((ScilabString)this.data.get(0)).getData()[0][0];
        return string.equals(DATA_FIELD_NAMES.get(0));
    }
}

