/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import com.mxgraph.model.mxICell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.link.BasicLink;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.Orientation;
import org.scilab.modules.xcos.port.command.CommandPort;
import org.scilab.modules.xcos.port.control.ControlPort;
import org.scilab.modules.xcos.port.input.InputPort;
import org.scilab.modules.xcos.port.output.OutputPort;

public final class BasicBlockInfo {
    private BasicBlockInfo() {
    }

    protected static ScilabDouble getAllLinkId(List<? extends BasicPort> list) {
        if (list.isEmpty()) {
            return new ScilabDouble();
        }
        double[][] dArray = new double[list.size()][1];
        for (int i = 0; i < list.size(); ++i) {
            BasicPort basicPort = list.get(i);
            dArray[i][0] = basicPort.getEdgeCount() == 1 ? (double)((BasicLink)basicPort.getEdgeAt(0)).getOrdering() : 0.0;
        }
        return new ScilabDouble(dArray);
    }

    public static <T extends BasicPort> List<T> getAllTypedPorts(BasicBlock basicBlock, boolean bl, Class<T> clazz) {
        ArrayList<BasicPort> arrayList = new ArrayList<BasicPort>();
        if (basicBlock == null) {
            return arrayList;
        }
        int n = basicBlock.getChildCount();
        Class<T> clazz2 = clazz;
        while (!clazz2.getSuperclass().equals(BasicPort.class)) {
            clazz2 = clazz2.getSuperclass();
        }
        for (int i = 0; i < n; ++i) {
            mxICell mxICell2 = basicBlock.getChildAt(i);
            if (!clazz2.isInstance(mxICell2)) continue;
            arrayList.add((BasicPort)mxICell2);
        }
        if (bl) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    public static List<BasicPort> getAllPortsAtPosition(BasicBlock basicBlock, int n) {
        ArrayList<BasicPort> arrayList = new ArrayList<BasicPort>();
        if (basicBlock == null) {
            return arrayList;
        }
        HashMap<Class<InputPort>, Integer> hashMap = new HashMap<Class<InputPort>, Integer>();
        int n2 = basicBlock.getChildCount();
        for (int i = 0; i < n2; ++i) {
            mxICell mxICell2 = basicBlock.getChildAt(i);
            Class clazz = mxICell2 instanceof InputPort ? InputPort.class : (mxICell2 instanceof OutputPort ? OutputPort.class : (mxICell2 instanceof ControlPort ? ControlPort.class : (mxICell2 instanceof CommandPort ? CommandPort.class : null)));
            if (clazz == null) continue;
            BasicPort basicPort = (BasicPort)mxICell2;
            Integer n3 = hashMap.getOrDefault(clazz, 1);
            if (n3 == n) {
                arrayList.add(basicPort);
            }
            hashMap.put(clazz, n3 + 1);
        }
        return arrayList;
    }

    public static Map<Orientation, List<BasicPort>> getAllOrientedPorts(BasicBlock basicBlock) {
        EnumMap<Orientation, List<BasicPort>> enumMap = new EnumMap<Orientation, List<BasicPort>>(Orientation.class);
        ArrayList<BasicPort> arrayList = new ArrayList<BasicPort>();
        ArrayList<BasicPort> arrayList2 = new ArrayList<BasicPort>();
        ArrayList<BasicPort> arrayList3 = new ArrayList<BasicPort>();
        ArrayList<BasicPort> arrayList4 = new ArrayList<BasicPort>();
        int n = basicBlock.getChildCount();
        block6: for (int i = 0; i < n; ++i) {
            if (!(basicBlock.getChildAt(i) instanceof BasicPort)) continue;
            BasicPort basicPort = (BasicPort)basicBlock.getChildAt(i);
            switch (basicPort.getOrientation()) {
                case NORTH: {
                    arrayList.add(basicPort);
                    continue block6;
                }
                case SOUTH: {
                    arrayList2.add(basicPort);
                    continue block6;
                }
                case EAST: {
                    arrayList3.add(basicPort);
                    continue block6;
                }
                case WEST: {
                    arrayList4.add(basicPort);
                    continue block6;
                }
            }
        }
        enumMap.put(Orientation.NORTH, arrayList);
        enumMap.put(Orientation.SOUTH, arrayList2);
        enumMap.put(Orientation.EAST, arrayList3);
        enumMap.put(Orientation.WEST, arrayList4);
        return enumMap;
    }
}

