/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.sax;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.io.HandledElement;
import org.scilab.modules.xcos.io.sax.RawDataHandler;
import org.scilab.modules.xcos.io.sax.ScilabHandler;
import org.scilab.modules.xcos.io.sax.XcosSAXHandler;
import org.xml.sax.Attributes;

class JGraphXHandler
implements ScilabHandler {
    private final XcosSAXHandler saxHandler;

    JGraphXHandler(XcosSAXHandler xcosSAXHandler) {
        this.saxHandler = xcosSAXHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object startElement(HandledElement handledElement, Attributes attributes) {
        switch (handledElement) {
            case mxCell: {
                XcosCell xcosCell;
                String string = attributes.getValue("parent");
                if (string != null) {
                    long l = this.saxHandler.allChildren.peek().getOrDefault(string, 0L);
                    if (l == 0L) return null;
                    return this.decodeCellAnnotation(l, this.saxHandler.controller.getKind(l), attributes);
                }
                Object object = this.saxHandler.parents.peek();
                if (!(object instanceof XcosCell) || (xcosCell = (XcosCell)((Object)object)).getUID() == 0L) return null;
                return this.decodeCellAnnotation(xcosCell.getUID(), xcosCell.getKind(), attributes);
            }
            case mxGeometry: {
                Object object;
                mxGeometry mxGeometry2 = new mxGeometry();
                String string = attributes.getValue("x");
                if (string != null) {
                    mxGeometry2.setX(Double.valueOf(string).doubleValue());
                }
                if ((string = attributes.getValue("y")) != null) {
                    mxGeometry2.setY(Double.valueOf(string).doubleValue());
                }
                if ((string = attributes.getValue("width")) != null) {
                    mxGeometry2.setWidth(Double.valueOf(string).doubleValue());
                }
                if ((string = attributes.getValue("height")) != null) {
                    mxGeometry2.setHeight(Double.valueOf(string).doubleValue());
                }
                if ((string = attributes.getValue("relative")) == null || string.charAt(0) != '1' || !((object = this.saxHandler.parents.peek()) instanceof XcosCell)) return mxGeometry2;
                XcosCell xcosCell = (XcosCell)((Object)object);
                long[] lArray = new long[]{0L};
                this.saxHandler.controller.getObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.RELATED_TO, lArray);
                VectorOfDouble vectorOfDouble = new VectorOfDouble(4L);
                this.saxHandler.controller.getObjectProperty(lArray[0], this.saxHandler.controller.getKind(lArray[0]), ObjectProperties.GEOMETRY, vectorOfDouble);
                mxGeometry2.setX(mxGeometry2.getX() * vectorOfDouble.get(2));
                mxGeometry2.setY(mxGeometry2.getY() * vectorOfDouble.get(3));
                return mxGeometry2;
            }
            case mxPoint: {
                Object object;
                mxPoint mxPoint2 = new mxPoint();
                String string = attributes.getValue("x");
                if (string != null) {
                    mxPoint2.setX(Double.valueOf(string).doubleValue());
                }
                if ((string = attributes.getValue("y")) != null) {
                    mxPoint2.setY(Double.valueOf(string).doubleValue());
                }
                if ((object = this.saxHandler.parents.peek()) instanceof mxGeometry) {
                    mxGeometry mxGeometry3 = (mxGeometry)object;
                    string = attributes.getValue("as");
                    if ("sourcePoint".equals(string)) {
                        mxGeometry3.setSourcePoint(mxPoint2);
                        return mxPoint2;
                    } else {
                        if (!"targetPoint".equals(string)) return mxPoint2;
                        mxGeometry3.setTargetPoint(mxPoint2);
                    }
                    return mxPoint2;
                } else if (object instanceof RawDataHandler.RawDataDescriptor) {
                    RawDataHandler.RawDataDescriptor rawDataDescriptor = (RawDataHandler.RawDataDescriptor)object;
                    ((ArrayList)rawDataDescriptor.value).add(mxPoint2);
                    return mxPoint2;
                } else {
                    if (!(object instanceof XcosCell)) return mxPoint2;
                    XcosCell xcosCell = (XcosCell)((Object)object);
                    VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
                    this.saxHandler.controller.getObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.CHILDREN, vectorOfScicosID);
                    VectorOfDouble vectorOfDouble = new VectorOfDouble(4L);
                    DoubleBuffer doubleBuffer = vectorOfDouble.asByteBuffer(0, 4).asDoubleBuffer();
                    LongBuffer longBuffer = vectorOfScicosID.asByteBuffer(0, vectorOfScicosID.size()).asLongBuffer();
                    while (longBuffer.hasRemaining()) {
                        long l = longBuffer.get();
                        Kind kind = this.saxHandler.controller.getKind(l);
                        this.saxHandler.controller.getObjectProperty(l, kind, ObjectProperties.GEOMETRY, vectorOfDouble);
                        doubleBuffer.put(0, doubleBuffer.get(0) + mxPoint2.getX());
                        doubleBuffer.put(1, doubleBuffer.get(1) + mxPoint2.getY());
                        this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.GEOMETRY, vectorOfDouble);
                        long[] lArray = new long[]{0L};
                        this.saxHandler.controller.getObjectProperty(l, kind, ObjectProperties.LABEL, lArray);
                        if (lArray[0] != 0L) {
                            this.saxHandler.controller.getObjectProperty(lArray[0], Kind.ANNOTATION, ObjectProperties.GEOMETRY, vectorOfDouble);
                            doubleBuffer.put(0, doubleBuffer.get(0) + mxPoint2.getX());
                            doubleBuffer.put(1, doubleBuffer.get(1) + mxPoint2.getY());
                            this.saxHandler.controller.setObjectProperty(lArray[0], Kind.ANNOTATION, ObjectProperties.GEOMETRY, vectorOfDouble);
                        }
                        if (kind != Kind.LINK) continue;
                        VectorOfDouble vectorOfDouble2 = new VectorOfDouble();
                        this.saxHandler.controller.getObjectProperty(l, kind, ObjectProperties.CONTROL_POINTS, vectorOfDouble2);
                        DoubleBuffer doubleBuffer2 = vectorOfDouble2.asByteBuffer(0, vectorOfDouble2.size()).asDoubleBuffer();
                        for (int i = 0; i < vectorOfDouble2.size(); i += 2) {
                            doubleBuffer2.put(i, doubleBuffer2.get(i) + mxPoint2.getX());
                            doubleBuffer2.put(i + 1, doubleBuffer2.get(i + 1) + mxPoint2.getY());
                        }
                        this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.CONTROL_POINTS, vectorOfDouble2);
                    }
                }
                return mxPoint2;
            }
        }
        throw new IllegalArgumentException();
    }

    private XcosCell decodeCellAnnotation(long l, Kind kind, Attributes attributes) {
        String string;
        String string2;
        Kind kind2 = Kind.ANNOTATION;
        long l2 = this.saxHandler.controller.createObject(kind2);
        String string3 = attributes.getValue("value");
        if (string3 != null) {
            this.saxHandler.controller.setObjectProperty(l2, kind2, ObjectProperties.DESCRIPTION, mxUtils.getBodyMarkup((String)string3, (boolean)false));
        }
        if ((string2 = attributes.getValue("style")) != null) {
            this.saxHandler.controller.setObjectProperty(l2, kind2, ObjectProperties.STYLE, string2);
        }
        if ((string = attributes.getValue("id")) != null) {
            this.saxHandler.allChildren.peek().put(string, l2);
        }
        XcosCell xcosCell = new XcosCell(this.saxHandler.controller, l2, kind2, string3, null, string2, string);
        this.saxHandler.controller.setObjectProperty(l, kind, ObjectProperties.LABEL, xcosCell.getUID());
        this.saxHandler.controller.setObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.RELATED_TO, l);
        return xcosCell;
    }

    @Override
    public void endElement(HandledElement handledElement) {
        switch (handledElement) {
            case mxCell: {
                break;
            }
            case mxGeometry: {
                if (!(this.saxHandler.parents.peek() instanceof mxGeometry)) {
                    return;
                }
                mxGeometry mxGeometry2 = (mxGeometry)this.saxHandler.parents.peek();
                if (!(this.saxHandler.parents.peek(1) instanceof XcosCell)) {
                    return;
                }
                XcosCell xcosCell = (XcosCell)((Object)this.saxHandler.parents.peek(1));
                xcosCell.setGeometry(this.saxHandler.controller, mxGeometry2);
                break;
            }
            case mxPoint: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

