/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.graph.swing.handler;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxGraphHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxGraph;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.GraphActionManager;
import org.scilab.modules.xcos.actions.EditFormatAction;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.TextBlock;
import org.scilab.modules.xcos.block.actions.BlockParametersAction;
import org.scilab.modules.xcos.graph.model.BlockInterFunction;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.graph.swing.GraphComponent;
import org.scilab.modules.xcos.link.BasicLink;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.utils.XcosMessages;

public class GraphHandler
extends mxGraphHandler {
    public GraphHandler(GraphComponent graphComponent) {
        super((mxGraphComponent)graphComponent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed() && !this.graphComponent.isForceMarqueeEvent(mouseEvent)) {
            this.cell = this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), false);
            if (mouseEvent.getClickCount() >= 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this.cell instanceof BasicLink) {
                    this.clickOnLink(mouseEvent, (BasicLink)((Object)this.cell));
                } else if (this.cell instanceof BasicBlock) {
                    this.openBlock(this.graphComponent, mouseEvent, (BasicBlock)this.cell);
                } else if (this.cell instanceof BasicPort) {
                    this.openBlock(this.graphComponent, mouseEvent, (BasicBlock)((BasicPort)((Object)this.cell)).getParent());
                } else if (this.cell instanceof XcosCell) {
                    this.openCell(this.graphComponent, mouseEvent, (XcosCell)((Object)this.cell));
                } else if (this.cell == null) {
                    this.createTextBlock(mouseEvent);
                }
            } else if (mouseEvent.getClickCount() == 1 && SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isPopupTrigger() || XcosMessages.isMacOsPopupTrigger(mouseEvent)) {
                if (this.cell == null) {
                    ((GraphComponent)this.graphComponent).displayContextMenu();
                } else if (this.cell instanceof BasicLink) {
                    ((BasicLink)((Object)this.cell)).openContextMenu((ScilabGraph)this.graphComponent.getGraph());
                } else if (this.cell instanceof BasicBlock) {
                    ((BasicBlock)this.cell).openContextMenu((ScilabGraph)this.graphComponent.getGraph());
                }
                mouseEvent.consume();
            }
        }
        if (!mouseEvent.isConsumed()) {
            super.mouseClicked(mouseEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTextBlock(MouseEvent mouseEvent) {
        TextBlock textBlock;
        try {
            textBlock = (TextBlock)XcosCellFactory.createBlock(BlockInterFunction.TEXT_f);
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            throw new RuntimeException(interpreterException);
        }
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        mxGraph2.getModel().beginUpdate();
        try {
            mxGraph2.addCell((Object)textBlock);
            mxPoint mxPoint2 = this.graphComponent.getPointForEvent(mouseEvent);
            mxGeometry mxGeometry2 = textBlock.getGeometry();
            mxGraph2.moveCells(new Object[]{textBlock}, mxPoint2.getX(), mxPoint2.getY() + mxGeometry2.getHeight());
        }
        finally {
            mxGraph2.getModel().endUpdate();
        }
        mouseEvent.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clickOnLink(MouseEvent mouseEvent, BasicLink basicLink) {
        mxIGraphModel mxIGraphModel2;
        ArrayList<mxPoint> arrayList = this.graphComponent.getGraph().getCellGeometry((Object)basicLink).getPoints();
        if (arrayList == null) {
            arrayList = new ArrayList<mxPoint>();
            basicLink.getGeometry().setPoints(arrayList);
        }
        mxPoint mxPoint2 = this.graphComponent.getPointForEvent(mouseEvent);
        if (basicLink.getSource() != null && basicLink.getTarget() != null && basicLink.getSource().getParent() == basicLink.getTarget().getParent() && basicLink.getSource().getParent() != null) {
            mxIGraphModel2 = basicLink.getSource().getParent().getGeometry();
            mxPoint2.setX(mxPoint2.getX() - mxIGraphModel2.getX());
            mxPoint2.setY(mxPoint2.getY() - mxIGraphModel2.getY());
        }
        mxIGraphModel2 = this.graphComponent.getGraph().getModel();
        mxIGraphModel2.beginUpdate();
        try {
            int n = basicLink.findNearestSegment(mxPoint2);
            if (n < arrayList.size() && ((mxPoint)arrayList.get(n)).getPoint().distanceSq(mxPoint2.getPoint()) == 0.0) {
                arrayList.remove(n);
            } else {
                arrayList.add(n, mxPoint2);
            }
            mxIGraphModel2.setGeometry((Object)basicLink, (mxGeometry)basicLink.getGeometry().clone());
        }
        finally {
            mxIGraphModel2.endUpdate();
        }
        mouseEvent.consume();
    }

    private void openBlock(mxGraphComponent mxGraphComponent2, MouseEvent mouseEvent, BasicBlock basicBlock) {
        BlockParametersAction blockParametersAction = (BlockParametersAction)GraphActionManager.getInstance((ScilabGraph)((ScilabGraph)mxGraphComponent2.getGraph()), BlockParametersAction.class);
        blockParametersAction.actionPerformed();
        mouseEvent.consume();
    }

    private void openCell(mxGraphComponent mxGraphComponent2, MouseEvent mouseEvent, XcosCell xcosCell) {
        EditFormatAction editFormatAction = (EditFormatAction)GraphActionManager.getInstance((ScilabGraph)((ScilabGraph)mxGraphComponent2.getGraph()), EditFormatAction.class);
        editFormatAction.actionPerformed();
        mouseEvent.consume();
    }

    static {
        try {
            mxGraphTransferable.dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=com.mxgraph.swing.util.mxGraphTransferable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(GraphHandler.class.getName()).severe(classNotFoundException.toString());
        }
    }
}

