/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.block.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.graph.ScilabComponent;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.SuperBlock;
import org.scilab.modules.xcos.block.actions.SuperBlockSelectedAction;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.utils.BlockPositioning;
import org.scilab.modules.xcos.utils.XcosMessages;

public class CodeGenerationAction
extends SuperBlockSelectedAction {
    public static final String NAME = XcosMessages.CODE_GENERATION;
    public static final String SMALL_ICON = "";
    public static final int MNEMONIC_KEY = 0;
    public static final int ACCELERATOR_KEY = 0;

    public CodeGenerationAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return CodeGenerationAction.createMenu((ScilabGraph)scilabGraph, CodeGenerationAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final XcosDiagram xcosDiagram = (XcosDiagram)this.getGraph(actionEvent);
        ScilabComponent scilabComponent = (ScilabComponent)xcosDiagram.getAsComponent();
        if (scilabComponent.isEditing()) {
            return;
        }
        Object object = xcosDiagram.getSelectionCell();
        if (!(object instanceof SuperBlock)) {
            xcosDiagram.error(XcosMessages.ERROR_GENERATING_C_CODE);
            return;
        }
        xcosDiagram.info(XcosMessages.GENERATING_C_CODE);
        xcosDiagram.setCellsLocked(true);
        xcosDiagram.getAsComponent().getGraphControl().setCursor(Cursor.getPredefinedCursor(3));
        final JavaController javaController = new JavaController();
        final SuperBlock superBlock = (SuperBlock)object;
        try {
            String string = ScilabInterpreterManagement.buildCall((String)"scicos_new", (Object[])new Object[]{Long.toHexString(superBlock.getUID())});
            String string2 = ScilabInterpreterManagement.buildCall((String)"blk = xcosCodeGeneration", (Object[])new Object[]{string.toCharArray()});
            ActionListener actionListener = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    xcosDiagram.getView().clear((Object)this, true, true);
                    xcosDiagram.getModel().beginUpdate();
                    try {
                        BasicBlock basicBlock;
                        ScicosObjectOwner scicosObjectOwner = XcosCellFactory.getLastCreated();
                        if (scicosObjectOwner != null && scicosObjectOwner.getUID() != 0L && (basicBlock = XcosCellFactory.createBlock(javaController, scicosObjectOwner)) != null) {
                            superBlock.updateBlockSettings(javaController, xcosDiagram, basicBlock);
                        }
                        BlockPositioning.updateBlockView(xcosDiagram, superBlock);
                    }
                    finally {
                        xcosDiagram.getModel().endUpdate();
                        xcosDiagram.getAsComponent().getGraphControl().setCursor(Cursor.getPredefinedCursor(0));
                        xcosDiagram.setCellsLocked(false);
                        xcosDiagram.info(CodeGenerationAction.SMALL_ICON);
                    }
                }
            };
            ScilabInterpreterManagement.asynchronousScilabExec((ActionListener)actionListener, (String)string2);
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            xcosDiagram.getAsComponent().getGraphControl().setCursor(Cursor.getPredefinedCursor(0));
            xcosDiagram.setCellsLocked(false);
            xcosDiagram.info(SMALL_ICON);
        }
    }
}

