/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.configuration.model.DocumentType;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class RecentFileAction
extends DefaultAction
implements PropertyChangeListener {
    public static final String NAME = XcosMessages.RECENT_FILES;
    public static final String SMALL_ICON = "";
    public static final int MNEMONIC_KEY = 0;
    public static final int ACCELERATOR_KEY = 0;
    private static final Map<URI, RecentFileAction> INSTANCE_REGISTRY = new HashMap<URI, RecentFileAction>();
    private File recentFile;
    private MenuItem menu;

    private RecentFileAction(File file) {
        super(null);
        this.recentFile = file;
    }

    private void setMenu(MenuItem menuItem) {
        this.menu = menuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Xcos.getInstance().open(this.recentFile.getCanonicalPath(), 0L);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static MenuItem createMenu(URL uRL) {
        File file;
        URI uRI;
        try {
            uRI = uRL.toURI();
            file = new File(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.getLogger(RecentFileAction.class.getName()).severe(uRISyntaxException.toString());
            return null;
        }
        RecentFileAction recentFileAction = INSTANCE_REGISTRY.get(uRI);
        if (recentFileAction == null) {
            recentFileAction = new RecentFileAction(file);
        }
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        configurationManager.addPropertyChangeListener("recentFilesHasChanged", recentFileAction);
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback((CommonCallBack)recentFileAction);
        menuItem.setText(file.getName());
        recentFileAction.setMenu(menuItem);
        return menuItem;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        URL uRL;
        URL uRL2;
        assert (propertyChangeEvent.getPropertyName().equals("recentFilesHasChanged"));
        if (propertyChangeEvent.getOldValue() == null) {
            return;
        }
        String string = ((DocumentType)propertyChangeEvent.getOldValue()).getUrl();
        String string2 = ((DocumentType)propertyChangeEvent.getNewValue()).getUrl();
        try {
            uRL2 = new URL(string);
            uRL = this.recentFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(RecentFileAction.class.getName()).severe(malformedURLException.toString());
            return;
        }
        if (!uRL.sameFile(uRL2)) {
            return;
        }
        try {
            URL uRL3 = new URL(string2);
            URI uRI = uRL3.toURI();
            this.recentFile = new File(uRI);
            this.menu.setText(this.recentFile.getName());
            INSTANCE_REGISTRY.remove(uRL2.toURI());
            INSTANCE_REGISTRY.put(uRI, this);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.getLogger(RecentFileAction.class.getName()).severe(uRISyntaxException.toString());
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(RecentFileAction.class.getName()).severe(malformedURLException.toString());
        }
    }
}

