/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.utils;

import com.mxgraph.util.mxUtils;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.modules.graph.view.SupportedLabelType;
import org.w3c.dom.Document;

public final class ScilabGraphUtils
extends mxUtils {
    private static Map<URL, WeakReference<GraphicsNode>> generatedSVGComponents = new HashMap<URL, WeakReference<GraphicsNode>>();
    private static Map<URL, Dimension2D> generatedSVGSizes = new HashMap<URL, Dimension2D>();
    private static Map<Float, Map<String, TeXIcon>> generatedLatexIcons = new WeakHashMap<Float, Map<String, TeXIcon>>();
    private static final String[][] HTML_ESCAPE_TABLE = new String[][]{{"&lt;", "<"}, {"&gt;", ">"}, {"&amp;", "&"}, {"&quot;", "\""}, {"&agrave;", "\u00e0"}, {"&Agrave;", "\u00c0"}, {"&acirc;", "\u00e2"}, {"&auml;", "\u00e4"}, {"&Auml;", "\u00c4"}, {"&Acirc;", "\u00c2"}, {"&aring;", "\u00e5"}, {"&Aring;", "\u00c5"}, {"&aelig;", "\u00e6"}, {"&AElig;", "\u00c6"}, {"&ccedil;", "\u00e7"}, {"&Ccedil;", "\u00c7"}, {"&eacute;", "\u00e9"}, {"&Eacute;", "\u00c9"}, {"&egrave;", "\u00e8"}, {"&Egrave;", "\u00c8"}, {"&ecirc;", "\u00ea"}, {"&Ecirc;", "\u00ca"}, {"&euml;", "\u00eb"}, {"&Euml;", "\u00cb"}, {"&iuml;", "\u00ef"}, {"&Iuml;", "\u00cf"}, {"&ocirc;", "\u00f4"}, {"&Ocirc;", "\u00d4"}, {"&ouml;", "\u00f6"}, {"&Ouml;", "\u00d6"}, {"&oslash;", "\u00f8"}, {"&Oslash;", "\u00d8"}, {"&szlig;", "\u00df"}, {"&ugrave;", "\u00f9"}, {"&Ugrave;", "\u00d9"}, {"&ucirc;", "\u00fb"}, {"&Ucirc;", "\u00db"}, {"&uuml;", "\u00fc"}, {"&Uuml;", "\u00dc"}, {"&nbsp;", " "}, {"&reg;", "\u00a9"}, {"&copy;", "\u00ae"}, {"&euro;", "\u20a0"}};

    public static GraphicsNode getSVGComponent(URL uRL) {
        WeakReference<GraphicsNode> weakReference = generatedSVGComponents.get(uRL);
        GraphicsNode graphicsNode = weakReference != null ? (GraphicsNode)weakReference.get() : null;
        if (graphicsNode == null) {
            try {
                String string = XMLResourceDescriptor.getXMLParserClassName();
                SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(string);
                Document document = sAXSVGDocumentFactory.createDocument(uRL.toString());
                UserAgentAdapter userAgentAdapter = new UserAgentAdapter();
                DocumentLoader documentLoader = new DocumentLoader((UserAgent)userAgentAdapter);
                BridgeContext bridgeContext = new BridgeContext((UserAgent)userAgentAdapter, documentLoader);
                bridgeContext.setDynamicState(0);
                GVTBuilder gVTBuilder = new GVTBuilder();
                graphicsNode = gVTBuilder.build(bridgeContext, document);
                generatedSVGComponents.put(uRL, graphicsNode.getWeakReference());
                generatedSVGSizes.put(uRL, bridgeContext.getDocumentSize());
            }
            catch (IOException | NullPointerException exception) {
                Logger.getLogger(ScilabGraphUtils.class.getName()).severe(exception.toString());
            }
        }
        return graphicsNode;
    }

    public static Dimension2D getSVGDocumentSizes(URL uRL) {
        Dimension2D dimension2D = generatedSVGSizes.get(uRL);
        if (dimension2D == null) {
            ScilabGraphUtils.getSVGComponent(uRL);
            dimension2D = generatedSVGSizes.get(uRL);
        }
        return dimension2D;
    }

    public static Icon getTexIcon(String string, float f) throws ParseException {
        TeXIcon teXIcon;
        String string2 = SupportedLabelType.Latex.escape(string);
        Map<String, TeXIcon> map = generatedLatexIcons.get(Float.valueOf(f));
        if (map == null) {
            map = new WeakHashMap<String, TeXIcon>();
            generatedLatexIcons.put(Float.valueOf(f), map);
        }
        if ((teXIcon = map.get(string2)) == null) {
            TeXFormula teXFormula = new TeXFormula(string2);
            teXIcon = teXFormula.createTeXIcon(0, f);
            map.put(string2, teXIcon);
        }
        return teXIcon;
    }

    public static void removeBlanks(StringBuilder stringBuilder) {
        char c;
        int n;
        for (n = 0; n < stringBuilder.length() && ((c = stringBuilder.charAt(n)) == ' ' || c == '\n'); ++n) {
        }
        stringBuilder.delete(0, n);
    }

    public static void unescape(StringBuilder stringBuilder, int n) {
        int n2 = stringBuilder.indexOf("&", n);
        if (n2 > -1) {
            int n3 = stringBuilder.indexOf(";", n2);
            n = n2 + 1;
            if (n3 > n2) {
                int n4;
                String string = stringBuilder.substring(n2, n3 + 1);
                for (n4 = 0; n4 < HTML_ESCAPE_TABLE.length && !HTML_ESCAPE_TABLE[n4][0].equals(string); ++n4) {
                }
                if (n4 < HTML_ESCAPE_TABLE.length) {
                    stringBuilder.replace(n2, n3 + 1, HTML_ESCAPE_TABLE[n4][1]);
                    ScilabGraphUtils.unescape(stringBuilder, n);
                }
            }
        }
    }

    private ScilabGraphUtils() {
    }
}

