/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.contrib.nanoxml;

import com.l2fprod.contrib.nanoxml.XMLParseException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class XMLElement
implements Serializable {
    public static final int NANOXML_MAJOR_VERSION = 1;
    public static final int NANOXML_MINOR_VERSION = 6;
    static final long serialVersionUID = 6685035139346394777L;
    private Properties attributes;
    private Vector children;
    private String tagName;
    private String contents;
    private Properties conversionTable;
    private boolean skipLeadingWhitespace;
    private int lineNr;
    private boolean ignoreCase;

    public void setContent(String content) {
        this.contents = content;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public Vector getChildren() {
        return this.children;
    }

    public String getContents() {
        return this.contents;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    /*
     * WARNING - void declaration
     */
    public int getIntProperty(String key, Hashtable valueSet, String defaultValue) {
        void result;
        String val = this.attributes.getProperty(key);
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        if (val == null) {
            val = defaultValue;
        }
        try {
            Integer n = (Integer)valueSet.get(val);
        }
        catch (ClassCastException e) {
            throw this.invalidValueSet(key);
        }
        if (result == null) {
            throw this.invalidValue(key, val, this.lineNr);
        }
        return result.intValue();
    }

    public String getProperty(String key) {
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        return this.attributes.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        return this.attributes.getProperty(key, defaultValue);
    }

    public int getProperty(String key, int defaultValue) {
        String val;
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        if ((val = this.attributes.getProperty(key)) == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw this.invalidValue(key, val, this.lineNr);
        }
    }

    public double getProperty(String key, double defaultValue) {
        String val;
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        if ((val = this.attributes.getProperty(key)) == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw this.invalidValue(key, val, this.lineNr);
        }
    }

    public boolean getProperty(String key, String trueValue, String falseValue, boolean defaultValue) {
        String val;
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        if ((val = this.attributes.getProperty(key)) == null) {
            return defaultValue;
        }
        if (val.equals(trueValue)) {
            return true;
        }
        if (val.equals(falseValue)) {
            return false;
        }
        throw this.invalidValue(key, val, this.lineNr);
    }

    public Object getProperty(String key, Hashtable valueSet, String defaultValue) {
        Object result;
        String val;
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        if ((val = this.attributes.getProperty(key)) == null) {
            val = defaultValue;
        }
        if ((result = valueSet.get(val)) == null) {
            throw this.invalidValue(key, val, this.lineNr);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public String getStringProperty(String key, Hashtable valueSet, String defaultValue) {
        void result;
        String val;
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        if ((val = this.attributes.getProperty(key)) == null) {
            val = defaultValue;
        }
        try {
            String string = (String)valueSet.get(val);
        }
        catch (ClassCastException e) {
            throw this.invalidValueSet(key);
        }
        if (result == null) {
            throw this.invalidValue(key, val, this.lineNr);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public int getSpecialIntProperty(String key, Hashtable valueSet, String defaultValue) {
        void result;
        String val;
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        if ((val = this.attributes.getProperty(key)) == null) {
            val = defaultValue;
        }
        try {
            Integer n = (Integer)valueSet.get(val);
        }
        catch (ClassCastException e) {
            throw this.invalidValueSet(key);
        }
        if (result == null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                throw this.invalidValue(key, val, this.lineNr);
            }
        }
        return result.intValue();
    }

    public double getSpecialDoubleProperty(String key, Hashtable valueSet, String defaultValue) {
        Double result;
        String val;
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        if ((val = this.attributes.getProperty(key)) == null) {
            val = defaultValue;
        }
        try {
            Double d = (Double)valueSet.get(val);
        }
        catch (ClassCastException e) {
            throw this.invalidValueSet(key);
        }
        if (result == null) {
            try {
                result = Double.valueOf(val);
            }
            catch (NumberFormatException e) {
                throw this.invalidValue(key, val, this.lineNr);
            }
        }
        return result;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void addChild(XMLElement child) {
        this.children.addElement(child);
    }

    public void addProperty(String key, Object value) {
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        ((Hashtable)this.attributes).put(key, value.toString());
    }

    public void addProperty(String key, int value) {
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        ((Hashtable)this.attributes).put(key, Integer.toString(value));
    }

    public void addProperty(String key, double value) {
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        ((Hashtable)this.attributes).put(key, Double.toString(value));
    }

    public int countChildren() {
        return this.children.size();
    }

    public Enumeration enumeratePropertyNames() {
        return ((Hashtable)this.attributes).keys();
    }

    public Enumeration enumerateChildren() {
        return this.children.elements();
    }

    public void parseFromReader(Reader reader) throws IOException, XMLParseException {
        this.parseFromReader(reader, 1);
    }

    public void parseFromReader(Reader reader, int startingLineNr) throws IOException, XMLParseException {
        int blockSize = 4096;
        char[] input = null;
        int size = 0;
        while (true) {
            if (input == null) {
                input = new char[blockSize];
            } else {
                char[] oldInput = input;
                input = new char[input.length + blockSize];
                System.arraycopy(oldInput, 0, input, 0, oldInput.length);
            }
            int charsRead = reader.read(input, size, blockSize);
            if (charsRead < 0) break;
            size += charsRead;
        }
        this.parseCharArray(input, 0, size, startingLineNr);
    }

    public void parseString(String string) throws XMLParseException {
        this.parseCharArray(string.toCharArray(), 0, string.length(), 1);
    }

    public int parseString(String string, int offset) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), offset, string.length(), 1);
    }

    public int parseString(String string, int offset, int end) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), offset, end, 1);
    }

    public int parseString(String string, int offset, int end, int startingLineNr) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), offset, end, startingLineNr);
    }

    public int parseCharArray(char[] input, int offset, int end) throws XMLParseException {
        return this.parseCharArray(input, offset, end, 1);
    }

    public int parseCharArray(char[] input, int offset, int end, int startingLineNr) throws XMLParseException {
        int[] lineNr = new int[]{startingLineNr};
        return this.parseCharArray(input, offset, end, lineNr);
    }

    public void removeChild(XMLElement child) {
        this.children.removeElement(child);
    }

    public void removeChild(String key) {
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        ((Hashtable)this.attributes).remove(key);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.write(writer);
        return writer.toString();
    }

    public void write(Writer writer) {
        this.write(writer, 0);
    }

    public void write(Writer writer, int indent) {
        PrintWriter out = new PrintWriter(writer);
        int i = 0;
        while (i < indent) {
            out.print(' ');
            ++i;
        }
        if (this.tagName == null) {
            this.writeEncoded(out, this.contents);
            return;
        }
        out.print('<');
        out.print(this.tagName);
        if (!((Hashtable)this.attributes).isEmpty()) {
            Enumeration enumeration = ((Hashtable)this.attributes).keys();
            while (enumeration.hasMoreElements()) {
                out.print(' ');
                String key = (String)enumeration.nextElement();
                String value = (String)((Hashtable)this.attributes).get(key);
                out.print(key);
                out.print("=\"");
                this.writeEncoded(out, value);
                out.print('\"');
            }
        }
        if (this.contents != null && this.contents.length() > 0) {
            if (this.skipLeadingWhitespace) {
                out.println('>');
                i = 0;
                while (i < indent + 4) {
                    out.print(' ');
                    ++i;
                }
                out.println(this.contents);
                i = 0;
                while (i < indent) {
                    out.print(' ');
                    ++i;
                }
            } else {
                out.print('>');
                this.writeEncoded(out, this.contents);
            }
            out.print("</");
            out.print(this.tagName);
            out.println('>');
        } else if (this.children.isEmpty()) {
            out.println("/>");
        } else {
            out.println('>');
            Enumeration enumeration = this.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                XMLElement child = (XMLElement)enumeration.nextElement();
                child.write(writer, indent + 4);
            }
            int i2 = 0;
            while (i2 < indent) {
                out.print(' ');
                ++i2;
            }
            out.print("</");
            out.print(this.tagName);
            out.println('>');
        }
    }

    protected void scanChildren(char[] input, int contentOffset, int contentSize, int contentLineNr) throws XMLParseException {
        int end = contentOffset + contentSize;
        int offset = contentOffset;
        int[] lineNr = new int[]{contentLineNr};
        while (offset < end) {
            try {
                offset = this.skipWhitespace(input, offset, end, lineNr);
            }
            catch (XMLParseException e) {
                return;
            }
            if (input[offset] != '<' || input[offset + 1] == '!' && input[offset + 2] == '[') {
                return;
            }
            XMLElement child = this.createAnotherElement();
            offset = child.parseCharArray(input, offset, end, lineNr);
            this.children.addElement(child);
        }
    }

    protected XMLElement createAnotherElement() {
        return new XMLElement(this.conversionTable, this.skipLeadingWhitespace, false, this.ignoreCase);
    }

    protected int skipBogusTag(char[] input, int offset, int end, int[] lineNr) {
        int level = 1;
        block6: while (offset < end) {
            char ch = input[offset++];
            switch (ch) {
                case '\r': {
                    if (offset < end && input[offset] == '\n') {
                        ++offset;
                    }
                    lineNr[0] = lineNr[0] + 1;
                    break;
                }
                case '\n': {
                    lineNr[0] = lineNr[0] + 1;
                    break;
                }
                case '<': {
                    ++level;
                    break;
                }
                case '>': {
                    if (--level != 0) continue block6;
                    return offset;
                }
            }
        }
        throw this.unexpectedEndOfData(lineNr[0]);
    }

    protected String decodeString(String s, int lineNr) {
        StringBuffer result = new StringBuffer(s.length());
        int index = 0;
        while (index < s.length()) {
            int index3;
            int index2 = (s + "&").indexOf(38, index);
            if (index2 <= (index3 = (s + "<![CDATA[").indexOf("<![CDATA[", index))) {
                result.append(s.substring(index, index2));
                if (index2 == s.length()) break;
                index = s.indexOf(59, index2);
                if (index < 0) {
                    result.append(s.substring(index2));
                    break;
                }
                String key = s.substring(index2 + 1, index);
                if (key.charAt(0) == '#') {
                    if (key.charAt(1) == 'x') {
                        result.append((char)Integer.parseInt(key.substring(2), 16));
                    } else {
                        result.append((char)Integer.parseInt(key.substring(1), 10));
                    }
                } else {
                    result.append(this.conversionTable.getProperty(key, "&" + key + ";"));
                }
            } else {
                int index4 = (s + "]]>").indexOf("]]>", index3 + 9);
                result.append(s.substring(index, index3));
                result.append(s.substring(index3 + 9, index4));
                index = index4 + 2;
            }
            ++index;
        }
        return result.toString();
    }

    protected void writeEncoded(PrintWriter out, String str) {
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    out.write("&lt;");
                    break;
                }
                case '>': {
                    out.write("&gt;");
                    break;
                }
                case '&': {
                    out.write("&amp;");
                    break;
                }
                case '\"': {
                    out.write("&quot;");
                    break;
                }
                case '\'': {
                    out.write("&apos;");
                    break;
                }
                case '\n': 
                case '\r': {
                    out.write(ch);
                    break;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        out.write("&#x");
                        out.write(Integer.toString(ch, 16));
                        out.write(59);
                        break;
                    }
                    out.write(ch);
                }
            }
            ++i;
        }
    }

    private final boolean isIdentifierChar(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ".-_:".indexOf(ch) >= 0;
    }

    private final int parseCharArray(char[] input, int offset, int end, int[] currentLineNr) throws XMLParseException {
        this.lineNr = currentLineNr[0];
        this.tagName = null;
        this.contents = null;
        this.attributes = new Properties();
        this.children = new Vector();
        try {
            offset = this.skipWhitespace(input, offset, end, currentLineNr);
        }
        catch (XMLParseException e) {
            return offset;
        }
        offset = this.skipPreamble(input, offset, end, currentLineNr);
        offset = this.scanTagName(input, offset, end, currentLineNr);
        this.lineNr = currentLineNr[0];
        offset = this.scanAttributes(input, offset, end, currentLineNr);
        int[] contentOffset = new int[1];
        int[] contentSize = new int[1];
        int contentLineNr = currentLineNr[0];
        offset = this.scanContent(input, offset, end, contentOffset, contentSize, currentLineNr);
        if (contentSize[0] > 0) {
            this.scanChildren(input, contentOffset[0], contentSize[0], contentLineNr);
            if (this.children.size() > 0) {
                this.contents = null;
            } else {
                this.processContents(input, contentOffset[0], contentSize[0], contentLineNr);
                int i = 0;
                while (i < contentSize[0]) {
                    if (input[contentOffset[0] + i] > ' ') {
                        return offset;
                    }
                    ++i;
                }
                this.contents = null;
            }
        }
        return offset;
    }

    private final void processContents(char[] input, int contentOffset, int contentSize, int contentLineNr) throws XMLParseException {
        int[] lineNr = new int[]{contentLineNr};
        if (!this.skipLeadingWhitespace) {
            String str = new String(input, contentOffset, contentSize);
            this.contents = this.decodeString(str, lineNr[0]);
            return;
        }
        StringBuffer result = new StringBuffer(contentSize);
        int end = contentSize + contentOffset;
        int i = contentOffset;
        while (i < end) {
            char ch = input[i];
            while (ch == '\r' || ch == '\n') {
                lineNr[0] = lineNr[0] + 1;
                result.append(ch);
                ch = input[++i];
                if (ch != '\n') {
                    result.append(ch);
                }
                while ((ch = input[++i]) == ' ' || ch == '\t') {
                }
            }
            if (i < end) {
                result.append(ch);
            }
            ++i;
        }
        this.contents = this.decodeString(result.toString(), lineNr[0]);
    }

    private final int scanAttributes(char[] input, int offset, int end, int[] lineNr) throws XMLParseException {
        char ch;
        while ((ch = input[offset = this.skipWhitespace(input, offset, end, lineNr)]) != '/' && ch != '>') {
            offset = this.scanOneAttribute(input, offset, end, lineNr);
        }
        return offset;
    }

    private final int scanContent(char[] input, int offset, int end, int[] contentOffset, int[] contentSize, int[] lineNr) throws XMLParseException {
        if (input[offset] == '/') {
            contentSize[0] = 0;
            if (input[offset + 1] != '>') {
                throw this.expectedInput("'>'", lineNr[0]);
            }
            return offset + 2;
        }
        if (input[offset] != '>') {
            throw this.expectedInput("'>'", lineNr[0]);
        }
        offset = this.skipLeadingWhitespace ? this.skipWhitespace(input, offset + 1, end, lineNr) : ++offset;
        int begin = offset;
        contentOffset[0] = offset;
        int level = 0;
        char[] tag = this.tagName.toCharArray();
        end -= tag.length + 2;
        while (offset < end && level >= 0) {
            if (input[offset] == '<') {
                boolean ok = true;
                if (offset < end - 1 && input[offset + 1] == '!' && input[offset + 2] == '[') {
                    ++offset;
                    continue;
                }
                int i = 0;
                while (ok && i < tag.length) {
                    ok &= input[offset + (i + 1)] == tag[i];
                    ++i;
                }
                if (ok &= !this.isIdentifierChar(input[offset + tag.length + 1])) {
                    while (offset < end && input[offset] != '>') {
                        ++offset;
                    }
                    if (input[offset - 1] == '/') continue;
                    ++level;
                    continue;
                }
                if (input[offset + 1] == '/') {
                    ok = true;
                    i = 0;
                    while (ok && i < tag.length) {
                        ok &= input[offset + (i + 2)] == tag[i];
                        ++i;
                    }
                    if (ok) {
                        contentSize[0] = offset - contentOffset[0];
                        offset += tag.length + 2;
                        try {
                            offset = this.skipWhitespace(input, offset, end + tag.length + 2, lineNr);
                        }
                        catch (XMLParseException e) {
                            // empty catch block
                        }
                        if (input[offset] != '>') continue;
                        --level;
                        ++offset;
                        continue;
                    }
                }
            }
            if (input[offset] == '\r') {
                lineNr[0] = lineNr[0] + 1;
                if (offset != end && input[offset + 1] == '\n') {
                    ++offset;
                }
            } else if (input[offset] == '\n') {
                lineNr[0] = lineNr[0] + 1;
            }
            ++offset;
        }
        if (level >= 0) {
            throw this.unexpectedEndOfData(lineNr[0]);
        }
        if (this.skipLeadingWhitespace) {
            int i = contentOffset[0] + contentSize[0] - 1;
            while (contentSize[0] >= 0 && input[i] <= ' ') {
                --i;
                contentSize[0] = contentSize[0] - 1;
            }
        }
        return offset;
    }

    private final String scanIdentifier(char[] input, int offset, int end) {
        int begin = offset;
        while (offset < end && this.isIdentifierChar(input[offset])) {
            ++offset;
        }
        if (offset == end || offset == begin) {
            return null;
        }
        return new String(input, begin, offset - begin);
    }

    private final int scanOneAttribute(char[] input, int offset, int end, int[] lineNr) throws XMLParseException {
        String key = this.scanIdentifier(input, offset, end);
        if (key == null) {
            throw this.syntaxError("an attribute key", lineNr[0]);
        }
        offset = this.skipWhitespace(input, offset + key.length(), end, lineNr);
        if (this.ignoreCase) {
            key = key.toUpperCase();
        }
        if (input[offset] != '=') {
            throw this.valueMissingForAttribute(key, lineNr[0]);
        }
        String value = this.scanString(input, offset = this.skipWhitespace(input, offset + 1, end, lineNr), end, lineNr);
        if (value == null) {
            throw this.syntaxError("an attribute value", lineNr[0]);
        }
        if (value.charAt(0) == '\"' || value.charAt(0) == '\'') {
            value = value.substring(1, value.length() - 1);
            offset += 2;
        }
        ((Hashtable)this.attributes).put(key, this.decodeString(value, lineNr[0]));
        return offset + value.length();
    }

    private final String scanString(char[] input, int offset, int end, int[] lineNr) throws XMLParseException {
        char delim = input[offset];
        if (delim == '\"' || delim == '\'') {
            int begin = offset++;
            while (offset < end && input[offset] != delim) {
                if (input[offset] == '\r') {
                    lineNr[0] = lineNr[0] + 1;
                    if (offset != end && input[offset + 1] == '\n') {
                        ++offset;
                    }
                } else if (input[offset] == '\n') {
                    lineNr[0] = lineNr[0] + 1;
                }
                ++offset;
            }
            if (offset == end) {
                return null;
            }
            return new String(input, begin, offset - begin + 1);
        }
        return this.scanIdentifier(input, offset, end);
    }

    private final int scanTagName(char[] input, int offset, int end, int[] lineNr) throws XMLParseException {
        this.tagName = this.scanIdentifier(input, offset, end);
        if (this.tagName == null) {
            throw this.syntaxError("a tag name", lineNr[0]);
        }
        return offset + this.tagName.length();
    }

    private final int skipPreamble(char[] input, int offset, int end, int[] lineNr) throws XMLParseException {
        char ch;
        do {
            if (input[offset = this.skipWhitespace(input, offset, end, lineNr)] != '<') {
                this.expectedInput("'<'", lineNr[0]);
            }
            if (++offset >= end) {
                throw this.unexpectedEndOfData(lineNr[0]);
            }
            ch = input[offset];
            if (ch != '!' && ch != '?') continue;
            offset = this.skipBogusTag(input, offset, end, lineNr);
        } while (!this.isIdentifierChar(ch));
        return offset;
    }

    private final int skipWhitespace(char[] input, int offset, int end, int[] lineNr) {
        int startLine = lineNr[0];
        while (offset < end) {
            if (offset + 6 < end && input[offset + 3] == '-' && input[offset + 2] == '-' && input[offset + 1] == '!' && input[offset] == '<') {
                offset += 4;
                while (input[offset] != '-' || input[offset + 1] != '-' || input[offset + 2] != '>') {
                    if (offset + 2 >= end) {
                        throw this.unexpectedEndOfData(startLine);
                    }
                    ++offset;
                }
                offset += 3;
            } else if (input[offset] == '\r') {
                lineNr[0] = lineNr[0] + 1;
                if (offset != end && input[offset + 1] == '\n') {
                    ++offset;
                }
            } else if (input[offset] == '\n') {
                lineNr[0] = lineNr[0] + 1;
            } else if (input[offset] > ' ') break;
            ++offset;
        }
        if (offset == end) {
            throw this.unexpectedEndOfData(startLine);
        }
        return offset;
    }

    private final XMLParseException invalidValueSet(String key) {
        String msg = "Invalid value set (key = \"" + key + "\")";
        return new XMLParseException(this.getTagName(), msg);
    }

    private final XMLParseException invalidValue(String key, String value, int lineNr) {
        String msg = "Attribute \"" + key + "\" does not contain a valid " + "value (\"" + value + "\")";
        return new XMLParseException(this.getTagName(), lineNr, msg);
    }

    private final XMLParseException unexpectedEndOfData(int lineNr) {
        String msg = "Unexpected end of data reached";
        return new XMLParseException(this.getTagName(), lineNr, msg);
    }

    private final XMLParseException syntaxError(String context, int lineNr) {
        String msg = "Syntax error while parsing " + context;
        return new XMLParseException(this.getTagName(), lineNr, msg);
    }

    private final XMLParseException expectedInput(String charSet, int lineNr) {
        String msg = "Expected: " + charSet;
        return new XMLParseException(this.getTagName(), lineNr, msg);
    }

    private final XMLParseException valueMissingForAttribute(String key, int lineNr) {
        String msg = "Value missing for attribute with key \"" + key + "\"";
        return new XMLParseException(this.getTagName(), lineNr, msg);
    }

    public XMLElement() {
        this(new Properties(), false, true, true);
    }

    public XMLElement(Properties conversionTable) {
        this(conversionTable, false, true, true);
    }

    public XMLElement(boolean skipLeadingWhitespace) {
        this(new Properties(), skipLeadingWhitespace, true, true);
    }

    public XMLElement(Properties conversionTable, boolean skipLeadingWhitespace) {
        this(conversionTable, skipLeadingWhitespace, true, true);
    }

    public XMLElement(Properties conversionTable, boolean skipLeadingWhitespace, boolean ignoreCase) {
        this(conversionTable, skipLeadingWhitespace, true, ignoreCase);
    }

    protected XMLElement(Properties conversionTable, boolean skipLeadingWhitespace, boolean fillBasicConversionTable, boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.skipLeadingWhitespace = skipLeadingWhitespace;
        this.tagName = null;
        this.contents = "";
        this.attributes = new Properties();
        this.children = new Vector();
        this.conversionTable = conversionTable;
        this.lineNr = 0;
        if (fillBasicConversionTable) {
            ((Hashtable)this.conversionTable).put("lt", "<");
            ((Hashtable)this.conversionTable).put("gt", ">");
            ((Hashtable)this.conversionTable).put("quot", "\"");
            ((Hashtable)this.conversionTable).put("apos", "'");
            ((Hashtable)this.conversionTable).put("amp", "&");
        }
    }
}

