/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.floating.policy;

import java.util.Map;
import java.util.Vector;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.drag.DragManager;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.event.DockingListener;
import org.flexdock.docking.floating.policy.DefaultFloatPolicy;
import org.flexdock.docking.floating.policy.FloatPolicy;

public class FloatPolicyManager
extends DockingListener.Stub {
    private static final FloatPolicyManager SINGLETON = new FloatPolicyManager();
    public static final String FLOATING_ALLOWED = "FloatPolicyManager.FLOATING_ALLOWED";
    public static final String GLOBAL_FLOATING_ENABLED = "global.floating.enabled";
    private Vector policies = new Vector();
    private boolean globalFloatingEnabled;

    public static FloatPolicyManager getInstance() {
        return SINGLETON;
    }

    private FloatPolicyManager() {
        this.addPolicy(DefaultFloatPolicy.getInstance());
        this.globalFloatingEnabled = Boolean.getBoolean(GLOBAL_FLOATING_ENABLED);
    }

    public void dragStarted(DockingEvent evt) {
        Map context = evt.getDragContext();
        Dockable d = evt.getDockable();
        Boolean allowed = this.isPolicyFloatingSupported(d) ? Boolean.TRUE : Boolean.FALSE;
        context.put(FLOATING_ALLOWED, allowed);
    }

    public void dropStarted(DockingEvent evt) {
        if (evt.isOverWindow()) {
            return;
        }
        if (!FloatPolicyManager.isFloatingAllowed(evt.getDockable())) {
            evt.consume();
            return;
        }
        for (FloatPolicy policy : this.policies) {
            if (policy.isFloatDropAllowed(evt)) continue;
            evt.consume();
            return;
        }
    }

    public static boolean isFloatingAllowed(Dockable dockable) {
        if (dockable == null) {
            return false;
        }
        Map context = DragManager.getDragContext(dockable);
        if (context == null) {
            return FloatPolicyManager.getInstance().isPolicyFloatingSupported(dockable);
        }
        Boolean floatAllowed = (Boolean)context.get(FLOATING_ALLOWED);
        return floatAllowed == null ? true : floatAllowed;
    }

    public boolean isPolicyFloatingSupported(Dockable dockable) {
        if (dockable == null) {
            return false;
        }
        for (FloatPolicy policy : this.policies) {
            if (policy.isFloatingAllowed(dockable)) continue;
            return false;
        }
        return true;
    }

    public void addPolicy(FloatPolicy policy) {
        if (policy != null) {
            this.policies.add(policy);
        }
    }

    public void removePolicy(FloatPolicy policy) {
        if (policy != null) {
            this.policies.remove(policy);
        }
    }

    public static boolean isGlobalFloatingEnabled() {
        return FloatPolicyManager.getInstance().globalFloatingEnabled;
    }

    public static void setGlobalFloatingEnabled(boolean globalFloatingEnabled) {
        FloatPolicyManager.getInstance().globalFloatingEnabled = globalFloatingEnabled;
    }
}

