/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.external_objects_java;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.external_objects_java.ScilabClassLoader;
import org.scilab.modules.external_objects_java.ScilabJavaException;
import org.scilab.modules.external_objects_java.ScilabJavaObject;

public class ScilabJavaCompiler {
    private static final String JAVACOMPILER = "javax.tools.JavaCompiler";
    private static final String BINPATH = System.getProperty("java.io.tmpdir") + File.separator + "JIMS" + File.separator + "bin";
    private static JavaCompiler compiler;
    private static boolean ecjLoaded;
    private static boolean isECJ;

    private static void findCompiler() throws ScilabJavaException {
        if (compiler == null) {
            try {
                compiler = ToolProvider.getSystemJavaCompiler();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (compiler == null) {
                ServiceLoader<JavaCompiler> serviceLoader = ServiceLoader.load(JavaCompiler.class);
                for (JavaCompiler javaCompiler : serviceLoader) {
                    if (javaCompiler == null) continue;
                    compiler = javaCompiler;
                    break;
                }
            }
            if (compiler == null) {
                if (ecjLoaded) {
                    throw new ScilabJavaException("No java compiler in the classpath\nCheck for tools.jar (comes from JDK) or ecj.jar (Eclipse Compiler for Java)");
                }
                ScilabCommonsUtils.loadOnUse((String)"external_objects_java");
                ecjLoaded = true;
                ScilabJavaCompiler.findCompiler();
            }
            isECJ = compiler.getClass().getSimpleName().indexOf("Eclipse") != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compileCode(String string, String[] stringArray) throws ScilabJavaException {
        Object object;
        if (SwingUtilities.isEventDispatchThread()) {
            ScilabJavaCompiler.findCompiler();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ScilabJavaCompiler.findCompiler();
                        }
                        catch (ScilabJavaException scilabJavaException) {
                            scilabJavaException.printStackTrace();
                        }
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector<JavaFileObject>();
        StandardJavaFileManager standardJavaFileManager = compiler.getStandardFileManager(null, Locale.getDefault(), null);
        try {
            standardJavaFileManager.setLocation(StandardLocation.CLASS_PATH, ScilabJavaCompiler.getClasspathFiles());
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
        }
        ClassFileManager classFileManager = new ClassFileManager(standardJavaFileManager);
        ArrayList<SimpleJavaFileObject> arrayList = new ArrayList<SimpleJavaFileObject>();
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(charArrayWriter);
        boolean bl = true;
        SourceString sourceString = null;
        for (String string2 : stringArray) {
            object = new File(string2);
            if (((File)object).exists() && ((File)object).canRead()) continue;
            bl = false;
            break;
        }
        if (bl) {
            for (String string2 : stringArray) {
                object = new File(string2);
                arrayList.add(new SourceFile((File)object));
            }
        } else {
            sourceString = new SourceString(string, stringArray);
            arrayList.add(sourceString);
        }
        String[] stringArray2 = new String[]{"-d", BINPATH, "-target", "17"};
        List<String> list = Arrays.asList(stringArray2);
        try {
            standardJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(new File(BINPATH)));
        }
        catch (IOException iOException) {
            Logger.getLogger(ScilabJavaCompiler.class.getName()).log(Level.SEVERE, null, iOException);
        }
        JavaCompiler.CompilationTask compilationTask = null;
        try {
            compilationTask = compiler.getTask(bufferedWriter, classFileManager, diagnosticCollector, list, null, arrayList);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getLocalizedMessage());
        }
        boolean bl2 = compilationTask.call();
        object = "";
        try {
            bufferedWriter.flush();
            object = charArrayWriter.toString();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
        }
        if (bl2) {
            if (bl) {
                return -1;
            }
            if (classFileManager.className != null && !classFileManager.className.isEmpty()) {
                return ScilabClassLoader.loadJavaClass(BINPATH, classFileManager.className);
            }
            return -1;
        }
        if (!isECJ) {
            object = ScilabJavaCompiler.getCompilerErrors(diagnosticCollector);
        }
        throw new ScilabJavaException((String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCompilerErrors(DiagnosticCollector<JavaFileObject> diagnosticCollector) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        stringBuffer.append("----------\n");
        for (Diagnostic<JavaFileObject> diagnostic : diagnosticCollector.getDiagnostics()) {
            stringBuffer.append(Integer.toString(n++)).append(". ").append((Object)diagnostic.getKind());
            if (diagnostic.getSource() != null) {
                stringBuffer.append(" in ").append(diagnostic.getSource().toUri().getPath()).append(" (at line ").append(Long.toString(diagnostic.getLineNumber())).append(")\n");
                Reader reader = null;
                try {
                    reader = diagnostic.getSource().openReader(true);
                    reader.skip(diagnostic.getStartPosition());
                    char[] cArray = new char[(int)(diagnostic.getEndPosition() - diagnostic.getStartPosition() + 1L)];
                    reader.read(cArray);
                    stringBuffer.append("        ").append(cArray).append('\n');
                    Arrays.fill(cArray, '^');
                    stringBuffer.append("        ").append(cArray).append('\n');
                }
                catch (IOException iOException) {
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                stringBuffer.append('\n');
            }
            stringBuffer.append(diagnostic.getMessage(Locale.getDefault())).append('\n');
        }
        stringBuffer.append("----------\n");
        return stringBuffer.toString();
    }

    public static String getClasspath() {
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] uRLArray = uRLClassLoader.getURLs();
        StringBuffer stringBuffer = new StringBuffer();
        for (URL uRL : uRLArray) {
            stringBuffer.append(uRL.getPath()).append(File.pathSeparatorChar);
        }
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    public static List<File> getClasspathFiles() {
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] uRLArray = uRLClassLoader.getURLs();
        ArrayList<File> arrayList = new ArrayList<File>(uRLArray.length);
        for (URL uRL : uRLArray) {
            try {
                arrayList.add(new File(uRL.toURI()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static void addURLToClassPath(URL uRL) {
        org.scilab.modules.jvm.ScilabClassLoader scilabClassLoader = (org.scilab.modules.jvm.ScilabClassLoader)ClassLoader.getSystemClassLoader();
        scilabClassLoader.addURL(uRL);
    }

    static {
        ecjLoaded = false;
        new File(System.getProperty("java.io.tmpdir") + File.separator + "JIMS").mkdir();
        new File(BINPATH).mkdir();
        try {
            URL uRL = new File(BINPATH).toURI().toURL();
            ScilabJavaCompiler.addURLToClassPath(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException);
        }
    }

    private static class ClassFileManager
    extends ForwardingJavaFileManager {
        String className;

        public ClassFileManager(StandardJavaFileManager standardJavaFileManager) {
            super(standardJavaFileManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
            if (fileObject instanceof SourceString && string != null && string.indexOf(36) == -1) {
                this.className = string.replace('/', '.');
            }
            if (ScilabJavaObject.debug) {
                ScilabJavaObject.logger.log(Level.INFO, "Compilation of class '" + string + "'");
            }
            return super.getJavaFileForOutput(location, string, kind, fileObject);
        }
    }

    private static class SourceFile
    extends SimpleJavaFileObject {
        final File f;

        private SourceFile(File file) {
            super(file.toURI(), JavaFileObject.Kind.SOURCE);
            this.f = file;
        }

        @Override
        public CharSequence getCharContent(boolean bl) {
            StringBuffer stringBuffer;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.f), "UTF-8");
            try {
                int n;
                char[] cArray = new char[1024];
                StringBuffer stringBuffer2 = new StringBuffer();
                while ((n = ((Reader)inputStreamReader).read(cArray, 0, 1024)) != -1) {
                    stringBuffer2.append(cArray, 0, n);
                }
                stringBuffer = stringBuffer2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)inputStreamReader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            ((Reader)inputStreamReader).close();
            return stringBuffer;
        }
    }

    private static class SourceString
    extends SimpleJavaFileObject {
        private final String code;
        private File fakeFile;

        private SourceString(String string, String[] stringArray) {
            super(new File(BINPATH + "/" + string.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension).toURI(), JavaFileObject.Kind.SOURCE);
            try {
                this.fakeFile = new File(BINPATH + "/" + string.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension);
                this.fakeFile.createNewFile();
            }
            catch (IOException iOException) {
                System.err.println(iOException.getLocalizedMessage());
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (String string2 : stringArray) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            this.code = stringBuffer.toString();
        }

        @Override
        public CharSequence getCharContent(boolean bl) {
            if (this.fakeFile != null) {
                this.fakeFile.delete();
            }
            return this.code;
        }
    }
}

