/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.external_objects_java;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.scilab.modules.external_objects_java.ScilabJavaClass;
import org.scilab.modules.external_objects_java.ScilabJavaException;
import org.scilab.modules.external_objects_java.ScilabJavaObject;

public class ScilabClassLoader {
    protected static Map<String, Integer> clazz = new HashMap<String, Integer>();
    protected static Map<Integer, String> zzalc = new HashMap<Integer, String>();

    private ScilabClassLoader() {
    }

    public static int loadJavaClass(String string) throws ScilabJavaException {
        return ScilabClassLoader.loadJavaClass(string, true);
    }

    public static int loadJavaClass(String string, boolean bl) throws ScilabJavaException {
        Integer n = clazz.get(string);
        int n2 = -1;
        if (ScilabJavaObject.debug) {
            ScilabJavaObject.logger.log(Level.INFO, "Load Java class '" + string + "' and reload=" + bl);
        }
        try {
            if (n != null) {
                if (bl) {
                    ScilabJavaClass scilabJavaClass = (ScilabJavaClass)ScilabJavaObject.arraySJO[n];
                    URL uRL = scilabJavaClass.getURL();
                    if (uRL == null) {
                        System.err.println("Warning: The class " + string + " could not be reloaded");
                        ScilabJavaObject scilabJavaObject = ScilabJavaObject.arraySJO[n].clone();
                        n2 = scilabJavaObject.id;
                    } else {
                        Class<?> clazz = new URLClassLoader(new URL[]{uRL}, null).loadClass(string);
                        ScilabJavaObject.removeScilabJavaObject(n);
                        scilabJavaClass = new ScilabJavaClass(clazz);
                        scilabJavaClass.setURL(uRL);
                        ScilabClassLoader.clazz.put(string, scilabJavaClass.id);
                        zzalc.put(scilabJavaClass.id, string);
                        n2 = scilabJavaClass.id;
                    }
                } else {
                    ScilabJavaObject scilabJavaObject = ScilabJavaObject.arraySJO[n].clone();
                    n2 = scilabJavaObject.id;
                }
            } else {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
                ScilabJavaClass scilabJavaClass = new ScilabJavaClass(clazz);
                scilabJavaClass.setURL(ScilabClassLoader.getLocation(scilabJavaClass.clazz));
                ScilabClassLoader.clazz.put(string, scilabJavaClass.id);
                zzalc.put(scilabJavaClass.id, string);
                n2 = scilabJavaClass.id;
            }
        }
        catch (Exception exception) {
            throw new ScilabJavaException("Cannot find the class " + string + ". Check the name or if the classpath contains it.");
        }
        if (ScilabJavaObject.debug) {
            ScilabJavaObject.logger.log(Level.INFO, "The loaded Java class has id=" + n2 + " and URL=" + String.valueOf(((ScilabJavaClass)ScilabJavaObject.arraySJO[n2]).getURL()));
        }
        return n2;
    }

    public static int loadJavaClass(String string, String string2) throws ScilabJavaException {
        if (ScilabJavaObject.debug) {
            ScilabJavaObject.logger.log(Level.INFO, "Load Java class '" + string2 + "' in " + string);
        }
        try {
            URL uRL = new File(string).toURI().toURL();
            Class<?> clazz = new URLClassLoader(new URL[]{uRL}, null).loadClass(string2);
            ScilabJavaClass scilabJavaClass = new ScilabJavaClass(clazz);
            scilabJavaClass.setURL(ScilabClassLoader.getLocation(scilabJavaClass.clazz));
            ScilabClassLoader.clazz.put(string2, scilabJavaClass.id);
            zzalc.put(scilabJavaClass.id, string2);
            if (ScilabJavaObject.debug) {
                ScilabJavaObject.logger.log(Level.INFO, "The loaded Java class has id=" + scilabJavaClass.id + " and URL=" + String.valueOf(scilabJavaClass.getURL()));
            }
            return scilabJavaClass.id;
        }
        catch (Exception exception) {
            throw new ScilabJavaException("Cannot find the class " + string2 + " in " + string + ".");
        }
    }

    protected static void removeID(int n) {
        String string = zzalc.get(n);
        if (string != null) {
            clazz.remove(string);
            zzalc.remove(n);
        }
    }

    private static final URL getLocation(Class clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        return codeSource.getLocation();
    }
}

