/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.scilab.modules.preferences.Component.Panel;
import org.scilab.modules.preferences.Component.XAdapterNode;
import org.scilab.modules.preferences.Component.XTreeModel;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XComponent;
import org.w3c.dom.Node;

public class Tree
extends Panel
implements XComponent,
XChooser,
TreeSelectionListener {
    private static final long serialVersionUID = -6127289363733321914L;
    private ActionListener actionListener = null;
    private XTreeModel model;
    private JTree tree;
    private boolean dontChange = false;

    public Tree(Node node) {
        super(node);
        this.model = new XTreeModel(node);
        this.tree = new JTree();
        this.tree.setModel(this.model);
        this.tree.getSelectionModel().addTreeSelectionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setExpandsSelectedPaths(true);
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.tree.getCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add(jScrollPane);
    }

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{"item"};
        return stringArray;
    }

    @Override
    public final void refresh(Node node) {
        this.model.setRoot(node);
        String string = XCommonManager.getAttribute(XCommonManager.getElementByContext("/"), "path", "/1");
        if (!string.equals(this.path())) {
            this.path(string);
        }
    }

    @Override
    public final Object choose() {
        return this.path();
    }

    @Override
    public final void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.actionListener != null && !this.dontChange) {
            ActionEvent actionEvent = new ActionEvent(this, 0, "actionPerformed", treeSelectionEvent.hashCode(), 0);
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public final String path() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            StringBuilder stringBuilder = new StringBuilder();
            Object[] objectArray = treePath.getPath();
            XAdapterNode xAdapterNode = (XAdapterNode)objectArray[0];
            for (int i = 1; i < objectArray.length; ++i) {
                XAdapterNode xAdapterNode2 = (XAdapterNode)objectArray[i];
                int n = xAdapterNode.getIndexOfChild(xAdapterNode2) + 1;
                if (i == 1) {
                    stringBuilder.append(Integer.toString(n));
                } else {
                    stringBuilder.append(Integer.toString(n + 1));
                }
                stringBuilder.append("/");
                xAdapterNode = xAdapterNode2;
            }
            return stringBuilder.toString();
        }
        return "-1";
    }

    public final void path(String string) {
        String[] stringArray = string.split("/");
        int n = 0;
        XAdapterNode xAdapterNode = (XAdapterNode)this.tree.getModel().getRoot();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                xAdapterNode = xAdapterNode.getChild(n += Integer.parseInt(stringArray[i]) - 1);
                if (xAdapterNode == null) {
                    this.tree.setSelectionRow(0);
                    break;
                }
                if (i < stringArray.length - 1) {
                    this.tree.expandRow(n);
                    continue;
                }
                this.dontChange = true;
                this.tree.setSelectionRow(n);
                this.dontChange = false;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.dontChange = true;
                this.tree.setSelectionRow(0);
                this.dontChange = false;
                break;
            }
        }
    }

    @Override
    public final String toString() {
        return "Tree ...";
    }
}

