/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import org.scilab.modules.preferences.Component.Panel;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

public class Grid
extends Panel
implements XComponent {
    private static final long serialVersionUID = 3462302313959678932L;
    private static final HashMap<String, Integer> ANCHORS = new HashMap();

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public Grid(Node node) {
        super(node);
        this.setLayout(new GridBagLayout());
    }

    void setConstraints(GridBagConstraints gridBagConstraints, Object object) {
        String string;
        Node node = (Node)object;
        gridBagConstraints.gridx = XCommonManager.getInt(node, "gridx", 1) - 1;
        gridBagConstraints.gridy = XCommonManager.getInt(node, "gridy", 1) - 1;
        gridBagConstraints.gridwidth = XCommonManager.getInt(node, "gridwidth", 1);
        gridBagConstraints.gridheight = XCommonManager.getInt(node, "gridheight", 1);
        gridBagConstraints.weightx = XCommonManager.getDouble(node, "weightx", 1.0);
        gridBagConstraints.weighty = XCommonManager.getDouble(node, "weighty", 1.0);
        gridBagConstraints.ipadx = XCommonManager.getInt(node, "ipadx", 0);
        gridBagConstraints.ipady = XCommonManager.getInt(node, "ipady", 0);
        Integer n = ANCHORS.get(XConfigManager.getAttribute(node, "anchor").toLowerCase());
        if (n != null) {
            gridBagConstraints.anchor = n;
        }
        if ((string = XConfigManager.getAttribute(node, "insets")).equals("large")) {
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        } else if (string.equals("huge")) {
            gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        }
        String string2 = XConfigManager.getAttribute(node, "fill");
        if (string2.equals("none")) {
            gridBagConstraints.fill = 0;
        } else if (string2.equals("horizontal")) {
            gridBagConstraints.fill = 2;
        } else if (string2.equals("vertical")) {
            gridBagConstraints.fill = 3;
        } else if (string2.equals("both")) {
            gridBagConstraints.fill = 1;
        }
    }

    @Override
    public void add(Component component, Object object, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.setConstraints(gridBagConstraints, object);
        super.add(component, gridBagConstraints);
    }

    @Override
    public void add(Component component, Object object) {
        int n = this.getComponentCount();
        this.add(component, object, n);
    }

    @Override
    public void remove(Component component) {
        this.getLayout().removeLayoutComponent(component);
        super.remove(component);
        this.revalidate();
        System.err.println("- - - - - REMOVE NOT IMPLEMENTABLE IN GRIDS!\n" + String.valueOf(component));
    }

    @Override
    public void refresh(Node node) {
        this.revalidate();
    }

    @Override
    public final String toString() {
        String string = "VBox";
        return string;
    }

    static {
        ANCHORS.put("northwest", 18);
        ANCHORS.put("north", 11);
        ANCHORS.put("northeast", 12);
        ANCHORS.put("west", 17);
        ANCHORS.put("center", 10);
        ANCHORS.put("east", 13);
        ANCHORS.put("southwest", 16);
        ANCHORS.put("south", 15);
        ANCHORS.put("southeast", 14);
        ANCHORS.put("first_line_start", 23);
        ANCHORS.put("page_start", 19);
        ANCHORS.put("first_line_end", 24);
        ANCHORS.put("line_start", 21);
        ANCHORS.put("line_end", 22);
        ANCHORS.put("last_line_start", 25);
        ANCHORS.put("page_end", 20);
        ANCHORS.put("last_line_end", 26);
        ANCHORS.put("baseline", 256);
        ANCHORS.put("baseline_leading", 512);
        ANCHORS.put("baseline_trailing", 768);
        ANCHORS.put("above_baseline", 1024);
        ANCHORS.put("above_baseline_leading", 1280);
        ANCHORS.put("above_baseline_trailing", 1536);
        ANCHORS.put("below_baseline", 1792);
        ANCHORS.put("below_baseline_leading", 2048);
        ANCHORS.put("below_baseline_trailing", 2304);
    }
}

