/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.lighting;

import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;

public class ColorTriplet {
    protected Double[] ambient;
    protected Double[] diffuse;
    protected Double[] specular;

    public ColorTriplet() {
        this.ambient = new Double[]{0.0, 0.0, 0.0};
        this.diffuse = new Double[]{0.0, 0.0, 0.0};
        this.specular = new Double[]{0.0, 0.0, 0.0};
    }

    public ColorTriplet(ColorTriplet colorTriplet) {
        this.ambient = new Double[3];
        this.diffuse = new Double[3];
        this.specular = new Double[3];
        this.setAmbientColor(colorTriplet.ambient);
        this.setDiffuseColor(colorTriplet.diffuse);
        this.setSpecularColor(colorTriplet.specular);
    }

    public Double[] getAmbientColor() {
        Double[] doubleArray = new Double[]{this.ambient[0], this.ambient[1], this.ambient[2]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setAmbientColor(Double[] doubleArray) {
        if (doubleArray.length != 3 || !this.isColorValid(doubleArray)) {
            return GraphicObject.UpdateStatus.Fail;
        }
        if (!(this.ambient[0].equals(doubleArray[0]) && this.ambient[1].equals(doubleArray[1]) && this.ambient[2].equals(doubleArray[2]))) {
            this.ambient[0] = doubleArray[0];
            this.ambient[1] = doubleArray[1];
            this.ambient[2] = doubleArray[2];
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double[] getDiffuseColor() {
        Double[] doubleArray = new Double[]{this.diffuse[0], this.diffuse[1], this.diffuse[2]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setDiffuseColor(Double[] doubleArray) {
        if (doubleArray.length != 3 || !this.isColorValid(doubleArray)) {
            return GraphicObject.UpdateStatus.Fail;
        }
        if (!(this.diffuse[0].equals(doubleArray[0]) && this.diffuse[1].equals(doubleArray[1]) && this.diffuse[2].equals(doubleArray[2]))) {
            this.diffuse[0] = doubleArray[0];
            this.diffuse[1] = doubleArray[1];
            this.diffuse[2] = doubleArray[2];
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double[] getSpecularColor() {
        Double[] doubleArray = new Double[]{this.specular[0], this.specular[1], this.specular[2]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setSpecularColor(Double[] doubleArray) {
        if (doubleArray.length != 3 || !this.isColorValid(doubleArray)) {
            return GraphicObject.UpdateStatus.Fail;
        }
        if (!(this.specular[0].equals(doubleArray[0]) && this.specular[1].equals(doubleArray[1]) && this.specular[2].equals(doubleArray[2]))) {
            this.specular[0] = doubleArray[0];
            this.specular[1] = doubleArray[1];
            this.specular[2] = doubleArray[2];
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    private boolean isColorValid(Double[] doubleArray) {
        for (Double d : doubleArray) {
            if (!(d < 0.0) && !(d > 1.0)) continue;
            return false;
        }
        return true;
    }

    public static enum ColorTripletProperty {
        AMBIENTCOLOR,
        DIFFUSECOLOR,
        SPECULARCOLOR;

    }
}

