/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.axes;

import java.util.ArrayList;
import org.scilab.modules.graphic_objects.arc.Arc;
import org.scilab.modules.graphic_objects.axes.AxisProperty;
import org.scilab.modules.graphic_objects.axes.Box;
import org.scilab.modules.graphic_objects.axes.Camera;
import org.scilab.modules.graphic_objects.axes.TicksProperty;
import org.scilab.modules.graphic_objects.contouredObject.Line;
import org.scilab.modules.graphic_objects.contouredObject.Mark;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.ClippableProperty;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.textObject.FormattedText;

public class Axes
extends GraphicObject {
    private static final double BOUNDS_PARAMETER = 5.0;
    private AxisProperty[] axes;
    private boolean autoSubticks;
    private GridPosition gridPosition;
    private Integer title;
    private boolean autoClear;
    private boolean filled;
    private int background;
    private Camera camera;
    private Box box;
    private double[] margins;
    private boolean auto_margins;
    private double[] axesBounds;
    private int hiddenColor;
    private Line line;
    private Mark mark;
    private Arc.ArcDrawingMethod arcDrawingMethod;
    private ClippableProperty clipProperty;
    private double[] axesScale = new double[]{0.0, 0.0, 0.0};
    private ColorMap colorMap;

    public Axes() {
        this.axes = new AxisProperty[3];
        this.axes[0] = new AxisProperty();
        this.axes[1] = new AxisProperty();
        this.axes[2] = new AxisProperty();
        this.gridPosition = GridPosition.FOREGROUND;
        this.title = 0;
        this.autoClear = false;
        this.filled = false;
        this.camera = new Camera();
        this.box = new Box();
        this.margins = new double[4];
        this.auto_margins = true;
        this.axesBounds = new double[4];
        this.line = new Line();
        this.mark = new Mark();
        this.arcDrawingMethod = Arc.ArcDrawingMethod.LINES;
        this.clipProperty = new ClippableProperty();
        this.colorMap = new ColorMap();
    }

    @Override
    public Axes clone() {
        Axes axes = (Axes)super.clone();
        AxisProperty[] axisPropertyArray = new AxisProperty[3];
        for (int i = 0; i < this.axes.length; ++i) {
            axisPropertyArray[i] = new AxisProperty(this.axes[i]);
        }
        axes.axes = axisPropertyArray;
        axes.title = 0;
        axes.camera = new Camera(this.camera);
        axes.box = new Box(this.box);
        double[] dArray = new double[4];
        for (int i = 0; i < this.margins.length; ++i) {
            dArray[i] = this.margins[i];
        }
        axes.margins = dArray;
        axes.auto_margins = this.auto_margins;
        double[] dArray2 = new double[4];
        for (int i = 0; i < this.axesBounds.length; ++i) {
            dArray2[i] = this.axesBounds[i];
        }
        axes.axesBounds = dArray2;
        axes.line = new Line(this.line);
        axes.mark = new Mark(this.mark);
        axes.clipProperty = new ClippableProperty(this.clipProperty);
        axes.setValid(true);
        axes.colorMap = new ColorMap(this.colorMap);
        return axes;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 110: {
                return AxesProperty.XAXISVISIBLE;
            }
            case 111: {
                return AxesProperty.XAXISREVERSE;
            }
            case 112: {
                return AxesProperty.XAXISGRIDCOLOR;
            }
            case 113: {
                return AxesProperty.XAXISGRIDTHICKNESS;
            }
            case 114: {
                return AxesProperty.XAXISGRIDSTYLE;
            }
            case 115: {
                return AxesProperty.XAXISLABEL;
            }
            case 116: {
                return AxesProperty.XAXISLOCATION;
            }
            case 117: {
                return AxesProperty.XAXISLOGFLAG;
            }
            case 118: {
                return AxesProperty.XAXISTICKS;
            }
            case 119: {
                return AxesProperty.XAXISFORMAT;
            }
            case 120: {
                return AxesProperty.XAXISSTFACTORS;
            }
            case 121: {
                return AxesProperty.XAXISAUTOTICKS;
            }
            case 122: {
                return AxesProperty.XAXISNUMBERTICKS;
            }
            case 123: {
                return AxesProperty.XAXISTICKSLOCATIONS;
            }
            case 124: {
                return AxesProperty.XAXISTICKSLABELS;
            }
            case 125: {
                return AxesProperty.XAXISTICKSINTERPRETERS;
            }
            case 126: {
                return AxesProperty.XAXISSUBTICKS;
            }
            case 127: {
                return AxesProperty.YAXISVISIBLE;
            }
            case 128: {
                return AxesProperty.YAXISREVERSE;
            }
            case 129: {
                return AxesProperty.YAXISGRIDCOLOR;
            }
            case 130: {
                return AxesProperty.YAXISGRIDTHICKNESS;
            }
            case 131: {
                return AxesProperty.YAXISGRIDSTYLE;
            }
            case 132: {
                return AxesProperty.YAXISLABEL;
            }
            case 133: {
                return AxesProperty.YAXISLOCATION;
            }
            case 134: {
                return AxesProperty.YAXISLOGFLAG;
            }
            case 135: {
                return AxesProperty.YAXISTICKS;
            }
            case 136: {
                return AxesProperty.YAXISFORMAT;
            }
            case 137: {
                return AxesProperty.YAXISSTFACTORS;
            }
            case 138: {
                return AxesProperty.YAXISAUTOTICKS;
            }
            case 139: {
                return AxesProperty.YAXISNUMBERTICKS;
            }
            case 140: {
                return AxesProperty.YAXISTICKSLOCATIONS;
            }
            case 141: {
                return AxesProperty.YAXISTICKSLABELS;
            }
            case 142: {
                return AxesProperty.YAXISTICKSINTERPRETERS;
            }
            case 143: {
                return AxesProperty.YAXISSUBTICKS;
            }
            case 144: {
                return AxesProperty.ZAXISVISIBLE;
            }
            case 145: {
                return AxesProperty.ZAXISREVERSE;
            }
            case 146: {
                return AxesProperty.ZAXISGRIDCOLOR;
            }
            case 147: {
                return AxesProperty.ZAXISGRIDTHICKNESS;
            }
            case 148: {
                return AxesProperty.ZAXISGRIDSTYLE;
            }
            case 149: {
                return AxesProperty.ZAXISLABEL;
            }
            case 150: {
                return AxesProperty.ZAXISLOCATION;
            }
            case 151: {
                return AxesProperty.ZAXISLOGFLAG;
            }
            case 152: {
                return AxesProperty.ZAXISTICKS;
            }
            case 153: {
                return AxesProperty.ZAXISFORMAT;
            }
            case 154: {
                return AxesProperty.ZAXISSTFACTORS;
            }
            case 155: {
                return AxesProperty.ZAXISAUTOTICKS;
            }
            case 156: {
                return AxesProperty.ZAXISNUMBERTICKS;
            }
            case 157: {
                return AxesProperty.ZAXISTICKSLOCATIONS;
            }
            case 158: {
                return AxesProperty.ZAXISTICKSLABELS;
            }
            case 159: {
                return AxesProperty.ZAXISTICKSINTERPRETERS;
            }
            case 160: {
                return AxesProperty.ZAXISSUBTICKS;
            }
            case 161: {
                return AxesProperty.AUTOSUBTICKS;
            }
            case 221: {
                return AxesProperty.FONT_STYLE;
            }
            case 222: {
                return AxesProperty.FONT_SIZE;
            }
            case 223: {
                return AxesProperty.FONT_COLOR;
            }
            case 224: {
                return AxesProperty.FONT_FRACTIONAL;
            }
            case 162: {
                return AxesProperty.GRIDPOSITION;
            }
            case 163: {
                return AxesProperty.TITLE;
            }
            case 164: {
                return AxesProperty.AUTOCLEAR;
            }
            case 165: {
                return AxesProperty.FILLED;
            }
            case 96: {
                return AxesProperty.BACKGROUND;
            }
            case 167: {
                return Camera.CameraProperty.VIEW;
            }
            case 168: {
                return Camera.CameraProperty.ISOVIEW;
            }
            case 169: {
                return Camera.CameraProperty.CUBESCALING;
            }
            case 170: {
                return Camera.CameraProperty.ROTATIONANGLES;
            }
            case 171: {
                return Camera.CameraProperty.ROTATIONANGLES3D;
            }
            case 172: {
                return Box.BoxProperty.BOX;
            }
            case 173: {
                return Box.BoxProperty.HIDDENAXISCOLOR;
            }
            case 174: {
                return Box.BoxProperty.XTIGHTLIMITS;
            }
            case 175: {
                return Box.BoxProperty.YTIGHTLIMITS;
            }
            case 176: {
                return Box.BoxProperty.ZTIGHTLIMITS;
            }
            case 177: {
                return Box.BoxProperty.DATABOUNDS;
            }
            case 178: {
                return Box.BoxProperty.REALDATABOUNDS;
            }
            case 179: {
                return Box.BoxProperty.ZOOMENABLED;
            }
            case 180: {
                return Box.BoxProperty.ZOOMBOX;
            }
            case 181: {
                return Box.BoxProperty.AUTOSCALE;
            }
            case 182: {
                return Box.BoxProperty.AUTOSTRETCH;
            }
            case 183: {
                return Box.BoxProperty.FIRSTPLOT;
            }
            case 184: {
                return AxesProperty.MARGINS;
            }
            case 185: {
                return AxesProperty.AUTO_MARGINS;
            }
            case 186: {
                return AxesProperty.AXESBOUNDS;
            }
            case 278: {
                return AxesProperty.HIDDENCOLOR;
            }
            case 192: {
                return Line.LinePropertyType.MODE;
            }
            case 193: {
                return Line.LinePropertyType.LINESTYLE;
            }
            case 194: {
                return Line.LinePropertyType.THICKNESS;
            }
            case 195: {
                return Line.LinePropertyType.COLOR;
            }
            case 198: {
                return Mark.MarkPropertyType.MODE;
            }
            case 199: {
                return Mark.MarkPropertyType.STYLE;
            }
            case 200: {
                return Mark.MarkPropertyType.SIZEUNIT;
            }
            case 201: {
                return Mark.MarkPropertyType.SIZE;
            }
            case 202: {
                return Mark.MarkPropertyType.FOREGROUND;
            }
            case 203: {
                return Mark.MarkPropertyType.BACKGROUND;
            }
            case 188: {
                return ClippableProperty.ClippablePropertyType.CLIPSTATE;
            }
            case 189: {
                return ClippableProperty.ClippablePropertyType.CLIPBOX;
            }
            case 190: {
                return ClippableProperty.ClippablePropertyType.CLIPBOXSET;
            }
            case 109: {
                return Arc.ArcProperty.ARCDRAWINGMETHOD;
            }
            case 90: {
                return AxesProperty.COLORMAP;
            }
            case 91: {
                return AxesProperty.COLORMAPSIZE;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object instanceof AxesProperty) {
            AxesProperty axesProperty = (AxesProperty)((Object)object);
            switch (axesProperty) {
                case XAXISVISIBLE: {
                    return this.getXAxisVisible();
                }
                case XAXISREVERSE: {
                    return this.getXAxisReverse();
                }
                case XAXISGRIDCOLOR: {
                    return this.getXAxisGridColor();
                }
                case XAXISGRIDTHICKNESS: {
                    return this.getXAxisGridThickness();
                }
                case XAXISGRIDSTYLE: {
                    return this.getXAxisGridStyle();
                }
                case XAXISLABEL: {
                    return this.getXAxisLabel();
                }
                case XAXISLOCATION: {
                    return this.getXAxisLocation();
                }
                case XAXISLOGFLAG: {
                    return this.getXAxisLogFlag();
                }
                case XAXISTICKS: {
                    return this.getXAxisTicks();
                }
                case XAXISFORMAT: {
                    return this.getXAxisFormat();
                }
                case XAXISSTFACTORS: {
                    return this.getXAxisSTFactors();
                }
                case XAXISAUTOTICKS: {
                    return this.getXAxisAutoTicks();
                }
                case XAXISNUMBERTICKS: {
                    return this.getXAxisNumberTicks();
                }
                case XAXISTICKSLOCATIONS: {
                    return this.getXAxisTicksLocations();
                }
                case XAXISTICKSLABELS: {
                    return this.getXAxisTicksLabels();
                }
                case XAXISTICKSINTERPRETERS: {
                    return this.getXAxisTicksInterpreters();
                }
                case XAXISSUBTICKS: {
                    return this.getXAxisSubticks();
                }
                case YAXISVISIBLE: {
                    return this.getYAxisVisible();
                }
                case YAXISREVERSE: {
                    return this.getYAxisReverse();
                }
                case YAXISGRIDCOLOR: {
                    return this.getYAxisGridColor();
                }
                case YAXISGRIDTHICKNESS: {
                    return this.getYAxisGridThickness();
                }
                case YAXISGRIDSTYLE: {
                    return this.getYAxisGridStyle();
                }
                case YAXISLABEL: {
                    return this.getYAxisLabel();
                }
                case YAXISLOCATION: {
                    return this.getYAxisLocation();
                }
                case YAXISLOGFLAG: {
                    return this.getYAxisLogFlag();
                }
                case YAXISTICKS: {
                    return this.getYAxisTicks();
                }
                case YAXISFORMAT: {
                    return this.getYAxisFormat();
                }
                case YAXISSTFACTORS: {
                    return this.getYAxisSTFactors();
                }
                case YAXISAUTOTICKS: {
                    return this.getYAxisAutoTicks();
                }
                case YAXISNUMBERTICKS: {
                    return this.getYAxisNumberTicks();
                }
                case YAXISTICKSLOCATIONS: {
                    return this.getYAxisTicksLocations();
                }
                case YAXISTICKSLABELS: {
                    return this.getYAxisTicksLabels();
                }
                case YAXISTICKSINTERPRETERS: {
                    return this.getYAxisTicksInterpreters();
                }
                case YAXISSUBTICKS: {
                    return this.getYAxisSubticks();
                }
                case ZAXISVISIBLE: {
                    return this.getZAxisVisible();
                }
                case ZAXISREVERSE: {
                    return this.getZAxisReverse();
                }
                case ZAXISGRIDCOLOR: {
                    return this.getZAxisGridColor();
                }
                case ZAXISGRIDTHICKNESS: {
                    return this.getZAxisGridThickness();
                }
                case ZAXISGRIDSTYLE: {
                    return this.getZAxisGridStyle();
                }
                case ZAXISLABEL: {
                    return this.getZAxisLabel();
                }
                case ZAXISLOCATION: {
                    return this.getZAxisLocation();
                }
                case ZAXISLOGFLAG: {
                    return this.getZAxisLogFlag();
                }
                case ZAXISTICKS: {
                    return this.getZAxisTicks();
                }
                case ZAXISFORMAT: {
                    return this.getZAxisFormat();
                }
                case ZAXISSTFACTORS: {
                    return this.getZAxisSTFactors();
                }
                case ZAXISAUTOTICKS: {
                    return this.getZAxisAutoTicks();
                }
                case ZAXISNUMBERTICKS: {
                    return this.getZAxisNumberTicks();
                }
                case ZAXISTICKSLOCATIONS: {
                    return this.getZAxisTicksLocations();
                }
                case ZAXISTICKSLABELS: {
                    return this.getZAxisTicksLabels();
                }
                case ZAXISTICKSINTERPRETERS: {
                    return this.getZAxisTicksInterpreters();
                }
                case ZAXISSUBTICKS: {
                    return this.getZAxisSubticks();
                }
                case AUTOSUBTICKS: {
                    return this.getAutoSubticks();
                }
                case FONT_STYLE: {
                    return this.getFontStyle();
                }
                case FONT_SIZE: {
                    return this.getFontSize();
                }
                case FONT_COLOR: {
                    return this.getFontColor();
                }
                case FONT_FRACTIONAL: {
                    return this.getFontFractional();
                }
                case GRIDPOSITION: {
                    return this.getGridPosition();
                }
                case TITLE: {
                    return this.getTitle();
                }
                case AUTOCLEAR: {
                    return this.getAutoClear();
                }
                case FILLED: {
                    return this.getFilled();
                }
                case BACKGROUND: {
                    return this.getBackground();
                }
                case MARGINS: {
                    return this.getMargins();
                }
                case AUTO_MARGINS: {
                    return this.getAutoMargins();
                }
                case AXESBOUNDS: {
                    return this.getAxesBounds();
                }
                case HIDDENCOLOR: {
                    return this.getHiddenColor();
                }
                case COLORMAP: {
                    return this.colorMap.getData();
                }
                case COLORMAPSIZE: {
                    return this.colorMap.getSize();
                }
            }
        } else if (object instanceof Camera.CameraProperty) {
            Camera.CameraProperty cameraProperty = (Camera.CameraProperty)((Object)object);
            switch (cameraProperty) {
                case VIEW: {
                    return this.getView();
                }
                case ISOVIEW: {
                    return this.getIsoview();
                }
                case CUBESCALING: {
                    return this.getCubeScaling();
                }
                case ROTATIONANGLES: {
                    return this.getRotationAngles();
                }
                case ROTATIONANGLES3D: {
                    return this.getRotationAngles3d();
                }
            }
        } else if (object instanceof Box.BoxProperty) {
            Box.BoxProperty boxProperty = (Box.BoxProperty)((Object)object);
            switch (boxProperty) {
                case BOX: {
                    return this.getBoxType();
                }
                case HIDDENAXISCOLOR: {
                    return this.getHiddenAxisColor();
                }
                case XTIGHTLIMITS: {
                    return this.getXTightLimits();
                }
                case YTIGHTLIMITS: {
                    return this.getYTightLimits();
                }
                case ZTIGHTLIMITS: {
                    return this.getZTightLimits();
                }
                case DATABOUNDS: {
                    return this.getDataBounds();
                }
                case REALDATABOUNDS: {
                    return this.getRealDataBounds();
                }
                case ZOOMENABLED: {
                    return this.getZoomEnabled();
                }
                case ZOOMBOX: {
                    return this.getZoomBox();
                }
                case AUTOSCALE: {
                    return this.getAutoScale();
                }
                case AUTOSTRETCH: {
                    return this.getAutoStretch();
                }
                case FIRSTPLOT: {
                    return this.getFirstPlot();
                }
            }
        } else if (object instanceof Line.LinePropertyType) {
            Line.LinePropertyType linePropertyType = (Line.LinePropertyType)((Object)object);
            switch (linePropertyType) {
                case MODE: {
                    return this.getLineMode();
                }
                case LINESTYLE: {
                    return this.getLineStyle();
                }
                case THICKNESS: {
                    return this.getLineThickness();
                }
                case COLOR: {
                    return this.getLineColor();
                }
            }
        } else if (object instanceof Mark.MarkPropertyType) {
            Mark.MarkPropertyType markPropertyType = (Mark.MarkPropertyType)((Object)object);
            switch (markPropertyType) {
                case MODE: {
                    return this.getMarkMode();
                }
                case STYLE: {
                    return this.getMarkStyle();
                }
                case SIZE: {
                    return this.getMarkSize();
                }
                case SIZEUNIT: {
                    return this.getMarkSizeUnit();
                }
                case FOREGROUND: {
                    return this.getMarkForeground();
                }
                case BACKGROUND: {
                    return this.getMarkBackground();
                }
            }
        } else if (object instanceof ClippableProperty.ClippablePropertyType) {
            ClippableProperty.ClippablePropertyType clippablePropertyType = (ClippableProperty.ClippablePropertyType)((Object)object);
            switch (clippablePropertyType) {
                case CLIPSTATE: {
                    return this.getClipState();
                }
                case CLIPBOX: {
                    return this.getClipBox();
                }
                case CLIPBOXSET: {
                    return this.getClipBoxSet();
                }
            }
        } else if (object == Arc.ArcProperty.ARCDRAWINGMETHOD) {
            return this.getArcDrawingMethod();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object instanceof AxesProperty) {
            AxesProperty axesProperty = (AxesProperty)((Object)object);
            switch (axesProperty) {
                case XAXISVISIBLE: {
                    return this.setXAxisVisible((Boolean)object2);
                }
                case XAXISREVERSE: {
                    return this.setXAxisReverse((Boolean)object2);
                }
                case XAXISGRIDCOLOR: {
                    return this.setXAxisGridColor((Integer)object2);
                }
                case XAXISGRIDTHICKNESS: {
                    return this.setXAxisGridThickness((Double)object2);
                }
                case XAXISGRIDSTYLE: {
                    return this.setXAxisGridStyle((Integer)object2);
                }
                case XAXISLABEL: {
                    return this.setXAxisLabel((Integer)object2);
                }
                case XAXISLOCATION: {
                    return this.setXAxisLocation((Integer)object2);
                }
                case XAXISLOGFLAG: {
                    return this.setXAxisLogFlag((Boolean)object2);
                }
                case XAXISTICKS: {
                    return this.setXAxisTicks((TicksProperty)object2);
                }
                case XAXISFORMAT: {
                    return this.setXAxisFormat((String)object2);
                }
                case XAXISSTFACTORS: {
                    return this.setXAxisSTFactors((Double[])object2);
                }
                case XAXISAUTOTICKS: {
                    return this.setXAxisAutoTicks((Boolean)object2);
                }
                case XAXISTICKSLOCATIONS: {
                    return this.setXAxisTicksLocations((Double[])object2);
                }
                case XAXISTICKSLABELS: {
                    return this.setXAxisTicksLabels((String[])object2);
                }
                case XAXISTICKSINTERPRETERS: {
                    return this.setXAxisTicksInterpreters((String[])object2);
                }
                case XAXISSUBTICKS: {
                    return this.setXAxisSubticks((Integer)object2);
                }
                case YAXISVISIBLE: {
                    return this.setYAxisVisible((Boolean)object2);
                }
                case YAXISREVERSE: {
                    return this.setYAxisReverse((Boolean)object2);
                }
                case YAXISGRIDCOLOR: {
                    return this.setYAxisGridColor((Integer)object2);
                }
                case YAXISGRIDTHICKNESS: {
                    return this.setYAxisGridThickness((Double)object2);
                }
                case YAXISGRIDSTYLE: {
                    return this.setYAxisGridStyle((Integer)object2);
                }
                case YAXISLABEL: {
                    return this.setYAxisLabel((Integer)object2);
                }
                case YAXISLOCATION: {
                    return this.setYAxisLocation((Integer)object2);
                }
                case YAXISLOGFLAG: {
                    return this.setYAxisLogFlag((Boolean)object2);
                }
                case YAXISTICKS: {
                    return this.setYAxisTicks((TicksProperty)object2);
                }
                case YAXISFORMAT: {
                    return this.setYAxisFormat((String)object2);
                }
                case YAXISSTFACTORS: {
                    return this.setYAxisSTFactors((Double[])object2);
                }
                case YAXISAUTOTICKS: {
                    return this.setYAxisAutoTicks((Boolean)object2);
                }
                case YAXISTICKSLOCATIONS: {
                    return this.setYAxisTicksLocations((Double[])object2);
                }
                case YAXISTICKSLABELS: {
                    return this.setYAxisTicksLabels((String[])object2);
                }
                case YAXISTICKSINTERPRETERS: {
                    return this.setYAxisTicksInterpreters((String[])object2);
                }
                case YAXISSUBTICKS: {
                    return this.setYAxisSubticks((Integer)object2);
                }
                case ZAXISVISIBLE: {
                    return this.setZAxisVisible((Boolean)object2);
                }
                case ZAXISREVERSE: {
                    return this.setZAxisReverse((Boolean)object2);
                }
                case ZAXISGRIDCOLOR: {
                    return this.setZAxisGridColor((Integer)object2);
                }
                case ZAXISGRIDTHICKNESS: {
                    return this.setZAxisGridThickness((Double)object2);
                }
                case ZAXISGRIDSTYLE: {
                    return this.setZAxisGridStyle((Integer)object2);
                }
                case ZAXISLABEL: {
                    return this.setZAxisLabel((Integer)object2);
                }
                case ZAXISLOCATION: {
                    return this.setZAxisLocation((Integer)object2);
                }
                case ZAXISLOGFLAG: {
                    return this.setZAxisLogFlag((Boolean)object2);
                }
                case ZAXISTICKS: {
                    return this.setZAxisTicks((TicksProperty)object2);
                }
                case ZAXISFORMAT: {
                    return this.setZAxisFormat((String)object2);
                }
                case ZAXISSTFACTORS: {
                    return this.setZAxisSTFactors((Double[])object2);
                }
                case ZAXISAUTOTICKS: {
                    return this.setZAxisAutoTicks((Boolean)object2);
                }
                case ZAXISTICKSLOCATIONS: {
                    return this.setZAxisTicksLocations((Double[])object2);
                }
                case ZAXISTICKSLABELS: {
                    return this.setZAxisTicksLabels((String[])object2);
                }
                case ZAXISTICKSINTERPRETERS: {
                    return this.setZAxisTicksInterpreters((String[])object2);
                }
                case ZAXISSUBTICKS: {
                    return this.setZAxisSubticks((Integer)object2);
                }
                case AUTOSUBTICKS: {
                    return this.setAutoSubticks((Boolean)object2);
                }
                case FONT_STYLE: {
                    return this.setFontStyle((Integer)object2);
                }
                case FONT_SIZE: {
                    return this.setFontSize((Double)object2);
                }
                case FONT_COLOR: {
                    return this.setFontColor((Integer)object2);
                }
                case FONT_FRACTIONAL: {
                    return this.setFontFractional((Boolean)object2);
                }
                case GRIDPOSITION: {
                    return this.setGridPosition((Integer)object2);
                }
                case TITLE: {
                    return this.setTitle((Integer)object2);
                }
                case AUTOCLEAR: {
                    return this.setAutoClear((Boolean)object2);
                }
                case FILLED: {
                    return this.setFilled((Boolean)object2);
                }
                case BACKGROUND: {
                    return this.setBackground((Integer)object2);
                }
                case MARGINS: {
                    return this.setMargins((Double[])object2);
                }
                case AUTO_MARGINS: {
                    return this.setAutoMargins((Boolean)object2);
                }
                case AXESBOUNDS: {
                    return this.setAxesBounds((Double[])object2);
                }
                case HIDDENCOLOR: {
                    return this.setHiddenColor((Integer)object2);
                }
                case COLORMAP: {
                    return this.colorMap.setData((Double[])object2);
                }
                case COLORMAPSIZE: {
                    return GraphicObject.UpdateStatus.NoChange;
                }
            }
        } else if (object instanceof Camera.CameraProperty) {
            Camera.CameraProperty cameraProperty = (Camera.CameraProperty)((Object)object);
            switch (cameraProperty) {
                case VIEW: {
                    return this.setView((Integer)object2);
                }
                case ISOVIEW: {
                    return this.setIsoview((Boolean)object2);
                }
                case CUBESCALING: {
                    return this.setCubeScaling((Boolean)object2);
                }
                case ROTATIONANGLES: {
                    return this.setRotationAngles((Double[])object2);
                }
                case ROTATIONANGLES3D: {
                    return this.setRotationAngles3d((Double[])object2);
                }
            }
        } else if (object instanceof Box.BoxProperty) {
            Box.BoxProperty boxProperty = (Box.BoxProperty)((Object)object);
            switch (boxProperty) {
                case BOX: {
                    return this.setBoxType((Integer)object2);
                }
                case HIDDENAXISCOLOR: {
                    return this.setHiddenAxisColor((Integer)object2);
                }
                case XTIGHTLIMITS: {
                    return this.setXTightLimits((Boolean)object2);
                }
                case YTIGHTLIMITS: {
                    return this.setYTightLimits((Boolean)object2);
                }
                case ZTIGHTLIMITS: {
                    return this.setZTightLimits((Boolean)object2);
                }
                case DATABOUNDS: {
                    return this.setDataBounds((Double[])object2);
                }
                case REALDATABOUNDS: {
                    return this.setRealDataBounds((Double[])object2);
                }
                case ZOOMENABLED: {
                    return this.setZoomEnabled((Boolean)object2);
                }
                case ZOOMBOX: {
                    return this.setZoomBox((Double[])object2);
                }
                case AUTOSCALE: {
                    return this.setAutoScale((Boolean)object2);
                }
                case AUTOSTRETCH: {
                    return this.setAutoStretch((Boolean)object2);
                }
                case FIRSTPLOT: {
                    return this.setFirstPlot((Boolean)object2);
                }
            }
        } else if (object instanceof Line.LinePropertyType) {
            Line.LinePropertyType linePropertyType = (Line.LinePropertyType)((Object)object);
            switch (linePropertyType) {
                case MODE: {
                    return this.setLineMode((Boolean)object2);
                }
                case LINESTYLE: {
                    return this.setLineStyle((Integer)object2);
                }
                case THICKNESS: {
                    return this.setLineThickness((Double)object2);
                }
                case COLOR: {
                    return this.setLineColor((Integer)object2);
                }
            }
        } else if (object instanceof Mark.MarkPropertyType) {
            Mark.MarkPropertyType markPropertyType = (Mark.MarkPropertyType)((Object)object);
            switch (markPropertyType) {
                case MODE: {
                    return this.setMarkMode((Boolean)object2);
                }
                case STYLE: {
                    return this.setMarkStyle((Integer)object2);
                }
                case SIZE: {
                    return this.setMarkSize((Integer)object2);
                }
                case SIZEUNIT: {
                    return this.setMarkSizeUnit((Integer)object2);
                }
                case FOREGROUND: {
                    return this.setMarkForeground((Integer)object2);
                }
                case BACKGROUND: {
                    return this.setMarkBackground((Integer)object2);
                }
            }
        } else if (object instanceof ClippableProperty.ClippablePropertyType) {
            ClippableProperty.ClippablePropertyType clippablePropertyType = (ClippableProperty.ClippablePropertyType)((Object)object);
            switch (clippablePropertyType) {
                case CLIPSTATE: {
                    return this.setClipState((Integer)object2);
                }
                case CLIPBOX: {
                    return this.setClipBox((Double[])object2);
                }
                case CLIPBOXSET: {
                    return this.setClipBoxSet((Boolean)object2);
                }
            }
        } else if (object == Arc.ArcProperty.ARCDRAWINGMETHOD) {
            return this.setArcDrawingMethod((Integer)object2);
        }
        return super.setProperty(object, object2);
    }

    public Boolean getAutoClear() {
        return this.autoClear;
    }

    public GraphicObject.UpdateStatus setAutoClear(Boolean bl) {
        if (bl != this.autoClear) {
            this.autoClear = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public AxisProperty[] getAxes() {
        return this.axes;
    }

    public GraphicObject.UpdateStatus setAxes(AxisProperty[] axisPropertyArray) {
        this.axes = axisPropertyArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public AxisProperty getXAxis() {
        return this.axes[0];
    }

    public GraphicObject.UpdateStatus setXAxis(AxisProperty axisProperty) {
        this.axes[0] = axisProperty;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getXAxisVisible() {
        return this.axes[0].getVisible();
    }

    public GraphicObject.UpdateStatus setXAxisVisible(Boolean bl) {
        return this.axes[0].setVisible(bl);
    }

    public String getXAxisFormat() {
        return this.axes[0].getFormat();
    }

    public GraphicObject.UpdateStatus setXAxisFormat(String string) {
        return this.axes[0].setFormat(string);
    }

    public Double[] getXAxisSTFactors() {
        return this.axes[0].getSTFactors();
    }

    public GraphicObject.UpdateStatus setXAxisSTFactors(Double[] doubleArray) {
        return this.axes[0].setSTFactors(doubleArray);
    }

    public Boolean getXAxisReverse() {
        return this.axes[0].getReverse();
    }

    public GraphicObject.UpdateStatus setXAxisReverse(Boolean bl) {
        return this.axes[0].setReverse(bl);
    }

    public Integer getXAxisGridColor() {
        return this.axes[0].getGridColor();
    }

    public GraphicObject.UpdateStatus setXAxisGridColor(Integer n) {
        return this.axes[0].setGridColor(n);
    }

    public Double getXAxisGridThickness() {
        Double d = this.axes[0].getGridThickness();
        return d == -1.0 ? this.getLineThickness() : d;
    }

    public GraphicObject.UpdateStatus setXAxisGridThickness(Double d) {
        return this.axes[0].setGridThickness(d);
    }

    public Integer getXAxisGridStyle() {
        return this.axes[0].getGridStyle();
    }

    public GraphicObject.UpdateStatus setXAxisGridStyle(Integer n) {
        return this.axes[0].setGridStyle(n);
    }

    public Integer getXAxisLabel() {
        return this.axes[0].getLabel();
    }

    public GraphicObject.UpdateStatus setXAxisLabel(Integer n) {
        return this.axes[0].setLabel(n);
    }

    public Integer getXAxisLocation() {
        return this.getXAxisLocationAsEnum().ordinal();
    }

    public AxisProperty.AxisLocation getXAxisLocationAsEnum() {
        return this.axes[0].getAxisLocation();
    }

    public GraphicObject.UpdateStatus setXAxisLocation(Integer n) {
        return this.setXAxisLocationAsEnum(AxisProperty.AxisLocation.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setXAxisLocationAsEnum(AxisProperty.AxisLocation axisLocation) {
        return this.axes[0].setAxisLocation(axisLocation);
    }

    public Boolean getXAxisLogFlag() {
        return this.axes[0].getLogFlag();
    }

    public GraphicObject.UpdateStatus setXAxisLogFlag(Boolean bl) {
        return this.axes[0].setLogFlag(bl);
    }

    public TicksProperty getXAxisTicks() {
        return this.axes[0].getTicks();
    }

    public GraphicObject.UpdateStatus setXAxisTicks(TicksProperty ticksProperty) {
        return this.axes[0].setTicks(ticksProperty);
    }

    public Boolean getXAxisAutoTicks() {
        return this.axes[0].getAutoTicks();
    }

    public GraphicObject.UpdateStatus setXAxisAutoTicks(Boolean bl) {
        return this.axes[0].setAutoTicks(bl);
    }

    public Integer getXAxisNumberTicks() {
        return this.axes[0].getNumberOfTicks();
    }

    public Double[] getXAxisTicksLocations() {
        return this.axes[0].getTicksLocations();
    }

    public GraphicObject.UpdateStatus setXAxisTicksLocations(Double[] doubleArray) {
        return this.axes[0].setTicksLocations(doubleArray);
    }

    public String[] getXAxisTicksLabels() {
        return this.axes[0].getTicksLabelsStrings();
    }

    public ArrayList<FormattedText> getXAxisTicksLabelsAsArrayList() {
        return this.axes[0].getTicksLabels();
    }

    public GraphicObject.UpdateStatus setXAxisTicksLabels(String[] stringArray) {
        return this.axes[0].setTicksLabelsStrings(stringArray);
    }

    public GraphicObject.UpdateStatus setXAxisTicksInterpreters(String[] stringArray) {
        return this.axes[0].setTicksLabelsInterpreters(stringArray);
    }

    public String[] getXAxisTicksInterpreters() {
        return this.axes[0].getTicksLabelsInterpreters();
    }

    public GraphicObject.UpdateStatus setXAxisTicksLabelsAsArrayList(ArrayList<FormattedText> arrayList) {
        return this.axes[0].setTicksLabels(arrayList);
    }

    public Integer getXAxisSubticks() {
        return this.axes[0].getSubticks();
    }

    public GraphicObject.UpdateStatus setXAxisSubticks(Integer n) {
        return this.axes[0].setSubticks(n);
    }

    public AxisProperty getYAxis() {
        return this.axes[1];
    }

    public GraphicObject.UpdateStatus setYAxis(AxisProperty axisProperty) {
        this.axes[1] = axisProperty;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getYAxisVisible() {
        return this.axes[1].getVisible();
    }

    public GraphicObject.UpdateStatus setYAxisVisible(Boolean bl) {
        return this.axes[1].setVisible(bl);
    }

    public String getYAxisFormat() {
        return this.axes[1].getFormat();
    }

    public GraphicObject.UpdateStatus setYAxisFormat(String string) {
        return this.axes[1].setFormat(string);
    }

    public Double[] getYAxisSTFactors() {
        return this.axes[1].getSTFactors();
    }

    public GraphicObject.UpdateStatus setYAxisSTFactors(Double[] doubleArray) {
        return this.axes[1].setSTFactors(doubleArray);
    }

    public Boolean getYAxisReverse() {
        return this.axes[1].getReverse();
    }

    public GraphicObject.UpdateStatus setYAxisReverse(Boolean bl) {
        return this.axes[1].setReverse(bl);
    }

    public Integer getYAxisGridColor() {
        return this.axes[1].getGridColor();
    }

    public GraphicObject.UpdateStatus setYAxisGridColor(Integer n) {
        return this.axes[1].setGridColor(n);
    }

    public Double getYAxisGridThickness() {
        Double d = this.axes[1].getGridThickness();
        return d == -1.0 ? this.getLineThickness() : d;
    }

    public GraphicObject.UpdateStatus setYAxisGridThickness(Double d) {
        return this.axes[1].setGridThickness(d);
    }

    public Integer getYAxisGridStyle() {
        return this.axes[1].getGridStyle();
    }

    public GraphicObject.UpdateStatus setYAxisGridStyle(Integer n) {
        return this.axes[1].setGridStyle(n);
    }

    public Integer getYAxisLabel() {
        return this.axes[1].getLabel();
    }

    public GraphicObject.UpdateStatus setYAxisLabel(Integer n) {
        return this.axes[1].setLabel(n);
    }

    public Integer getYAxisLocation() {
        return this.getYAxisLocationAsEnum().ordinal();
    }

    public AxisProperty.AxisLocation getYAxisLocationAsEnum() {
        return this.axes[1].getAxisLocation();
    }

    public GraphicObject.UpdateStatus setYAxisLocation(Integer n) {
        return this.setYAxisLocationAsEnum(AxisProperty.AxisLocation.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setYAxisLocationAsEnum(AxisProperty.AxisLocation axisLocation) {
        return this.axes[1].setAxisLocation(axisLocation);
    }

    public Boolean getYAxisLogFlag() {
        return this.axes[1].getLogFlag();
    }

    public GraphicObject.UpdateStatus setYAxisLogFlag(Boolean bl) {
        return this.axes[1].setLogFlag(bl);
    }

    public TicksProperty getYAxisTicks() {
        return this.axes[1].getTicks();
    }

    public GraphicObject.UpdateStatus setYAxisTicks(TicksProperty ticksProperty) {
        return this.axes[1].setTicks(ticksProperty);
    }

    public Boolean getYAxisAutoTicks() {
        return this.axes[1].getAutoTicks();
    }

    public GraphicObject.UpdateStatus setYAxisAutoTicks(Boolean bl) {
        return this.axes[1].setAutoTicks(bl);
    }

    public Integer getYAxisNumberTicks() {
        return this.axes[1].getNumberOfTicks();
    }

    public Double[] getYAxisTicksLocations() {
        return this.axes[1].getTicksLocations();
    }

    public GraphicObject.UpdateStatus setYAxisTicksLocations(Double[] doubleArray) {
        return this.axes[1].setTicksLocations(doubleArray);
    }

    public String[] getYAxisTicksLabels() {
        return this.axes[1].getTicksLabelsStrings();
    }

    public GraphicObject.UpdateStatus setYAxisTicksInterpreters(String[] stringArray) {
        return this.axes[1].setTicksLabelsInterpreters(stringArray);
    }

    public String[] getYAxisTicksInterpreters() {
        return this.axes[1].getTicksLabelsInterpreters();
    }

    public ArrayList<FormattedText> getYAxisTicksLabelsAsArrayList() {
        return this.axes[1].getTicksLabels();
    }

    public GraphicObject.UpdateStatus setYAxisTicksLabels(String[] stringArray) {
        return this.axes[1].setTicksLabelsStrings(stringArray);
    }

    public GraphicObject.UpdateStatus setYAxisTicksLabelsAsArrayList(ArrayList<FormattedText> arrayList) {
        return this.axes[1].setTicksLabels(arrayList);
    }

    public Integer getYAxisSubticks() {
        return this.axes[1].getSubticks();
    }

    public GraphicObject.UpdateStatus setYAxisSubticks(Integer n) {
        return this.axes[1].setSubticks(n);
    }

    public AxisProperty getZAxis() {
        return this.axes[2];
    }

    public GraphicObject.UpdateStatus setZAxis(AxisProperty axisProperty) {
        this.axes[2] = axisProperty;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getZAxisVisible() {
        return this.axes[2].getVisible();
    }

    public GraphicObject.UpdateStatus setZAxisVisible(Boolean bl) {
        return this.axes[2].setVisible(bl);
    }

    public String getZAxisFormat() {
        return this.axes[2].getFormat();
    }

    public GraphicObject.UpdateStatus setZAxisFormat(String string) {
        return this.axes[2].setFormat(string);
    }

    public Double[] getZAxisSTFactors() {
        return this.axes[2].getSTFactors();
    }

    public GraphicObject.UpdateStatus setZAxisSTFactors(Double[] doubleArray) {
        return this.axes[2].setSTFactors(doubleArray);
    }

    public Boolean getZAxisReverse() {
        return this.axes[2].getReverse();
    }

    public GraphicObject.UpdateStatus setZAxisReverse(Boolean bl) {
        return this.axes[2].setReverse(bl);
    }

    public Integer getZAxisGridColor() {
        return this.axes[2].getGridColor();
    }

    public GraphicObject.UpdateStatus setZAxisGridColor(Integer n) {
        return this.axes[2].setGridColor(n);
    }

    public Double getZAxisGridThickness() {
        Double d = this.axes[2].getGridThickness();
        return d == -1.0 ? this.getLineThickness() : d;
    }

    public GraphicObject.UpdateStatus setZAxisGridThickness(Double d) {
        return this.axes[2].setGridThickness(d);
    }

    public Integer getZAxisGridStyle() {
        return this.axes[2].getGridStyle();
    }

    public GraphicObject.UpdateStatus setZAxisGridStyle(Integer n) {
        return this.axes[2].setGridStyle(n);
    }

    public Integer getZAxisLabel() {
        return this.axes[2].getLabel();
    }

    public GraphicObject.UpdateStatus setZAxisLabel(Integer n) {
        return this.axes[2].setLabel(n);
    }

    public Integer getZAxisLocation() {
        return this.getZAxisLocationAsEnum().ordinal();
    }

    public AxisProperty.AxisLocation getZAxisLocationAsEnum() {
        return this.axes[2].getAxisLocation();
    }

    public GraphicObject.UpdateStatus setZAxisLocation(Integer n) {
        return this.setZAxisLocationAsEnum(AxisProperty.AxisLocation.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setZAxisLocationAsEnum(AxisProperty.AxisLocation axisLocation) {
        return this.axes[2].setAxisLocation(axisLocation);
    }

    public Boolean getZAxisLogFlag() {
        return this.axes[2].getLogFlag();
    }

    public GraphicObject.UpdateStatus setZAxisLogFlag(Boolean bl) {
        return this.axes[2].setLogFlag(bl);
    }

    public TicksProperty getZAxisTicks() {
        return this.axes[2].getTicks();
    }

    public GraphicObject.UpdateStatus setZAxisTicks(TicksProperty ticksProperty) {
        return this.axes[2].setTicks(ticksProperty);
    }

    public Boolean getZAxisAutoTicks() {
        return this.axes[2].getAutoTicks();
    }

    public GraphicObject.UpdateStatus setZAxisAutoTicks(Boolean bl) {
        return this.axes[2].setAutoTicks(bl);
    }

    public Integer getZAxisNumberTicks() {
        return this.axes[2].getNumberOfTicks();
    }

    public Double[] getZAxisTicksLocations() {
        return this.axes[2].getTicksLocations();
    }

    public GraphicObject.UpdateStatus setZAxisTicksLocations(Double[] doubleArray) {
        return this.axes[2].setTicksLocations(doubleArray);
    }

    public String[] getZAxisTicksLabels() {
        return this.axes[2].getTicksLabelsStrings();
    }

    public ArrayList<FormattedText> getZAxisTicksLabelsAsArrayList() {
        return this.axes[2].getTicksLabels();
    }

    public GraphicObject.UpdateStatus setZAxisTicksLabels(String[] stringArray) {
        return this.axes[2].setTicksLabelsStrings(stringArray);
    }

    public GraphicObject.UpdateStatus setZAxisTicksInterpreters(String[] stringArray) {
        return this.axes[2].setTicksLabelsInterpreters(stringArray);
    }

    public String[] getZAxisTicksInterpreters() {
        return this.axes[2].getTicksLabelsInterpreters();
    }

    public GraphicObject.UpdateStatus setZAxisTicksLabelsAsArrayList(ArrayList<FormattedText> arrayList) {
        return this.axes[2].setTicksLabels(arrayList);
    }

    public Integer getZAxisSubticks() {
        return this.axes[2].getSubticks();
    }

    public GraphicObject.UpdateStatus setZAxisSubticks(Integer n) {
        return this.axes[2].setSubticks(n);
    }

    public Boolean getAutoSubticks() {
        return this.autoSubticks;
    }

    public GraphicObject.UpdateStatus setAutoSubticks(Boolean bl) {
        if (this.autoSubticks != bl) {
            this.autoSubticks = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getFontStyle() {
        return this.axes[0].getFontStyle();
    }

    public GraphicObject.UpdateStatus setFontStyle(Integer n) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        for (int i = 0; i < this.axes.length; ++i) {
            GraphicObject.UpdateStatus updateStatus2 = this.axes[i].setFontStyle(n);
            if (updateStatus2 != GraphicObject.UpdateStatus.Success) continue;
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Double getFontSize() {
        return this.axes[0].getFontSize();
    }

    public GraphicObject.UpdateStatus setFontSize(Double d) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        for (int i = 0; i < this.axes.length; ++i) {
            GraphicObject.UpdateStatus updateStatus2 = this.axes[i].setFontSize(d);
            if (updateStatus2 != GraphicObject.UpdateStatus.Success) continue;
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer getFontColor() {
        return this.axes[0].getFontColor();
    }

    public GraphicObject.UpdateStatus setFontColor(Integer n) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        for (int i = 0; i < this.axes.length; ++i) {
            GraphicObject.UpdateStatus updateStatus2 = this.axes[i].setFontColor(n);
            if (updateStatus2 != GraphicObject.UpdateStatus.Success) continue;
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Boolean getFontFractional() {
        return this.axes[0].getFontFractional();
    }

    public GraphicObject.UpdateStatus setFontFractional(Boolean bl) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        for (int i = 0; i < this.axes.length; ++i) {
            GraphicObject.UpdateStatus updateStatus2 = this.axes[i].setFontFractional(bl);
            if (updateStatus2 != GraphicObject.UpdateStatus.Success) continue;
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Double[] getAxesBounds() {
        Double[] doubleArray = new Double[]{this.axesBounds[0], this.axesBounds[1], this.axesBounds[2], this.axesBounds[3]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setAxesBounds(Double[] doubleArray) {
        if (this.axesBounds[0] != doubleArray[0] || this.axesBounds[1] != doubleArray[1] || this.axesBounds[2] != doubleArray[2] || this.axesBounds[3] != doubleArray[3]) {
            this.axesBounds[0] = doubleArray[0];
            this.axesBounds[1] = doubleArray[1];
            this.axesBounds[2] = doubleArray[2];
            this.axesBounds[3] = doubleArray[3];
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getHiddenColor() {
        return this.hiddenColor;
    }

    public GraphicObject.UpdateStatus setHiddenColor(Integer n) {
        if (this.hiddenColor != n) {
            this.hiddenColor = n;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Line getLine() {
        return this.line;
    }

    public Boolean getLineMode() {
        return this.line.getMode();
    }

    public GraphicObject.UpdateStatus setLineMode(Boolean bl) {
        return this.line.setMode(bl);
    }

    public Integer getLineStyle() {
        return this.line.getLineStyle().asScilabIndex();
    }

    public GraphicObject.UpdateStatus setLineStyle(Integer n) {
        return this.line.setLineStyle(Line.LineType.fromScilabIndex(n));
    }

    public Double getLineThickness() {
        return this.line.getThickness();
    }

    public GraphicObject.UpdateStatus setLineThickness(Double d) {
        return this.line.setThickness(d);
    }

    public Integer getLineColor() {
        return this.line.getColor();
    }

    public GraphicObject.UpdateStatus setLineColor(Integer n) {
        return this.line.setColor(n);
    }

    public Boolean getMarkMode() {
        return this.mark.getMode();
    }

    public GraphicObject.UpdateStatus setMarkMode(Boolean bl) {
        return this.mark.setMode(bl);
    }

    public Integer getMarkStyle() {
        return this.mark.getStyle();
    }

    public GraphicObject.UpdateStatus setMarkStyle(Integer n) {
        return this.mark.setStyle(n);
    }

    public Integer getMarkSize() {
        return this.mark.getSize();
    }

    public GraphicObject.UpdateStatus setMarkSize(Integer n) {
        return this.mark.setSize(n);
    }

    public Integer getMarkSizeUnit() {
        return this.mark.getMarkSizeUnit().ordinal();
    }

    public GraphicObject.UpdateStatus setMarkSizeUnit(Integer n) {
        return this.mark.setMarkSizeUnit(Mark.MarkSizeUnitType.intToEnum(n));
    }

    public Integer getMarkForeground() {
        return this.mark.getForeground();
    }

    public GraphicObject.UpdateStatus setMarkForeground(Integer n) {
        return this.mark.setForeground(n);
    }

    public Integer getMarkBackground() {
        return this.mark.getBackground();
    }

    public GraphicObject.UpdateStatus setMarkBackground(Integer n) {
        return this.mark.setBackground(n);
    }

    public Integer getClipState() {
        return this.clipProperty.getClipState().ordinal();
    }

    public GraphicObject.UpdateStatus setClipState(Integer n) {
        return this.clipProperty.setClipState(ClippableProperty.ClipStateType.intToEnum(n));
    }

    public Double[] getClipBox() {
        return this.clipProperty.getClipBox();
    }

    public GraphicObject.UpdateStatus setClipBox(Double[] doubleArray) {
        return this.clipProperty.setClipBox(doubleArray);
    }

    public Boolean getClipBoxSet() {
        return this.clipProperty.getClipBoxSet();
    }

    public GraphicObject.UpdateStatus setClipBoxSet(Boolean bl) {
        return this.clipProperty.setClipBoxSet(bl);
    }

    public Integer getArcDrawingMethod() {
        return this.arcDrawingMethod.ordinal();
    }

    public GraphicObject.UpdateStatus setArcDrawingMethod(Integer n) {
        Arc.ArcDrawingMethod arcDrawingMethod = Arc.ArcDrawingMethod.intToEnum(n);
        if (this.arcDrawingMethod != arcDrawingMethod) {
            this.arcDrawingMethod = arcDrawingMethod;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Box getBox() {
        return this.box;
    }

    public GraphicObject.UpdateStatus setBox(Box box) {
        this.box = box;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getBoxType() {
        return this.getBoxTypeAsEnum().ordinal();
    }

    public Box.BoxType getBoxTypeAsEnum() {
        return this.box.getBox();
    }

    public GraphicObject.UpdateStatus setBoxType(Integer n) {
        return this.setBoxTypeAsEnum(Box.BoxType.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setBoxTypeAsEnum(Box.BoxType boxType) {
        return this.box.setBox(boxType);
    }

    public Integer getHiddenAxisColor() {
        return this.box.getHiddenAxisColor();
    }

    public GraphicObject.UpdateStatus setHiddenAxisColor(Integer n) {
        return this.box.setHiddenAxisColor(n);
    }

    public Boolean getXTightLimits() {
        return this.box.getXTightLimits();
    }

    public Boolean getYTightLimits() {
        return this.box.getYTightLimits();
    }

    public Boolean getZTightLimits() {
        return this.box.getZTightLimits();
    }

    public GraphicObject.UpdateStatus setXTightLimits(Boolean bl) {
        return this.box.setXTightLimits(bl);
    }

    public GraphicObject.UpdateStatus setYTightLimits(Boolean bl) {
        return this.box.setYTightLimits(bl);
    }

    public GraphicObject.UpdateStatus setZTightLimits(Boolean bl) {
        return this.box.setZTightLimits(bl);
    }

    public Double[] getDataBounds() {
        return this.box.getDataBounds();
    }

    public GraphicObject.UpdateStatus setDataBounds(Double[] doubleArray) {
        return this.box.setDataBounds(doubleArray);
    }

    public Double[] getRealDataBounds() {
        return this.box.getRealDataBounds();
    }

    public GraphicObject.UpdateStatus setRealDataBounds(Double[] doubleArray) {
        return this.box.setRealDataBounds(doubleArray);
    }

    public double[][] getScaleTranslateFactors() {
        Double[] doubleArray = this.getMaximalDisplayedBounds();
        double[][] dArrayArray = new double[][]{{2.0 / (doubleArray[1] - doubleArray[0]), 2.0 / (doubleArray[3] - doubleArray[2]), 2.0 / (doubleArray[5] - doubleArray[4])}, {-(doubleArray[1] + doubleArray[0]) / (doubleArray[1] - doubleArray[0]), -(doubleArray[3] + doubleArray[2]) / (doubleArray[3] - doubleArray[2]), -(doubleArray[5] + doubleArray[4]) / (doubleArray[5] - doubleArray[4])}};
        return dArrayArray;
    }

    public Double[] getCorrectedBounds() {
        if (this.getZoomEnabled().booleanValue()) {
            Double[] doubleArray = this.getCorrectZoomBox();
            double[][] dArray = this.getScaleTranslateFactors();
            doubleArray[0] = doubleArray[0] * dArray[0][0] + dArray[1][0];
            doubleArray[1] = doubleArray[1] * dArray[0][0] + dArray[1][0];
            doubleArray[2] = doubleArray[2] * dArray[0][1] + dArray[1][1];
            doubleArray[3] = doubleArray[3] * dArray[0][1] + dArray[1][1];
            doubleArray[4] = doubleArray[4] * dArray[0][2] + dArray[1][2];
            doubleArray[5] = doubleArray[5] * dArray[0][2] + dArray[1][2];
            return doubleArray;
        }
        return new Double[]{-1.0, 1.0, -1.0, 1.0, -1.0, 1.0};
    }

    public Double[] getDisplayedBounds() {
        if (this.getZoomEnabled().booleanValue()) {
            return this.getCorrectZoomBox();
        }
        return this.getMaximalDisplayedBounds();
    }

    public Double[] getMaximalDisplayedBounds() {
        Double[] doubleArray;
        double d;
        boolean bl;
        Double[] doubleArray2 = this.getDataBounds();
        boolean bl2 = bl = doubleArray2[0].doubleValue() == doubleArray2[1].doubleValue();
        if (this.getXAxisLogFlag().booleanValue()) {
            if (bl) {
                doubleArray2[0] = Math.log10(doubleArray2[0]) - 1.0;
                doubleArray2[1] = doubleArray2[0] + 2.0;
            } else {
                doubleArray2[0] = Math.log10(doubleArray2[0]);
                doubleArray2[1] = Math.log10(doubleArray2[1]);
            }
        } else if (bl) {
            d = this.getIncrement(doubleArray2[0]);
            doubleArray = doubleArray2;
            Double.valueOf(doubleArray[0] - d);
            doubleArray = doubleArray2;
            Double.valueOf(doubleArray[1] + d);
        }
        if (this.getXAxisLocationAsEnum() == AxisProperty.AxisLocation.ORIGIN) {
            if (0.0 < doubleArray2[0]) {
                doubleArray2[0] = 0.0;
            } else if (doubleArray2[1] < 0.0) {
                doubleArray2[1] = 0.0;
            }
        }
        boolean bl3 = bl = doubleArray2[2].doubleValue() == doubleArray2[3].doubleValue();
        if (this.getYAxisLogFlag().booleanValue()) {
            if (bl) {
                doubleArray2[2] = Math.log10(doubleArray2[2]) - 1.0;
                doubleArray2[3] = doubleArray2[2] + 2.0;
            } else {
                doubleArray2[2] = Math.log10(doubleArray2[2]);
                doubleArray2[3] = Math.log10(doubleArray2[3]);
            }
        } else if (bl) {
            d = this.getIncrement(doubleArray2[2]);
            doubleArray = doubleArray2;
            Double.valueOf(doubleArray[2] - d);
            doubleArray = doubleArray2;
            Double.valueOf(doubleArray[3] + d);
        }
        if (this.getYAxisLocationAsEnum() == AxisProperty.AxisLocation.ORIGIN) {
            if (0.0 < doubleArray2[2]) {
                doubleArray2[2] = 0.0;
            } else if (doubleArray2[3] < 0.0) {
                doubleArray2[3] = 0.0;
            }
        }
        boolean bl4 = bl = doubleArray2[4].doubleValue() == doubleArray2[5].doubleValue();
        if (this.getZAxisLogFlag().booleanValue()) {
            if (bl) {
                doubleArray2[4] = Math.log10(doubleArray2[4]) - 1.0;
                doubleArray2[5] = doubleArray2[4] + 2.0;
            } else {
                doubleArray2[4] = Math.log10(doubleArray2[4]);
                doubleArray2[5] = Math.log10(doubleArray2[5]);
            }
        } else if (bl) {
            d = this.getIncrement(doubleArray2[4]);
            doubleArray = doubleArray2;
            Double.valueOf(doubleArray[4] - d);
            doubleArray = doubleArray2;
            Double.valueOf(doubleArray[5] + d);
        }
        if (!this.getXTightLimits().booleanValue()) {
            this.round(doubleArray2, 0);
        }
        if (!this.getYTightLimits().booleanValue()) {
            this.round(doubleArray2, 2);
        }
        if (!this.getZTightLimits().booleanValue()) {
            this.round(doubleArray2, 4);
        }
        return doubleArray2;
    }

    private final double getIncrement(double d) {
        int n = (int)(((Double.doubleToLongBits(d) & 0x7FF0000000000000L) >> 52) - 1023L);
        return Math.pow(2.0, Math.max(0, n - 52));
    }

    private void round(Double[] doubleArray, int n) {
        double d;
        double d2 = (doubleArray[n + 1] - doubleArray[n]) / 5.0;
        double d3 = d2 / (d = Math.pow(10.0, Math.floor(Math.log10(d2))));
        d3 = d3 < 2.0 ? 1.0 : (d3 < 5.0 ? 2.0 : 5.0);
        double d4 = d3 * d;
        doubleArray[n] = d4 * Math.floor(doubleArray[n] / d4);
        doubleArray[n + 1] = d4 * Math.ceil(doubleArray[n + 1] / d4);
        if (Math.abs((doubleArray[n] - doubleArray[n + 1]) / Math.max(doubleArray[n], doubleArray[n + 1])) < 2.0 * Math.ulp(1.0)) {
            double d5 = this.getIncrement(doubleArray[n]);
            doubleArray[n + 1] = doubleArray[n] + d5;
            doubleArray[n] = doubleArray[n] - d5;
        }
    }

    public Boolean getZoomEnabled() {
        return this.box.getZoomEnabled();
    }

    public GraphicObject.UpdateStatus setZoomEnabled(Boolean bl) {
        return this.box.setZoomEnabled(bl);
    }

    public Double[] getZoomBox() {
        return this.box.getZoomBox();
    }

    public Double[] getCorrectZoomBox() {
        Double[] doubleArray = this.getZoomBox();
        if (this.getXAxisLogFlag().booleanValue()) {
            doubleArray[0] = Math.log10(doubleArray[0]);
            doubleArray[1] = Math.log10(doubleArray[1]);
        }
        if (this.getYAxisLogFlag().booleanValue()) {
            doubleArray[2] = Math.log10(doubleArray[2]);
            doubleArray[3] = Math.log10(doubleArray[3]);
        }
        if (this.getZAxisLogFlag().booleanValue()) {
            doubleArray[4] = Math.log10(doubleArray[4]);
            doubleArray[5] = Math.log10(doubleArray[5]);
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setZoomBox(Double[] doubleArray) {
        return this.box.setZoomBox(doubleArray);
    }

    public Boolean getAutoScale() {
        return this.box.getAutoScale();
    }

    public Boolean getAutoStretch() {
        return this.box.getAutoStretch();
    }

    public GraphicObject.UpdateStatus setAutoScale(Boolean bl) {
        return this.box.setAutoScale(bl);
    }

    public GraphicObject.UpdateStatus setAutoStretch(Boolean bl) {
        return this.box.setAutoStretch(bl);
    }

    public Boolean getFirstPlot() {
        return this.box.getFirstPlot();
    }

    public GraphicObject.UpdateStatus setFirstPlot(Boolean bl) {
        return this.box.setFirstPlot(bl);
    }

    public Camera getCamera() {
        return this.camera;
    }

    public GraphicObject.UpdateStatus setCamera(Camera camera) {
        if (this.camera.equals(camera)) {
            this.camera = camera;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getView() {
        return this.getViewAsEnum().ordinal();
    }

    public Camera.ViewType getViewAsEnum() {
        return this.camera.getView();
    }

    public GraphicObject.UpdateStatus setView(Integer n) {
        return this.setViewAsEnum(Camera.ViewType.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setViewAsEnum(Camera.ViewType viewType) {
        return this.camera.setView(viewType);
    }

    public GraphicObject.UpdateStatus setScale(double d, double d2, double d3) {
        this.axesScale[0] = d;
        this.axesScale[1] = d2;
        this.axesScale[2] = d3;
        return GraphicObject.UpdateStatus.Success;
    }

    public double[] getScale() {
        return this.axesScale;
    }

    public Boolean getIsoview() {
        return this.camera.getIsoview();
    }

    public GraphicObject.UpdateStatus setIsoview(Boolean bl) {
        return this.camera.setIsoview(bl);
    }

    public Boolean getCubeScaling() {
        return this.camera.getCubeScaling();
    }

    public GraphicObject.UpdateStatus setCubeScaling(Boolean bl) {
        return this.camera.setCubeScaling(bl);
    }

    public Double[] getRotationAngles() {
        return this.camera.getRotationAngles();
    }

    public GraphicObject.UpdateStatus setRotationAngles(Double[] doubleArray) {
        if (this.camera.setRotationAngles(doubleArray)) {
            try {
                GraphicController graphicController = GraphicController.getController();
                Figure figure = (Figure)graphicController.getObjectFromId(this.getParentFigure());
                if (figure.getRotationAsEnum().equals((Object)Figure.RotationType.MULTIPLE)) {
                    for (Integer n : figure.getChildren()) {
                        if (n == null || 1 != (Integer)graphicController.getProperty(n, 29)) continue;
                        graphicController.setProperty(n, 170, doubleArray);
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double[] getRotationAngles3d() {
        return this.camera.getRotationAngles3d();
    }

    public GraphicObject.UpdateStatus setRotationAngles3d(Double[] doubleArray) {
        return this.camera.setRotationAngles3d(doubleArray);
    }

    public Boolean getFilled() {
        return this.filled;
    }

    public GraphicObject.UpdateStatus setFilled(Boolean bl) {
        if (this.filled != bl) {
            this.filled = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getBackground() {
        return this.background;
    }

    public GraphicObject.UpdateStatus setBackground(Integer n) {
        if (this.background != n) {
            this.background = n;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getGridPosition() {
        return this.getGridPositionAsEnum().ordinal();
    }

    public GridPosition getGridPositionAsEnum() {
        return this.gridPosition;
    }

    public GraphicObject.UpdateStatus setGridPosition(Integer n) {
        return this.setGridPositionAsEnum(GridPosition.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setGridPositionAsEnum(GridPosition gridPosition) {
        if (this.gridPosition != gridPosition) {
            this.gridPosition = gridPosition;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double[] getMargins() {
        Double[] doubleArray = new Double[]{this.margins[0], this.margins[1], this.margins[2], this.margins[3]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setMargins(Double[] doubleArray) {
        if (this.margins[0] != doubleArray[0] || this.margins[1] != doubleArray[1] || this.margins[2] != doubleArray[2] || this.margins[3] != doubleArray[3]) {
            this.margins[0] = doubleArray[0];
            this.margins[1] = doubleArray[1];
            this.margins[2] = doubleArray[2];
            this.margins[3] = doubleArray[3];
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getAutoMargins() {
        return new Boolean(this.auto_margins);
    }

    public GraphicObject.UpdateStatus setAutoMargins(Boolean bl) {
        if (this.auto_margins != bl) {
            this.auto_margins = bl;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer getTitle() {
        return this.title;
    }

    public GraphicObject.UpdateStatus setTitle(Integer n) {
        if (this.title != n) {
            this.title = n;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    @Override
    public Integer getType() {
        return 1;
    }

    public static enum GridPosition {
        BACKGROUND,
        FOREGROUND;


        public static GridPosition intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return BACKGROUND;
                }
                case 1: {
                    return FOREGROUND;
                }
            }
            return null;
        }
    }

    private static enum AxesProperty {
        XAXISVISIBLE,
        XAXISFORMAT,
        XAXISSTFACTORS,
        XAXISREVERSE,
        XAXISGRIDCOLOR,
        XAXISGRIDTHICKNESS,
        XAXISGRIDSTYLE,
        XAXISLABEL,
        XAXISLOCATION,
        XAXISLOGFLAG,
        XAXISTICKS,
        XAXISAUTOTICKS,
        XAXISNUMBERTICKS,
        XAXISTICKSLOCATIONS,
        XAXISTICKSLABELS,
        XAXISTICKSINTERPRETERS,
        XAXISSUBTICKS,
        YAXISVISIBLE,
        YAXISFORMAT,
        YAXISSTFACTORS,
        YAXISREVERSE,
        YAXISGRIDCOLOR,
        YAXISGRIDTHICKNESS,
        YAXISGRIDSTYLE,
        YAXISLABEL,
        YAXISLOCATION,
        YAXISLOGFLAG,
        YAXISTICKS,
        YAXISAUTOTICKS,
        YAXISNUMBERTICKS,
        YAXISTICKSLOCATIONS,
        YAXISTICKSLABELS,
        YAXISTICKSINTERPRETERS,
        YAXISSUBTICKS,
        ZAXISVISIBLE,
        ZAXISFORMAT,
        ZAXISSTFACTORS,
        ZAXISREVERSE,
        ZAXISGRIDCOLOR,
        ZAXISGRIDTHICKNESS,
        ZAXISGRIDSTYLE,
        ZAXISLABEL,
        ZAXISLOCATION,
        ZAXISLOGFLAG,
        ZAXISTICKS,
        ZAXISAUTOTICKS,
        ZAXISNUMBERTICKS,
        ZAXISTICKSLOCATIONS,
        ZAXISTICKSLABELS,
        ZAXISTICKSINTERPRETERS,
        ZAXISSUBTICKS,
        AUTOSUBTICKS,
        FONT_STYLE,
        FONT_SIZE,
        FONT_COLOR,
        FONT_FRACTIONAL,
        GRIDPOSITION,
        TITLE,
        AUTOCLEAR,
        FILLED,
        BACKGROUND,
        MARGINS,
        AUTO_MARGINS,
        AXESBOUNDS,
        HIDDENCOLOR,
        COLORMAP,
        COLORMAPSIZE;

    }
}

