/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.DefaultSearchEngine;
import com.sun.java.help.search.QueryEngine;
import java.util.Locale;
import javax.help.search.SearchEngine;
import javax.help.search.SearchQuery;

public class DefaultSearchQuery
extends SearchQuery
implements Runnable {
    private Thread thread = null;
    private DefaultSearchEngine dhs;
    private static final boolean debugFlag = false;

    public DefaultSearchQuery(SearchEngine hs) {
        super(hs);
        if (hs instanceof DefaultSearchEngine) {
            this.dhs = (DefaultSearchEngine)hs;
        }
    }

    public void start(String searchparams, Locale l) throws IllegalArgumentException, IllegalStateException {
        DefaultSearchQuery.debug("Starting Search");
        if (this.isActive()) {
            throw new IllegalStateException();
        }
        super.start(searchparams, l);
        this.thread = new Thread((Runnable)this, "QueryThread");
        this.thread.start();
    }

    public void stop() throws IllegalArgumentException, IllegalStateException {
        DefaultSearchQuery.debug("Stop Search");
    }

    public boolean isActive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }

    public void run() throws IllegalArgumentException {
        QueryEngine qe = this.dhs.getQueryEngine();
        try {
            qe.processQuery(this.searchparams, this.l, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException();
        }
        this.fireSearchFinished();
        this.thread = null;
    }

    private static void debug(String str) {
    }
}

