/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import com.sun.java.help.impl.MyBufferedReader;
import com.sun.java.help.impl.ScanBuffer;
import com.sun.java.help.impl.TagProperties;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public abstract class DocumentParser {
    static final char EOF = '\uffff';
    protected Reader source;
    int readOffset;
    ScanBuffer buffer;
    ScanBuffer escapeBuffer;
    ScanBuffer documentSource;
    boolean shouldCacheSource;
    Hashtable entities;
    int defaultCharBufferSize = 8192;
    char[] cb = new char[this.defaultCharBufferSize];
    int mySize = 0;
    int myCount = 0;

    public DocumentParser(InputStream in) {
        this.source = new MyBufferedReader(new InputStreamReader(in));
        this.init();
    }

    public DocumentParser(Reader src) {
        this.source = src instanceof MyBufferedReader ? src : new MyBufferedReader(src);
        this.init();
    }

    public void setInput(Reader src) {
        this.source = src instanceof MyBufferedReader ? src : new MyBufferedReader(src);
    }

    public void setInput(InputStream i, String encoding) throws UnsupportedEncodingException {
        if (i == null) {
            this.source = null;
            return;
        }
        this.source = new MyBufferedReader(new InputStreamReader(i, encoding));
    }

    public void setShouldCacheSource(boolean state) {
        this.shouldCacheSource = state;
    }

    public String getDocumentSource() {
        if (!this.shouldCacheSource) {
            return null;
        }
        int offset = 0 == this.documentSource.length() ? 0 : this.documentSource.length() - 1;
        return new String(this.documentSource.buf, 0, offset) + "\n";
    }

    public void parse() throws IOException {
        int c = 65535;
        this.buffer.clear();
        if (this.source != null) {
            c = this.readChar();
        }
        while (c != 65535) {
            if (c == 38) {
                c = this.parseEscape();
                continue;
            }
            if (c == 60) {
                this.buffer.flush(this);
                c = this.parseTag();
                continue;
            }
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] x = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, x, 0, this.buffer.buf.length);
                this.buffer.buf = x;
            }
            if (c != 13) {
                this.buffer.buf[this.buffer.buflen++] = c;
            }
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::parse() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException e) {
                    throw e;
                }
                catch (IOException e) {
                    break;
                }
            }
            if (this.shouldCacheSource) {
                this.documentSource.add(this.cb[this.myCount]);
            }
            c = this.cb[this.myCount++];
        }
        this.buffer.flush(this);
    }

    public void parseText() throws IOException {
        this.tag("PRE", null, false, false);
        this.buffer.clear();
        char c = this.readChar();
        while (c != '\uffff') {
            this.buffer.add(c);
            c = this.readChar();
        }
        this.buffer.flush(this);
    }

    protected void callFlush(char[] buf, int offset, int length) {
        this.flush(buf, offset, length);
    }

    protected abstract void flush(char[] var1, int var2, int var3);

    protected abstract void comment(String var1);

    protected abstract void tag(String var1, TagProperties var2, boolean var3, boolean var4);

    protected abstract void pi(String var1, String var2);

    protected abstract void doctype(String var1, String var2, String var3);

    protected abstract String documentAttribute(String var1);

    protected abstract void errorString(String var1);

    private void init() {
        this.buffer = new ScanBuffer(8192, 4);
        this.escapeBuffer = new ScanBuffer(8192, 4);
        this.documentSource = new ScanBuffer(8192, 4);
        this.readOffset = 0;
    }

    protected void findCloseAngleForComment(char c) throws IOException {
        this.buffer.add(c);
        while ((c = this.readChar()) != '>') {
            this.buffer.add(c);
        }
        this.buffer.add(c);
        this.comment(this.buffer.extract(0));
        this.buffer.clear();
    }

    protected char handleCommentOrDoctype(char c) throws IOException {
        this.buffer.add(c);
        int offset = this.buffer.length();
        c = this.scanIdentifier(c);
        String name = this.buffer.extract(offset);
        if (!name.equals("DOCTYPE")) {
            this.findCloseAngleForComment(c);
            return this.readChar();
        }
        c = this.skipWhite(c);
        offset = this.buffer.length();
        c = this.scanIdentifier(c);
        String root = this.buffer.extract(offset);
        if ((c = this.skipWhite(c)) == '>') {
            this.buffer.clear();
            return this.readChar();
        }
        offset = this.buffer.length();
        c = this.scanIdentifier(c);
        name = this.buffer.extract(offset);
        String publicId = null;
        String systemId = null;
        if (name.equals("SYSTEM")) {
            c = this.skipWhite(c);
            offset = this.buffer.length();
            c = this.scanQuotedString(c);
            systemId = this.buffer.extract(offset);
            this.doctype(root, null, systemId);
            if (c != '>') {
                this.findCloseAngleForComment(c);
            }
            this.buffer.clear();
            return this.readChar();
        }
        if (name.equals("PUBLIC")) {
            c = this.skipWhite(c);
            offset = this.buffer.length();
            c = this.scanQuotedString(c);
            publicId = this.buffer.extract(offset);
            c = this.skipWhite(c);
            offset = this.buffer.length();
            c = this.scanQuotedString(c);
            systemId = this.buffer.extract(offset);
            this.doctype(root, publicId, systemId);
            if (c != '>') {
                this.findCloseAngleForComment(c);
            }
            this.buffer.clear();
            return this.readChar();
        }
        if (c != '>') {
            this.findCloseAngleForComment(c);
        }
        this.findCloseAngleForComment(c);
        this.doctype(root, null, null);
        this.buffer.clear();
        return this.readChar();
    }

    protected void setXmlEntities(TagProperties attr) {
    }

    protected char parseTag() throws IOException {
        boolean emptyTag;
        boolean endTag;
        int resetPos;
        this.buffer.clear();
        boolean tagStartOffset = false;
        char c = '<';
        this.buffer.add('<');
        c = this.readChar();
        if (c == '!') {
            resetPos = 0;
            this.buffer.add('!');
            c = this.readChar();
            if (c != '-') {
                return this.handleCommentOrDoctype(c);
            }
            this.buffer.add(c);
            c = this.readChar();
            if (c != '-') {
                this.findCloseAngleForComment(c);
                return this.readChar();
            }
            this.buffer.add(c);
            resetPos = this.buffer.length();
            int nDash = 0;
            while (true) {
                if ((c = this.readChar()) == '\uffff') {
                    this.commentEOFError(resetPos);
                    break;
                }
                if (c != '-') {
                    this.buffer.add(c);
                    continue;
                }
                while (c == '-') {
                    this.buffer.add(c);
                    ++nDash;
                    c = this.readChar();
                }
                if (c == '\uffff') {
                    this.commentEOFError(resetPos);
                    break;
                }
                this.buffer.add(c);
                if (nDash >= 2 && c == '>') {
                    this.comment(this.buffer.extract(0));
                    this.buffer.clear();
                    return this.readChar();
                }
                nDash = 0;
            }
        }
        if (c == '?') {
            resetPos = 0;
            StringBuffer target = new StringBuffer();
            this.buffer.add('?');
            while ((c = this.readChar()) != '\"' && c != ' ' && c != '\t' && c != '\n' && c != '>') {
                this.buffer.add(c);
                target.append(c);
            }
            if (!target.toString().equals("xml")) {
                this.buffer.clear();
                while ((c = this.readChar()) != '?' && c != '\uffff') {
                    this.buffer.add(c);
                }
                if (c == '\uffff') {
                    this.eofError();
                    return this.readChar();
                }
                c = this.readChar();
                if (c != '>' && c != '\uffff') {
                    this.buffer.add('?');
                    this.buffer.add(c);
                }
                if (c == '\uffff') {
                    this.eofError();
                    return this.readChar();
                }
                this.pi(target.toString(), this.buffer.extract(0));
                return this.readChar();
            }
            target = null;
            c = this.readChar();
            TagProperties attributes = null;
            while (true) {
                String attvalue;
                if ((c = this.skipWhite(c)) == '\uffff') {
                    this.eofError();
                    return c;
                }
                if (c == '?') break;
                int offset = this.buffer.length();
                c = this.scanIdentifier(c);
                if (offset == this.buffer.length()) {
                    this.error("Expecting an attribute");
                    this.skipToCloseAngle(c);
                    return this.readChar();
                }
                String attname = this.buffer.extract(offset);
                c = this.skipWhite(c);
                if (attributes == null) {
                    attributes = new TagProperties();
                }
                if (c == '=') {
                    int voff;
                    this.buffer.add(c);
                    c = this.readChar();
                    c = this.skipWhite(c);
                    if (c == '?' || c == '<') {
                        attvalue = "";
                    } else if (c == '\"') {
                        this.buffer.add(c);
                        voff = this.buffer.length();
                        while (true) {
                            if ((c = this.readChar()) == '\uffff') {
                                this.eofError();
                                return c;
                            }
                            if (c == '\"') break;
                            if (c == '&') {
                                c = this.parseEscape();
                            }
                            this.buffer.add(c);
                        }
                        attvalue = this.buffer.extract(voff);
                        this.buffer.add(c);
                        c = this.readChar();
                    } else {
                        voff = this.buffer.length();
                        this.buffer.add(c);
                        while (true) {
                            if ((c = this.readChar()) == '\uffff') {
                                this.eofError();
                                return c;
                            }
                            if (c == 34 || c == 32 || c == 9 || c == 10 || c == '?') break;
                            if (c == '&') {
                                c = this.parseEscape();
                            }
                            this.buffer.add(c);
                        }
                        attvalue = this.buffer.extract(voff);
                    }
                } else {
                    attvalue = "true";
                }
                attributes.put(attname, attvalue);
            }
            c = this.readChar();
            if (c == '\uffff') {
                this.eofError();
                return this.readChar();
            }
            c = this.skipWhite(c);
            this.buffer.add(c);
            if (c == '>') {
                this.setXmlEntities(attributes);
                this.buffer.clear();
                return this.readChar();
            }
            this.error("Expecting ?>");
            this.skipToCloseAngle(c);
            return this.readChar();
        }
        if ((c = this.skipWhite(c)) == '\uffff') {
            this.eofError();
            return c;
        }
        if (c == '/') {
            this.buffer.add(c);
            c = this.skipWhite(this.readChar());
            endTag = true;
            emptyTag = false;
        } else {
            endTag = false;
            emptyTag = false;
        }
        int offset = this.buffer.length();
        c = this.scanIdentifier(c);
        String name = this.buffer.extract(offset);
        TagProperties attributes = null;
        while (true) {
            String attvalue;
            if ((c = this.skipWhite(c)) == '\uffff') {
                this.eofError();
                return c;
            }
            if (c == '>') break;
            if (c == '/') {
                this.buffer.add(c);
                c = this.readChar();
                if (c == '>') {
                    endTag = true;
                    emptyTag = true;
                    break;
                }
                this.error("Expecting />");
                this.skipToCloseAngle(c);
                return this.readChar();
            }
            if (c == '<') {
                this.tag(name, attributes, endTag, false);
                this.buffer.clear();
                return '<';
            }
            offset = this.buffer.length();
            c = this.scanIdentifier(c);
            if (offset == this.buffer.length()) {
                this.error("Expecting an attribute (2)");
                this.skipToCloseAngle(c);
                return this.readChar();
            }
            String attname = this.buffer.extract(offset);
            c = this.skipWhite(c);
            if (attributes == null) {
                attributes = new TagProperties();
            }
            if (c == '=') {
                int voff;
                this.buffer.add(c);
                c = this.readChar();
                c = this.skipWhite(c);
                if (c == '>' || c == '<') {
                    attvalue = "";
                } else if (c == '\"') {
                    this.buffer.add(c);
                    voff = this.buffer.length();
                    while (true) {
                        if ((c = this.readChar()) == '\uffff') {
                            this.eofError();
                            return c;
                        }
                        if (c == '\"') break;
                        if (c == '&') {
                            c = this.parseEscape();
                        }
                        this.buffer.add(c);
                    }
                    attvalue = this.buffer.extract(voff);
                    this.buffer.add(c);
                    c = this.readChar();
                } else {
                    voff = this.buffer.length();
                    this.buffer.add(c);
                    while (true) {
                        if ((c = this.readChar()) == '\uffff') {
                            this.eofError();
                            return c;
                        }
                        if (c == 34 || c == 32 || c == 9 || c == 10 || c == '>') break;
                        if (c == '&') {
                            c = this.parseEscape();
                        }
                        this.buffer.add(c);
                    }
                    attvalue = this.buffer.extract(voff);
                }
            } else {
                attvalue = "true";
            }
            attributes.put(attname, attvalue);
        }
        this.tag(name, attributes, endTag, emptyTag);
        this.buffer.clear();
        return this.readChar();
    }

    protected char parseEscape() throws IOException {
        char c;
        block17: {
            int offset;
            block18: {
                block19: {
                    block15: {
                        block16: {
                            offset = this.buffer.length();
                            this.buffer.add('&');
                            c = this.readChar();
                            if (c == '\uffff') {
                                this.generateError(offset);
                                return c;
                            }
                            if (c != '#') break block16;
                            int x = 0;
                            while (true) {
                                if ((c = this.readChar()) == '\uffff') {
                                    this.generateError(offset);
                                    return c;
                                }
                                if (c == ';') {
                                    c = '\u0000';
                                    break;
                                }
                                if (!Character.isDigit(c)) {
                                    if (x > 0) break;
                                    this.error("Expecting a digit");
                                    this.generateError(offset);
                                    return c;
                                }
                                this.buffer.add(c);
                                x = x * 10 + Character.digit(c, 10);
                            }
                            this.buffer.reset(offset);
                            this.buffer.add((char)x);
                            break block17;
                        }
                        if (!Character.isLowerCase(c) && !Character.isUpperCase(c)) break block18;
                        if (this.entities == null) {
                            this.initEntities();
                        }
                        this.escapeBuffer.clear();
                        this.escapeBuffer.add(c);
                        do {
                            this.buffer.add(c);
                            c = this.readChar();
                            if (c == '\uffff') {
                                this.generateError(offset);
                                return c;
                            }
                            if (!Character.isLowerCase(c) && !Character.isUpperCase(c)) break block15;
                            this.escapeBuffer.add(c);
                        } while (this.entities.get(this.escapeBuffer.extract(0)) == null);
                        c = this.readChar();
                        if (c == ';') {
                            c = '\u0000';
                        }
                        break block19;
                    }
                    if (c == ';') {
                        c = '\u0000';
                    } else {
                        this.error("Expecting a letter");
                        this.generateError(offset);
                        return c;
                    }
                }
                String s = this.escapeBuffer.extract(0);
                this.buffer.reset(offset);
                Character x = (Character)this.entities.get(s);
                if (x != null) {
                    return x.charValue();
                }
                String a = this.documentAttribute(s);
                if (a != null) {
                    for (int i = 0; i < a.length(); ++i) {
                        this.buffer.add(a.charAt(i));
                    }
                }
                break block17;
            }
            this.error("Expecting a letter o");
            this.generateError(offset);
            return c;
        }
        if (c != '\u0000') {
            return c;
        }
        return this.readChar();
    }

    protected void initEntities() {
        this.entities = new Hashtable();
        this.entities.put("quot", new Character('\"'));
        this.entities.put("amp", new Character('&'));
        this.entities.put("gt", new Character('>'));
        this.entities.put("lt", new Character('<'));
        this.entities.put("nbsp", new Character('\u00a0'));
        this.entities.put("copy", new Character('\u00a9'));
        this.entities.put("Agrave", new Character('\u00c0'));
        this.entities.put("Aacute", new Character('\u00c1'));
        this.entities.put("Acirc", new Character('\u00c2'));
        this.entities.put("Atilde", new Character('\u00c3'));
        this.entities.put("Auml", new Character('\u00c4'));
        this.entities.put("Aring", new Character('\u00c5'));
        this.entities.put("AElig", new Character('\u00c6'));
        this.entities.put("Ccedil", new Character('\u00c7'));
        this.entities.put("Egrave", new Character('\u00c8'));
        this.entities.put("Eacute", new Character('\u00c9'));
        this.entities.put("Ecirc", new Character('\u00ca'));
        this.entities.put("Euml", new Character('\u00cb'));
        this.entities.put("Igrave", new Character('\u00cc'));
        this.entities.put("Iacute", new Character('\u00cd'));
        this.entities.put("Icirc", new Character('\u00ce'));
        this.entities.put("Iuml", new Character('\u00cf'));
        this.entities.put("Ntilde", new Character('\u00d1'));
        this.entities.put("Ograve", new Character('\u00d2'));
        this.entities.put("Oacute", new Character('\u00d3'));
        this.entities.put("Ocirc", new Character('\u00d4'));
        this.entities.put("Otilde", new Character('\u00d5'));
        this.entities.put("Ouml", new Character('\u00d6'));
        this.entities.put("Oslash", new Character('\u00d8'));
        this.entities.put("Ugrave", new Character('\u00d9'));
        this.entities.put("Uacute", new Character('\u00da'));
        this.entities.put("Ucirc", new Character('\u00db'));
        this.entities.put("Uuml", new Character('\u00dc'));
        this.entities.put("Yacute", new Character('\u00dd'));
        this.entities.put("THORN", new Character('\u00de'));
        this.entities.put("szlig", new Character('\u00df'));
        this.entities.put("agrave", new Character('\u00e0'));
        this.entities.put("aacute", new Character('\u00e1'));
        this.entities.put("acirc", new Character('\u00e2'));
        this.entities.put("atilde", new Character('\u00e3'));
        this.entities.put("auml", new Character('\u00e4'));
        this.entities.put("aring", new Character('\u00e5'));
        this.entities.put("aelig", new Character('\u00e6'));
        this.entities.put("ccedil", new Character('\u00e7'));
        this.entities.put("egrave", new Character('\u00e8'));
        this.entities.put("eacute", new Character('\u00e9'));
        this.entities.put("ecirc", new Character('\u00ea'));
        this.entities.put("euml", new Character('\u00eb'));
        this.entities.put("igrave", new Character('\u00ec'));
        this.entities.put("iacute", new Character('\u00ed'));
        this.entities.put("icirc", new Character('\u00ee'));
        this.entities.put("iuml", new Character('\u00ef'));
        this.entities.put("eth", new Character('\u00f0'));
        this.entities.put("ntilde", new Character('\u00f1'));
        this.entities.put("ograve", new Character('\u00f2'));
        this.entities.put("oacute", new Character('\u00f3'));
        this.entities.put("ocirc", new Character('\u00f4'));
        this.entities.put("otilde", new Character('\u00f5'));
        this.entities.put("ouml", new Character('\u00f6'));
        this.entities.put("oslash", new Character('\u00f8'));
        this.entities.put("ugrave", new Character('\u00f9'));
        this.entities.put("uacute", new Character('\u00fa'));
        this.entities.put("ucirc", new Character('\u00fb'));
        this.entities.put("uuml", new Character('\u00fc'));
        this.entities.put("yacute", new Character('\u00fd'));
        this.entities.put("thorn", new Character('\u00fe'));
        this.entities.put("yuml", new Character('\u00ff'));
    }

    protected char scanIdentifier(char c) throws IOException {
        while (c == '_' || c == ':' || c >= '0' && c <= '9' || Character.isLetter(c)) {
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] x = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, x, 0, this.buffer.buf.length);
                this.buffer.buf = x;
            }
            this.buffer.buf[this.buffer.buflen++] = c;
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::scanIdentifier() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException e) {
                    throw e;
                }
                catch (IOException e) {
                    break;
                }
            }
            if (this.shouldCacheSource) {
                this.documentSource.add(this.cb[this.myCount]);
            }
            c = this.cb[this.myCount++];
        }
        return c;
    }

    protected char scanQuotedString(char c) throws IOException {
        if ((c = this.skipWhite(c)) == '\"') {
            while ((c = this.readChar()) != '\"' && c != '>') {
                this.buffer.add(c);
            }
            return this.readChar();
        }
        if (c == '\'') {
            while ((c = this.readChar()) != '\'' && c != '>') {
                this.buffer.add(c);
            }
            return this.readChar();
        }
        return c;
    }

    protected char skipWhite(char c) throws IOException {
        while (c == ' ' || c == '\r' || c == '\t' || c == '\n') {
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] x = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, x, 0, this.buffer.buf.length);
                this.buffer.buf = x;
            }
            this.buffer.buf[this.buffer.buflen++] = c;
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::parse() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException e) {
                    throw e;
                }
                catch (IOException e) {
                    break;
                }
            }
            if (this.shouldCacheSource) {
                this.documentSource.add(this.cb[this.myCount]);
            }
            c = this.cb[this.myCount++];
        }
        return c;
    }

    protected char readChar() throws IOException {
        if (this.myCount >= this.mySize) {
            try {
                this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                if (this.mySize < 0) {
                    return '\uffff';
                }
                if (this.mySize == 0) {
                    System.err.println(" DocumentParser::readChar() !!!ERROR !!! source.read(...) == 0");
                    return '\uffff';
                }
                this.myCount = 0;
            }
            catch (CharConversionException e) {
                throw e;
            }
            catch (IOException e) {
                return '\uffff';
            }
        }
        if (this.shouldCacheSource) {
            this.documentSource.add(this.cb[this.myCount]);
        }
        return this.cb[this.myCount++];
    }

    protected void skipToCloseAngle(char c) throws IOException {
        while (true) {
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] x = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, x, 0, this.buffer.buf.length);
                this.buffer.buf = x;
            }
            this.buffer.buf[this.buffer.buflen++] = c;
            if (c == '>') break;
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::skipToCloseAngle() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException e) {
                    throw e;
                }
                catch (IOException e) {
                    break;
                }
            }
            c = this.cb[this.myCount++];
        }
        this.generateError(0);
    }

    protected void generateError(int offset) {
        String s = this.buffer.extract(offset);
        this.buffer.reset(offset);
        this.buffer.flush(this);
        this.errorString(s);
    }

    protected void commentEOFError(int resetTo) {
        this.eofError();
    }

    protected void eofError() {
        this.error("Unexpected end of file");
        this.generateError(0);
    }

    void error(String s) {
        System.err.println("DocumentParser Error: " + s);
    }
}

