/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.ged;

import java.awt.Component;
import javax.swing.SwingUtilities;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.ged.GEDView;
import org.scilab.modules.gui.ged.InspectorTab;
import org.scilab.modules.gui.ged.SwapObject;
import org.scilab.modules.gui.ged.SwingInspector;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;

public class Inspector {
    private static Inspector instance;
    private static SwingInspector inspectorTab;
    private static GEDView gedView;

    public Inspector(Integer n) {
        TextBox textBox = ScilabTextBox.createTextBox();
        inspectorTab = new SwingInspector(n);
        inspectorTab.addInfoBar(textBox);
        gedView = new GEDView();
    }

    public static SwingInspector createInspectorTab(Integer n) {
        if (instance == null) {
            instance = new Inspector(n);
        }
        return inspectorTab;
    }

    public static boolean isInspectorOpened() {
        return instance != null;
    }

    public static Inspector getInspector() {
        return instance;
    }

    public static Inspector getInspector(Integer n) {
        if (instance == null) {
            boolean bl = WindowsConfigurationManager.restoreUUID("4m249547-6a71-4998-r8c-00o367s47932");
            if (!bl) {
                InspectorTab.getInspectorInstance(n);
                SwingScilabWindow swingScilabWindow = SwingScilabWindow.createWindow(true);
                swingScilabWindow.addTab(inspectorTab);
                swingScilabWindow.setLocation(0, 0);
                swingScilabWindow.setSize(300, 700);
                swingScilabWindow.setVisible(true);
            }
        } else {
            SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)inspectorTab));
            swingScilabWindow.setVisible(true);
            swingScilabWindow.toFront();
            new SwapObject(n);
        }
        return instance;
    }

    public static void closeInspector() {
        if (instance != null) {
            instance = null;
            gedView.close();
        }
    }

    public void close() {
        ClosingOperationsManager.startClosingOperationWithoutSave(inspectorTab);
        gedView.close();
    }

    public void setVisible(boolean bl) {
        inspectorTab.setVisible(bl);
    }
}

