/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.editor;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.scilab.modules.gui.datatip.DatatipCreate;
import org.scilab.modules.gui.datatip.DatatipDelete;
import org.scilab.modules.gui.datatip.DatatipDrag;
import org.scilab.modules.gui.datatip.DatatipManager;
import org.scilab.modules.gui.datatip.DatatipManagerMode;
import org.scilab.modules.gui.datatip.DatatipMove;
import org.scilab.modules.gui.datatip.DatatipOrientation;
import org.scilab.modules.gui.editor.Editor;
import org.scilab.modules.gui.editor.EditorManager;
import org.scilab.modules.gui.events.GlobalEventWatcher;
import org.scilab.modules.gui.ged.Inspector;
import org.scilab.modules.gui.plotbrowser.PlotBrowser;
import org.scilab.modules.renderer.utils.EntityPicker;

public class EditorEventListener
implements KeyListener,
MouseListener,
MouseMotionListener {
    Integer windowUid;
    Integer picked;
    EntityPicker ep;
    DatatipManagerMode datatipManagerMode;
    Integer lastDatatip = null;
    Integer[] lastClick = new Integer[2];
    boolean changeOrientation = false;
    Editor editor;
    boolean isInRotation = false;
    boolean isLeftButtonPressed = false;
    boolean enabled = false;

    public EditorEventListener(Integer n) {
        this.windowUid = n;
        this.editor = EditorManager.newEditor(n);
        this.ep = new EntityPicker();
        this.datatipManagerMode = DatatipManager.newDatatipManagerMode(n);
    }

    public void setEnable(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnable() {
        return this.enabled;
    }

    public boolean isDatatipEnable() {
        return this.datatipManagerMode.isEnabled();
    }

    public boolean canProcess() {
        return this.enabled && !GlobalEventWatcher.isActivated() && !this.datatipManagerMode.isInteractiveZoom();
    }

    public void onExit() {
        EditorManager.deleteEditor(this.editor.getFigureUid());
        DatatipManager.deleteDatatipManager(this.windowUid);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.enabled && !GlobalEventWatcher.isActivated()) {
            this.editor.onKeyPressed(keyEvent);
            if (this.datatipManagerMode.isEnabled() && this.datatipManagerMode.getSelectedTip() != null) {
                switch (keyEvent.getKeyCode()) {
                    case 39: {
                        DatatipMove.moveRight(this.datatipManagerMode.getSelectedTip());
                        break;
                    }
                    case 37: {
                        DatatipMove.moveLeft(this.datatipManagerMode.getSelectedTip());
                        break;
                    }
                    case 8: 
                    case 127: {
                        DatatipDelete.deleteDatatip(this.datatipManagerMode.getSelectedTip());
                    }
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.canProcess() && mouseEvent.getButton() == 1) {
            this.isLeftButtonPressed = true;
            if (!this.datatipManagerMode.isEnabled()) {
                this.editor.onLeftMouseDown(mouseEvent);
                if (Inspector.isInspectorOpened()) {
                    this.editor.onClickGED();
                }
                if (PlotBrowser.isPlotBrowserOpened()) {
                    PlotBrowser.getPlotBrowser(this.windowUid);
                }
            } else if (!this.datatipManagerMode.pickAndHighlight(mouseEvent.getX(), mouseEvent.getY())) {
                this.picked = this.ep.pick(this.windowUid, Integer.valueOf(mouseEvent.getX()), Integer.valueOf(mouseEvent.getY()));
                if (this.picked != null) {
                    this.lastClick[0] = mouseEvent.getX();
                    this.lastClick[1] = mouseEvent.getY();
                    this.lastDatatip = DatatipCreate.createDatatip(this.windowUid, mouseEvent.getX(), mouseEvent.getY());
                    this.changeOrientation = true;
                }
            } else {
                this.datatipManagerMode.enableTranslation(false);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.canProcess()) {
            if (!this.datatipManagerMode.isEnabled()) {
                if (mouseEvent.getButton() == 3) {
                    if (!this.isInRotation) {
                        this.editor.onRightMouseClick(mouseEvent);
                    }
                } else if (mouseEvent.getButton() == 1) {
                    this.editor.onLeftMouseRelease(mouseEvent);
                }
            } else {
                if (mouseEvent.getButton() == 3 && !this.isInRotation && !this.datatipManagerMode.pickAndDelete(mouseEvent.getX(), mouseEvent.getY())) {
                    this.datatipManagerMode.onRightMouseClick(mouseEvent);
                }
                this.datatipManagerMode.enableTranslation(true);
            }
            this.isInRotation = false;
            this.isLeftButtonPressed = false;
            this.changeOrientation = false;
            this.editor.setUpdateDrag(true);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.canProcess()) {
            if (!this.datatipManagerMode.isEnabled()) {
                if (this.isLeftButtonPressed) {
                    this.editor.onMouseDragged(mouseEvent);
                } else {
                    this.isInRotation = true;
                }
            } else if (this.changeOrientation) {
                Integer[] integerArray = new Integer[]{mouseEvent.getX(), mouseEvent.getY()};
                DatatipOrientation.setOrientation(this.lastDatatip, this.lastClick, integerArray);
            } else if (this.datatipManagerMode.getSelectedTip() != null && this.isLeftButtonPressed) {
                DatatipDrag.dragDatatip(this.datatipManagerMode.getSelectedTip(), mouseEvent.getX(), mouseEvent.getY());
            }
            this.editor.setUpdateDrag(false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

