/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.util.Set;
import org.scilab.modules.commons.xml.XConfigurationEvent;
import org.scilab.modules.commons.xml.XConfigurationListener;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.SciNotesOptions;

public class SciNotesConfiguration
implements XConfigurationListener {
    public void configurationChanged(XConfigurationEvent xConfigurationEvent) {
        Conf conf = new Conf(xConfigurationEvent.getModifiedPaths());
        if (conf.changed()) {
            SciNotesOptions.invalidate(conf);
            SciNotes.configurationChanged(conf);
        }
    }

    public static class Conf {
        public boolean preferences;
        public boolean display;
        public boolean autosave;
        public boolean colors;
        public boolean systemfont;
        public boolean font;
        public boolean keymap;
        public boolean header;

        public Conf(Set<String> set) {
            if (set.contains("ALL")) {
                this.preferences = true;
                this.display = true;
                this.autosave = true;
                this.colors = true;
                this.systemfont = true;
                this.font = true;
                this.keymap = true;
                this.header = true;
            } else {
                this.preferences = set.contains("//scinotes/body/scinotes-preferences");
                this.display = set.contains("//scinotes/display/body/scinotes-display");
                this.autosave = set.contains("//scinotes/autosave/body/scinotes-autosave");
                this.colors = set.contains("//colors/body/syntax-highlighting-colors/item");
                this.systemfont = set.contains("//fonts/body/fonts");
                this.font = set.contains("//fonts/body/fonts/item[@xconf-uid=\"scinotes-font\"]");
                this.keymap = set.contains("//general/shortcuts/body/actions/action-folder[@xconf-uid=\"scinotes\"]/action");
                this.header = set.contains("//scinotes/header/body/scinotes-header");
            }
        }

        public boolean changed() {
            return this.preferences || this.display || this.autosave || this.colors || this.systemfont || this.font || this.keymap || this.header;
        }
    }
}

