/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import org.scilab.modules.scinotes.IndentScanner;
import org.scilab.modules.scinotes.ScilabDocument;

public class IndentManager {
    private ScilabDocument doc;
    private Element elem;
    private IndentScanner scanner;
    private char indentChar = (char)32;
    private int num = 4;
    private boolean isPsychoRigid = true;

    public IndentManager(ScilabDocument scilabDocument) {
        this.doc = scilabDocument;
        this.elem = scilabDocument.getDefaultRootElement();
        this.scanner = new IndentScanner(scilabDocument);
    }

    public void setProperties(char c, int n, boolean bl) {
        this.indentChar = c;
        this.num = c != '\t' ? n : 1;
        this.isPsychoRigid = bl;
    }

    public void setProperties(char c, int n) {
        this.setProperties(c, n, this.isPsychoRigid);
    }

    public void setPsychoRigidMode(boolean bl) {
        this.isPsychoRigid = bl;
    }

    public int[] indentDoc(int n, int n2) {
        try {
            int n3;
            if (n > n2) {
                n2 = n;
            }
            int[] nArray = new int[2];
            int n4 = this.elem.getElementIndex(n);
            int n5 = this.elem.getElementIndex(n2);
            int[] nArray2 = new int[n5 - n4 + 1];
            int[] nArray3 = new int[2];
            int[] nArray4 = new int[2];
            this.getNums(n4 - 1, nArray4);
            if (n4 > 0) {
                this.scanner.getIndentLevel(this.elem.getElement(n4 - 1).getStartOffset(), nArray);
                nArray2[0] = nArray4[1] + nArray[1] * this.num;
            }
            for (int i = 0; i <= n5 - n4; ++i) {
                int n6 = this.elem.getElement(i + n4).getEndOffset() - 1;
                this.scanner.getIndentLevel(n6, nArray);
                nArray2[i] = Math.max(nArray2[i] - nArray[0] * this.num, 0);
                if (i == n5 - n4) continue;
                nArray2[i + 1] = nArray2[i] + nArray[1] * this.num;
            }
            Segment segment = new Segment();
            StringBuffer stringBuffer = new StringBuffer();
            int n7 = n;
            for (n3 = n4; n3 <= n5; ++n3) {
                int n8;
                n7 = n3 < n5 ? this.elem.getElement(n3).getEndOffset() : this.elem.getElement(n3).getEndOffset() - 1;
                if (n7 - (n8 = this.elem.getElement(n3).getStartOffset() + this.scanner.getTabsAtBeginning(n3)) + 1 == 0) {
                    n7 = n8;
                }
                this.doc.getText(n8, n7 - n8, segment);
                nArray3[0] = n;
                if (n7 > n8 + 1) {
                    char[] cArray = new char[nArray2[n3 - n4]];
                    for (int i = 0; i < cArray.length; ++i) {
                        cArray[i] = this.indentChar;
                    }
                    stringBuffer.append(cArray);
                    if (n3 == n4) {
                        nArray3[0] = n + cArray.length - this.scanner.getTabsAtBeginning(n3);
                    }
                }
                stringBuffer.append(segment.array, segment.offset, segment.count);
            }
            n3 = this.elem.getElement(n4).getStartOffset();
            this.doc.replace(n3, n7 - n3, stringBuffer.toString(), null);
            nArray3[1] = n3 + stringBuffer.length() - (n7 - n2 - 1);
            return nArray3;
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
            return null;
        }
    }

    public void indentDoc(int n) {
        if (this.doc.getAutoIndent()) {
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            try {
                Object[] objectArray;
                int n2;
                int n3 = this.elem.getElementIndex(n);
                int n4 = this.elem.getElement(n3).getEndOffset() - 1;
                this.scanner.getIndentLevel(n4, nArray);
                int n5 = 0;
                if (n3 >= 0) {
                    this.getNums(n3, nArray2);
                    if (nArray[0] > 0 && nArray2[0] <= nArray2[1]) {
                        n5 = nArray[0] * this.num;
                        if (n3 > 0 && nArray2[0] == nArray2[1]) {
                            n2 = this.elem.getElement(n3 - 1).getEndOffset() - 1;
                            objectArray = new int[2];
                            this.scanner.getIndentLevel(n2, (int[])objectArray);
                            if (objectArray[1] != '\u0000') {
                                n5 = 0;
                            }
                        }
                        if (nArray2[1] < n5) {
                            n5 = nArray2[1];
                        }
                        if (n5 != 0) {
                            n2 = this.elem.getElement(n3).getStartOffset();
                            this.doc.remove(n2, n5);
                        }
                    }
                }
                n2 = nArray2[1] + nArray[1] * this.num - n5;
                objectArray = new char[n2];
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = this.indentChar;
                }
                this.doc.insertString(n4 + 1 - n5, new String((char[])objectArray), null);
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException);
            }
        }
    }

    public IndentScanner getIndentScanner() {
        return this.scanner;
    }

    private void getNums(int n, int[] nArray) {
        int n2;
        nArray[1] = this.scanner.getIndentNumber(n, this.indentChar);
        nArray[0] = this.scanner.getIndentNumber(n - 1, this.indentChar);
        if (!this.isPsychoRigid && (n2 = nArray[1] - nArray[0]) > 0) {
            this.num = n2;
        }
    }
}

