/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.history_browser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.flexdock.view.View;
import org.scilab.modules.commons.gui.ScilabGUIUtilities;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.messagebox.ScilabMessageBox;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.AbstractScilabTabFactory;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ScilabToolBar;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.history_browser.CommandHistoryMessages;
import org.scilab.modules.history_browser.CommandHistoryMouseListener;
import org.scilab.modules.history_browser.CommandHistoryTabFactory;
import org.scilab.modules.history_browser.actions.ClearAction;
import org.scilab.modules.history_browser.actions.CloseAction;
import org.scilab.modules.history_browser.actions.CopyAction;
import org.scilab.modules.history_browser.actions.CutAction;
import org.scilab.modules.history_browser.actions.DeleteAction;
import org.scilab.modules.history_browser.actions.EditInScinotesAction;
import org.scilab.modules.history_browser.actions.EvaluateAction;
import org.scilab.modules.history_browser.actions.HelpAction;
import org.scilab.modules.history_browser.actions.PrefsAction;
import org.scilab.modules.history_manager.HistoryManagement;
import org.scilab.modules.localization.Messages;

public final class CommandHistory
extends SwingScilabDockablePanel
implements SimpleTab {
    public static final String COMMANDHISTORYUUID = "856207f6-0a60-47a0-b9f4-232feedd4bf4";
    private static final int DEFAULT_WIDTH = 450;
    private static final int DEFAULT_HEIGHT = 550;
    private static final String NEWLINE = "\n";
    private static final String SESSION_BEGINNING = "// -- ";
    private static final String SESSION_ENDING = " -- //";
    private static HistoryTree scilabHistoryTree;
    private static DefaultMutableTreeNode scilabHistoryRootNode;
    private static DefaultMutableTreeNode currentSessionNode;
    private static DefaultTreeModel scilabHistoryTreeModel;
    private static SwingScilabDockablePanel browserTab;
    private static JScrollPane scrollPane;
    private static boolean modelLoaded;
    private static boolean initialized;
    private static List<String> linesToAppend;
    private static Timer linesToAppendTimer;

    private CommandHistory() {
        super(CommandHistoryMessages.TITLE, COMMANDHISTORYUUID);
        this.setAssociatedXMLIDForHelp("browsehistory");
        CommandHistory.initialize();
        this.addMenuBar(CommandHistory.createMenuBar());
        this.addToolBar(CommandHistory.createToolBar());
        this.addInfoBar(ScilabTextBox.createTextBox());
        scilabHistoryTree.addMouseListener(new CommandHistoryMouseListener());
        DeleteAction.registerKeyAction();
        EvaluateAction.registerKeyAction();
        CopyAction.registerKeyAction();
        CutAction.registerKeyAction();
        CloseAction.registerKeyAction();
        scrollPane = new JScrollPane(scilabHistoryTree);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(scrollPane);
        this.setContentPane(jPanel);
    }

    public static void initialize() {
        if (!initialized) {
            scilabHistoryRootNode = new DefaultMutableTreeNode(Messages.gettext((String)"History loading in progress..."));
            scilabHistoryTreeModel = new DefaultTreeModel(scilabHistoryRootNode);
            scilabHistoryTree = new HistoryTree(scilabHistoryTreeModel);
            scilabHistoryTree.setShowsRootHandles(true);
            scilabHistoryTree.setDragEnabled(true);
            scilabHistoryTree.setEnabled(true);
            scilabHistoryTree.setRootVisible(false);
            scilabHistoryTree.setScrollsOnExpand(true);
            scilabHistoryTree.setVisible(false);
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)scilabHistoryTree.getCellRenderer();
            defaultTreeCellRenderer.setLeafIcon(null);
            defaultTreeCellRenderer.setClosedIcon(null);
            defaultTreeCellRenderer.setOpenIcon(null);
            initialized = true;
        }
    }

    public static SwingScilabDockablePanel createCommandHistoryTab() {
        browserTab = new CommandHistory();
        WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)browserTab);
        return browserTab;
    }

    public void addInfoBar(TextBox textBox) {
        this.setInfoBar(textBox);
    }

    public void addMenuBar(MenuBar menuBar) {
        this.setMenuBar(menuBar);
    }

    public void addToolBar(ToolBar toolBar) {
        this.setToolBar(toolBar);
    }

    public SwingScilabWindow getParentWindow() {
        return (SwingScilabWindow)SwingScilabWindow.allScilabWindows.get(this.getParentWindowId());
    }

    public SimpleTab getAsSimpleTab() {
        return this;
    }

    public static void loadFromFile() {
        final String[] stringArray = HistoryManagement.getAllLinesOfScilabHistory();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommandHistory.reset();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    CommandHistory.appendLineAndExpand(stringArray[i], false);
                }
            }
        });
        CommandHistory.expandAll();
    }

    public static void expandAll() {
        if (CommandHistory.isHistoryVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    scilabHistoryTree.setVisible(true);
                    if (!modelLoaded) {
                        scilabHistoryTreeModel.nodeStructureChanged((TreeNode)scilabHistoryTreeModel.getRoot());
                        modelLoaded = true;
                    }
                    Object object = scilabHistoryTreeModel.getRoot();
                    TreePath treePath = new TreePath(object);
                    int n = scilabHistoryTreeModel.getChildCount(object);
                    CommandHistory.scilabHistoryTree.mustFire = false;
                    for (int i = 0; i < n; ++i) {
                        Object object2 = scilabHistoryTreeModel.getChild(object, i);
                        if (scilabHistoryTreeModel.isLeaf(object2)) continue;
                        scilabHistoryTree.expandPath(treePath.pathByAddingChild(object2));
                    }
                    CommandHistory.scilabHistoryTree.mustFire = true;
                    scilabHistoryTree.fireTreeExpanded(treePath);
                    CommandHistory.scrollAtBottom();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendLine(String string) {
        List<String> list = linesToAppend;
        synchronized (list) {
            linesToAppend.add(string);
            linesToAppendTimer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendLinesOnEDT() {
        List<String> list = linesToAppend;
        synchronized (list) {
            for (String string : linesToAppend) {
                CommandHistory.appendLineAndExpand(string, true);
            }
            linesToAppend.clear();
        }
    }

    private static boolean isBeginSessionLine(String string) {
        return string.startsWith(SESSION_BEGINNING) && string.endsWith(SESSION_ENDING);
    }

    public static void appendLineAndExpand(String string, boolean bl) {
        if (CommandHistory.isBeginSessionLine(string)) {
            currentSessionNode = new DefaultMutableTreeNode(new SessionString(string));
            scilabHistoryTreeModel.insertNodeInto(currentSessionNode, scilabHistoryRootNode, scilabHistoryRootNode.getChildCount());
            if (bl && CommandHistory.isHistoryVisible()) {
                scilabHistoryTree.expandRow(scilabHistoryTree.getRowCount() - 1);
                scilabHistoryTree.scrollPathToVisible(new TreePath(currentSessionNode.getPath()));
            }
        } else {
            Serializable serializable;
            boolean bl2 = false;
            if (bl && CommandHistory.isHistoryVisible() && (serializable = scrollPane.getVerticalScrollBar()) != null) {
                BoundedRangeModel boundedRangeModel = ((JScrollBar)serializable).getModel();
                bl2 = boundedRangeModel.getValue() == boundedRangeModel.getMaximum() - boundedRangeModel.getExtent();
            }
            serializable = new DefaultMutableTreeNode(string);
            scilabHistoryTreeModel.insertNodeInto((MutableTreeNode)((Object)serializable), currentSessionNode, currentSessionNode.getChildCount());
            if (bl && CommandHistory.isHistoryVisible()) {
                scilabHistoryTree.expandRow(scilabHistoryTree.getRowCount() - 1);
                if (bl2) {
                    scilabHistoryTree.scrollPathToVisible(new TreePath(((DefaultMutableTreeNode)serializable).getPath()));
                }
            }
        }
    }

    public static void reset() {
        scilabHistoryRootNode.removeAllChildren();
        scilabHistoryTreeModel.reload();
        currentSessionNode = null;
    }

    public static void deleteLine(int n) {
        int n2 = scilabHistoryRootNode.getChildCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            TreeNode treeNode;
            if (n3 == n) {
                if (i == n2 - 1) {
                    treeNode = ScilabMessageBox.createMessageBox();
                    treeNode.setTitle(CommandHistoryMessages.ERROR);
                    treeNode.setMessage(CommandHistoryMessages.CANNOT_DELETE_CURRENT_SESSION_NODE);
                    treeNode.setIcon("error");
                    treeNode.displayAndWait();
                    return;
                }
                treeNode = scilabHistoryRootNode.getChildAt(i);
                scilabHistoryRootNode.remove(i);
                scilabHistoryTreeModel.nodesWereRemoved(scilabHistoryRootNode, new int[]{i}, new Object[]{treeNode});
                break;
            }
            treeNode = (DefaultMutableTreeNode)scilabHistoryRootNode.getChildAt(i);
            if (n3 + ((DefaultMutableTreeNode)treeNode).getChildCount() >= n) {
                int n4 = n - n3 - 1;
                TreeNode treeNode2 = ((DefaultMutableTreeNode)treeNode).getChildAt(n4);
                ((DefaultMutableTreeNode)treeNode).remove(n4);
                scilabHistoryTreeModel.nodesWereRemoved(treeNode, new int[]{n4}, new Object[]{treeNode2});
                break;
            }
            n3 += ((DefaultMutableTreeNode)treeNode).getChildCount() + 1;
        }
    }

    public static void closeHistory() {
        browserTab = null;
    }

    public static SwingScilabDockablePanel getBrowserTab() {
        return browserTab;
    }

    public static void setVisible() {
        if (browserTab == null) {
            boolean bl = WindowsConfigurationManager.restoreUUID((String)COMMANDHISTORYUUID);
            if (!bl) {
                CommandHistoryTabFactory.getInstance().getTab(COMMANDHISTORYUUID);
                SwingScilabWindow swingScilabWindow = SwingScilabWindow.createWindow((boolean)true);
                swingScilabWindow.addTab((SwingScilabPanel)browserTab);
                swingScilabWindow.setLocation(0, 0);
                swingScilabWindow.setSize(500, 500);
                swingScilabWindow.setVisible(true);
            }
        } else {
            int n;
            SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)browserTab);
            if (swingScilabWindow != null && ((n = swingScilabWindow.getExtendedState()) & 1) == 1) {
                swingScilabWindow.setExtendedState(n - 1);
            }
        }
        ScilabGUIUtilities.toFront((View)browserTab, (String)CommandHistoryMessages.TITLE);
        browserTab.setVisible(true);
        CommandHistory.expandAll();
    }

    public static void launchHistoryBrowser() {
        CommandHistory.setVisible();
    }

    private static boolean isHistoryVisible() {
        return browserTab != null && browserTab.isVisible();
    }

    private static MenuBar createMenuBar() {
        MenuBar menuBar = ScilabMenuBar.createMenuBar();
        Menu menu = ScilabMenu.createMenu();
        menu.setText(CommandHistoryMessages.FILE);
        menu.setMnemonic(70);
        menu.add(CloseAction.createMenuItem());
        menuBar.add(menu);
        Menu menu2 = ScilabMenu.createMenu();
        menu2.setText(CommandHistoryMessages.EDIT);
        menu2.setMnemonic(69);
        menu2.add(CopyAction.createMenuItem());
        menu2.add(CutAction.createMenuItem());
        menu2.add(EvaluateAction.createMenuItem());
        menu2.add(EditInScinotesAction.createMenuItem());
        menu2.addSeparator();
        menu2.add(DeleteAction.createMenuItem());
        menu2.add(ClearAction.createMenuItem());
        menuBar.add(menu2);
        Menu menu3 = ScilabMenu.createMenu();
        menu3.setText(CommandHistoryMessages.HELP);
        menu3.setMnemonic(63);
        menu3.add(HelpAction.createMenuItem());
        menuBar.add(menu3);
        return menuBar;
    }

    private static ToolBar createToolBar() {
        ToolBar toolBar = ScilabToolBar.createToolBar();
        SwingScilabToolBar swingScilabToolBar = (SwingScilabToolBar)toolBar.getAsSimpleToolBar();
        swingScilabToolBar.add((Component)CopyAction.createPushButton());
        swingScilabToolBar.add((Component)CutAction.createPushButton());
        swingScilabToolBar.add((Component)DeleteAction.createPushButton());
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)PrefsAction.createPushButton());
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)HelpAction.createPushButton());
        return toolBar;
    }

    public static JTree getTree() {
        return scilabHistoryTree;
    }

    public static DefaultTreeModel getTreeModel() {
        return scilabHistoryTreeModel;
    }

    public static String getSelectedCommands() {
        TreePath[] treePathArray = CommandHistory.getTree().getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        Object object = "";
        for (int i = 0; i < treePathArray.length; ++i) {
            Object object2 = ((DefaultMutableTreeNode)treePathArray[i].getLastPathComponent()).getUserObject();
            object = (String)object + object2.toString();
            if (i >= treePathArray.length - 1) continue;
            object = (String)object + NEWLINE;
        }
        return object;
    }

    private static void scrollAtBottom() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                scrollPane.getHorizontalScrollBar().setValue(0);
                scrollPane.getVerticalScrollBar().setValue(scrollPane.getVerticalScrollBar().getMaximum());
            }
        });
    }

    static {
        ScilabTabFactory.getInstance().addTabFactory((AbstractScilabTabFactory)CommandHistoryTabFactory.getInstance());
        linesToAppend = Collections.synchronizedList(new ArrayList());
        linesToAppendTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandHistory.appendLinesOnEDT();
            }
        });
        linesToAppendTimer.setRepeats(false);
    }

    static class HistoryTree
    extends JTree {
        private boolean first = true;
        private Color defaultColor;
        private Color sessionColor = new Color(1, 168, 1);
        boolean mustFire = true;

        HistoryTree(TreeModel treeModel) {
            super(treeModel);
            this.setRowHeight(16);
            this.setLargeModel(true);
            this.setCellRenderer(new DefaultTreeCellRenderer(){
                {
                    defaultColor = this.getTextNonSelectionColor();
                }

                @Override
                public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                    super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                    if (((DefaultMutableTreeNode)object).getUserObject() instanceof SessionString) {
                        this.setTextNonSelectionColor(sessionColor);
                    } else {
                        this.setTextNonSelectionColor(defaultColor);
                    }
                    return this;
                }
            });
        }

        @Override
        public void fireTreeExpanded(TreePath treePath) {
            if (this.mustFire) {
                super.fireTreeExpanded(treePath);
            }
        }

        @Override
        public void fireTreeWillExpand(TreePath treePath) throws ExpandVetoException {
            if (this.mustFire) {
                super.fireTreeWillExpand(treePath);
            }
        }

        @Override
        public void paint(final Graphics graphics) {
            if (this.first) {
                graphics.setFont(this.getFont());
                int n = graphics.getFontMetrics().getHeight();
                this.setRowHeight(n);
                this.setLargeModel(true);
                this.first = false;
                scrollPane.getVerticalScrollBar().setUnitIncrement(n);
                CommandHistory.scrollAtBottom();
            }
            try {
                super.paint(graphics);
            }
            catch (Exception exception) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.paint(graphics);
                    }
                });
            }
        }
    }

    static class SessionString {
        String s;

        SessionString(String string) {
            this.s = string;
        }

        public String toString() {
            return this.s;
        }
    }
}

