/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor.actions;

import javax.swing.Action;
import javax.swing.JTable;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.commons.gui.ScilabKeyStroke;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.gui.messagebox.MessageBox;
import org.scilab.modules.gui.messagebox.ScilabMessageBox;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.types.ScilabTypeEnum;
import org.scilab.modules.ui_data.datatable.SwingEditvarTableModel;
import org.scilab.modules.ui_data.variablebrowser.SwingScilabVariableBrowser;
import org.scilab.modules.ui_data.variableeditor.SwingScilabVariableEditor;

public final class ExportToCsvAction
extends CommonCallBack {
    private static final String KEY = "OSSCKEY S";
    private static final String CREATE = "Export to CSV";
    private static final int GAP = 5;
    private final SwingScilabDockablePanel editor;

    public ExportToCsvAction(SwingScilabDockablePanel swingScilabDockablePanel, String string) {
        super(string);
        this.editor = swingScilabDockablePanel;
    }

    public static void registerAction(SwingScilabDockablePanel swingScilabDockablePanel, JTable jTable) {
        jTable.getActionMap().put(CREATE, (Action)((Object)new ExportToCsvAction(swingScilabDockablePanel, CREATE)));
        jTable.getInputMap().put(ScilabKeyStroke.getKeyStroke((String)KEY), CREATE);
    }

    public void callBack() {
        String string = "__export__csv__=uiputfile('*.csv');if __export__csv__<>'' then csvWrite(%s, __export__csv__); end; clear __export__csv__";
        if (this.editor instanceof SwingScilabVariableEditor) {
            JTable jTable = ((SwingScilabVariableEditor)this.editor).getCurrentTable();
            SwingEditvarTableModel swingEditvarTableModel = (SwingEditvarTableModel)jTable.getModel();
            swingEditvarTableModel.execCommand(String.format(string, swingEditvarTableModel.getVarName()));
        } else {
            int n = ((SwingScilabVariableBrowser)this.editor).getTable().getSelectedRow();
            if (n != -1) {
                String string2 = ((SwingScilabVariableBrowser)this.editor).getTable().getValueAt(n, 1).toString();
                int n2 = ((SwingScilabVariableBrowser)this.editor).getTable().convertRowIndexToModel(n);
                int n3 = Integer.parseInt(((SwingScilabVariableBrowser)this.editor).getTable().getModel().getValueAt(n2, 7).toString());
                try {
                    if (n3 == ScilabTypeEnum.sci_matrix.swigValue() || n3 == ScilabTypeEnum.sci_strings.swigValue()) {
                        ScilabInterpreterManagement.asynchronousScilabExec(null, (String)String.format(string, string2));
                    } else {
                        MessageBox messageBox = ScilabMessageBox.createMessageBox();
                        messageBox.setTitle(Messages.gettext((String)"Error"));
                        messageBox.setMessage(Messages.gettext((String)"Type not supported for this operation"));
                        messageBox.setIcon("error");
                        messageBox.displayAndWait();
                    }
                }
                catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
                    System.err.println("An error in the interpreter has been catched: " + interpreterException.getLocalizedMessage());
                }
            }
        }
    }

    public static MenuItem createMenuItem(SwingScilabDockablePanel swingScilabDockablePanel, String string) {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback((CommonCallBack)new ExportToCsvAction(swingScilabDockablePanel, string));
        menuItem.setText(string);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setAccelerator(ScilabKeyStroke.getKeyStroke((String)KEY));
        return menuItem;
    }

    public static SwingScilabMenuItem createJMenuItem(SwingScilabDockablePanel swingScilabDockablePanel, String string) {
        return (SwingScilabMenuItem)ExportToCsvAction.createMenuItem(swingScilabDockablePanel, string).getAsSimpleMenuItem();
    }
}

