/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabKeyStroke;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.ui_data.UI_data;
import org.scilab.modules.ui_data.datatable.SwingEditvarTableModel;
import org.scilab.modules.ui_data.utils.UiDataMessages;
import org.scilab.modules.ui_data.variableeditor.SwingScilabVariableEditor;

public final class CreateVariableFromSelectionAction
extends CommonCallBack {
    private static final String KEY = "OSSCKEY K";
    private static final String CREATE = "Create";
    private static final int GAP = 5;
    private final SwingScilabVariableEditor editor;

    private CreateVariableFromSelectionAction(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        super(string);
        this.editor = swingScilabVariableEditor;
    }

    public static void registerAction(SwingScilabVariableEditor swingScilabVariableEditor, JTable jTable) {
        jTable.getActionMap().put(CREATE, (Action)((Object)new CreateVariableFromSelectionAction(swingScilabVariableEditor, CREATE)));
        jTable.getInputMap().put(ScilabKeyStroke.getKeyStroke((String)KEY), CREATE);
    }

    public void callBack() {
        String string;
        JTable jTable = this.editor.getCurrentTable();
        int[] nArray = jTable.getSelectedColumns();
        int[] nArray2 = jTable.getSelectedRows();
        if (nArray.length > 0 && nArray2.length > 0 && !(string = this.askForName()).isEmpty()) {
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            SwingEditvarTableModel swingEditvarTableModel = (SwingEditvarTableModel)jTable.getModel();
            String string2 = swingEditvarTableModel.getScilabSubMatrix(nArray2, nArray, nArray3, nArray4);
            swingEditvarTableModel.execCommand(string + "=" + string2 + ";editvar(\"" + string + "\")");
        }
    }

    public String askForName() {
        final JDialog jDialog = new JDialog();
        final String[] stringArray = new String[]{""};
        jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        jDialog.setDefaultCloseOperation(2);
        jDialog.setIconImage(new ImageIcon(FindIconHelper.findIcon((String)"rrze_table", (String)"256x256")).getImage());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(UiDataMessages.VARNAME);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        final JTextField jTextField = new JTextField(25);
        jTextField.setText(UI_data.getUnnamedVariable());
        jTextField.selectAll();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jTextField, gridBagConstraints);
        JButton jButton = new JButton(UiDataMessages.CANCEL);
        JButton jButton2 = new JButton(UiDataMessages.OK);
        JPanel jPanel2 = new JPanel();
        jButton2.setPreferredSize(jButton.getPreferredSize());
        jPanel2.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jDialog.setContentPane(jPanel);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                stringArray[0] = jTextField.getText();
            }
        });
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    jDialog.dispose();
                    stringArray[0] = jTextField.getText();
                } else if (n == 27) {
                    jDialog.dispose();
                }
            }
        });
        jDialog.setTitle(UiDataMessages.CREATEVAR);
        jDialog.pack();
        jDialog.setResizable(false);
        jDialog.setLocationRelativeTo((Component)((Object)this.editor));
        jDialog.setVisible(true);
        return stringArray[0];
    }

    public static JButton createButton(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        JButton jButton = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)jButton);
        jButton.addActionListener((ActionListener)((Object)new CreateVariableFromSelectionAction(swingScilabVariableEditor, string)));
        jButton.setToolTipText(string);
        ImageIcon imageIcon = new ImageIcon(FindIconHelper.findIcon((String)"variable-from-selection"));
        jButton.setIcon(imageIcon);
        return jButton;
    }

    public static MenuItem createMenuItem(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback((CommonCallBack)new CreateVariableFromSelectionAction(swingScilabVariableEditor, string));
        menuItem.setText(string);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setAccelerator(ScilabKeyStroke.getKeyStroke((String)KEY));
        return menuItem;
    }

    public static SwingScilabMenuItem createJMenuItem(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        return (SwingScilabMenuItem)CreateVariableFromSelectionAction.createMenuItem(swingScilabVariableEditor, string).getAsSimpleMenuItem();
    }
}

